/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileManipulator {
    private static final Log log = LogFactory.getLog(FileManipulator.class);

    public static boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String child : children) {
                boolean success = FileManipulator.deleteDir(new File(dir, child));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void copyDir(File srcDir, File dstDir) throws IOException {
        if (srcDir.isDirectory()) {
            String[] children;
            if (!dstDir.exists() && !dstDir.mkdir()) {
                throw new IOException("Fail to create the directory: " + dstDir.getAbsolutePath());
            }
            for (String aChildren : children = srcDir.list()) {
                FileManipulator.copyDir(new File(srcDir, aChildren), new File(dstDir, aChildren));
            }
        } else {
            FileManipulator.copyFile(srcDir, dstDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(dst);
            byte[] buf = new byte[10240];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close the InputStream " + e.getMessage()), (Throwable)e);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("Unable to close the OutputStream " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void copyFileToDir(File src, File dst) throws IOException {
        String dstAbsPath = dst.getAbsolutePath();
        String dstDir = dstAbsPath.substring(0, dstAbsPath.lastIndexOf(File.separator));
        File dir = new File(dstDir);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Fail to create the directory: " + dir.getAbsolutePath());
        }
        File file = new File(dstAbsPath + File.separator + src.getName());
        FileManipulator.copyFile(src, file);
    }

    public static File[] getMatchingFiles(String sourceDir, String fileNamePrefix, String extension) {
        ArrayList<File> fileList = new ArrayList<File>();
        File libDir = new File(sourceDir);
        String libDirPath = libDir.getAbsolutePath();
        String[] items = libDir.list();
        if (items != null) {
            for (String item : items) {
                if (fileNamePrefix != null && extension != null) {
                    if (!item.startsWith(fileNamePrefix) || !item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix == null && extension != null) {
                    if (!item.endsWith(extension)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                if (fileNamePrefix != null) {
                    if (!item.startsWith(fileNamePrefix)) continue;
                    fileList.add(new File(libDirPath + File.separator + item));
                    continue;
                }
                fileList.add(new File(libDirPath + File.separator + item));
            }
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }

    public static void deleteDir(String directory) {
        FileManipulator.deleteDir(new File(directory));
    }
}

