/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.loader.xml;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import org.dozer.classmap.MappingFileData;
import org.dozer.loader.MappingsSource;
import org.dozer.loader.xml.XMLParser;
import org.dozer.loader.xml.XMLParserFactory;
import org.dozer.util.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingStreamReader
implements MappingsSource<InputStream> {
    private static final Logger log = LoggerFactory.getLogger(MappingStreamReader.class);
    private final DocumentBuilder documentBuilder;
    private final MappingsSource<Document> parser;

    public MappingStreamReader(XMLParserFactory parserFactory) {
        this.documentBuilder = parserFactory.createParser();
        this.parser = new XMLParser();
    }

    @Override
    public MappingFileData read(InputStream xmlStream) {
        MappingFileData result = null;
        try {
            Document document = this.documentBuilder.parse(xmlStream);
            result = this.parser.read(document);
        }
        catch (Throwable e) {
            log.error("Error while loading dozer mapping InputStream: [" + xmlStream + "]", e);
            MappingUtils.throwMappingException(e);
        }
        return result;
    }
}

