/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.logging.MDCUtil;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.gfac.core.GFacUtils;
import org.apache.airavata.gfac.core.scheduler.HostScheduler;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.MessagingFactory;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.Subscriber;
import org.apache.airavata.messaging.core.Type;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.replica.DataProductModel;
import org.apache.airavata.model.data.replica.DataReplicaLocationModel;
import org.apache.airavata.model.data.replica.ReplicaLocationCategory;
import org.apache.airavata.model.error.LaunchValidationException;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.experiment.ExperimentType;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.ExperimentSubmitEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessIdentifier;
import org.apache.airavata.model.messaging.event.ProcessStatusChangeEvent;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.status.ExperimentState;
import org.apache.airavata.model.status.ExperimentStatus;
import org.apache.airavata.orchestrator.core.exception.OrchestratorException;
import org.apache.airavata.orchestrator.cpi.OrchestratorService;
import org.apache.airavata.orchestrator.cpi.impl.SimpleOrchestratorImpl;
import org.apache.airavata.orchestrator.util.OrchestratorServerThreadPoolExecutor;
import org.apache.airavata.orchestrator.util.OrchestratorUtils;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ComputeResource;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.ReplicaCatalog;
import org.apache.airavata.registry.cpi.ReplicaCatalogException;
import org.apache.commons.lang.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.ZKPaths;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class OrchestratorServerHandler
implements OrchestratorService.Iface {
    private static Logger log = LoggerFactory.getLogger(OrchestratorServerHandler.class);
    private SimpleOrchestratorImpl orchestrator = null;
    private ExperimentCatalog experimentCatalog;
    private AppCatalog appCatalog;
    private static Integer mutex = new Integer(-1);
    private String airavataUserName;
    private String gatewayName;
    private Publisher publisher;
    private final Subscriber statusSubscribe;
    private final Subscriber experimentSubscriber;
    private CuratorFramework curatorClient;

    public String getOrchestratorCPIVersion() throws TException {
        return "0.16.0";
    }

    public OrchestratorServerHandler() throws OrchestratorException {
        try {
            this.setAiravataUserName(ServerSettings.getDefaultUser());
            this.orchestrator = new SimpleOrchestratorImpl();
            this.experimentCatalog = RegistryFactory.getDefaultExpCatalog();
            this.appCatalog = RegistryFactory.getAppCatalog();
            this.publisher = MessagingFactory.getPublisher((Type)Type.STATUS);
            this.orchestrator.initialize();
            this.orchestrator.getOrchestratorContext().setPublisher(this.publisher);
            this.statusSubscribe = this.getStatusSubscriber();
            this.experimentSubscriber = this.getExperimentSubscriber();
            this.startCurator();
        }
        catch (AiravataException | OrchestratorException | AppCatalogException | RegistryException e) {
            log.error(e.getMessage(), e);
            throw new OrchestratorException("Error while initializing orchestrator service", e);
        }
    }

    private Subscriber getStatusSubscriber() throws AiravataException {
        ArrayList<String> routingKeys = new ArrayList<String>();
        routingKeys.add("*.*.*");
        return MessagingFactory.getSubscriber((MessageHandler)new ProcessStatusHandler(), routingKeys, (Type)Type.STATUS);
    }

    private Subscriber getExperimentSubscriber() throws AiravataException {
        ArrayList<String> routingKeys = new ArrayList<String>();
        routingKeys.add(ServerSettings.getRabbitmqExperimentLaunchQueueName());
        return MessagingFactory.getSubscriber((MessageHandler)new ExperimentHandler(), routingKeys, (Type)Type.EXPERIMENT_LAUNCH);
    }

    public boolean launchExperiment(String experimentId, String gatewayId) throws TException {
        block10: {
            ExperimentModel experiment = null;
            try {
                String experimentNodePath = GFacUtils.getExperimentNodePath((String)experimentId);
                ZKPaths.mkdirs((ZooKeeper)this.curatorClient.getZookeeperClient().getZooKeeper(), (String)experimentNodePath);
                String experimentCancelNode = ZKPaths.makePath((String)experimentNodePath, (String)"/cancelListener");
                ZKPaths.mkdirs((ZooKeeper)this.curatorClient.getZookeeperClient().getZooKeeper(), (String)experimentCancelNode);
                experiment = (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
                if (experiment == null) {
                    log.error("Error retrieving the Experiment by the given experimentID: {} ", (Object)experimentId);
                    return false;
                }
                ComputeResourcePreference computeResourcePreference = this.appCatalog.getGatewayProfile().getComputeResourcePreference(gatewayId, experiment.getUserConfigurationData().getComputationalResourceScheduling().getResourceHostId());
                String token = computeResourcePreference.getResourceSpecificCredentialStoreToken();
                if (token == null || token.isEmpty()) {
                    GatewayResourceProfile gatewayProfile = this.appCatalog.getGatewayProfile().getGatewayProfile(gatewayId);
                    token = gatewayProfile.getCredentialStoreToken();
                }
                if (token == null || token.isEmpty()) {
                    log.error("You have not configured credential store token at gateway profile or compute resource preference. Please provide the correct token at gateway profile or compute resource preference.");
                    return false;
                }
                ExperimentType executionType = experiment.getExperimentType();
                if (executionType == ExperimentType.SINGLE_APPLICATION) {
                    List processes = this.orchestrator.createProcesses(experimentId, gatewayId);
                    for (ProcessModel processModel : processes) {
                        ReplicaCatalog replicaCatalog = RegistryFactory.getReplicaCatalog();
                        processModel.getProcessInputs().stream().forEach(pi -> {
                            block11: {
                                if (pi.getType().equals((Object)DataType.URI) && pi.getValue().startsWith("airavata-dp://")) {
                                    try {
                                        DataProductModel dataProductModel = replicaCatalog.getDataProduct(pi.getValue());
                                        Optional<DataReplicaLocationModel> rpLocation = dataProductModel.getReplicaLocations().stream().filter(rpModel -> rpModel.getReplicaLocationCategory().equals((Object)ReplicaLocationCategory.GATEWAY_DATA_STORE)).findFirst();
                                        if (rpLocation.isPresent()) {
                                            pi.setValue(rpLocation.get().getFilePath());
                                            pi.setStorageResourceId(rpLocation.get().getStorageResourceId());
                                            break block11;
                                        }
                                        log.error("Could not find a replica for the URI " + pi.getValue());
                                    }
                                    catch (ReplicaCatalogException e) {
                                        log.error(e.getMessage(), (Throwable)e);
                                    }
                                } else if (pi.getType().equals((Object)DataType.URI_COLLECTION) && pi.getValue().contains("airavata-dp://")) {
                                    try {
                                        String[] uriList = pi.getValue().split(",");
                                        ArrayList<String> filePathList = new ArrayList<String>();
                                        for (String uri : uriList) {
                                            if (uri.startsWith("airavata-dp://")) {
                                                DataProductModel dataProductModel = replicaCatalog.getDataProduct(uri);
                                                Optional<DataReplicaLocationModel> rpLocation = dataProductModel.getReplicaLocations().stream().filter(rpModel -> rpModel.getReplicaLocationCategory().equals((Object)ReplicaLocationCategory.GATEWAY_DATA_STORE)).findFirst();
                                                if (rpLocation.isPresent()) {
                                                    filePathList.add(rpLocation.get().getFilePath());
                                                    continue;
                                                }
                                                log.error("Could not find a replica for the URI " + pi.getValue());
                                                continue;
                                            }
                                            filePathList.add(uri);
                                        }
                                        pi.setValue(StringUtils.join(filePathList, (char)','));
                                    }
                                    catch (ReplicaCatalogException e) {
                                        log.error(e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                        });
                        String taskDag = this.orchestrator.createAndSaveTasks(gatewayId, processModel, experiment.getUserConfigurationData().isAiravataAutoSchedule());
                        processModel.setTaskDag(taskDag);
                        this.experimentCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processModel.getProcessId());
                    }
                    if (!this.validateProcess(experimentId, processes)) {
                        log.error("Validating process fails for given experiment Id : {}", (Object)experimentId);
                        return false;
                    }
                    log.debug(experimentId, (Object)"Launching single application experiment {}.", (Object)experimentId);
                    ExperimentStatus status = new ExperimentStatus(ExperimentState.LAUNCHED);
                    status.setReason("submitted all processes");
                    status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                    OrchestratorUtils.updageAndPublishExperimentStatus(experimentId, status, this.publisher, gatewayId);
                    log.info("expId: {}, Launched experiment ", (Object)experimentId);
                    OrchestratorServerThreadPoolExecutor.getCachedThreadPool().execute(MDCUtil.wrapWithMDC((Runnable)new SingleAppExperimentRunner(experimentId, token, gatewayId)));
                    break block10;
                }
                if (executionType == ExperimentType.WORKFLOW) {
                    log.debug(experimentId, (Object)"Launching workflow experiment {}.", (Object)experimentId);
                    this.launchWorkflowExperiment(experimentId, token, gatewayId);
                    break block10;
                }
                log.error(experimentId, (Object)"Couldn't identify experiment type, experiment {} is neither single application nor workflow.", (Object)experimentId);
                throw new TException("Experiment '" + experimentId + "' launch failed. Unable to figureout execution type for application " + experiment.getExecutionId());
            }
            catch (LaunchValidationException launchValidationException) {
                ExperimentStatus status = new ExperimentStatus(ExperimentState.FAILED);
                status.setReason("Validation failed: " + launchValidationException.getErrorMessage());
                status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                OrchestratorUtils.updageAndPublishExperimentStatus(experimentId, status, this.publisher, gatewayId);
                throw new TException("Experiment '" + experimentId + "' launch failed. Experiment failed to validate: " + launchValidationException.getErrorMessage(), (Throwable)launchValidationException);
            }
            catch (Exception e) {
                throw new TException("Experiment '" + experimentId + "' launch failed. Unable to figureout execution type for application " + experiment.getExecutionId(), (Throwable)e);
            }
        }
        return true;
    }

    public boolean validateExperiment(String experimentId) throws TException, LaunchValidationException {
        try {
            ExperimentModel experimentModel = (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            return this.orchestrator.validateExperiment(experimentModel).isValidationState();
        }
        catch (OrchestratorException e) {
            log.error(experimentId, (Object)"Error while validating experiment", (Object)e);
            throw new TException((Throwable)e);
        }
        catch (RegistryException e) {
            log.error(experimentId, (Object)"Error while validating experiment", (Object)e);
            throw new TException((Throwable)e);
        }
    }

    public boolean validateProcess(String experimentId, List<ProcessModel> processes) throws LaunchValidationException, TException {
        try {
            ExperimentModel experimentModel = (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            for (ProcessModel processModel : processes) {
                boolean state = this.orchestrator.validateProcess(experimentModel, processModel).isSetValidationState();
                if (state) continue;
                return false;
            }
            return true;
        }
        catch (LaunchValidationException lve) {
            ErrorModel details = new ErrorModel();
            details.setActualErrorMessage(lve.getErrorMessage());
            details.setCreationTime(Calendar.getInstance().getTimeInMillis());
            try {
                this.experimentCatalog.add(ExpCatChildDataType.EXPERIMENT_ERROR, (Object)details, (Object)experimentId);
            }
            catch (RegistryException e) {
                log.error("Failed to add EXPERIMENT_ERROR regarding LaunchValidationException to experiment " + experimentId, (Throwable)e);
            }
            throw lve;
        }
        catch (OrchestratorException e) {
            log.error(experimentId, (Object)"Error while validating process", (Object)e);
            throw new TException((Throwable)e);
        }
        catch (RegistryException e) {
            log.error(experimentId, (Object)"Error while validating process", (Object)e);
            throw new TException((Throwable)e);
        }
    }

    public boolean terminateExperiment(String experimentId, String gatewayId) throws TException {
        log.info(experimentId, (Object)"Experiment: {} is cancelling  !!!!!", (Object)experimentId);
        try {
            return this.validateStatesAndCancel(experimentId, gatewayId);
        }
        catch (Exception e) {
            log.error("expId : " + experimentId + " :- Error while cancelling experiment", (Throwable)e);
            return false;
        }
    }

    private String getAiravataUserName() {
        return this.airavataUserName;
    }

    private String getGatewayName() {
        return this.gatewayName;
    }

    public void setAiravataUserName(String airavataUserName) {
        this.airavataUserName = airavataUserName;
    }

    public void setGatewayName(String gatewayName) {
        this.gatewayName = gatewayName;
    }

    public boolean launchProcess(String processId, String airavataCredStoreToken, String gatewayId) throws TException {
        try {
            ProcessModel processModel = (ProcessModel)this.experimentCatalog.get(ExperimentCatalogModelType.PROCESS, (Object)processId);
            String applicationId = processModel.getApplicationInterfaceId();
            if (applicationId == null) {
                log.error(processId, (Object)"Application interface id shouldn't be null.");
                throw new OrchestratorException("Error executing the job, application interface id shouldn't be null.");
            }
            ApplicationDeploymentDescription applicationDeploymentDescription = this.getAppDeployment(processModel, applicationId);
            processModel.setApplicationDeploymentId(applicationDeploymentDescription.getAppDeploymentId());
            processModel.setComputeResourceId(processModel.getProcessResourceSchedule().getResourceHostId());
            this.experimentCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processModel.getProcessId());
            return this.orchestrator.launchProcess(processModel, airavataCredStoreToken);
        }
        catch (Exception e) {
            log.error(processId, (Object)"Error while launching process ", (Object)e);
            throw new TException((Throwable)e);
        }
    }

    private ApplicationDeploymentDescription getAppDeployment(ProcessModel processModel, String applicationId) throws AppCatalogException, OrchestratorException, ClassNotFoundException, ApplicationSettingsException, InstantiationException, IllegalAccessException {
        String selectedModuleId = this.getModuleId(this.appCatalog, applicationId);
        return this.getAppDeploymentForModule(processModel, selectedModuleId);
    }

    private ApplicationDeploymentDescription getAppDeploymentForModule(ProcessModel processModel, String selectedModuleId) throws AppCatalogException, ClassNotFoundException, ApplicationSettingsException, InstantiationException, IllegalAccessException {
        HashMap<String, String> moduleIdFilter = new HashMap<String, String>();
        moduleIdFilter.put("appModuleID", selectedModuleId);
        if (processModel.getProcessResourceSchedule() != null && processModel.getProcessResourceSchedule().getResourceHostId() != null) {
            moduleIdFilter.put("hostID", processModel.getProcessResourceSchedule().getResourceHostId());
        }
        List applicationDeployements = this.appCatalog.getApplicationDeployment().getApplicationDeployements(moduleIdFilter);
        HashMap<ComputeResourceDescription, ApplicationDeploymentDescription> deploymentMap = new HashMap<ComputeResourceDescription, ApplicationDeploymentDescription>();
        ComputeResource computeResource = this.appCatalog.getComputeResource();
        for (ApplicationDeploymentDescription deploymentDescription : applicationDeployements) {
            deploymentMap.put(computeResource.getComputeResource(deploymentDescription.getComputeHostId()), deploymentDescription);
        }
        List<ComputeResourceDescription> computeHostList = Arrays.asList(deploymentMap.keySet().toArray(new ComputeResourceDescription[0]));
        Class<HostScheduler> aClass = Class.forName(ServerSettings.getHostScheduler()).asSubclass(HostScheduler.class);
        HostScheduler hostScheduler = aClass.newInstance();
        ComputeResourceDescription ComputeResourceDescription2 = hostScheduler.schedule(computeHostList);
        return (ApplicationDeploymentDescription)deploymentMap.get(ComputeResourceDescription2);
    }

    private String getModuleId(AppCatalog appCatalog, String applicationId) throws AppCatalogException, OrchestratorException {
        ApplicationInterfaceDescription applicationInterface = appCatalog.getApplicationInterface().getApplicationInterface(applicationId);
        List applicationModules = applicationInterface.getApplicationModules();
        if (applicationModules.size() == 0) {
            throw new OrchestratorException("No modules defined for application " + applicationId);
        }
        String selectedModuleId = (String)applicationModules.get(0);
        return selectedModuleId;
    }

    private boolean validateStatesAndCancel(String experimentId, String gatewayId) throws Exception {
        ExperimentStatus experimentStatus = OrchestratorUtils.getExperimentStatus(experimentId);
        switch (experimentStatus.getState()) {
            case COMPLETED: 
            case CANCELED: 
            case FAILED: 
            case CANCELING: {
                log.warn("Can't terminate already {} experiment", (Object)experimentStatus.getState().name());
                return false;
            }
            case CREATED: {
                log.warn("Experiment termination is only allowed for launched experiments.");
                return false;
            }
        }
        String expCancelNodePath = ZKPaths.makePath((String)ZKPaths.makePath((String)"/experiments", (String)experimentId), (String)"/cancelListener");
        Stat stat = (Stat)this.curatorClient.checkExists().forPath(expCancelNodePath);
        if (stat != null) {
            ((BackgroundPathAndBytesable)this.curatorClient.setData().withVersion(-1)).forPath(expCancelNodePath, "CANCEL_REQUEST".getBytes());
            ExperimentStatus status = new ExperimentStatus(ExperimentState.CANCELING);
            status.setReason("Experiment cancel request processed");
            status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            OrchestratorUtils.updageAndPublishExperimentStatus(experimentId, status, this.publisher, gatewayId);
            log.info("expId : " + experimentId + " :- Experiment status updated to " + status.getState());
            return true;
        }
        return false;
    }

    private void launchWorkflowExperiment(String experimentId, String airavataCredStoreToken, String gatewayId) throws TException {
    }

    private void startCurator() throws ApplicationSettingsException {
        String connectionSting = ServerSettings.getZookeeperConnection();
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 5);
        this.curatorClient = CuratorFrameworkFactory.newClient((String)connectionSting, (RetryPolicy)retryPolicy);
        this.curatorClient.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void launchExperiment(MessageContext messageContext) {
        ExperimentSubmitEvent expEvent = new ExperimentSubmitEvent();
        try {
            byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
            ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)expEvent);
            MDC.put((String)"experiment_id", (String)expEvent.getExperimentId());
            log.info("Launching experiment with experimentId: {} gateway Id: {}", (Object)expEvent.getExperimentId(), (Object)expEvent.getGatewayId());
            if (messageContext.isRedeliver()) {
                ExperimentModel experimentModel = (ExperimentModel)this.experimentCatalog.get(ExperimentCatalogModelType.EXPERIMENT, (Object)expEvent.getExperimentId());
                MDC.put((String)"experiment_name", (String)experimentModel.getExperimentName());
                if (((ExperimentStatus)experimentModel.getExperimentStatus().get(0)).getState() == ExperimentState.CREATED) {
                    this.launchExperiment(expEvent.getExperimentId(), expEvent.getGatewayId());
                }
            } else {
                this.launchExperiment(expEvent.getExperimentId(), expEvent.getGatewayId());
            }
        }
        catch (TException e) {
            String logMessage = expEvent.getExperimentId() != null && expEvent.getGatewayId() != null ? String.format("Experiment launch failed due to Thrift conversion error, experimentId: %s, gatewayId: %s", expEvent.getExperimentId(), expEvent.getGatewayId()) : "Experiment launch failed due to Thrift conversion error";
            log.error(logMessage, (Throwable)e);
        }
        catch (RegistryException e) {
            String logMessage = expEvent.getExperimentId() != null && expEvent.getGatewayId() != null ? String.format("Experiment launch failed due to registry access issue, experimentId: %s, gatewayId: %s", expEvent.getExperimentId(), expEvent.getGatewayId()) : "Experiment launch failed due to registry access issue";
            log.error(logMessage, (Throwable)e);
        }
        finally {
            this.experimentSubscriber.sendAck(messageContext.getDeliveryTag());
            MDC.clear();
        }
    }

    private class ExperimentHandler
    implements MessageHandler {
        private ExperimentHandler() {
        }

        public void onMessage(MessageContext messageContext) {
            MDC.put((String)"gateway_id", (String)messageContext.getGatewayId());
            switch (messageContext.getType()) {
                case EXPERIMENT: {
                    OrchestratorServerHandler.this.launchExperiment(messageContext);
                    break;
                }
                case EXPERIMENT_CANCEL: {
                    this.cancelExperiment(messageContext);
                    break;
                }
                default: {
                    OrchestratorServerHandler.this.experimentSubscriber.sendAck(messageContext.getDeliveryTag());
                    log.error("Orchestrator got un-support message type : " + messageContext.getType());
                }
            }
            MDC.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelExperiment(MessageContext messageContext) {
            try {
                byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageContext.getEvent());
                ExperimentSubmitEvent expEvent = new ExperimentSubmitEvent();
                ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)expEvent);
                log.info("Cancelling experiment with experimentId: {} gateway Id: {}", (Object)expEvent.getExperimentId(), (Object)expEvent.getGatewayId());
                OrchestratorServerHandler.this.terminateExperiment(expEvent.getExperimentId(), expEvent.getGatewayId());
            }
            catch (TException e) {
                log.error("Experiment cancellation failed due to Thrift conversion error", (Throwable)e);
            }
            finally {
                OrchestratorServerHandler.this.experimentSubscriber.sendAck(messageContext.getDeliveryTag());
            }
        }
    }

    private class ProcessStatusHandler
    implements MessageHandler {
        private ProcessStatusHandler() {
        }

        public void onMessage(MessageContext message) {
            if (message.getType().equals((Object)MessageType.PROCESS)) {
                try {
                    ProcessStatusChangeEvent processStatusChangeEvent = new ProcessStatusChangeEvent();
                    TBase event = message.getEvent();
                    byte[] bytes = ThriftUtils.serializeThriftObject((TBase)event);
                    ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)processStatusChangeEvent);
                    ExperimentStatus status = new ExperimentStatus();
                    ProcessIdentifier processIdentity = processStatusChangeEvent.getProcessIdentity();
                    log.info("expId: {}, processId: {} :- Process status changed event received for status {}", new Object[]{processIdentity.getExperimentId(), processIdentity.getProcessId(), processStatusChangeEvent.getState().name()});
                    switch (processStatusChangeEvent.getState()) {
                        case STARTED: {
                            try {
                                ExperimentStatus stat = OrchestratorUtils.getExperimentStatus(processIdentity.getExperimentId());
                                if (stat.getState() == ExperimentState.CANCELING) {
                                    status.setState(ExperimentState.CANCELING);
                                    status.setReason("Process started but experiment cancelling is triggered");
                                    break;
                                }
                                status.setState(ExperimentState.EXECUTING);
                                status.setReason("process  started");
                            }
                            catch (RegistryException e) {
                                status.setState(ExperimentState.EXECUTING);
                                status.setReason("process  started");
                            }
                            break;
                        }
                        case COMPLETED: {
                            try {
                                ExperimentStatus stat = OrchestratorUtils.getExperimentStatus(processIdentity.getExperimentId());
                                if (stat.getState() == ExperimentState.CANCELING) {
                                    status.setState(ExperimentState.CANCELED);
                                    status.setReason("Process competed but experiment cancelling is triggered");
                                    break;
                                }
                                status.setState(ExperimentState.COMPLETED);
                                status.setReason("process  completed");
                            }
                            catch (RegistryException e) {
                                status.setState(ExperimentState.COMPLETED);
                                status.setReason("process  completed");
                            }
                            break;
                        }
                        case FAILED: {
                            try {
                                ExperimentStatus stat = OrchestratorUtils.getExperimentStatus(processIdentity.getExperimentId());
                                if (stat.getState() == ExperimentState.CANCELING) {
                                    status.setState(ExperimentState.CANCELED);
                                    status.setReason("Process failed but experiment cancelling is triggered");
                                    break;
                                }
                                status.setState(ExperimentState.FAILED);
                                status.setReason("process  failed");
                            }
                            catch (RegistryException e) {
                                status.setState(ExperimentState.FAILED);
                                status.setReason("process  failed");
                            }
                            break;
                        }
                        case CANCELED: {
                            status.setState(ExperimentState.CANCELED);
                            status.setReason("process  cancelled");
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    if (status.getState() != null) {
                        status.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
                        OrchestratorUtils.updageAndPublishExperimentStatus(processIdentity.getExperimentId(), status, OrchestratorServerHandler.this.publisher, processIdentity.getGatewayId());
                        log.info("expId : " + processIdentity.getExperimentId() + " :- Experiment status updated to " + status.getState());
                    }
                }
                catch (TException e) {
                    log.error("Message Id : " + message.getMessageId() + ", Message type : " + message.getType() + "Error while prcessing process status change event");
                }
            } else {
                System.out.println("Message Recieved with message id " + message.getMessageId() + " and with message type " + message.getType().name());
            }
        }
    }

    private class SingleAppExperimentRunner
    implements Runnable {
        String experimentId;
        String airavataCredStoreToken;
        String gatewayId;

        public SingleAppExperimentRunner(String experimentId, String airavataCredStoreToken, String gatewayId) {
            this.experimentId = experimentId;
            this.airavataCredStoreToken = airavataCredStoreToken;
            this.gatewayId = gatewayId;
        }

        @Override
        public void run() {
            try {
                this.launchSingleAppExperiment();
            }
            catch (TException e) {
                log.error("Unable to launch experiment..", (Throwable)e);
            }
            catch (AiravataException e) {
                log.error("Unable to publish experiment status..", (Throwable)e);
            }
        }

        private boolean launchSingleAppExperiment() throws TException, AiravataException {
            try {
                List processIds = OrchestratorServerHandler.this.experimentCatalog.getIds(ExperimentCatalogModelType.PROCESS, "experimentId", (Object)this.experimentId);
                for (String processId : processIds) {
                    OrchestratorServerHandler.this.launchProcess(processId, this.airavataCredStoreToken, this.gatewayId);
                }
            }
            catch (Exception e) {
                ExperimentStatus status = new ExperimentStatus(ExperimentState.FAILED);
                status.setReason("Error while updating task status");
                OrchestratorUtils.updageAndPublishExperimentStatus(this.experimentId, status, OrchestratorServerHandler.this.publisher, this.gatewayId);
                log.error("expId: " + this.experimentId + ", Error while updating task status, hence updated experiment status to " + ExperimentState.FAILED, (Throwable)e);
                ExperimentStatusChangeEvent event = new ExperimentStatusChangeEvent(ExperimentState.FAILED, this.experimentId, this.gatewayId);
                String messageId = AiravataUtils.getId((String)"EXPERIMENT");
                MessageContext messageContext = new MessageContext((TBase)event, MessageType.EXPERIMENT, messageId, this.gatewayId);
                messageContext.setUpdatedTime(AiravataUtils.getCurrentTimestamp());
                OrchestratorServerHandler.this.publisher.publish(messageContext);
                throw new TException((Throwable)e);
            }
            return true;
        }
    }
}

