/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hmef.attribute;

import java.util.Date;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class MAPIDateAttribute
extends MAPIAttribute {
    private static POILogger logger = POILogFactory.getLogger(MAPIDateAttribute.class);
    private Date data;

    protected MAPIDateAttribute(MAPIProperty property, int type, byte[] data) {
        super(property, type, data);
        this.data = Util.filetimeToDate(LittleEndian.getLong(data, 0));
    }

    public Date getDate() {
        return this.data;
    }

    public String toString() {
        return this.getProperty().toString() + " " + this.data.toString();
    }

    public static Date getAsDate(MAPIAttribute attr) {
        if (attr == null) {
            return null;
        }
        if (attr instanceof MAPIDateAttribute) {
            return ((MAPIDateAttribute)attr).getDate();
        }
        logger.log(5, "Warning, non date property found: " + attr.toString());
        return null;
    }
}

