/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.AttachManager;
import org.apache.openjpa.kernel.AttachStrategy;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.UnsupportedException;

public class DetachedStateManager
extends AttachStrategy
implements OpenJPAStateManager,
Serializable {
    private static final long serialVersionUID = 4112223665584731100L;
    private static final Localizer _loc = Localizer.forPackage(DetachedStateManager.class);
    private final PersistenceCapable _pc;
    private final boolean _embedded;
    private final boolean _access;
    private final BitSet _loaded;
    private final BitSet _dirty;
    private final Object _oid;
    private final Object _version;
    private final ReentrantLock _lock;
    private final boolean _useDSFForUnproxy;

    public DetachedStateManager(PersistenceCapable pc, OpenJPAStateManager sm, BitSet load, boolean access, boolean multithreaded) {
        Compatibility compat;
        this._pc = pc;
        this._embedded = sm.isEmbedded();
        this._loaded = load;
        this._access = access;
        this._dirty = !sm.isFlushed() ? (BitSet)sm.getDirty().clone() : new BitSet(this._loaded.length());
        this._oid = sm.fetchObjectId();
        this._version = sm.getVersion();
        this._lock = multithreaded ? new ReentrantLock() : null;
        this._useDSFForUnproxy = sm.getContext() != null && sm.getContext().getConfiguration() != null ? (compat = sm.getContext().getConfiguration().getCompatibilityInstance()) != null && !compat.getIgnoreDetachedStateFieldForProxySerialization() : false;
    }

    @Override
    public Object attach(AttachManager manager, Object toAttach, ClassMetaData meta, PersistenceCapable into, OpenJPAStateManager owner, ValueMetaData ownerMeta, boolean explicit) {
        StateManagerImpl sm;
        BrokerImpl broker = manager.getBroker();
        if (this._embedded) {
            if (this._dirty.length() > 0) {
                owner.dirty(ownerMeta.getFieldMetaData().getIndex());
            }
            sm = (StateManagerImpl)broker.embed(this._pc, this._oid, owner, ownerMeta);
            ImplHelper.toPersistenceCapable(toAttach, broker.getConfiguration()).pcReplaceStateManager(this);
        } else {
            PCState state = this._dirty.length() > 0 ? PCState.PDIRTY : PCState.PCLEAN;
            sm = (StateManagerImpl)broker.copy(this, state);
        }
        PersistenceCapable pc = sm.getPersistenceCapable();
        manager.setAttachedCopy(toAttach, pc);
        manager.fireBeforeAttach(toAttach, meta);
        FieldMetaData[] fields = sm.getMetaData().getFields();
        int restore = broker.getRestoreState();
        boolean postLoadOnMerge = broker.getPostLoadOnMerge();
        if (this._dirty.length() > 0 || postLoadOnMerge) {
            BitSet load = new BitSet(fields.length);
            if (postLoadOnMerge && broker.getLifecycleEventManager().hasLoadListeners(pc, meta)) {
                load.set(0, fields.length);
            } else {
                block18: for (int i = 0; i < fields.length; ++i) {
                    if (!this._dirty.get(i)) continue;
                    switch (fields[i].getDeclaredTypeCode()) {
                        case 11: 
                        case 12: {
                            if (restore != 2 && fields[i].getElement().getCascadeDelete() != 2) continue block18;
                            load.set(i);
                            continue block18;
                        }
                        case 13: {
                            if (restore != 2 && fields[i].getElement().getCascadeDelete() != 2 && fields[i].getKey().getCascadeDelete() != 2) continue block18;
                            load.set(i);
                            continue block18;
                        }
                        default: {
                            if (restore == 0 && fields[i].getCascadeDelete() != 2) continue block18;
                            load.set(i);
                        }
                    }
                }
            }
            if (!postLoadOnMerge) {
                sm.setPostLoadCallback(false);
            }
            FetchConfiguration fc = broker.getFetchConfiguration();
            sm.loadFields(load, fc, fc.getWriteLockLevel(), null);
        }
        Object origVersion = sm.getVersion();
        sm.setVersion(this._version);
        BitSet loaded = sm.getLoaded();
        int set = 2;
        sm.setPostLoadCallback(false);
        block19: for (int i = 0; i < fields.length; ++i) {
            if (!this._loaded.get(i) || !this._dirty.get(i) && loaded.get(i) && DetachedStateManager.ignoreLoaded(fields[i])) continue;
            this.provideField(i);
            switch (fields[i].getDeclaredTypeCode()) {
                case 0: {
                    if (this._dirty.get(i)) {
                        sm.settingBooleanField(pc, i, loaded.get(i) && sm.fetchBooleanField(i), this.longval == 1L, set);
                        continue block19;
                    }
                    sm.storeBooleanField(i, this.longval == 1L);
                    continue block19;
                }
                case 1: {
                    if (this._dirty.get(i)) {
                        sm.settingByteField(pc, i, !loaded.get(i) ? (byte)0 : sm.fetchByteField(i), (byte)this.longval, set);
                        continue block19;
                    }
                    sm.storeByteField(i, (byte)this.longval);
                    continue block19;
                }
                case 2: {
                    if (this._dirty.get(i)) {
                        sm.settingCharField(pc, i, !loaded.get(i) ? (char)'\u0000' : sm.fetchCharField(i), (char)this.longval, set);
                        continue block19;
                    }
                    sm.storeCharField(i, (char)this.longval);
                    continue block19;
                }
                case 5: {
                    if (this._dirty.get(i)) {
                        sm.settingIntField(pc, i, !loaded.get(i) ? 0 : sm.fetchIntField(i), (int)this.longval, set);
                        continue block19;
                    }
                    sm.storeIntField(i, (int)this.longval);
                    continue block19;
                }
                case 6: {
                    if (this._dirty.get(i)) {
                        sm.settingLongField(pc, i, !loaded.get(i) ? 0L : sm.fetchLongField(i), this.longval, set);
                        continue block19;
                    }
                    sm.storeLongField(i, this.longval);
                    continue block19;
                }
                case 7: {
                    if (this._dirty.get(i)) {
                        sm.settingShortField(pc, i, !loaded.get(i) ? (short)0 : sm.fetchShortField(i), (short)this.longval, set);
                        continue block19;
                    }
                    sm.storeShortField(i, (short)this.longval);
                    continue block19;
                }
                case 4: {
                    if (this._dirty.get(i)) {
                        sm.settingFloatField(pc, i, !loaded.get(i) ? 0.0f : sm.fetchFloatField(i), (float)this.dblval, set);
                        continue block19;
                    }
                    sm.storeFloatField(i, (float)this.dblval);
                    continue block19;
                }
                case 3: {
                    if (this._dirty.get(i)) {
                        sm.settingDoubleField(pc, i, !loaded.get(i) ? 0.0 : sm.fetchDoubleField(i), this.dblval, set);
                        continue block19;
                    }
                    sm.storeDoubleField(i, this.dblval);
                    continue block19;
                }
                case 9: {
                    if (this._dirty.get(i)) {
                        sm.settingStringField(pc, i, !loaded.get(i) ? null : sm.fetchStringField(i), (String)this.objval, set);
                    } else {
                        sm.storeStringField(i, (String)this.objval);
                    }
                    this.objval = null;
                    continue block19;
                }
                case 15: 
                case 27: {
                    if (fields[i].getCascadeAttach() == 0) {
                        PersistenceCapable cpy = manager.getAttachedCopy(this.objval);
                        this.objval = cpy != null ? cpy : this.getReference(manager, this.objval, sm, fields[i]);
                    } else {
                        PersistenceCapable toPC = null;
                        if (this.objval != null && fields[i].isEmbeddedPC()) {
                            toPC = ImplHelper.toPersistenceCapable(this.objval, broker.getConfiguration());
                        }
                        this.objval = manager.attach(this.objval, toPC, sm, fields[i], false);
                    }
                    if (this._dirty.get(i)) {
                        sm.settingObjectField(pc, i, !loaded.get(i) ? null : sm.fetchObjectField(i), this.objval, set);
                    } else {
                        sm.storeObjectField(i, this.objval);
                    }
                    this.objval = null;
                    continue block19;
                }
                case 12: {
                    Collection coll = (Collection)this.objval;
                    this.objval = null;
                    if (coll != null) {
                        coll = this.attachCollection(manager, coll, sm, fields[i]);
                    }
                    if (this._dirty.get(i)) {
                        sm.settingObjectField(pc, i, !loaded.get(i) ? null : sm.fetchObjectField(i), coll, set);
                        continue block19;
                    }
                    sm.storeObjectField(i, coll);
                    continue block19;
                }
                case 13: {
                    Map map = (Map)this.objval;
                    this.objval = null;
                    if (map != null) {
                        map = this.attachMap(manager, map, sm, fields[i]);
                    }
                    if (this._dirty.get(i)) {
                        sm.settingObjectField(pc, i, !loaded.get(i) ? null : sm.fetchObjectField(i), map, set);
                        continue block19;
                    }
                    sm.storeObjectField(i, map);
                    continue block19;
                }
                default: {
                    if (this._dirty.get(i)) {
                        sm.settingObjectField(pc, i, !loaded.get(i) ? null : sm.fetchObjectField(i), this.objval, set);
                    } else {
                        sm.storeObjectField(i, this.objval);
                    }
                    this.objval = null;
                }
            }
        }
        sm.setPostLoadCallback(true);
        pc.pcReplaceStateManager(sm);
        if (!sm.isVersionCheckRequired() && broker.isActive() && this._version != origVersion && (origVersion == null || broker.getStoreManager().compareVersion(sm, this._version, origVersion) != 3)) {
            broker.transactional(sm.getManagedInstance(), false, manager.getBehavior());
        }
        return sm.getManagedInstance();
    }

    @Override
    protected Object getDetachedObjectId(AttachManager manager, Object toAttach) {
        return this._oid;
    }

    void provideField(int field) {
        this._pc.pcProvideField(field);
    }

    @Override
    protected void provideField(Object toAttach, StateManagerImpl sm, int field) {
        this.provideField(field);
    }

    protected static boolean ignoreLoaded(FieldMetaData fmd) {
        switch (fmd.getTypeCode()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getGenericContext() {
        return null;
    }

    @Override
    public Object getPCPrimaryKey(Object oid, int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StateManager replaceStateManager(StateManager sm) {
        return sm;
    }

    @Override
    public Object getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(Object version) {
        throw new UnsupportedException();
    }

    @Override
    public boolean isDirty() {
        return this._dirty.length() != 0;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public boolean isVersionUpdateRequired() {
        return false;
    }

    @Override
    public boolean isVersionCheckRequired() {
        return false;
    }

    @Override
    public void dirty(String field) {
        throw new UnsupportedException();
    }

    @Override
    public Object fetchObjectId() {
        return this._oid;
    }

    @Override
    public void accessingField(int idx) {
        if (!this._access && !this._loaded.get(idx)) {
            throw new IllegalStateException(_loc.get("unloaded-detached", Exceptions.toString(this._pc)).getMessage());
        }
    }

    @Override
    public boolean serializing() {
        return false;
    }

    @Override
    public boolean writeDetached(ObjectOutput out) throws IOException {
        out.writeObject(this._pc.pcGetDetachedState());
        out.writeObject(this);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyDetachedDeserialized(int idx) {
        this.lock();
        try {
            this._pc.pcProvideField(idx);
            if (this.objval instanceof Proxy) {
                ((Proxy)this.objval).setOwner(this, idx);
            }
            this.objval = null;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingBooleanField(PersistenceCapable pc, int idx, boolean cur, boolean next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next ? 1L : 0L;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingCharField(PersistenceCapable pc, int idx, char cur, char next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingByteField(PersistenceCapable pc, int idx, byte cur, byte next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingShortField(PersistenceCapable pc, int idx, short cur, short next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingIntField(PersistenceCapable pc, int idx, int cur, int next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingLongField(PersistenceCapable pc, int idx, long cur, long next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.longval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingFloatField(PersistenceCapable pc, int idx, float cur, float next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.dblval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingDoubleField(PersistenceCapable pc, int idx, double cur, double next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.dblval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingStringField(PersistenceCapable pc, int idx, String cur, String next, int set) {
        this.accessingField(idx);
        if (cur == next || cur != null && cur.equals(next) || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.objval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
            this.objval = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingObjectField(PersistenceCapable pc, int idx, Object cur, Object next, int set) {
        this.accessingField(idx);
        if (cur == next || !this._loaded.get(idx)) {
            return;
        }
        this.lock();
        try {
            this._dirty.set(idx);
            this.objval = next;
            pc.pcReplaceField(idx);
        }
        finally {
            this.unlock();
            this.objval = null;
        }
    }

    @Override
    public void providedBooleanField(PersistenceCapable pc, int idx, boolean cur) {
        this.longval = cur ? 1L : 0L;
    }

    @Override
    public void providedCharField(PersistenceCapable pc, int idx, char cur) {
        this.longval = cur;
    }

    @Override
    public void providedByteField(PersistenceCapable pc, int idx, byte cur) {
        this.longval = cur;
    }

    @Override
    public void providedShortField(PersistenceCapable pc, int idx, short cur) {
        this.longval = cur;
    }

    @Override
    public void providedIntField(PersistenceCapable pc, int idx, int cur) {
        this.longval = cur;
    }

    @Override
    public void providedLongField(PersistenceCapable pc, int idx, long cur) {
        this.longval = cur;
    }

    @Override
    public void providedFloatField(PersistenceCapable pc, int idx, float cur) {
        this.dblval = cur;
    }

    @Override
    public void providedDoubleField(PersistenceCapable pc, int idx, double cur) {
        this.dblval = cur;
    }

    @Override
    public void providedStringField(PersistenceCapable pc, int idx, String cur) {
        this.objval = cur;
    }

    @Override
    public void providedObjectField(PersistenceCapable pc, int idx, Object cur) {
        this.objval = cur;
    }

    @Override
    public boolean replaceBooleanField(PersistenceCapable pc, int idx) {
        return this.longval == 1L;
    }

    @Override
    public char replaceCharField(PersistenceCapable pc, int idx) {
        return (char)this.longval;
    }

    @Override
    public byte replaceByteField(PersistenceCapable pc, int idx) {
        return (byte)this.longval;
    }

    @Override
    public short replaceShortField(PersistenceCapable pc, int idx) {
        return (short)this.longval;
    }

    @Override
    public int replaceIntField(PersistenceCapable pc, int idx) {
        return (int)this.longval;
    }

    @Override
    public long replaceLongField(PersistenceCapable pc, int idx) {
        return this.longval;
    }

    @Override
    public float replaceFloatField(PersistenceCapable pc, int idx) {
        return (float)this.dblval;
    }

    @Override
    public double replaceDoubleField(PersistenceCapable pc, int idx) {
        return this.dblval;
    }

    @Override
    public String replaceStringField(PersistenceCapable pc, int idx) {
        String str = (String)this.objval;
        this.objval = null;
        return str;
    }

    @Override
    public Object replaceObjectField(PersistenceCapable pc, int idx) {
        Object ret = this.objval;
        this.objval = null;
        return ret;
    }

    @Override
    public void initialize(Class forType, PCState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(FetchConfiguration fetch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getManagedInstance() {
        return this._pc;
    }

    @Override
    public PersistenceCapable getPersistenceCapable() {
        return this._pc;
    }

    @Override
    public ClassMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OpenJPAStateManager getOwner() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getOwnerIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmbedded() {
        return this._embedded;
    }

    @Override
    public boolean isFlushed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFlushedDirty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isProvisional() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getLoaded() {
        return this._loaded;
    }

    @Override
    public BitSet getDirty() {
        return this._dirty;
    }

    public boolean getUseDSFForUnproxy() {
        return this._useDSFForUnproxy;
    }

    @Override
    public BitSet getFlushed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getUnloaded(FetchConfiguration fetch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newProxy(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newFieldProxy(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultValue(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StoreContext getContext() {
        return null;
    }

    @Override
    public PCState getPCState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObjectId() {
        return this._oid;
    }

    @Override
    public void setObjectId(Object oid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean assignObjectId(boolean flush) {
        return true;
    }

    @Override
    public Object getId() {
        return this.getObjectId();
    }

    @Override
    public Object getLock() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLock(Object lock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNextVersion(Object version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getImplData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setImplData(Object data, boolean cacheable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImplDataCacheable() {
        return false;
    }

    @Override
    public Object getImplData(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object setImplData(int field, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImplDataCacheable(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getIntermediate(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIntermediate(int field, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removed(int field, Object removed, boolean key) {
        this.dirty(field);
    }

    @Override
    public boolean beforeRefresh(boolean all) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dirty(int field) {
        this.lock();
        try {
            this._dirty.set(field);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void storeBoolean(int field, boolean extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeByte(int field, byte extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeChar(int field, char extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeInt(int field, int extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeShort(int field, short extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeLong(int field, long extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeFloat(int field, float extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeDouble(int field, double extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeString(int field, String extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeObject(int field, Object extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void store(int field, Object extVal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeField(int field, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean fetchBoolean(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte fetchByte(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char fetchChar(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short fetchShort(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int fetchInt(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long fetchLong(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float fetchFloat(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double fetchDouble(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String fetchString(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fetchObject(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fetch(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fetchField(int field, boolean transitions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fetchInitialField(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRemote(int field, Object value) {
        throw new UnsupportedOperationException();
    }

    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }
}

