/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.IOException;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.BitSet;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;

public class ObjectIdStateManager
implements OpenJPAStateManager {
    private static final Byte ZERO_BYTE = 0;
    private static final Character ZERO_CHAR = Character.valueOf('\u0000');
    private static final Double ZERO_DOUBLE = 0.0;
    private static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    private static final Short ZERO_SHORT = 0;
    private Object _oid;
    private final OpenJPAStateManager _owner;
    private final ValueMetaData _vmd;

    public ObjectIdStateManager(Object oid, OpenJPAStateManager owner, ValueMetaData ownerVal) {
        this._oid = oid;
        this._owner = owner;
        this._vmd = ownerVal;
    }

    @Override
    public Object getGenericContext() {
        return this._owner == null ? null : this._owner.getGenericContext();
    }

    @Override
    public Object getPCPrimaryKey(Object oid, int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StateManager replaceStateManager(StateManager sm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getVersion() {
        return null;
    }

    @Override
    public void setVersion(Object version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public boolean isDetached() {
        return true;
    }

    @Override
    public boolean isVersionUpdateRequired() {
        return false;
    }

    @Override
    public boolean isVersionCheckRequired() {
        return false;
    }

    @Override
    public void dirty(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object fetchObjectId() {
        return null;
    }

    @Override
    public void accessingField(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean serializing() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean writeDetached(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void proxyDetachedDeserialized(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingBooleanField(PersistenceCapable pc, int idx, boolean cur, boolean next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingCharField(PersistenceCapable pc, int idx, char cur, char next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingByteField(PersistenceCapable pc, int idx, byte cur, byte next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingShortField(PersistenceCapable pc, int idx, short cur, short next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingIntField(PersistenceCapable pc, int idx, int cur, int next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingLongField(PersistenceCapable pc, int idx, long cur, long next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingFloatField(PersistenceCapable pc, int idx, float cur, float next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingDoubleField(PersistenceCapable pc, int idx, double cur, double next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingStringField(PersistenceCapable pc, int idx, String cur, String next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void settingObjectField(PersistenceCapable pc, int idx, Object cur, Object next, int set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedBooleanField(PersistenceCapable pc, int idx, boolean cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedCharField(PersistenceCapable pc, int idx, char cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedByteField(PersistenceCapable pc, int idx, byte cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedShortField(PersistenceCapable pc, int idx, short cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedIntField(PersistenceCapable pc, int idx, int cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedLongField(PersistenceCapable pc, int idx, long cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedFloatField(PersistenceCapable pc, int idx, float cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedDoubleField(PersistenceCapable pc, int idx, double cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedStringField(PersistenceCapable pc, int idx, String cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void providedObjectField(PersistenceCapable pc, int idx, Object cur) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replaceBooleanField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char replaceCharField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte replaceByteField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short replaceShortField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int replaceIntField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long replaceLongField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float replaceFloatField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double replaceDoubleField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String replaceStringField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object replaceObjectField(PersistenceCapable pc, int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initialize(Class forType, PCState state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void load(FetchConfiguration fetch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getManagedInstance() {
        return this._oid;
    }

    @Override
    public PersistenceCapable getPersistenceCapable() {
        return ImplHelper.toPersistenceCapable(this._oid, this._vmd.getRepository().getConfiguration());
    }

    @Override
    public ClassMetaData getMetaData() {
        return this._vmd.getEmbeddedMetaData();
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this._owner;
    }

    @Override
    public int getOwnerIndex() {
        return this._vmd.getFieldMetaData().getIndex();
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public boolean isFlushed() {
        return false;
    }

    @Override
    public boolean isFlushedDirty() {
        return false;
    }

    @Override
    public boolean isProvisional() {
        return false;
    }

    @Override
    public BitSet getLoaded() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getDirty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getFlushed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getUnloaded(FetchConfiguration fetch) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newProxy(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object newFieldProxy(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultValue(int field) {
        Object val = this.getValue(field);
        if (val == null) {
            return true;
        }
        FieldMetaData fmd = this.getMetaData().getField(field);
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return Boolean.FALSE.equals(val);
            }
            case 2: {
                return ((Character)val).charValue() == '\u0000';
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return ((Number)val).intValue() == 0;
            }
            case 9: {
                return "".equals(val);
            }
        }
        return false;
    }

    @Override
    public StoreContext getContext() {
        return this._owner == null ? null : this._owner.getContext();
    }

    @Override
    public PCState getPCState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObjectId() {
        return null;
    }

    @Override
    public void setObjectId(Object oid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean assignObjectId(boolean flush) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getId() {
        return null;
    }

    @Override
    public Object getLock() {
        return null;
    }

    @Override
    public void setLock(Object lock) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNextVersion(Object version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getImplData() {
        return null;
    }

    @Override
    public Object setImplData(Object data, boolean cacheable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImplDataCacheable() {
        return false;
    }

    @Override
    public Object getImplData(int field) {
        return null;
    }

    @Override
    public Object setImplData(int field, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isImplDataCacheable(int field) {
        return false;
    }

    @Override
    public Object getIntermediate(int field) {
        return null;
    }

    @Override
    public void setIntermediate(int field, Object data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removed(int field, Object removed, boolean key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean beforeRefresh(boolean all) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dirty(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeBoolean(int field, boolean extVal) {
        this.setValue(field, extVal ? Boolean.TRUE : Boolean.FALSE, true);
    }

    @Override
    public void storeByte(int field, byte extVal) {
        this.setValue(field, extVal, true);
    }

    @Override
    public void storeChar(int field, char extVal) {
        this.setValue(field, Character.valueOf(extVal), true);
    }

    @Override
    public void storeInt(int field, int extVal) {
        this.setValue(field, extVal, true);
    }

    @Override
    public void storeShort(int field, short extVal) {
        this.setValue(field, extVal, true);
    }

    @Override
    public void storeLong(int field, long extVal) {
        this.setValue(field, extVal, true);
    }

    @Override
    public void storeFloat(int field, float extVal) {
        this.setValue(field, Float.valueOf(extVal), true);
    }

    @Override
    public void storeDouble(int field, double extVal) {
        this.setValue(field, extVal, true);
    }

    @Override
    public void storeString(int field, String extVal) {
        this.setValue(field, extVal, extVal != null);
    }

    @Override
    public void storeObject(int field, Object extVal) {
        this.setValue(field, extVal, extVal != null);
    }

    @Override
    public void store(int field, Object extVal) {
        boolean forceInst = true;
        if (extVal == null) {
            extVal = this.getDefaultValue(field);
            forceInst = false;
        }
        this.setValue(field, extVal, forceInst);
    }

    @Override
    public void storeBooleanField(int field, boolean extVal) {
        this.storeBoolean(field, extVal);
    }

    @Override
    public void storeByteField(int field, byte extVal) {
        this.storeByte(field, extVal);
    }

    @Override
    public void storeCharField(int field, char extVal) {
        this.storeChar(field, extVal);
    }

    @Override
    public void storeIntField(int field, int extVal) {
        this.storeInt(field, extVal);
    }

    @Override
    public void storeShortField(int field, short extVal) {
        this.storeShort(field, extVal);
    }

    @Override
    public void storeLongField(int field, long extVal) {
        this.storeLong(field, extVal);
    }

    @Override
    public void storeFloatField(int field, float extVal) {
        this.storeFloat(field, extVal);
    }

    @Override
    public void storeDoubleField(int field, double extVal) {
        this.storeDouble(field, extVal);
    }

    @Override
    public void storeStringField(int field, String extVal) {
        this.storeString(field, extVal);
    }

    @Override
    public void storeObjectField(int field, Object extVal) {
        this.storeObject(field, extVal);
    }

    @Override
    public void storeField(int field, Object value) {
        this.store(field, value);
    }

    @Override
    public boolean fetchBoolean(int field) {
        return (Boolean)this.getValue(field);
    }

    @Override
    public byte fetchByte(int field) {
        return ((Number)this.getValue(field)).byteValue();
    }

    @Override
    public char fetchChar(int field) {
        return ((Character)this.getValue(field)).charValue();
    }

    @Override
    public short fetchShort(int field) {
        return ((Number)this.getValue(field)).shortValue();
    }

    @Override
    public int fetchInt(int field) {
        return ((Number)this.getValue(field)).intValue();
    }

    @Override
    public long fetchLong(int field) {
        return ((Number)this.getValue(field)).longValue();
    }

    @Override
    public float fetchFloat(int field) {
        return ((Number)this.getValue(field)).floatValue();
    }

    @Override
    public double fetchDouble(int field) {
        return ((Number)this.getValue(field)).doubleValue();
    }

    @Override
    public String fetchString(int field) {
        return (String)this.getValue(field);
    }

    @Override
    public Object fetchObject(int field) {
        return this.getValue(field);
    }

    @Override
    public Object fetch(int field) {
        Object ret = this.getValue(field);
        if (ret == null) {
            ret = this.getDefaultValue(field);
        }
        return ret;
    }

    @Override
    public boolean fetchBooleanField(int field) {
        return this.fetchBoolean(field);
    }

    @Override
    public byte fetchByteField(int field) {
        return this.fetchByte(field);
    }

    @Override
    public char fetchCharField(int field) {
        return this.fetchChar(field);
    }

    @Override
    public short fetchShortField(int field) {
        return this.fetchShort(field);
    }

    @Override
    public int fetchIntField(int field) {
        return this.fetchInt(field);
    }

    @Override
    public long fetchLongField(int field) {
        return this.fetchLong(field);
    }

    @Override
    public float fetchFloatField(int field) {
        return this.fetchFloat(field);
    }

    @Override
    public double fetchDoubleField(int field) {
        return this.fetchDouble(field);
    }

    @Override
    public String fetchStringField(int field) {
        return this.fetchString(field);
    }

    @Override
    public Object fetchObjectField(int field) {
        return this.fetch(field);
    }

    @Override
    public Object fetchField(int field, boolean transitions) {
        return this.fetch(field);
    }

    @Override
    public Object fetchInitialField(int field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRemote(int field, Object value) {
        this.store(field, value);
    }

    public void lock() {
    }

    public void unlock() {
    }

    private Object getDefaultValue(int field) {
        FieldMetaData fmd = this.getMetaData().getField(field);
        switch (fmd.getDeclaredTypeCode()) {
            case 0: {
                return Boolean.FALSE;
            }
            case 1: {
                return ZERO_BYTE;
            }
            case 2: {
                return ZERO_CHAR;
            }
            case 3: {
                return ZERO_DOUBLE;
            }
            case 4: {
                return ZERO_FLOAT;
            }
            case 5: {
                return 0;
            }
            case 6: {
                return 0L;
            }
            case 7: {
                return ZERO_SHORT;
            }
        }
        return null;
    }

    private Object getValue(int field) {
        if (this._oid == null) {
            return null;
        }
        FieldMetaData fmd = this.getMetaData().getField(field);
        Object val = null;
        val = fmd.getBackingMember() instanceof Field ? Reflection.get(this._oid, (Field)fmd.getBackingMember()) : (fmd.getBackingMember() instanceof Method ? Reflection.get(this._oid, (Method)fmd.getBackingMember()) : (AccessCode.isField(fmd.getDefiningMetaData().getAccessType()) ? Reflection.get(this._oid, Reflection.findField(this._oid.getClass(), fmd.getName(), true)) : Reflection.get(this._oid, Reflection.findGetter(this._oid.getClass(), fmd.getName(), true))));
        if (fmd.getValue().getEmbeddedMetaData() != null) {
            return new ObjectIdStateManager(val, null, fmd);
        }
        return val;
    }

    private void setValue(int field, Object val, boolean forceInst) {
        if (this._oid == null && forceInst) {
            try {
                this._oid = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(this.getMetaData().getDescribedType()));
            }
            catch (Exception e) {
                if (e instanceof PrivilegedActionException) {
                    e = ((PrivilegedActionException)e).getException();
                }
                throw new GeneralException(e);
            }
        } else if (this._oid == null) {
            return;
        }
        FieldMetaData fmd = this.getMetaData().getField(field);
        if (fmd.getBackingMember() instanceof Field) {
            Reflection.set(this._oid, (Field)fmd.getBackingMember(), val);
        } else if (AccessCode.isField(fmd.getDefiningMetaData().getAccessType())) {
            Reflection.set(this._oid, Reflection.findField(this._oid.getClass(), fmd.getName(), true), val);
        } else {
            Reflection.set(this._oid, Reflection.findSetter(this._oid.getClass(), fmd.getName(), fmd.getDeclaredType(), true), val);
        }
    }
}

