/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.AbstractGlobusNamespacesStore;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GlobusNamespacesStore
extends AbstractGlobusNamespacesStore {
    protected Map<String, Map<String, List<NamespacePolicy>>> policiesByName = new HashMap<String, Map<String, List<NamespacePolicy>>>(1);

    public GlobusNamespacesStore(ObserversHandler observers, boolean openssl1Mode) {
        super(observers, openssl1Mode);
    }

    @Override
    public void setPolicies(Collection<String> locations) {
        ArrayList<NamespacePolicy> policies = new ArrayList<NamespacePolicy>();
        for (String location : locations) {
            this.tryLoadNsLocation(location, policies);
        }
        this.setPolicies((List<NamespacePolicy>)policies);
    }

    protected synchronized void setPolicies(List<NamespacePolicy> policies) {
        this.policiesByName = new HashMap<String, Map<String, List<NamespacePolicy>>>(policies.size());
        for (NamespacePolicy policy : policies) {
            this.addPolicy(policy, this.policiesByName);
        }
    }

    @Override
    protected List<NamespacePolicy> getPoliciesFor(String definedForHash, String issuerDn) {
        Map<String, List<NamespacePolicy>> policiesMap = this.policiesByName.get(definedForHash);
        if (policiesMap == null) {
            return null;
        }
        return policiesMap.get(issuerDn);
    }
}

