/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfile;
import org.apache.airavata.registry.core.app.catalog.model.UserResourceProfilePK;
import org.apache.airavata.registry.core.app.catalog.model.UserStoragePreference;
import org.apache.airavata.registry.core.app.catalog.model.UserStoragePreferencePK;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.resources.UserResourceProfileResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.CompositeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStoragePreferenceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(UserStoragePreferenceResource.class);
    private String gatewayID;
    private String userId;
    private String storageResourceId;
    private String loginUserName;
    private String fsRootLocation;
    private String resourceCSToken;
    private UserResourceProfileResource userResourceProfileResource;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getLoginUserName() {
        return this.loginUserName;
    }

    public void setLoginUserName(String loginUserName) {
        this.loginUserName = loginUserName;
    }

    public String getGatewayId() {
        return this.gatewayID;
    }

    public void setGatewayId(String gatewayID) {
        this.gatewayID = gatewayID;
    }

    public UserResourceProfileResource getUserResourceProfileResource() {
        return this.userResourceProfileResource;
    }

    public void setUserResourceProfileResource(UserResourceProfileResource userResourceProfileResource) {
        this.userResourceProfileResource = userResourceProfileResource;
    }

    public String getResourceCSToken() {
        return this.resourceCSToken;
    }

    public void setResourceCSToken(String resourceCSToken) {
        this.resourceCSToken = resourceCSToken;
    }

    public String getFsRootLocation() {
        return this.fsRootLocation;
    }

    public void setFsRootLocation(String fsRootLocation) {
        this.fsRootLocation = fsRootLocation;
    }

    public String getStorageResourceId() {
        return this.storageResourceId;
    }

    public void setStorageResourceId(String storageResourceId) {
        this.storageResourceId = storageResourceId;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserStoragePreference", new Object[0][]);
            generator.setParameter("storageResourceId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("userId", ids.getSecondLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getThirdLevelIdentifier().toString());
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserStoragePreference", new Object[0][]);
            generator.setParameter("storageResourceId", ids.getTopLevelIdentifier().toString());
            generator.setParameter("userId", ids.getSecondLevelIdentifier().toString());
            generator.setParameter("gatewayID", ids.getThirdLevelIdentifier().toString());
            Query q = generator.selectQuery(em);
            UserStoragePreference preference = (UserStoragePreference)q.getSingleResult();
            UserStoragePreferenceResource preferenceResource = (UserStoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_STORAGE_PREFERENCE, preference);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            UserStoragePreferenceResource userStoragePreferenceResource = preferenceResource;
            return userStoragePreferenceResource;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> preferenceResourceList = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("UserStoragePreference", new Object[0][]);
            if (fieldName.equals("storageResourceId")) {
                generator.setParameter("storageResourceId", value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserStoragePreference preference = (UserStoragePreference)result;
                        if (preference.getStorageResourceId() == null) continue;
                        UserStoragePreferenceResource preferenceResource = (UserStoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_STORAGE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else if (fieldName.equals("userId")) {
                if (!(value instanceof CompositeIdentifier)) {
                    logger.error("Identifier should be a instance of CompositeIdentifier class");
                    throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
                }
                CompositeIdentifier ids = (CompositeIdentifier)value;
                generator.setParameter("userId", ids.getTopLevelIdentifier().toString());
                generator.setParameter("gatewayID", ids.getSecondLevelIdentifier().toString());
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                if (results.size() != 0) {
                    for (Object result : results) {
                        UserStoragePreference preference = (UserStoragePreference)result;
                        if (preference.getStorageResourceId() == null) continue;
                        UserStoragePreferenceResource preferenceResource = (UserStoragePreferenceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.USER_STORAGE_PREFERENCE, preference);
                        preferenceResourceList.add(preferenceResource);
                    }
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for data storage preference Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for data storage preference Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return preferenceResourceList;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        logger.error("Unsupported for objects with a composite identifier");
        throw new AppCatalogException("Unsupported for objects with a composite identifier");
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            UserStoragePreference existingPreference = (UserStoragePreference)em.find(UserStoragePreference.class, (Object)new UserStoragePreferencePK(this.userId, this.gatewayID, this.storageResourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            UserResourceProfile userResourceProfile = (UserResourceProfile)em.find(UserResourceProfile.class, (Object)new UserResourceProfilePK(this.userId, this.gatewayID));
            if (existingPreference != null) {
                existingPreference.setStorageResourceId(this.storageResourceId);
                existingPreference.setUserId(this.userId);
                existingPreference.setGatewayID(this.gatewayID);
                existingPreference.setUserResourceProfile(userResourceProfile);
                existingPreference.setLoginUserName(this.loginUserName);
                existingPreference.setComputeResourceCSToken(this.resourceCSToken);
                existingPreference.setFsRootLocation(this.fsRootLocation);
                em.merge((Object)existingPreference);
            } else {
                UserStoragePreference resourcePreference = new UserStoragePreference();
                resourcePreference.setStorageResourceId(this.storageResourceId);
                resourcePreference.setGatewayID(this.gatewayID);
                resourcePreference.setUserId(this.userId);
                resourcePreference.setUserResourceProfile(userResourceProfile);
                resourcePreference.setLoginUserName(this.loginUserName);
                resourcePreference.setComputeResourceCSToken(this.resourceCSToken);
                resourcePreference.setFsRootLocation(this.fsRootLocation);
                em.persist((Object)resourcePreference);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        if (!(identifier instanceof CompositeIdentifier)) {
            logger.error("Identifier should be a instance of CompositeIdentifier class");
            throw new AppCatalogException("Identifier should be a instance of CompositeIdentifier class");
        }
        CompositeIdentifier ids = (CompositeIdentifier)identifier;
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            String storageResourceId = ids.getTopLevelIdentifier().toString();
            String userId = ids.getSecondLevelIdentifier().toString();
            String gatewayID = ids.getThirdLevelIdentifier().toString();
            UserStoragePreference existingPreference = (UserStoragePreference)em.find(UserStoragePreference.class, (Object)new UserStoragePreferencePK(userId, gatewayID, storageResourceId));
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = existingPreference != null;
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }
}

