/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionRecord;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class RemoveBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    long recordId;

    public RemoveBackupOperation() {
    }

    public RemoveBackupOperation(CollectionProxyId proxyId, Data dataKey, long recordId) {
        super(proxyId, dataKey);
        this.recordId = recordId;
    }

    @Override
    public void run() throws Exception {
        CollectionWrapper wrapper = this.getCollectionWrapper();
        this.response = false;
        if (wrapper == null) {
            return;
        }
        Collection<CollectionRecord> coll = wrapper.getCollection();
        Iterator<CollectionRecord> iter = coll.iterator();
        while (iter.hasNext()) {
            if (iter.next().getRecordId() != this.recordId) continue;
            iter.remove();
            this.response = true;
            if (!coll.isEmpty()) break;
            this.removeCollection();
            break;
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.recordId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.recordId = in.readLong();
    }

    @Override
    public int getId() {
        return 19;
    }
}

