/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.uas.client;

import de.fzj.unicore.uas.TargetSystem;
import de.fzj.unicore.uas.TargetSystemFactory;
import de.fzj.unicore.uas.client.BaseClientWithStatus;
import de.fzj.unicore.uas.client.EnumerationClient;
import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.client.ReservationClient;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.TSFClient;
import de.fzj.unicore.uas.faults.AutoStartNotSupportedException;
import de.fzj.unicore.uas.lookup.AddressFilter;
import de.fzj.unicore.uas.util.StorageFilters;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.OperatingSystemType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.unigrids.services.atomic.types.AvailableResourceType;
import org.unigrids.services.atomic.types.SecurityType;
import org.unigrids.services.atomic.types.SiteResourceType;
import org.unigrids.services.atomic.types.StatusType;
import org.unigrids.services.atomic.types.StorageReferenceDocument;
import org.unigrids.services.atomic.types.TextInfoType;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationRequestDocument;
import org.unigrids.x2006.x04.services.reservation.ResourceReservationResponseDocument;
import org.unigrids.x2006.x04.services.tss.ApplicationResourceType;
import org.unigrids.x2006.x04.services.tss.DeleteJobsDocument;
import org.unigrids.x2006.x04.services.tss.GetJobsStatusDocument;
import org.unigrids.x2006.x04.services.tss.GetJobsStatusResponseDocument;
import org.unigrids.x2006.x04.services.tss.JobReferenceDocument;
import org.unigrids.x2006.x04.services.tss.JobStatusDocument;
import org.unigrids.x2006.x04.services.tss.SubmitDocument;
import org.unigrids.x2006.x04.services.tss.SubmitResponseDocument;
import org.unigrids.x2006.x04.services.tss.SupportsReservationDocument;
import org.unigrids.x2006.x04.services.tss.TargetSystemPropertiesDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class TSSClient
extends BaseClientWithStatus {
    private static final Logger logger = Log.getLogger("unicore.client", TSSClient.class);
    private final TargetSystem tss = this.makeProxy(TargetSystem.class);
    private String name;

    public TSSClient(String endpointUrl, EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        super(endpointUrl, epr, sec);
    }

    public TSSClient(EndpointReferenceType epr, IClientConfiguration sec) throws Exception {
        this(epr.getAddress().getStringValue(), epr, sec);
    }

    public SubmitResponseDocument Submit(SubmitDocument in) throws Exception, AutoStartNotSupportedException {
        boolean autoStart;
        if (logger.isDebugEnabled()) {
            logger.debug("Calling target system service at " + this.getEPR().getAddress().getStringValue());
        }
        if ((autoStart = in.getSubmit().getAutoStartWhenReady()) && !this.checkVersion("1.4.1")) {
            throw new AutoStartNotSupportedException();
        }
        return this.tss.Submit(in);
    }

    public JobClient submit(SubmitDocument in) throws Exception {
        SubmitResponseDocument res = this.Submit(in);
        EndpointReferenceType epr = res.getSubmitResponse().getJobReference();
        return new JobClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
    }

    public TargetSystemPropertiesDocument getResourcePropertiesDocument() throws Exception {
        return TargetSystemPropertiesDocument.Factory.parse(this.GetResourcePropertyDocument().getGetResourcePropertyDocumentResponse().newInputStream());
    }

    public Calendar getUpSince() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemProperties().getUpSince();
    }

    public long getNumberOfJobs() throws Exception {
        return this.getResourcePropertiesDocument().getTargetSystemProperties().getTotalNumberOfJobs().longValue();
    }

    private List<EndpointReferenceType> getJobsWithoutEnumeration() throws Exception {
        EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemProperties().getJobReferenceArray();
        return Arrays.asList(eprs);
    }

    public List<EndpointReferenceType> getJobs() throws Exception {
        EnumerationClient<JobReferenceDocument> c = this.getJobReferenceEnumeration();
        if (c == null) {
            return this.getJobsWithoutEnumeration();
        }
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        Iterator<JobReferenceDocument> iter = c.iterator();
        while (iter.hasNext()) {
            res.add(iter.next().getJobReference());
        }
        return res;
    }

    public EnumerationClient<JobReferenceDocument> getJobReferenceEnumeration() throws Exception {
        EndpointReferenceType epr = this.getResourcePropertiesDocument().getTargetSystemProperties().getJobReferenceEnumeration();
        if (epr != null) {
            EnumerationClient<JobReferenceDocument> c = new EnumerationClient<JobReferenceDocument>(epr, this.getSecurityConfiguration(), JobReferenceDocument.type.getDocumentElementName());
            return c;
        }
        return null;
    }

    public List<EndpointReferenceType> getReservations() throws Exception {
        EndpointReferenceType[] eprs = this.getResourcePropertiesDocument().getTargetSystemProperties().getReservationReferenceArray();
        return Arrays.asList(eprs);
    }

    public List<EndpointReferenceType> getStorages() throws Exception {
        List<StorageReferenceDocument> smsRefs = this.getResourceProperty(StorageReferenceDocument.class);
        ArrayList<EndpointReferenceType> res = new ArrayList<EndpointReferenceType>();
        for (StorageReferenceDocument x : smsRefs) {
            res.add(x.getStorageReference().getStorageEndpointReference());
        }
        return res;
    }

    public StorageClient getStorage(AddressFilter<StorageClient> filter) throws Exception {
        List<StorageReferenceDocument> smsRefs = this.getResourceProperty(StorageReferenceDocument.class);
        for (StorageReferenceDocument x : smsRefs) {
            StorageClient c;
            EndpointReferenceType epr = x.getStorageReference().getStorageEndpointReference();
            if (!filter.accept(epr) || !filter.accept(c = new StorageClient(epr, this.getSecurityConfiguration()))) continue;
            return c;
        }
        return null;
    }

    public StorageClient getStorage(String name) throws Exception {
        return this.getStorage(new StorageFilters.ByName(name));
    }

    @Override
    public String[] getXlogins() throws Exception {
        String[] srs = null;
        SecurityType secT = this.getSecurityInfo();
        if (secT != null) {
            return super.getXlogins();
        }
        srs = this.getResourcePropertiesDocument().getTargetSystemProperties().getXloginArray();
        return srs;
    }

    @Override
    public String[] getXgroups() throws Exception {
        String[] srs = null;
        SecurityType secT = this.getSecurityInfo();
        if (secT != null) {
            return super.getXlogins();
        }
        srs = this.getResourcePropertiesDocument().getTargetSystemProperties().getXgroupArray();
        return srs;
    }

    public String getTargetSystemName() throws Exception {
        if (this.name == null) {
            this.name = this.getResourcePropertiesDocument().getTargetSystemProperties().getName();
        }
        return this.name;
    }

    public List<ApplicationResourceType> getApplications() throws Exception {
        ApplicationResourceType[] apps = this.getResourcePropertiesDocument().getTargetSystemProperties().getApplicationResourceArray();
        return Arrays.asList(apps);
    }

    public List<TextInfoType> getTextInfo() throws Exception {
        TextInfoType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getTextInfoArray();
        return Arrays.asList(info);
    }

    public List<SiteResourceType> getSiteSpecificResources() throws Exception {
        SiteResourceType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getSiteResourceArray();
        return Arrays.asList(info);
    }

    public List<AvailableResourceType> getAvailableResources() throws Exception {
        AvailableResourceType[] info = this.getResourcePropertiesDocument().getTargetSystemProperties().getAvailableResourceArray();
        return Arrays.asList(info);
    }

    public String getOperatingSystemInfo() throws Exception {
        OperatingSystemType os = this.getResourcePropertiesDocument().getTargetSystemProperties().getOperatingSystem();
        if (os == null) {
            return "UNKNOWN";
        }
        try {
            String name = os.getOperatingSystemType().getOperatingSystemName().toString();
            String version = os.getOperatingSystemVersion();
            String descrString = os.getDescription();
            return name + " " + (version != null ? version : "") + (descrString != null ? " (" + descrString + ")" : "");
        }
        catch (Exception e) {
            logger.warn("Error retrieving OS from target system.");
            return "UNKNOWN";
        }
    }

    public OperatingSystemType getOperatingSystem() throws Exception {
        OperatingSystemType os = this.getResourcePropertiesDocument().getTargetSystemProperties().getOperatingSystem();
        return os;
    }

    public static TSSClient getOrCreateTSS(String registryURL, IClientConfiguration sec) throws Exception {
        EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
        epr.addNewAddress().setStringValue(registryURL);
        RegistryClient c = new RegistryClient(registryURL, epr, sec);
        List<EndpointReferenceType> tss = c.listAccessibleServices(TargetSystem.TSS_PORT);
        if (tss.size() == 0) {
            return TSSClient.createTSS(c, sec);
        }
        if (tss.get(0).getAddress().getStringValue().contains("WorkflowTargetSystem")) {
            if (tss.size() > 0) {
                return new TSSClient(tss.get(1).getAddress().getStringValue(), tss.get(1), sec);
            }
            return TSSClient.createTSS(c, sec);
        }
        return new TSSClient(tss.get(0).getAddress().getStringValue(), tss.get(0), sec);
    }

    private static TSSClient createTSS(RegistryClient c, IClientConfiguration sec) throws Exception {
        List<EndpointReferenceType> tsfs = c.listAccessibleServices(TargetSystemFactory.TSF_PORT);
        if (tsfs.size() == 0) {
            return null;
        }
        return new TSFClient(tsfs.get(0).getAddress().getStringValue(), tsfs.get(0), sec).createTSS();
    }

    public boolean supportsReservation() throws Exception {
        SupportsReservationDocument resSupport = this.getSingleResourceProperty(SupportsReservationDocument.class);
        return resSupport.getSupportsReservation();
    }

    public EndpointReferenceType createReservation(ResourcesDocument resources, Calendar startTime) throws Exception {
        ResourceReservationRequestDocument req = ResourceReservationRequestDocument.Factory.newInstance();
        req.addNewResourceReservationRequest().setResources(resources.getResources());
        req.getResourceReservationRequest().setStartTime(startTime);
        TargetSystem tss = this.makeProxy(TargetSystem.class);
        ResourceReservationResponseDocument res = tss.ReserveResources(req);
        return res.getResourceReservationResponse().getReservationReference();
    }

    public ReservationClient createReservationClient(ResourcesDocument resources, Calendar startTime) throws Exception {
        EndpointReferenceType epr = this.createReservation(resources, startTime);
        ReservationClient client = new ReservationClient(epr.getAddress().getStringValue(), epr, this.getSecurityConfiguration());
        return client;
    }

    public void deleteJobs(Collection<String> jobs) throws Exception {
        if (this.checkVersion("1.7.0")) {
            DeleteJobsDocument djd = DeleteJobsDocument.Factory.newInstance();
            djd.addNewDeleteJobs();
            for (String j : jobs) {
                djd.getDeleteJobs().addJobID(j);
            }
            this.tss.DeleteJobs(djd);
        } else {
            for (String job : jobs) {
                String url = this.getUrl().split("TargetSystem")[0] + "JobManagement?res=" + job;
                EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
                epr.addNewAddress().setStringValue(url);
                JobClient j = new JobClient(epr, this.getSecurityConfiguration());
                j.destroy();
            }
        }
    }

    public Map<String, StatusType.Enum> getJobsStatus(Collection<String> jobs) throws Exception {
        HashMap<String, StatusType.Enum> result = new HashMap<String, StatusType.Enum>();
        if (this.checkVersion("1.7.0")) {
            GetJobsStatusDocument gjs = GetJobsStatusDocument.Factory.newInstance();
            gjs.addNewGetJobsStatus();
            for (String j : jobs) {
                gjs.getGetJobsStatus().addJobID(j);
            }
            GetJobsStatusResponseDocument response = this.tss.GetJobsStatus(gjs);
            for (JobStatusDocument.JobStatus s : response.getGetJobsStatusResponse().getJobStatusArray()) {
                result.put(s.getJobID(), s.getStatus());
            }
        } else {
            for (String job : jobs) {
                String url = this.getUrl().split("TargetSystem")[0] + "JobManagement?res=" + job;
                EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
                epr.addNewAddress().setStringValue(url);
                JobClient j = new JobClient(epr, this.getSecurityConfiguration());
                result.put(job, j.getStatus());
                j.destroy();
            }
        }
        return result;
    }
}

