/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import eu.unicore.security.HTTPAuthNTokens;
import eu.unicore.security.SignatureStatus;
import eu.unicore.security.etd.TrustDelegation;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityTokens
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String KEY = SecurityTokens.class.getName() + ".key";
    public static final String CTX_LOGIN_HTTP = HTTPAuthNTokens.class.getName() + ".key";
    public static final String CTX_SOAP_ACTION = "REQUEST.soapAction";
    public static final String CTX_SCOPE_KEY = SecurityTokens.class.getName() + ".scope";
    public static final String SCOPE_REQUEST = "request";
    private transient X509Certificate[] user;
    private transient X509Certificate[] consignor;
    private transient SignatureStatus signatureStatus = SignatureStatus.UNCHECKED;
    private transient Map<String, Object> context = new HashMap<String, Object>();
    private String userName;
    private String consignorName;
    private String clientIP;
    private boolean consignorTrusted;
    private boolean trustDelegationValidated;
    private List<TrustDelegation> tdTokens;
    private boolean supportProxy;
    private static final String lineSep = System.getProperty("line.separator");

    public SecurityTokens() {
        this(true);
    }

    public SecurityTokens(boolean supportProxy) {
        this.supportProxy = supportProxy;
    }

    public SecurityTokens clone() throws CloneNotSupportedException {
        SecurityTokens clone = (SecurityTokens)super.clone();
        return clone;
    }

    public void setConsignor(X509Certificate[] consignor) {
        this.consignor = consignor;
        this.consignorName = consignor[0].getSubjectX500Principal().getName();
    }

    public void setConsignorName(String consignorName) {
        this.consignorName = consignorName;
        this.consignor = null;
    }

    public X509Certificate[] getConsignor() {
        return this.consignor;
    }

    public X509Certificate getConsignorCertificate() {
        if (this.consignor != null) {
            if (this.supportProxy) {
                return ProxyUtils.getEndUserCertificate((X509Certificate[])this.consignor);
            }
            return this.consignor[0];
        }
        return null;
    }

    public void setUser(X509Certificate[] user) {
        this.user = user;
        X509Certificate userCert = this.getUserCertificate();
        if (userCert != null) {
            this.userName = userCert.getSubjectX500Principal().getName();
        }
    }

    public X509Certificate[] getUser() {
        return this.user;
    }

    public void setUserName(String userName) {
        this.userName = userName;
        this.user = null;
    }

    public X509Certificate getUserCertificate() {
        if (this.user == null) {
            return null;
        }
        return this.user[0];
    }

    public String getUserName() {
        if (this.userName != null) {
            return this.userName;
        }
        return null;
    }

    public String getConsignorName() {
        if (this.consignor != null) {
            return this.getConsignorCertificate().getSubjectX500Principal().getName();
        }
        return this.consignorName;
    }

    public X509Certificate getEffectiveUserCertificate() {
        if (this.user != null && this.consignorTrusted) {
            return this.getUserCertificate();
        }
        return this.getConsignorCertificate();
    }

    public String getEffectiveUserName() {
        if (this.userName != null && this.consignorTrusted) {
            return this.getUserName();
        }
        return this.getConsignorName();
    }

    public String toString() {
        String res;
        StringBuilder sb = new StringBuilder();
        if (this.userName != null) {
            sb.append("User name: ").append(X500NameUtils.getReadableForm((String)this.userName)).append(lineSep);
        }
        if (this.user != null) {
            sb.append("(have user cert)").append(lineSep);
            if (ProxyUtils.isProxy((X509Certificate[])this.user)) {
                sb.append("User certificate is a proxy certificate");
                if (this.supportProxy) {
                    sb.append(lineSep);
                } else {
                    sb.append(" but proxy handling is NOT enabled" + lineSep);
                }
            }
        }
        if (this.consignorName != null) {
            String consignor = this.getConsignorName();
            sb.append("Consignor DN: ").append(X500NameUtils.getReadableForm((String)consignor));
            sb.append(lineSep);
            if (this.consignor != null && ProxyUtils.isProxy((X509Certificate[])this.consignor)) {
                sb.append("Consignor's certificate is a proxy certificate");
                if (this.supportProxy) {
                    sb.append(lineSep);
                } else {
                    sb.append(" but proxy handling is NOT enabled" + lineSep);
                }
            }
        }
        sb.append("Delegation to consignor status: " + this.isConsignorTrusted() + ", core delegation status: " + this.isTrustDelegationValidated());
        if (this.signatureStatus != null) {
            sb.append(lineSep + "Message signature status: ").append(this.signatureStatus.toString());
        }
        if (this.clientIP != null) {
            sb.append(lineSep + "Client's original IP: ").append(this.clientIP);
        }
        if ((res = sb.toString()).length() == 0) {
            return super.toString() + " [no details available]";
        }
        return res;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public SignatureStatus getMessageSignatureStatus() {
        return this.signatureStatus;
    }

    public void setMessageSignatureStatus(SignatureStatus status) {
        this.signatureStatus = status;
    }

    public boolean isConsignorUsingProxy() {
        if (this.consignor != null && this.supportProxy) {
            return ProxyUtils.isProxy((X509Certificate[])this.consignor);
        }
        return false;
    }

    public String getConsignorRealName() {
        if (this.consignor != null) {
            return this.consignor[0].getSubjectX500Principal().getName();
        }
        return this.consignorName;
    }

    public boolean isConsignorTrusted() {
        return this.consignorTrusted;
    }

    public boolean isSupportingProxy() {
        return this.supportProxy;
    }

    public void setConsignorTrusted(boolean consignorTrusted) {
        this.consignorTrusted = consignorTrusted;
    }

    public boolean isTrustDelegationValidated() {
        return this.trustDelegationValidated;
    }

    public void setTrustDelegationValidated(boolean validTrustDelegation) {
        this.trustDelegationValidated = validTrustDelegation;
    }

    public void setTrustDelegationTokens(List<TrustDelegation> tdTokens) {
        this.tdTokens = tdTokens;
    }

    public List<TrustDelegation> getTrustDelegationTokens() {
        return this.tdTokens;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public boolean equals(Object otherO) {
        if (otherO == null || !(otherO instanceof SecurityTokens)) {
            return false;
        }
        SecurityTokens other = (SecurityTokens)otherO;
        if (!other.getMessageSignatureStatus().equals((Object)this.getMessageSignatureStatus())) {
            return false;
        }
        if (other.isConsignorTrusted() != this.isConsignorTrusted()) {
            return false;
        }
        if (other.isTrustDelegationValidated() != this.isTrustDelegationValidated()) {
            return false;
        }
        if (other.getConsignorName() == null ? this.getConsignorName() != null : !other.getConsignorName().equals(this.getConsignorName())) {
            return false;
        }
        if (other.getEffectiveUserName() == null ? this.getEffectiveUserName() != null : !other.getEffectiveUserName().equals(this.getEffectiveUserName())) {
            return false;
        }
        if (other.supportProxy != this.supportProxy) {
            return false;
        }
        return !(other.getClientIP() == null ? this.getClientIP() != null : !other.getClientIP().equals(this.getClass()));
    }

    public int hashCode() {
        String cons = this.getConsignorName();
        int consignorHash = cons == null ? 0 : cons.hashCode();
        String user = this.getEffectiveUserName();
        int userHash = user == null ? 0 : user.hashCode();
        return this.getMessageSignatureStatus().hashCode() ^ (this.isConsignorTrusted() ? 1 : 0) ^ (this.isTrustDelegationValidated() ? 2 : 0) ^ consignorHash ^ userHash;
    }
}

