/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil;

import eu.unicore.security.dsig.DOMUtilities;
import eu.unicore.security.wsutil.DSigDecider;
import eu.unicore.security.wsutil.client.LogInMessageHandler;
import eu.unicore.util.Log;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class DSigParseInHandler
extends AbstractSoapInterceptor {
    protected static final Logger logger = Log.getLogger("unicore.security.dsig", DSigParseInHandler.class);
    public static final String DOCUMENT_DOM_KEY = DSigParseInHandler.class.getName() + "_DOM";
    private DSigDecider decider;

    public DSigParseInHandler(DSigDecider decider) {
        super("read");
        this.getBefore().add(ReadHeadersInterceptor.class.getName());
        this.getBefore().add(LogInMessageHandler.class.getName());
        this.decider = decider;
    }

    public void handleMessage(SoapMessage message) {
        if (this.decider == null || this.decider.isMessageDSigCandidate((Message)message)) {
            try {
                this.buildDOM((Message)message);
            }
            catch (Exception ex) {
                throw new Fault((Throwable)ex);
            }
        }
    }

    protected void buildDOM(Message message) throws XMLStreamException, ParserConfigurationException {
        Document doc;
        logger.debug("Creating DOM from SOAP message");
        long start = System.currentTimeMillis();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        XMLStreamReader xmlStreamReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xmlStreamReader == null) {
            logger.warn("XML Stream reader content is not available for the message content. Can not build DOM");
            return;
        }
        try {
            doc = StaxUtils.read((DocumentBuilder)dbf.newDocumentBuilder(), (XMLStreamReader)xmlStreamReader, (boolean)false);
        }
        catch (XMLStreamException e1) {
            logger.warn("Can't parse XML stream as W3C DOM: " + e1.getMessage());
            throw e1;
        }
        catch (ParserConfigurationException e1) {
            logger.warn("Can't create W3C DOM document builder: " + e1.getMessage());
            throw e1;
        }
        if (logger.isTraceEnabled()) {
            DOMUtilities.logDOMAsRawString("SOAP message DOM is: \n", doc, logger);
        }
        W3CDOMStreamReader replayStream = new W3CDOMStreamReader(doc.getDocumentElement());
        message.setContent(XMLStreamReader.class, (Object)replayStream);
        message.put((Object)DOCUMENT_DOM_KEY, (Object)doc);
        long stop = System.currentTimeMillis();
        logger.debug("DOM creation time: " + (stop - start));
    }
}

