/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.base;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.DiscoveryService;
import org.wso2.carbon.base.UnloadTenantTask;

public final class CarbonContextHolderBase {
    private int tenantId = -1;
    private static final int CARBON_AUTHENTICATION_UTIL_INDEX = 5;
    private static final String CARBON_AUTHENTICATION_UTIL_CLASS = "org.wso2.carbon.core.services.util.CarbonAuthenticationUtil";
    private static final int CARBON_AUTHENTICATION_HANDLER_INDEX = 5;
    private static final String CARBON_AUTHENTICATION_HANDLER_CLASS = "org.wso2.carbon.server.admin.module.handler.AuthenticationHandler";
    private String username;
    private String tenantDomain;
    private Map<String, Object> properties;
    private static List<UnloadTenantTask> unloadTenantTasks = null;
    private static final Log log = LogFactory.getLog(CarbonContextHolderBase.class);
    private static final AtomicReference<DiscoveryService> discoveryServiceProvider = new AtomicReference();
    private static ThreadLocal<CarbonContextHolderBase> currentContextHolderBase = new ThreadLocal<CarbonContextHolderBase>(){

        @Override
        protected CarbonContextHolderBase initialValue() {
            return new CarbonContextHolderBase();
        }
    };
    private static ThreadLocal<Stack<CarbonContextHolderBase>> parentContextHolderBaseStack = new ThreadLocal<Stack<CarbonContextHolderBase>>(){

        @Override
        protected Stack<CarbonContextHolderBase> initialValue() {
            return new Stack<CarbonContextHolderBase>();
        }
    };

    public static DiscoveryService getDiscoveryServiceProvider() {
        return discoveryServiceProvider.get();
    }

    public static void setDiscoveryServiceProvider(DiscoveryService discoveryServiceProvider) {
        CarbonContextHolderBase.discoveryServiceProvider.set(discoveryServiceProvider);
    }

    public static CarbonContextHolderBase getCurrentCarbonContextHolderBase() {
        return currentContextHolderBase.get();
    }

    public static synchronized void registerUnloadTenantTask(UnloadTenantTask unloadTenantTask) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unload Tenant Task: " + unloadTenantTask.getClass().getName() + " was " + "registered."));
        }
        unloadTenantTasks.add(unloadTenantTask);
    }

    public static void unloadTenant(int tenantId) {
        log.debug((Object)"Started unloading tenant");
        for (UnloadTenantTask unloadTenantTask : unloadTenantTasks) {
            unloadTenantTask.cleanup(tenantId);
        }
        log.info((Object)"Completed unloading tenant");
    }

    public void startTenantFlow() {
        log.trace((Object)"Starting tenant flow.");
        parentContextHolderBaseStack.get().push(new CarbonContextHolderBase(this));
        this.restore(null);
    }

    public void endTenantFlow() {
        log.trace((Object)"Stopping tenant flow.");
        this.restore(parentContextHolderBaseStack.get().pop());
    }

    private CarbonContextHolderBase() {
        this.tenantId = -1;
        this.username = null;
        this.tenantDomain = null;
        this.properties = new HashMap<String, Object>();
    }

    public CarbonContextHolderBase(CarbonContextHolderBase carbonContextHolder) {
        this.tenantId = carbonContextHolder.tenantId;
        this.username = carbonContextHolder.username;
        this.tenantDomain = carbonContextHolder.tenantDomain;
        this.properties = new HashMap<String, Object>(carbonContextHolder.properties);
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        try {
            StackTraceElement[] traces;
            if (this.tenantId == -1 || this.tenantId == -1234) {
                this.tenantId = tenantId;
            } else if (this.tenantId != tenantId && !this.isAllowedToChangeTenantDomain(traces = Thread.currentThread().getStackTrace())) {
                throw new IllegalStateException("Trying to set the domain from " + this.tenantId + " to " + tenantId);
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String domain) {
        try {
            StackTraceElement[] traces;
            if (this.tenantDomain == null || this.tenantDomain == "carbon.super") {
                this.tenantDomain = domain;
            } else if (!this.tenantDomain.equals(domain) && !this.isAllowedToChangeTenantDomain(traces = Thread.currentThread().getStackTrace())) {
                throw new IllegalStateException("Trying to set the domain from " + this.tenantDomain + " to " + domain);
            }
        }
        catch (IllegalStateException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object value) {
        log.trace((Object)("Setting Property: " + name));
        this.properties.put(name, value);
    }

    private void cleanupProperties() {
        if (this.properties != null) {
            log.trace((Object)"Cleaning up properties.");
            this.properties.clear();
        }
    }

    private boolean isAllowedToChangeTenantDomain(StackTraceElement[] traces) {
        boolean allowChange = false;
        if (traces.length > 5 && traces[5].getClassName().equals(CARBON_AUTHENTICATION_UTIL_CLASS)) {
            allowChange = true;
        } else if (traces.length > 5 && traces[5].getClassName().equals(CARBON_AUTHENTICATION_HANDLER_CLASS)) {
            allowChange = true;
        }
        return allowChange;
    }

    public static void destroyCurrentCarbonContextHolder() {
        currentContextHolderBase.remove();
        parentContextHolderBaseStack.remove();
    }

    private void restore(CarbonContextHolderBase carbonContextHolder) {
        if (carbonContextHolder != null) {
            this.tenantId = carbonContextHolder.tenantId;
            this.username = carbonContextHolder.username;
            this.tenantDomain = carbonContextHolder.tenantDomain;
            this.properties = new HashMap<String, Object>(carbonContextHolder.properties);
        } else {
            this.tenantId = -1;
            this.username = null;
            this.tenantDomain = null;
            this.properties = new HashMap<String, Object>();
        }
    }

    static {
        unloadTenantTasks = new LinkedList<UnloadTenantTask>();
        CarbonContextHolderBase.registerUnloadTenantTask(new CarbonContextCleanupTask());
    }

    private static class CarbonContextCleanupTask
    implements UnloadTenantTask<CarbonContextHolderBase> {
        private Map<Integer, ArrayList<WeakReference<CarbonContextHolderBase>>> contextHolderList = new ConcurrentHashMap<Integer, ArrayList<WeakReference<CarbonContextHolderBase>>>();

        private CarbonContextCleanupTask() {
        }

        @Override
        public void register(int tenantId, CarbonContextHolderBase contextHolderBase) {
            ArrayList<WeakReference<CarbonContextHolderBase>> list = this.contextHolderList.get(tenantId);
            if (list == null) {
                list = new ArrayList();
                list.add(new WeakReference<CarbonContextHolderBase>(contextHolderBase));
                this.contextHolderList.put(tenantId, list);
            } else {
                list.add(new WeakReference<CarbonContextHolderBase>(contextHolderBase));
            }
        }

        @Override
        public void cleanup(int tenantId) {
            ArrayList<WeakReference<CarbonContextHolderBase>> list = this.contextHolderList.remove(tenantId);
            if (list != null) {
                for (WeakReference<CarbonContextHolderBase> carbonContextHolderBaseRef : list) {
                    CarbonContextHolderBase carbonContextHolderBase = (CarbonContextHolderBase)carbonContextHolderBaseRef.get();
                    if (carbonContextHolderBase == null) continue;
                    carbonContextHolderBase.cleanupProperties();
                }
                list.clear();
            }
        }
    }
}

