/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.handler;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import javax.xml.ws.handler.soap.SOAPHandler;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.spi.handler.BaseHandlerResolver;
import org.apache.axis2.jaxws.spi.handler.LifecycleManager;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerResolverImpl
extends BaseHandlerResolver {
    private static Log log = LogFactory.getLog(HandlerResolverImpl.class);

    public HandlerResolverImpl(String filePath) {
        super(filePath);
    }

    public HandlerResolverImpl(URI fileURI) {
        this(fileURI.toString());
    }

    public HandlerResolverImpl(File file) {
        this(file.toURI());
    }

    @Override
    public List<Handler> getHandlerChain(PortInfo portinfo) {
        Iterator<HandlerChainType> it;
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Iterator<HandlerChainType> iterator = it = this.handlerChainsType == null ? null : this.handlerChainsType.getHandlerChain().iterator();
        while (it != null && it.hasNext()) {
            HandlerChainType handlerChainType = it.next();
            if (!HandlerResolverImpl.chainResolvesToPort(handlerChainType, portinfo)) continue;
            List<HandlerType> handlerTypeList = handlerChainType.getHandler();
            for (HandlerType handlerType : handlerTypeList) {
                String portHandler = handlerType.getHandlerClass().getValue();
                Handler handler = null;
                try {
                    handler = this.createHandlerInstance(HandlerResolverImpl.loadClass(portHandler));
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
                if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                    log.debug((Object)("Successfully instantiated the class: " + handler.getClass()));
                }
                if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((LogicalHandler)handler);
                    continue;
                }
                if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                    handlers.add((SOAPHandler)handler);
                    continue;
                }
                if (Handler.class.isAssignableFrom(handler.getClass())) {
                    throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainErr1", handler.getClass().getName()));
                }
                throw ExceptionFactory.makeWebServiceException(Messages.getMessage("handlerChainErr2", handler.getClass().getName()));
            }
        }
        return handlers;
    }

    private Handler createHandlerInstance(Class handlerClass) throws LifecycleException {
        if (handlerClass == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("createHandlerInstanceErr"));
        }
        Object object = null;
        try {
            object = handlerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
        LifecycleManager manager = new LifecycleManager(object);
        manager.invokePostConstruct();
        return object;
    }
}

