/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index.oracle;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.lucene.store.jdbc.index.FileJdbcIndexOutput;
import org.apache.lucene.store.jdbc.index.oracle.OracleIndexOutputHelper;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public class OracleFileJdbcIndexOutput
extends FileJdbcIndexOutput {
    public void close() throws IOException {
        this.flush();
        final long length = this.length();
        this.doBeforeClose();
        String sqlInsert = OracleIndexOutputHelper.sqlInsert(this.jdbcDirectory.getTable());
        this.jdbcDirectory.getJdbcTemplate().executeUpdate(sqlInsert, new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, OracleFileJdbcIndexOutput.this.name);
                ps.setLong(2, length);
                ps.setBoolean(3, false);
            }
        });
        String sqlUpdate = OracleIndexOutputHelper.sqlUpdate(this.jdbcDirectory.getTable());
        this.jdbcDirectory.getJdbcTemplate().executeSelect(sqlUpdate, new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, OracleFileJdbcIndexOutput.this.name);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object execute(ResultSet rs) throws Exception {
                OutputStream os = null;
                try {
                    rs.next();
                    os = OracleIndexOutputHelper.getBlobOutputStream(rs);
                    InputStream is = OracleFileJdbcIndexOutput.this.openInputStream();
                    byte[] buffer = new byte[1000];
                    int bytesRead = 0;
                    while ((bytesRead = is.read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                    Object var6_6 = null;
                    return var6_6;
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
        });
        this.doAfterClose();
    }
}

