/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.converter.basic.format;

import java.text.ParseException;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.basic.format.Formatter;
import org.compass.core.converter.basic.format.FormatterFactory;

public class ThreadSafeFormat
implements Formatter {
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient Formatter[] pool;
    private int nextAvailable = 0;
    private final Object mutex = new Object();
    private final FormatterFactory formatterFactory;

    public ThreadSafeFormat(int initialPoolSize, int maxPoolSize, FormatterFactory formatterFactory) {
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.formatterFactory = formatterFactory;
    }

    public boolean isThreadSafe() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Object obj) {
        Formatter format = this.fetchFromPool();
        try {
            String string = format.format(obj);
            return string;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(String str) throws ParseException {
        Formatter format = this.fetchFromPool();
        try {
            Object object = format.parse(str);
            return object;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Formatter fetchFromPool() {
        Formatter result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new Formatter[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(this.formatterFactory.create());
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new ConversionException("Interrupted whilst waiting for a free item in the pool", e);
                }
            }
            result = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (result == null) {
            result = this.formatterFactory.create();
            this.putInPool(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(Formatter format) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = format;
            this.mutex.notify();
        }
    }
}

