/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.highlighter;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.config.CompassSettings;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.engine.highlighter.DefaultLuceneHighlighterFactory;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterFactory;
import org.compass.core.lucene.engine.highlighter.LuceneHighlighterSettings;

public class LuceneHighlighterManager {
    private static final Log log = LogFactory.getLog(LuceneHighlighterManager.class);
    private LuceneHighlighterSettings defaultHighlighterSettings;
    private Map<String, LuceneHighlighterSettings> highlightersSettings = new HashMap<String, LuceneHighlighterSettings>();

    public void configure(CompassSettings settings) throws SearchEngineException {
        Map<String, CompassSettings> highlighterSettingGroups = settings.getSettingGroups("compass.engine.highlighter");
        for (String highlighterName : highlighterSettingGroups.keySet()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Building highlighter [" + highlighterName + "]"));
            }
            LuceneHighlighterSettings highlighter = this.buildHighlighter(highlighterName, highlighterSettingGroups.get(highlighterName));
            this.highlightersSettings.put(highlighterName, highlighter);
        }
        this.defaultHighlighterSettings = this.highlightersSettings.get("default");
        if (this.defaultHighlighterSettings == null) {
            this.defaultHighlighterSettings = this.buildHighlighter("default", new CompassSettings(settings.getClassLoader()));
            this.highlightersSettings.put("default", this.defaultHighlighterSettings);
        }
    }

    private LuceneHighlighterSettings buildHighlighter(String highlighterName, CompassSettings settings) {
        LuceneHighlighterFactory highlighterFactory = (LuceneHighlighterFactory)settings.getSettingAsInstance("factory", DefaultLuceneHighlighterFactory.class.getName());
        return highlighterFactory.createHighlighterSettings(highlighterName, settings);
    }

    public LuceneHighlighterSettings getDefaultHighlighterSettings() {
        return this.defaultHighlighterSettings;
    }

    public LuceneHighlighterSettings getHighlighterSettings(String highlighterName) {
        return this.highlightersSettings.get(highlighterName);
    }

    public LuceneHighlighterSettings getHighlighterSettingsMustExists(String highlighterName) {
        LuceneHighlighterSettings highlighterSettings = this.highlightersSettings.get(highlighterName);
        if (highlighterSettings == null) {
            throw new SearchEngineException("No highlighter is defined for highlighter name [" + highlighterName + "]");
        }
        return highlighterSettings;
    }
}

