/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.transaction.readcommitted;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.engine.transaction.readcommitted.TransIndex;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;

public class TransIndexManager
implements CompassConfigurable {
    private LuceneSearchEngineFactory searchEngineFactory;
    private CompassSettings settings;
    private Map<String, TransIndex> transIndexMap = new HashMap<String, TransIndex>();

    public TransIndexManager(LuceneSearchEngineFactory searchEngineFactory) {
        this.searchEngineFactory = searchEngineFactory;
    }

    public void configure(CompassSettings settings) throws CompassException {
        this.settings = settings;
    }

    public void create(InternalResource resource, Analyzer analyzer) throws IOException {
        this.getTransIndex(resource.getSubIndex()).create(resource, analyzer);
    }

    public void update(InternalResource resource, Analyzer analyzer) throws IOException {
        this.getTransIndex(resource.getSubIndex()).update(resource, analyzer);
    }

    public void delete(ResourceKey resourceKey) throws IOException {
        if (!this.transIndexMap.containsKey(resourceKey.getSubIndex())) {
            return;
        }
        this.getTransIndex(resourceKey.getSubIndex()).delete(resourceKey);
    }

    public IndexReader getReader(String subIndex) throws IOException {
        return this.transIndexMap.get(subIndex).getReader();
    }

    public IndexSearcher getSearcher(String subIndex) throws IOException {
        return this.transIndexMap.get(subIndex).getSearcher();
    }

    public Directory getDirectory(String subIndex) {
        return this.transIndexMap.get(subIndex).getDirectory();
    }

    public boolean hasTransactions() {
        return !this.transIndexMap.isEmpty();
    }

    public boolean hasTransIndex(String subIndex) {
        return this.transIndexMap.containsKey(subIndex);
    }

    public void commit() throws IOException {
        for (TransIndex transIndex : this.transIndexMap.values()) {
            transIndex.commit();
        }
    }

    public void commit(String subIndex) throws IOException {
        this.transIndexMap.get(subIndex).commit();
    }

    public void close(String subIndex) throws IOException {
        TransIndex transIndex = this.transIndexMap.remove(subIndex);
        if (transIndex != null) {
            transIndex.close();
        }
    }

    private TransIndex getTransIndex(String subIndex) {
        TransIndex transIndex = this.transIndexMap.get(subIndex);
        if (transIndex == null) {
            transIndex = new TransIndex(this.searchEngineFactory, subIndex);
            transIndex.configure(this.settings);
            this.transIndexMap.put(subIndex, transIndex);
        }
        return transIndex;
    }
}

