/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.hibernate;

import java.util.Hashtable;
import java.util.Map;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.config.CompassSettings;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransactionFactory;
import org.compass.core.transaction.InternalCompassTransaction;
import org.compass.gps.device.hibernate.HibernateSyncTransaction;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionImplementor;

public class HibernateSyncTransactionFactory
extends AbstractTransactionFactory {
    private static ThreadLocal sessionFactoryHolder = new ThreadLocal();
    private static String sessionFactoryKey = HibernateSyncTransactionFactory.class.getName();
    private SessionFactory sessionFactory;
    private transient Map currentSessionMap = new Hashtable();

    public static void setSessionFactory(SessionFactory sessionFactory) {
        sessionFactoryHolder.set(sessionFactory);
    }

    protected void doConfigure(CompassSettings settings) {
        this.sessionFactory = (SessionFactory)sessionFactoryHolder.get();
        if (this.sessionFactory == null) {
            this.sessionFactory = (SessionFactory)settings.getRegistry(sessionFactoryKey);
        }
        if (this.sessionFactory != null) {
            settings.setRegistry(sessionFactoryKey, this.sessionFactory);
        }
        sessionFactoryHolder.set(null);
    }

    protected boolean isWithinExistingTransaction(InternalCompassSession session) throws CompassException {
        return ((SessionImplementor)this.sessionFactory.getCurrentSession()).isTransactionInProgress();
    }

    protected InternalCompassTransaction doBeginTransaction(InternalCompassSession session, CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        HibernateSyncTransaction tr = new HibernateSyncTransaction(this.sessionFactory, this.commitBeforeCompletion, this);
        tr.begin(session, transactionIsolation);
        return tr;
    }

    protected InternalCompassTransaction doContinueTransaction(InternalCompassSession session) throws CompassException {
        HibernateSyncTransaction tr = new HibernateSyncTransaction(this.sessionFactory, this.commitBeforeCompletion, this);
        tr.join(session);
        return tr;
    }

    public CompassSession getTransactionBoundSession() throws CompassException {
        Session session = this.sessionFactory.getCurrentSession();
        if (!((SessionImplementor)session).isTransactionInProgress()) {
            return null;
        }
        return (CompassSession)this.currentSessionMap.get(session.getTransaction());
    }

    protected void doBindSessionToTransaction(CompassTransaction tr, CompassSession session) throws CompassException {
        this.currentSessionMap.put(this.sessionFactory.getCurrentSession().getTransaction(), session);
    }

    public void unbindSessionFromTransaction(Transaction transaction) {
        this.currentSessionMap.remove(transaction);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

