/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.traverse;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.axiom.om.OMNode;

public abstract class OMAbstractIterator
implements Iterator {
    private OMNode currentNode;
    private OMNode nextNode;
    private boolean noMoreNodes;
    private boolean nextCalled;

    public OMAbstractIterator(OMNode firstNode) {
        if (firstNode == null) {
            this.noMoreNodes = true;
        } else {
            this.nextNode = firstNode;
        }
    }

    protected abstract OMNode getNextNode(OMNode var1);

    @Override
    public boolean hasNext() {
        if (this.noMoreNodes) {
            return false;
        }
        if (this.nextNode != null) {
            return true;
        }
        this.nextNode = this.getNextNode(this.currentNode);
        this.noMoreNodes = this.nextNode == null;
        return !this.noMoreNodes;
    }

    public Object next() {
        if (this.hasNext()) {
            this.currentNode = this.nextNode;
            this.nextNode = null;
            this.nextCalled = true;
            return this.currentNode;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        if (!this.nextCalled) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.hasNext();
        this.currentNode.detach();
        this.nextCalled = false;
    }
}

