/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.common.UserStore;
import org.wso2.carbon.user.core.dto.RoleDTO;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.DatabaseUtil;
import org.wso2.carbon.utils.xml.StringUtils;

public final class UserCoreUtil {
    private static Log log = LogFactory.getLog(UserCoreUtil.class);
    private static Boolean isEmailUserName;
    private static Boolean isCrossTenantUniqueUserName;
    private static RealmService realmService;
    private static final String DUMMY_VALUE = "dummy";
    private static ThreadLocal threadLocalToSetDomain;

    public static String[] combineArrays(String[] arr1, String[] arr2) throws UserStoreException {
        if (arr1 == null || arr1.length == 0) {
            return arr2;
        }
        if (arr2 == null || arr2.length == 0) {
            return arr1;
        }
        Object[] newArray = new String[arr1.length + arr2.length];
        for (int i = 0; i < arr1.length; ++i) {
            newArray[i] = arr1[i];
        }
        int j = 0;
        for (int i = arr1.length; i < newArray.length; ++i) {
            Arrays.toString(newArray);
            newArray[i] = arr2[j];
            ++j;
        }
        return newArray;
    }

    public static String[] combine(String[] array, List<String> list) throws UserStoreException {
        String[] newArray = array;
        if (list.size() > 0) {
            newArray = new String[list.size() + array.length];
            int i = 0;
            Iterator<String> ite = list.iterator();
            while (ite.hasNext()) {
                String name;
                newArray[i] = name = ite.next();
                ++i;
            }
            String[] arr$ = array;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String name;
                newArray[i] = name = arr$[i$];
                ++i;
            }
        }
        return newArray;
    }

    public static String[] optimizePermissions(String[] rawResourcePath) {
        Arrays.sort(rawResourcePath);
        int index = 0;
        ArrayList<String> lst = new ArrayList<String>();
        block0: while (index < rawResourcePath.length) {
            String shortestString = rawResourcePath[index];
            lst.add(shortestString);
            ++index;
            Pattern p = Pattern.compile("(.*)/.*$");
            while (index < rawResourcePath.length) {
                Matcher m = p.matcher(rawResourcePath[index]);
                if (!m.find()) continue;
                String s = m.group(1);
                if (!s.equals(shortestString)) continue block0;
                ++index;
            }
        }
        return lst.toArray(new String[lst.size()]);
    }

    public static Boolean getIsEmailUserName() {
        return isEmailUserName;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    public static void setRealmService(RealmService realmService) {
        UserCoreUtil.realmService = realmService;
    }

    public static Boolean getIsCrossTenantUniqueUserName() {
        return isCrossTenantUniqueUserName;
    }

    public static String getPasswordToStore(String password, String passwordHashMethod, boolean isKdcEnabled) throws UserStoreException {
        if (isKdcEnabled) {
            return password;
        }
        String passwordToStore = password;
        if (passwordHashMethod != null) {
            if (passwordHashMethod.equals("PLAIN_TEXT")) {
                return passwordToStore;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(passwordHashMethod);
                byte[] digestValue = messageDigest.digest(password.getBytes());
                passwordToStore = "{" + passwordHashMethod + "}" + Base64.encode((byte[])digestValue);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UserStoreException("Invalid hashMethod", e);
            }
        }
        return passwordToStore;
    }

    public static boolean isKdcEnabled(RealmConfiguration realmConfig) {
        String stringKdcEnabled = realmConfig.getUserStoreProperty("kdcEnabled");
        if (stringKdcEnabled != null) {
            return Boolean.parseBoolean(stringKdcEnabled);
        }
        return false;
    }

    public static String getDummyPassword() {
        Random rand = new Random();
        return DUMMY_VALUE + rand.nextInt(999999);
    }

    public static boolean isContain(String name, String[] names) {
        if (name == null || names == null || names.length == 0) {
            return false;
        }
        for (String n : names) {
            if (!name.equalsIgnoreCase(n)) continue;
            return true;
        }
        return false;
    }

    public static String getPolicyFriendlyRandomPassword(String username) throws UserStoreException {
        return UserCoreUtil.getPolicyFriendlyRandomPassword(username, 8);
    }

    public static String getPolicyFriendlyRandomPassword(String username, int length) throws UserStoreException {
        if (length < 8 || length > 50) {
            length = 12;
        }
        char[] chars = new char[]{'E', 'F', 'G', 'H', 'J', 'K', 'L', 'N', 'P', 'Q', 'U', 'V', 'W', 'X', 'Y', 'Z', 'e', 'f', 'g', 'h', 'j', 'k', 'l', 'n', 'p', 'q', 'u', 'v', 'w', 'x', 'y', 'z', '~', '!', '@', '#', '$', '%', '^', '&', '*', '_', '-', '+', '='};
        char[] invalidChars = username.toCharArray();
        StringBuffer passwordFeed = new StringBuffer();
        for (char invalidCha : invalidChars) {
            for (char cha : chars) {
                if (cha == invalidCha) continue;
                passwordFeed.append(cha);
            }
        }
        String passwordChars = passwordFeed.toString();
        char[] password = new char[length];
        String randomNum = null;
        try {
            SecureRandom prng = SecureRandom.getInstance("SHA1PRNG");
            for (int i = 0; i < length; ++i) {
                password[i] = passwordChars.charAt(prng.nextInt(passwordFeed.length()));
            }
            randomNum = new Integer(prng.nextInt()).toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)"Error while creating the random password.", (Throwable)e);
            throw new UserStoreException("Error while creating the random password.", e);
        }
        return new String(password).concat(randomNum);
    }

    public static RoleDTO[] convertRoleNamesToRoleDTO(String[] roleNames, String domain) {
        if (roleNames != null && roleNames.length != 0) {
            ArrayList<RoleDTO> dtos = new ArrayList<RoleDTO>();
            for (String roleName : roleNames) {
                RoleDTO dto = new RoleDTO();
                dto.setRoleName(roleName);
                dto.setDomainName(domain);
                dtos.add(dto);
            }
            return dtos.toArray(new RoleDTO[dtos.size()]);
        }
        return null;
    }

    public static void setDomainInThreadLocal(String domain) {
        if (domain != null && !"PRIMARY".equalsIgnoreCase(domain)) {
            threadLocalToSetDomain.set(domain.toUpperCase());
        }
    }

    public static String getDomainFromThreadLocal() {
        return (String)threadLocalToSetDomain.get();
    }

    public static String removeDomainFromName(String name) {
        int index = name.indexOf("/");
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public static String formatSearchBase(String base, String entryName, String nameAttribute) {
        entryName = UserCoreUtil.removeDomainFromName(entryName);
        String key = nameAttribute + "=" + entryName;
        if (base.indexOf(key) >= 0) {
            String[] arr = base.split(key);
            base = "";
            for (String s : arr) {
                base = base + s;
            }
            if (base.startsWith(",")) {
                base = base.substring(1);
            }
            if (base.endsWith(",")) {
                base = base.substring(0, base.length() - 1);
            }
            return base;
        }
        return base;
    }

    public static String removeDistinguishedName(String name) {
        int index = name.indexOf("@");
        if (index >= 0) {
            name = name.substring(0, index);
        }
        return name;
    }

    public static String addInternalDomainName(String name) {
        if (name.indexOf("/") < 0) {
            name = "Internal/" + name;
        }
        return name;
    }

    public static String setDomainToUpperCase(String name) {
        int index = name.indexOf("/");
        if (index > 0) {
            String domain = name.substring(0, index);
            name = domain.toUpperCase() + name.substring(index);
        }
        return name;
    }

    public static String addDomainToName(String name, String domainName) {
        if (name.indexOf("/") < 0 && !"PRIMARY".equalsIgnoreCase(domainName) && domainName != null) {
            domainName = domainName.toUpperCase() + "/";
            name = domainName + name;
        }
        return name;
    }

    public static String addTenantDomainToEntry(String entry, String tenantDomain) {
        if (!StringUtils.isEmpty((String)tenantDomain)) {
            entry = entry.split("@")[0];
            return entry + "@" + tenantDomain;
        }
        return entry;
    }

    public static String getDomainName(RealmConfiguration realmConfig) {
        return realmConfig.getUserStoreProperty("DomainName");
    }

    public static String[] addDomainToNames(String[] names, String domainName) {
        if (domainName != null) {
            domainName = domainName.toUpperCase();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        if (names != null && names.length != 0) {
            for (String name : names) {
                if (name.indexOf("/") < 0 && !"PRIMARY".equalsIgnoreCase(domainName) && domainName != null) {
                    name = UserCoreUtil.addDomainToName(name, domainName);
                    namesList.add(name);
                    continue;
                }
                namesList.add(name);
            }
        }
        if (namesList.size() != 0) {
            return namesList.toArray(new String[namesList.size()]);
        }
        return names;
    }

    public static String[] removeDomainFromNames(String[] names) {
        ArrayList<String> nameList = new ArrayList<String>();
        if (names != null && names.length != 0) {
            for (String name : names) {
                int index = name.indexOf("/");
                if (index <= 0) continue;
                String domain = name.substring(0, index);
                if (!"Internal".equalsIgnoreCase(domain)) {
                    nameList.add(name.substring(index + 1));
                    continue;
                }
                nameList.add(name);
            }
        }
        if (nameList.size() != 0) {
            return nameList.toArray(new String[nameList.size()]);
        }
        return names;
    }

    public static String getCombinedName(String domainName, String userName, String displayName) {
        String combinedName = null;
        if (domainName != null && !"PRIMARY".equalsIgnoreCase(domainName)) {
            domainName = domainName.toUpperCase() + "/";
            if (!userName.equals(displayName) && displayName != null) {
                userName = domainName + userName;
                displayName = domainName + displayName;
                combinedName = userName + "|" + displayName;
            } else {
                combinedName = domainName + userName;
            }
        } else {
            combinedName = userName.equals(displayName) ? userName + "|" + displayName : userName;
        }
        return combinedName;
    }

    public static boolean isPrimaryAdminUser(String userName, RealmConfiguration realmConfig) {
        String myDomain = UserCoreUtil.getDomainName(realmConfig);
        if (myDomain != null) {
            myDomain = myDomain + "/";
        }
        return realmConfig.isPrimary() && (realmConfig.getAdminUserName().equalsIgnoreCase(userName) || realmConfig.getAdminUserName().equalsIgnoreCase(myDomain + userName));
    }

    public static boolean isPrimaryAdminRole(String roleName, RealmConfiguration realmConfig) {
        String myDomain = UserCoreUtil.getDomainName(realmConfig);
        if (myDomain != null) {
            myDomain = myDomain + "/";
        }
        return realmConfig.isPrimary() && (realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) || realmConfig.getAdminRoleName().equalsIgnoreCase(myDomain + roleName));
    }

    public static boolean isEveryoneRole(String roleName, RealmConfiguration realmConfig) {
        String myDomain = "Internal";
        if (myDomain != null) {
            myDomain = myDomain + "/";
        }
        return realmConfig.isPrimary() && realmConfig.getEveryOneRoleName() != null && realmConfig.getEveryOneRoleName().equalsIgnoreCase(roleName) || realmConfig.getEveryOneRoleName().equalsIgnoreCase(myDomain + roleName);
    }

    public static boolean canRoleBeRenamed(UserStore oldStore, UserStore newStore, RealmConfiguration realmConfig) {
        if (oldStore.getDomainName() == null && newStore.getDomainName() != null) {
            return false;
        }
        if (oldStore.getDomainName() != null && !oldStore.getDomainName().equalsIgnoreCase(newStore.getDomainName())) {
            return false;
        }
        return (!oldStore.isHybridRole() || !realmConfig.isReservedRoleName(oldStore.getDomainFreeName())) && (!newStore.isHybridRole() || !realmConfig.isReservedRoleName(newStore.getDomainFreeName()));
    }

    public static boolean isRegistryAnnonymousUser(String userName) {
        return "wso2.anonymous.user".equalsIgnoreCase(userName);
    }

    public static boolean isRegistrySystemUser(String userName) {
        return "wso2.system.user".equalsIgnoreCase(userName);
    }

    public static String extractDomainFromName(String nameWithDomain) {
        int index = nameWithDomain.indexOf("/");
        if (index > 0) {
            String[] names = nameWithDomain.split("/");
            return names[0];
        }
        return "PRIMARY";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void persistDomain(String domain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "INSERT INTO UM_DOMAIN (UM_DOMAIN_NAME, UM_TENANT_ID) VALUES (?, ?)";
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            if (!UserCoreUtil.isExistingDomain(domain, tenantId, dataSource)) {
                dbConnection = DatabaseUtil.getDBConnection(dataSource);
                dbConnection.setAutoCommit(false);
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, domain, tenantId);
                dbConnection.commit();
            }
        }
        catch (UserStoreException e) {
            try {
                throw new UserStoreException(e.getMessage());
                catch (SQLException e2) {
                    throw new UserStoreException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deletePersistedDomain(String domain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "DELETE FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?";
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            if (UserCoreUtil.isExistingDomain(domain, tenantId, dataSource)) {
                dbConnection = DatabaseUtil.getDBConnection(dataSource);
                dbConnection.setAutoCommit(false);
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, domain, tenantId);
                dbConnection.commit();
            }
        }
        catch (UserStoreException e) {
            try {
                throw new UserStoreException(e.getMessage());
                catch (SQLException e2) {
                    throw new UserStoreException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
    }

    public static void updatePersistedDomain(String previousDomain, String newDomain, int tenantId, DataSource dataSource) throws UserStoreException {
        Connection dbConnection = null;
        try {
            String sqlStatement = "UPDATE UM_DOMAIN SET UM_DOMAIN_NAME=? WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?";
            if (previousDomain != null) {
                previousDomain = previousDomain.toUpperCase();
            }
            if (newDomain != null) {
                newDomain = newDomain.toUpperCase();
            }
            if (UserCoreUtil.isExistingDomain(previousDomain, tenantId, dataSource)) {
                if (!UserCoreUtil.isExistingDomain(newDomain, tenantId, dataSource)) {
                    UserCoreUtil.deletePersistedDomain(newDomain, tenantId, dataSource);
                }
                dbConnection = DatabaseUtil.getDBConnection(dataSource);
                dbConnection.setAutoCommit(false);
                DatabaseUtil.updateDatabase(dbConnection, sqlStatement, newDomain, previousDomain, tenantId);
                dbConnection.commit();
            }
        }
        catch (UserStoreException e) {
            throw new UserStoreException(e.getMessage());
        }
        catch (SQLException e) {
            throw new UserStoreException(e.getMessage());
        }
        finally {
            DatabaseUtil.closeAllConnections(dbConnection, new PreparedStatement[0]);
        }
    }

    private static boolean isExistingDomain(String domain, int tenantId, DataSource dataSource) throws UserStoreException {
        boolean bl;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_NAME=? AND UM_TENANT_ID=?");
            if (domain != null) {
                domain = domain.toUpperCase();
            }
            prepStmt.setString(1, domain);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                isExisting = true;
            }
            bl = isExisting;
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return bl;
    }

    private static boolean checkExistingDomainId(int domainId, int tenantId, DataSource dataSource) throws UserStoreException {
        int value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int isExisting = 0;
        try {
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_DOMAIN_ID FROM UM_DOMAIN WHERE UM_DOMAIN_ID=? AND UM_TENANT_ID=?");
            prepStmt.setInt(1, domainId);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && domainId == (value = rs.getInt(1))) {
                isExisting = 1;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public static boolean isSystemRole(String roleName, int tenantId, DataSource dataSource) throws UserStoreException {
        boolean value;
        Connection dbConnection = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        boolean isExisting = false;
        try {
            dbConnection = DatabaseUtil.getDBConnection(dataSource);
            prepStmt = dbConnection.prepareStatement("SELECT UM_ID FROM UM_SYSTEM_ROLE WHERE UM_ROLE_NAME=? AND UM_TENANT_ID=?");
            prepStmt.setString(1, roleName);
            prepStmt.setInt(2, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next() && (value = rs.getInt(1)) > -1 != 0) {
                isExisting = true;
            }
            value = isExisting;
        }
        catch (SQLException e) {
            try {
                throw new UserStoreException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
                throw throwable;
            }
        }
        DatabaseUtil.closeAllConnections(dbConnection, rs, prepStmt);
        return value;
    }

    public static String getTenantShareGroupBase(String tenantOu) {
        return tenantOu + "=" + CarbonContext.getCurrentContext().getTenantDomain();
    }

    static {
        realmService = null;
        threadLocalToSetDomain = new ThreadLocal();
    }
}

