/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.util.encoders.Base64;
import org.globus.gsi.util.PEMUtil;

public final class CertificateIOUtil {
    public static final int LINE_LENGTH = 64;
    public static final String LINE_SEP = "\n";
    public static final String CERT_HEADER = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_FOOTER = "-----END CERTIFICATE-----";
    public static final String KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String KEY_FOOTER = "-----END RSA PRIVATE KEY-----";
    private static Log logger = LogFactory.getLog((String)CertificateIOUtil.class.getCanonicalName());
    private static MessageDigest md5;

    private CertificateIOUtil() {
    }

    private static void init() {
        if (md5 == null) {
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public static String nameHash(X500Principal subjectDN) {
        try {
            return CertificateIOUtil.hash(CertificateIOUtil.encodePrincipal(subjectDN));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static String nameHash(X509Name subjectDN) {
        try {
            return CertificateIOUtil.hash(CertificateIOUtil.encodePrincipal(subjectDN));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public static byte[] encodePrincipal(X500Principal subject) throws IOException {
        return subject.getEncoded();
    }

    public static byte[] encodePrincipal(X509Name subject) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DEROutputStream der = new DEROutputStream((OutputStream)bout);
        der.writeObject((ASN1Encodable)subject.toASN1Primitive());
        return bout.toByteArray();
    }

    private static synchronized String hash(byte[] data) {
        CertificateIOUtil.init();
        if (md5 == null) {
            return null;
        }
        md5.reset();
        md5.update(data);
        byte[] md = md5.digest();
        long ret = CertificateIOUtil.fixByte(md[0]) | CertificateIOUtil.fixByte(md[1]) << 8;
        ret |= CertificateIOUtil.fixByte(md[2]) << 16;
        ret |= CertificateIOUtil.fixByte(md[3]) << 24;
        return Long.toHexString(ret &= 0xFFFFFFFFL);
    }

    private static long fixByte(byte b) {
        return b < 0 ? (long)(b + 256) : (long)b;
    }

    public static void writeCertificate(X509Certificate cert, File path) throws CertificateEncodingException, IOException {
        FileOutputStream fos = new FileOutputStream(path);
        CertificateIOUtil.writeCertificate(fos, cert);
        fos.close();
    }

    public static String certToPEMString(String base64Data) {
        return CertificateIOUtil.toStringImpl(base64Data, false);
    }

    public static void writeCertificate(OutputStream out, X509Certificate cert) throws IOException, CertificateEncodingException {
        PEMUtil.writeBase64(out, CERT_HEADER, Base64.encode((byte[])cert.getEncoded()), CERT_FOOTER);
    }

    private static String toStringImpl(String base64Data, boolean isKey) {
        int length = 64;
        int offset = 0;
        StringBuffer buf = new StringBuffer(2048);
        if (isKey) {
            buf.append(KEY_HEADER);
        } else {
            buf.append(CERT_HEADER);
        }
        buf.append(LINE_SEP);
        int size = base64Data.length();
        while (offset < size) {
            if (64 > size - offset) {
                length = size - offset;
            }
            buf.append(base64Data.substring(offset, offset + length));
            buf.append(LINE_SEP);
            offset += 64;
        }
        if (isKey) {
            buf.append(KEY_FOOTER);
        } else {
            buf.append(CERT_FOOTER);
        }
        buf.append(LINE_SEP);
        return buf.toString();
    }
}

