// This file is auto-generated by @hey-api/openapi-ts

export const $BundleInfo = {
    properties: {
        name: {
            type: 'string',
            title: 'Name'
        },
        version: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Version'
        }
    },
    type: 'object',
    required: ['name'],
    title: 'BundleInfo',
    description: 'Schema for telling task which bundle to run with.'
} as const;

export const $EdgeJobFetched = {
    properties: {
        dag_id: {
            type: 'string',
            title: 'Dag ID',
            description: 'Identifier of the DAG to which the task belongs.'
        },
        task_id: {
            type: 'string',
            title: 'Task ID',
            description: 'Task name in the DAG.'
        },
        run_id: {
            type: 'string',
            title: 'Run ID',
            description: 'Run ID of the DAG execution.'
        },
        map_index: {
            type: 'integer',
            title: 'Map Index',
            description: 'For dynamically mapped tasks the mapping number, -1 if the task is not mapped.'
        },
        try_number: {
            type: 'integer',
            title: 'Try Number',
            description: 'The number of attempt to execute this task.'
        },
        command: {
            '$ref': '#/components/schemas/ExecuteTask',
            title: 'Command',
            description: 'Command line to use to execute the job in Airflow 2. Task definition in Airflow 3'
        },
        concurrency_slots: {
            type: 'integer',
            title: 'Concurrency Slots',
            description: 'Number of concurrency slots the job requires.'
        }
    },
    type: 'object',
    required: ['dag_id', 'task_id', 'run_id', 'map_index', 'try_number', 'command', 'concurrency_slots'],
    title: 'EdgeJobFetched',
    description: 'Job that is to be executed on the edge worker.'
} as const;

export const $EdgeWorkerState = {
    type: 'string',
    enum: ['starting', 'running', 'idle', 'shutdown request', 'terminating', 'offline', 'unknown', 'maintenance request', 'maintenance pending', 'maintenance mode', 'maintenance exit', 'offline maintenance'],
    title: 'EdgeWorkerState',
    description: 'Status of a Edge Worker instance.'
} as const;

export const $ExecuteTask = {
    properties: {
        token: {
            type: 'string',
            title: 'Token'
        },
        dag_rel_path: {
            type: 'string',
            format: 'path',
            title: 'Dag Rel Path'
        },
        bundle_info: {
            '$ref': '#/components/schemas/BundleInfo'
        },
        log_path: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Log Path'
        },
        ti: {
            '$ref': '#/components/schemas/TaskInstance'
        },
        type: {
            type: 'string',
            const: 'ExecuteTask',
            title: 'Type',
            default: 'ExecuteTask'
        }
    },
    type: 'object',
    required: ['token', 'dag_rel_path', 'bundle_info', 'log_path', 'ti'],
    title: 'ExecuteTask',
    description: 'Execute the given Task.'
} as const;

export const $HTTPExceptionResponse = {
    properties: {
        detail: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    additionalProperties: true,
                    type: 'object'
                }
            ],
            title: 'Detail'
        }
    },
    type: 'object',
    required: ['detail'],
    title: 'HTTPExceptionResponse',
    description: 'HTTPException Model used for error response.'
} as const;

export const $HTTPValidationError = {
    properties: {
        detail: {
            items: {
                '$ref': '#/components/schemas/ValidationError'
            },
            type: 'array',
            title: 'Detail'
        }
    },
    type: 'object',
    title: 'HTTPValidationError'
} as const;

export const $Job = {
    properties: {
        dag_id: {
            type: 'string',
            title: 'Dag ID',
            description: 'Identifier of the DAG to which the task belongs.'
        },
        task_id: {
            type: 'string',
            title: 'Task ID',
            description: 'Task name in the DAG.'
        },
        run_id: {
            type: 'string',
            title: 'Run ID',
            description: 'Run ID of the DAG execution.'
        },
        map_index: {
            type: 'integer',
            title: 'Map Index',
            description: 'For dynamically mapped tasks the mapping number, -1 if the task is not mapped.'
        },
        try_number: {
            type: 'integer',
            title: 'Try Number',
            description: 'The number of attempt to execute this task.'
        },
        state: {
            '$ref': '#/components/schemas/TaskInstanceState',
            description: 'State of the job from the view of the executor.'
        },
        queue: {
            type: 'string',
            title: 'Queue',
            description: 'Queue for which the task is scheduled/running.'
        },
        queued_dttm: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Queued Dttm',
            description: 'When the job was queued.'
        },
        edge_worker: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Edge Worker',
            description: 'The worker processing the job during execution.'
        },
        last_update: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Update',
            description: 'Last heartbeat of the job.'
        }
    },
    type: 'object',
    required: ['dag_id', 'task_id', 'run_id', 'map_index', 'try_number', 'state', 'queue'],
    title: 'Job',
    description: 'Details of the job sent to the scheduler.'
} as const;

export const $JobCollectionResponse = {
    properties: {
        jobs: {
            items: {
                '$ref': '#/components/schemas/Job'
            },
            type: 'array',
            title: 'Jobs'
        },
        total_entries: {
            type: 'integer',
            title: 'Total Entries'
        }
    },
    type: 'object',
    required: ['jobs', 'total_entries'],
    title: 'JobCollectionResponse',
    description: 'Job Collection serializer.'
} as const;

export const $MaintenanceRequest = {
    properties: {
        maintenance_comment: {
            type: 'string',
            title: 'Maintenance Comment',
            description: 'Comment describing the maintenance reason.'
        }
    },
    type: 'object',
    required: ['maintenance_comment'],
    title: 'MaintenanceRequest',
    description: 'Request body for maintenance operations.'
} as const;

export const $PushLogsBody = {
    properties: {
        log_chunk_time: {
            type: 'string',
            format: 'date-time',
            title: 'Log Chunk Time',
            description: 'Time of the log chunk at point of sending.'
        },
        log_chunk_data: {
            type: 'string',
            title: 'Log Chunk Data',
            description: 'Log chunk data as incremental log text.'
        }
    },
    type: 'object',
    required: ['log_chunk_time', 'log_chunk_data'],
    title: 'PushLogsBody',
    description: 'Incremental new log content from worker.'
} as const;

export const $TaskInstance = {
    properties: {
        id: {
            type: 'string',
            format: 'uuid',
            title: 'Id'
        },
        dag_version_id: {
            type: 'string',
            format: 'uuid',
            title: 'Dag Version Id'
        },
        task_id: {
            type: 'string',
            title: 'Task Id'
        },
        dag_id: {
            type: 'string',
            title: 'Dag Id'
        },
        run_id: {
            type: 'string',
            title: 'Run Id'
        },
        try_number: {
            type: 'integer',
            title: 'Try Number'
        },
        map_index: {
            type: 'integer',
            title: 'Map Index',
            default: -1
        },
        pool_slots: {
            type: 'integer',
            title: 'Pool Slots'
        },
        queue: {
            type: 'string',
            title: 'Queue'
        },
        priority_weight: {
            type: 'integer',
            title: 'Priority Weight'
        },
        parent_context_carrier: {
            anyOf: [
                {
                    additionalProperties: true,
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Parent Context Carrier'
        },
        context_carrier: {
            anyOf: [
                {
                    additionalProperties: true,
                    type: 'object'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Context Carrier'
        }
    },
    type: 'object',
    required: ['id', 'dag_version_id', 'task_id', 'dag_id', 'run_id', 'try_number', 'pool_slots', 'queue', 'priority_weight'],
    title: 'TaskInstance',
    description: 'Schema for TaskInstance with minimal required fields needed for Executors and Task SDK.'
} as const;

export const $TaskInstanceState = {
    type: 'string',
    enum: ['removed', 'scheduled', 'queued', 'running', 'success', 'restarting', 'failed', 'up_for_retry', 'up_for_reschedule', 'upstream_failed', 'skipped', 'deferred'],
    title: 'TaskInstanceState',
    description: `All possible states that a Task Instance can be in.

Note that None is also allowed, so always use this in a type hint with Optional.`
} as const;

export const $ValidationError = {
    properties: {
        loc: {
            items: {
                anyOf: [
                    {
                        type: 'string'
                    },
                    {
                        type: 'integer'
                    }
                ]
            },
            type: 'array',
            title: 'Location'
        },
        msg: {
            type: 'string',
            title: 'Message'
        },
        type: {
            type: 'string',
            title: 'Error Type'
        }
    },
    type: 'object',
    required: ['loc', 'msg', 'type'],
    title: 'ValidationError'
} as const;

export const $Worker = {
    properties: {
        queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Queues',
            description: 'List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.'
        },
        state: {
            '$ref': '#/components/schemas/EdgeWorkerState',
            description: 'State of the worker from the view of the worker.'
        },
        jobs_active: {
            type: 'integer',
            title: 'Jobs Active',
            description: 'Number of active jobs the worker is running.',
            default: 0
        },
        sysinfo: {
            additionalProperties: {
                anyOf: [
                    {
                        type: 'string'
                    },
                    {
                        type: 'integer'
                    }
                ]
            },
            type: 'object',
            title: 'Sysinfo',
            description: 'System information of the worker.',
            examples: [
                {
                    airflow_version: '2.0.0',
                    concurrency: 4,
                    edge_provider_version: '1.0.0',
                    free_concurrency: 3
                }
            ]
        },
        maintenance_comments: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Maintenance Comments',
            description: 'Comments about the maintenance state of the worker.'
        },
        worker_name: {
            type: 'string',
            title: 'Worker Name',
            description: 'Name of the worker.'
        },
        first_online: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'First Online',
            description: 'When the worker was first online.'
        },
        last_heartbeat: {
            anyOf: [
                {
                    type: 'string',
                    format: 'date-time'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Last Heartbeat',
            description: 'When the worker last sent a heartbeat.'
        }
    },
    type: 'object',
    required: ['state', 'sysinfo', 'worker_name'],
    title: 'Worker',
    description: 'Details of the worker state sent to the scheduler.'
} as const;

export const $WorkerCollectionResponse = {
    properties: {
        workers: {
            items: {
                '$ref': '#/components/schemas/Worker'
            },
            type: 'array',
            title: 'Workers'
        },
        total_entries: {
            type: 'integer',
            title: 'Total Entries'
        }
    },
    type: 'object',
    required: ['workers', 'total_entries'],
    title: 'WorkerCollectionResponse',
    description: 'Worker Collection serializer.'
} as const;

export const $WorkerQueueUpdateBody = {
    properties: {
        new_queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'New Queues',
            description: 'Additional queues to be added to worker.'
        },
        remove_queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Remove Queues',
            description: 'Queues to remove from worker.'
        }
    },
    type: 'object',
    required: ['new_queues', 'remove_queues'],
    title: 'WorkerQueueUpdateBody',
    description: 'Changed queues for the worker.'
} as const;

export const $WorkerQueuesBody = {
    properties: {
        queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Queues',
            description: 'List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.'
        },
        free_concurrency: {
            type: 'integer',
            title: 'Free Concurrency',
            description: 'Number of free concurrency slots on the worker.'
        }
    },
    type: 'object',
    required: ['free_concurrency'],
    title: 'WorkerQueuesBody',
    description: 'Queues that a worker supports to run jobs on.'
} as const;

export const $WorkerRegistrationReturn = {
    properties: {
        last_update: {
            type: 'string',
            format: 'date-time',
            title: 'Last Update',
            description: 'Time of the last update of the worker.'
        }
    },
    type: 'object',
    required: ['last_update'],
    title: 'WorkerRegistrationReturn',
    description: 'The return class for the worker registration.'
} as const;

export const $WorkerSetStateReturn = {
    properties: {
        state: {
            '$ref': '#/components/schemas/EdgeWorkerState',
            description: 'State of the worker from the view of the server.'
        },
        queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Queues',
            description: 'List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.'
        },
        maintenance_comments: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Maintenance Comments',
            description: 'Comments about the maintenance state of the worker.'
        }
    },
    type: 'object',
    required: ['state', 'queues'],
    title: 'WorkerSetStateReturn',
    description: 'The return class for the worker set state.'
} as const;

export const $WorkerStateBody = {
    properties: {
        queues: {
            anyOf: [
                {
                    items: {
                        type: 'string'
                    },
                    type: 'array'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Queues',
            description: 'List of queues the worker is pulling jobs from. If not provided, worker pulls from all queues.'
        },
        state: {
            '$ref': '#/components/schemas/EdgeWorkerState',
            description: 'State of the worker from the view of the worker.'
        },
        jobs_active: {
            type: 'integer',
            title: 'Jobs Active',
            description: 'Number of active jobs the worker is running.',
            default: 0
        },
        sysinfo: {
            additionalProperties: {
                anyOf: [
                    {
                        type: 'string'
                    },
                    {
                        type: 'integer'
                    }
                ]
            },
            type: 'object',
            title: 'Sysinfo',
            description: 'System information of the worker.',
            examples: [
                {
                    airflow_version: '2.0.0',
                    concurrency: 4,
                    edge_provider_version: '1.0.0',
                    free_concurrency: 3
                }
            ]
        },
        maintenance_comments: {
            anyOf: [
                {
                    type: 'string'
                },
                {
                    type: 'null'
                }
            ],
            title: 'Maintenance Comments',
            description: 'Comments about the maintenance state of the worker.'
        }
    },
    type: 'object',
    required: ['state', 'sysinfo'],
    title: 'WorkerStateBody',
    description: 'Details of the worker state sent to the scheduler.'
} as const;