/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.types;

import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.types.XSequenceType;

public class CompoundType
extends Type {
    private Type m_basetype;
    private OccurrenceIndicator m_occurrenceIndicator;

    public CompoundType(Type type, OccurrenceIndicator occurrenceIndicator) {
        this.m_basetype = type;
        this.m_occurrenceIndicator = occurrenceIndicator;
    }

    public Type getBaseType() {
        return this.m_basetype;
    }

    public OccurrenceIndicator getOccurrenceIndicator() {
        return this.m_occurrenceIndicator;
    }

    public String toString() {
        return this.m_basetype.toString() + this.m_occurrenceIndicator.toString();
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        return this.m_basetype.getQuantifier().product(this.m_occurrenceIndicator);
    }

    @Override
    public Type getPrimeType() {
        return this.m_basetype.getPrimeType();
    }

    @Override
    public Type getApproximateType() {
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public Type getAtomizedType() {
        return TypeFactory.newType(this.m_basetype.getAtomizedType(), this.m_occurrenceIndicator);
    }

    @Override
    public String getRuntimeType() {
        if (this.m_occurrenceIndicator == OccurrenceIndicator.ONE || this.m_occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
            return this.m_basetype.getRuntimeType();
        }
        return "com.ibm.xtq.xml.datamodel.XSequence";
    }

    @Override
    public boolean mayContainNodeType() {
        return this.m_basetype.mayContainNodeType();
    }

    @Override
    public int castableAs(AnyAtomicType anyAtomicType, boolean bl) {
        OccurrenceIndicator occurrenceIndicator = this.getQuantifier();
        Type type = this.getPrimeType();
        if (occurrenceIndicator == OccurrenceIndicator.TWO_OR_MORE) {
            return 0;
        }
        if (occurrenceIndicator == OccurrenceIndicator.ZERO_OR_MORE || this.m_occurrenceIndicator == OccurrenceIndicator.ONE_OR_MORE) {
            int n;
            if (type instanceof AnyAtomicType && (n = type.castableAs(anyAtomicType, bl)) == 0) {
                return 0;
            }
        } else if (type instanceof AnyAtomicType) {
            int n = type.castableAs(anyAtomicType, bl);
            if (n == 1) {
                return bl ? 1 : 2;
            }
            return n;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType xSequenceType, boolean bl) {
        OccurrenceIndicator occurrenceIndicator = this.getQuantifier();
        OccurrenceIndicator occurrenceIndicator2 = xSequenceType.getQuantifier();
        boolean bl2 = occurrenceIndicator.canBeEmpty() && occurrenceIndicator2.canBeEmpty();
        int n = occurrenceIndicator.matches(occurrenceIndicator2);
        if (n == 0) {
            return 0;
        }
        Type type = this.getPrimeType();
        int n2 = type.typeMatches(xSequenceType, bl);
        if (n2 == 0) {
            return bl2 ? 2 : 0;
        }
        if (n2 == 1 && n == 1) {
            return 1;
        }
        if (n2 == 3 && n == 1) {
            return 3;
        }
        return 2;
    }
}

