/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.xslt.drivers.ObjectFactory;
import com.ibm.xtq.xslt.drivers.SecuritySupport;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xylem.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;

public class XylemRuntimePreCompiler {
    public static void main(String[] stringArray) throws Exception {
        Module module;
        String string = stringArray[0];
        if (string.equals("1.0")) {
            module = XSLTCompiler.genRuntimeModule10(false);
        } else if (string.equals("2.0")) {
            module = XSLTCompiler.genRuntimeModule20();
        } else {
            throw new IllegalArgumentException(new ErrorMsg("ERR_SYSTEM", "Unrecognized version: " + string).toString());
        }
        String string2 = stringArray[1] + "/" + XylemRuntimePreCompiler.getPath(string, "xltxe_rt.xylemo");
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        Module.writeModule(objectOutputStream, module);
        objectOutputStream.flush();
        fileOutputStream.close();
        string2 = stringArray[1] + "/" + XylemRuntimePreCompiler.getPath(string, "xltxe_rts.xylemo");
        file = new File(string2);
        fileOutputStream = new FileOutputStream(file);
        objectOutputStream = new ObjectOutputStream(fileOutputStream);
        module.m_signature.write(objectOutputStream);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public static InputStream getPrecompiledRuntime(String string) {
        String string2 = XylemRuntimePreCompiler.getPath(string, "xltxe_rt.xylemo");
        return XylemRuntimePreCompiler.getResource(string2);
    }

    public static InputStream getPrecompiledRuntimeSignature(String string) {
        String string2 = XylemRuntimePreCompiler.getPath(string, "xltxe_rts.xylemo");
        return XylemRuntimePreCompiler.getResource(string2);
    }

    private static String getPath(String string, String string2) {
        if (string.equals("1.0")) {
            return "com/ibm/xtq/xslt/runtime/v1/" + string2;
        }
        if (string.equals("2.0")) {
            return "com/ibm/xtq/xslt/runtime/v2/" + string2;
        }
        throw new IllegalArgumentException(new ErrorMsg("ERR_SYSTEM", "Unrecognized version: " + string).toString());
    }

    private static InputStream getResource(String string) {
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        InputStream inputStream = SecuritySupport.getResourceAsStream(classLoader, string);
        return inputStream;
    }
}

