/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker;

import com.ibm.xtq.Constants;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.scontext.XStaticContext;
import com.ibm.xtq.xslt.VisitorBase;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import java.util.Hashtable;
import java.util.Stack;
import javax.xml.namespace.QName;

public abstract class TypeCheckerBase
extends VisitorBase
implements Constants {
    protected XPathCompiler _compiler;
    protected XSLTParser _parser;
    protected XStaticContext _staticContext;
    private Hashtable _variableScope;

    protected TypeCheckerBase(XPathCompiler xPathCompiler) {
        this._compiler = xPathCompiler;
        this._parser = xPathCompiler.getParser();
        this._staticContext = this._parser.getStaticContext();
        this._variableScope = new Hashtable();
    }

    public XPathCompiler getCompiler() {
        return this._compiler;
    }

    public XSLTParser getParser() {
        return this._parser;
    }

    public void addVariable(VarDecl varDecl) {
        this.addVariableOrParam(varDecl);
    }

    public void addParameter(Param param) {
        this.addVariableOrParam(param);
    }

    private void addVariableOrParam(VariableBase variableBase) {
        Object v = this._variableScope.get(variableBase.getQName());
        if (v != null) {
            if (v instanceof Stack) {
                Stack stack = (Stack)v;
                stack.push(variableBase);
            } else if (v instanceof VariableBase) {
                Stack<Object> stack = new Stack<Object>();
                stack.push(v);
                stack.push(variableBase);
                this._variableScope.put(variableBase.getQName(), stack);
            }
        } else {
            this._variableScope.put(variableBase.getQName(), variableBase);
        }
    }

    public void removeVariable(QName qName) {
        Object v = this._variableScope.get(qName);
        if (v instanceof Stack) {
            Stack stack = (Stack)v;
            if (!stack.isEmpty()) {
                stack.pop();
            }
            if (!stack.isEmpty()) {
                return;
            }
        }
        this._variableScope.remove(qName);
    }

    public VariableBase lookupVariable(QName qName) {
        Object v = this._variableScope.get(qName);
        if (v instanceof VariableBase) {
            return (VariableBase)v;
        }
        if (v instanceof Stack) {
            Stack stack = (Stack)v;
            return (VariableBase)stack.peek();
        }
        return null;
    }

    protected QName updateScope(Expr expr) {
        if (expr instanceof VarDecl) {
            VarDecl varDecl = (VarDecl)expr;
            this.addVariable(varDecl);
            if (varDecl.getAt() != null) {
                this.updateScope(varDecl.getAt());
            }
            return varDecl.getQName();
        }
        if (expr instanceof Param) {
            Param param = (Param)expr;
            this.addParameter(param);
            return param.getQName();
        }
        return null;
    }
}

