/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.types;

import com.ibm.xtq.xslt.translator.CoreFunctionLibrary;
import com.ibm.xtq.xslt.xylem.instructions.QNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.QNameLocalNameInstruction;
import com.ibm.xtq.xslt.xylem.instructions.XPathDataTypeLiteralInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateAttributeInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateCommentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateDocumentFragmentInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateElementInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateProcessingInstruction;
import com.ibm.xtq.xslt.xylem.instructions.nodeconstructors.CreateTextInstruction;
import com.ibm.xtq.xslt.xylem.types.XPathDataType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.AttributeXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.DocumentXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.ElementXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.NamedXType;
import com.ibm.xtq.xslt.xylem.xpath20.typesystem.TextXType;
import com.ibm.xylem.Binding;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Type;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.OnceInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.NamedType;
import com.ibm.xylem.types.StreamType;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.QName;

public class XPathDataTypesLibrary {
    private static final NamedType s_xdtType = new NamedType("XPath20Datum");
    private static final StreamType s_xdtStream = new StreamType(s_xdtType);
    public static AbstractDataType.Constructor s_String = new AbstractDataType.Constructor("String", new Binding[]{new Binding((Object)"value", CharType.s_charType.getStreamType()), new Binding((Object)"type", XPathDataType.s_xpathDataType)});
    private static final Instruction[] s_emptyInstructionArray = new Instruction[0];

    public static Instruction makeQName(LetChainBuilder letChainBuilder, String string, String string2, String string3) {
        return letChainBuilder.bind(new QNameInstruction(letChainBuilder.bind(StreamInstruction.charStreamLiteral(string)), letChainBuilder.bind(StreamInstruction.charStreamLiteral(string2)), letChainBuilder.bind(StreamInstruction.charStreamLiteral(string3))));
    }

    public static Instruction makeLocalNameExtractor(Instruction instruction) {
        return new QNameLocalNameInstruction(instruction);
    }

    public static Instruction makeXDTUntypedAny() {
        return new XPathDataTypeLiteralInstruction(NamedXType.s_xsAnyType);
    }

    public static Instruction makeXDTUntypedAtomic() {
        return new XPathDataTypeLiteralInstruction(NamedXType.s_xdtAnyAtomicType);
    }

    public static Instruction makeString(LetChainBuilder letChainBuilder, String string) {
        return XPathDataTypesLibrary.makeString(letChainBuilder, letChainBuilder.bind(StreamInstruction.charStreamLiteral(string)));
    }

    public static Instruction makeString(LetChainBuilder letChainBuilder, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("String", new Instruction[]{instruction, letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsString))}));
    }

    public static Instruction makeInteger(LetChainBuilder letChainBuilder, BigInteger bigInteger) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Integer", new Instruction[]{LiteralInstruction.integerLiteral(bigInteger.intValue()), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsInteger))}));
    }

    public static Instruction makeDecimal(LetChainBuilder letChainBuilder, BigDecimal bigDecimal) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Decimal", new Instruction[]{LiteralInstruction.decimalLiteral(bigDecimal), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsDecimal))}));
    }

    public static Instruction makeDouble(LetChainBuilder letChainBuilder, double d) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Double", new Instruction[]{LiteralInstruction.doubleLiteral(d), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsDouble))}));
    }

    public static Instruction makeUndefined(LetChainBuilder letChainBuilder) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Undefined", new Instruction[0]));
    }

    public static Instruction makeBoolean(LetChainBuilder letChainBuilder, boolean bl) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Boolean", new Instruction[]{bl ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral(), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsBoolean))}));
    }

    public static Instruction makeBoolean(LetChainBuilder letChainBuilder, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Boolean", new Instruction[]{instruction, letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xsDecimal))}));
    }

    public static Instruction makeComment(LetChainBuilder letChainBuilder, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateCommentInstruction(CoreFunctionLibrary.generateCreateStringFunctionCall(letChainBuilder, instruction, letChainBuilder.bind(new StreamInstruction((Type)s_xdtType, new Instruction[]{XPathDataTypesLibrary.makeString(letChainBuilder, " ")}))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null))))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xdtUntyped))}));
    }

    public static Instruction makePI(LetChainBuilder letChainBuilder, Instruction instruction, Instruction instruction2) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateProcessingInstruction(CoreFunctionLibrary.generateToStringFunctionCall(letChainBuilder, instruction), CoreFunctionLibrary.generateCreateStringFunctionCall(letChainBuilder, instruction2, letChainBuilder.bind(new StreamInstruction((Type)s_xdtType, new Instruction[]{XPathDataTypesLibrary.makeString(letChainBuilder, " ")}))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null))))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(NamedXType.s_xdtUntyped))}));
    }

    public static Instruction makeDocument(LetChainBuilder letChainBuilder, Instruction instruction, boolean bl) {
        Instruction instruction2 = letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null));
        CreateDocumentFragmentInstruction createDocumentFragmentInstruction = new CreateDocumentFragmentInstruction(instruction2, instruction);
        createDocumentFragmentInstruction.setPreserveTypeAnnotations(bl);
        Instruction instruction3 = letChainBuilder.bind(new OnceInstruction(letChainBuilder.bind(createDocumentFragmentInstruction)));
        Instruction instruction4 = letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new DocumentXType()));
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{instruction3, instruction4}));
    }

    public static Instruction makeElement(LetChainBuilder letChainBuilder, QName qName, Instruction instruction, boolean bl) {
        CreateElementInstruction createElementInstruction = new CreateElementInstruction(XPathDataTypesLibrary.makeQName(letChainBuilder, qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart()), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction);
        createElementInstruction.setPreserveTypeAnnotations(bl);
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(createElementInstruction)), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new ElementXType(null, NamedXType.s_xdtUntyped)))}));
    }

    public static Instruction makeElement(LetChainBuilder letChainBuilder, String string, Instruction instruction, boolean bl) {
        CreateElementInstruction createElementInstruction = new CreateElementInstruction(XPathDataTypesLibrary.makeQName(letChainBuilder, "", "", string), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction);
        createElementInstruction.setPreserveTypeAnnotations(bl);
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(createElementInstruction)), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new ElementXType(null, NamedXType.s_xdtUntyped)))}));
    }

    public static Instruction makeElement(LetChainBuilder letChainBuilder, QNameInstruction qNameInstruction, Instruction instruction, boolean bl) {
        CreateElementInstruction createElementInstruction = new CreateElementInstruction(letChainBuilder.bind(qNameInstruction), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction);
        createElementInstruction.setPreserveTypeAnnotations(bl);
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(createElementInstruction)), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new ElementXType(null, NamedXType.s_xdtUntyped)))}));
    }

    public static Instruction makeAttribute(LetChainBuilder letChainBuilder, String string, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateAttributeInstruction(XPathDataTypesLibrary.makeQName(letChainBuilder, "", "", string), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new AttributeXType(null, NamedXType.s_xdtUntypedAtomic)))}));
    }

    public static Instruction makeAttribute(LetChainBuilder letChainBuilder, QName qName, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateAttributeInstruction(XPathDataTypesLibrary.makeQName(letChainBuilder, qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart()), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new AttributeXType(null, NamedXType.s_xdtUntypedAtomic)))}));
    }

    public static Instruction makeAttribute(LetChainBuilder letChainBuilder, QNameInstruction qNameInstruction, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateAttributeInstruction(letChainBuilder.bind(qNameInstruction), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new AttributeXType(null, NamedXType.s_xdtUntypedAtomic)))}));
    }

    public static Instruction makeNamespaceNode(LetChainBuilder letChainBuilder, Instruction instruction, Instruction instruction2) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateAttributeInstruction(letChainBuilder.bind(new QNameInstruction(letChainBuilder.bind(StreamInstruction.charStreamLiteral("http://www.w3.org/2000/xmlns/")), letChainBuilder.bind(StreamInstruction.charStreamLiteral("xmlns")), instruction)), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null)), instruction2))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(new AttributeXType(null, NamedXType.s_xdtUntypedAtomic)))}));
    }

    public static Instruction makeText(LetChainBuilder letChainBuilder, Instruction instruction) {
        return letChainBuilder.bind(new ConstructorInstantiationInstruction("Node", new Instruction[]{letChainBuilder.bind(new OnceInstruction(new CreateTextInstruction(instruction, letChainBuilder.bind(new XPathDataTypeLiteralInstruction(null))))), letChainBuilder.bind(new XPathDataTypeLiteralInstruction(TextXType.s_textXType))}));
    }

    public static Instruction makeEmpty() {
        return XPathDataTypesLibrary.makeStream(s_emptyInstructionArray);
    }

    public static Instruction makeStream(Instruction[] instructionArray) {
        return new StreamInstruction((Type)s_xdtType, instructionArray);
    }

    public static Instruction makeSingletonStream(Instruction instruction) {
        return new StreamInstruction((Type)s_xdtType, new Instruction[]{instruction});
    }
}

