/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.tools.rumen.DeepCompare;
import org.apache.hadoop.tools.rumen.DeepInequalityException;
import org.apache.hadoop.tools.rumen.TreePath;
import org.codehaus.jackson.annotate.JsonAnySetter;

public class LoggedLocation
implements DeepCompare {
    static final Map<List<String>, List<String>> layersCache = new HashMap<List<String>, List<String>>();
    List<String> layers = Collections.emptyList();
    private static Set<String> alreadySeenAnySetterAttributes = new TreeSet<String>();

    public List<String> getLayers() {
        return this.layers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLayers(List<String> layers) {
        if (layers == null || layers.isEmpty()) {
            this.layers = Collections.emptyList();
        } else {
            Map<List<String>, List<String>> map = layersCache;
            synchronized (map) {
                List<String> found = layersCache.get(layers);
                if (found == null) {
                    ArrayList<String> clone = new ArrayList<String>(layers.size());
                    for (String s : layers) {
                        clone.add(s.intern());
                    }
                    List readonlyLayers = Collections.unmodifiableList(clone);
                    layersCache.put(readonlyLayers, readonlyLayers);
                    this.layers = readonlyLayers;
                } else {
                    this.layers = found;
                }
            }
        }
    }

    @JsonAnySetter
    public void setUnknownAttribute(String attributeName, Object ignored) {
        if (!alreadySeenAnySetterAttributes.contains(attributeName)) {
            alreadySeenAnySetterAttributes.add(attributeName);
            System.err.println("In LoggedJob, we saw the unknown attribute " + attributeName + ".");
        }
    }

    private void compareStrings(List<String> c1, List<String> c2, TreePath loc, String eltname) throws DeepInequalityException {
        if (c1 == null && c2 == null) {
            return;
        }
        TreePath recursePath = new TreePath(loc, eltname);
        if (c1 == null || c2 == null || !((Object)c1).equals(c2)) {
            throw new DeepInequalityException(eltname + " miscompared", recursePath);
        }
    }

    @Override
    public void deepCompare(DeepCompare comparand, TreePath loc) throws DeepInequalityException {
        if (!(comparand instanceof LoggedLocation)) {
            throw new DeepInequalityException("comparand has wrong type", loc);
        }
        LoggedLocation other = (LoggedLocation)comparand;
        this.compareStrings(this.layers, other.layers, loc, "layers");
    }
}

