/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.jaxp;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.xpath.XPath;
import org.apache.xpath.jaxp.XPathExpressionImpl;
import org.apache.xpath.jaxp.XPathPrefixResolver;
import org.apache.xpath.res.XPATHMessages;
import org.xml.sax.InputSource;

public class XPathImpl
implements javax.xml.xpath.XPath {
    private XPathVariableResolver m_origVariableResolver = null;
    private XPathFunctionResolver m_origFunctionResolver = null;
    private XPathVariableResolver m_variableResolver = null;
    private XPathFunctionResolver m_functionResolver = null;
    private NamespaceContext m_namespaceContext = null;
    private boolean m_allowNullFcnPrefix = false;
    private boolean m_isSecureProcessing = false;

    protected XPathImpl(XPathFunctionResolver xPathFunctionResolver, XPathVariableResolver xPathVariableResolver, boolean bl, boolean bl2) {
        this.m_origFunctionResolver = this.m_functionResolver = xPathFunctionResolver;
        this.m_origVariableResolver = this.m_variableResolver = xPathVariableResolver;
        this.m_isSecureProcessing = bl;
        this.m_allowNullFcnPrefix = bl2;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.m_variableResolver;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver xPathVariableResolver) {
        if (xPathVariableResolver == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", null));
        }
        this.m_variableResolver = xPathVariableResolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.m_functionResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver xPathFunctionResolver) {
        if (xPathFunctionResolver == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", null));
        }
        this.m_functionResolver = xPathFunctionResolver;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.m_namespaceContext;
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        if (namespaceContext == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_NAMESPACE_CONTEXT", null));
        }
        this.m_namespaceContext = namespaceContext;
    }

    @Override
    public void reset() {
        this.m_variableResolver = this.m_origVariableResolver;
        this.m_functionResolver = this.m_origFunctionResolver;
    }

    @Override
    public XPathExpression compile(String string) throws XPathExpressionException {
        if (string == null) {
            throw new NullPointerException(XPATHMessages.createXPATHMessage("ER_NULL_XPATH_EXPRESSION", null));
        }
        XPathPrefixResolver xPathPrefixResolver = new XPathPrefixResolver(this.m_namespaceContext);
        try {
            XPath xPath = new XPath(string, xPathPrefixResolver, this.m_functionResolver, this.m_variableResolver, this.m_isSecureProcessing, this.m_allowNullFcnPrefix);
            return new XPathExpressionImpl(xPath, xPathPrefixResolver, this.m_isSecureProcessing);
        }
        catch (TransformerException transformerException) {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof XPathExpressionException) {
                throw (XPathExpressionException)throwable;
            }
            throw new XPathExpressionException(transformerException);
        }
    }

    @Override
    public String evaluate(String string, Object object) throws XPathExpressionException {
        return (String)this.evaluate(string, object, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(String string, Object object, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(object, qName);
    }

    @Override
    public String evaluate(String string, InputSource inputSource) throws XPathExpressionException {
        return (String)this.evaluate(string, inputSource, XPathConstants.STRING);
    }

    @Override
    public Object evaluate(String string, InputSource inputSource, QName qName) throws XPathExpressionException {
        XPathExpression xPathExpression = this.compile(string);
        return xPathExpression.evaluate(inputSource, qName);
    }
}

