/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.bcel.generic;

import com.ibm.xtq.bcel.Constants;
import com.ibm.xtq.bcel.classfile.Constant;
import com.ibm.xtq.bcel.classfile.ConstantPool;
import com.ibm.xtq.bcel.generic.ConstantPoolGen;
import com.ibm.xtq.bcel.generic.ExceptionThrower;
import com.ibm.xtq.bcel.generic.FieldOrMethod;
import com.ibm.xtq.bcel.generic.StackConsumer;
import com.ibm.xtq.bcel.generic.StackProducer;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.bcel.generic.TypedInstruction;
import java.util.StringTokenizer;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short opcode, int index) {
        super(opcode, index);
    }

    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[this.opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    public int consumeStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        Type[] args = Type.getArgumentTypes(signature);
        int sum = this.opcode == 184 ? 0 : 1;
        int n = args.length;
        int i = 0;
        while (i < n) {
            sum += args[i].getSize();
            ++i;
        }
        return sum;
    }

    public int produceStack(ConstantPoolGen cpg) {
        return this.getReturnType(cpg).getSize();
    }

    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    public abstract Class[] getExceptions();
}

