/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.common.utils;

import com.ibm.xtq.common.utils.IntVector;
import java.util.Vector;

public class SparseVector {
    Vector m_values;
    IntVector m_keys;
    static final int HASHPRIME = 101;
    int[] m_hashStart = new int[101];
    IntVector m_hashChain;
    static final int NULL = -1;

    public SparseVector() {
        this.m_values = new Vector();
        this.m_keys = new IntVector();
        this.m_hashChain = new IntVector(512);
        this.removeAllElements();
    }

    public void removeAllElements() {
        this.m_values.removeAllElements();
        this.m_keys.removeAllElements();
        for (int i = 0; i < 101; ++i) {
            this.m_hashStart[i] = -1;
        }
        this.m_hashChain.removeAllElements();
    }

    public Object setElementAt(Object object, int n) {
        return this.maybeSetElementAt(object, n, true);
    }

    public Object elementAt(int n) {
        return this.maybeSetElementAt(null, n, false);
    }

    protected Object maybeSetElementAt(Object object, int n, boolean bl) {
        int n2;
        int n3 = n % 101;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = n2 = this.m_hashStart[n3];
        while (n4 != -1) {
            if (this.m_keys.elementAt(n4) == n) {
                Object e = this.m_values.elementAt(n4);
                if (bl) {
                    this.m_values.setElementAt(object, n4);
                }
                return e;
            }
            n2 = n4;
            n4 = this.m_hashChain.elementAt(n4);
        }
        if (bl) {
            int n5 = this.m_values.size();
            this.m_values.addElement(object);
            this.m_keys.addElement(n);
            this.m_hashChain.addElement(-1);
            if (n2 == -1) {
                this.m_hashStart[n3] = n5;
            } else {
                this.m_hashChain.setElementAt(n5, n2);
            }
        }
        return null;
    }
}

