/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.XDate;
import com.ibm.xtq.xml.datamodel.XDateTime;
import com.ibm.xtq.xml.datamodel.XDayTimeDuration;
import com.ibm.xtq.xml.datamodel.XTime;
import com.ibm.xtq.xml.datamodel.XValidationContext;
import com.ibm.xtq.xml.datamodel.XYearMonthDuration;
import com.ibm.xtq.xml.xdm.XDMCursor;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.util.Base64;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.dv.xs.AnyURIDV;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.datatypes.ByteList;
import org.apache.xerces.xs.datatypes.XSDateTime;
import org.apache.xerces.xs.datatypes.XSDecimal;
import org.apache.xerces.xs.datatypes.XSDouble;
import org.apache.xerces.xs.datatypes.XSFloat;
import org.apache.xerces.xs.datatypes.XSQName;

public class LibraryUtilities {
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final Class[] CLASS_ARRAY = new Class[]{Boolean.class, Double.class, String.class, XDMCursor.class};

    public static char[] dateTimeToCharArray(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, int n8, int n9) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LibraryUtilities.dateToString(n, n2, n3));
        stringBuffer.append('T');
        stringBuffer.append(LibraryUtilities.timeToString(n4, n5, n6, n7));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n8, n9));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] dateToCharArray(int n, int n2, int n3, boolean bl, int n4, int n5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LibraryUtilities.dateToString(n, n2, n3));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n4, n5));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] timeToCharArray(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LibraryUtilities.timeToString(n, n2, n3, n4));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n5, n6));
        return stringBuffer.toString().toCharArray();
    }

    public static String timeToString(int n, int n2, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(Math.abs(n)));
        stringBuffer.append(':');
        stringBuffer.append(numberFormat.format(Math.abs(n2)));
        stringBuffer.append(':');
        stringBuffer.append(numberFormat.format(Math.abs(n3)));
        if (n4 != 0) {
            n4 = Math.abs(n4);
            int n5 = 3;
            while (n4 % 10 == 0) {
                --n5;
                n4 /= 10;
            }
            numberFormat.setMinimumIntegerDigits(n5);
            stringBuffer.append('.');
            stringBuffer.append(numberFormat.format(n4));
        }
        return stringBuffer.toString();
    }

    public static char[] gDayToCharArray(int n, boolean bl, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer("---");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n2, n3));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] gMonthToCharArray(int n, boolean bl, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer("--");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n2, n3));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] gMonthDayToCharArray(int n, int n2, boolean bl, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer("--");
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append("-");
        stringBuffer.append(numberFormat.format(n2));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n3, n4));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] gYearToCharArray(int n, boolean bl, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n2, n3));
        return stringBuffer.toString().toCharArray();
    }

    public static char[] gYearMonthToCharArray(int n, int n2, boolean bl, int n3, int n4) {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append("-");
        n2 = Math.abs(n2);
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(n2));
        stringBuffer.append(LibraryUtilities.tzToString(bl, n3, n4));
        return stringBuffer.toString().toCharArray();
    }

    public static String dateToString(int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.isParseIntegerOnly();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(4);
        stringBuffer.append(numberFormat.format(n));
        stringBuffer.append('-');
        numberFormat.setMinimumIntegerDigits(2);
        stringBuffer.append(numberFormat.format(Math.abs(n2)));
        stringBuffer.append('-');
        stringBuffer.append(numberFormat.format(Math.abs(n3)));
        return stringBuffer.toString();
    }

    public static String tzToString(boolean bl, int n, int n2) {
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n == 0 && n2 == 0) {
                stringBuffer.append('Z');
            } else {
                if (n >= 0) {
                    stringBuffer.append('+');
                }
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.isParseIntegerOnly();
                numberFormat.setGroupingUsed(false);
                numberFormat.setMinimumIntegerDigits(2);
                stringBuffer.append(numberFormat.format(n));
                stringBuffer.append(':');
                stringBuffer.append(numberFormat.format(Math.abs(n2)));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static char[] durationToCharArray(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0) {
            stringBuffer.append('-');
            n = Math.abs(n);
            n2 = Math.abs(n2);
            n3 = Math.abs(n3);
            n4 = Math.abs(n4);
            n5 = Math.abs(n5);
            n6 = Math.abs(n6);
            n7 = Math.abs(n7);
        }
        stringBuffer.append('P');
        if (n > 0) {
            stringBuffer.append(n);
            stringBuffer.append('Y');
        }
        if (n2 > 0) {
            stringBuffer.append(n2);
            stringBuffer.append('M');
        }
        if (n3 > 0) {
            stringBuffer.append(n3);
            stringBuffer.append('D');
        }
        if (n4 > 0 || n5 > 0 || n6 > 0 || n7 > 0) {
            stringBuffer.append('T');
        }
        if (n4 > 0) {
            stringBuffer.append(n4);
            stringBuffer.append('H');
        }
        if (n5 > 0) {
            stringBuffer.append(n5);
            stringBuffer.append('M');
        }
        if (n6 > 0 || n7 > 0) {
            stringBuffer.append(n6);
            if (n7 > 0) {
                stringBuffer.append('.');
                if (n7 < 10) {
                    stringBuffer.append('0');
                }
                if (n7 < 100) {
                    stringBuffer.append('0');
                }
                while (n7 % 10 == 0) {
                    n7 /= 10;
                }
                stringBuffer.append(n7);
            }
            stringBuffer.append('S');
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("T0S");
        }
        return stringBuffer.toString().toCharArray();
    }

    public static char[] dayTimeDurationToCharArray(int n, int n2, int n3, int n4, int n5) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            stringBuffer.append('-');
            n = Math.abs(n);
            n2 = Math.abs(n2);
            n3 = Math.abs(n3);
            n4 = Math.abs(n4);
            n5 = Math.abs(n5);
        }
        stringBuffer.append('P');
        if (n > 0) {
            stringBuffer.append(n);
            stringBuffer.append('D');
        }
        if (n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0) {
            stringBuffer.append('T');
        }
        if (n2 > 0) {
            stringBuffer.append(n2);
            stringBuffer.append('H');
        }
        if (n3 > 0) {
            stringBuffer.append(n3);
            stringBuffer.append('M');
        }
        if (n4 > 0 || n5 > 0) {
            stringBuffer.append(n4);
            if (n5 > 0) {
                stringBuffer.append('.');
                if (n5 < 10) {
                    stringBuffer.append('0');
                }
                if (n5 < 100) {
                    stringBuffer.append('0');
                }
                while (n5 % 10 == 0) {
                    n5 /= 10;
                }
                stringBuffer.append(n5);
            }
            stringBuffer.append('S');
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("T0S");
        }
        return stringBuffer.toString().toCharArray();
    }

    public static char[] yearMonthDurationToCharArray(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0 || n2 < 0) {
            stringBuffer.append('-');
            n = Math.abs(n);
            n2 = Math.abs(n2);
        }
        stringBuffer.append('P');
        if (n > 0) {
            stringBuffer.append(n);
            stringBuffer.append('Y');
        }
        if (n2 > 0) {
            stringBuffer.append(n2);
            stringBuffer.append('M');
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("0M");
        }
        return stringBuffer.toString().toCharArray();
    }

    public static char[] hexBinaryToCharArray(byte[] byArray) {
        String string = HexBin.encode(byArray).trim();
        return string.toCharArray();
    }

    public static char[] base64BinaryToCharArray(byte[] byArray) {
        String string = Base64.encode(byArray).trim();
        return string.toCharArray();
    }

    public static int[] parseIntegerfromStr(char[] cArray) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = new int[2];
        nArray[0] = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '-' && i == 0) {
                bl = true;
                continue;
            }
            if (cArray[i] == '+' && i == 0) continue;
            if (Character.isDigit(cArray[i])) {
                stringBuffer.append(cArray[i]);
                continue;
            }
            nArray[0] = 1;
            nArray[1] = 0;
        }
        if (stringBuffer.length() == 0) {
            nArray[0] = 1;
            nArray[1] = 0;
        }
        String string = stringBuffer.toString();
        if (bl) {
            boolean bl2 = true;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '0') continue;
                bl2 = false;
                break;
            }
            if (bl2) {
                nArray[0] = 1;
                nArray[1] = 0;
                return nArray;
            }
        }
        try {
            nArray[1] = Integer.parseInt((bl ? "-" : "") + stringBuffer.toString());
        }
        catch (Exception exception) {
            nArray[0] = 1;
            nArray[1] = 0;
        }
        return nArray;
    }

    public static int[] parseIntegerfromFloat(float f) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        if ((double)f >= 2.147483648E9) {
            nArray[0] = 1;
            nArray[1] = 0;
        } else {
            nArray[1] = (int)f;
        }
        return nArray;
    }

    public static int[] parseIntegerfromDouble(double d) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        if (d >= 2.147483648E9) {
            nArray[0] = 1;
            nArray[1] = 0;
        } else {
            nArray[1] = (int)d;
        }
        return nArray;
    }

    public static int[] parseIntegerfromDecimal(BigDecimal bigDecimal) {
        int[] nArray = new int[2];
        nArray[0] = 0;
        if ((double)bigDecimal.intValue() + 0.0 > 2.147483647E9) {
            nArray[0] = 1;
            nArray[1] = 0;
        } else {
            nArray[1] = bigDecimal.intValue();
        }
        return nArray;
    }

    public static BigDecimal[] parseDecimalfromStr(char[] cArray) {
        BigDecimal bigDecimal;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        bigDecimalArray[0] = bigDecimal = new BigDecimal(0);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '-' && i == 0) {
                bl = true;
                continue;
            }
            if (cArray[i] == '+' && i == 0) continue;
            if (Character.isDigit(cArray[i]) || cArray[i] == '.') {
                stringBuffer.append(cArray[i]);
                continue;
            }
            bigDecimalArray[0] = new BigDecimal(1);
            bigDecimalArray[1] = bigDecimal;
        }
        if (stringBuffer.length() == 0) {
            bigDecimalArray[0] = new BigDecimal(1);
            bigDecimalArray[1] = bigDecimal;
        }
        try {
            bigDecimalArray[1] = new BigDecimal((bl ? "-" : "") + stringBuffer.toString());
        }
        catch (Exception exception) {
            bigDecimalArray[0] = new BigDecimal(1);
            bigDecimalArray[1] = bigDecimal;
        }
        return bigDecimalArray;
    }

    public static BigDecimal[] parseDecimalfromFloat(float f) {
        BigDecimal bigDecimal;
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        bigDecimalArray[0] = bigDecimal = new BigDecimal(0);
        try {
            bigDecimalArray[1] = new BigDecimal(f);
        }
        catch (Exception exception) {
            bigDecimalArray[0] = new BigDecimal(1);
            bigDecimalArray[1] = bigDecimal;
        }
        return bigDecimalArray;
    }

    public static BigDecimal[] parseDecimalfromDouble(double d) {
        BigDecimal bigDecimal;
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        bigDecimalArray[0] = bigDecimal = new BigDecimal(0);
        try {
            bigDecimalArray[1] = new BigDecimal(d);
        }
        catch (Exception exception) {
            bigDecimalArray[0] = new BigDecimal(1);
            bigDecimalArray[1] = bigDecimal;
        }
        return bigDecimalArray;
    }

    public static float[] parseFloatfromStr(char[] cArray) {
        float[] fArray = new float[2];
        fArray[0] = 0.0f;
        try {
            fArray[1] = Float.parseFloat(String.valueOf(cArray));
        }
        catch (Exception exception) {
            fArray[0] = 1.0f;
            fArray[1] = 0.0f;
        }
        return fArray;
    }

    public static double[] parseDoublefromStr(char[] cArray) {
        double[] dArray = new double[2];
        dArray[0] = 0.0;
        try {
            dArray[1] = Double.parseDouble(String.valueOf(cArray));
        }
        catch (Exception exception) {
            dArray[0] = 1.0;
            dArray[1] = 0.0;
        }
        return dArray;
    }

    public static int[] parseDateTime(char[] cArray) {
        int[] nArray;
        int[] nArray2;
        boolean bl;
        String string = String.valueOf(cArray);
        int[] nArray3 = new int[]{};
        if (cArray.length == 0) {
            return nArray3;
        }
        boolean bl2 = bl = cArray[0] == '-';
        if (bl) {
            string = string.substring(1);
        }
        try {
            String string2;
            int n = string.indexOf(84);
            String string3 = string.substring(n + 1);
            nArray2 = LibraryUtilities.parseTime(string3.toCharArray(), bl);
            if (nArray2.length == 0) {
                return nArray3;
            }
            boolean bl3 = false;
            if (nArray2[0] == 24 || nArray2[0] == -24) {
                bl3 = true;
                nArray2[0] = 0;
            }
            if ((nArray = LibraryUtilities.parseDate((string2 = string.substring(0, n)).toCharArray(), bl, bl3)).length == 0) {
                return nArray3;
            }
        }
        catch (Exception exception) {
            return nArray3;
        }
        return new int[]{nArray[0], nArray[1], nArray[2], nArray2[0], nArray2[1], nArray2[2], nArray2[3], nArray2[4], nArray2[5], nArray2[6]};
    }

    public static int[] parseDate(char[] cArray) {
        int[] nArray;
        boolean bl;
        int[] nArray2 = new int[]{};
        if (cArray.length == 0) {
            return nArray2;
        }
        String string = String.valueOf(cArray);
        boolean bl2 = bl = cArray[0] == '-';
        if (bl) {
            string = string.substring(1);
        }
        if ((nArray = LibraryUtilities.parseDate(string.toCharArray(), bl, false)).length == 0) {
            return nArray2;
        }
        return nArray;
    }

    private static int[] getDigits(char[] cArray, int n, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (cArray.length - n < n2) {
            return new int[]{-1};
        }
        int n4 = 0;
        for (int i = n; i < cArray.length && i < n3 + n; ++i) {
            if (Character.isDigit(cArray[i])) {
                stringBuffer.append(cArray[i]);
                ++n4;
                continue;
            }
            if (i >= n + n2) {
                return new int[]{n4, Integer.parseInt(stringBuffer.toString())};
            }
            return new int[]{-1};
        }
        return new int[]{n4, Integer.parseInt(stringBuffer.toString())};
    }

    private static int[] parseMilliSeconds(char[] cArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (Character.isDigit(cArray[n2])) {
            stringBuffer.append(cArray[n2]);
            if (++n2 != cArray.length) continue;
        }
        if (stringBuffer.length() == 0) {
            return new int[]{0, Integer.parseInt(stringBuffer.toString())};
        }
        if (stringBuffer.length() > 3) {
            stringBuffer.delete(3, stringBuffer.length());
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("00");
        } else if (stringBuffer.length() == 2) {
            stringBuffer.append("0");
        }
        return new int[]{n2 - n, Integer.parseInt(stringBuffer.toString())};
    }

    private static boolean checkChars(char[] cArray, int n, char[] cArray2) {
        if (n >= cArray.length) {
            return false;
        }
        for (int i = 0; i < cArray2.length; ++i) {
            if (cArray[n] != cArray2[i]) continue;
            return true;
        }
        return false;
    }

    private static boolean checkChars(char[] cArray, int n, char c) {
        if (n >= cArray.length) {
            return false;
        }
        return cArray[n] == c;
    }

    private static int[] parseDate(char[] cArray, boolean bl, boolean bl2) {
        int[] nArray = new int[6];
        int[] nArray2 = new int[]{};
        Arrays.fill(nArray, 0);
        int n = 0;
        try {
            int[] nArray3;
            int[] nArray4;
            int[] nArray5 = LibraryUtilities.getDigits(cArray, n, 4, 100);
            if (nArray5[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray5[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray5[0], '-')) {
                return nArray2;
            }
            if ((nArray4 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[1] = nArray4[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray4[0], '-')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[2] = nArray3[1];
            int[] nArray6 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray6.length == 0) {
                return nArray2;
            }
            nArray[3] = nArray6[0];
            nArray[4] = nArray6[1];
            nArray[5] = nArray6[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validYear(nArray[0])) {
            return nArray2;
        }
        if (!LibraryUtilities.validMonth(nArray[1])) {
            return nArray2;
        }
        if (!LibraryUtilities.validDayOfMonth(nArray[0], nArray[1], nArray[2])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[4])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[5])) {
            return nArray2;
        }
        if (bl2) {
            nArray[2] = nArray[2] + 1;
            if (!LibraryUtilities.validDayOfMonth(nArray[0], nArray[1], nArray[2])) {
                nArray[2] = 1;
                nArray[1] = nArray[1] + 1;
                if (!LibraryUtilities.validMonth(nArray[1])) {
                    nArray[1] = 1;
                    nArray[0] = nArray[0] + 1;
                }
            }
        }
        if (bl) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
            nArray[2] = nArray[2] * -1;
        }
        return nArray;
    }

    public static int[] parseTime(char[] cArray) {
        int[] nArray = new int[]{};
        if (cArray.length == 0) {
            return nArray;
        }
        int[] nArray2 = LibraryUtilities.parseTime(cArray, false);
        if (nArray2.length == 0) {
            return nArray;
        }
        if (nArray2[0] == 24) {
            nArray2[0] = 0;
        }
        return nArray2;
    }

    private static int[] parseTimeZone(char[] cArray, int n) {
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{};
        Arrays.fill(nArray, 0);
        if (cArray.length > n) {
            if (!LibraryUtilities.checkChars(cArray, n, new char[]{'-', '+', 'Z'})) {
                return nArray2;
            }
            nArray[0] = 1;
            if (LibraryUtilities.checkChars(cArray, n, 'Z')) {
                if (cArray.length != ++n) {
                    return nArray2;
                }
            } else {
                int[] nArray3;
                int[] nArray4;
                boolean bl = false;
                if (LibraryUtilities.checkChars(cArray, n, '-')) {
                    bl = true;
                }
                if ((nArray4 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                    return nArray2;
                }
                int n2 = nArray[1] = bl ? nArray4[1] * -1 : nArray4[1];
                if (!LibraryUtilities.checkChars(cArray, n += nArray4[0], ':')) {
                    return nArray2;
                }
                if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                    return nArray2;
                }
                nArray[2] = nArray3[1];
                if (cArray.length != (n += nArray3[0])) {
                    return nArray2;
                }
            }
        }
        return nArray;
    }

    private static int[] parseTime(char[] cArray, boolean bl) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[]{};
        int n = 0;
        Arrays.fill(nArray, 0);
        try {
            int[] nArray3;
            int[] nArray4;
            int[] nArray5 = LibraryUtilities.getDigits(cArray, n, 2, 2);
            if (nArray5[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray5[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray5[0], ':')) {
                return nArray2;
            }
            if ((nArray4 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[1] = nArray4[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray4[0], ':')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 100))[0] == -1) {
                return nArray2;
            }
            nArray[2] = nArray3[1];
            if (cArray.length > (n += nArray3[0])) {
                int[] nArray6;
                if (LibraryUtilities.checkChars(cArray, n, '.')) {
                    if ((nArray6 = LibraryUtilities.parseMilliSeconds(cArray, ++n))[0] == -1) {
                        return nArray2;
                    }
                    n += nArray6[0];
                    nArray[3] = nArray6[1];
                }
                if ((nArray6 = LibraryUtilities.parseTimeZone(cArray, n)).length == 0) {
                    return nArray2;
                }
                nArray[4] = nArray6[0];
                nArray[5] = nArray6[1];
                nArray[6] = nArray6[2];
            }
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validHour(nArray[0], nArray[1], nArray[2], nArray[3])) {
            return nArray2;
        }
        if (!LibraryUtilities.validMinOrSec(nArray[1])) {
            return nArray2;
        }
        if (!LibraryUtilities.validMinOrSec(nArray[2])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[5])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[6])) {
            return nArray2;
        }
        if (bl) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
            nArray[2] = nArray[2] * -1;
            nArray[3] = nArray[3] * -1;
        }
        return nArray;
    }

    public static int[] parseGDay(char[] cArray) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{};
        int n = 0;
        Arrays.fill(nArray, 0);
        try {
            int[] nArray3;
            if (!LibraryUtilities.checkChars(cArray, n, '-')) {
                return nArray2;
            }
            if (!LibraryUtilities.checkChars(cArray, ++n, '-')) {
                return nArray2;
            }
            if (!LibraryUtilities.checkChars(cArray, ++n, '-')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray3[1];
            int[] nArray4 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray4.length == 0) {
                return nArray2;
            }
            nArray[1] = nArray4[0];
            nArray[2] = nArray4[1];
            nArray[3] = nArray4[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (nArray[0] < 1 || nArray[0] > 31) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[2])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[3])) {
            return nArray2;
        }
        return nArray;
    }

    public static int[] parseGYear(char[] cArray) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{};
        int n = 0;
        boolean bl = false;
        Arrays.fill(nArray, 0);
        try {
            int[] nArray3;
            if (LibraryUtilities.checkChars(cArray, n, '-')) {
                bl = true;
                ++n;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, n, 4, 100))[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray3[1];
            int[] nArray4 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray4.length == 0) {
                return nArray2;
            }
            nArray[1] = nArray4[0];
            nArray[2] = nArray4[1];
            nArray[3] = nArray4[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validYear(nArray[0])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[2])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[3])) {
            return nArray2;
        }
        if (bl) {
            nArray[0] = nArray[0] * -1;
        }
        return nArray;
    }

    public static int[] parseGYearMonth(char[] cArray) {
        int[] nArray = new int[5];
        int[] nArray2 = new int[]{};
        int n = 0;
        Arrays.fill(nArray, 0);
        boolean bl = false;
        try {
            int[] nArray3;
            int[] nArray4;
            if (LibraryUtilities.checkChars(cArray, n, '-')) {
                bl = true;
                ++n;
            }
            if ((nArray4 = LibraryUtilities.getDigits(cArray, n, 4, 100))[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray4[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray4[0], '-')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[1] = nArray3[1];
            int[] nArray5 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray5.length == 0) {
                return nArray2;
            }
            nArray[2] = nArray5[0];
            nArray[3] = nArray5[1];
            nArray[4] = nArray5[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validYear(nArray[0])) {
            return nArray2;
        }
        if (!LibraryUtilities.validMonth(nArray[1])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[3])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[4])) {
            return nArray2;
        }
        if (bl) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
        }
        return nArray;
    }

    public static int[] parseGMonth(char[] cArray) {
        int[] nArray = new int[4];
        int[] nArray2 = new int[]{};
        int n = 0;
        Arrays.fill(nArray, 0);
        try {
            int[] nArray3;
            if (!LibraryUtilities.checkChars(cArray, n, '-')) {
                return nArray2;
            }
            if (!LibraryUtilities.checkChars(cArray, ++n, '-')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray3[1];
            int[] nArray4 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray4.length == 0) {
                return nArray2;
            }
            nArray[1] = nArray4[0];
            nArray[2] = nArray4[1];
            nArray[3] = nArray4[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validMonth(nArray[0])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[2])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[3])) {
            return nArray2;
        }
        return nArray;
    }

    public static int[] parseGMonthDay(char[] cArray) {
        int[] nArray = new int[5];
        int[] nArray2 = new int[]{};
        int n = 0;
        Arrays.fill(nArray, 0);
        try {
            int[] nArray3;
            int[] nArray4;
            if (!LibraryUtilities.checkChars(cArray, n, '-')) {
                return nArray2;
            }
            if (!LibraryUtilities.checkChars(cArray, ++n, '-')) {
                return nArray2;
            }
            if ((nArray4 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[0] = nArray4[1];
            if (!LibraryUtilities.checkChars(cArray, n += nArray4[0], '-')) {
                return nArray2;
            }
            if ((nArray3 = LibraryUtilities.getDigits(cArray, ++n, 2, 2))[0] == -1) {
                return nArray2;
            }
            nArray[1] = nArray3[1];
            int[] nArray5 = LibraryUtilities.parseTimeZone(cArray, n += nArray3[0]);
            if (nArray5.length == 0) {
                return nArray2;
            }
            nArray[2] = nArray5[0];
            nArray[3] = nArray5[1];
            nArray[4] = nArray5[2];
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!LibraryUtilities.validMonth(nArray[0])) {
            return nArray2;
        }
        if (!LibraryUtilities.validDayOfMonth(nArray[0], nArray[1])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZHour(nArray[3])) {
            return nArray2;
        }
        if (!LibraryUtilities.validTZMin(nArray[4])) {
            return nArray2;
        }
        return nArray;
    }

    public static int[] parseDuration(char[] cArray) {
        int[] nArray = new int[7];
        int[] nArray2 = new int[]{};
        Arrays.fill(nArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            block13: for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                switch (cArray[i]) {
                    case '-': {
                        if (i == 0) {
                            bl3 = true;
                            continue block13;
                        }
                        return nArray2;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && cArray[0] == '-') {
                            if (i + 1 == cArray.length) {
                                return nArray2;
                            }
                        } else {
                            return nArray2;
                        }
                        bl2 = true;
                        continue block13;
                    }
                    case 'Y': {
                        if (n != 0) {
                            return nArray2;
                        }
                        nArray[0] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        if (!bl) continue block13;
                        return nArray2;
                    }
                    case 'M': {
                        if (!bl) {
                            if (n != 0) {
                                return nArray2;
                            }
                            n = 1;
                            nArray[1] = Integer.parseInt(stringBuffer.toString());
                        } else {
                            if (n >= 4) {
                                return nArray2;
                            }
                            n = 4;
                            nArray[4] = Integer.parseInt(stringBuffer.toString());
                        }
                        stringBuffer = new StringBuffer();
                        continue block13;
                    }
                    case 'D': {
                        if (n >= 2) {
                            return nArray2;
                        }
                        n = 2;
                        nArray[2] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        if (!bl) continue block13;
                        return nArray2;
                    }
                    case 'T': {
                        if (bl || i == cArray.length - 1) {
                            return nArray2;
                        }
                        bl = true;
                        continue block13;
                    }
                    case 'H': {
                        if (n >= 3) {
                            return nArray2;
                        }
                        n = 3;
                        nArray[3] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        if (bl) continue block13;
                        return nArray2;
                    }
                    case 'S': {
                        if (n == 5) {
                            if (stringBuffer.length() > 3) {
                                stringBuffer.delete(3, stringBuffer.length());
                            } else {
                                while (stringBuffer.length() < 3) {
                                    stringBuffer.append('0');
                                }
                            }
                            nArray[6] = Integer.parseInt(stringBuffer.toString());
                        } else if (n < 5) {
                            nArray[5] = Integer.parseInt(stringBuffer.toString());
                        } else {
                            return nArray2;
                        }
                        n = 6;
                        stringBuffer = new StringBuffer();
                        if (bl) continue block13;
                        return nArray2;
                    }
                    case '.': {
                        if (n >= 5) {
                            return nArray2;
                        }
                        n = 5;
                        if (stringBuffer.length() > 0 && !stringBuffer.toString().equals("-")) {
                            nArray[5] = Integer.parseInt(stringBuffer.toString());
                            stringBuffer = new StringBuffer();
                        }
                        if (bl) continue block13;
                        return nArray2;
                    }
                    default: {
                        return nArray2;
                    }
                }
            }
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!bl2) {
            return nArray2;
        }
        if (bl3) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
            nArray[2] = nArray[2] * -1;
            nArray[3] = nArray[3] * -1;
            nArray[4] = nArray[4] * -1;
            nArray[5] = nArray[5] * -1;
            nArray[6] = nArray[6] * -1;
        }
        if (Math.abs(nArray[5]) >= 60) {
            nArray[4] = nArray[4] + nArray[5] / 60;
            nArray[5] = nArray[5] % 60;
        }
        if (Math.abs(nArray[4]) >= 60) {
            nArray[3] = nArray[3] + nArray[4] / 60;
            nArray[4] = nArray[4] % 60;
        }
        if (Math.abs(nArray[3]) >= 24) {
            nArray[2] = nArray[2] + nArray[3] / 24;
            nArray[3] = nArray[3] % 24;
        }
        if (Math.abs(nArray[1]) >= 12) {
            nArray[0] = nArray[0] + nArray[1] / 12;
            nArray[1] = nArray[1] % 12;
        }
        return nArray;
    }

    public static int[] parseDayTimeDuration(char[] cArray) {
        int[] nArray = new int[5];
        int[] nArray2 = new int[]{};
        Arrays.fill(nArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            block12: for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    if (i == cArray.length - 1) {
                        return nArray2;
                    }
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                switch (cArray[i]) {
                    case '-': {
                        if (i == 0) {
                            bl3 = true;
                            continue block12;
                        }
                        return nArray2;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && cArray[0] == '-') {
                            if (i + 1 == cArray.length) {
                                return nArray2;
                            }
                        } else {
                            return nArray2;
                        }
                        bl2 = true;
                        continue block12;
                    }
                    case 'M': {
                        if (n >= 2) {
                            return nArray2;
                        }
                        n = 2;
                        nArray[2] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        bl4 = true;
                        continue block12;
                    }
                    case 'D': {
                        if (n > 0) {
                            return nArray2;
                        }
                        n = 0;
                        nArray[0] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        if (!bl) continue block12;
                        return nArray2;
                    }
                    case 'T': {
                        if (bl || i == cArray.length - 1) {
                            return nArray2;
                        }
                        if (stringBuffer.length() > 0) {
                            return nArray2;
                        }
                        if (bl4) {
                            return nArray2;
                        }
                        bl = true;
                        continue block12;
                    }
                    case 'H': {
                        if (n >= 1) {
                            return nArray2;
                        }
                        n = 1;
                        nArray[1] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        bl4 = true;
                        continue block12;
                    }
                    case 'S': {
                        if (n == 3) {
                            if (stringBuffer.length() > 3) {
                                stringBuffer.delete(3, stringBuffer.length());
                            } else {
                                while (stringBuffer.length() < 3) {
                                    stringBuffer.append('0');
                                }
                            }
                            nArray[4] = Integer.parseInt(stringBuffer.toString());
                        } else if (n < 3) {
                            nArray[3] = Integer.parseInt(stringBuffer.toString());
                        } else {
                            return nArray2;
                        }
                        n = 4;
                        stringBuffer = new StringBuffer();
                        bl4 = true;
                        continue block12;
                    }
                    case '.': {
                        if (n >= 3) {
                            return nArray2;
                        }
                        n = 3;
                        if (stringBuffer.length() <= 0 || stringBuffer.toString().equals("-")) continue block12;
                        nArray[3] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue block12;
                    }
                    default: {
                        return nArray2;
                    }
                }
            }
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!bl2) {
            return nArray2;
        }
        if (bl3) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
            nArray[2] = nArray[2] * -1;
            nArray[3] = nArray[3] * -1;
            nArray[4] = nArray[4] * -1;
        }
        if (Math.abs(nArray[3]) >= 60) {
            nArray[2] = nArray[2] + nArray[3] / 60;
            nArray[3] = nArray[3] % 60;
        }
        if (Math.abs(nArray[2]) >= 60) {
            nArray[1] = nArray[1] + nArray[2] / 60;
            nArray[2] = nArray[2] % 60;
        }
        if (Math.abs(nArray[1]) >= 24) {
            nArray[0] = nArray[0] + nArray[1] / 24;
            nArray[1] = nArray[1] % 24;
        }
        return nArray;
    }

    public static int[] parseYearMonthDuration(char[] cArray) {
        int[] nArray = new int[2];
        int[] nArray2 = new int[]{};
        Arrays.fill(nArray, 0);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            block8: for (int i = 0; i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) {
                    if (i == cArray.length - 1) {
                        return nArray2;
                    }
                    stringBuffer.append(cArray[i]);
                    continue;
                }
                switch (cArray[i]) {
                    case '-': {
                        if (i == 0) {
                            bl3 = true;
                            continue block8;
                        }
                        return nArray2;
                    }
                    case 'P': {
                        if (i == 0 || i == 1 && cArray[0] == '-') {
                            if (i + 1 == cArray.length) {
                                return nArray2;
                            }
                        } else {
                            return nArray2;
                        }
                        bl2 = true;
                        continue block8;
                    }
                    case 'Y': {
                        if (bl) {
                            return nArray2;
                        }
                        nArray[0] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue block8;
                    }
                    case 'M': {
                        if (bl) {
                            return nArray2;
                        }
                        nArray[1] = Integer.parseInt(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue block8;
                    }
                    default: {
                        return nArray2;
                    }
                }
            }
        }
        catch (Exception exception) {
            return nArray2;
        }
        if (!bl2) {
            return nArray2;
        }
        if (bl3) {
            nArray[0] = nArray[0] * -1;
            nArray[1] = nArray[1] * -1;
        }
        if (Math.abs(nArray[1]) >= 12) {
            nArray[0] = nArray[0] + nArray[1] / 12;
            nArray[1] = nArray[1] % 12;
        }
        return nArray;
    }

    public static byte[] parseHexBinary(char[] cArray) {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2 = HexBin.decode(String.valueOf(cArray));
            if (byArray2 == null) {
                return byArray;
            }
            return byArray2;
        }
        catch (Exception exception) {
            return byArray;
        }
    }

    public static byte[] parseBase64Binary(char[] cArray) {
        byte[] byArray = new byte[]{};
        try {
            byte[] byArray2 = Base64.decode(String.valueOf(cArray));
            if (byArray2 == null) {
                return byArray;
            }
            return byArray2;
        }
        catch (Exception exception) {
            return byArray;
        }
    }

    public static int[] getImplicitTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        int[] nArray = new int[2];
        if (n == 0) {
            nArray[0] = 0;
            nArray[1] = 0;
        } else {
            nArray[0] = (int)Math.floor((n /= 60000) / 60);
            nArray[1] = n % 60;
        }
        return nArray;
    }

    private static boolean validMonth(int n) {
        return n > 0 && n <= 12;
    }

    private static boolean validYear(int n) {
        return n != 0;
    }

    private static boolean validDayOfMonth(int n, int n2, int n3) {
        if (n3 <= 0) {
            return false;
        }
        if (n2 == 2 && (n % 100 != 0 && n % 4 == 0 || n % 400 == 0)) {
            return n3 <= 29;
        }
        return n3 <= daysInMonth[n2 - 1];
    }

    private static boolean validDayOfMonth(int n, int n2) {
        if (n2 <= 0) {
            return false;
        }
        if (n == 2) {
            return n2 <= 29;
        }
        return n2 <= daysInMonth[n - 1];
    }

    private static boolean validHour(int n, int n2, int n3, int n4) {
        if (n < 24 && n >= 0) {
            return true;
        }
        return n == 24 && n2 == 0 && n3 == 0 && n4 == 0;
    }

    private static boolean validMinOrSec(int n) {
        return n < 60 && n >= 0;
    }

    private static boolean validTZHour(int n) {
        return n >= -14 && n <= 14;
    }

    private static boolean validTZMin(int n) {
        return n == 0 || n == 30 || n == 45;
    }

    public static boolean validURI(char[] cArray) {
        try {
            AnyURIDV anyURIDV = new AnyURIDV();
            anyURIDV.getActualValue(String.valueOf(cArray), null);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int[] addYearMonthDurationToDate(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        boolean bl = n4 > 24;
        XDate xDate = bl ? new XDate(n, n2, n3) : new XDate(n, n2, n3, n4, n5);
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n6, n7);
        XDate xDate2 = xDate.add(xYearMonthDuration);
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = xDate2.getYear();
            nArray2[1] = xDate2.getMonth();
            nArray = nArray2;
            nArray2[2] = xDate2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = xDate2.getYear();
            nArray3[1] = xDate2.getMonth();
            nArray3[2] = xDate2.getDay();
            nArray3[3] = xDate2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = xDate2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToDate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int[] nArray;
        boolean bl = n4 > 24;
        XDate xDate = bl ? new XDate(n, n2, n3) : new XDate(n, n2, n3, n4, n5);
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n6, n7, n8, (double)n9 + (double)n10 / 1000.0);
        XDate xDate2 = xDate.add(xDayTimeDuration);
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = xDate2.getYear();
            nArray2[1] = xDate2.getMonth();
            nArray = nArray2;
            nArray2[2] = xDate2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = xDate2.getYear();
            nArray3[1] = xDate2.getMonth();
            nArray3[2] = xDate2.getDay();
            nArray3[3] = xDate2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = xDate2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int[] nArray;
        boolean bl = n5 > 24;
        double d = (double)(n3 * 1000 + n4) / 1000.0;
        XTime xTime = bl ? new XTime(n, n2, d) : new XTime(n, n2, d, n5, n6);
        double d2 = (double)(n10 * 1000 + n11) / 1000.0;
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n7, n8, n9, d2);
        XTime xTime2 = xTime.add(xDayTimeDuration);
        double d3 = xTime2.getSecond();
        double d4 = (d3 - (double)((int)d3)) * 1000.0;
        long l = Math.round(d4);
        if (bl) {
            int[] nArray2 = new int[4];
            nArray2[0] = xTime2.getHour();
            nArray2[1] = xTime2.getMinute();
            nArray2[2] = (int)d3;
            nArray = nArray2;
            nArray2[3] = (int)Math.round((d3 - (double)((int)d3)) * 1000.0);
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = xTime2.getHour();
            nArray3[1] = xTime2.getMinute();
            nArray3[2] = (int)d3;
            nArray3[3] = (int)l;
            nArray3[4] = xTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[5] = xTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addYearMonthDurationToDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int[] nArray;
        boolean bl = n8 > 24;
        XDateTime xDateTime = bl ? new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0) : new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0, n8, n9);
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n10, n11);
        XDateTime xDateTime2 = xDateTime.add(xYearMonthDuration);
        double d = xDateTime2.getSecond();
        if (bl) {
            int[] nArray2 = new int[7];
            nArray2[0] = xDateTime2.getYear();
            nArray2[1] = xDateTime2.getMonth();
            nArray2[2] = xDateTime2.getDay();
            nArray2[3] = xDateTime2.getHour();
            nArray2[4] = xDateTime2.getMinute();
            nArray2[5] = (int)d;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = xDateTime2.getYear();
            nArray3[1] = xDateTime2.getMonth();
            nArray3[2] = xDateTime2.getDay();
            nArray3[3] = xDateTime2.getHour();
            nArray3[4] = xDateTime2.getMinute();
            nArray3[5] = (int)d;
            nArray3[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
            nArray3[7] = xDateTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = xDateTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addDayTimeDurationToDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        int[] nArray;
        boolean bl = n8 > 24;
        XDateTime xDateTime = bl ? new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0) : new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0, n8, n9);
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n10, n11, n12, (double)n13 + (double)n14 / 1000.0);
        XDateTime xDateTime2 = xDateTime.add(xDayTimeDuration);
        double d = xDateTime2.getSecond();
        if (bl) {
            int[] nArray2 = new int[7];
            nArray2[0] = xDateTime2.getYear();
            nArray2[1] = xDateTime2.getMonth();
            nArray2[2] = xDateTime2.getDay();
            nArray2[3] = xDateTime2.getHour();
            nArray2[4] = xDateTime2.getMinute();
            nArray2[5] = (int)d;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = xDateTime2.getYear();
            nArray3[1] = xDateTime2.getMonth();
            nArray3[2] = xDateTime2.getDay();
            nArray3[3] = xDateTime2.getHour();
            nArray3[4] = xDateTime2.getMinute();
            nArray3[5] = (int)d;
            nArray3[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
            nArray3[7] = xDateTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = xDateTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] addYearMonthDurations(int n, int n2, int n3, int n4) {
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n, n2);
        XYearMonthDuration xYearMonthDuration2 = new XYearMonthDuration(n3, n4);
        XYearMonthDuration xYearMonthDuration3 = xYearMonthDuration.add(xYearMonthDuration2);
        return new int[]{xYearMonthDuration3.getYears(), xYearMonthDuration3.getMonths()};
    }

    public static int[] addDayTimeDurations(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, n2, n3, (double)n4 + (double)n5 / 1000.0);
        XDayTimeDuration xDayTimeDuration2 = new XDayTimeDuration(n6, n7, n8, (double)n9 + (double)n10 / 1000.0);
        XDayTimeDuration xDayTimeDuration3 = xDayTimeDuration.add(xDayTimeDuration2);
        double d = xDayTimeDuration3.getSeconds();
        return new int[]{xDayTimeDuration3.getDays(), xDayTimeDuration3.getHours(), xDayTimeDuration3.getMinutes(), (int)d, (int)Math.round((d - (double)((int)d)) * 1000.0)};
    }

    public static int[] subtractYearMonthDurationFromDate(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray;
        boolean bl = n4 > 24;
        XDate xDate = bl ? new XDate(n, n2, n3) : new XDate(n, n2, n3, n4, n5);
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n6, n7);
        XDate xDate2 = xDate.subtract(xYearMonthDuration);
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = xDate2.getYear();
            nArray2[1] = xDate2.getMonth();
            nArray = nArray2;
            nArray2[2] = xDate2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = xDate2.getYear();
            nArray3[1] = xDate2.getMonth();
            nArray3[2] = xDate2.getDay();
            nArray3[3] = xDate2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = xDate2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDayTimeDurationFromDate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int[] nArray;
        boolean bl = n4 > 24;
        XDate xDate = bl ? new XDate(n, n2, n3) : new XDate(n, n2, n3, n4, n5);
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n6, n7, n8, (double)n9 + (double)n10 / 1000.0);
        XDate xDate2 = xDate.subtract(xDayTimeDuration);
        if (bl) {
            int[] nArray2 = new int[3];
            nArray2[0] = xDate2.getYear();
            nArray2[1] = xDate2.getMonth();
            nArray = nArray2;
            nArray2[2] = xDate2.getDay();
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = xDate2.getYear();
            nArray3[1] = xDate2.getMonth();
            nArray3[2] = xDate2.getDay();
            nArray3[3] = xDate2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[4] = xDate2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractTimes(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        XTime xTime = new XTime(n, n2, (double)n3 + (double)n4 / 1000.0, n5, n6);
        XTime xTime2 = new XTime(n7, n8, (double)n9 + (double)n10 / 1000.0, n11, n12);
        XDayTimeDuration xDayTimeDuration = xTime.subtract(xTime2);
        double d = xDayTimeDuration.getSeconds();
        return new int[]{xDayTimeDuration.getDays(), xDayTimeDuration.getHours(), xDayTimeDuration.getMinutes(), (int)d, (int)Math.round((d - (double)((int)d)) * 1000.0)};
    }

    public static int[] subtractDayTimeDurationFromTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int[] nArray;
        boolean bl = n5 > 24;
        XTime xTime = bl ? new XTime(n, n2, (double)n3 + (double)n4 / 1000.0) : new XTime(n, n2, (double)n3 + (double)n4 / 1000.0, n5, n6);
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n7, n8, n9, (double)n10 + (double)n11 / 1000.0);
        XTime xTime2 = xTime.subtract(xDayTimeDuration);
        double d = xTime2.getSecond();
        if (bl) {
            int[] nArray2 = new int[4];
            nArray2[0] = xTime2.getHour();
            nArray2[1] = xTime2.getMinute();
            nArray2[2] = (int)d;
            nArray = nArray2;
            nArray2[3] = (int)(d * 1000.0) - (int)d * 1000;
        } else {
            int[] nArray3 = new int[6];
            nArray3[0] = xTime2.getHour();
            nArray3[1] = xTime2.getMinute();
            nArray3[2] = (int)d;
            nArray3[3] = (int)(d * 1000.0) - (int)d * 1000;
            nArray3[4] = xTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[5] = xTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractYearMonthDurationFromDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        int[] nArray;
        boolean bl = n8 > 24;
        XDateTime xDateTime = bl ? new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0) : new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0, n8, n9);
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n10, n11);
        XDateTime xDateTime2 = xDateTime.subtract(xYearMonthDuration);
        double d = xDateTime2.getSecond();
        if (bl) {
            int[] nArray2 = new int[7];
            nArray2[0] = xDateTime2.getYear();
            nArray2[1] = xDateTime2.getMonth();
            nArray2[2] = xDateTime2.getDay();
            nArray2[3] = xDateTime2.getHour();
            nArray2[4] = xDateTime2.getMinute();
            nArray2[5] = (int)d;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = xDateTime2.getYear();
            nArray3[1] = xDateTime2.getMonth();
            nArray3[2] = xDateTime2.getDay();
            nArray3[3] = xDateTime2.getHour();
            nArray3[4] = xDateTime2.getMinute();
            nArray3[5] = (int)d;
            nArray3[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
            nArray3[7] = xDateTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = xDateTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDayTimeDurationFromDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        int[] nArray;
        boolean bl = n8 > 24;
        XDateTime xDateTime = bl ? new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0) : new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0, n8, n9);
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n10, n11, n12, (double)n13 + (double)n14 / 1000.0);
        XDateTime xDateTime2 = xDateTime.subtract(xDayTimeDuration);
        double d = xDateTime2.getSecond();
        if (bl) {
            int[] nArray2 = new int[7];
            nArray2[0] = xDateTime2.getYear();
            nArray2[1] = xDateTime2.getMonth();
            nArray2[2] = xDateTime2.getDay();
            nArray2[3] = xDateTime2.getHour();
            nArray2[4] = xDateTime2.getMinute();
            nArray2[5] = (int)d;
            nArray = nArray2;
            nArray2[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = xDateTime2.getYear();
            nArray3[1] = xDateTime2.getMonth();
            nArray3[2] = xDateTime2.getDay();
            nArray3[3] = xDateTime2.getHour();
            nArray3[4] = xDateTime2.getMinute();
            nArray3[5] = (int)d;
            nArray3[6] = (int)Math.round((d - (double)((int)d)) * 1000.0);
            nArray3[7] = xDateTime2.getTimeZoneHour();
            nArray = nArray3;
            nArray3[8] = xDateTime2.getTimeZoneMinute();
        }
        return nArray;
    }

    public static int[] subtractDatesYieldingDayTimeDuration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        XDate xDate = new XDate(n, n2, n3, n4, n5);
        XDate xDate2 = new XDate(n6, n7, n8, n9, n10);
        XDayTimeDuration xDayTimeDuration = xDate.subtract(xDate2);
        double d = xDayTimeDuration.getSeconds();
        return new int[]{xDayTimeDuration.getDays(), xDayTimeDuration.getHours(), xDayTimeDuration.getMinutes(), (int)d, (int)Math.round((d - (double)((int)d)) * 1000.0)};
    }

    public static int[] subtractDateTimesYieldingDayTimeDuration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        XDateTime xDateTime = new XDateTime(n, n2, n3, n4, n5, (double)n6 + (double)n7 / 1000.0, n8, n9);
        XDateTime xDateTime2 = new XDateTime(n10, n11, n12, n13, n14, (double)n15 + (double)n16 / 1000.0, n17, n18);
        XDayTimeDuration xDayTimeDuration = xDateTime.subtract(xDateTime2);
        double d = xDayTimeDuration.getSeconds();
        return new int[]{xDayTimeDuration.getDays(), xDayTimeDuration.getHours(), xDayTimeDuration.getMinutes(), (int)d, (int)Math.round((d - (double)((int)d)) * 1000.0)};
    }

    public static int[] subtractYearMonthDurations(int n, int n2, int n3, int n4) {
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n, n2);
        XYearMonthDuration xYearMonthDuration2 = new XYearMonthDuration(n3, n4);
        XYearMonthDuration xYearMonthDuration3 = xYearMonthDuration.subtract(xYearMonthDuration2);
        return new int[]{xYearMonthDuration3.getYears(), xYearMonthDuration3.getMonths()};
    }

    public static int[] subtractDayTimeDurations(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, n2, n3, (double)n4 + (double)n5 / 1000.0);
        XDayTimeDuration xDayTimeDuration2 = new XDayTimeDuration(n6, n7, n8, (double)n9 + (double)n10 / 1000.0);
        XDayTimeDuration xDayTimeDuration3 = xDayTimeDuration.subtract(xDayTimeDuration2);
        double d = xDayTimeDuration3.getSeconds();
        return new int[]{xDayTimeDuration3.getDays(), xDayTimeDuration3.getHours(), xDayTimeDuration3.getMinutes(), (int)d, (int)Math.round((d - (double)((int)d)) * 1000.0)};
    }

    public static int[] multiplyYearMonthDuration(int n, int n2, double d) {
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n, n2);
        XYearMonthDuration xYearMonthDuration2 = xYearMonthDuration.multiply(d);
        return new int[]{xYearMonthDuration2.getYears(), xYearMonthDuration2.getMonths()};
    }

    public static int[] multiplyDayTimeDuration(int n, int n2, int n3, int n4, int n5, double d) {
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, n2, n3, (double)n4 + (double)n5 / 1000.0);
        XDayTimeDuration xDayTimeDuration2 = xDayTimeDuration.multiply(d);
        double d2 = xDayTimeDuration2.getSeconds();
        return new int[]{xDayTimeDuration2.getDays(), xDayTimeDuration2.getHours(), xDayTimeDuration2.getMinutes(), (int)d2, (int)Math.round((d2 - (double)((int)d2)) * 1000.0)};
    }

    public static int[] DivideYearMonthDuration(int n, int n2, double d) {
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n, n2);
        XYearMonthDuration xYearMonthDuration2 = xYearMonthDuration.divide(d);
        return new int[]{xYearMonthDuration2.getYears(), xYearMonthDuration2.getMonths()};
    }

    public static int[] DivideDayTimeDuration(int n, int n2, int n3, int n4, int n5, double d) {
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, n2, n3, (double)n4 + (double)n5 / 1000.0);
        XDayTimeDuration xDayTimeDuration2 = xDayTimeDuration.divide(d);
        double d2 = xDayTimeDuration2.getSeconds();
        return new int[]{xDayTimeDuration2.getDays(), xDayTimeDuration2.getHours(), xDayTimeDuration2.getMinutes(), (int)d2, (int)Math.round((d2 - (double)((int)d2)) * 1000.0)};
    }

    public static BigDecimal divideYearMonthDurationByYearMonthDuration(int n, int n2, int n3, int n4) {
        XYearMonthDuration xYearMonthDuration = new XYearMonthDuration(n, n2);
        XYearMonthDuration xYearMonthDuration2 = new XYearMonthDuration(n3, n4);
        double d = xYearMonthDuration.divide(xYearMonthDuration2);
        return new BigDecimal(d).setScale(4, 4);
    }

    public static BigDecimal divideDayTimeDurationByDayTimeDuration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        XDayTimeDuration xDayTimeDuration = new XDayTimeDuration(n, n2, n3, (double)n4 + (double)n5 / 1000.0);
        XDayTimeDuration xDayTimeDuration2 = new XDayTimeDuration(n6, n7, n8, (double)n9 + (double)n10 / 1000.0);
        double d = xDayTimeDuration.divide(xDayTimeDuration2);
        return new BigDecimal(d).setScale(4, 4);
    }

    public static int[] currentDateTime() {
        Calendar calendar = GregorianCalendar.getInstance();
        int[] nArray = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), 0};
        return nArray;
    }

    public static int[] currentTZ() {
        int[] nArray = new int[2];
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset() / 1000 / 60;
        nArray[0] = (int)Math.floor(n / 60);
        nArray[1] = Math.abs(n) - Math.abs(nArray[0] * 60);
        return nArray;
    }

    public static int getJavaType(Object object) {
        if (object == null) {
            return 1024;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            return 512;
        }
        for (int i = 0; i < CLASS_ARRAY.length; ++i) {
            if (clazz != CLASS_ARRAY[i]) continue;
            return i;
        }
        return -1;
    }

    public static char[] getBaseTypeString(XSTypeDefinition xSTypeDefinition) {
        short s = 3;
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "string", s)) {
            return "String".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "boolean", s)) {
            return "Boolean".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "integer", s)) {
            return "Integer".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "decimal", s)) {
            return "Decimal".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "float", s)) {
            return "Float".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "double", s)) {
            return "Double".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "hexBinary", s)) {
            return "HexBinary".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "base64Binary", s)) {
            return "Base64Binary".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "dateTime", s)) {
            return "DateTime".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "date", s)) {
            return "Date".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "time", s)) {
            return "Time".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYear", s)) {
            return "GYear".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gYearMonth", s)) {
            return "GYearMonth".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonthDay", s)) {
            return "GMonthDay".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gMonth", s)) {
            return "GMonth".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "gDay", s)) {
            return "GDay".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "duration", s)) {
            return "Duration".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "anyURI", s)) {
            return "AnyURI".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "QName", s)) {
            return "QName".toCharArray();
        }
        if (xSTypeDefinition.derivedFrom("http://www.w3.org/2001/XMLSchema", "NOTATION", s)) {
            return "Notation".toCharArray();
        }
        return null;
    }

    public static char[] validateSchemaString(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        char[] cArray2 = new char[]{};
        String string = String.valueOf(cArray);
        try {
            XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
            XValidationContext xValidationContext = new XValidationContext(hashtable);
            ValidatedInfo validatedInfo = new ValidatedInfo();
            xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
            Object object = validatedInfo.actualValue;
            return ((String)object).toCharArray();
        }
        catch (Exception exception) {
            return cArray2;
        }
    }

    public static boolean isValidSchemaString(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        String string = String.valueOf(cArray);
        try {
            if (xSTypeDefinition instanceof XSSimpleType) {
                XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                XValidationContext xValidationContext = new XValidationContext(hashtable);
                ValidatedInfo validatedInfo = new ValidatedInfo();
                xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                Object object = validatedInfo.actualValue;
                return object instanceof String;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static double[] validateSchemaDouble(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        double[] dArray;
        block4: {
            dArray = new double[]{};
            double[] dArray2 = new double[1];
            String string = String.valueOf(cArray);
            try {
                if (xSTypeDefinition instanceof XSSimpleType) {
                    XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                    XValidationContext xValidationContext = new XValidationContext(hashtable);
                    ValidatedInfo validatedInfo = new ValidatedInfo();
                    xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                    Object object = validatedInfo.actualValue;
                    if (object instanceof XSDouble) {
                        XSDouble xSDouble = (XSDouble)object;
                        dArray2[0] = xSDouble.getValue();
                        return dArray2;
                    }
                    break block4;
                }
                return dArray;
            }
            catch (Exception exception) {
                return dArray;
            }
        }
        return dArray;
    }

    public static float[] validateSchemaFloat(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        float[] fArray;
        block4: {
            fArray = new float[]{};
            float[] fArray2 = new float[1];
            String string = String.valueOf(cArray);
            try {
                if (xSTypeDefinition instanceof XSSimpleType) {
                    XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                    XValidationContext xValidationContext = new XValidationContext(hashtable);
                    ValidatedInfo validatedInfo = new ValidatedInfo();
                    xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                    Object object = validatedInfo.actualValue;
                    if (object instanceof XSFloat) {
                        XSFloat xSFloat = (XSFloat)object;
                        fArray2[0] = xSFloat.getValue();
                        return fArray2;
                    }
                    break block4;
                }
                return fArray;
            }
            catch (Exception exception) {
                return fArray;
            }
        }
        return fArray;
    }

    public static int[] validateSchemaInteger(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        int[] nArray;
        block4: {
            nArray = new int[]{};
            int[] nArray2 = new int[1];
            String string = String.valueOf(cArray);
            try {
                if (xSTypeDefinition instanceof XSSimpleType) {
                    XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                    XValidationContext xValidationContext = new XValidationContext(hashtable);
                    ValidatedInfo validatedInfo = new ValidatedInfo();
                    xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                    Object object = validatedInfo.actualValue;
                    if (object instanceof XSDecimal) {
                        XSDecimal xSDecimal = (XSDecimal)object;
                        nArray2[0] = xSDecimal.getInt();
                        return nArray2;
                    }
                    break block4;
                }
                return nArray;
            }
            catch (Exception exception) {
                return nArray;
            }
        }
        return nArray;
    }

    public static BigDecimal[] validateSchemaDecimal(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        BigDecimal[] bigDecimalArray;
        block4: {
            bigDecimalArray = new BigDecimal[]{};
            BigDecimal[] bigDecimalArray2 = new BigDecimal[1];
            String string = String.valueOf(cArray);
            try {
                if (xSTypeDefinition instanceof XSSimpleType) {
                    XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                    XValidationContext xValidationContext = new XValidationContext(hashtable);
                    ValidatedInfo validatedInfo = new ValidatedInfo();
                    xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                    Object object = validatedInfo.actualValue;
                    if (object instanceof XSDecimal) {
                        XSDecimal xSDecimal = (XSDecimal)object;
                        bigDecimalArray2[0] = xSDecimal.getBigDecimal();
                        return bigDecimalArray2;
                    }
                    break block4;
                }
                return bigDecimalArray;
            }
            catch (Exception exception) {
                return bigDecimalArray;
            }
        }
        return bigDecimalArray;
    }

    public static byte[] validateSchemaHexBase64Binary(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        byte[] byArray = new byte[]{};
        String string = String.valueOf(cArray);
        try {
            XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
            XValidationContext xValidationContext = new XValidationContext(hashtable);
            ValidatedInfo validatedInfo = new ValidatedInfo();
            xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
            Object object = validatedInfo.actualValue;
            ByteList byteList = (ByteList)object;
            int n = byteList.getLength();
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = byteList.item(i);
            }
            return byArray2;
        }
        catch (Exception exception) {
            return byArray;
        }
    }

    public static boolean isValidSchemaHexBase64Binary(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        String string = String.valueOf(cArray);
        try {
            if (xSTypeDefinition instanceof XSSimpleType) {
                XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                XValidationContext xValidationContext = new XValidationContext(hashtable);
                ValidatedInfo validatedInfo = new ValidatedInfo();
                xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                Object object = validatedInfo.actualValue;
                return object instanceof ByteList;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int[] validateSchemaDateTime(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        int[] nArray;
        block4: {
            nArray = new int[]{};
            int[] nArray2 = new int[10];
            String string = String.valueOf(cArray);
            try {
                if (xSTypeDefinition instanceof XSSimpleType) {
                    XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                    XValidationContext xValidationContext = new XValidationContext(hashtable);
                    ValidatedInfo validatedInfo = new ValidatedInfo();
                    xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                    Object object = validatedInfo.actualValue;
                    if (object instanceof XSDateTime) {
                        XSDateTime xSDateTime = (XSDateTime)object;
                        nArray2[0] = xSDateTime.getYears();
                        nArray2[1] = xSDateTime.getMonths();
                        nArray2[2] = xSDateTime.getDays();
                        nArray2[3] = xSDateTime.getHours();
                        nArray2[4] = xSDateTime.getMinutes();
                        double d = xSDateTime.getSeconds();
                        nArray2[5] = (int)Math.floor(d);
                        nArray2[6] = (int)Math.floor(d % 1.0 * 1000.0);
                        nArray2[7] = xSDateTime.hasTimeZone() ? 1 : 0;
                        nArray2[8] = xSDateTime.getTimeZoneHours();
                        nArray2[9] = xSDateTime.getTimeZoneMinutes();
                        return nArray2;
                    }
                    break block4;
                }
                return nArray;
            }
            catch (Exception exception) {
                return nArray;
            }
        }
        return nArray;
    }

    public static QName validateSchemaQName(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        String string = String.valueOf(cArray);
        try {
            XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
            XValidationContext xValidationContext = new XValidationContext(hashtable);
            ValidatedInfo validatedInfo = new ValidatedInfo();
            xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
            Object object = validatedInfo.actualValue;
            XSQName xSQName = (XSQName)object;
            return xSQName.getJAXPQName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isValidSchemaQName(XSTypeDefinition xSTypeDefinition, char[] cArray, Hashtable hashtable) {
        String string = String.valueOf(cArray);
        try {
            if (xSTypeDefinition instanceof XSSimpleType) {
                XSSimpleType xSSimpleType = (XSSimpleType)xSTypeDefinition;
                XValidationContext xValidationContext = new XValidationContext(hashtable);
                ValidatedInfo validatedInfo = new ValidatedInfo();
                xSSimpleType.validate(string, (ValidationContext)xValidationContext, validatedInfo);
                Object object = validatedInfo.actualValue;
                return object instanceof XSQName;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

