/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.partialeval;

import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.instructions.GetStringValueInstruction;
import com.ibm.xtq.xslt.xylem.instructions.NodeSetInstruction;
import com.ibm.xtq.xslt.xylem.optimizers.VariableDefinitionOptimizer;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xtq.xslt.xylem.types.SAXEventsLibrary;
import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Type;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LengthInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xylem.instructions.NotInstruction;
import com.ibm.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xylem.instructions.PrimitiveToStringInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.OptimizerUtilities;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.BooleanType;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.DoubleType;
import com.ibm.xylem.types.IntType;
import com.ibm.xylem.types.NamedType;
import java.io.Serializable;
import java.util.Set;

public class CoerceEvaluator
extends PartialEvaluator {
    private boolean m_isDebug = false;
    private final Type s_ftdRefType = new NamedType("FTD");

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction instruction, PartialInformationCollector partialInformationCollector, LetInstruction letInstruction, LetChainManager letChainManager) {
        Serializable serializable;
        Object object;
        if (this.m_isDebug) {
            System.out.println("CoerceEvaluator called.");
        }
        CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
        Instruction instruction2 = coerceInstruction.getOperand();
        Set set = partialInformationCollector.partiallyEvaluate(instruction2, letChainManager);
        Type type = partialInformationCollector.resolveType(instruction2);
        Type type2 = partialInformationCollector.resolveType(coerceInstruction);
        if (type == null || type2 == null) {
            throw new RuntimeException();
        }
        Instruction instruction3 = letChainManager.lookupBinding(instruction2);
        Module module = partialInformationCollector.getCurrentModule();
        if (type.equals(type2)) {
            return new PartialEvaluationResult(instruction2, set);
        }
        if (instruction3 instanceof FunctionCallInstruction) {
            object = (FunctionCallInstruction)instruction3;
            serializable = letChainManager.getCurrentFunction().getTypeEnvironment().getModule().getFunction(((FunctionCallInstruction)object).getFunction());
            int n = 0;
            if (n < ((Function)serializable).m_parameters.length) {
                CoersionDerivative coersionDerivative = new CoersionDerivative(type2);
                Function function = ((Function)serializable).lookupDerivative(coersionDerivative);
                if (function == null) {
                    function = ((Function)serializable).cloneFunctionForFixup(coersionDerivative, true, true, true);
                    function.setMemoizeResult(((Function)serializable).getMemoizeResult());
                    String string = OptimizerUtilities.generateIntermediateIdentifier();
                    function.setBody(CoerceEvaluator.moveToBottom(function.getBody(), string, new CoerceInstruction(new IdentifierInstruction(string), type2)));
                    module.addFunction(function);
                }
                object = (FunctionCallInstruction)((NaryPrimopInstruction)object).cloneReduced();
                ((FunctionCallInstruction)object).setFunction(function.getName());
                return new PartialEvaluationResult((Instruction)object, true);
            }
        }
        if (type.equals(IntType.s_intType) && type2.equals(CharType.s_charType.getStreamType())) {
            return new PartialEvaluationResult((Instruction)new PrimitiveToStringInstruction(instruction2), true);
        }
        if (type.equals(CursorType.s_cursorType) && type2.equals(CharType.s_charType.getStreamType())) {
            return new PartialEvaluationResult((Instruction)new GetStringValueInstruction(instruction2), true);
        }
        object = CoerceEvaluator.extractLiteralValue(partialInformationCollector, instruction2, letChainManager);
        if (object != null) {
            if (type.equals(IntType.s_intType) && type2.equals(BooleanType.s_booleanType)) {
                return new PartialEvaluationResult((Integer)object == 0 ? LiteralInstruction.booleanFalseLiteral() : LiteralInstruction.booleanTrueLiteral());
            }
            if (type.equals(IntType.s_intType) && type2.equals(DoubleType.s_doubleType)) {
                return new PartialEvaluationResult(LiteralInstruction.doubleLiteral(((Integer)object).intValue()));
            }
            if (type.equals(DoubleType.s_doubleType) && type2.equals(IntType.s_intType)) {
                return new PartialEvaluationResult(LiteralInstruction.integerLiteral(((Double)object).intValue()));
            }
        }
        serializable = SAXEventsLibrary.getSAXEventStream();
        NamedType namedType = SAXEventsLibrary.getSAXEvent();
        if (type.equals(serializable) && type2.equals(CharType.s_charType.getStreamType())) {
            return new PartialEvaluationResult(XSLTLinker.generateRuntimeFunctionCall(module, "processSAXEvents-text", new Instruction[]{instruction2}), true);
        }
        if (type.equals(serializable) && (type2.equals(DoubleType.s_doubleType) || type2.equals(IntType.s_intType))) {
            coerceInstruction.setChildInstruction(0, letChainManager.insertBody(XSLTLinker.generateRuntimeFunctionCall(module, "processSAXEvents-text", new Instruction[]{instruction2}), letInstruction));
            return new PartialEvaluationResult((Instruction)coerceInstruction, true);
        }
        if (type.equals(serializable) && type2.equals(BooleanType.s_booleanType)) {
            return new PartialEvaluationResult(LiteralInstruction.booleanTrueLiteral());
        }
        if (type.equals(this.s_ftdRefType) && type2.equals(serializable)) {
            return new PartialEvaluationResult((Instruction)letChainManager.insertBody(new FunctionCallInstruction(VariableDefinitionOptimizer.getCoerceXylemFunctionName(), new Instruction[]{instruction2}), letInstruction), true);
        }
        if (type.equals(this.s_ftdRefType) && type2.equals(CharType.s_charType.getStreamType())) {
            IdentifierInstruction identifierInstruction = letChainManager.insertBody(new FunctionCallInstruction(VariableDefinitionOptimizer.getCoerceXylemFunctionName(), new Instruction[]{instruction2}), letInstruction);
            return new PartialEvaluationResult((Instruction)letChainManager.insertBody(new CoerceInstruction(identifierInstruction, CharType.s_charType.getStreamType()), letInstruction), true);
        }
        if (type.equals(CharType.s_charType.getStreamType()) && type2.equals(BooleanType.s_booleanType)) {
            IdentifierInstruction identifierInstruction = letChainManager.insertBody(new LengthInstruction(instruction2), letInstruction);
            IdentifierInstruction identifierInstruction2 = letChainManager.insertBody(new PrimitiveEqualityInstruction(LiteralInstruction.integerLiteral(0), identifierInstruction), letInstruction);
            return new PartialEvaluationResult((Instruction)new NotInstruction(identifierInstruction2), true);
        }
        if (type.equals(CharType.s_charType.getStreamType()) && type2.equals(serializable)) {
            if (this.m_isDebug) {
                System.out.println("Here I am, from: " + type + " to: " + type2);
            }
            return new PartialEvaluationResult((Instruction)letChainManager.insertBody(XSLTLinker.generateRuntimeFunctionCall(module, "string-to-sax-event", new Instruction[]{instruction2}), letInstruction), true);
        }
        if (type.equals(namedType) && type2.equals(serializable)) {
            return new PartialEvaluationResult(letChainManager.insertBody(new StreamInstruction((Type)namedType, new Instruction[]{instruction2}), letInstruction));
        }
        if (type.equals(serializable) && type2.equals(CursorType.s_cursorType)) {
            IdentifierInstruction identifierInstruction = letChainManager.insertBody(XSLTLinker.generateRuntimeFunctionCall(module, "handle-rtf", new Instruction[]{instruction2}), letInstruction);
            IdentifierInstruction identifierInstruction3 = letChainManager.insertBody(new NodeSetInstruction(identifierInstruction), letInstruction);
            return new PartialEvaluationResult((Instruction)identifierInstruction3, true);
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    static final class CoersionDerivative {
        Type m_type;

        CoersionDerivative(Type type) {
            this.m_type = type;
        }

        public int hashCode() {
            return this.m_type.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof CoersionDerivative) {
                return ((CoersionDerivative)object).m_type.equals(this.m_type);
            }
            return false;
        }
    }
}

