/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.instructions;

import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.ReadObjectFileHelper;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.WriteObjectFileHelper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class NaryPrimopInstruction
extends Instruction {
    public Instruction[] m_parameters;

    protected static final Instruction[] convertParameters(List list) {
        Instruction[] instructionArray = new Instruction[list.size()];
        list.toArray(instructionArray);
        return instructionArray;
    }

    public NaryPrimopInstruction(Instruction[] instructionArray) {
        this.m_parameters = instructionArray;
    }

    public NaryPrimopInstruction(List list) {
        this(NaryPrimopInstruction.convertParameters(list));
    }

    public NaryPrimopInstruction() {
        this((Instruction[])null);
    }

    public Instruction[] getOperands() {
        return this.m_parameters;
    }

    public int getOperandCount() {
        return this.m_parameters.length;
    }

    protected void typeCheckChildren(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        for (int i = 0; i < this.m_parameters.length; ++i) {
            this.m_parameters[i].typeCheck(typeEnvironment, bindingEnvironment, linkedList);
        }
    }

    @Override
    public Instruction getChildInstruction(int n) {
        return this.m_parameters[n];
    }

    @Override
    public int getChildInstructionCount() {
        return this.m_parameters.length;
    }

    @Override
    public void setChildInstruction(int n, Instruction instruction) {
        this.m_parameters[n] = instruction;
    }

    @Override
    public void generateReducedForm(ReductionHelper reductionHelper, Instruction[] instructionArray, BindingEnvironment bindingEnvironment) {
        for (Instruction instruction : this.m_parameters) {
            this.m_parameters[var5_5] = reductionHelper.reduceToBasicInstruction(instructionArray, instruction, bindingEnvironment);
        }
        instructionArray[0] = this;
        this.m_bindingEnvironment = null;
    }

    @Override
    public void read(ReadObjectFileHelper readObjectFileHelper, BindingEnvironment bindingEnvironment) throws Exception {
        int n = readObjectFileHelper.readInt();
        this.m_parameters = new Instruction[n];
        for (int i = 0; i < n; ++i) {
            this.m_parameters[i] = readObjectFileHelper.readInstruction(bindingEnvironment);
        }
    }

    @Override
    public void write(WriteObjectFileHelper writeObjectFileHelper) throws IOException {
        int n = this.m_parameters.length;
        writeObjectFileHelper.writeInt(n);
        for (int i = 0; i < n; ++i) {
            writeObjectFileHelper.writeInstruction(this.m_parameters[i]);
        }
    }

    @Override
    public Instruction cloneReduced() {
        return this.cloneShallow();
    }

    @Override
    public void typeCheckReduced(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) {
    }
}

