/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.util.URIUtil;

public class URLResource
extends Resource {
    protected URL _url;
    protected String _urlString;
    protected transient URLConnection _connection;
    protected transient InputStream _in = null;
    transient boolean _useCaches = Resource.__defaultUseCaches;

    protected URLResource(URL url, URLConnection connection) {
        this._url = url;
        this._urlString = this._url.toString();
        this._connection = connection;
    }

    protected URLResource(URL url, URLConnection connection, boolean useCaches) {
        this(url, connection);
        this._useCaches = useCaches;
    }

    protected synchronized boolean checkConnection() {
        if (this._connection == null) {
            try {
                this._connection = this._url.openConnection();
                this._connection.setUseCaches(this._useCaches);
            }
            catch (IOException e) {
                Log.ignore(e);
            }
        }
        return this._connection != null;
    }

    @Override
    public synchronized void release() {
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException e) {
                Log.ignore(e);
            }
            this._in = null;
        }
        if (this._connection != null) {
            this._connection = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() {
        try {
            URLResource uRLResource = this;
            synchronized (uRLResource) {
                if (this.checkConnection() && this._in == null) {
                    this._in = this._connection.getInputStream();
                }
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        return this._in != null;
    }

    @Override
    public boolean isDirectory() {
        return this.exists() && this._url.toString().endsWith("/");
    }

    @Override
    public long lastModified() {
        if (this.checkConnection()) {
            return this._connection.getLastModified();
        }
        return -1L;
    }

    @Override
    public long length() {
        if (this.checkConnection()) {
            return this._connection.getContentLength();
        }
        return -1L;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public File getFile() throws IOException {
        Permission perm;
        if (this.checkConnection() && (perm = this._connection.getPermission()) instanceof FilePermission) {
            return new File(perm.getName());
        }
        try {
            return new File(this._url.getFile());
        }
        catch (Exception e) {
            Log.ignore(e);
            return null;
        }
    }

    @Override
    public String getName() {
        return this._url.toExternalForm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.checkConnection()) {
            throw new IOException("Invalid resource");
        }
        try {
            if (this._in != null) {
                InputStream in = this._in;
                this._in = null;
                InputStream inputStream = in;
                return inputStream;
            }
            InputStream inputStream = this._connection.getInputStream();
            return inputStream;
        }
        finally {
            this._connection = null;
        }
    }

    @Override
    public OutputStream getOutputStream() throws IOException, SecurityException {
        throw new IOException("Output not supported");
    }

    @Override
    public boolean delete() throws SecurityException {
        throw new SecurityException("Delete not supported");
    }

    @Override
    public boolean renameTo(Resource dest) throws SecurityException {
        throw new SecurityException("RenameTo not supported");
    }

    @Override
    public String[] list() {
        return null;
    }

    @Override
    public Resource addPath(String path) throws IOException, MalformedURLException {
        if (path == null) {
            return null;
        }
        path = URIUtil.canonicalPath(path);
        return URLResource.newResource(URIUtil.addPaths(this._url.toExternalForm(), path));
    }

    public String toString() {
        return this._urlString;
    }

    public int hashCode() {
        return this._url.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof URLResource && this._url.equals(((URLResource)o)._url);
    }

    public boolean getUseCaches() {
        return this._useCaches;
    }
}

