/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.StormSubmitter;
import backtype.storm.generated.StormTopology;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.TestWordSpout;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.TopologyBuilder;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.util.List;
import java.util.Map;

public class ExclamationTopology {
    public static void main(String[] args) throws Exception {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("word", (IRichSpout)new TestWordSpout(), (Number)10);
        builder.setBolt("exclaim1", (IRichBolt)new ExclamationBolt(), (Number)3).shuffleGrouping("word");
        builder.setBolt("exclaim2", (IRichBolt)new ExclamationBolt(), (Number)2).shuffleGrouping("exclaim1");
        Config conf = new Config();
        conf.setDebug(true);
        if (args != null && args.length > 0) {
            conf.setNumWorkers(3);
            StormSubmitter.submitTopology((String)args[0], (Map)conf, (StormTopology)builder.createTopology());
        } else {
            LocalCluster cluster = new LocalCluster();
            cluster.submitTopology("test", (Map)conf, builder.createTopology());
            Utils.sleep((long)10000L);
            cluster.killTopology("test");
            cluster.shutdown();
        }
    }

    public static class ExclamationBolt
    extends BaseRichBolt {
        OutputCollector _collector;

        public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
            this._collector = collector;
        }

        public void execute(Tuple tuple) {
            this._collector.emit(tuple, (List)new Values(new Object[]{tuple.getString(0) + "!!!"}));
            this._collector.ack(tuple);
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"word"}));
        }
    }
}

