/*
 * Decompiled with CFR 0.152.
 */
package storm.starter;

import backtype.storm.Config;
import backtype.storm.LocalCluster;
import backtype.storm.coordination.BatchOutputCollector;
import backtype.storm.coordination.IBatchBolt;
import backtype.storm.task.TopologyContext;
import backtype.storm.testing.MemoryTransactionalSpout;
import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.IBasicBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.topology.base.BaseTransactionalBolt;
import backtype.storm.transactional.ICommitter;
import backtype.storm.transactional.TransactionAttempt;
import backtype.storm.transactional.TransactionalTopologyBuilder;
import backtype.storm.transactional.partitioned.IPartitionedTransactionalSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TransactionalWords {
    public static final int BUCKET_SIZE = 10;
    public static Map<String, CountValue> COUNT_DATABASE = new HashMap<String, CountValue>();
    public static Map<Integer, BucketValue> BUCKET_DATABASE = new HashMap<Integer, BucketValue>();
    public static final int PARTITION_TAKE_PER_BATCH = 3;
    public static final Map<Integer, List<List<Object>>> DATA = new HashMap<Integer, List<List<Object>>>(){
        {
            this.put(0, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"chicken"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"apple"}));
                }
            });
            this.put(1, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"apple"}));
                    this.add(new Values(new Object[]{"banana"}));
                }
            });
            this.put(2, new ArrayList<List<Object>>(){
                {
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"cat"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                    this.add(new Values(new Object[]{"dog"}));
                }
            });
        }
    };

    public static void main(String[] args) throws Exception {
        MemoryTransactionalSpout spout = new MemoryTransactionalSpout(DATA, new Fields(new String[]{"word"}), 3);
        TransactionalTopologyBuilder builder = new TransactionalTopologyBuilder("top-n-words", "spout", (IPartitionedTransactionalSpout)spout, (Number)2);
        builder.setBolt("count", (IBatchBolt)new KeyedCountUpdater(), (Number)5).fieldsGrouping("spout", new Fields(new String[]{"word"}));
        builder.setBolt("bucketize", (IBasicBolt)new Bucketize()).noneGrouping("count");
        builder.setBolt("buckets", (IBatchBolt)new BucketCountUpdater(), (Number)5).fieldsGrouping("bucketize", new Fields(new String[]{"bucket"}));
        LocalCluster cluster = new LocalCluster();
        Config config = new Config();
        config.setDebug(true);
        config.setMaxSpoutPending(3);
        cluster.submitTopology("top-n-topology", (Map)config, builder.buildTopology());
        Thread.sleep(3000L);
        cluster.shutdown();
    }

    public static class BucketCountUpdater
    extends BaseTransactionalBolt {
        Map<Integer, Integer> _accum = new HashMap<Integer, Integer>();
        BatchOutputCollector _collector;
        TransactionAttempt _attempt;
        int _count = 0;

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, TransactionAttempt attempt) {
            this._collector = collector;
            this._attempt = attempt;
        }

        public void execute(Tuple tuple) {
            Integer bucket = tuple.getInteger(1);
            Integer delta = tuple.getInteger(2);
            Integer curr = this._accum.get(bucket);
            if (curr == null) {
                curr = 0;
            }
            this._accum.put(bucket, curr + delta);
        }

        public void finishBatch() {
            for (Integer bucket : this._accum.keySet()) {
                BucketValue newVal;
                BucketValue currVal = BUCKET_DATABASE.get(bucket);
                if (currVal == null || !currVal.txid.equals(this._attempt.getTransactionId())) {
                    newVal = new BucketValue();
                    newVal.txid = this._attempt.getTransactionId();
                    newVal.count = this._accum.get(bucket);
                    if (currVal != null) {
                        newVal.count += currVal.count;
                    }
                    BUCKET_DATABASE.put(bucket, newVal);
                } else {
                    newVal = currVal;
                }
                this._collector.emit((List)new Values(new Object[]{this._attempt, bucket, newVal.count}));
            }
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "bucket", "count"}));
        }
    }

    public static class Bucketize
    extends BaseBasicBolt {
        public void execute(Tuple tuple, BasicOutputCollector collector) {
            TransactionAttempt attempt = (TransactionAttempt)tuple.getValue(0);
            int curr = tuple.getInteger(2);
            Integer prev = tuple.getInteger(3);
            int currBucket = curr / 10;
            Integer prevBucket = null;
            if (prev != null) {
                prevBucket = prev / 10;
            }
            if (prevBucket == null) {
                collector.emit((List)new Values(new Object[]{attempt, currBucket, 1}));
            } else if (currBucket != prevBucket) {
                collector.emit((List)new Values(new Object[]{attempt, currBucket, 1}));
                collector.emit((List)new Values(new Object[]{attempt, prevBucket, -1}));
            }
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"attempt", "bucket", "delta"}));
        }
    }

    public static class KeyedCountUpdater
    extends BaseTransactionalBolt
    implements ICommitter {
        Map<String, Integer> _counts = new HashMap<String, Integer>();
        BatchOutputCollector _collector;
        TransactionAttempt _id;
        int _count = 0;

        public void prepare(Map conf, TopologyContext context, BatchOutputCollector collector, TransactionAttempt id) {
            this._collector = collector;
            this._id = id;
        }

        public void execute(Tuple tuple) {
            String key = tuple.getString(1);
            Integer curr = this._counts.get(key);
            if (curr == null) {
                curr = 0;
            }
            this._counts.put(key, curr + 1);
        }

        public void finishBatch() {
            for (String key : this._counts.keySet()) {
                CountValue newVal;
                CountValue val = COUNT_DATABASE.get(key);
                if (val == null || !val.txid.equals(this._id)) {
                    newVal = new CountValue();
                    newVal.txid = this._id.getTransactionId();
                    if (val != null) {
                        newVal.prev_count = val.count;
                        newVal.count = val.count;
                    }
                    newVal.count += this._counts.get(key).intValue();
                    COUNT_DATABASE.put(key, newVal);
                } else {
                    newVal = val;
                }
                this._collector.emit((List)new Values(new Object[]{this._id, key, newVal.count, newVal.prev_count}));
            }
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"id", "key", "count", "prev-count"}));
        }
    }

    public static class BucketValue {
        int count = 0;
        BigInteger txid;
    }

    public static class CountValue {
        Integer prev_count = null;
        int count = 0;
        BigInteger txid = null;
    }
}

