/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.common.utils;

public class IntVector
implements Cloneable {
    protected int m_blocksize;
    protected int[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public IntVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new int[this.m_blocksize];
    }

    public IntVector(int n) {
        this.m_blocksize = n;
        this.m_mapSize = n;
        this.m_map = new int[n];
    }

    public IntVector(int n, int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n;
        this.m_map = new int[n];
    }

    public IntVector(IntVector intVector) {
        this.m_map = new int[intVector.m_mapSize];
        this.m_mapSize = intVector.m_mapSize;
        this.m_firstFree = intVector.m_firstFree;
        this.m_blocksize = intVector.m_blocksize;
        System.arraycopy(intVector.m_map, 0, this.m_map, 0, this.m_firstFree);
    }

    public final int size() {
        return this.m_firstFree;
    }

    public final void setSize(int n) {
        this.m_firstFree = n;
    }

    public final void addElement(int n) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n;
        ++this.m_firstFree;
    }

    public final void addElements(int n, int n2) {
        if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n2;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        for (int i = 0; i < n2; ++i) {
            this.m_map[this.m_firstFree] = n;
            ++this.m_firstFree;
        }
    }

    public final void addElements(int n) {
        if (this.m_firstFree + n >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        this.m_firstFree += n;
    }

    public final void insertElementAt(int n, int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = n;
        ++this.m_firstFree;
    }

    public final void removeAllElements() {
        for (int i = 0; i < this.m_firstFree; ++i) {
            this.m_map[i] = Integer.MIN_VALUE;
        }
        this.m_firstFree = 0;
    }

    public final boolean removeElement(int n) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n) continue;
            if (i + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i + 1, this.m_map, i - 1, this.m_firstFree - i);
            } else {
                this.m_map[i] = Integer.MIN_VALUE;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final void removeElementAt(int n) {
        if (n > this.m_firstFree) {
            System.arraycopy(this.m_map, n + 1, this.m_map, n, this.m_firstFree);
        } else {
            this.m_map[n] = Integer.MIN_VALUE;
        }
        --this.m_firstFree;
    }

    public final void setElementAt(int n, int n2) {
        this.m_map[n2] = n;
    }

    public final int elementAt(int n) {
        return this.m_map[n];
    }

    public final boolean contains(int n) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n) continue;
            return true;
        }
        return false;
    }

    public final int indexOf(int n, int n2) {
        for (int i = n2; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int indexOf(int n) {
        for (int i = 0; i < this.m_firstFree; ++i) {
            if (this.m_map[i] != n) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(int n) {
        for (int i = this.m_firstFree - 1; i >= 0; --i) {
            if (this.m_map[i] != n) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public Object clone() throws CloneNotSupportedException {
        return new IntVector(this);
    }

    public int[] toArray() {
        int[] nArray = new int[this.m_firstFree];
        System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree);
        return nArray;
    }
}

