/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.xdm.ref;

import com.ibm.xtq.common.utils.ObjectVector;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.ref.XDMCursorProxyCursor;
import java.util.Vector;

public class XDMCachedNodeListCursor
extends XDMCursorProxyCursor {
    XDMCursor m_source;
    Vector m_cache = new Vector();
    private ObjectVector _nodes = new ObjectVector();
    private int _numCachedNodes = 0;
    private int _index = 0;
    private boolean _isEnded = false;

    public XDMCachedNodeListCursor(XDMCursor xDMCursor) {
        super(xDMCursor);
        this.m_source = xDMCursor;
        this.init();
    }

    @Override
    public XDMCursor newContext(XDMCursor xDMCursor, Object object, boolean bl) {
        if (bl) {
            return new XDMCachedNodeListCursor(this.m_source.newContext(xDMCursor, object, true));
        }
        this.m_source = this.m_source.newContext(xDMCursor, object, false);
        this.init();
        return this;
    }

    private void init() {
        while (this.nextNode()) {
        }
        this._index = 1;
        this.m_currentCursor = this.getNode(0);
    }

    public int getPosition() {
        return this._index == 0 ? 1 : this._index;
    }

    public XDMCursor getNodeByPosition(int n) {
        return this.getNode(n);
    }

    public XDMCursor getNode(int n) {
        if (n < this._numCachedNodes) {
            return (XDMCursor)this._nodes.elementAt(n);
        }
        if (!this._isEnded) {
            XDMCursor xDMCursor = null;
            if (!this.m_source.isEmpty()) {
                xDMCursor = this.m_source.singleNode();
                this._nodes.addElement(xDMCursor);
                ++this._numCachedNodes;
                this._isEnded = !this.m_source.nextNode();
            } else {
                this._isEnded = true;
            }
            return xDMCursor;
        }
        return null;
    }

    @Override
    public boolean setDocOrdered() {
        return this.m_source.isDocOrdered();
    }

    @Override
    public boolean setDocOrderedUnique() {
        return this.m_source.isDocOrdered() && this.m_source.isUniqueNodes();
    }

    @Override
    public boolean isDocOrdered() {
        return this.m_source.isDocOrdered();
    }

    @Override
    public boolean isUniqueNodes() {
        return this.m_source.isUniqueNodes();
    }

    @Override
    public boolean nextNode() {
        return (this.m_currentCursor = this.getNode(this._index++)) != null;
    }

    @Override
    public int getLength() {
        return this._numCachedNodes;
    }

    @Override
    public boolean setCurrentPos(int n) {
        if (n < this._index) {
            this._index = n;
        } else {
            while (n > this._index && this.nextNode()) {
            }
        }
        return n == this._index;
    }

    @Override
    public void resetIteration() {
        this._index = 1;
        this.m_currentCursor = this.getNode(0);
    }

    @Override
    public XDMCursor getTypedAxisCursor(int n, int n2) {
        XDMCursor xDMCursor = this.m_source.getTypedAxisCursor(n, n2);
        return xDMCursor.newContext(this.m_currentCursor);
    }

    @Override
    public XDMCursor getAxisCursor(int n) {
        XDMCursor xDMCursor = this.m_source.getAxisCursor(n);
        return xDMCursor.newContext(this.m_currentCursor);
    }

    @Override
    public XDMCursor cloneWithReset() throws CloneNotSupportedException {
        XDMCursor xDMCursor = this.cloneXDMCursor();
        xDMCursor.resetIteration();
        return xDMCursor;
    }

    @Override
    public XDMCursor cloneXDMCursor() {
        XDMCachedNodeListCursor xDMCachedNodeListCursor = (XDMCachedNodeListCursor)this.clone();
        xDMCachedNodeListCursor._numCachedNodes = this._nodes.size();
        return xDMCachedNodeListCursor;
    }

    public boolean isMutable() {
        return false;
    }

    @Override
    public int getCurrentPos() {
        return this._index;
    }

    @Override
    public boolean isEmpty() {
        return this._nodes.size() <= 0;
    }
}

