/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.runtime.extensions;

import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xml.xdm.XDMManagerFactory;
import com.ibm.xtq.xslt.runtime.JavaMethodResolver;
import com.ibm.xtq.xslt.runtime.extensions.ObjectFactory;
import com.ibm.xtq.xslt.runtime.extensions.XSLTObject;
import com.ibm.xtq.xslt.runtime.res.RuntimeMsg;
import com.ibm.xtq.xslt.typechecker.v1.MultiHashtable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class JavaExtensionUtils {
    private static final MultiHashtable _internal2Java = new MultiHashtable();
    private static final Class stringClass = String.class;
    private static final Class xdmCursorClass = XDMCursor.class;

    public static final XSLTObject callJavaConstructor(String string, XSLTObject[] xSLTObjectArray, XDMManagerFactory xDMManagerFactory) {
        Class clazz;
        if (string == null || string.length() == 0) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", string));
        }
        try {
            clazz = ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", string), classNotFoundException);
        }
        List list = JavaMethodResolver.findConstructors(clazz, xSLTObjectArray.length);
        if (list == null || list.isEmpty()) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("CONSTRUCTOR_NOT_FOUND", string));
        }
        int n = list.size();
        Class[] classArray = JavaExtensionUtils.getArgumentTypes(xSLTObjectArray);
        int n2 = Integer.MAX_VALUE;
        Constructor constructor = null;
        for (int i = 0; i < n; ++i) {
            int n3;
            Constructor constructor2 = (Constructor)list.get(i);
            Class<?>[] classArray2 = constructor2.getParameterTypes();
            int n4 = 0;
            for (n3 = 0; n3 < xSLTObjectArray.length; ++n3) {
                Class clazz2 = classArray[n3];
                Class<?> clazz3 = classArray2[n3];
                Object object = _internal2Java.maps(clazz2, clazz3);
                if (object != null) {
                    n4 += ((TargetType)object).distance;
                    continue;
                }
                if (clazz2 == clazz3) continue;
                if (clazz3.isAssignableFrom(clazz2)) {
                    ++n4;
                    continue;
                }
                n4 = Integer.MAX_VALUE;
                break;
            }
            if (n3 != xSLTObjectArray.length || n4 >= n2) continue;
            constructor = constructor2;
            n2 = n4;
        }
        if (constructor != null) {
            Object[] objectArray = JavaExtensionUtils.convertArgumentValues(xSLTObjectArray, constructor.getParameterTypes());
            try {
                Object t = constructor.newInstance(objectArray);
                return JavaExtensionUtils.createXSLTObject(t, constructor.getDeclaringClass(), xDMManagerFactory);
            }
            catch (Exception exception) {
                throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_CONSTRUCTOR_CALL_FAILED", string), exception);
            }
        }
        throw new RuntimeException(JavaExtensionUtils.getMessageString("CONSTRUCTOR_NOT_FOUND", string));
    }

    public static final XSLTObject callJavaMethod(String string, String string2, XSLTObject[] xSLTObjectArray, XDMManagerFactory xDMManagerFactory, HashMap hashMap) {
        Object object;
        Object[] objectArray;
        int n;
        List list;
        Class[] classArray = JavaExtensionUtils.getArgumentTypes(xSLTObjectArray);
        Class clazz = null;
        boolean bl = false;
        if (string2 != null && string2.length() > 0) {
            try {
                Class clazz2;
                clazz = ObjectFactory.findProviderClass(string2, ObjectFactory.findClassLoader(), true);
                if (classArray.length > 0 && clazz.isAssignableFrom(clazz2 = classArray[0])) {
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            if (classArray.length > 0 && !classArray[0].isPrimitive()) {
                bl = true;
                clazz = classArray[0];
            } else {
                throw new RuntimeException(JavaExtensionUtils.getMessageString("CLASS_NOT_FOUND_ERR", string2));
            }
        }
        int n2 = xSLTObjectArray.length;
        if (bl) {
            --n2;
        }
        if ((list = JavaMethodResolver.findMethods(clazz, string, n2)) == null || list.isEmpty()) {
            throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", string));
        }
        int n3 = Integer.MAX_VALUE;
        Object[] objectArray2 = null;
        int n4 = list.size();
        int n5 = bl ? 1 : 0;
        for (n = 0; n < n4; ++n) {
            int n6;
            objectArray = (Object[])list.get(n);
            object = objectArray.getParameterTypes();
            int n7 = 0;
            for (n6 = 0; n6 < n2; ++n6) {
                Class clazz3 = classArray[n6 + n5];
                Class<?> clazz4 = object[n6];
                Object object2 = _internal2Java.maps(clazz3, clazz4);
                if (object2 != null) {
                    n7 += ((TargetType)object2).distance;
                    continue;
                }
                if (clazz3 == clazz4) continue;
                if (clazz4.isAssignableFrom(clazz3)) {
                    ++n7;
                    continue;
                }
                n7 = Integer.MAX_VALUE;
                break;
            }
            if (n6 != n2 || n7 >= n3) continue;
            objectArray2 = objectArray;
            n3 = n7;
        }
        if (objectArray2 != null) {
            Object object3 = null;
            n = objectArray2.getModifiers();
            if ((n & 8) != 0) {
                if (bl) {
                    throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", string));
                }
            } else if (bl) {
                object3 = xSLTObjectArray[0].getValueObject();
            } else {
                object3 = hashMap.get(string2);
                if (object3 == null) {
                    try {
                        object3 = clazz.newInstance();
                        hashMap.put(string2, object3);
                    }
                    catch (Exception exception) {
                        throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_DEFAULT_OBJECT_FAILED", string2), exception);
                    }
                }
            }
            objectArray = JavaExtensionUtils.convertArgumentValues(xSLTObjectArray, n5, objectArray2.getParameterTypes());
            try {
                object = objectArray2.invoke(object3, objectArray);
                return JavaExtensionUtils.createXSLTObject(object, objectArray2.getReturnType(), xDMManagerFactory);
            }
            catch (Exception exception) {
                throw new WrappedRuntimeException(JavaExtensionUtils.getMessageString("ERR_EXT_METHOD_CALL_FAILED", new Object[]{string, string2}), exception);
            }
        }
        throw new RuntimeException(JavaExtensionUtils.getMessageString("FUNCTION_RESOLVE_ERR", string));
    }

    private static final Class[] getArgumentTypes(XSLTObject[] xSLTObjectArray) {
        Class[] classArray = new Class[xSLTObjectArray.length];
        for (int i = 0; i < xSLTObjectArray.length; ++i) {
            classArray[i] = JavaExtensionUtils.getArgumentType(xSLTObjectArray[i]);
        }
        return classArray;
    }

    private static final Class getArgumentType(XSLTObject xSLTObject) {
        if (xSLTObject.isNumber()) {
            return Double.TYPE;
        }
        if (xSLTObject.isBoolean()) {
            return Boolean.TYPE;
        }
        if (xSLTObject.isString()) {
            return stringClass;
        }
        if (xSLTObject.isNodeset()) {
            return xdmCursorClass;
        }
        if (xSLTObject.isRTF()) {
            return xdmCursorClass;
        }
        return xSLTObject.getValueClass();
    }

    private static final Object[] convertArgumentValues(XSLTObject[] xSLTObjectArray, Class[] classArray) {
        return JavaExtensionUtils.convertArgumentValues(xSLTObjectArray, 0, classArray);
    }

    private static final Object[] convertArgumentValues(XSLTObject[] xSLTObjectArray, int n, Class[] classArray) {
        Object[] objectArray = new Object[xSLTObjectArray.length - n];
        int n2 = n;
        int n3 = 0;
        while (n2 < xSLTObjectArray.length) {
            objectArray[n3] = JavaExtensionUtils.convertArgumentValue(xSLTObjectArray[n2], classArray[n3]);
            ++n2;
            ++n3;
        }
        return objectArray;
    }

    private static final Object convertArgumentValue(XSLTObject xSLTObject, Class clazz) {
        if (xSLTObject.isExternal()) {
            return xSLTObject.getValueObject();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return xSLTObject.getJavaBooleanObject();
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new Character(xSLTObject.getJavaChar());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return xSLTObject.getJavaDoubleObject();
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(xSLTObject.getJavaFloat());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long(xSLTObject.getJavaLong());
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return new Integer(xSLTObject.getJavaInt());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short(xSLTObject.getJavaShort());
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte(xSLTObject.getJavaByte());
        }
        if (clazz == String.class) {
            return xSLTObject.getJavaString();
        }
        if (clazz == NodeIterator.class) {
            return xSLTObject.getJavaNodeIterator();
        }
        if (clazz == NodeList.class) {
            return xSLTObject.getJavaNodeList();
        }
        if (clazz == Node.class) {
            return xSLTObject.getJavaNode();
        }
        if (clazz == Number.class) {
            return xSLTObject.getJavaDoubleObject();
        }
        if (clazz == Object.class) {
            if (xSLTObject.isBoolean()) {
                return xSLTObject.getJavaBooleanObject();
            }
            if (xSLTObject.isNumber()) {
                return xSLTObject.getJavaDoubleObject();
            }
            if (xSLTObject.isString()) {
                return xSLTObject.getJavaString();
            }
            if (xSLTObject.isNodeset()) {
                return xSLTObject.getJavaNodeIterator();
            }
            if (xSLTObject.isRTF()) {
                return xSLTObject.getJavaNodeIterator();
            }
        }
        return xSLTObject.getJavaObject(clazz);
    }

    private static final XSLTObject createXSLTObject(Object object, Class clazz, XDMManagerFactory xDMManagerFactory) {
        XSLTObject xSLTObject = clazz == Boolean.TYPE ? XSLTObject.createXSLTObject((Boolean)object) : (clazz == Character.TYPE ? XSLTObject.createXSLTObject(((Character)object).charValue()) : (clazz == Double.TYPE ? XSLTObject.createXSLTObject((Double)object) : (clazz == Float.TYPE ? XSLTObject.createXSLTObject(((Float)object).floatValue()) : (clazz == Long.TYPE ? XSLTObject.createXSLTObject((Long)object) : (clazz == Integer.TYPE ? XSLTObject.createXSLTObject((Integer)object) : (clazz == Short.TYPE ? XSLTObject.createXSLTObject((Short)object) : (clazz == Byte.TYPE ? XSLTObject.createXSLTObject((Byte)object) : XSLTObject.createXSLTObject(xDMManagerFactory, object, clazz.getName()))))))));
        return xSLTObject;
    }

    public static String getMessageString(String string, Object object) {
        return JavaExtensionUtils.getMessageString(string, new Object[]{object});
    }

    public static String getMessageString(String string, Object[] objectArray) {
        RuntimeMsg runtimeMsg = new RuntimeMsg(string, objectArray);
        return runtimeMsg.getFormattedMessage();
    }

    static {
        Class<Object> clazz = Object.class;
        Class<Node> clazz2 = Node.class;
        Class<NodeList> clazz3 = NodeList.class;
        Class<NodeIterator> clazz4 = NodeIterator.class;
        _internal2Java.put(Boolean.TYPE, new TargetType(Boolean.TYPE, 0));
        _internal2Java.put(Boolean.TYPE, new TargetType(Boolean.class, 1));
        _internal2Java.put(Boolean.TYPE, new TargetType(clazz, 2));
        _internal2Java.put(Boolean.TYPE, new TargetType(stringClass, 3));
        _internal2Java.put(Double.TYPE, new TargetType(Double.TYPE, 0));
        _internal2Java.put(Double.TYPE, new TargetType(Double.class, 1));
        _internal2Java.put(Double.TYPE, new TargetType(Number.class, 2));
        _internal2Java.put(Double.TYPE, new TargetType(Float.TYPE, 3));
        _internal2Java.put(Double.TYPE, new TargetType(Long.TYPE, 4));
        _internal2Java.put(Double.TYPE, new TargetType(Integer.TYPE, 5));
        _internal2Java.put(Double.TYPE, new TargetType(Short.TYPE, 6));
        _internal2Java.put(Double.TYPE, new TargetType(Character.TYPE, 7));
        _internal2Java.put(Double.TYPE, new TargetType(Byte.TYPE, 8));
        _internal2Java.put(Double.TYPE, new TargetType(Boolean.TYPE, 9));
        _internal2Java.put(Double.TYPE, new TargetType(stringClass, 10));
        _internal2Java.put(Double.TYPE, new TargetType(clazz, 11));
        _internal2Java.put(Integer.TYPE, new TargetType(Integer.TYPE, 0));
        _internal2Java.put(Integer.TYPE, new TargetType(Double.class, 1));
        _internal2Java.put(Integer.TYPE, new TargetType(Number.class, 2));
        _internal2Java.put(Integer.TYPE, new TargetType(Long.TYPE, 3));
        _internal2Java.put(Integer.TYPE, new TargetType(Double.TYPE, 4));
        _internal2Java.put(Integer.TYPE, new TargetType(Float.TYPE, 5));
        _internal2Java.put(Integer.TYPE, new TargetType(Short.TYPE, 6));
        _internal2Java.put(Integer.TYPE, new TargetType(Character.TYPE, 7));
        _internal2Java.put(Integer.TYPE, new TargetType(Byte.TYPE, 8));
        _internal2Java.put(Integer.TYPE, new TargetType(Boolean.TYPE, 9));
        _internal2Java.put(Integer.TYPE, new TargetType(stringClass, 10));
        _internal2Java.put(Integer.TYPE, new TargetType(clazz, 11));
        _internal2Java.put(stringClass, new TargetType(stringClass, 0));
        _internal2Java.put(stringClass, new TargetType(clazz, 1));
        _internal2Java.put(stringClass, new TargetType(Character.TYPE, 2));
        _internal2Java.put(stringClass, new TargetType(Double.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Float.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Long.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Integer.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Short.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Byte.TYPE, 3));
        _internal2Java.put(stringClass, new TargetType(Boolean.TYPE, 4));
        _internal2Java.put(xdmCursorClass, new TargetType(clazz4, 0));
        _internal2Java.put(xdmCursorClass, new TargetType(clazz3, 1));
        _internal2Java.put(xdmCursorClass, new TargetType(clazz2, 2));
        _internal2Java.put(xdmCursorClass, new TargetType(stringClass, 3));
        _internal2Java.put(xdmCursorClass, new TargetType(clazz, 5));
        _internal2Java.put(xdmCursorClass, new TargetType(Character.TYPE, 6));
        _internal2Java.put(xdmCursorClass, new TargetType(Double.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Float.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Long.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Integer.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Short.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Byte.TYPE, 7));
        _internal2Java.put(xdmCursorClass, new TargetType(Boolean.TYPE, 8));
    }

    static class TargetType {
        public Class type;
        public int distance;

        public TargetType(Class clazz, int n) {
            this.type = clazz;
            this.distance = n;
        }

        public boolean equals(Object object) {
            return object.equals(this.type);
        }
    }
}

