/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.xylem.instructions;

import com.ibm.xtq.bcel.generic.ArrayType;
import com.ibm.xtq.bcel.generic.BasicType;
import com.ibm.xtq.bcel.generic.BranchInstruction;
import com.ibm.xtq.bcel.generic.InstructionHandle;
import com.ibm.xtq.bcel.generic.Type;
import com.ibm.xtq.xml.xdm.XDMCursor;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xtq.xslt.xylem.interpreter.CursorStream;
import com.ibm.xtq.xslt.xylem.types.CursorType;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Function;
import com.ibm.xylem.IDebuggerInterceptor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.TypeCheckException;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationOptimizationStyle;
import com.ibm.xylem.codegen.CodeGenerationTracker;
import com.ibm.xylem.codegen.DataFlowCodeGenerationHelper;
import com.ibm.xylem.codegen.IStreamOptimizationInstruction;
import com.ibm.xylem.codegen.StreamOptimizationStyle;
import com.ibm.xylem.codegen.bcel.BCELCodeGenerationHelper;
import com.ibm.xylem.codegen.bcel.InstructionListBuilder;
import com.ibm.xylem.codegen.bcel.SwitchBuilder;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.instructions.UnaryPrimopInstruction;
import com.ibm.xylem.interpreter.Debugger;
import com.ibm.xylem.interpreter.Environment;
import com.ibm.xylem.interpreter.StringStream;
import com.ibm.xylem.types.CharType;
import com.ibm.xylem.types.StreamType;
import java.util.LinkedList;

public class GetStringValueInstruction
extends UnaryPrimopInstruction
implements IStreamOptimizationInstruction {
    public GetStringValueInstruction(Instruction instruction) {
        super(instruction);
    }

    public GetStringValueInstruction() {
        this(new IdentifierInstruction("__context__"));
    }

    @Override
    public Instruction cloneWithoutTypeInformation() {
        return new GetStringValueInstruction(this.m_operand.cloneWithoutTypeInformation());
    }

    @Override
    public com.ibm.xylem.Type typeCheck(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment, LinkedList linkedList) throws TypeCheckException {
        super.doDefaultTypeCheck(typeEnvironment, bindingEnvironment, linkedList);
        typeEnvironment.unify(this.m_operand.typeCheck(typeEnvironment, bindingEnvironment, linkedList), CursorType.s_cursorType, this);
        return this.setCachedType(CharType.s_charType.getStreamType());
    }

    @Override
    public com.ibm.xylem.Type getType(TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        return CharType.s_charType.getStreamType();
    }

    @Override
    public String generateCodeBasedOnDataFlow(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, boolean bl) {
        TypeEnvironment typeEnvironment = codeGenerationTracker.m_typeEnvironment;
        String string2 = dataFlowCodeGenerationHelper.generateNewLocalVariableName(string);
        String string3 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper.appendAssignment(string2, this.getType(typeEnvironment, codeGenerationTracker.m_bindingEnvironment), string3 + ".isEmpty() ? " + RuntimeLibrary.class.getName() + ".s_emptyCharStream : " + string3 + ".getStringValueX().toCharArray()", codeGenerationTracker);
        return string2;
    }

    @Override
    public void generateCode(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, String string, InstructionHandle instructionHandle, InstructionListBuilder instructionListBuilder) {
        codeGenerationTracker.generateConventionally(this.m_operand, bCELCodeGenerationHelper, null, instructionListBuilder);
        GetStringValueInstruction.generateCursorToCharArray(bCELCodeGenerationHelper, codeGenerationTracker, instructionListBuilder);
    }

    public static void generateCursorToCharArray(BCELCodeGenerationHelper bCELCodeGenerationHelper, CodeGenerationTracker codeGenerationTracker, InstructionListBuilder instructionListBuilder) {
        instructionListBuilder.appendDUP();
        instructionListBuilder.appendInvokeInterface(CursorType.s_className, "isEmpty", BasicType.BOOLEAN);
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTestTrue();
        instructionListBuilder.appendPop();
        StreamInstruction.insertCharStreamConstant("", bCELCodeGenerationHelper, instructionListBuilder);
        switchBuilder.endTest();
        switchBuilder.startElse();
        instructionListBuilder.appendInvokeInterface(CursorType.s_className, "getStringValueX", BasicType.STRING);
        instructionListBuilder.appendStringToCharArray();
        switchBuilder.endElse();
    }

    @Override
    public void generateCodeWithStreamOptimization(BCELCodeGenerationHelper bCELCodeGenerationHelper, InstructionListBuilder instructionListBuilder, int[] nArray, CodeGenerationTracker codeGenerationTracker, InstructionHandle instructionHandle) {
        int n = codeGenerationTracker.generateConventionallyIntoRegister(this.m_operand, bCELCodeGenerationHelper, instructionListBuilder);
        instructionListBuilder.appendALoad(n);
        instructionListBuilder.appendInvokeInterface(CursorType.s_className, "isEmpty", BasicType.BOOLEAN);
        SwitchBuilder switchBuilder = new SwitchBuilder(instructionListBuilder, 1);
        switchBuilder.startTestTrue();
        switchBuilder.endTest();
        switchBuilder.startElse();
        int n2 = codeGenerationTracker.allocateRegister();
        ArrayType arrayType = BCELCodeGenerationHelper.s_charArrayType;
        instructionListBuilder.appendALoad(n);
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendISub();
        instructionListBuilder.appendInvokeInterface(CursorType.s_className, "copyStringValue", (Type)BasicType.INT, new Type[]{arrayType, BasicType.INT, BasicType.INT});
        instructionListBuilder.appendDUP();
        instructionListBuilder.appendIStore(n2);
        instructionListBuilder.appendConstant(0);
        BranchInstruction branchInstruction = instructionListBuilder.appendIficmpge();
        instructionListBuilder.appendILoad(n2);
        instructionListBuilder.appendINeg();
        StreamType.generateGrowStream(nArray, bCELCodeGenerationHelper, CharType.s_charType.getStreamType(), instructionListBuilder);
        instructionListBuilder.appendALoad(n);
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendALoad(nArray[0]);
        instructionListBuilder.appendArrayLength();
        instructionListBuilder.appendILoad(nArray[1]);
        instructionListBuilder.appendISub();
        instructionListBuilder.appendInvokeInterface(CursorType.s_className, "copyStringValue", (Type)BasicType.INT, new Type[]{arrayType, BasicType.INT, BasicType.INT});
        instructionListBuilder.appendIStore(n2);
        branchInstruction.setTarget(instructionListBuilder.appendILoad(nArray[1]));
        instructionListBuilder.appendILoad(n2);
        instructionListBuilder.appendIAdd();
        instructionListBuilder.appendIStore(nArray[1]);
        switchBuilder.endElse();
    }

    @Override
    public String innerToString() {
        return "get-string-value";
    }

    @Override
    public Instruction cloneWithoutTypeInformation(Instruction instruction) {
        return new GetStringValueInstruction(instruction);
    }

    @Override
    public Object evaluate(Environment environment, Function function, IDebuggerInterceptor iDebuggerInterceptor, boolean bl) {
        XDMCursor xDMCursor;
        if (null != iDebuggerInterceptor) {
            iDebuggerInterceptor.enter(this, environment, function);
        }
        if ((xDMCursor = ((CursorStream)this.m_operand.evaluate(environment, function, iDebuggerInterceptor, false)).getCursor()).isEmpty()) {
            String string = new String("");
            return Debugger.leave(iDebuggerInterceptor, this, environment, function, string);
        }
        StringStream stringStream = new StringStream(xDMCursor.getStringValueX());
        return Debugger.leave(iDebuggerInterceptor, this, environment, function, stringStream);
    }

    @Override
    protected boolean supportsCodeGenerationOptimizationInternal(CodeGenerationOptimizationStyle codeGenerationOptimizationStyle, TypeEnvironment typeEnvironment, BindingEnvironment bindingEnvironment) {
        if (codeGenerationOptimizationStyle instanceof StreamOptimizationStyle) {
            return true;
        }
        return super.supportsCodeGenerationOptimizationInternal(codeGenerationOptimizationStyle, typeEnvironment, bindingEnvironment);
    }

    @Override
    public void generateCodeWithStreamOptimization(DataFlowCodeGenerationHelper dataFlowCodeGenerationHelper, String string, CodeGenerationTracker codeGenerationTracker, boolean bl) {
        String string2 = codeGenerationTracker.generateConventionally(this.m_operand, dataFlowCodeGenerationHelper);
        dataFlowCodeGenerationHelper.append("if (!" + string2 + ".isEmpty() ) {\n");
        String string3 = dataFlowCodeGenerationHelper.generateNewLocalVariableName();
        dataFlowCodeGenerationHelper.append("int " + string3 + " = " + string2 + ".copyStringValue(" + string + "_stream, " + string + "_size, " + string + "_stream.length - " + string + "_size);\n");
        dataFlowCodeGenerationHelper.append("if (" + string3 + " < 0) {\n");
        StreamType.generateGrowStream(dataFlowCodeGenerationHelper, string, CharType.s_charType.getStreamType(), "-(" + string3 + ")");
        dataFlowCodeGenerationHelper.append(string3 + " = " + string2 + ".copyStringValue(" + string + "_stream, " + string + "_size, " + string + "_stream.length - " + string + "_size);\n");
        dataFlowCodeGenerationHelper.append("}\n");
        dataFlowCodeGenerationHelper.append(string + "_size += " + string3 + ";\n");
        dataFlowCodeGenerationHelper.append("}\n");
    }
}

