/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Binding;
import com.ibm.xylem.BindingEnvironment;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.NavigationUtilities;
import com.ibm.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xylem.instructions.IdentifierInstruction;
import com.ibm.xylem.instructions.LetBaseInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.optimizers.partialeval.AbstractDataObjectPI;
import com.ibm.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xylem.optimizers.partialeval.PISubEntry;
import com.ibm.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xylem.types.AbstractDataType;
import com.ibm.xylem.types.TypeVariable;
import java.util.Collections;
import java.util.List;

public class OptimizerUtilities {
    private static int s_identifiers = 0;

    public static Instruction replaceDeconstructionBindings(Instruction[] instructionArray, Binding[] bindingArray, Instruction instruction) {
        Instruction instruction2 = null;
        Instruction instruction3 = null;
        for (int i = 0; i < instructionArray.length; ++i) {
            instruction3 = new LetInstruction(bindingArray[i].getName(), instructionArray[i].cloneReduced(), instruction3);
            if (instruction2 != null) continue;
            instruction2 = instruction3;
        }
        if (instruction2 == null) {
            instruction2 = instruction.cloneReduced();
            if (instruction3 == null) {
                instruction3 = instruction2;
            }
        } else {
            ((LetInstruction)instruction2).setBody(instruction.cloneReduced());
        }
        return instruction3;
    }

    public static String generateIntermediateIdentifier() {
        return OptimizerUtilities.generateIntermediateIdentifier("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateIntermediateIdentifier(String string) {
        Class<OptimizerUtilities> clazz = OptimizerUtilities.class;
        synchronized (OptimizerUtilities.class) {
            int n = ++s_identifiers;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return "$optimize" + n + (string.length() == 0 ? "" : "$" + string);
        }
    }

    public static final Instruction skipLets(Instruction instruction, List list) {
        while (instruction instanceof LetInstruction) {
            list.add(instruction);
            instruction = ((LetInstruction)instruction).getBody();
        }
        return instruction;
    }

    public static final Instruction skipLets(Instruction instruction) {
        while (instruction instanceof LetInstruction) {
            instruction = ((LetInstruction)instruction).getBody();
        }
        return instruction;
    }

    public static Instruction reconstructLets(Instruction instruction, List list) {
        return OptimizerUtilities.reconstructLets(instruction, list, true);
    }

    public static Instruction reconstructLets(Instruction instruction, List list, boolean bl) {
        LetBaseInstruction letBaseInstruction = null;
        LetInstruction letInstruction = null;
        for (LetInstruction letInstruction2 : list) {
            LetInstruction letInstruction3;
            LetInstruction letInstruction4 = letInstruction3 = bl ? new LetInstruction(letInstruction2.getVariable(), letInstruction2.getValue().cloneWithoutTypeInformation(), null) : letInstruction2;
            if (letInstruction == null) {
                letInstruction = letInstruction3;
            }
            if (letBaseInstruction != null) {
                letBaseInstruction.setBody(letInstruction3);
            }
            letBaseInstruction = letInstruction3;
        }
        if (letInstruction == null) {
            return instruction;
        }
        letBaseInstruction.setBody(instruction);
        return letInstruction;
    }

    public static AbstractDataObjectPI findCommonalities(PartialInformationCollector partialInformationCollector, List list, LetChainManager letChainManager) {
        Object object;
        BindingEnvironment bindingEnvironment = letChainManager.getCurrentFunction().getBindingEnvironment();
        Instruction[] instructionArray = null;
        Object object2 = null;
        for (Instruction instruction : list) {
            int n;
            Object object3;
            if ((instruction = NavigationUtilities.skipLets(instruction)) instanceof IdentifierInstruction) {
                object = (IdentifierInstruction)instruction;
                object3 = ((IdentifierInstruction)object).getBinding(letChainManager.getCurrentFunction().getBindingEnvironment());
                if (object3 != null && object3.getLet() != null) {
                    instruction = object3.getLet().getValue();
                } else {
                    return null;
                }
            }
            if (instruction == null) {
                return null;
            }
            if (!(instruction instanceof ConstructorInstantiationInstruction)) {
                return null;
            }
            object = (ConstructorInstantiationInstruction)instruction;
            object3 = ((ConstructorInstantiationInstruction)object).getConstructor();
            if (instructionArray == null) {
                instructionArray = new Instruction[((AbstractDataType.Constructor)object3).m_parameters.length];
                object2 = object3;
                for (n = 0; n < ((AbstractDataType.Constructor)object3).m_parameters.length; ++n) {
                    if (!((ConstructorInstantiationInstruction)object).m_parameters[n].isStatic(bindingEnvironment)) continue;
                    instructionArray[n] = ((ConstructorInstantiationInstruction)object).m_parameters[n];
                }
                continue;
            }
            if (object2 != object3) {
                return null;
            }
            for (n = 0; n < ((AbstractDataType.Constructor)object3).m_parameters.length; ++n) {
                if (((ConstructorInstantiationInstruction)object).m_parameters[n].isStatic(bindingEnvironment) && ((ConstructorInstantiationInstruction)object).m_parameters[n].equals(instructionArray[n])) continue;
                instructionArray[n] = null;
            }
        }
        if (instructionArray == null) {
            return null;
        }
        boolean bl = false;
        object = new PISubEntry[instructionArray.length];
        for (int i = 0; i < instructionArray.length; ++i) {
            if (instructionArray[i] == null) continue;
            instructionArray[i] = letChainManager.lookupBinding((Instruction)instructionArray[i]);
            if (!(instructionArray[i] instanceof LiteralInstruction)) continue;
            object[i] = new PISubEntry(Collections.EMPTY_SET, instructionArray[i], letChainManager.getCurrentFunction().getName());
            bl = true;
        }
        if (!bl) {
            return null;
        }
        AbstractDataObjectPI abstractDataObjectPI = new AbstractDataObjectPI((AbstractDataType.Constructor)object2, (PISubEntry[])object);
        return abstractDataObjectPI;
    }

    public static void clearTypeInformation(Instruction instruction) {
        int n;
        int n2 = instruction.getTypeParameterCount();
        for (n = 0; n < n2; ++n) {
            instruction.setTypeParameter(n, new TypeVariable());
        }
        n = instruction.getChildInstructionCount();
        for (int i = 0; i < n; ++i) {
            OptimizerUtilities.clearTypeInformation(instruction.getChildInstruction(i));
        }
    }
}

