/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.EndPoint;

public class ByteArrayEndPoint
implements EndPoint {
    byte[] _inBytes;
    ByteArrayBuffer _in;
    ByteArrayBuffer _out;
    boolean _closed;
    boolean _nonBlocking;
    boolean _growOutput;

    public ByteArrayEndPoint() {
    }

    public boolean isNonBlocking() {
        return this._nonBlocking;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this._nonBlocking = nonBlocking;
    }

    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this._inBytes = input;
        this._in = new ByteArrayBuffer(input);
        this._out = new ByteArrayBuffer(outputSize);
    }

    public ByteArrayBuffer getIn() {
        return this._in;
    }

    public void setIn(ByteArrayBuffer in) {
        this._in = in;
    }

    public ByteArrayBuffer getOut() {
        return this._out;
    }

    public void setOut(ByteArrayBuffer out) {
        this._out = out;
    }

    @Override
    public boolean isOpen() {
        return !this._closed;
    }

    @Override
    public boolean isBlocking() {
        return !this._nonBlocking;
    }

    @Override
    public boolean blockReadable(long millisecs) {
        return true;
    }

    @Override
    public boolean blockWritable(long millisecs) {
        return true;
    }

    @Override
    public void shutdownOutput() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this._closed = true;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._in == null) {
            return -1;
        }
        if (this._in.length() <= 0) {
            return this._nonBlocking ? 0 : -1;
        }
        int len = buffer.put(this._in);
        this._in.skip(len);
        return len;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        if (this._growOutput && buffer.length() > this._out.space()) {
            this._out.compact();
            if (buffer.length() > this._out.space()) {
                ByteArrayBuffer n = new ByteArrayBuffer(this._out.putIndex() + buffer.length());
                n.put(this._out.peek(0, this._out.putIndex()));
                if (this._out.getIndex() > 0) {
                    n.mark();
                    n.setGetIndex(this._out.getIndex());
                }
                this._out = n;
            }
        }
        int len = this._out.put(buffer);
        buffer.skip(len);
        return len;
    }

    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        if (this._closed) {
            throw new IOException("CLOSED");
        }
        int flushed = 0;
        if (header != null && header.length() > 0) {
            flushed = this.flush(header);
        }
        if (header == null || header.length() == 0) {
            if (buffer != null && buffer.length() > 0) {
                flushed += this.flush(buffer);
            }
            if ((buffer == null || buffer.length() == 0) && trailer != null && trailer.length() > 0) {
                flushed += this.flush(trailer);
            }
        }
        return flushed;
    }

    public void reset() {
        this._closed = false;
        this._in.clear();
        this._out.clear();
        if (this._inBytes != null) {
            this._in.setPutIndex(this._inBytes.length);
        }
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public String getLocalHost() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public Object getTransport() {
        return this._inBytes;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean isBufferingInput() {
        return false;
    }

    @Override
    public boolean isBufferingOutput() {
        return false;
    }

    @Override
    public boolean isBufferred() {
        return false;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    public void setGrowOutput(boolean growOutput) {
        this._growOutput = growOutput;
    }
}

