(function(/*! Brunch !*/) {
  'use strict';

  var globals = typeof window !== 'undefined' ? window : global;
  if (typeof globals.require === 'function') return;

  var modules = {};
  var cache = {};

  var has = function(object, name) {
    return ({}).hasOwnProperty.call(object, name);
  };

  var expand = function(root, name) {
    var results = [], parts, part;
    if (/^\.\.?(\/|$)/.test(name)) {
      parts = [root, name].join('/').split('/');
    } else {
      parts = name.split('/');
    }
    for (var i = 0, length = parts.length; i < length; i++) {
      part = parts[i];
      if (part === '..') {
        results.pop();
      } else if (part !== '.' && part !== '') {
        results.push(part);
      }
    }
    return results.join('/');
  };

  var dirname = function(path) {
    return path.split('/').slice(0, -1).join('/');
  };

  var localRequire = function(path) {
    return function(name) {
      var dir = dirname(path);
      var absolute = expand(dir, name);
      return globals.require(absolute, path);
    };
  };

  var initModule = function(name, definition) {
    var module = {id: name, exports: {}};
    cache[name] = module;
    definition(module.exports, localRequire(name), module);
    return module.exports;
  };

  var require = function(name, loaderPath) {
    var path = expand(name, '.');
    if (loaderPath == null) loaderPath = '/';

    if (has(cache, path)) return cache[path].exports;
    if (has(modules, path)) return initModule(path, modules[path]);

    var dirIndex = expand(path, './index');
    if (has(cache, dirIndex)) return cache[dirIndex].exports;
    if (has(modules, dirIndex)) return initModule(dirIndex, modules[dirIndex]);

    throw new Error('Cannot find module "' + name + '" from '+ '"' + loaderPath + '"');
  };

  var define = function(bundle, fn) {
    if (typeof bundle === 'object') {
      for (var key in bundle) {
        if (has(bundle, key)) {
          modules[key] = bundle[key];
        }
      }
    } else {
      modules[bundle] = fn;
    }
  };

  var list = function() {
    var result = [];
    for (var item in modules) {
      if (has(modules, item)) {
        result.push(item);
      }
    }
    return result;
  };

  globals.require = require;
  globals.require.define = define;
  globals.require.register = define;
  globals.require.list = list;
  globals.require.brunch = true;
})();
require.register("test/aliases/computed/alias", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {string} [type]
 */
App.TestAliases.testAsComputedAlias = function (context, propertyName, dependentKey, type) {
  var testsCases = [];
  var typesMap = {
    string: ['1234', '', 'abc', '{}'],
    number: [1234, 0, -1234, 1.2, -1.2],
    boolean: [true, false],
    object: [{a: 12345}, {}],
    array: [[1,2,3], [], [{}, {a: 1}]]
  };

  if (type) {
    testsCases = typesMap[type] || [];
  }
  else {
   // all
    testsCases = [].concat(Object.keys(typesMap).map(function (key) {return typesMap[key]}));
  }

  describe('#' + propertyName + ' as Em.computed.alias', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    testsCases.forEach(function (testedValue) {
      it('should be equal to the ' + JSON.stringify(dependentKey) + ' (' + Em.typeOf(testedValue) + ')', function () {
        helpers.smartStubGet(context, dependentKey, testedValue)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.eql(testedValue);
      });
    });

  });

};
});

require.register("test/aliases/computed/and", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var objectUtils = require('utils/object_utils');

var helpers = App.TestAliases.helpers;

function getTrulyCombination(dependentKeys) {
  var hash = {};
  dependentKeys.forEach(function (key) {
    if (key.startsWith('!')) {
      hash[key.substr(1)] = false;
    }
    else {
      hash[key] = true;
    }
  });
  return hash;
}

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string[]} dependentKeys
 */
App.TestAliases.testAsComputedAnd = function (context, propertyName, dependentKeys) {

  var realKeys = dependentKeys.map(function (key) {
    return key.startsWith('!') ? key.substr(1) : key;
  });
  var trulyCombination = getTrulyCombination(dependentKeys);
  var binaryCombos = helpers.getBinaryCombos(realKeys);

  describe('#' + propertyName + ' as Em.computed.and', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql(realKeys);
    });

    binaryCombos.forEach(function (combo) {

      var expectedResult = objectUtils.deepEqual(trulyCombination, combo);

      it('`' + expectedResult + '` for ' + JSON.stringify(combo), function() {
        helpers.smartStubGet(context, combo)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.equal(expectedResult);
      });

    });

  });

};
});

require.register("test/aliases/computed/countBasedMessage", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {string} zeroMessage
 * @param {string} oneMessage
 * @param {string} manyMessage
 */
App.TestAliases.testAsComputedCountBasedMessage = function (context, propertyName, dependentKey, zeroMessage, oneMessage, manyMessage) {

  describe('#' + propertyName + ' as Em.computed.countBasedMessage', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be equal to `zeroMessage` if ' + JSON.stringify(dependentKey) + ' is 0', function () {
      helpers.smartStubGet(context, dependentKey, 0)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(zeroMessage);
    });

    it('should be equal to `oneMessage` if ' + JSON.stringify(dependentKey) + ' is 1', function () {
      helpers.smartStubGet(context, dependentKey, 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(oneMessage);
    });

    it('should be equal to `manyMessage` if ' + JSON.stringify(dependentKey) + ' is 1+', function () {
      helpers.smartStubGet(context, dependentKey, 2)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(manyMessage);
    });

  });

};
});

require.register("test/aliases/computed/equal", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedEqual = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.equal', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is equal to the ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is not equal to the ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, Math.random())
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};
});

require.register("test/aliases/computed/equalProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedEqualProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.equalProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is equal to ' + JSON.stringify(dependentKey2), function () {
      var someValue = '1234567';
      var hash = {};
      hash[dependentKey1] = someValue;
      hash[dependentKey2] = someValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is not equal to ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = '12345';
      hash[dependentKey2] = '54321';
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};
});

require.register("test/aliases/computed/everyBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedEveryBy = function (context, propertyName, collectionName, keyName, neededValue) {

  describe('#' + propertyName + ' as Em.computed.everyBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `true` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if no one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.setEach(keyName, !neededValue); // something that not equal to the `neededValue`
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if at least one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.setEach(keyName, neededValue);
      collection[1][keyName] = !neededValue;
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if all objects in the ' + JSON.stringify(collectionName) + ' have ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.setEach(keyName, neededValue);
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/everyByKey", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {string} neededValueKey
 */
App.TestAliases.testAsComputedEveryByKey = function (context, propertyName, collectionName, keyName, neededValueKey) {

  describe('#' + propertyName + ' as Em.computed.everyByKey', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName, neededValueKey]);
    });

    it('should be `true` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if no one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.setEach(keyName, !neededValue); // something that not equal to the `neededValue`
      helpers.smartStubGet(context, {collectionName: collection, neededValueKey: neededValue})
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if at least one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.setEach(keyName, neededValue);
      collection[1][keyName] = !neededValue;
      helpers.smartStubGet(context, {collectionName: collection, neededValueKey: neededValue})
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if all objects in the ' + JSON.stringify(collectionName) + ' have ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.setEach(keyName, neededValue);
      var hash = {};
      hash[collectionName] = collection;
      hash[neededValueKey] = neededValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/existsIn", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {array} neededValues
 */
App.TestAliases.testAsComputedExistsIn = function (context, propertyName, dependentKey, neededValues) {

  describe('#' + propertyName + ' as Em.computed.existsIn', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    neededValues.forEach(function (neededValue) {

      it('should be `true` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
        helpers.smartStubGet(context, dependentKey, neededValue)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.be.true;
      });

    });

  });

};
});

require.register("test/aliases/computed/filterBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedFilterBy = function (context, propertyName, collectionName, keyName, neededValue) {

  describe('#' + propertyName + ' as Em.computed.filterBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be an array objects from  ' + JSON.stringify(collectionName) + ' with ' + JSON.stringify(keyName) + ' equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.forEach(function (item) {
        Ember.setFullPath(item, keyName, neededValue);
      });

      collection.setEach(keyName, neededValue);
      Em.set(collection[2], keyName, !neededValue);
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql(collection.slice(0, 2));
    });

  });

};
});

require.register("test/aliases/computed/filterByKey", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {string} neededValueKey
 */
App.TestAliases.testAsComputedFilterByKey = function (context, propertyName, collectionName, keyName, neededValueKey) {

  describe('#' + propertyName + ' as Em.computed.filterByKey', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName, neededValueKey]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be an array objects from  ' + JSON.stringify(collectionName) + ' with ' + JSON.stringify(keyName) + ' equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.forEach(function (item) {
        Ember.setFullPath(item, keyName, neededValue);
      });

      Em.set(collection[2], keyName, !neededValue);
      var hash = {};
      hash[collectionName] = collection;
      hash[neededValueKey] = neededValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql(collection.slice(0, 2));
    });

  });

};
});

require.register("test/aliases/computed/findBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedFindBy = function (context, propertyName, collectionName, keyName, neededValue) {

  describe('#' + propertyName + ' as Em.computed.findBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `undefined` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.undefined;
    });

    it('should be `null` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.null;
    });

    it('should be a first object from ' + JSON.stringify(collectionName) + ' with ' + JSON.stringify(keyName) + ' equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{i: 0}, {i: 1}, {i: 2}];
      collection.forEach(function (item) {
        Ember.setFullPath(item, keyName, neededValue)
      });
      Em.set(collection[2], keyName, !neededValue);
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql(collection[0]);
    });

  });

};
});

require.register("test/aliases/computed/findByKey", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {string} neededValueKey
 */
App.TestAliases.testAsComputedFindByKey = function (context, propertyName, collectionName, keyName, neededValueKey) {

  describe('#' + propertyName + ' as Em.computed.findByKey', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName, neededValueKey]);
    });

    it('should be `undefined` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.undefined;
    });

    it('should be `null` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.null;
    });

    it('should be a first object from ' + JSON.stringify(collectionName) + ' with ' + JSON.stringify(keyName) + ' equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{i: 0}, {i: 1}, {i: 2}];
      var neededValue = Math.random();
      collection.forEach(function (item) {
        Ember.setFullPath(item, keyName, neededValue)
      });
      Em.set(collection[2], keyName, !neededValue);
      var hash = {};
      hash[collectionName] = collection;
      hash[neededValueKey] = neededValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql(collection[0]);
    });

  });

};
});

require.register("test/aliases/computed/firstNotBlank", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

function prepareHash(dependentKeys, index) {
  var hash = {};
  dependentKeys.forEach(function (key, i) {
    hash[key] = i < index ? null : '' + i;
  });
  return hash;
}

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string[]} dependentKeys
 */
App.TestAliases.testAsComputedFirstNotBlank = function (context, propertyName, dependentKeys) {

  describe('#' + propertyName + ' as Em.computed.firstNotBlank', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql(dependentKeys);
    });

    dependentKeys.forEach(function(dependentKey, index) {

      it('should be equal to the ' + JSON.stringify(dependentKey), function () {
        helpers.smartStubGet(context, prepareHash(dependentKeys, index))
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.equal('' + index);
      });

    });

  });

};
});

require.register("test/aliases/computed/formatUnavailable", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 */
App.TestAliases.testAsComputedFormatNa = function (context, propertyName, dependentKey) {

  describe('#' + propertyName + ' as Em.computed.formatUnavailable', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `0` if ' + JSON.stringify(dependentKey) + ' is  `0`', function () {
      helpers.smartStubGet(context, dependentKey, 0)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(0);
    });

    it('should be `12` if ' + JSON.stringify(dependentKey) + ' is `12`', function () {
      helpers.smartStubGet(context, dependentKey, 12)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(12);
    });

    it('should be `n/a` if ' + JSON.stringify(dependentKey) + ' is not number >= 0', function () {
      helpers.smartStubGet(context, dependentKey, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(Em.I18n.t('services.service.summary.notAvailable'));
    });

  });

};
});

require.register("test/aliases/computed/getByKey", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} objectKey
 * @param {string} propertyKey
 * @param {{defaultValue: *, map: object}} [checks]
 */
App.TestAliases.testAsComputedGetByKey = function (context, propertyName, objectKey, propertyKey, checks) {

  var _checks = checks || {};
  var obj = _checks.map || Em.get(context, objectKey);
  var defaultValueIsSet = _checks.hasOwnProperty('defaultValue');

  describe('#' + propertyName + ' as Em.computed.getByKey', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([objectKey, propertyKey]);
    });

    Object.keys(obj).forEach(function (key) {
      var expectedValue = obj[key];
      it('should be `' + JSON.stringify(expectedValue) + '` if ' + JSON.stringify(propertyKey) + ' is ' + JSON.stringify(key), function () {
        helpers.smartStubGet(context, propertyKey, key)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.be.eql(expectedValue);
      });
    });

    if (defaultValueIsSet) {
      var defaultValue = _checks.defaultValue;
      it('should be `' + JSON.stringify(defaultValue) + '` if ' + JSON.stringify(propertyKey) + ' is not exist in the tested object', function () {
        helpers.smartStubGet(context, propertyKey, '' + Math.random())
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.be.eql(defaultValue);
      });
    }

  });

};
});

require.register("test/aliases/computed/gt", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {number} neededValue
 */
App.TestAliases.testAsComputedGt = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.gt', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is greater than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue + 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is lower than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue - 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};
});

require.register("test/aliases/computed/gtProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedGtProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.gtProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is greater than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 6;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is equal to ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 5;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is lower than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 4;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};

});

require.register("test/aliases/computed/gte", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {number} neededValue
 */
App.TestAliases.testAsComputedGte = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.gte', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is greater than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue + 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is lower than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue - 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};
});

require.register("test/aliases/computed/gteProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedGteProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.gteProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is greater than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 6;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is equal to ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 5;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is lower than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 4;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

  });

};
});

require.register("test/aliases/computed/ifThenElse", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {*} trueValue
 * @param {*} falseValue
 */
App.TestAliases.testAsComputedIfThenElse = function (context, propertyName, dependentKey, trueValue, falseValue) {

  describe('#' + propertyName + ' as Em.computed.ifThenElse', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `trueValue` if ' + JSON.stringify(dependentKey) + ' is `true`', function () {
      helpers.smartStubGet(context, dependentKey, true)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(trueValue);
    });

    it('should be `falseValue` if ' + JSON.stringify(dependentKey) + ' is `false`', function () {
      helpers.smartStubGet(context, dependentKey, false)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(falseValue);
    });

  });

};
});

require.register("test/aliases/computed/lt", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {number} neededValue
 */
App.TestAliases.testAsComputedLt = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.lt', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is greater than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue + 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is lower than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue - 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/ltProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedLtProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.lteProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is greater than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 6;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is equal to ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 5;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is lower than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 4;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/lte", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {number} neededValue
 */
App.TestAliases.testAsComputedLte = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.lte', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is greater than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue + 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is lower than ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue - 1)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/lteProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedLteProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.lteProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is greater than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 6;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is equal to ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 5;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is lower than ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = 4;
      hash[dependentKey2] = 5;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/mapBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 */
App.TestAliases.testAsComputedMapBy = function (context, propertyName, collectionName, keyName) {

  describe('#' + propertyName + ' as Em.computed.mapBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be `[]` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([]);
    });

    it('should be an array with values of each ' + JSON.stringify(keyName) + ' in the ' + JSON.stringify(collectionName), function () {
      var collection = [{}, {}, {}];
      collection.forEach(function (item, index) {
        Ember.setFullPath(item, keyName, index);
      });
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.eql([0, 1, 2]);
    });

  });

};
});

require.register("test/aliases/computed/notEqual", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedNotEqual = function (context, propertyName, dependentKey, neededValue) {

  describe('#' + propertyName + ' as Em.computed.notEqual', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey) + ' is equal to the ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, neededValue)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey) + ' is not equal to the ' + JSON.stringify(neededValue), function () {
      helpers.smartStubGet(context, dependentKey, Math.random())
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/notEqualProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 */
App.TestAliases.testAsComputedNotEqualProperties = function (context, propertyName, dependentKey1, dependentKey2) {

  describe('#' + propertyName + ' as Em.computed.notEqualProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be `false` if ' + JSON.stringify(dependentKey1) + ' is equal to the ' + JSON.stringify(dependentKey2), function () {
      var someValue = '1234567';
      var hash = {};
      hash[dependentKey1] = someValue;
      hash[dependentKey2] = someValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if ' + JSON.stringify(dependentKey1) + ' is not equal to the ' + JSON.stringify(dependentKey2), function () {
      var hash = {};
      hash[dependentKey1] = '12345';
      hash[dependentKey2] = '54321';
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/notExistsIn", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {array} neededValues
 */
App.TestAliases.testAsComputedNotExistsIn = function (context, propertyName, dependentKey, neededValues) {

  describe('#' + propertyName + ' as Em.computed.notExistsIn', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    neededValues.forEach(function (neededValue) {

      it('should be `false` if ' + JSON.stringify(dependentKey) + ' is equal to ' + JSON.stringify(neededValue), function () {
        helpers.smartStubGet(context, dependentKey, neededValue)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.be.false;
      });

    });

  });

};
});

require.register("test/aliases/computed/or", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var objectUtils = require('utils/object_utils');

var helpers = App.TestAliases.helpers;

function getFalsyCombination(dependentKeys) {
  var hash = {};
  dependentKeys.forEach(function (key) {
    if (key.startsWith('!')) {
      hash[key.substr(1)] = true;
    }
    else {
      hash[key] = false;
    }
  });
  return hash;
}


/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string[]} dependentKeys
 */
App.TestAliases.testAsComputedOr = function (context, propertyName, dependentKeys) {

  var realKeys = dependentKeys.map(function (key) {
    return key.startsWith('!') ? key.substr(1) : key;
  });
  var falsyCombination = getFalsyCombination(dependentKeys);
  var binaryCombos = helpers.getBinaryCombos(realKeys);

  describe('#' + propertyName + ' as Em.computed.or', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql(realKeys);
    });

    binaryCombos.forEach(function (combo) {

      var expectedResult = !objectUtils.deepEqual(falsyCombination, combo);

      it('`' + expectedResult + '` for ' + JSON.stringify(combo), function() {
        helpers.smartStubGet(context, combo)
          .propertyDidChange(context, propertyName);
        var value = helpers.smartGet(context, propertyName);
        expect(value).to.equal(expectedResult);
      });

    });

  });

};
});

require.register("test/aliases/computed/percents", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey1
 * @param {string} dependentKey2
 * @param {number} [accuracy=0]
 */
App.TestAliases.testAsComputedPercents = function (context, propertyName, dependentKey1, dependentKey2, accuracy) {

  describe('#' + propertyName + ' as Em.computed.percents', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey1, dependentKey2]);
    });

    it('should be calculated with ' + JSON.stringify(dependentKey1) + ' and ' + JSON.stringify(dependentKey2), function() {
      var hash = {};
      hash[dependentKey1] = 10;
      hash[dependentKey2] = 20;
      var result = 10 / 20 * 100;
      result = accuracy ? parseFloat(result.toFixed(accuracy)) : Math.round(result);
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(result);
    });

  });

};
});

require.register("test/aliases/computed/someBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {*} neededValue
 */
App.TestAliases.testAsComputedSomeBy = function (context, propertyName, collectionName, keyName, neededValue) {

  describe('#' + propertyName + ' as Em.computed.someBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if no one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.setEach(keyName, !neededValue); // something that not equal to the `neededValue`
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if at least one object in the ' + JSON.stringify(collectionName) + ' has ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.setEach(keyName, !neededValue);
      collection.forEach(function (item) {
        Em.setFullPath(item, keyName, !neededValue);
      });
      Em.set(collection[1], keyName, neededValue);
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if all objects in the ' + JSON.stringify(collectionName) + ' have ' + JSON.stringify(keyName) + ' with value equal to the ' + JSON.stringify(neededValue), function () {
      var collection = [{}, {}, {}];
      collection.forEach(function (item) {
        Em.setFullPath(item, keyName, neededValue);
      });
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/someByKey", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 * @param {string} neededValueKey
 */
App.TestAliases.testAsComputedSomeByKey = function (context, propertyName, collectionName, keyName, neededValueKey) {

  describe('#' + propertyName + ' as Em.computed.someByKey', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName, neededValueKey]);
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `false` if no one object in the ' + JSON.stringify(collectionName) + ' does not have ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.setEach(keyName, !neededValue); // something that not equal to the `neededValue`
      helpers.smartStubGet(context, {collectionName: collection, neededValueKey: neededValue})
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.false;
    });

    it('should be `true` if at least one object in the ' + JSON.stringify(collectionName) + ' has ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.setEach(keyName, !neededValue);
      collection.forEach(function (item) {
        Em.setFullPath(item, keyName, !neededValue);
      });
      Em.set(collection[1], keyName, neededValue);
      helpers.smartStubGet(context, {collectionName: collection, neededValueKey: neededValue})
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

    it('should be `true` if all objects in the ' + JSON.stringify(collectionName) + ' have ' + JSON.stringify(keyName) + ' with value equal to the value in ' + JSON.stringify(neededValueKey), function () {
      var collection = [{}, {}, {}];
      var neededValue = Math.random();
      collection.forEach(function (item) {
        Em.setFullPath(item, keyName, neededValue);
      });
      var hash = {};
      hash[collectionName] = collection;
      hash[neededValueKey] = neededValue;
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.true;
    });

  });

};
});

require.register("test/aliases/computed/sumBy", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} collectionName
 * @param {string} keyName
 */
App.TestAliases.testAsComputedSumBy = function (context, propertyName, collectionName, keyName) {

  describe('#' + propertyName + ' as Em.computed.sumBy', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([collectionName + '.@each.' + keyName]);
    });

    it('should be `0` if ' + JSON.stringify(collectionName) + ' is empty', function () {
      helpers.smartStubGet(context, collectionName, [])
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(0);
    });

    it('should be `0` if ' + JSON.stringify(collectionName) + ' does not exist', function () {
      helpers.smartStubGet(context, collectionName, null)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(0);
    });

    it('should be a sum of the values of each ' + JSON.stringify(keyName) + ' in the ' + JSON.stringify(collectionName), function () {
      var collection = [{}, {}, {}];
      collection.forEach(function (item, index) {
        Ember.setFullPath(item, keyName, index);
      });
      helpers.smartStubGet(context, collectionName, collection)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(3); // 0 + 1 + 2
    });

  });

};
});

require.register("test/aliases/computed/sumProperties", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string[]} dependentKeys
 */
App.TestAliases.testAsComputedSumProperties = function (context, propertyName, dependentKeys) {

  describe('#' + propertyName + ' as Em.computed.sumProperties', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql(dependentKeys);
    });

    it('should calculate sum of the ' + JSON.stringify(dependentKeys), function () {
      var hash = {};
      var result = 0;
      dependentKeys.forEach(function (k, i) {
        hash[k] = i;
        result += i;
      });
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(result);
    });

    it('should calculate sum of the ' + JSON.stringify(dependentKeys) + ' (2)', function () {
      var hash = {};
      var result = 0;
      dependentKeys.forEach(function (k, i) {
        hash[k] = i * 2;
        result += i * 2;
      });
      helpers.smartStubGet(context, hash)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.equal(result);
    });

  });

};
});

require.register("test/aliases/computed/truncate", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var helpers = App.TestAliases.helpers;

var strTemplate = '0123456789';

/**
 * 10 -> '0123456789'
 *  5 -> '01234'
 * 15 -> '012345678901234'
 *
 * @param length
 * @returns {string}
 */
function getStr(length) {
  var ret = '';
  var n = Math.floor(length / 10);
  var m = length % 10;
  for (var i = 0; i < n; i++) {
    ret += strTemplate;
  }
  ret += strTemplate.substr(0, m);
  return ret;
}

/**
 *
 * @param {Em.Object} context
 * @param {string} propertyName
 * @param {string} dependentKey
 * @param {number} maxLength
 * @param {number} reduceTo
 * @param {string} [replacer]
 */
App.TestAliases.testAsComputedTruncate = function (context, propertyName, dependentKey, maxLength, reduceTo, replacer) {

  var _replacer = arguments.length > 5 ? replacer : '...';

  describe('#' + propertyName + ' as Em.computed.truncate', function () {

    afterEach(function () {
      helpers.smartRestoreGet(context);
    });

    it('has valid dependent keys', function () {
      expect(Em.meta(context).descs[propertyName]._dependentKeys).to.eql([dependentKey]);
    });

    it('should be truncated if `maxLength` > ' + JSON.stringify(dependentKey) + ' length', function () {
      var val = getStr(maxLength + 1);
      var expectedValue = val.substr(0, reduceTo) + _replacer;
      helpers.smartStubGet(context, dependentKey, val)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(expectedValue);
    });

    it('should not be truncated if `maxLength` = ' + JSON.stringify(dependentKey) + ' length', function () {
      var val = getStr(maxLength);
      var expectedValue = val;
      helpers.smartStubGet(context, dependentKey, val)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(expectedValue);
    });

    it('should not be truncated if `maxLength` < ' + JSON.stringify(dependentKey) + ' length', function () {
      var val = getStr(maxLength - 1);
      var expectedValue = val;
      helpers.smartStubGet(context, dependentKey, val)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(expectedValue);
    });

    it('should be "" if ' + JSON.stringify(dependentKey) + ' value is empty', function () {
      var val = null;
      var expectedValue = '';
      helpers.smartStubGet(context, dependentKey, val)
        .propertyDidChange(context, propertyName);
      var value = helpers.smartGet(context, propertyName);
      expect(value).to.be.equal(expectedValue);
    });

  });

};
});

require.register("test/app_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('views/common/quick_view_link_view');
require('models/host_component');
require('models/stack_service_component');
App.auth = ["AMBARI.ADD_DELETE_CLUSTERS", "AMBARI.ASSIGN_ROLES", "AMBARI.EDIT_STACK_REPOS", "AMBARI.MANAGE_GROUPS", "AMBARI.MANAGE_STACK_VERSIONS", "AMBARI.MANAGE_USERS", "AMBARI.MANAGE_VIEWS", "AMBARI.RENAME_CLUSTER", "SERVICE.SET_SERVICE_USERS_GROUPS", "CLUSTER.TOGGLE_ALERTS", "CLUSTER.TOGGLE_KERBEROS", "CLUSTER.UPGRADE_DOWNGRADE_STACK", "CLUSTER.VIEW_ALERTS", "CLUSTER.VIEW_CONFIGS", "CLUSTER.VIEW_METRICS", "CLUSTER.VIEW_STACK_DETAILS", "CLUSTER.VIEW_STATUS_INFO", "HOST.ADD_DELETE_COMPONENTS", "HOST.ADD_DELETE_HOSTS", "HOST.TOGGLE_MAINTENANCE", "HOST.VIEW_CONFIGS", "HOST.VIEW_METRICS", "HOST.VIEW_STATUS_INFO", "SERVICE.ADD_DELETE_SERVICES", "SERVICE.COMPARE_CONFIGS", "SERVICE.DECOMMISSION_RECOMMISSION", "SERVICE.ENABLE_HA", "SERVICE.MANAGE_CONFIG_GROUPS", "SERVICE.MODIFY_CONFIGS", "SERVICE.MOVE", "SERVICE.RUN_CUSTOM_COMMAND", "SERVICE.RUN_SERVICE_CHECK", "SERVICE.START_STOP", "SERVICE.TOGGLE_ALERTS", "SERVICE.TOGGLE_MAINTENANCE", "SERVICE.VIEW_ALERTS", "SERVICE.VIEW_CONFIGS", "SERVICE.VIEW_METRICS", "SERVICE.VIEW_STATUS_INFO", "VIEW.USE"];

describe('App', function () {

  describe('#stackVersionURL', function () {

    App.set('defaultStackVersion', "HDP-1.2.2");
    App.set('currentStackVersion', "HDP-1.2.2");

    var testCases = [
      {
        title: 'if currentStackVersion and defaultStackVersion are empty then stackVersionURL should contain prefix',
        currentStackVersion: '',
        defaultStackVersion: '',
        result: '/stacks/HDP/versions/'
      },
      {
        title: 'if currentStackVersion is "HDP-1.3.1" then stackVersionURL should be "/stacks/HDP/versions/1.3.1"',
        currentStackVersion: 'HDP-1.3.1',
        defaultStackVersion: '',
        result: '/stacks/HDP/versions/1.3.1'
      },
      {
        title: 'if defaultStackVersion is "HDP-1.3.1" then stackVersionURL should be "/stacks/HDP/versions/1.3.1"',
        currentStackVersion: '',
        defaultStackVersion: 'HDP-1.3.1',
        result: '/stacks/HDP/versions/1.3.1'
      },
      {
        title: 'if defaultStackVersion and currentStackVersion are different then stackVersionURL should have currentStackVersion value',
        currentStackVersion: 'HDP-1.3.2',
        defaultStackVersion: 'HDP-1.3.1',
        result: '/stacks/HDP/versions/1.3.2'
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        App.set('defaultStackVersion', test.defaultStackVersion);
        App.set('currentStackVersion', test.currentStackVersion);
        expect(App.get('stackVersionURL')).to.equal(test.result);
        App.set('defaultStackVersion', "HDP-1.2.2");
        App.set('currentStackVersion', "HDP-1.2.2");
      });
    });
  });

  describe('#falconServerURL', function () {

    var testCases = [
      {
        title: 'No services installed, url should be empty',
        service: Em.A([]),
        result: ''
      },
      {
        title: 'FALCON is not installed, url should be empty',
        service: Em.A([
          {
            serviceName: 'HDFS'
          }
        ]),
        result: ''
      },
      {
        title: 'FALCON is installed, url should be "host1"',
        service: Em.A([
          Em.Object.create({
            serviceName: 'FALCON',
            hostComponents: [
              Em.Object.create({
                componentName: 'FALCON_SERVER',
                hostName: 'host1'
              })
            ]
          })
        ]),
        result: 'host1'
      }
    ];

    testCases.forEach(function (test) {
      describe(test.title, function () {

        beforeEach(function () {
          sinon.stub(App.Service, 'find', function () {
            return test.service;
          });
        });

        afterEach(function () {
          App.Service.find.restore();
        });

        it('App.falconServerURL is ' + test.result, function () {
          expect(App.get('falconServerURL')).to.equal(test.result);
        });

      });
    });
  });

  describe('#currentStackVersionNumber', function () {

    var testCases = [
      {
        title: 'if currentStackVersion is empty then currentStackVersionNumber should be empty',
        currentStackVersion: '',
        result: ''
      },
      {
        title: 'if currentStackVersion is "HDP-1.3.1" then currentStackVersionNumber should be "1.3.1',
        currentStackVersion: 'HDP-1.3.1',
        result: '1.3.1'
      },
      {
        title: 'if currentStackVersion is "HDPLocal-1.3.1" then currentStackVersionNumber should be "1.3.1',
        currentStackVersion: 'HDPLocal-1.3.1',
        result: '1.3.1'
      }
    ];
    before(function () {
      App.set('defaultStackVersion', '');
    });
    after(function () {
      App.set('defaultStackVersion', 'HDP-2.0.5');
    });
    testCases.forEach(function (test) {
      it(test.title, function () {
        App.set('currentStackVersion', test.currentStackVersion);
        expect(App.get('currentStackVersionNumber')).to.equal(test.result);
        App.set('currentStackVersion', "HDP-1.2.2");
      });
    });
  });

  describe('#isHaEnabled when HDFS is installed:', function () {

    beforeEach(function () {
      sinon.stub(App.Service, 'find').returns(Em.Object.create({'isLoaded': true}));
      this.mock = sinon.stub(App.HostComponent, 'find');
    });
    afterEach(function () {
      App.Service.find.restore();
      this.mock.restore();
    });

    it('if hadoop stack version higher than 2 then isHaEnabled should be true', function () {
      this.mock.returns([]);
      App.propertyDidChange('isHaEnabled');
      expect(App.get('isHaEnabled')).to.equal(true);
    });
    it('if cluster has SECONDARY_NAMENODE then isHaEnabled should be false', function () {
      this.mock.returns([Em.Object.create({componentName: 'SECONDARY_NAMENODE'})]);
      App.propertyDidChange('isHaEnabled');
      expect(App.get('isHaEnabled')).to.equal(false);
    });
  });

  describe('#isHaEnabled when HDFS is not installed:', function () {

    beforeEach(function () {
      sinon.stub(App.Service, 'find').returns(Em.Object.create({'isLoaded': false}));
    });
    afterEach(function () {
      App.Service.find.restore();
    });

    it('if hadoop stack version higher than 2 but HDFS not installed then isHaEnabled should be false', function () {
      App.set('currentStackVersion', 'HDP-2.1');
      expect(App.get('isHaEnabled')).to.equal(false);
      App.set('currentStackVersion', "HDP-1.2.2");
    });

  });


  describe('#services', function () {
    var stackServices = [
      Em.Object.create({
        serviceName: 'S1',
        isClientOnlyService: true
      }),
      Em.Object.create({
        serviceName: 'S2',
        hasClient: true
      }),
      Em.Object.create({
        serviceName: 'S3',
        hasMaster: true
      }),
      Em.Object.create({
        serviceName: 'S4',
        hasSlave: true
      }),
      Em.Object.create({
        serviceName: 'S5',
        isNoConfigTypes: true
      }),
      Em.Object.create({
        serviceName: 'S6',
        isMonitoringService: true
      }),
      Em.Object.create({
        serviceName: 'S7'
      })
    ];

    beforeEach(function () {
      sinon.stub(App.StackService, 'find', function () {
        return stackServices;
      });
    });

    afterEach(function () {
      App.StackService.find.restore();
    });

    it('App.services.all', function () {
      expect(App.get('services.all')).to.eql(['S1', 'S2', 'S3', 'S4', 'S5', 'S6', 'S7']);
    });

    it('App.services.clientOnly', function () {
      expect(App.get('services.clientOnly')).to.eql(['S1']);
    });

    it('App.services.hasClient', function () {
      expect(App.get('services.hasClient')).to.eql(['S2']);
    });

    it('App.services.hasMaster', function () {
      expect(App.get('services.hasMaster')).to.eql(['S3']);
    });

    it('App.services.hasSlave', function () {
      expect(App.get('services.hasSlave')).to.eql(['S4']);
    });

    it('App.services.noConfigTypes', function () {
      expect(App.get('services.noConfigTypes')).to.eql(['S5']);
    });

    it('App.services.monitoring', function () {
      expect(App.get('services.monitoring')).to.eql(['S6']);
    });
  });


  describe('#components', function () {
    var i = 0,
      testCases = [
        {
          key: 'allComponents',
          data: [
            Em.Object.create({
              componentName: 'C1'
            })
          ],
          result: ['C1']
        },
        {
          key: 'reassignable',
          data: [
            Em.Object.create({
              componentName: 'C2',
              isReassignable: true
            })
          ],
          result: ['C2']
        },
        {
          key: 'restartable',
          data: [
            Em.Object.create({
              componentName: 'C3',
              isRestartable: true
            })
          ],
          result: ['C3']
        },
        {
          key: 'deletable',
          data: [
            Em.Object.create({
              componentName: 'C4',
              isDeletable: true
            })
          ],
          result: ['C4']
        },
        {
          key: 'rollinRestartAllowed',
          data: [
            Em.Object.create({
              componentName: 'C5',
              isRollinRestartAllowed: true
            })
          ],
          result: ['C5']
        },
        {
          key: 'decommissionAllowed',
          data: [
            Em.Object.create({
              componentName: 'C6',
              isDecommissionAllowed: true
            })
          ],
          result: ['C6']
        },
        {
          key: 'refreshConfigsAllowed',
          data: [
            Em.Object.create({
              componentName: 'C7',
              isRefreshConfigsAllowed: true
            })
          ],
          result: ['C7']
        },
        {
          key: 'addableToHost',
          data: [
            Em.Object.create({
              componentName: 'C8',
              isAddableToHost: true
            })
          ],
          result: ['C8']
        },
        {
          key: 'addableMasterInstallerWizard',
          data: [
            Em.Object.create({
              componentName: 'C9',
              isMasterAddableInstallerWizard: true,
              showAddBtnInInstall: true
            })
          ],
          result: ['C9']
        },
        {
          key: 'multipleMasters',
          data: [
            Em.Object.create({
              componentName: 'C10',
              isMasterWithMultipleInstances: true
            })
          ],
          result: ['C10']
        },
        {
          key: 'slaves',
          data: [
            Em.Object.create({
              componentName: 'C11',
              isSlave: true
            })
          ],
          result: ['C11']
        },
        {
          key: 'clients',
          data: [
            Em.Object.create({
              componentName: 'C12',
              isClient: true
            })
          ],
          result: ['C12']
        }
      ];

    beforeEach(function () {
      sinon.stub(App.StackServiceComponent, 'find', function () {
        return testCases[i].data;
      });
    });

    afterEach(function () {
      i++;
      App.StackServiceComponent.find.restore();
    });

    testCases.forEach(function (test) {
      it(test.key + ' should contain ' + test.result, function () {
        expect(App.get('components.' + test.key)).to.eql(test.result);
      })
    })
  });

  describe('#upgradeIsRunning', function () {

    Em.A([
        {
          upgradeState: 'IN_PROGRESS',
          m: 'should be true (1)',
          e: true
        },
        {
          upgradeState: 'HOLDING',
          m: 'should be true (2)',
          e: true
        },
        {
          upgradeState: 'FAKE',
          m: 'should be false',
          e: false
        }
      ]).forEach(function (test) {
        it(test.m, function () {
          App.set('upgradeState', test.upgradeState);
          expect(App.get('upgradeIsRunning')).to.equal(test.e);
        });
      });

  });

  describe('#upgradeSuspended', function () {
    var cases = [
      {
        upgradeState: 'NOT_REQUIRED',
        isSuspended: false,
        upgradeSuspended: false
      },
      {
        upgradeState: 'ABORTED',
        isSuspended: false,
        upgradeSuspended: false
      },
      {
        upgradeState: 'ABORTED',
        isSuspended: true,
        upgradeSuspended: true
      }
    ];

    beforeEach(function() {
      this.mock = sinon.stub(App.router, 'get');
    });
    afterEach(function() {
      this.mock.restore();
    });

    cases.forEach(function (test) {
      it(test.upgradeState + ", isSuspended=" + test.isSuspended, function () {
        App.set('upgradeState', test.upgradeState);
        this.mock.returns(test.isSuspended);
        App.propertyDidChange('upgradeSuspended');
        expect(App.get('upgradeSuspended')).to.equal(test.upgradeSuspended);
      });
    });
  });

  describe('#upgradeAborted', function () {

    var cases = [
      {
        upgradeState: 'NOT_REQUIRED',
        isSuspended: false,
        upgradeAborted: false
      },
      {
        upgradeState: 'ABORTED',
        isSuspended: true,
        upgradeAborted: false
      },
      {
        upgradeState: 'ABORTED',
        isSuspended: false,
        upgradeAborted: true
      }
    ];

    beforeEach(function() {
      this.mock = sinon.stub(App.router, 'get');
    });
    afterEach(function() {
      this.mock.restore();
    });

    cases.forEach(function (test) {
      it(test.upgradeState + ", isSuspended=" + test.isSuspended, function () {
        App.set('upgradeState', test.upgradeState);
        this.mock.returns(test.isSuspended);
        App.propertyDidChange('upgradeAborted');
        expect(App.get('upgradeAborted')).to.equal(test.upgradeAborted);
      });
    });
  });

  describe('#wizardIsNotFinished', function () {
    var cases = [
      {
        upgradeState: 'NOT_REQUIRED',
        wizardIsNotFinished: false
      },
      {
        upgradeState: 'IN_PROGRESS',
        wizardIsNotFinished: true
      },
      {
        upgradeState: 'HOLDING',
        wizardIsNotFinished: true
      },
      {
        upgradeState: 'HOLDING_TIMEDOUT',
        wizardIsNotFinished: true
      },
      {
        upgradeState: 'ABORTED',
        wizardIsNotFinished: true
      }
    ];

    cases.forEach(function (item) {
      it(item.upgradeState, function () {
        App.set('upgradeState', item.upgradeState);
        App.propertyDidChange('wizardIsNotFinished');
        expect(App.get('wizardIsNotFinished')).to.equal(item.wizardIsNotFinished);
      });
    });
  });

  describe("#upgradeHolding", function () {
    var cases = [
      {
        upgradeState: 'NOT_REQUIRED',
        upgradeAborted: false,
        upgradeHolding: false
      },
      {
        upgradeState: 'HOLDING',
        upgradeAborted: false,
        upgradeHolding: true
      },
      {
        upgradeState: 'HOLDING_FAILED',
        upgradeAborted: false,
        upgradeHolding: true
      },
      {
        upgradeState: 'NOT_REQUIRED',
        upgradeAborted: true,
        upgradeHolding: true
      }
    ];

    beforeEach(function() {
      this.mock = sinon.stub(App.router, 'get');
    });
    afterEach(function() {
      this.mock.restore();
    });

    cases.forEach(function (test) {
      it(test.upgradeState + ", upgradeAborted=" + test.upgradeAborted, function () {
        App.reopen({
          upgradeAborted: test.upgradeAborted,
          upgradeState: test.upgradeState
        });
        App.propertyDidChange('upgradeHolding');
        expect(App.get('upgradeHolding')).to.equal(test.upgradeHolding);
      });
    });
  });
});

});

require.register("test/controllers/application_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('models/cluster');
var testHelpers = require('test/helpers');

function getController() {
  return App.ApplicationController.create();
}

describe('App.ApplicationController', function () {

  var applicationController = getController();

  App.TestAliases.testAsComputedTruncate(getController(), 'clusterDisplayName', 'clusterName', 13, 10);

  App.TestAliases.testAsComputedAnd(getController(), 'isClusterDataLoaded', ['App.router.clusterController.isLoaded','App.router.loggedIn']);

  App.TestAliases.testAsComputedAnd(getController(), 'isExistingClusterDataLoaded', ['App.router.clusterInstallCompleted','isClusterDataLoaded']);

  App.TestAliases.testAsComputedAnd(getController(), 'enableLinks', ['isExistingClusterDataLoaded','!App.isOnlyViewUser']);

  describe('#showAboutPopup', function() {
    var dataToShowRes = {};
    beforeEach(function () {
      sinon.stub(App.ModalPopup, 'show', function(dataToShow){
        dataToShowRes = dataToShow;
      });
    });
    afterEach(function () {
      App.ModalPopup.show.restore();
    });
    it ('Should send correct data to popup', function() {
      applicationController.showAboutPopup();
      dataToShowRes = JSON.parse(JSON.stringify(dataToShowRes));
      expect(dataToShowRes).to.eql({
        "header": "About",
        "secondary": false
      });
    });
  });

  describe('#clusterName', function() {
    beforeEach(function () {
      sinon.stub(App.router, 'get').returns('cl1');
    });
    afterEach(function () {
      App.router.get.restore();
    });
    it ('Should return cluster name', function() {
      expect(applicationController.get('clusterName')).to.equal('cl1');
    });
  });

  describe('#startKeepAlivePoller', function() {
    it ('Should change run poller state', function() {
      applicationController.set('isPollerRunning', false);
      applicationController.startKeepAlivePoller();
      expect(applicationController.get('isPollerRunning')).to.be.true;
    });
  });

  describe('#goToAdminView', function() {
    var result;
    beforeEach(function () {
      sinon.stub(App.router, 'route', function(data) {
        result = data;
        return false;
      });
    });
    afterEach(function () {
      App.router.route.restore();
    });
    it ('Should call route once', function() {
      applicationController.goToAdminView();
      expect(result).to.be.equal('adminView');
    });
  });

  describe('#getStack', function() {

    it ('Should return send value', function() {
      var callback = {
        'callback': true
      };
      applicationController.getStack(callback);
      var args = testHelpers.findAjaxRequest('name', 'router.login.clusters');
      expect(args[0]).to.exists;
      expect(args[0].callback.callback).to.be.true;
    });
  });

});

});

require.register("test/controllers/experimental_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

require('controllers/experimental');

var controller,
  supports = {},
  controllerSupports = [
    Em.Object.create({
      name: 'sup0',
      selected: true
    }),
    Em.Object.create({
      name: 'sup1',
      selected: false
    })
  ],
  saveObject = {};

describe('App.ExperimentalController', function () {

  before(function () {
    controllerSupports.forEach(function(item) {
      supports[item.get('name')] = item.get('selected');
    });
    sinon.stub(App, 'get', function(k) {
      if (k === 'supports') return supports;
      return Em.get(App, k);
    });
  });

  beforeEach(function () {
    controller = App.ExperimentalController.create();
  });

  after(function () {
    App.get.restore();
  });

  describe('#supports', function () {
    it('should take data from App.supports', function () {
      expect(controller.get('supports')).to.eql(controllerSupports);
    });
  });

  describe.skip('#doSave', function () {
    before(function () {
      sinon.stub(Ember, 'set', function (p, v) {
        if (p.startsWith('App.supports.')) {
          var key = p.replace('App.supports.', '');
          saveObject[key] = v;
          return v;
        }
        return Ember.set(p, v);
      });
      sinon.stub(App.router, 'transitionTo', Em.K);
    });

    after(function () {
      Em.set.restore();
      App.router.transitionTo.restore();
    });

    it('should pass data to App.supports', function () {
      controller.set('supports', controllerSupports);
      controller.doSave();
      expect(saveObject).to.eql(supports);
    });

  });

  describe('#getUserPrefSuccessCallback', function () {

    var receivedSupports = {
        sup0: false,
        sup2: true
      },
      expectedResult = {
        sup0: false,
        sup1: false,
        sup2: true
      };

    beforeEach(function () {
      sinon.spy(App, 'set');
    });

    afterEach(function () {
      App.set.restore();
    });

    it('no data received', function () {
      controller.getUserPrefSuccessCallback(null);
      expect(App.set.called).to.be.false;
    });

    it('some data received', function () {
      controller.getUserPrefSuccessCallback(receivedSupports);
      expect(App.set.calledWith('supports', expectedResult)).to.be.true;
    });

  });

});

});

require.register("test/controllers/global/background_operations_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');

require('config');
require('utils/updater');
require('utils/ajax/ajax');

require('models/host_component');

require('controllers/global/background_operations_controller');
require('views/common/modal_popup');
require('utils/host_progress_popup');

describe('App.BackgroundOperationsController', function () {

  var controller = App.BackgroundOperationsController.create({
    isInitLoading: Em.K
  });

  describe('#getQueryParams', function () {
    /**
     * Predefined data
     *
     */
    App.set('clusterName', 'testName');

    var tests = Em.A([
      {
        levelInfo: Em.Object.create({
          name: 'REQUESTS_LIST',
          requestId: null,
          taskId: null,
          sync: false
        }),
        e: {
          name: 'background_operations.get_most_recent',
          successCallback: 'callBackForMostRecent',
          data: {
            'operationsCount': 10
          }
        },
        response: {items: []},
        m: '"Get Most Recent"'
      },
      {
        levelInfo: Em.Object.create({
          name: 'TASK_DETAILS',
          requestId: 1,
          taskId: 1
        }),
        e: {
          name: 'background_operations.get_by_task',
          successCallback: 'callBackFilteredByTask',
          data: {
            taskId: 1,
            requestId: 1
          }
        },
        response: {items: {Tasks: {request_id: 0}}},
        m: '"Filtered By task"'
      },
      {
        levelInfo: Em.Object.create({
          name: 'TASKS_LIST',
          requestId: 1,
          taskId: 1
        }),
        e: {
          name: 'background_operations.get_by_request',
          successCallback: 'callBackFilteredByRequest',
          data: {
            requestId: 1
          }
        },
        response: {items: {Requests: {id: 0}}},
        m: '"Filtered By Request (TASKS_LIST)"'
      },
      {
        levelInfo: Em.Object.create({
          name: 'HOSTS_LIST',
          requestId: 1,
          taskId: 1
        }),
        e: {
          name: 'background_operations.get_by_request',
          successCallback: 'callBackFilteredByRequest',
          data: {
            requestId: 1
          }
        },
        response: {items: {Requests: {id: 0}}},
        m: '"Filtered By Request (HOSTS_LIST)"'
      }
    ]);

    tests.forEach(function (test) {
      it(test.m, function () {
        controller.set('levelInfo', test.levelInfo);
        var r = controller.getQueryParams();
        expect(r.name).to.equal(test.e.name);
        expect(r.successCallback).to.equal(test.e.successCallback);
        expect(r.data).to.eql(test.e.data);
      });
    });
  });

  describe('#startPolling()', function () {

    beforeEach(function () {
      sinon.spy(controller, 'requestMostRecent');
    });
    afterEach(function () {
      controller.requestMostRecent.restore();
    });

    it('isWorking = false', function () {
      controller.set('isWorking', false);
      expect(App.updater.run.calledOnce).to.equal(false);
      expect(controller.requestMostRecent.calledOnce).to.equal(false);
    });
    it('isWorking = true', function () {
      controller.set('isWorking', true);
      expect(App.updater.run.calledOnce).to.equal(true);
      expect(controller.requestMostRecent.calledOnce).to.equal(true);
    });
  });

  describe('#isUpgradeRequest', function() {

    it('defines if request is upgrade task (true)', function() {
      expect(controller.isUpgradeRequest({Requests: {request_context: "upgrading"}})).to.be.true;
    });

    it('defines if request is upgrade task (true - with uppercase)', function() {
      expect(controller.isUpgradeRequest({Requests: {request_context: "UPGRADING"}})).to.be.true;
    });

    it('defines if request is downgrade task (true - with uppercase)', function() {
      expect(controller.isUpgradeRequest({Requests: {request_context: "downgrading"}})).to.be.true;
    });

    it('defines if request is upgrade task (false)', function() {
      expect(controller.isUpgradeRequest({Requests: {request_context: "install"}})).to.be.false;
    });

    it('defines if request is upgrade task (false - invalid param)', function() {
      expect(controller.isUpgradeRequest({Requests: {}})).to.be.false;
    });
  });

  describe('#callBackForMostRecent()', function () {

    beforeEach(function () {
      sinon.stub(App.router.get('clusterController'), 'restoreUpgradeState', Em.K);
    });

    afterEach(function () {
      App.router.get('clusterController').restoreUpgradeState.restore();
    });

    it('No requests exists', function () {
      var data = {
        items: []
      };
      controller.callBackForMostRecent(data);
      expect(controller.get("allOperationsCount")).to.equal(0);
      expect(controller.get("services.length")).to.equal(0);
    });
    it('One non-running request', function () {
      var data = {
        items: [
          {
            Requests: {
              id: 1,
              request_context: '',
              task_count: 0,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ]
      };
      controller.callBackForMostRecent(data);
      expect(controller.get("allOperationsCount")).to.equal(0);
      expect(controller.get("services").mapProperty('id')).to.eql([1]);
    });

    it('One request that is excluded', function () {
      var data = {
        items: [
          {
            Requests: {
              id: 1,
              request_context: 'upgrading'
            }
          }
        ]
      };
      controller.callBackForMostRecent(data);
      expect(controller.get("allOperationsCount")).to.equal(0);
      expect(controller.get("services").mapProperty('id')).to.eql([]);
    });

    it('One running request', function () {
      var data = {
        items: [
          {
            Requests: {
              id: 1,
              request_context: '',
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ]
      };
      controller.callBackForMostRecent(data);
      expect(controller.get("allOperationsCount")).to.equal(1);
      expect(controller.get("services").mapProperty('id')).to.eql([1]);
    });
    it('Two requests in order', function () {
      var data = {
        items: [
          {
            Requests: {
              id: 1,
              request_context: ''
            }
          },
          {
            Requests: {
              id: 2,
              request_context: ''
            }
          }
        ]
      };
      controller.callBackForMostRecent(data);
      expect(controller.get("allOperationsCount")).to.equal(0);
      expect(controller.get("services").mapProperty('id')).to.eql([2, 1]);
    });
  });

  describe('#removeOldRequests()', function () {
    var testCases = [
      {
        title: 'No requests exist',
        content: {
          currentRequestIds: [],
          services: []
        },
        result: []
      },
      {
        title: 'One current request',
        content: {
          currentRequestIds: [1],
          services: [
            {id: 1}
          ]
        },
        result: [
          {id: 1}
        ]
      },
      {
        title: 'One old request',
        content: {
          currentRequestIds: [2],
          services: [
            {id: 1}
          ]
        },
        result: []
      },
      {
        title: 'One old request and one is current',
        content: {
          currentRequestIds: [2],
          services: [
            {id: 1},
            {id: 2}
          ]
        },
        result: [
          {id: 2}
        ]
      },
      {
        title: 'two old request and two current',
        content: {
          currentRequestIds: [3, 4],
          services: [
            {id: 1},
            {id: 2},
            {id: 3},
            {id: 4}
          ]
        },
        result: [
          {id: 3},
          {id: 4}
        ]
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.set('services', test.content.services);
        controller.removeOldRequests(test.content.currentRequestIds);
        expect(controller.get('services')).to.eql(test.result);
      });
    });
  });

  describe('#isRequestRunning()', function () {
    var testCases = [
      {
        title: 'Counters are missing',
        request: {
          Requests: {}
        },
        result: false
      },
      {
        title: 'Request has zero tasks',
        request: {
          Requests: {
            task_count: 0,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 0,
            queued_task_count: 0
          }
        },
        result: false
      },
      {
        title: 'One task in running status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 0,
            queued_task_count: 0
          }
        },
        result: true
      },
      {
        title: 'One task in queued status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 0,
            queued_task_count: 1
          }
        },
        result: true
      },
      {
        title: 'One task in aborted status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 1,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 0,
            queued_task_count: 0
          }
        },
        result: false
      },
      {
        title: 'One task in completed status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 0,
            completed_task_count: 1,
            failed_task_count: 0,
            timed_out_task_count: 0,
            queued_task_count: 0
          }
        },
        result: false
      },
      {
        title: 'One task in failed status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 1,
            timed_out_task_count: 0,
            queued_task_count: 0
          }
        },
        result: false
      },
      {
        title: 'One task in timed out status',
        request: {
          Requests: {
            task_count: 1,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 1,
            queued_task_count: 0
          }
        },
        result: false
      },
      {
        title: 'One task in timed out status and the second one in running',
        request: {
          Requests: {
            task_count: 2,
            aborted_task_count: 0,
            completed_task_count: 0,
            failed_task_count: 0,
            timed_out_task_count: 1,
            queued_task_count: 0
          }
        },
        result: true
      },
      {
        title: 'One task in each status',
        request: {
          Requests: {
            task_count: 5,
            aborted_task_count: 1,
            completed_task_count: 1,
            failed_task_count: 1,
            timed_out_task_count: 1,
            queued_task_count: 1
          }
        },
        result: true
      },
      {
        title: 'One task in each status except queued',
        request: {
          Requests: {
            task_count: 5,
            aborted_task_count: 1,
            completed_task_count: 1,
            failed_task_count: 1,
            timed_out_task_count: 1,
            queued_task_count: 0
          }
        },
        result: true
      },
      {
        title: 'No tasks in running status',
        request: {
          Requests: {
            task_count: 4,
            aborted_task_count: 1,
            completed_task_count: 1,
            failed_task_count: 1,
            timed_out_task_count: 1,
            queued_task_count: 0
          }
        },
        result: false
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        expect(controller.isRequestRunning(test.request)).to.eql(test.result);
      });
    });
  });

  describe('#isOneHost()', function () {
    var testCases = [
      {
        title: 'inputs is null',
        inputs: null,
        result: false
      },
      {
        title: 'inputs is "null"',
        inputs: 'null',
        result: false
      },
      {
        title: 'inputs is empty object',
        inputs: '{}',
        result: false
      },
      {
        title: 'included_hosts is empty',
        inputs: '{"included_hosts": ""}',
        result: false
      },
      {
        title: 'included_hosts contain one host',
        inputs: '{"included_hosts": "host1"}',
        result: true
      },
      {
        title: 'included_hosts contain two hosts',
        inputs: '{"included_hosts": "host1,host2"}',
        result: false
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        expect(controller.isOneHost(test.inputs)).to.eql(test.result);
      });
    });
  });

  describe('#assignScheduleId()', function () {
    var testCases = [
      {
        title: 'isOneHost is false',
        content: {
          request: {
            Requests: {
              request_schedule: {
                schedule_id: 1
              },
              inputs: null
            }
          },
          requestParams: ''
        },
        result: 1
      },
      {
        title: 'isOneHost is true and requestContext is empty',
        content: {
          request: {
            Requests: {
              request_schedule: {
                schedule_id: 1
              },
              inputs: '{"included_hosts": "host1"}'
            }
          },
          requestParams: {
            requestContext: ''
          }
        },
        result: 1
      },
      {
        title: 'isOneHost is true and requestContext contains "Recommission"',
        content: {
          request: {
            Requests: {
              request_schedule: {
                schedule_id: 1
              },
              inputs: '{"included_hosts": "host1"}'
            }
          },
          requestParams: {
            requestContext: 'Recommission'
          }
        },
        result: null
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.assignScheduleId(test.content.request, test.content.requestParams);
        expect(test.content.request.Requests.request_schedule.schedule_id).to.equal(test.result);
      });
    });
  });

  describe('#callBackFilteredByRequest()', function () {

    it('request haven\'t tasks and isRunning false', function () {
      var data = {
        Requests: {id: 1},
        tasks: []
      };
      var request = Em.Object.create({
        id: 1,
        previousTaskStatusMap: {},
        isRunning: false,
        progress: 0,
        status:''
      });
      controller.set('services', [request]);
      controller.callBackFilteredByRequest(data);
      expect(request.get('previousTaskStatusMap')).to.eql({});
      expect(request.get('hostsMap')).to.eql({});
      expect(request.get('isRunning')).to.equal(false);
    });

    it('request haven\'t tasks and isRunning true', function () {
      var data = {
        Requests: {id: 1},
        tasks: []
      };
      var request = Em.Object.create({
        id: 1,
        previousTaskStatusMap: {},
        isRunning: true,
        progress: 0,
        status:''
      });
      controller.set('services', [request]);
      controller.callBackFilteredByRequest(data);
      expect(request.get('previousTaskStatusMap')).to.eql({});
      expect(request.get('hostsMap')).to.eql({});
      expect(request.get('isRunning')).to.equal(true);
    });

    it('request has one completed task', function () {
      var data = {
        Requests: {id: 1},
        tasks: [
          {
            Tasks: {
              id: 1,
              host_name: 'host1',
              status: 'COMPLETED'
            }
          }
        ]
      };
      var request = Em.Object.create({
        id: 1,
        previousTaskStatusMap: {},
        isRunning: true,
        progress: 100,
        status:''
      });
      controller.set('services', [request]);
      controller.callBackFilteredByRequest(data);
      expect(request.get('previousTaskStatusMap')).to.eql({"1": "COMPLETED"});
      expect(request.get('hostsMap.host1.logTasks.length')).to.equal(1);
      expect(request.get('isRunning')).to.equal(false);
    });

    it('request has one completed task and one running task', function () {
      var data = {
        Requests: {id: 1},
        tasks: [
          {
            Tasks: {
              id: 1,
              host_name: 'host1',
              status: 'COMPLETED'
            }
          },
          {
            Tasks: {
              id: 2,
              host_name: 'host1',
              status: 'IN_PROGRESS'
            }
          }
        ]
      };
      var request = Em.Object.create({
        id: 1,
        previousTaskStatusMap: {},
        isRunning: true,
        progress: 100,
        status:''
      });
      controller.set('services', [request]);
      controller.callBackFilteredByRequest(data);
      expect(request.get('previousTaskStatusMap')).to.eql({"1": "COMPLETED", "2": "IN_PROGRESS"});
      expect(request.get('hostsMap.host1.logTasks.length')).to.equal(2);
      expect(request.get('isRunning')).to.equal(true);
    });
  });
});

});

require.register("test/controllers/global/cluster_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
var credentialUtils = require('utils/credentials');
var testHelpers = require('test/helpers');
require('controllers/global/cluster_controller');
require('models/host_component');
require('utils/http_client');
require('models/service');
require('models/host');
require('utils/ajax/ajax');
require('utils/string_utils');

var modelSetup = require('test/init_model_test');

describe('App.clusterController', function () {
  var controller = App.ClusterController.create();
  App.Service.FIXTURES = [
    {service_name: 'GANGLIA'}
  ];

  App.TestAliases.testAsComputedAnd(controller, 'isHostContentLoaded', ['isHostsLoaded', 'isComponentsStateLoaded']);

  App.TestAliases.testAsComputedAnd(controller, 'isServiceContentFullyLoaded', ['isServiceMetricsLoaded', 'isComponentsStateLoaded', 'isComponentsConfigLoaded']);

  App.TestAliases.testAsComputedAlias(controller, 'clusterName', 'App.clusterName', 'string');

  describe('#updateLoadStatus()', function () {

    controller.set('dataLoadList', Em.Object.create({
      'item1': false,
      'item2': false
    }));

    it('when none item is loaded then width should be "width:0"', function () {
      expect(controller.get('clusterDataLoadedPercent')).to.equal('width:0');
    });
    it('when first item is loaded then isLoaded should be false', function () {
      controller.updateLoadStatus('item1');
      expect(controller.get('isLoaded')).to.equal(false);
    });
    it('when first item is loaded then width should be "width:50%"', function () {
      controller.updateLoadStatus('item1');
      expect(controller.get('clusterDataLoadedPercent')).to.equal('width:50%');
    });

    it('when all items are loaded then isLoaded should be true', function () {
      controller.updateLoadStatus('item2');
      expect(controller.get('isLoaded')).to.equal(true);
    });
    it('when all items are loaded then width should be "width:100%"', function () {
      controller.updateLoadStatus('item2');
      expect(controller.get('clusterDataLoadedPercent')).to.equal('width:100%');
    });
  });

  describe('#loadClusterName()', function () {

    beforeEach(function () {
      modelSetup.setupStackVersion(this, 'HDP-2.0.5');
      App.ajax.send.restore(); // default ajax-mock can't be used here
      sinon.stub(App.ajax, 'send', function () {
        return {
          then: function (successCallback) {
            App.set('clusterName', 'clusterNameFromServer');
            App.set('currentStackVersion', 'HDP-2.0.5');
            successCallback();
          }
        }
      });
      this.args = testHelpers.findAjaxRequest('name', 'cluster.load_cluster_name');
    });
    afterEach(function () {
      modelSetup.restoreStackVersion(this);
    });

    it('if clusterName is "mycluster" and reload is false then clusterName stays the same', function () {
      App.set('clusterName', 'mycluster');
      controller.loadClusterName(false);
      expect(this.args).to.not.exists;
      expect(App.get('clusterName')).to.equal('mycluster');
    });

    it('reload is true and clusterName is not empty', function () {
      controller.loadClusterName(true);
      expect(this.args).to.exists;
      expect(App.get('clusterName')).to.equal('clusterNameFromServer');
      expect(App.get('currentStackVersion')).to.equal('HDP-2.0.5');
    });

    it('reload is false and clusterName is empty', function () {
      App.set('clusterName', '');
      controller.loadClusterName(false);
      expect(this.args).to.exists;
      expect(App.get('clusterName')).to.equal('clusterNameFromServer');
      expect(App.get('currentStackVersion')).to.equal('HDP-2.0.5');
    });


  });

  describe('#reloadSuccessCallback', function () {
    var testData = {
      "items": [
        {
          "Clusters": {
            "cluster_name": "tdk",
            "version": "HDP-1.3.0"
          }
        }
      ]
    };
    it('Check cluster', function () {
      controller.reloadSuccessCallback(testData);
      expect(App.get('clusterName')).to.equal('tdk');
      expect(App.get('currentStackVersion')).to.equal('HDP-1.3.0');
    });
  });

  describe('#getServerClockSuccessCallback()', function () {
    var testCases = [
      {
        title: 'if server clock is 1 then currentServerTime should be 1000',
        data: {
          RootServiceComponents: {
            server_clock: 1
          }
        },
        result: 1000
      },
      {
        title: 'if server clock is 0 then currentServerTime should be 0',
        data: {
          RootServiceComponents: {
            server_clock: 0
          }
        },
        result: 0
      },
      {
        title: 'if server clock is 111111111111 then currentServerTime should be 111111111111000',
        data: {
          RootServiceComponents: {
            server_clock: 111111111111
          }
        },
        result: 111111111111000
      },
      {
        title: 'if server clock is 1111111111113 then currentServerTime should be 1111111111113',
        data: {
          RootServiceComponents: {
            server_clock: 1111111111113
          }
        },
        result: 1111111111113
      }
    ];
    var currentServerTime = App.get('currentServerTime');
    var clockDistance = App.get('clockDistance');

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.getServerClockSuccessCallback(test.data);
        expect(App.get('currentServerTime')).to.equal(test.result);
        App.set('clockDistance', clockDistance);
        App.set('currentServerTime', currentServerTime);
      });
    });
  });

  describe('#getUrl', function () {
    controller.set('clusterName', 'tdk');
    var tests = ['test1', 'test2', 'test3'];

    tests.forEach(function (test) {
      it(test, function () {
        expect(controller.getUrl(test, test)).to.equal(App.apiPrefix + '/clusters/' + controller.get('clusterName') + test);
      });
    });
  });

  describe("#createKerberosAdminSession()", function() {

    beforeEach(function () {
      sinon.stub(credentialUtils, 'createOrUpdateCredentials', function() {
        return $.Deferred().resolve().promise();
      });
      this.stub = sinon.stub(App, 'get');
      this.stub.withArgs('clusterName').returns('test');
    });

    afterEach(function () {
      credentialUtils.createOrUpdateCredentials.restore();
      App.get.restore();
    });

    it("credentials updated via credentials storage call", function() {
      controller.createKerberosAdminSession({
        principal: 'admin',
        key: 'pass',
        type: 'persistent'
      }, {});
      var args = testHelpers.findAjaxRequest('name', 'common.cluster.update');
      expect(args).to.not.exists;
      expect(credentialUtils.createOrUpdateCredentials.getCall(0).args).to.eql([
        'test', 'kdc.admin.credential', {
          principal: 'admin',
          key: 'pass',
          type: 'persistent'
        }
      ]);
    });
  });

  describe('#checkDetailedRepoVersion()', function () {

    var cases = [
      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.1',
        isStormMetricsSupported: false,
        title: 'HDP < 2.2'
      },
      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.3',
        isStormMetricsSupported: true,
        title: 'HDP > 2.2'
      },
      {
        currentStackName: 'BIGTOP',
        currentStackVersionNumber: '0.8',
        isStormMetricsSupported: true,
        title: 'not HDP'
      }
    ];

    afterEach(function () {
      App.get.restore();
    });

    describe('should check detailed repo version for HDP 2.2', function () {

      beforeEach(function () {
        sinon.stub(App, 'get').withArgs('currentStackName').returns('HDP').withArgs('currentStackVersionNumber').returns('2.2');
      });

      it('request is sent', function () {
        controller.checkDetailedRepoVersion();
        var args = testHelpers.findAjaxRequest('name', 'cluster.load_detailed_repo_version');
        expect(args).to.exists;
      });
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(App, 'get', function (key) {
            return item[key] || Em.get(App, key);
          });
          controller.checkDetailedRepoVersion();
        });

        it('request is not sent', function () {
          var args = testHelpers.findAjaxRequest('name', 'cluster.load_detailed_repo_version');
          expect(args).to.not.exists;
        });

        it('App.isStormMetricsSupported is ' + item.isStormMetricsSupported, function () {
          expect(App.get('isStormMetricsSupported')).to.equal(item.isStormMetricsSupported);
        });

      });
    });

  });

  describe('#checkDetailedRepoVersionSuccessCallback()', function () {
    beforeEach(function () {
      sinon.stub(App, 'get', function(key) {
        if (key === 'currentStackName') {
          return 'HDP';
        }
        if (key === 'currentStackVersionNumber') {
          return '2.2';
        }
        return Em.get(App, key);
      });
    });
    afterEach(function() {
      App.get.restore();
    });

    var cases = [
      {
        items: [
          {
            ClusterStackVersions: {
              stack: 'HDP',
              version: '2.2'
            },
            repository_versions: [
              {
                RepositoryVersions: {
                  repository_version: '2.1'
                }
              }
            ]
          }
        ],
        isStormMetricsSupported: false,
        title: 'HDP < 2.2.2'
      },
      {
        items: [
          {
            ClusterStackVersions: {
              stack: 'HDP',
              version: '2.2'
            },
            repository_versions: [
              {
                RepositoryVersions: {
                  repository_version: '2.2.2'
                }
              }
            ]
          }
        ],
        isStormMetricsSupported: true,
        title: 'HDP 2.2.2'
      },
      {
        items: [
          {
            repository_versions: [
              {
                RepositoryVersions: {
                  repository_version: '2.2.3'
                }
              }
            ]
          }
        ],
        isStormMetricsSupported: true,
        title: 'HDP > 2.2.2'
      },
      {
        items: null,
        isStormMetricsSupported: true,
        title: 'empty response'
      },
      {
        items: [],
        isStormMetricsSupported: true,
        title: 'no items'
      },
      {
        items: [{}],
        isStormMetricsSupported: true,
        title: 'empty item'
      },
      {
        items: [{
          repository_versions: []
        }],
        isStormMetricsSupported: true,
        title: 'no versions'
      },
      {
        items: [{
          repository_versions: [{}]
        }],
        isStormMetricsSupported: true,
        title: 'no version info'
      },
      {
        items: [{
          repository_versions: [
            {
              RepositoryVersions: {}
            }
          ]
        }],
        isStormMetricsSupported: true,
        title: 'empty version info'
      }
    ];

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.checkDetailedRepoVersionSuccessCallback({
          items: item.items
        });
        expect(App.get('isStormMetricsSupported')).to.equal(item.isStormMetricsSupported);
      });
    });

  });

  describe('#checkDetailedRepoVersionErrorCallback()', function () {
    it('should set isStormMetricsSupported to default value', function () {
      controller.checkDetailedRepoVersionErrorCallback();
      expect(App.get('isStormMetricsSupported')).to.be.true;
    });
  });

  describe('#getAllUpgrades()', function () {

    it('should send request to get upgrades data', function () {
      controller.getAllUpgrades();
      var args = testHelpers.findAjaxRequest('name', 'cluster.load_last_upgrade');
      expect(args).to.exists;
    });

  });

  describe("#restoreUpgradeState()", function() {
    var data = {upgradeData: {}};
    var mock = {
      done: function (callback) {
        callback(data.upgradeData);
      }
    };
    var upgradeController = Em.Object.create({
      restoreLastUpgrade: Em.K,
      initDBProperties: Em.K,
      loadUpgradeData: Em.K,
      loadCompatibleVersions: Em.K,
      updateCurrentStackVersion: Em.K,
      loadStackVersionsToModel: function () {
        return {done: Em.clb};
      }
    });

    beforeEach(function () {
      sinon.stub(controller, 'getAllUpgrades').returns(mock);
      sinon.spy(mock, 'done');
      sinon.stub(App.router, 'get').returns(upgradeController);
      sinon.stub(App.db, 'get').returns('PENDING');
      sinon.spy(upgradeController, 'restoreLastUpgrade');
      sinon.spy(upgradeController, 'initDBProperties');
      sinon.spy(upgradeController, 'loadUpgradeData');
      sinon.spy(upgradeController, 'loadStackVersionsToModel');
      sinon.spy(upgradeController, 'loadCompatibleVersions');
      sinon.spy(upgradeController, 'updateCurrentStackVersion');
      sinon.stub(App.stackUpgradeHistoryMapper, 'map');
    });

    afterEach(function () {
      mock.done.restore();
      controller.getAllUpgrades.restore();
      App.router.get.restore();
      App.db.get.restore();
      upgradeController.restoreLastUpgrade.restore();
      upgradeController.initDBProperties.restore();
      upgradeController.loadUpgradeData.restore();
      upgradeController.loadStackVersionsToModel.restore();
      upgradeController.loadCompatibleVersions.restore();
      upgradeController.updateCurrentStackVersion.restore();
      App.stackUpgradeHistoryMapper.map.restore();
    });

    describe("has upgrade request", function() {

      beforeEach(function () {
        data.upgradeData = {items: [
          {
            Upgrade: {
              request_id: 1
            }
          }
        ]};
        controller.restoreUpgradeState();
      });

      it('getAllUpgrades is called once', function () {
        expect(controller.getAllUpgrades.calledOnce).to.be.true;
      });

      it('upgradeState is PENDING', function () {
        expect(App.get('upgradeState')).to.equal('PENDING');
      });

      it('restoreLastUpgrade is called with valid arguments', function () {
        expect(upgradeController.restoreLastUpgrade.calledWith(data.upgradeData.items[0])).to.be.true;
      });

      it('loadStackVersionsToModel is called with valid arguments', function () {
        expect(upgradeController.loadStackVersionsToModel.calledWith(true)).to.be.true;
      });

      it('loadCompatibleVersions should be called', function () {
        expect(upgradeController.loadCompatibleVersions.calledOnce).to.be.true;
      });

      it('updateCurrentStackVersion should be called', function () {
        expect(upgradeController.updateCurrentStackVersion.calledOnce).to.be.true;
      });

      it('initDBProperties is not called', function () {
        expect(upgradeController.initDBProperties.called).to.be.false;
      });

      it('loadUpgradeData is not called', function () {
        expect(upgradeController.loadUpgradeData.called).to.be.false;
      });

      it('App.stackUpgradeHistoryMapper.map should be called', function () {
        expect(App.stackUpgradeHistoryMapper.map.calledOnce).to.be.true;
      });
    });

    describe("has completed upgrade request", function() {

      beforeEach(function () {
        data.upgradeData = {items: [
          {
            Upgrade: {
              request_id: 1,
              request_status: 'COMPLETED'
            }
          }
        ]};
        controller.restoreUpgradeState();
      });

      it('getAllUpgrades is called once', function () {
        expect(controller.getAllUpgrades.calledOnce).to.be.true;
      });

      it('restoreLastUpgrade should not be called', function () {
        expect(upgradeController.restoreLastUpgrade.called).to.be.false;
      });

      it('loadStackVersionsToModel should be called', function () {
        expect(upgradeController.loadStackVersionsToModel).to.be.calledOnce;
      });
    });

    describe("does not have upgrade request", function() {

      beforeEach(function () {
        data.upgradeData = {items: []};
        controller.restoreUpgradeState();
      });

      it('getAllUpgrades is called once', function () {
        expect(controller.getAllUpgrades.calledOnce).to.be.true;
      });

      it('upgradeState is PENDING', function () {
        expect(App.get('upgradeState')).to.equal('PENDING');
      });

      it('restoreLastUpgrade is not called', function () {
        expect(upgradeController.restoreLastUpgrade.called).to.be.false;
      });

      it('loadStackVersionsToModel is called with valid arguments', function () {
        expect(upgradeController.loadStackVersionsToModel.calledWith(true)).to.be.true;
      });

      it('initDBProperties is called once', function () {
        expect(upgradeController.initDBProperties.calledOnce).to.be.true;
      });

      it('loadUpgradeData is called with valid arguments', function () {
        expect(upgradeController.loadUpgradeData.calledWith(true)).to.be.true;
      });

    });
  });
});

});

require.register("test/controllers/global/configuration_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/global/configuration_controller');


describe('App.ConfigurationController', function () {
  var controller = App.ConfigurationController.create();

  describe('#checkTagsChanges()', function () {
    var testCases = [
      {
        title: 'Tags haven\'t been uploaded',
        content: {
          tags: [],
          storedTags: []
        },
        result: false
      },
      {
        title: 'New tag uploaded',
        content: {
          tags: [
            {
              siteName: 'site1',
              tagName: 1
            }
          ],
          storedTags: []
        },
        result: true
      },
      {
        title: 'Existing tag with with new tagName',
        content: {
          tags: [
            {
              siteName: 'site1',
              tagName: 1
            }
          ],
          storedTags: [
            {
              siteName: 'site1',
              tagName: 2
            }
          ]
        },
        result: true
      },
      {
        title: 'Tags with different tagNames',
        content: {
          tags: [
            {
              siteName: 'site1',
              tagName: 1
            }
          ],
          storedTags: [
            {
              siteName: 'site2',
              tagName: 1
            }
          ]
        },
        result: true
      },
      {
        title: 'One new tag uploaded',
        content: {
          tags: [
            {
              siteName: 'site2',
              tagName: 1
            },
            {
              siteName: 'site1',
              tagName: 1
            }
          ],
          storedTags: [
            {
              siteName: 'site2',
              tagName: 1
            }
          ]
        },
        result: true
      },
      {
        title: 'Tags haven\'t been changed',
        content: {
          tags: [
            {
              siteName: 'site2',
              tagName: 1
            }
          ],
          storedTags: [
            {
              siteName: 'site2',
              tagName: 1
            }
          ]
        },
        result: false
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        expect(controller.checkTagsChanges(test.content.tags, test.content.storedTags)).to.equal(test.result);
      });
    });
  });
});
});

require.register("test/controllers/global/errors_handler_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');

require('controllers/global/errors_handler_controller');

describe('App.ErrorsHandlerController', function () {
  var controller;

  beforeEach(function() {
    controller = App.ErrorsHandlerController.create();
  });

  describe("#loadErrorLogs()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'getUserPref');
    });

    afterEach(function() {
      controller.getUserPref.restore();
    });

    it("getUserPref should be called", function() {
      controller.loadErrorLogs();
      expect(controller.getUserPref.calledWith('errors')).to.be.true;
    });
  });

  describe("#saveErrorLogs()", function () {

    beforeEach(function() {
      localStorage.removeItem('errors');
      sinon.stub(controller, 'postUserPref');
    });

    afterEach(function() {
      controller.postUserPref.restore();
    });

    it("postUserPref should be called", function() {
      controller.saveErrorLogs('err', 'url', 1, 2, {});
      var args = controller.postUserPref.getCall(0).args;
      expect(JSON.stringify(args[1][Object.keys(args[1])[0]])).to.be.equal(JSON.stringify({
        "file": "url",
        "line": 1,
        "col": 2,
        "error": "err"
      }));
      expect(args[0]).to.be.equal('errors');
    });
  });
});

});

require.register("test/controllers/global/update_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('utils/updater');
require('controllers/global/update_controller');
var testHelpers = require('test/helpers');
var c;

describe('App.UpdateController', function () {
  var controller = App.UpdateController.create({
    clusterName: '',
    location: '',
    updateServiceMetric: function(){}
  });

  beforeEach(function () {
    c = App.UpdateController.create();
  });

  App.TestAliases.testAsComputedAlias(App.UpdateController.create(), 'clusterName', 'App.router.clusterController.clusterName', 'string');

  App.TestAliases.testAsComputedAnd(App.UpdateController.create(), 'updateAlertInstances', ['isWorking', '!App.router.mainAlertInstancesController.isUpdating']);

  describe('#getUrl()', function () {

    it('testMode = false', function () {
      expect(controller.getUrl('test', '/real')).to.equal('/api/v1/clusters//real');
    });

    it('testMode = false (2)', function () {
      controller.set('clusterName', 'mycluster');
      expect(controller.getUrl('test', '/real')).to.equal('/api/v1/clusters/mycluster/real');
    });
  });

  describe('#updateAll()', function () {

    it('isWorking = false', function () {
      controller.set('isWorking', false);
      expect(App.updater.run.called).to.equal(false);
    });

    it('isWorking = true', function () {
      controller.set('isWorking', true);
      expect(App.updater.run.callCount).to.equal(13);
    });
  });

  describe('#getConditionalFields()', function () {

    var testCases = [
      {
        title: 'No services exist',
        services: [],
        result: ['metrics/1']
      },
      {
        title: 'HDFS service',
        services: [
          {
            ServiceInfo: {
              service_name: 'HDFS'
            }
          }
        ],
        result: ['metrics/1']
      },
      {
        title: 'FLUME service',
        services: [
          {
            ServiceInfo: {
              service_name: 'FLUME'
            }
          }
        ],
        result: ['metrics/1', "host_components/processes/HostComponentProcess"]
      },
      {
        title: 'YARN service',
        services: [
          {
            ServiceInfo: {
              service_name: 'YARN'
            }
          }
        ],
        result: ['metrics/1', "host_components/metrics/yarn/Queue," +
        "host_components/metrics/yarn/ClusterMetrics/NumActiveNMs," +
        "host_components/metrics/yarn/ClusterMetrics/NumLostNMs," +
        "host_components/metrics/yarn/ClusterMetrics/NumUnhealthyNMs," +
        "host_components/metrics/yarn/ClusterMetrics/NumRebootedNMs," +
        "host_components/metrics/yarn/ClusterMetrics/NumDecommissionedNMs"]
      },
      {
        title: 'HBASE service',
        services: [
          {
            ServiceInfo: {
              service_name: 'HBASE'
            }
          }
        ],
        result: ['metrics/1', "host_components/metrics/hbase/master/IsActiveMaster," +
        "host_components/metrics/hbase/master/MasterStartTime," +
        "host_components/metrics/hbase/master/MasterActiveTime," +
        "host_components/metrics/hbase/master/AverageLoad," +
        "host_components/metrics/master/AssignmentManger/ritCount"]
      },
      {
        title: 'STORM service',
        services: [
          {
            ServiceInfo: {
              service_name: 'STORM'
            }
          }
        ],
        result: ['metrics/1', "metrics/api/v1/cluster/summary," +
        "metrics/api/v1/topology/summary," +
        "metrics/api/v1/nimbus/summary"]
      }
    ];

    var testCasesByStackVersion = [
      {
        title: 'STORM service stack 2.1',
        services: [
          {
            ServiceInfo: {
              service_name: 'STORM'
            }
          }
        ],
        stackVersionNumber: '2.1',
        result: ['metrics/1', "metrics/api/cluster/summary"]
      },
      {
        title: 'STORM service stack 2.2',
        services: [
          {
            ServiceInfo: {
              service_name: 'STORM'
            }
          }
        ],
        stackVersionNumber: '2.2',
        result: ['metrics/1', "metrics/api/v1/cluster/summary,metrics/api/v1/topology/summary"]
      },
      {
        title: 'STORM service stack 2.3',
        services: [
          {
            ServiceInfo: {
              service_name: 'STORM'
            }
          }
        ],
        stackVersionNumber: '2.3',
        result: ['metrics/1', "metrics/api/v1/cluster/summary,metrics/api/v1/topology/summary,metrics/api/v1/nimbus/summary"]
      }
    ];

    beforeEach(function () {
      this.mock = sinon.stub(App, 'get');
      controller.set('serviceComponentMetrics', ['metrics/1']);
    });
    afterEach(function () {
      this.mock.restore();
    });
    testCases.forEach(function (test) {
      it(test.title, function () {
        App.cache.services = test.services;
        this.mock.withArgs('router.clusterController.isServiceMetricsLoaded').returns(true);
        expect(controller.getConditionalFields()).to.eql(test.result);
      });
    });

    testCasesByStackVersion.forEach(function (test) {
      it(test.title, function () {
        App.cache.services = test.services;
        this.mock.withArgs('currentStackVersionNumber').returns(test.stackVersionNumber);
        this.mock.withArgs('router.clusterController.isServiceMetricsLoaded').returns(true);
        expect(controller.getConditionalFields()).to.eql(test.result);
      });
    });

    it('FLUME service, first load', function () {
      App.cache.services = [
        {
          ServiceInfo: {
            service_name: 'FLUME'
          }
        }
      ];
      this.mock.withArgs('router.clusterController.isServiceMetricsLoaded').returns(false);
      expect(controller.getConditionalFields()).to.eql(["host_components/processes/HostComponentProcess"]);
    });
  });

  describe("#getComplexUrl()", function () {
    beforeEach(function () {
      sinon.stub(App, 'get').returns('mock');
      sinon.stub(controller, 'computeParameters').returns('params');
    });
    afterEach(function () {
      App.get.restore();
      controller.computeParameters.restore();
    });
    it("queryParams is empty", function () {
      expect(controller.getComplexUrl('<parameters>')).to.equal('mock/clusters/mock');
    });
    it("queryParams is present", function () {
      var queryParams = [
        {
          type: "EQUAL",
          key: "key",
          value: "value"
        }
      ];
      expect(controller.getComplexUrl('<parameters>', queryParams)).to.equal('mock/clusters/mockparams&');
    });
  });

  describe("#addParamsToHostsUrl()", function () {
    beforeEach(function () {
      sinon.stub(App, 'get').returns('mock');
      sinon.stub(controller, 'computeParameters').returns('params');
    });
    afterEach(function () {
      App.get.restore();
      controller.computeParameters.restore();
    });
    it("valid params are added", function () {
      expect(controller.addParamsToHostsUrl([], [], 'url')).to.equal('mock/clusters/mockurl&params&params');
    });
  });

  describe("#loadHostsMetric()", function () {
    beforeEach(function () {
      this.mock = sinon.stub(App.Service, 'find');
      sinon.stub(controller, 'computeParameters');
      sinon.stub(controller, 'addParamsToHostsUrl');
    });
    afterEach(function () {
      App.Service.find.restore();
      controller.computeParameters.restore();
      controller.addParamsToHostsUrl.restore();
    });
    it("AMBARI_METRICS is not started", function () {
      this.mock.returns(Em.Object.create({isStarted: false}));
      expect(controller.loadHostsMetric([])).to.be.null;
      var args = testHelpers.findAjaxRequest('name', 'hosts.metrics.lazy_load');
      expect(args).to.not.exists;
    });
    it("AMBARI_METRICS is started", function () {
      this.mock.returns(Em.Object.create({isStarted: true}));
      expect(controller.loadHostsMetric([])).to.be.object;
      var args = testHelpers.findAjaxRequest('name', 'hosts.metrics.lazy_load');
      expect(args).to.exists;
    });
  });

  describe("#loadHostsMetricSuccessCallback()", function () {
    beforeEach(function () {
      sinon.stub(App.hostsMapper, 'setMetrics');
    });
    afterEach(function () {
      App.hostsMapper.setMetrics.restore();
    });
    it("setMetrics called with valid arguments", function () {
      controller.loadHostsMetricSuccessCallback({});
      expect(App.hostsMapper.setMetrics.calledWith({})).to.be.true;
    });
  });

  describe('#updateUpgradeState()', function () {

    var cases = [
        {
          currentStateName: 'versions',
          parentStateName: 'stackAndUpgrade',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: true,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'stack versions page'
        },
        {
          currentStateName: 'stackUpgrade',
          parentStateName: 'admin',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: true,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'upgrade popup open'
        },
        {
          currentStateName: 'versions',
          parentStateName: 'admin',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 1,
          callbackCallCount: 0,
          title: 'another page with \'versions\' name'
        },
        {
          currentStateName: 'versions',
          parentStateName: 'admin',
          wizardIsNotFinished: false,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'another page with \'versions\' name, upgrade finished'
        },
        {
          currentStateName: 'versions',
          parentStateName: 'admin',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: true,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'another page with \'versions\' name, another update upgrade request not completed'
        },
        {
          currentStateName: 'services',
          parentStateName: 'stackAndUpgrade',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 1,
          callbackCallCount: 0,
          title: 'another page from \'Stack and Versions\' section'
        },
        {
          currentStateName: 'services',
          parentStateName: 'stackAndUpgrade',
          wizardIsNotFinished: false,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'another page from \'Stack and Versions\' section, upgrade finished'
        },
        {
          currentStateName: 'services',
          parentStateName: 'stackAndUpgrade',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: true,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'another page from \'Stack and Versions\' section, another update upgrade request not completed'
        },
        {
          currentStateName: 'widgets',
          parentStateName: 'dashboard',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 1,
          callbackCallCount: 0,
          title: 'not \'Stack and Versions\' section'
        },
        {
          currentStateName: 'widgets',
          parentStateName: 'dashboard',
          wizardIsNotFinished: false,
          isLoadUpgradeDataPending: false,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'not \'Stack and Versions\' section, upgrade finished'
        },
        {
          currentStateName: 'widgets',
          parentStateName: 'dashboard',
          wizardIsNotFinished: true,
          isLoadUpgradeDataPending: true,
          loadUpgradeDataCallCount: 0,
          callbackCallCount: 1,
          title: 'not \'Stack and Versions\' section, another update upgrade request not completed'
        }
      ],
      mock = {
        callback: Em.K,
        loadUpgradeData: function () {
          return {
            done: Em.K
          };
        }
      },
      appGetMock;

    beforeEach(function () {
      sinon.spy(mock, 'callback');
      sinon.spy(mock, 'loadUpgradeData');
      appGetMock = sinon.stub(App, 'get');
    });

    afterEach(function () {
      mock.callback.restore();
      mock.loadUpgradeData.restore();
      App.get.restore();
      appGetMock.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          appGetMock.withArgs('router.mainAdminStackAndUpgradeController').returns(Em.Object.create({
            loadUpgradeData: mock.loadUpgradeData,
            isLoadUpgradeDataPending: item.isLoadUpgradeDataPending
          })).withArgs('wizardIsNotFinished').returns(item.wizardIsNotFinished)
            .withArgs('router.currentState.name').returns(item.currentStateName)
            .withArgs('router.currentState.parentState.name').returns(item.parentStateName);
          controller.updateUpgradeState(mock.callback);
        });
        it('loadUpgradeData is called ' + item.loadUpgradeDataCallCount + ' times', function () {
          expect(mock.loadUpgradeData.callCount).to.equal(item.loadUpgradeDataCallCount);
        });
        it('callback is called ' + item.callbackCallCount + ' times', function () {
          expect(mock.callback.callCount).to.equal(item.callbackCallCount);
        });

      });
    });

  });

  describe('#computeParameters', function () {

    Em.A([
      {
        q: [{
          type: 'EQUAL',
          key: 'k',
          value: [1, 2]
        }],
        result: 'k.in(1,2)'
      },
      {
        q: [{
          type: 'MULTIPLE',
          key: 'k',
          value: [1, 2]
        }],
        result: 'k.in(1,2)'
      },
      {
        q: [{
          type: 'EQUAL',
          key: 'k',
          value: 1
        }],
        result: 'k=1'
      },
      {
        q: [
          {
            type: 'LESS',
            key: 'k',
            value: '1'
          }
        ],
        result: 'k<1'
      },
      {
        q: [
          {
            type: 'MORE',
            key: 'k',
            value: '1'
          }
        ],
        result: 'k>1'
      },
      {
        q: [
          {
            type: 'SORT',
            key: 'k',
            value: 'f'
          }
        ],
        result: 'sortBy=k.f'
      },
      {
        q: [
          {
            type: 'MATCH',
            key: 'k',
            value: 'abc'
          }
        ],
        result: 'k.matches(abc)'
      },
      {
        q: [
          {
            type: 'MATCH',
            key: 'k',
            value: ['a', 'b', 'c']
          }
        ],
        result: '(k.matches(a)|k.matches(b)|k.matches(c))'
      },
      {
        q: [
          {type: 'EQUAL', key: 'k1', value: [1,2]},
          {type: 'EQUAL', key: 'k2', value: 'abc'},
          {type: 'LESS', key: 'k3', value: 1},
          {type: 'MORE', key: 'k4', value: 1},
          {type: 'MATCH', key: 'k5', value: ['a', 'b', 'c']}
        ],
        result: 'k1.in(1,2)&k2=abc&k3<1&k4>1&(k5.matches(a)|k5.matches(b)|k5.matches(c))'
      }
    ]).forEach(function (test, index) {

      it('test#' + index, function () {
        var result = c.computeParameters(test.q);
        expect(result).to.be.equal(test.result);
      });

    });

  });

});

});

require.register("test/controllers/global/user_settings_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var userSettingsController;

describe('App.UserSettingsController', function () {

  beforeEach(function () {
    userSettingsController = App.UserSettingsController.create();
  });

  afterEach(function () {
    userSettingsController.destroy();
  });

  describe('#userSettingsKeys', function () {
    it('should not be empty', function () {
      expect(Object.keys(userSettingsController.get('userSettingsKeys'))).to.have.length.gt(0);
    });
  });

});
});

require.register("test/controllers/global/wizard_watcher_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/global/wizard_watcher_controller');

var controller;

describe('App.wizardWatcherController', function () {
  beforeEach(function() {
    controller = App.WizardWatcherController.create();
  });

  describe("#isWizardRunning", function() {
    it("wizardUser is null", function() {
      controller.set('wizardUser', null);
      controller.propertyDidChange('isWizardRunning');
      expect(controller.get('isWizardRunning')).to.be.false;
    });
    it("wizardUser is correct", function() {
      controller.set('wizardUser', 'admin');
      controller.propertyDidChange('isWizardRunning');
      expect(controller.get('isWizardRunning')).to.be.true;
    });
  });

  describe("#wizardDisplayName", function() {
    beforeEach(function () {
      sinon.stub(App.router, 'get').returns(Em.Object.create({displayName: 'Wizard'}));
    });
    afterEach(function () {
      App.router.get.restore();
    });
    it("controllerName is null", function() {
      controller.set('controllerName', null);
      controller.propertyDidChange('wizardDisplayName');
      expect(controller.get('wizardDisplayName')).to.be.empty;
    });
    it("controllerName is correct", function() {
      controller.set('controllerName', 'ctrl1');
      controller.propertyDidChange('wizardDisplayName');
      expect(controller.get('wizardDisplayName')).to.equal(Em.I18n.t('wizard.inProgress').format('Wizard'));
    });
  });


  describe("#isNonWizardUser", function() {
    beforeEach(function () {
      sinon.stub(App.router, 'get').returns('admin');
    });
    afterEach(function () {
      App.router.get.restore();
    });
    it("isWizardRunning is false", function() {
      controller.reopen({
        isWizardRunning: false
      });
      controller.propertyDidChange('isNonWizardUser');
      expect(controller.get('isNonWizardUser')).to.be.false;
    });
    it("isWizardRunning is true, wizardUser is admin", function() {
      controller.setProperties({
        isWizardRunning: true,
        wizardUser: 'admin'
      });
      controller.propertyDidChange('isNonWizardUser');
      expect(controller.get('isNonWizardUser')).to.be.false;
    });
    it("isWizardRunning is true, wizardUser is admin2", function() {
      controller.setProperties({
        isWizardRunning: true,
        wizardUser: 'admin2'
      });
      controller.propertyDidChange('isNonWizardUser');
      expect(controller.get('isNonWizardUser')).to.be.true;
    });
  });

  describe("#setUser()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'postUserPref', Em.K);
      sinon.stub(App.router, 'get').returns('admin');
    });
    afterEach(function () {
      controller.postUserPref.restore();
      App.router.get.restore();
    });
    it("post user pref", function() {
      controller.setUser('ctrl1');
      expect(controller.postUserPref.calledWith(controller.get('PREF_KEY'), {
        userName: 'admin',
        controllerName: 'ctrl1'
      })).to.be.true;
    });
  });

  describe("#resetUser()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'postUserPref', Em.K);
    });
    afterEach(function () {
      controller.postUserPref.restore();
    });
    it("post user pref", function() {
      controller.resetUser('ctrl1');
      expect(controller.postUserPref.calledWith(controller.get('PREF_KEY'), null)).to.be.true;
    });
  });

  describe("#getUser()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'getUserPref', Em.K);
    });
    afterEach(function () {
      controller.getUserPref.restore();
    });
    it("get user pref", function() {
      controller.getUser('ctrl1');
      expect(controller.getUserPref.calledWith(controller.get('PREF_KEY'))).to.be.true;
    });
  });

  describe("#getUserPrefSuccessCallback()", function() {
    it("data is null", function() {
      controller.getUserPrefSuccessCallback(null);
      expect(controller.get('wizardUser')).to.be.null;
      expect(controller.get('controllerName')).to.be.null;
    });
    it("data is correct", function() {
      controller.getUserPrefSuccessCallback({userName: 'admin', controllerName: 'ctrl1'});
      expect(controller.get('wizardUser')).to.equal('admin');
      expect(controller.get('controllerName')).to.equal('ctrl1');
    });
  });

  describe("#getUserPrefErrorCallback()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'resetUser', Em.K);
    });
    afterEach(function () {
      controller.resetUser.restore();
    });
    it("reset wizard-data", function() {
      controller.getUserPrefErrorCallback();
      expect(controller.resetUser.calledOnce).to.be.true;
    });
  });
});

});

require.register("test/controllers/installer_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('models/cluster');
require('controllers/wizard');
require('controllers/installer');

describe('App.InstallerController', function () {

  var installerController = App.InstallerController.create();

  after(function () {
    installerController.destroy();
  });

  describe('#init', function () {
    var c;
    beforeEach(function () {
      c = App.InstallerController.create({});
    });
    it('all steps are disabled by default', function () {
      expect(c.get('isStepDisabled.length')).to.be.above(0);
      expect(c.get('isStepDisabled').everyProperty('value', true)).to.be.ok;
    });
  });

  describe('#getCluster', function() {
    it ('Should return merged clusterStatusTemplate', function() {
      installerController.set('clusterStatusTemplate', {
        name: 'template'
      });
      expect(installerController.getCluster()).to.eql({
        name: 'template'
      });
    });
  });

  describe('#getHosts', function() {
    it ('Should return empty array', function() {
      expect(installerController.getHosts()).to.eql([]);
    });
  });

  describe('#loadServices', function() {
    it ('Should resolve nothing', function() {
      var res = installerController.loadServices();
      res.then(function(data){
        expect(data).to.be.undefined;
      });
    });
  });

  describe('#checkRepoURL', function() {
    var stacks = Em.A([
      Em.Object.create({
        isSelected: false
      }),
      Em.Object.create({
        isSelected: true,
        reload: false,
        id: 'nn-cc',
        stackNameVersion: 'nn-cc',
        repositories: Em.A([
          Em.Object.create({
            isSelected: true,
            isEmpty: false
          })
        ]),
        operatingSystems: Em.A([
          Em.Object.create({
            isSelected: true,
            isEmpty: false,
            repositories: Em.A([
              Em.Object.create({
                isEmpty: false,
                errorTitle: '1',
                errorContent: '1',
                validation: '',
                showRepo: true
              })
            ])
          })
        ])
      })
    ]);
    var wizard = Em.Object.create({
      skipValidationChecked: true
    });
    it ('Should reload installed stacks', function() {

      installerController.set('content.stacks', stacks);
      installerController.checkRepoURL(wizard);

      var expected = [
        {
          "isSelected": false
        },
        {
          "isSelected": true,
          "reload": true,
          "id": "nn-cc",
          "stackNameVersion": 'nn-cc',
          "repositories": [
            {
              "isSelected": true,
              "isEmpty": false
            }
          ],
          "operatingSystems": [
            {
              "isSelected": true,
              "isEmpty": false,
              "repositories": [
                {
                  "isEmpty": false,
                  "errorTitle": "",
                  "errorContent": "",
                  "validation": "icon-repeat",
                  "showRepo": true
                }
              ]
            }
          ]
        }
      ];

      var res = JSON.parse(JSON.stringify(installerController.get('content.stacks')));

      expect(res).to.be.eql(expected);
    });
  });

  describe('#checkRepoURLSuccessCallback', function() {
    var stacks = Em.A([
      Em.Object.create({
        isSelected: false
      }),
      Em.Object.create({
        isSelected: true,
        reload: false,
        id: 'nn-cc',
        repositories: Em.A([
          Em.Object.create({
            repoId: 11,
            isSelected: true,
            isEmpty: false
          })
        ]),
        operatingSystems: Em.A([
          Em.Object.create({
            isSelected: true,
            isEmpty: false,
            id: 1,
            repositories: Em.A([
              Em.Object.create({
                repoId: 11,
                isEmpty: false,
                errorTitle: '1',
                errorContent: '1',
                validation: '',
                showRepo: true
              })
            ])
          })
        ])
      })
    ]);
    var resolve = false;
    var data = {
      osId: 1,
      repoId: 11,
      dfd: {
        resolve: function() {
          resolve = true;
        }
      }
    };
    it ('Should check stacks for success', function() {

      installerController.set('content.stacks', stacks);
      installerController.checkRepoURLSuccessCallback(null,null,data);

      var expected = [
        {
          "isSelected": false
        },
        {
          "isSelected": true,
          "reload": false,
          "id": "nn-cc",
          "repositories": [
            {
              "repoId": 11,
              "isSelected": true,
              "isEmpty": false
            }
          ],
          "operatingSystems": [
            {
              "isSelected": true,
              "isEmpty": false,
              "id": 1,
              "repositories": [
                {
                  "repoId": 11,
                  "isEmpty": false,
                  "errorTitle": "1",
                  "errorContent": "1",
                  "validation": "icon-ok",
                  "showRepo": true
                }
              ]
            }
          ]
        }
      ];

      var res = JSON.parse(JSON.stringify(installerController.get('content.stacks')));
      expect(resolve).to.be.true;
      expect(res).to.be.eql(expected);
    });
  });

  describe('#checkRepoURLErrorCallback', function() {
    var stacks = Em.A([
      Em.Object.create({
        isSelected: false
      }),
      Em.Object.create({
        isSelected: true,
        reload: false,
        id: 'nn-cc',
        repositories: Em.A([
          Em.Object.create({
            repoId: 11,
            isSelected: true
          })
        ]),
        operatingSystems: Em.A([
          Em.Object.create({
            isSelected: true,
            id: 1,
            repositories: Em.A([
              Em.Object.create({
                repoId: 11,
                errorTitle: '1',
                errorContent: '1',
                validation: ''
              })
            ])
          })
        ])
      })
    ]);
    var resolve = false;
    var data = {
      osId: 1,
      repoId: 11,
      dfd: {
        reject: function() {
          resolve = true;
        }
      }
    };
    it ('Should check stacks for error', function() {

      var req = {
        status: 500,
        statusText: 'error'
      };
      installerController.set('content.stacks', stacks);
      installerController.checkRepoURLErrorCallback(req,{},{},{},data);

      var expected = [
        {
          "isSelected": false
        },
        {
          "isSelected": true,
          "reload": false,
          "id": "nn-cc",
          "repositories": [
            {
              "repoId": 11,
              "isSelected": true
            }
          ],
          "operatingSystems": [
            {
              "isSelected": true,
              "id": 1,
              "repositories": [
                {
                  "repoId": 11,
                  "errorTitle": "500:error",
                  "errorContent": "",
                  "validation": "icon-exclamation-sign"
                }
              ]
            }
          ]
        }
      ];

      var res = JSON.parse(JSON.stringify(installerController.get('content.stacks')));
      expect(resolve).to.be.true;
      expect(res).to.be.eql(expected);
    });
  });

  describe('#setLowerStepsDisable', function() {

    beforeEach(function () {
      var steps = Em.A([
        Em.Object.create({
          step: 0,
          value: false
        }),
        Em.Object.create({
          step: 1,
          value: false
        }),
        Em.Object.create({
          step: 2,
          value: false
        }),
        Em.Object.create({
          step: 3,
          value: false
        }),
        Em.Object.create({
          step: 4,
          value: false
        })
      ]);
      installerController.set('isStepDisabled', steps);
      installerController.setLowerStepsDisable(3);
    });

    it ('Should disable lower steps', function() {
      var expected = [
        {
          "step": 0,
          "value": true
        },
        {
          "step": 1,
          "value": true
        },
        {
          "step": 2,
          "value": true
        },
        {
          "step": 3,
          "value": false
        },
        {
          "step": 4,
          "value": false
        }
      ];
      var res = JSON.parse(JSON.stringify(installerController.get('isStepDisabled')));
      expect(res).to.eql(expected);
    });
  });

  describe('#setStepsEnable', function() {

    beforeEach(function () {
      var steps = Em.A([
        Em.Object.create({
          step: 0,
          value: false
        }),
        Em.Object.create({
          step: 1,
          value: false
        }),
        Em.Object.create({
          step: 2,
          value: false
        }),
        Em.Object.create({
          step: 3,
          value: false
        }),
        Em.Object.create({
          step: 4,
          value: false
        })
      ]);
      installerController.set('isStepDisabled', steps);
      installerController.totalSteps = steps.length - 1;
      installerController.set('currentStep',2);
    });

    it ('Should enable next steps', function() {
      var expected = [
        {
          "step": 0,
          "value": false
        },
        {
          "step": 1,
          "value": true
        },
        {
          "step": 2,
          "value": true
        },
        {
          "step": 3,
          "value": true
        },
        {
          "step": 4,
          "value": true
        }
      ];
      var res = JSON.parse(JSON.stringify(installerController.get('isStepDisabled')));
      expect(res).to.eql(expected);
    });
  });

  describe('#loadMap', function() {

    describe('Should load cluster', function() {
      var loadCluster = false;
      var checker = {
        load: function() {
          loadCluster = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['0'][0].callback.call(checker);
      });

      it('cluster info is loaded', function () {
        expect(loadCluster).to.be.true;
      });
    });

    describe('Should load stacks', function() {
      var loadStacks = false;
      var checker = {
        loadStacks: function() {
          return {
            always: function() {
              loadStacks = true;
            }
          };
        }
      };

      beforeEach(function () {
        installerController.loadMap['1'][0].callback.call(checker);
      });

      it('stack info is loaded', function () {
        expect(loadStacks).to.be.true;
      });
    });

    describe ('Should load stacks async', function() {
      var loadStacksVersions = false;
      var checker = {
        loadStacksVersions: function() {
          loadStacksVersions = true;
        }
      };

      it('stack versions are loaded', function () {
        installerController.loadMap['1'][1].callback.call(checker, true).then(function(data){
          expect(data).to.be.true;
        });
        expect(loadStacksVersions).to.be.false;
      });
    });

    describe('Should load installOptions', function() {
      var installOptions = false;
      var checker = {
        load: function() {
          installOptions = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['2'][0].callback.call(checker);
      });

      it('install option are loaded', function () {
        expect(installOptions).to.be.true;
      });
    });

    describe('Should load loadConfirmedHosts', function() {
      var loadConfirmedHosts = false;
      var checker = {
        loadConfirmedHosts: function() {
          loadConfirmedHosts = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['3'][0].callback.call(checker);
      });

      it('confirmed hosts are loaded', function () {
        expect(loadConfirmedHosts).to.be.true;
      });
    });

    describe('Should load loadServices', function() {
      var loadServices = false;
      var checker = {
        loadServices: function() {
          loadServices = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['4'][0].callback.call(checker);
      });

      it('services are loaded', function () {
        expect(loadServices).to.be.true;
      });
    });

    describe('Should load loadServices (2)', function() {
      var setSkipSlavesStep = false;
      var loadMasterComponentHosts = false;
      var loadConfirmedHosts = false;
      var loadComponentsFromConfigs = false;
      var loadRecommendations = false;

      var checker = {
        setSkipSlavesStep: function() {
          setSkipSlavesStep = true;
        },
        loadMasterComponentHosts: function() {
          loadMasterComponentHosts = true;
        },
        loadConfirmedHosts: function() {
          loadConfirmedHosts = true;
        },
        loadComponentsFromConfigs: function() {
          loadComponentsFromConfigs = true;
        },
        loadRecommendations: function() {
          loadRecommendations = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['5'][0].callback.call(checker);
      });

      it('confirmed hosts are loaded', function() {
        expect(loadConfirmedHosts).to.be.true;
      });

      it('`skipSlavesStep` is loaded', function() {
        expect(setSkipSlavesStep).to.be.true;
      });

      it('master components hosts are loaded', function() {
        expect(loadMasterComponentHosts).to.be.true;
      });

      it('components added via configs are loaded', function () {
        expect(loadComponentsFromConfigs).to.be.true;
      });

      it('recommendations are loaded', function() {
        expect(loadRecommendations).to.be.true;
      });

    });

    describe ('Should load serviceConfigGroups', function() {
      var loadServiceConfigGroups = false;
      var loadServiceConfigProperties = false;
      var loadCurrentHostGroups = false;
      var loadRecommendationsConfigs = false;
      var loadComponentsFromConfigs = false;
      var loadConfigThemes = false;

      var checker = {
        loadServiceConfigGroups: function() {
          loadServiceConfigGroups = true;
        },
        loadServiceConfigProperties: function() {
          loadServiceConfigProperties = true;
          return $.Deferred().resolve().promise();
        },
        loadCurrentHostGroups: function() {
          loadCurrentHostGroups = true;
        },
        loadRecommendationsConfigs: function() {
          loadRecommendationsConfigs = true;
        },
        loadComponentsFromConfigs: function() {
          loadComponentsFromConfigs = true;
        },
        loadConfigThemes: function() {
          loadConfigThemes = true;
          return $.Deferred().resolve().promise();
        }
      };

      beforeEach(function () {
        installerController.loadMap['7'][0].callback.call(checker);
      });

      it('config groups are loaded', function () {
        expect(loadServiceConfigGroups).to.be.true;
      });

      it('config properties are loaded', function () {
        expect(loadServiceConfigProperties).to.be.true;
      });

      it('current host groups are loaded', function () {
        expect(loadCurrentHostGroups).to.be.true;
      });

      it('recommendations are loaded', function () {
        expect(loadRecommendationsConfigs).to.be.true;
      });

      it('components added via configs are loaded', function () {
        expect(loadComponentsFromConfigs).to.be.true;
      });

      it('config themes are loaded', function () {
        expect(loadConfigThemes).to.be.true;
      });

    });

    describe('Should load clients', function() {
      var loadSlaveComponentHosts = false;
      var loadClients = false;
      var loadRecommendations = false;
      var loadComponentsFromConfigs = false;

      var checker = {
        loadSlaveComponentHosts: function() {
          loadSlaveComponentHosts = true;
        },
        loadClients: function() {
          loadClients = true;
        },
        loadComponentsFromConfigs: function() {
          loadComponentsFromConfigs = true;
        },
        loadRecommendations: function() {
          loadRecommendations = true;
        }
      };

      beforeEach(function () {
        installerController.loadMap['6'][0].callback.call(checker);
      });

      it('slave components hosts are loaded', function () {
        expect(loadSlaveComponentHosts).to.be.true;
      });

      it('clients are loaded', function () {
        expect(loadClients).to.be.true;
      });

      it('components added via configs are loaded', function () {
        expect(loadComponentsFromConfigs).to.be.true;
      });

      it('recommendations are loaded', function () {
        expect(loadRecommendations).to.be.true;
      });

    });

  });

  describe('#removeHosts', function() {
    var hostsDb = {
      'h1': {},
      'h2': {},
      'h3': {},
      'h4': {}
    };
    beforeEach(function () {
      sinon.stub(installerController, 'getDBProperty').returns(hostsDb);
    });
    afterEach(function () {
      installerController.getDBProperty.restore();
    });
    it ('Should remove hosts from the list', function() {
      var hosts = Em.A([
        {
          name: 'h1'
        },
        {
          name: 'h2'
        },
        {
          name: 'h3'
        }
      ]);
      installerController.removeHosts(hosts);
      expect(hostsDb).to.eql({
        'h4': {}
      });
    });
  });

  describe('#allHosts', function() {
    it ('Should return hosts', function() {
      var hosts = {
        'h1': {
          hostComponents: Em.A([])
        }
      };
      var masterComponentHosts = Em.A([
        {
          hostName: 'h1',
          component: 'component',
          display_name: 'n1'
        }
      ]);
      var slaveComponentHosts = Em.A([
        {
          hosts: Em.A([
          {
            hostName: 'h1'
          }
          ])
        }
      ]);
      installerController.set('content.hosts', hosts);
      installerController.set('content.masterComponentHosts', masterComponentHosts);
      installerController.set('content.slaveComponentHosts', slaveComponentHosts);
      var res = JSON.parse(JSON.stringify(installerController.get('allHosts')));
      expect(res).to.eql([
        {
          "hostComponents": [
            {
              "componentName": "component",
              "displayName": "n1"
            },
            {}
          ]
        }
      ]);
    });
  });

  describe('#loadServiceConfigProperties', function() {
    beforeEach(function () {
      sinon.stub(installerController, 'getPersistentProperty').returns($.Deferred().resolve({
        value: 2
      }).promise());
    });
    afterEach(function () {
      installerController.getPersistentProperty.restore();
    });
    it ('Should load service config property', function() {
      installerController.loadServiceConfigProperties();
      expect(installerController.get('content.serviceConfigProperties')).to.eql({
        "value": 2
      });
    });
  });

  describe('#saveServices', function() {
    it ('Should return correct names', function() {
      var stepController = Em.A([
        Em.Object.create({
          isInstalled: true,
          isSelected: true,
          serviceName: 'i1'
        }),
        Em.Object.create({
          isInstalled: false,
          isSelected: true,
          serviceName: 'i2'
        }),
        Em.Object.create({
          isInstalled: true,
          isSelected: false,
          serviceName: 'i3'
        })
      ]);
      installerController.saveServices(stepController);
      expect(installerController.get('content.selectedServiceNames')).to.eql(['i1','i2']);
      expect(installerController.get('content.installedServiceNames')).to.eql(['i1','i3']);
    });
  });

  describe('#saveClients', function() {
    var stepController;

    beforeEach(function () {
      stepController = Em.Object.create({
        content: Em.A([
          Em.Object.create({
            isInstalled: true,
            isSelected: true,
            serviceName: 'i1',
            serviceComponents: Em.A([
              Em.Object.create({
                isClient: true,
                componentName: 'name',
                displayName: 'dname'
              })
            ])
          }),
          Em.Object.create({
            isInstalled: false,
            isSelected: true,
            serviceName: 'i2',
            serviceComponents: Em.A([
              Em.Object.create({
                isClient: false
              })
            ])
          }),
          Em.Object.create({
            isInstalled: true,
            isSelected: false,
            serviceName: 'i3',
            serviceComponents: Em.A([
              Em.Object.create({
                isClient: false
              })
            ])
          })
        ])
      });
    });
    it ('Should return correct clients names', function() {
      installerController.saveClients(stepController);
      var res = JSON.parse(JSON.stringify(installerController.get('content.clients')));
      expect(res).to.eql([
        {
          "component_name": "name",
          "display_name": "dname",
          "isInstalled": false
        }
      ]);
    });
  });

  describe('#saveMasterComponentHosts', function() {
    beforeEach(function () {
      sinon.stub(installerController, 'getDBProperty').returns({
        'h1': {
          id: 11
        },
        'h3': {
          id: 13
        },
        'h2': {
          id: 12
        }
      });
    });
    afterEach(function () {
      installerController.getDBProperty.restore();
    });
    it ('Should return hosts', function() {
      var stepController = Em.Object.create({
        selectedServicesMasters: Em.A([
          Em.Object.create({
            display_name: 'n1',
            component_name: 'c1',
            serviceId: 1,
            selectedHost: 'h1'
          })
        ])
      });
      installerController.saveMasterComponentHosts(stepController);
      expect(installerController.get('content.masterComponentHosts')).to.eql([
        {
          "display_name": "n1",
          "component": "c1",
          "serviceId": 1,
          "isInstalled": false,
          "host_id": 11
        }
      ]);
    });
  });

  describe('#loadConfirmedHosts', function() {
    beforeEach(function () {
      sinon.stub(installerController, 'getDBProperty').returns({
        'h1': {
          id: 11
        },
        'h3': {
          id: 13
        },
        'h2': {
          id: 12
        }
      });
    });
    afterEach(function () {
      installerController.getDBProperty.restore();
    });
    it ('Should load hosts from db', function() {
      installerController.loadConfirmedHosts();
      expect(installerController.get('content.hosts')).to.eql({
        'h1': {
          id: 11
        },
        'h3': {
          id: 13
        },
        'h2': {
          id: 12
        }
      });
    });
  });

  describe('#loadMasterComponentHosts', function() {
    beforeEach(function () {
      sinon.stub(installerController, 'getDBProperties', function() {
        return {
          masterComponentHosts: Em.A([
            {
              hostName: '',
              host_id: 11
            }
          ]),
          hosts: {
            'h1': {
              id: 11
            },
            'h3': {
              id: 13
            },
            'h2': {
              id: 12
            }
          }
        }
      });
    });
    afterEach(function () {
      installerController.getDBProperties.restore();
    });
    it ('Should load hosts', function() {
      installerController.loadMasterComponentHosts();
      expect(installerController.get('content.masterComponentHosts')).to.eql([
        {
          "hostName": "h1",
          "host_id": 11
        }
      ]);
    });
  });

  describe('#loadSlaveComponentHosts', function() {
    beforeEach(function () {
      sinon.stub(installerController, 'getDBProperties', function() {
        return {
          hosts: {
            'h1': {
              id: 11
            },
            'h3': {
              id: 13
            },
            'h2': {
              id: 12
            }
          },
          slaveComponentHosts: Em.A([
            {
              hosts: Em.A([
                {
                  hostName: '',
                  host_id: 11
                }
              ])
            }
          ])
        };
      });
    });
    afterEach(function () {
      installerController.getDBProperties.restore();
    });
    it ('Should load slave hosts', function() {
      installerController.loadSlaveComponentHosts();
      expect(installerController.get('content.slaveComponentHosts')).to.eql([
        {
          "hosts": [
            {
              "hostName": "h1",
              "host_id": 11
            }
          ]
        }
      ]);
    });
  });

  describe('#getServerVersionSuccessCallback', function () {

    var cases = [
        {
          osFamily: 'redhat5',
          expected: false
        },
        {
          osFamily: 'redhat6',
          expected: true
        },
        {
          osFamily: 'suse11',
          expected: false
        }
      ],
      title = 'App.isManagedMySQLForHiveEnabled should be {0} for {1}';

    cases.forEach(function (item) {
      it(title.format(item.expected, item.osFamily), function () {
        installerController.getServerVersionSuccessCallback({
          'RootServiceComponents': {
            'component_version': '',
            'properties': {
              'server.os_family': item.osFamily
            }
          }
        });
        expect(App.get('isManagedMySQLForHiveEnabled')).to.equal(item.expected);
      });
    });

  });

  describe('#validateJDKVersion', function() {
    var tests = [
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.8'
        },
        successCallbackCalled: false,
        popupCalled: true,
        stacks: [Em.Object.create({
          minJdkVersion: '1.6',
          maxJdkVersion: '1.7',
          isSelected: true
        })],
        m: 'JDK 1.8, stack supports 1.6-1.7 popup should be displayed'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.8'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          minJdkVersion: '1.6',
          maxJdkVersion: '1.8',
          isSelected: true
        })],
        m: 'JDK 1.8, stack supports 1.7-1.8 procceed installation without warning'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.5'
        },
        successCallbackCalled: false,
        popupCalled: true,
        stacks: [Em.Object.create({
          minJdkVersion: '1.6',
          maxJdkVersion: '1.8',
          isSelected: true
        })],
        m: 'JDK 1.5, stack supports 1.6-1.8, popup should be displayed'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.5'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          minJdkVersion: null,
          maxJdkVersion: null,
          isSelected: true
        })],
        m: 'JDK 1.5, stack supports max and min are null, procceed installation without warning'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.5'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          minJdkVersion: '1.5',
          maxJdkVersion: null,
          isSelected: true
        })],
        m: 'JDK 1.5, stack supports max is missed and min is 1.5, procceed installation without warning'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.6'
        },
        successCallbackCalled: false,
        popupCalled: true,
        stacks: [Em.Object.create({
          minJdkVersion: '1.5',
          maxJdkVersion: null,
          isSelected: true
        })],
        m: 'JDK 1.6, stack supports max is missed and min is 1.5, popup should be displayed'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.5'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          minJdkVersion: null,
          maxJdkVersion: '1.5',
          isSelected: true
        })],
        m: 'JDK 1.5, stack supports max 1.5 and min is missed, procceed installation without warning'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.5'
        },
        successCallbackCalled: false,
        popupCalled: true,
        stacks: [Em.Object.create({
          minJdkVersion: null,
          maxJdkVersion: '1.8',
          isSelected: true
        })],
        m: 'JDK 1.5, stack supports max 1.8 and min is missed, popup should be displayed'
      },
      {
        isCustomJDK: false,
        ambariProperties: {
          'java.version': '1.8'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          isSelected: true
        })],
        m: 'JDK 1.8, min, max jdk missed in stack definition, procceed installation without warning'
      },
      {
        isCustomJDK: true,
        ambariProperties: {
          'java.version': '1.8'
        },
        successCallbackCalled: true,
        popupCalled: false,
        stacks: [Em.Object.create({
          minJdkVersion: '1.6',
          maxJdkVersion: '1.8',
          isSelected: true
        })],
        m: 'JDK 1.8, custom jdk location used, procceed installation without warning'
      }
    ];

    tests.forEach(function(test) {

      describe(test.m, function() {

        var successCallback;

        beforeEach(function () {
          sinon.stub(App.Stack, 'find').returns(test.stacks);
          sinon.stub(App.router, 'get').withArgs('clusterController.isCustomJDK').returns(test.isCustomJDK)
            .withArgs('clusterController.ambariProperties').returns(test.ambariProperties);
          sinon.stub(App, 'showConfirmationPopup', Em.K);
          successCallback = sinon.spy();
          installerController.validateJDKVersion(successCallback);
        });

        afterEach(function () {
          App.router.get.restore();
          App.Stack.find.restore();
          App.showConfirmationPopup.restore();
        });

        it('successCallback is ' + (test.successCallbackCalled ? '' : 'not') + ' called', function () {
          expect(successCallback.called).to.be.equal(test.successCallbackCalled);
        });

        it('App.showConfirmationPopup. is ' + (test.popupCalled ? '' : 'not') + ' called', function () {
          expect(App.showConfirmationPopup.called).to.be.equal(test.popupCalled);
        });

      });
    });
  });

  describe('#postVersionDefinitionFileErrorCallback', function () {

    beforeEach(function () {
      sinon.stub(App, 'showAlertPopup', Em.K);
    });

    afterEach(function () {
      App.showAlertPopup.restore();
    });

    it('should delete VDF-data', function () {
      App.db.setLocalRepoVDFData({});
      expect(App.db.getLocalRepoVDFData()).to.not.be.an.object;
      installerController.postVersionDefinitionFileErrorCallback({}, {}, {}, {}, {dfd: $.Deferred()});
      expect(App.db.getLocalRepoVDFData()).to.be.undefined;
    });

  });

});

});

require.register("test/controllers/login_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('models/cluster');
require('controllers/wizard');
require('controllers/installer');

describe('App.LoginController', function () {

  var loginController = App.LoginController.create();

  describe('#postLogin', function() {
    it ('Should set error connect', function() {
      loginController.postLogin(false, false, null);
      expect(loginController.get('errorMessage')).to.be.equal(Em.I18n.t('login.error.bad.connection'));
    });
    it ('Should set error connect with specific message', function() {
      loginController.postLogin(false, false, 'specific message');
      expect(loginController.get('errorMessage')).to.be.equal('specific message');
    });
    it ('Should set error user is disabled', function() {
      loginController.postLogin(true, false, 'User is disabled');
      expect(loginController.get('errorMessage')).to.be.equal(Em.I18n.t('login.error.disabled'));
    });
    it ('Should set bad credentials error', function() {
      loginController.postLogin(true, false, 'Authentication required');
      expect(loginController.get('errorMessage')).to.be.equal(Em.I18n.t('login.error.bad.credentials'));
    });
    it ('Should set bad credentials error, empty response', function() {
      loginController.postLogin(true, false, null);
      expect(loginController.get('errorMessage')).to.be.equal(Em.I18n.t('login.error.bad.credentials'));
    });
    it ('Should set custom error', function() {
      loginController.postLogin(true, false, 'Login Failed: Please append your domain to your username and try again.  Example: user_dup@domain');
      expect(loginController.get('errorMessage')).to.be.equal('Login Failed: Please append your domain to your username and try again.  Example: user_dup@domain');
    });
  });

});

});

require.register("test/controllers/main/admin/highAvailability/hawq/activateStandby/step2_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/admin/highAvailability/hawq/activateStandby/step2_controller');

describe('App.ActivateHawqStandbyWizardStep2Controller', function () {

  describe('#isSubmitDisabled', function () {

    var controller = App.ActivateHawqStandbyWizardStep2Controller.create({
        content: Em.Object.create({})
      }),
      cases = [
        {
          isLoaded: false,
          isSubmitDisabled: true,
          title: 'wizard step content not loaded'
        },
        {
          isLoaded: true,
          isSubmitDisabled: false,
          title: 'wizard step content loaded'
        }
      ];

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.set('isLoaded', item.isLoaded);
        expect(controller.get('isSubmitDisabled')).to.equal(item.isSubmitDisabled);
      });
    });

  });


  describe('#setDynamicConfigValues', function () {

    var controller = App.ActivateHawqStandbyWizardStep2Controller.create({
        content: Em.Object.create({
          masterComponentHosts: [
            {component: 'HAWQMASTER', hostName: 'h0', isInstalled: true},
            {component: 'HAWQSTANDBY', hostName: 'h1', isInstalled: true}
          ],
          hawqHost: {
            hawqMaster: 'h0',
            hawqStandby: 'h1'
          }
        })
      }),
      configs = {
        configs: [
          Em.Object.create({
            name: 'hawq_master_address_host'
          })
        ]
      };


    beforeEach(function () {
      controller.setDynamicConfigValues(configs);
    });

    it('hawq_master_address_host value', function () {
      expect(configs.configs.findProperty('name', 'hawq_master_address_host').get('value')).to.equal('h1');
    });
    it('hawq_master_address_host recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'hawq_master_address_host').get('recommendedValue')).to.equal('h1');
    });
  });

});

});

require.register("test/controllers/main/admin/highAvailability/hawq/addStandby/step3_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/admin/highAvailability/hawq/addStandby/step3_controller');
var testHelpers = require('test/helpers');

function getController() {
  return App.AddHawqStandbyWizardStep3Controller.create({
    content: Em.Object.create({})
  });
}
var controller;

describe('App.AddHawqStandbyWizardStep3Controller', function () {

  beforeEach(function () {
    controller = getController();
  });

  describe('#isSubmitDisabled', function () {

    var cases = [
        {
          isLoaded: false,
          isSubmitDisabled: true,
          title: 'wizard step content not loaded'
        },
        {
          isLoaded: true,
          isSubmitDisabled: false,
          title: 'wizard step content loaded'
        }
      ];

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.set('isLoaded', item.isLoaded);
        expect(controller.get('isSubmitDisabled')).to.equal(item.isSubmitDisabled);
      });
    });

  });

  describe('#loadConfigTagsSuccessCallback', function () {

    it('should send proper ajax request', function () {
      controller.loadConfigTagsSuccessCallback({
        'Clusters': {
          'desired_configs': {
            'hawq-site': {
              'tag': 1
            }
          }
        }
      }, {}, {
        'serviceConfig': {}
      });
      var data = testHelpers.findAjaxRequest('name', 'reassign.load_configs')[0].data;
      expect(data.urlParams).to.equal('(type=hawq-site&tag=1)');
      expect(data.serviceConfig).to.eql({});
    });

  });

  describe('#loadConfigsSuccessCallback', function () {

    var cases = [
        {
          'title': 'should set properties from load config success callback',
          'items': [
            {
              'type': 'hawq-site',
              'properties': {
                'hawq_master_address_host' : 'h0'
              }
            }
          ],
          'params': {
            'serviceConfig': {}
          }
        }
      ];

    beforeEach(function () {
      sinon.stub(controller, 'setDynamicConfigValues', Em.K);
    });

    afterEach(function () {
      controller.setDynamicConfigValues.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.loadConfigsSuccessCallback({
          items: item.items
        }, {}, item.params);
        expect(controller.get('selectedService')).to.eql({});
        expect(controller.get('isLoaded')).to.be.true;
      });
    });

  });

  describe('#loadConfigsSuccessCallback=loadConfigsErrorCallback(we have one callback for both cases)', function () {

    beforeEach(function () {
      sinon.stub(controller, 'setDynamicConfigValues', Em.K);
    });

    afterEach(function () {
      controller.setDynamicConfigValues.restore();
    });

    it('should proceed with default value', function () {
      controller.loadConfigsSuccessCallback({}, {}, {});
      expect(controller.get('selectedService')).to.eql({});
      expect(controller.get('isLoaded')).to.be.true;
    });

  });

  describe('#setDynamicConfigValues', function () {

    var data = {
      items: [
        {
          type: 'hawq-site',
          properties: {
           hawq_master_address_host : 'h0'
          }
        }
      ]
    };

    var configs = {
      configs: [
        Em.Object.create({
          name: 'hawq_standby_address_host'
        })
      ]
    };


    beforeEach(function () {
      controller = App.AddHawqStandbyWizardStep3Controller.create({
        content: Em.Object.create({
          masterComponentHosts: [
            {component: 'HAWQMASTER', hostName: 'h0', isInstalled: true},
            {component: 'HAWQSTANDBY', hostName: 'h1', isInstalled: false}
          ],
          slaveComponentHosts: [],
          hosts: {},
          hawqHost: {
            hawqMaster: 'h0',
            newHawqStandby: 'h1'
          }
        })
      });
      controller.setDynamicConfigValues(configs, data);
    });

    it('hawq_standby_address_host value', function () {
      expect(configs.configs.findProperty('name', 'hawq_standby_address_host').get('value')).to.equal('h1');
    });
    it('hawq_standby_address_host recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'hawq_standby_address_host').get('recommendedValue')).to.equal('h1');
    });
  });

});

});

require.register("test/controllers/main/admin/highAvailability/hawq/removeStandby/step2_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/admin/highAvailability/hawq/removeStandby/step2_controller');

describe('App.RemoveHawqStandbyWizardStep2Controller', function () {

  describe('#isSubmitDisabled', function () {

    var controller = App.RemoveHawqStandbyWizardStep2Controller.create({
        content: Em.Object.create({})
      }),
      cases = [
        {
          isLoaded: false,
          isSubmitDisabled: true,
          title: 'wizard step content not loaded'
        },
        {
          isLoaded: true,
          isSubmitDisabled: false,
          title: 'wizard step content loaded'
        }
      ];

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.set('isLoaded', item.isLoaded);
        expect(controller.get('isSubmitDisabled')).to.equal(item.isSubmitDisabled);
      });
    });

  });


});

});

require.register("test/controllers/main/admin/highAvailability/nameNode/step2_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

function O (fl) {
  return Em.Object.create({
    isInstalled: fl
  })
}

describe('App.HighAvailabilityWizardStep2Controller', function () {
  var controller = App.HighAvailabilityWizardStep2Controller.create();

  describe('#sortMasterComponents', function () {

    it('should sort installed masters first', function() {
      var init = [O(true), O(false), O(true), O(false), O(true)];
      var sorted = [O(true), O(true), O(true), O(false), O(false)];
      expect(controller.sortMasterComponents(init)).to.eql(sorted);
    });
  });

});
});

require.register("test/controllers/main/admin/highAvailability/nameNode/step3_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

var testHelpers = require('test/helpers');
var controller;

describe('App.HighAvailabilityWizardStep3Controller', function() {

  var serverConfigData = {
    items: [
      {
        type: 'hdfs-site',
        properties: {
          'dfs.namenode.http-address': 'h1:1234',
          'dfs.namenode.https-address': 'h1:4321',
          'dfs.namenode.rpc-address': 'h1:1111',
          'dfs.journalnode.edits.dir': '/hadoop/hdfs/journalnode123'
        }
      },
      {
        type: 'zoo.cfg',
        properties: {
          clientPort: '4444'
        }
      },
      {
        type: 'hbase-site',
        properties: {
          'hbase.rootdir': 'hdfs://h34:8020/apps/hbase/data'
        }
      },
      {
        type: 'ams-hbase-site',
        properties: {
          'hbase.rootdir': 'hdfs://h1:8020/user/ams/hbase'
        }
      },
      {
        type: 'accumulo-site',
        properties: {
          'instance.volumes': 'hdfs://localhost:8020/apps/accumulo/data'
        }
      },
      {
        type: 'hawq-site',
        properties: {
          'hawq_dfs_url': 'localhost:8020/hawq_data'
        }
      },
      {
        type: 'ranger-env',
        properties: {
          'xasecure.audit.destination.hdfs.dir': 'hdfs://c6401.ambari.apache.org/ranger/audit'
        }
      }
    ]
  };

  beforeEach(function () {
    controller = App.HighAvailabilityWizardStep3Controller.create();
    controller.set('serverConfigData', serverConfigData);
  });

  afterEach(function () {
    controller.destroy();
  });

  describe('#removeConfigs', function() {

    var tests = [
      {
        m: 'should not delete properties if configsToRemove is empty',
        configs: {
          items: [
            {
              type: 'site1',
              properties: {
                property1: 'value1',
                property2: 'value2',
                property3: 'value3',
                property4: 'value4'
              }
            }
          ]
        },
        toRemove: {},
        expected: {
          items: [
            {
              type: 'site1',
              properties: {
                property1: 'value1',
                property2: 'value2',
                property3: 'value3',
                property4: 'value4'
              }
            }
          ]
        }
      },
      {
        m: 'should delete properties from configsToRemove',
        configs: {
          items: [
            {
              type: 'site1',
              properties: {
                property1: 'value1',
                property2: 'value2',
                property3: 'value3',
                property4: 'value4'
              }
            }
          ]
        },
        toRemove: {
          'site1': ['property1', 'property3']
        },
        expected: {
          items: [
            {
              type: 'site1',
              properties: {
                property2: 'value2',
                property4: 'value4'
              }
            }
          ]
        }
      },
      {
        m: 'should delete properties from configsToRemove from different sites',
        configs: {
          items: [
            {
              type: 'site1',
              properties: {
                property1: 'value1',
                property2: 'value2',
                property3: 'value3',
                property4: 'value4'
              }
            },
            {
              type: 'site2',
              properties: {
                property1: 'value1',
                property2: 'value2',
                property3: 'value3',
                property4: 'value4'
              }
            }
          ]
        },
        toRemove: {
          'site1': ['property1', 'property3'],
          'site2': ['property2', 'property4']
        },
        expected: {
          items: [
            {
              type: 'site1',
              properties: {
                property2: 'value2',
                property4: 'value4'
              }
            },
            {
              type: 'site2',
              properties: {
                property1: 'value1',
                property3: 'value3'
              }
            }
          ]
        }
      }
    ];

    tests.forEach(function(test) {
      it(test.m, function() {
        var _controller = App.HighAvailabilityWizardStep3Controller.create({
          configsToRemove: test.toRemove,
          serverConfigData: test.configs
        });
        var result = _controller.removeConfigs(test.toRemove, _controller.get('serverConfigData'));
        expect(JSON.stringify(_controller.get('serverConfigData'))).to.equal(JSON.stringify(test.expected));
        expect(JSON.stringify(result)).to.equal(JSON.stringify(test.expected));
      });
    });
  });

  describe('#tweakServiceConfigs', function () {

    var nameServiceId = 'tdk';

    var masterComponentHosts = [
      {component: 'NAMENODE', isInstalled: true, hostName: 'h1'},
      {component: 'NAMENODE', isInstalled: false, hostName: 'h2'},
      {component: 'RANGER_ADMIN', isInstalled: true, hostName: 'h1'},
      {component: 'JOURNALNODE', hostName: 'h1'},
      {component: 'JOURNALNODE', hostName: 'h2'},
      {component: 'JOURNALNODE', hostName: 'h3'},
      {component: 'ZOOKEEPER_SERVER', hostName: 'h1'},
      {component: 'ZOOKEEPER_SERVER', hostName: 'h2'},
      {component: 'ZOOKEEPER_SERVER', hostName: 'h3'}
    ];

    beforeEach(function () {
      controller.set('content', Em.Object.create({
        masterComponentHosts: masterComponentHosts,
        slaveComponentHosts: [],
        hosts: {},
        nameServiceId: nameServiceId
      }));
      var get = sinon.stub(App, 'get');
      get.withArgs('isHadoopWindowsStack').returns(true);
      sinon.stub(App.Service, 'find', function () {
        return [{serviceName: 'HDFS'}, {serviceName: 'HBASE'}, {serviceName: 'AMBARI_METRICS'}, {serviceName: 'ACCUMULO'}, {serviceName: 'HAWQ'}, {serviceName: 'RANGER'}]
      });
    });

    afterEach(function () {
      App.Service.find.restore();
      App.get.restore();
    });

    Em.A([
      {
        config: {
          name: 'dfs.namenode.rpc-address.${dfs.nameservices}.nn1',
          filename: 'hdfs-site'
        },
        value: 'h1:1111',
        name: 'dfs.namenode.rpc-address.' + nameServiceId + '.nn1'
      },
      {
        config: {
          name: 'dfs.namenode.rpc-address.${dfs.nameservices}.nn2',
          filename: 'hdfs-site'
        },
        value: 'h2:8020',
        name: 'dfs.namenode.rpc-address.' + nameServiceId + '.nn2'
      },
      {
        config: {
          name: 'dfs.namenode.http-address.${dfs.nameservices}.nn1',
          filename: 'hdfs-site'
        },
        value: 'h1:1234',
        name: 'dfs.namenode.http-address.' + nameServiceId + '.nn1'
      },
      {
        config: {
          name: 'dfs.namenode.http-address.${dfs.nameservices}.nn2',
          filename: 'hdfs-site'
        },
        value: 'h2:50070',
        name: 'dfs.namenode.http-address.' + nameServiceId + '.nn2'
      },{
        config: {
          name: 'dfs.namenode.rpc-address.${dfs.nameservices}.nn1',
          filename: 'hdfs-client'
        },
        value: 'h1:1111',
        name: 'dfs.namenode.rpc-address.' + nameServiceId + '.nn1'
      },
      {
        config: {
          name: 'dfs.namenode.rpc-address.${dfs.nameservices}.nn2',
          filename: 'hdfs-client'
        },
        value: 'h2:8020',
        name: 'dfs.namenode.rpc-address.' + nameServiceId + '.nn2'
      },
      {
        config: {
          name: 'dfs.namenode.http-address.${dfs.nameservices}.nn1',
          filename: 'hdfs-client'
        },
        value: 'h1:1234',
        name: 'dfs.namenode.http-address.' + nameServiceId + '.nn1'
      },
      {
        config: {
          name: 'dfs.namenode.http-address.${dfs.nameservices}.nn2',
          filename: 'hdfs-client'
        },
        value: 'h2:50070',
        name: 'dfs.namenode.http-address.' + nameServiceId + '.nn2'
      },
      {
        config: {
          name: 'dfs.namenode.https-address.${dfs.nameservices}.nn1',
          filename: 'hdfs-site'
        },
        value: 'h1:4321',
        name: 'dfs.namenode.https-address.' + nameServiceId + '.nn1'
      },
      {
        config: {
          name: 'dfs.namenode.https-address.${dfs.nameservices}.nn2',
          filename: 'hdfs-site'
        },
        value: 'h2:50470',
        name: 'dfs.namenode.https-address.' + nameServiceId + '.nn2'
      },
      {
        config: {
          name: 'dfs.namenode.shared.edits.dir'
        },
        value: 'qjournal://h1:8485;h2:8485;h3:8485/' + nameServiceId
      },
      {
        config: {
          name: 'ha.zookeeper.quorum'
        },
        value: 'h1:4444,h2:4444,h3:4444'
      },
      {
        config: {
          name: 'hbase.rootdir',
          filename: 'hbase-site'
        },
        value: 'hdfs://' + nameServiceId + '/apps/hbase/data'
      },
      {
        config: {
          name: 'hbase.rootdir',
          filename: 'ams-hbase-site'
        },
        value: 'hdfs://' + nameServiceId + '/user/ams/hbase'
      },
      {
        config: {
          name: 'instance.volumes'
        },
        value: 'hdfs://' + nameServiceId + '/apps/accumulo/data'
      },
      {
        config: {
          name: 'instance.volumes.replacements'
        },
        value: 'hdfs://localhost:8020/apps/accumulo/data hdfs://' + nameServiceId + '/apps/accumulo/data'
      },
      {
        config: {
          name: 'dfs.journalnode.edits.dir'
        },
        value: '/hadoop/hdfs/journalnode123'
      },
      {
        config: {
          name: 'hawq_dfs_url',
          filename: 'hawq-site'
        },
        value: nameServiceId + '/hawq_data'
      },
      {
        config: {
          name: 'xasecure.audit.destination.hdfs.dir',
          filename: 'ranger-env'
        },
        value: 'hdfs://' + nameServiceId + '/ranger/audit'
      }
    ]).forEach(function (test) {
      describe(test.config.name, function () {
        var configs;
        beforeEach(function () {
          test.config.displayName = test.config.name;
          configs = controller.tweakServiceConfigs([test.config]);
        });

        it('value is ' + test.value, function () {
          expect(configs[0].value).to.equal(test.value);
        });
        it('recommendedValue is ' + test.value, function () {
          expect(configs[0].recommendedValue).to.equal(test.value);
        });

        if(test.name) {
          it('name is ' + test.name, function () {
            expect(configs[0].name).to.equal(test.name);
          });
          it('displayName is' + test.name, function () {
            expect(configs[0].displayName).to.equal(test.name);
          });
        }
      });
    });

    it('should set isOverridable=false for each config', function () {
      var configs = [
        {name: 'prop1'}, {name: 'prop2'}
      ];
      configs = controller.tweakServiceConfigs(configs);
      expect(configs.everyProperty('isOverridable', false)).to.be.true;
    });

  });

  describe('#onLoadConfigsTags', function () {

    var data = {Clusters: {desired_configs: {
      'hdfs-site': {tag: 'v1'},
      'core-site': {tag: 'v2'},
      'zoo.cfg': {tag: 'v3'},
      'hbase-site': {tag: 'v4'},
      'accumulo-site': {tag: 'v5'},
      'ams-hbase-site': {tag: 'v6'},
      'hawq-site': {tag: 'v7'},
      'hdfs-client': {tag: 'v8'},
      'ranger-env': {tag: 'v9'}
    }}};

    beforeEach(function () {
      sinon.stub(App.Service, 'find', function () {
        return [
          Em.Object.create({serviceName: 'HBASE'}),
          Em.Object.create({serviceName: 'ACCUMULO'}),
          Em.Object.create({serviceName: 'AMBARI_METRICS'}),
          Em.Object.create({serviceName: 'HAWQ'}),
          Em.Object.create({serviceName: 'RANGER'})
        ];
      });
      controller.onLoadConfigsTags(data);
      this.args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
    });

    afterEach(function () {
      App.Service.find.restore();
    });

    it('urlParams are valid', function () {
      expect(this.args[0].data.urlParams).to.be.equal('(type=hdfs-site&tag=v1)|(type=core-site&tag=v2)|(type=zoo.cfg&tag=v3)|(type=hbase-site&tag=v4)|(type=accumulo-site&tag=v5)|(type=ams-hbase-site&tag=v6)|(type=hawq-site&tag=v7)|(type=hdfs-client&tag=v8)|(type=ranger-env&tag=v9)');
    });

  });

});


});

require.register("test/controllers/main/admin/highAvailability/nameNode/step4_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

describe('App.HighAvailabilityWizardStep4Controller', function() {
  
  describe('#checkNnCheckPointStatus', function() {
    beforeEach(function() {
      this.controller = App.HighAvailabilityWizardStep4Controller.create();
      this.clock = sinon.useFakeTimers();
      sinon.stub(this.controller, 'pullCheckPointStatus');
    });

    afterEach(function() {
      this.clock.restore();
      this.controller.pullCheckPointStatus.restore();
    });

    var tests = [
      {
        responseData: {
          HostRoles: { desired_state: 'STARTED' }
        },
        m: 'NameNode started, Safemode off, no journal node transaction. Polling should be performed and isNameNodeStarted should be true',
        e: {
          isPollingCalled: true,
          isNameNodeStarted: true,
          isNextEnabled: false
        }
      },
      {
        responseData: {
          HostRoles: { desired_state: 'STARTED' },
          metrics: { dfs: { namenode: {
            Safemode: 'ON',
            JournalTransactionInfo: "{\"LastAppliedOrWrittenTxId\":\"4\",\"MostRecentCheckpointTxId\":\"2\"}"
          }}}
        },
        m: 'NameNode started, Safemode on, journal node transaction invalid. Polling should be performed and isNameNodeStarted should be true',
        e: {
          isPollingCalled: true,
          isNameNodeStarted: true,
          isNextEnabled: false
        }
      },
      {
        responseData: {
          HostRoles: { desired_state: 'INSTALLED' },
          metrics: { dfs: { namenode: {
            Safemode: 'ON',
            JournalTransactionInfo: "{\"LastAppliedOrWrittenTxId\":\"15\",\"MostRecentCheckpointTxId\":\"14\"}"
          }}}
        },
        m: 'NameNode not started, Safemode on, journal node transaction present. Polling should not be performed and isNameNodeStarted should be false',
        e: {
          isPollingCalled: false,
          isNameNodeStarted: false,
          isNextEnabled: true
        }
      },
      {
        responseData: {
          HostRoles: { desired_state: 'STARTED' },
          metrics: { dfs: { namenode: {
            Safemode: "",
            JournalTransactionInfo: "{\"LastAppliedOrWrittenTxId\":\"15\",\"MostRecentCheckpointTxId\":\"14\"}"
          }}}
        },
        m: 'NameNode started, Safemode off, journal node transaction present. Polling should not be performed and isNameNodeStarted should be true',
        e: {
          isPollingCalled: true,
          isNameNodeStarted: true,
          isNextEnabled: false
        }
      }
    ];

    tests.forEach(function(test) {
      describe(test.m, function() {

        beforeEach(function () {
          this.controller.set('isNameNodeStarted', !test.e.isNameNodeStarted);
          this.controller.checkNnCheckPointStatus(test.responseData);
          this.clock.tick(this.controller.get('POLL_INTERVAL'));
        });
        it('isNameNodeStarted is ' + test.e.isNameNodeStarted, function () {
          expect(this.controller.get('isNameNodeStarted')).to.be.equal(test.e.isNameNodeStarted);
        });
        it('isNextEnabled is ' + test.e.isNextEnabled, function () {
          expect(this.controller.get('isNextEnabled')).to.be.equal(test.e.isNextEnabled);
        });
        it('pullCheckPointStatus is ' + (test.e.isPollingCalled ? '' : 'not') + ' called', function () {
          expect(this.controller.pullCheckPointStatus.called).to.be.equal(test.e.isPollingCalled);
        });
      });
    });
  });
});


});

require.register("test/controllers/main/admin/highAvailability/progress_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/highAvailability_controller');
require('models/host_component');
require('models/host');
require('utils/ajax/ajax');

describe('App.HighAvailabilityProgressPageController', function () {

  var controller = App.HighAvailabilityProgressPageController.create();

  describe('#reconfigureSites()', function () {
    var tests = [
      {
        siteNames: ["site1", "site2"],
        data: {
          items: [
            {
              type: "site1",
              properties: {
                site1_property1: "site1_property1_value",
                site1_property2: "site1_property2_value"
              },
              properties_attributes: {
                final: {
                  site1_property1: "true"
                }
              }
            },
            {
              type: "site2",
              properties: {
                site2_property1: "site2_property1_value",
                site2_property2: "site2_property2_value"
              }
            },
            {
              type: "site3",
              properties: {
                site3_property: "site3_property_value"
              }
            }
          ]
        },
        note: 'note1',
        result: [
          {
            type: "site1",
            tag: "version1",
            properties: {
              site1_property1: "site1_property1_value",
              site1_property2: "site1_property2_value"
            },
            service_config_version_note: 'note1',
            properties_attributes: {
              final: {
                site1_property1: "true"
              }
            }
          },
          {
            type: "site2",
            tag: "version1",
            properties: {
              site2_property1: "site2_property1_value",
              site2_property2: "site2_property2_value"
            },
            service_config_version_note: 'note1'
          }
        ]
      },
      {
        siteNames: ["site1"],
        data: {
          items: [
            {
              type: "site1",
              properties: {
                site1_property1: "site1_property1_value",
                site1_property2: "site1_property2_value"
              },
              properties_attributes: {
                final: {
                  site1_property1: "true"
                }
              }
            }
          ]
        },
        note: 'note2',
        result: [
          {
            type: "site1",
            tag: "version1",
            properties: {
              site1_property1: "site1_property1_value",
              site1_property2: "site1_property2_value"
            },
            service_config_version_note: 'note2',
            properties_attributes: {
              final: {
                site1_property1: "true"
              }
            }
          }
        ]
      }];

    beforeEach(function () {
      sinon.stub(Date.prototype, 'getTime').returns(1);
    });

    afterEach(function () {
      Date.prototype.getTime.restore();
    });

    tests.forEach(function(t, index) {
      it("reconfigures configs after HA #" + (index + 1), function() {
        controller.set('content', t.content);
        expect(controller.reconfigureSites(t.siteNames, t.data, t.note)).to.eql(t.result);
      });
    });
  });

});

});

require.register("test/controllers/main/admin/highAvailability/progress_popup_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

require('controllers/main/admin/highAvailability/progress_popup_controller');
var testHelpers = require('test/helpers');

describe('App.HighAvailabilityProgressPopupController', function () {

  var controller;

  beforeEach(function () {
    controller = App.HighAvailabilityProgressPopupController.create();
  });

  after(function () {
    controller.destroy();
  });

  describe('#startTaskPolling', function () {

    describe('should start task polling', function () {

      beforeEach(function () {
        controller.startTaskPolling(1, 2);
      });

      it('isTaskPolling = true', function () {
        expect(controller.get('isTaskPolling')).to.be.true;
      });

      it('taskInfo.id = 2', function () {
        expect(controller.get('taskInfo.id')).to.be.equal(2);
      });

      it('taskInfo.requestId = 1', function () {
        expect(controller.get('taskInfo.requestId')).to.be.equal(1);
      });

      it('App.updater.run is called once', function () {
        expect(App.updater.run.calledOnce).to.be.true;
      });

      it('App.updater.immediateRun is called once', function () {
        expect(App.updater.immediateRun.calledOnce).to.be.true;
      });

    });

  });

  describe('#stopTaskPolling', function () {

    it('should stop task polling', function () {
      controller.stopTaskPolling();
      expect(controller.get('isTaskPolling')).to.be.false;
    });

  });

  describe('#updateTask', function () {

    it('should send polling request', function () {
      controller.updateTask();
      var args = testHelpers.findAjaxRequest('name', 'background_operations.get_by_task');
      expect(args).to.exists;
    });

  });

  describe('#updateTaskSuccessCallback', function () {

    beforeEach(function () {
      controller.reopen({
        taskInfo: {}
      });
    });

    var cases = [
        {
          status: 'FAILED',
          isTaskPolling: false
        },
        {
          status: 'COMPLETED',
          isTaskPolling: false
        },
        {
          status: 'TIMEDOUT',
          isTaskPolling: false
        },
        {
          status: 'ABORTED',
          isTaskPolling: false
        },
        {
          status: 'QUEUED',
          isTaskPolling: true
        },
        {
          status: 'IN_PROGRESS',
          isTaskPolling: true
        }
      ],
      tasks = {
        stderr: 'error',
        stdout: 'output',
        output_log: 'output-log.txt',
        error_log: 'error-log.txt'
      },
      title = '{0}polling task if it\'s status is {1}';

    cases.forEach(function (item) {
      var message = title.format(item.isTaskPolling ? '' : 'not ', item.status);
      describe(message, function () {

        beforeEach(function () {
          controller.updateTaskSuccessCallback({
            Tasks: $.extend(tasks, {
              status: item.status
            })
          });
        });

        it('stderr is valid', function () {
          expect(controller.get('taskInfo.stderr')).to.equal('error');
        });

        it('stdout is valid', function () {
          expect(controller.get('taskInfo.stdout')).to.equal('output');
        });

        it('outputLog is valid', function () {
          expect(controller.get('taskInfo.outputLog')).to.equal('output-log.txt');
        });

        it('errorLog is valid', function () {
          expect(controller.get('taskInfo.errorLog')).to.equal('error-log.txt');
        });

        it('isTaskPolling is valid', function () {
          expect(controller.get('isTaskPolling')).to.equal(item.isTaskPolling);
        });

      });
    });

  });

  describe('#getHosts', function () {

    var cases = [
      {
        name: 'background_operations.get_by_request',
        success: 'onGetHostsSuccess',
        title: 'default background operation polling'
      },
      {
        stageId: 0,
        name: 'common.request.polling',
        stageIdPassed: '0',
        successCallback: 's',
        success: 's',
        title: 'polling by stage, stageId = 0'
      },
      {
        stageId: 1,
        name: 'common.request.polling',
        stageIdPassed: 1,
        successCallback: null,
        success: 'onGetHostsSuccess',
        title: 'polling by stage'
      }
    ];

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          controller.setProperties({
            requestIds: [1, 2],
            stageId: item.stageId
          });
          controller.getHosts(item.successCallback);
          this.bgArgs = testHelpers.filterAjaxRequests('name', 'background_operations.get_by_request');
          this.pollingArgs = testHelpers.filterAjaxRequests('name', 'common.request.polling');
          this.args = item.name === 'background_operations.get_by_request' ? this.bgArgs : this.pollingArgs;
        });

        it('two requests are sent', function () {
          expect(this.args.length).to.be.equal(2);
        });

        it('1st call name is valid', function () {
          expect(this.args[0][0].name).to.equal(item.name);
        });

        it('2nd call name is valid', function () {
          expect(this.args[1][0].name).to.equal(item.name);
        });

        it('1st stageId is valid', function () {
          expect(this.args[0][0].data.stageId).to.eql(item.stageIdPassed);
        });

        it('2nd stageId is valid', function () {
          expect(this.args[1][0].data.stageId).to.eql(item.stageIdPassed);
        });

        it('success callback for first request', function () {
          expect(this.args[0][0].success).to.equal(item.success);
        });

        it('success callback for second request', function () {
          expect(this.args[1][0].success).to.equal(item.success);
        });

      });
    });

  });

  describe("#initPopup()", function () {

    beforeEach(function() {
      sinon.stub(App.ModalPopup, 'show');
      sinon.stub(controller, 'getHosts');
      sinon.stub(controller, 'setProperties');
    });

    afterEach(function() {
      App.ModalPopup.show.restore();
      controller.getHosts.restore();
      controller.setProperties.restore();
    });

    it("App.ModalPopup.show should be called", function() {
      controller.initPopup(null, null, null, true, null);
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });

    it("setProperties should be called", function() {
      controller.initPopup('popupTitle', [], {}, false, 1);
      expect(controller.setProperties.calledWith({
        progressController: {},
        popupTitle: 'popupTitle',
        requestIds: [],
        hostsData: [],
        stageId: 1
      })).to.be.true;
    });

    it("getHosts should be called", function() {
      controller.initPopup(null, null, null, false, null);
      expect(controller.getHosts.calledOnce).to.be.true;
    });
  });

  describe("#onGetHostsSuccess()", function () {
    var spinner = Em.Object.create({
      hide: Em.K
    });

    beforeEach(function() {
      sinon.stub(controller, 'calculateHostsData');
      sinon.stub(App.HostPopup, 'initPopup');
      sinon.stub(controller, 'isRequestRunning').returns(true);
      sinon.stub(controller, 'addObserver');
      sinon.stub(controller, 'doPolling');
      sinon.stub(spinner, 'hide');
      controller.setProperties({
        requestIds: [1],
        hostsData: [],
        popupTitle: 'popupTitle',
        spinnerPopup: spinner,
        progressController: {
          name: 'mainAdminStackAndUpgradeController'
        }
      });
      controller.onGetHostsSuccess({});
    });

    afterEach(function() {
      controller.calculateHostsData.restore();
      App.HostPopup.initPopup.restore();
      controller.isRequestRunning.restore();
      controller.addObserver.restore();
      controller.doPolling.restore();
      spinner.hide.restore();
    });

    it("calculateHostsData should be called", function() {
      expect(controller.calculateHostsData.calledWith([{}])).to.be.true;
    });

    it("App.HostPopup.initPopup should be called", function() {
      expect(App.HostPopup.initPopup.calledWith('popupTitle', controller)).to.be.true;
    });

    it("addObserver should be called", function() {
      expect(controller.addObserver.calledWith('progressController.logs.length', controller, 'getDataFromProgressController')).to.be.true;
    });

    it("spinnerPopup.hide should be called", function() {
      expect(spinner.hide.calledOnce).to.be.true;
    });

    it("doPolling should be called", function() {
      expect(controller.doPolling.calledOnce).to.be.true;
    });
  });

  describe("#calculateHostsData()", function () {

    beforeEach(function() {
      sinon.stub(App, 'dateTime').returns('dateTime');
      sinon.stub(controller, 'isRequestRunning').returns(false);
      sinon.stub(controller, 'removeObserver');
    });

    afterEach(function() {
      App.dateTime.restore();
      controller.isRequestRunning.restore();
      controller.removeObserver.restore();
    });

    it("calculate data", function() {
      var data = [
        {
          tasks: [
            {
              Tasks: {
                name: 't1',
                host_name: 'host1'
              }
            },
            {
              Tasks: {
                name: 't2',
                host_name: 'host1'
              }
            }
          ]
        }
      ];
      controller.setProperties({
        popupTitle: 'popupTitle'
      });
      controller.calculateHostsData(data);
      expect(controller.get('services')).to.be.eql([
        {
          "name": "popupTitle",
          "hosts": [
            {
              "name": "host1",
              "publicName": "host1",
              "logTasks": [
                {
                  "Tasks": {
                    "name": "t1",
                    "host_name": "host1"
                  }
                },
                {
                  "Tasks": {
                    "name": "t2",
                    "host_name": "host1"
                  }
                }
              ]
            }
          ]
        }
      ]);
      expect(controller.get('serviceTimestamp')).to.be.equal('dateTime');
      expect(controller.removeObserver.calledWith('progressController.logs.length', controller, 'getDataFromProgressController')).to.be.true;
    });
  });

  describe("#getDataFromProgressController()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'calculateHostsData');
    });

    afterEach(function() {
      controller.calculateHostsData.restore();
    });

    it("empty logs", function() {
      controller.set('progressController', Em.Object.create({
        logs: []
      }));
      controller.getDataFromProgressController();
      expect(controller.calculateHostsData.calledOnce).to.be.false;
    });

    it("filtered logs", function() {
      controller.setProperties({
        progressController: Em.Object.create({
          logs: [
            {
              Tasks: {
                stage_id: 1,
                request_id: 1
              }
            }
          ]
        }),
        stageId: 1,
        hostsData: [
          {
            Requests: {
              id: 1
            }
          }
        ]
      });
      controller.getDataFromProgressController();
      expect(controller.calculateHostsData.calledWith([
        {
          Requests: {
            id: 1
          },
          tasks: [
            {
              Tasks: {
                stage_id: 1,
                request_id: 1
              }
            }
          ]
        }
      ])).to.be.true;
    });
  });

  describe("#isRequestRunning()", function () {
    var testCases = [
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 1,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ],
        expected: false
      },
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 1,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ],
        expected: false
      },
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 1,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ],
        expected: false
      },
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 1,
              queued_task_count: 0
            }
          }
        ],
        expected: false
      },
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 1
            }
          }
        ],
        expected: true
      },
      {
        data: [
          {
            Requests: {
              task_count: 1,
              aborted_task_count: 0,
              completed_task_count: 0,
              failed_task_count: 0,
              timed_out_task_count: 0,
              queued_task_count: 0
            }
          }
        ],
        expected: true
      }
    ];

    testCases.forEach(function(test) {
      it("request: " + JSON.stringify(test.data), function() {
        expect(controller.isRequestRunning(test.data)).to.be.equal(test.expected);
      });
    });
  });

});

});

require.register("test/controllers/main/admin/highAvailability/rangerAdmin/step3_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/highAvailability/rangerAdmin/step3_controller');
require('controllers/main/admin/highAvailability/rangerAdmin/wizard_controller');
require('controllers/main');

describe('App.RAHighAvailabilityWizardStep3Controller', function () {

  var controller;

  beforeEach(function () {
    controller = App.RAHighAvailabilityWizardStep3Controller.create();
  });

  describe('#loadStep', function () {

    var dfd,
      testCases = [
        {
          path: 'isLoaded',
          result: true
        },
        {
          path: 'selectedService.configs.length',
          result: 1,
          massage: 'configs length'
        },
        {
          path: 'selectedService.configs.firstObject.name',
          result: 'policymgr_external_url',
          message: 'property name'
        },
        {
          path: 'selectedService.configs.firstObject.category',
          result: 'RANGER',
          message: 'config category'
        },
        {
          path: 'selectedService.configs.firstObject.value',
          result: 'http://localhost:1111',
          message: 'property value'
        }
      ],
      service = Em.Object.create({
        serviceName: 'RANGER',
        displayName: 'Ranger'
      });

    beforeEach(function () {
      dfd = $.Deferred();
      sinon.stub(App.get('router.mainController'), 'isLoading').returns(dfd);
      sinon.stub(App.Service, 'find').returns([service]);
      sinon.stub(App.config, 'get').withArgs('serviceByConfigTypeMap').returns({
        'admin-properties': service
      });
      sinon.stub(App.configsCollection, 'getConfigByName').returns({
        name: 'policymgr_external_url'
      });
      controller.setProperties({
        wizardController: App.get('router.rAHighAvailabilityWizardController'),
        content: {
          loadBalancerURL: 'http://localhost:1111'
        }
      });
      controller.loadStep();
      dfd.resolve();
    });

    afterEach(function () {
      App.get('router.mainController.isLoading').restore();
      App.Service.find.restore();
      App.config.get.restore();
      App.configsCollection.getConfigByName.restore();
    });

    testCases.forEach(function (testCase) {

      it(testCase.message || testCase.path, function () {
        expect(controller.get(testCase.path)).to.equal(testCase.result);
      });

    });

  });

});
});

require.register("test/controllers/main/admin/highAvailability/resourceManager/step3_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/admin/highAvailability/resourceManager/step3_controller');
var testHelpers = require('test/helpers');

describe('App.RMHighAvailabilityWizardStep3Controller', function () {

  describe('#isSubmitDisabled', function () {

    var controller = App.RMHighAvailabilityWizardStep3Controller.create({
        content: Em.Object.create({})
      }),
      cases = [
        {
          isLoaded: false,
          isSubmitDisabled: true,
          title: 'wizard step content not loaded'
        },
        {
          isLoaded: true,
          isSubmitDisabled: false,
          title: 'wizard step content loaded'
        }
      ];

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.set('isLoaded', item.isLoaded);
        expect(controller.get('isSubmitDisabled')).to.equal(item.isSubmitDisabled);
      });
    });

  });

  describe('#loadConfigTagsSuccessCallback', function () {

    var controller = App.RMHighAvailabilityWizardStep3Controller.create({
      content: Em.Object.create({})
    });

    it('should send proper ajax request', function () {
      controller.loadConfigTagsSuccessCallback({
        'Clusters': {
          'desired_configs': {
            'zoo.cfg': {
              'tag': 1
            },
            'yarn-site': {
              'tag': 1
            },
            'yarn-env': {
              'tag': 1
            }
          }
        }
      }, {}, {
        'serviceConfig': {}
      });
      var data = testHelpers.findAjaxRequest('name', 'reassign.load_configs')[0].data;
      expect(data.urlParams).to.equal('(type=zoo.cfg&tag=1)|(type=yarn-site&tag=1)|(type=yarn-env&tag=1)');
      expect(data.serviceConfig).to.eql({});
    });

  });

  describe('#loadConfigsSuccessCallback', function () {

    var controller = App.RMHighAvailabilityWizardStep3Controller.create({
        content: Em.Object.create({})
      }),
      cases = [
        {
          'items': [],
          'params': {
            'serviceConfig': {}
          },
          'port': '2181',
          'webAddressPort' : ':8088',
          'httpsWebAddressPort' : ':8090',
          'title': 'empty response'
        },
        {
          'items': [
            {
              'type': 'zoo.cfg'
            },
            {
              'type': 'yarn-site'
            }
          ],
          'params': {
            'serviceConfig': {}
          },
          'port': '2181',
          'webAddressPort' : ':8088',
          'httpsWebAddressPort' : ':8090',
          'title': 'no zoo.cfg properties received'
        },
        {
          'items': [
            {
              'type': 'zoo.cfg',
              'properties': {
                'n': 'v'
              }
            },
            {
              'type': 'yarn-site',
              'properties': {
                'n': 'v'
              }
            }
          ],
          'params': {
            'serviceConfig': {}
          },
          'port': '2181',
          'webAddressPort' : ':8088',
          'httpsWebAddressPort' : ':8090',
          'title': 'no clientPort property received'
        },
        {
          'items': [
            {
              'type': 'zoo.cfg',
              'properties': {
                'clientPort': '2182'
              }
            },
            {
              'type': 'yarn-site',
              'properties': {
                'yarn.resourcemanager.webapp.address' : 'c6402.ambari.apache.org:7777',
                'yarn.resourcemanager.webapp.https.address' : 'c6402.ambari.apache.org:8888'
              }
            }
          ],
          'params': {
            'serviceConfig': {}
          },
          'port': '2182',
          'webAddressPort' : ':7777',
          'httpsWebAddressPort' : ':8888',
          'title': 'clientPort property received'
        }
      ];

    beforeEach(function () {
      sinon.stub(controller, 'setDynamicConfigValues', Em.K);
    });

    afterEach(function () {
      controller.setDynamicConfigValues.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.loadConfigsSuccessCallback({
          items: item.items
        }, {}, item.params);
        expect(controller.get('selectedService')).to.eql({});
        expect(controller.get('isLoaded')).to.be.true;
      });
    });

  });

  describe('#loadConfigsSuccessCallback=loadConfigsErrorCallback(we have one callback for bouth cases)', function () {

    var controller = App.RMHighAvailabilityWizardStep3Controller.create({
      content: Em.Object.create({})
    });

    beforeEach(function () {
      sinon.stub(controller, 'setDynamicConfigValues', Em.K);
    });

    afterEach(function () {
      controller.setDynamicConfigValues.restore();
    });

    it('should proceed with default value', function () {
      controller.loadConfigsSuccessCallback({}, {}, {}, {}, {
        serviceConfig: {}
      });
      expect(controller.get('selectedService')).to.eql({});
      expect(controller.get('isLoaded')).to.be.true;
    });

  });

  describe('#setDynamicConfigValues', function () {

    var data = {
      items: [
        {
          type: 'zoo.cfg',
          properties: {
            clientPort: 2222
          }
        },
        {
          type: 'yarn-env',
          properties: {
            yarn_user: 'yarn'
          }
        },
        {
          type: 'yarn-site',
          properties: {
            'yarn.resourcemanager.webapp.address': 'lclhst:1234',
            'yarn.resourcemanager.webapp.https.address': 'lclhst:4321'
          }
        }
      ]
    };

    var controller = App.RMHighAvailabilityWizardStep3Controller.create({
        content: Em.Object.create({
          masterComponentHosts: [
            {component: 'RESOURCEMANAGER', hostName: 'h0', isInstalled: true},
            {component: 'RESOURCEMANAGER', hostName: 'h1', isInstalled: false},
            {component: 'ZOOKEEPER_SERVER', hostName: 'h2', isInstalled: true},
            {component: 'ZOOKEEPER_SERVER', hostName: 'h3', isInstalled: true}
          ],
          slaveComponentHosts: [],
          hosts: {},
          rmHosts: {
            currentRM: 'h0',
            additionalRM: 'h1'
          }
        })
      }),
      configs = {
        configs: [
          Em.Object.create({
            name: 'yarn.resourcemanager.hostname.rm1'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.hostname.rm2'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.zk-address'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.webapp.address.rm1'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.webapp.address.rm2'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.webapp.https.address.rm1'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.webapp.https.address.rm2'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.ha'
          }),
          Em.Object.create({
            name: 'yarn.resourcemanager.scheduler.ha'
          }),
          Em.Object.create({
            name: 'hadoop.proxyuser.yarn.hosts'
          })
        ]
      };

    beforeEach(function () {
      sinon.stub(App.HostComponent, 'find', function () {
        return [
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
              hostName: 'h2'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
              hostName: 'h3'
          }),
          Em.Object.create({
            componentName: 'RESOURCEMANAGER',
              hostName: 'h4'
          })
        ];
      });
      controller.setDynamicConfigValues(configs, data);
    });

    afterEach(function () {
      App.HostComponent.find.restore();
    });

    it('yarn.resourcemanager.hostname.rm1 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.hostname.rm1').get('value')).to.equal('h0');
    });
    it('yarn.resourcemanager.hostname.rm1 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.hostname.rm1').get('recommendedValue')).to.equal('h0');
    });
    it('yarn.resourcemanager.hostname.rm2 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.hostname.rm2').get('value')).to.equal('h1');
    });
    it('yarn.resourcemanager.hostname.rm2 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.hostname.rm2').get('recommendedValue')).to.equal('h1');
    });
    it('yarn.resourcemanager.webapp.address.rm1 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.address.rm1').get('value')).to.equal('h0:1234');
    });
    it('yarn.resourcemanager.webapp.address.rm1 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.address.rm1').get('recommendedValue')).to.equal('h0:1234');
    });
    it('yarn.resourcemanager.webapp.address.rm2 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.address.rm2').get('value')).to.equal('h1:1234');
    });
    it('yarn.resourcemanager.webapp.address.rm2 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.address.rm2').get('recommendedValue')).to.equal('h1:1234');
    });
    it('yarn.resourcemanager.webapp.https.address.rm1 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.https.address.rm1').get('value')).to.equal('h0:4321');
    });
    it('yarn.resourcemanager.webapp.https.address.rm1 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.https.address.rm1').get('recommendedValue')).to.equal('h0:4321');
    });
    it('yarn.resourcemanager.webapp.https.address.rm2 value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.https.address.rm2').get('value')).to.equal('h1:4321');
    });
    it('yarn.resourcemanager.webapp.https.address.rm2 recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.webapp.https.address.rm2').get('recommendedValue')).to.equal('h1:4321');
    });
    it('yarn.resourcemanager.zk-address value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.zk-address').get('value')).to.equal('h2:2222,h3:2222');
    });
    it('yarn.resourcemanager.zk-address recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.zk-address').get('recommendedValue')).to.equal('h2:2222,h3:2222');
    });
    it('yarn.resourcemanager.ha value', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.ha').get('value')).to.equal('h0:8032,h1:8032');
    });
    it('yarn.resourcemanager.ha recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'yarn.resourcemanager.scheduler.ha').get('recommendedValue')).to.equal('h0:8030,h1:8030');
    });

    it('hadoop.proxyuser.yarn.hosts value', function () {
      expect(configs.configs.findProperty('name', 'hadoop.proxyuser.yarn.hosts').get('value')).to.equal('h0,h1');
    });

    it('hadoop.proxyuser.yarn.hosts recommendedValue', function () {
      expect(configs.configs.findProperty('name', 'hadoop.proxyuser.yarn.hosts').get('recommendedValue')).to.equal('h0,h1');
    });

  });

});

});

require.register("test/controllers/main/admin/highAvailability_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/highAvailability_controller');
require('models/host_component');
require('models/host');
require('utils/ajax/ajax');

describe('App.MainAdminHighAvailabilityController', function () {

  var controller = App.MainAdminHighAvailabilityController.create();

  describe('#enableHighAvailability()', function () {

    var hostComponents = [];

    beforeEach(function () {
      sinon.stub(App.router, 'transitionTo', Em.K);
      sinon.stub(App.HostComponent, 'find', function(){
        return hostComponents;
      });
      sinon.spy(controller, "showErrorPopup");
    });

    afterEach(function () {
      App.router.transitionTo.restore();
      controller.showErrorPopup.restore();
      App.HostComponent.find.restore();
      App.router.get.restore();
    });

    describe('NAMENODE in INSTALLED state', function () {
      beforeEach(function () {
        hostComponents = [
          Em.Object.create({
            componentName: 'NAMENODE',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          })
        ];
        sinon.stub(App.router, 'get', function() {
          return 3;
        });
        this.result = controller.enableHighAvailability();
      });

      it('enableHighAvailability result is false', function () {
        expect(this.result).to.be.false;
      });

      it('showErrorPopup is called once', function () {
        expect(controller.showErrorPopup.calledOnce).to.be.true;
      });

    });

    describe('Cluster has less than 3 ZOOKEPER_SERVER components', function () {
      hostComponents = [
        Em.Object.create({
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        })
      ];

      beforeEach(function () {
        sinon.stub(App.router, 'get', function(){
          return 3;
        });
        this.result = controller.enableHighAvailability();
      });

      it('enableHighAvailability result is false', function () {
        expect(this.result).to.be.false;
      });

      it('showErrorPopup is called', function () {
        expect(controller.showErrorPopup.called).to.be.true;
      });

    });

    describe('total hosts number less than 3', function () {
      hostComponents = [
        Em.Object.create({
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        }),
        Em.Object.create({
          componentName: 'ZOOKEEPER_SERVER',
          workStatus: 'INSTALLED'
        }),
        Em.Object.create({
          componentName: 'ZOOKEEPER_SERVER',
          workStatus: 'INSTALLED'
        }),
        Em.Object.create({
          componentName: 'ZOOKEEPER_SERVER',
          workStatus: 'INSTALLED'
        })
      ];

      beforeEach(function () {
        sinon.stub(App.router, 'get', function () {
          return 1;
        });
        this.result = controller.enableHighAvailability();
      });

      it('enableHighAvailability result is false', function () {
        expect(this.result).to.be.false;
      });

      it('showErrorPopup is called once', function () {
        expect(controller.showErrorPopup.calledOnce).to.be.true;
      });

    });

    describe('All checks passed', function () {
      beforeEach(function () {
        hostComponents = [
          Em.Object.create({
            componentName: 'NAMENODE',
            workStatus: 'STARTED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'ZOOKEEPER_SERVER',
            workStatus: 'INSTALLED'
          })
        ];
        sinon.stub(App.router, 'get', function() {
          return 3;
        });
        this.result = controller.enableHighAvailability();
      });

      it('enableHighAvailability result is true', function () {
        expect(this.result).to.be.true;
      });

      it('user is moved to enable HA', function () {
        expect(App.router.transitionTo.calledWith('main.services.enableHighAvailability')).to.be.true;
      });

      it('showErrorPopup is not called', function () {
        expect(controller.showErrorPopup.calledOnce).to.be.false;
      });

    });
  });

  describe('#joinMessage()', function () {
    it('message is empty', function () {
      var message = [];
      expect(controller.joinMessage(message)).to.be.empty;
    });
    it('message is array from two strings', function () {
      var message = ['yes', 'no'];
      expect(controller.joinMessage(message)).to.equal('yes<br/>no');
    });
    it('message is string', function () {
      var message = 'hello';
      expect(controller.joinMessage(message)).to.equal('<p>hello</p>');
    });
  });

  describe('#manageJournalNode()', function () {

    beforeEach(function () {
      this.mock = sinon.stub(App.HostComponent, 'find');
      sinon.stub(App.router, 'transitionTo', Em.K);
      sinon.spy(controller, "showErrorPopup");
    });

    afterEach(function () {
      App.router.transitionTo.restore();
      controller.showErrorPopup.restore();
      App.HostComponent.find.restore();
    });

    it('should show error popup if there is no NNs', function () {
      this.mock.returns([]);
      var result = controller.manageJournalNode();
      expect(result).to.be.false;
      expect(controller.showErrorPopup.calledOnce).to.be.true;
    });

    it('should show error popup if there is no NNs', function () {
      this.mock.returns([
        Em.Object.create({
          componentName: 'NAMENODE',
          displayNameAdvanced: 'Active NameNode'
        }),
        Em.Object.create({
          componentName: 'NAMENODE'
        })
      ]);
      var result = controller.manageJournalNode();
      expect(result).to.be.false;
      expect(controller.showErrorPopup.calledOnce).to.be.true;
    });

    it('should call transition to wizard if we have both standby and active NNs', function () {
      this.mock.returns([
        Em.Object.create({
          componentName: 'NAMENODE',
          displayNameAdvanced: 'Active NameNode'
        }),
        Em.Object.create({
          componentName: 'NAMENODE',
          displayNameAdvanced: 'Standby NameNode'
        })
      ]);
      var result = controller.manageJournalNode();
      expect(result).to.be.true;
      expect(App.router.transitionTo.calledOnce).to.be.true;
    });
  });

});

});

require.register("test/controllers/main/admin/kerberos/disable_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');


describe('App.KerberosDisableController', function() {
  var controller;

  beforeEach(function() {
    controller = App.KerberosDisableController.create();
  });

  describe("#loadStep()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'loadTasksStatuses');
      sinon.stub(controller, 'loadTasksRequestIds');
      sinon.stub(controller, 'loadRequestIds');
      controller.loadStep();
    });

    afterEach(function() {
      controller.loadTasksStatuses.restore();
      controller.loadTasksRequestIds.restore();
      controller.loadRequestIds.restore();
    });

    it("controllerName should be set", function() {
      expect(controller.get('content.controllerName')).to.be.equal('kerberosDisableController');
    });

    it("loadTasksStatuses should be called", function() {
      expect(controller.loadTasksStatuses.calledOnce).to.be.true;
    });

    it("loadTasksRequestIds should be called", function() {
      expect(controller.loadTasksRequestIds.calledOnce).to.be.true;
    });

    it("loadRequestIds should be called", function() {
      expect(controller.loadRequestIds.calledOnce).to.be.true;
    });
  });

  describe("#unkerberize()", function () {

    it("App.ajax.send should be called", function() {
      controller.unkerberize();
      var args = testHelpers.findAjaxRequest('name', 'admin.unkerberize.cluster');
      expect(args[0]).to.be.eql({
        name: 'admin.unkerberize.cluster',
        sender: controller,
        success: 'startPolling',
        error: 'onTaskErrorWithSkip'
      });
    });
  });

  describe("#skipTask()", function () {

    it("App.ajax.send should be called", function() {
      controller.skipTask();
      var args = testHelpers.findAjaxRequest('name', 'admin.unkerberize.cluster.skip');
      expect(args[0]).to.be.eql({
        name: 'admin.unkerberize.cluster.skip',
        sender: controller,
        success: 'startPolling',
        error: 'onTaskError'
      });
    });
  });

  describe("#deleteKerberos()", function () {

    it("App.ajax.send should be called", function() {
      controller.deleteKerberos();
      var args = testHelpers.findAjaxRequest('name', 'common.delete.service');
      expect(args[0]).to.be.eql({
        name: 'common.delete.service',
        sender: controller,
        data: {
          serviceName: 'KERBEROS'
        },
        success: 'onTaskCompleted',
        error: 'onTaskCompleted'
      });
    });
  });

  describe("#startAllServices()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'startServices');
    });

    afterEach(function() {
      controller.startServices.restore();
    });

    it("startServices should be called", function() {
      controller.startAllServices();
      expect(controller.startServices.calledOnce).to.be.true;
    });
  });
});

});

require.register("test/controllers/main/admin/kerberos/kerberos_wizard_controler_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

describe('App.KerberosWizardController', function() {
  var controller;

  beforeEach(function() {
    controller = App.KerberosWizardController.create({});
  });

  describe('#warnBeforeExitPopup()', function () {
    beforeEach(function () {
      sinon.stub(App, "showConfirmationPopup", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
    });
    it('should open warning confirmation popup', function () {
      var f = Em.K;
      controller.warnBeforeExitPopup(f, false);
      expect(App.showConfirmationPopup.calledWith(f, Em.I18n.t('admin.kerberos.wizard.exit.warning.msg'), null, null, Em.I18n.t('common.exitAnyway'), false)).to.be.true;
    });

    it('should open critical confirmation popup', function () {
      var f = Em.K;
      controller.warnBeforeExitPopup(f, true);
      expect(App.showConfirmationPopup.calledWith(f, Em.I18n.t('admin.kerberos.wizard.exit.critical.msg'), null, null, Em.I18n.t('common.exitAnyway'), true)).to.be.true;
    });
  });

  describe("#skipClientInstall", function () {

    it("kerberosOption is null", function() {
      controller.set('content.kerberosOption', null);
      controller.propertyDidChange('skipClientInstall');
      expect(controller.get('skipClientInstall')).to.be.false;
    });

    it("kerberosOption is 'opt1'", function() {
      controller.set('content.kerberosOption', 'opt1');
      controller.propertyDidChange('skipClientInstall');
      expect(controller.get('skipClientInstall')).to.be.false;
    });

    it("kerberosOption is manual", function() {
      controller.set('content.kerberosOption', Em.I18n.t('admin.kerberos.wizard.step1.option.manual'));
      controller.propertyDidChange('skipClientInstall');
      expect(controller.get('skipClientInstall')).to.be.true;
    });
  });

  describe("#setCurrentStep()", function () {

    beforeEach(function() {
      sinon.stub(App.clusterStatus, 'setClusterStatus');
    });

    afterEach(function() {
      App.clusterStatus.setClusterStatus.restore();
    });

    it("skipStateSave is true", function() {
      controller.setCurrentStep("", true, true);
      expect(App.clusterStatus.setClusterStatus.called).to.be.false;
    });

    it("skipStateSave is false", function() {
      controller.setCurrentStep("", true, false);
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
  });

  describe("#getCluster()", function () {

    it("jQuery.extend should be called", function() {
      App.set('clusterName', 'c1');
      controller.set('clusterStatusTemplate', {});
      expect(controller.getCluster()).to.be.eql({name: 'c1'});
    });
  });

  describe("#updateClusterEnvData()", function () {

    it("configs should be set", function() {
      var configs = {};
      controller.set('kerberosDescriptorConfigs', {
        properties: {
          realm: 'realm'
        }
      });
      controller.updateClusterEnvData(configs);
      expect(configs).to.be.eql({
        security_enabled: true,
        kerberos_domain: 'realm'
      });
    });
  });

  describe("#saveClusterStatus()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'save');
    });

    afterEach(function() {
      controller.save.restore();
    });

    it("save should be called", function() {
      controller.set('content.cluster', {});
      controller.saveClusterStatus({});
      expect(controller.save.calledWith('cluster')).to.be.true;
    });

    it("new requestId should be pushed", function() {
      controller.set('content.cluster', {});
      controller.saveClusterStatus({requestId: [1], oldRequestsId: []});
      expect(controller.get('content.cluster')).to.be.eql({
        oldRequestsId: [1],
        requestId: [1]
      });
    });

    it("new requestId should not be pushed", function() {
      controller.set('content.cluster', {});
      controller.saveClusterStatus({requestId: [1], oldRequestsId: [1]});
      expect(controller.get('content.cluster')).to.be.eql({
        oldRequestsId: [1],
        requestId: [1]
      });
    });
  });

  describe("#saveConfigTag()", function () {
    var tag = {
      name: 'n1',
      value: 'v1'
    };

    beforeEach(function() {
      sinon.stub(App.db, 'setKerberosWizardConfigTag');
      controller.saveConfigTag(tag);
    });

    afterEach(function() {
      App.db.setKerberosWizardConfigTag.restore();
    });

    it("App.db.setKerberosWizardConfigTag should be called", function() {
      expect(App.db.setKerberosWizardConfigTag.calledWith(tag)).to.be.true;
    });

    it("content property should be set", function() {
      expect(controller.get('content.n1')).to.be.equal('v1');
    });
  });

  describe("#saveKerberosOption()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'setDBProperty');
      controller.saveKerberosOption(Em.Object.create({selectedItem: "selectedItem"}));
    });

    afterEach(function() {
      controller.setDBProperty.restore();
    });

    it("setDBProperty should be called", function() {
      expect(controller.setDBProperty.calledWith('kerberosOption', "selectedItem")).to.be.true;
    });

    it("kerberosOption should be set", function() {
      expect(controller.get('content.kerberosOption')).to.be.equal('selectedItem');
    });
  });

  describe("#loadKerberosDescriptorConfigs()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'getDBProperty').returns({});
    });

    afterEach(function() {
      controller.getDBProperty.restore();
    });

    it("kerberosDescriptorConfigs should be set", function() {
      controller.loadKerberosDescriptorConfigs();
      expect(controller.get('kerberosDescriptorConfigs')).to.be.eql({});
    });
  });

  describe("#overrideVisibility()", function () {

    it("empty object", function() {
      var itemsArray = [
        {}
      ];
      controller.overrideVisibility(itemsArray, true, []);
      expect(itemsArray[0]).to.be.empty;
    });

    it("override in exception", function() {
      var itemsArray = [
        {
          category: 'c1',
          name: 'n1',
          isVisible: false
        }
      ];
      controller.overrideVisibility(itemsArray, true, [{c1: 'n1'}]);
      expect(itemsArray[0].isVisible).to.be.false;
    });

    it("override should be set to visible", function() {
      var itemsArray = [
        {
          category: 'c1',
          name: 'n1',
          isVisible: false
        }
      ];
      controller.overrideVisibility(itemsArray, true, []);
      expect(itemsArray[0].isVisible).to.be.true;
    });
  });

  describe("#loadKerberosOption()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'getDBProperty').returns('kerberosOption');
    });

    afterEach(function() {
      controller.getDBProperty.restore();
    });

    it("kerberosOption should be set", function() {
      controller.loadKerberosOption();
      expect(controller.get('content.kerberosOption')).to.be.equal('kerberosOption');
    });
  });

  describe("#saveKerberosDescriptorConfigs()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'setDBProperty');
      controller.saveKerberosDescriptorConfigs([]);
    });

    afterEach(function() {
      controller.setDBProperty.restore();
    });

    it("setDBProperty should be called", function() {
      expect(controller.setDBProperty.calledWith('kerberosDescriptorConfigs', [])).to.be.true;
    });

    it("kerberosDescriptorConfigs should be set", function() {
      expect(controller.get('kerberosDescriptorConfigs')).to.be.eql([]);
    });
  });

  describe("#createKerberosResources()", function () {
    var mock = {
      callback: Em.K
    };

    beforeEach(function() {
      sinon.stub(mock, 'callback');
      sinon.stub(controller, 'createKerberosService').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'updateAndCreateServiceComponent').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'createKerberosHostComponents').returns({
        done: Em.clb
      });
      controller.createKerberosResources(mock.callback);
    });

    afterEach(function() {
      controller.createKerberosHostComponents.restore();
      controller.updateAndCreateServiceComponent.restore();
      controller.createKerberosService.restore();
      mock.callback.restore();
    });

    it("createKerberosService should be called", function() {
      expect(controller.createKerberosService.calledOnce).to.be.true;
    });

    it("updateAndCreateServiceComponent should be called", function() {
      expect(controller.updateAndCreateServiceComponent.calledWith('KERBEROS_CLIENT')).to.be.true;
    });

    it("createKerberosHostComponents should be called", function() {
      expect(controller.createKerberosHostComponents.calledOnce).to.be.true;
    });

    it("callback should be called", function() {
      expect(mock.callback.calledOnce).to.be.true;
    });
  });

  describe("#createKerberosService()", function () {

    it("App.ajax.send should be called", function() {
      App.set('clusterName', 'c1');
      controller.createKerberosService();
      var args = testHelpers.findAjaxRequest('name', 'wizard.step8.create_selected_services');
      expect(args[0]).to.be.eql({
        name: 'wizard.step8.create_selected_services',
        sender: controller,
        data: {
          data: '{"ServiceInfo": { "service_name": "KERBEROS"}}',
          cluster: 'c1'
        }
      });
    });
  });

  describe("#deleteKerberosService()", function () {

    beforeEach(function() {
      App.cache.services = [{
        ServiceInfo: {
          service_name: 'KERBEROS'
        }
      }];
      sinon.stub(App.serviceMapper, 'deleteRecord');
      sinon.stub(App.Service, 'find').returns(Em.Object.create({
        isLoaded: true
      }));
      controller.deleteKerberosService();
    });

    afterEach(function() {
      App.serviceMapper.deleteRecord.restore();
      App.Service.find.restore();
    });

    it("App.cache.services should be empty", function() {
      expect(App.cache.services).to.be.empty;
    });

    it("App.serviceMapper.deleteRecord should be called", function () {
      expect(App.serviceMapper.deleteRecord.calledWith(Em.Object.create({
        isLoaded: true
      }))).to.be.true;
    });

    it("App.ajax.send should be called", function() {
      var args = testHelpers.findAjaxRequest('name', 'common.delete.service');
      expect(args[0]).to.be.eql({
        name: 'common.delete.service',
        sender: controller,
        data: {
          serviceName: 'KERBEROS'
        }
      });
    });
  });

  describe("#unkerberize()", function () {

    it("App.ajax.send should be called", function() {
      controller.unkerberize();
      var args = testHelpers.findAjaxRequest('name', 'admin.unkerberize.cluster');
      expect(args[0]).to.be.eql({
        name: 'admin.unkerberize.cluster',
        sender: controller
      });
    });
  });

  describe("#createKerberosHostComponents()", function () {

    it("App.ajax.send should be called", function() {
      App.set('clusterName', 'c1');
      App.set('allHostNames', ['host1']);
      controller.createKerberosHostComponents();
      var args = testHelpers.findAjaxRequest('name', 'wizard.step8.register_host_to_component');
      expect(args[0]).to.be.exists;
    });
  });

  describe("#clearAllSteps()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'clearInstallOptions');
      sinon.stub(controller, 'getCluster').returns({});
      controller.clearAllSteps();
    });

    afterEach(function() {
      controller.clearInstallOptions.restore();
      controller.getCluster.restore();
    });

    it("clearInstallOptions should be called", function() {
      expect(controller.clearInstallOptions.calledOnce).to.be.true;
    });

    it("content.cluster should be set", function() {
      expect(controller.get('content.cluster')).to.be.eql({});
    });
  });

  describe("#clearTasksData()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'saveTasksStatuses');
      sinon.stub(controller, 'saveRequestIds');
      sinon.stub(controller, 'saveTasksRequestIds');
      controller.clearTasksData();
    });

    afterEach(function() {
      controller.saveTasksRequestIds.restore();
      controller.saveTasksStatuses.restore();
      controller.saveRequestIds.restore();
    });

    it("saveTasksRequestIds should be called", function() {
      expect(controller.saveTasksRequestIds.calledWith(undefined)).to.be.true;
    });

    it("saveRequestIds should be called", function() {
      expect(controller.saveRequestIds.calledWith(undefined)).to.be.true;
    });

    it("saveTasksStatuses should be called", function() {
      expect(controller.saveTasksStatuses.calledWith(undefined)).to.be.true;
    });
  });

  describe("#warnBeforeExitPopup()", function () {

    beforeEach(function() {
      sinon.stub(App, 'showConfirmationPopup');
    });

    afterEach(function() {
      App.showConfirmationPopup.restore();
    });

    it("isCritical is true", function() {
      controller.warnBeforeExitPopup(Em.K, true);
      expect(App.showConfirmationPopup.calledWith(Em.K, Em.I18n.t('admin.kerberos.wizard.exit.critical.msg'), null, null, Em.I18n.t('common.exitAnyway'), true)).to.be.true;
    });

    it("isCritical is false", function() {
      controller.warnBeforeExitPopup(Em.K, false);
      expect(App.showConfirmationPopup.calledWith(Em.K, Em.I18n.t('admin.kerberos.wizard.exit.warning.msg'), null, null, Em.I18n.t('common.exitAnyway'), false)).to.be.true;
    });
  });

  describe("#finish()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'setCurrentStep');
      sinon.stub(controller, 'resetDbNamespace');
      controller.finish();
    });

    afterEach(function() {
      controller.setCurrentStep.restore();
      controller.resetDbNamespace.restore();
    });

    it("setCurrentStep should be called", function() {
      expect(controller.setCurrentStep.calledWith('1', false, true)).to.be.true;
    });

    it("resetDbNamespace should be called", function() {
      expect(controller.resetDbNamespace.calledOnce).to.be.true;
    });
  });

  describe("#discardChanges()", function () {
    var mock = {
      onResolve: Em.K
    };

    beforeEach(function() {
      sinon.stub(controller, 'unkerberize').returns({always: Em.clb});
      sinon.stub(controller, 'deleteKerberosService').returns({always: Em.clb});
      sinon.stub(mock, 'onResolve');
      controller.discardChanges().done(mock.onResolve);
    });

    afterEach(function() {
      controller.unkerberize.restore();
      controller.deleteKerberosService.restore();
      mock.onResolve.restore();
    });

    it("unkerberize should be called", function() {
      expect(controller.unkerberize.calledOnce).to.be.true;
    });

    it("deleteKerberosService should be called", function() {
      expect(controller.deleteKerberosService.calledOnce).to.be.true;
    });

    it("onResolve should be called", function() {
      expect(mock.onResolve.calledOnce).to.be.true;
    });
  });


});



});

require.register("test/controllers/main/admin/kerberos/step1_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

function getController() {
  return App.KerberosWizardStep1Controller.create({});
}

describe('App.KerberosWizardStep1Controller', function() {
  var controller;

  beforeEach(function() {
    controller = getController();
  });
  
  describe("#selectedOption", function () {
  	 
    it("test", function() {
      var options=controller.get('options');
      controller.propertyDidChange('selectedOption');
      var option = options.findProperty('value', controller.get('selectedItem'));
      expect(option.preConditions.everyProperty('checked', false)).to.be.true;
    });
    
  });

  describe("#loadStep()", function () {

    beforeEach(function() {
      controller.set('options', []);
    });

    it("enableIpa is true", function() {
      App.set('supports.enableIpa', true);
      controller.loadStep();
      expect(controller.get('selectedItem')).to.be.equal(Em.I18n.t('admin.kerberos.wizard.step1.option.kdc'));
      expect(controller.get('options')).to.not.be.empty;
    });

    it("enableIpa is false", function() {
      App.set('supports.enableIpa', false);
      controller.loadStep();
      expect(controller.get('selectedItem')).to.be.equal(Em.I18n.t('admin.kerberos.wizard.step1.option.kdc'));
      expect(controller.get('options')).to.be.empty;
    });
    
    it("on load selected item should not change", function() {
      controller.set('selectedItem',Em.I18n.t('admin.kerberos.wizard.step3.option.kdc'));	
      controller.loadStep();
      expect(controller.get('selectedItem')).to.be.equal(Em.I18n.t('admin.kerberos.wizard.step3.option.kdc'));
    });
  });

  describe("#submit()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'send');
    });

    afterEach(function() {
      App.router.send.restore();
    });

    it("App.router.send should be called", function() {
      controller.reopen({
        'isSubmitDisabled': false
      });
      controller.submit();
      expect(App.router.send.calledOnce).to.be.true;
    });

    it("App.router.send should not be called", function() {
      controller.reopen({
        'isSubmitDisabled': true
      });
      controller.submit();
      expect(App.router.send.called).to.be.false;
    });
  });

});

});

require.register("test/controllers/main/admin/kerberos/step2_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var setups = require('test/init_model_test');
var testHelpers = require('test/helpers');

function getController() {
  return App.KerberosWizardStep2Controller.create({
    wizardController: Em.Object.create({
      deleteKerberosService: Em.K
    }),
    controllers: Em.Object.create(),
    content: Em.Object.create()
  });
}

describe('App.KerberosWizardStep2Controller', function() {
  var controller;

  beforeEach(function() {
    controller = getController();
  });

  App.TestAliases.testAsComputedOr(getController(), 'isBackBtnDisabled', ['testConnectionInProgress', 'App.router.nextBtnClickInProgress'], 'boolean');

  App.TestAliases.testAsComputedAlias(getController(), 'hostNames', 'App.allHostNames', 'array');

  App.TestAliases.testAsComputedAlias(getController(), 'isConfigsLoaded', 'wizardController.stackConfigsLoaded', 'boolean');

  describe('#createKerberosSiteObj', function() {

    beforeEach(function() {
      setups.setupStackVersion(this, 'HDP-2.3');
      sinon.stub(controller, 'tweakKdcTypeValue', Em.K);
      sinon.stub(controller, 'tweakManualKdcProperties', Em.K);
    });

    after(function() {
      setups.restoreStackVersion(this);
      controller.tweakKdcTypeValue.restore();
      controller.tweakManualKdcProperties.restore();
    });

    var _createProperty = function(name, value, displayType) {
      var preDefProp = App.config.get('preDefinedSiteProperties').findProperty('name', name);
      if (preDefProp) {
        return App.ServiceConfigProperty.create(
          $.extend(true, {}, preDefProp, {
            value: value, filename: 'some-site.xml',
            'displayType': displayType,
            isRequiredByAgent: preDefProp.isRequiredByAgent === undefined ? true : preDefProp.isRequiredByAgent
          }));
      }
      return App.ServiceConfigProperty.create({name: name, value: value, isRequiredByAgent: true, filename: 'some-site.xml'});
    };

    var tests = [
      {
        stepConfigs: [
          ['realm', ' SPACES ', 'host'],
          ['admin_server_host', ' space_left', 'host'],
          ['kdc_hosts', ' space_left_and_right ', 'host'],
          ['ldap_url', 'space_right ', 'host']
        ],
        e: {
          realm: 'SPACES',
          admin_server_host: 'space_left',
          kdc_hosts: 'space_left_and_right',
          ldap_url: 'space_right'
        }
      }
    ];

    tests.forEach(function(test) {
      describe('Should trim values for properties ' + Em.keys(test.e).join(','), function() {
        var result;

        beforeEach(function () {
          sinon.stub(App.StackService, 'find').returns([Em.Object.create({serviceName: 'KERBEROS'})]);
          controller.set('stepConfigs', [
            App.ServiceConfig.create({
              configs: test.stepConfigs.map(function(item) { return _createProperty(item[0], item[1], item[2]); })
            })
          ]);
          result = controller.createKerberosSiteObj('some-site', 'random-tag');
        });

        afterEach(function () {
          App.StackService.find.restore();
        });

        Em.keys(test.e).forEach(function(propertyName) {
          it(propertyName, function () {
            expect(result.properties[propertyName]).to.be.eql(test.e[propertyName]);
          });
        });
      });
    });
  });

  describe("#isSubmitDisabled", function () {
    var testCases = [
      {
        title: 'stepConfigs is empty',
        data: {
          stepConfigs: []
        },
        expected: true
      },
      {
        title: 'testConnectionInProgress is true',
        data: {
          stepConfigs: [{}],
          testConnectionInProgress: true
        },
        expected: true
      },
      {
        title: 'submitButtonClicked is true',
        data: {
          stepConfigs: [{}],
          testConnectionInProgress: false,
          submitButtonClicked: true
        },
        expected: true
      },
      {
        title: 'configs has errors',
        data: {
          stepConfigs: [{showConfig: true, errorCount: 1}],
          testConnectionInProgress: false,
          submitButtonClicked: false
        },
        expected: true
      },
      {
        title: 'miscModalVisible is true',
        data: {
          stepConfigs: [{showConfig: true, errorCount: 0}],
          testConnectionInProgress: false,
          submitButtonClicked: false,
          miscModalVisible: true
        },
        expected: true
      },
      {
        title: 'miscModalVisible is false',
        data: {
          stepConfigs: [{showConfig: true, errorCount: 0}],
          testConnectionInProgress: false,
          submitButtonClicked: false,
          miscModalVisible: false
        },
        expected: false
      }
    ];

    testCases.forEach(function(test) {
      it(test.title, function() {
        controller.setProperties(test.data);
        controller.propertyDidChange('isSubmitDisabled');
        expect(controller.get('isSubmitDisabled')).to.be.equal(test.expected);
      });
    });
  });

  describe("#clearStep()", function () {

    beforeEach(function() {
      controller.setProperties({
        configs: [{}],
        serviceConfigTags: [{}],
        servicesInstalled: true
      });
      controller.clearStep();
    });

    it("configs should be empty", function() {
      expect(controller.get('configs')).to.be.empty;
    });

    it("serviceConfigTags should be empty", function() {
      expect(controller.get('serviceConfigTags')).to.be.empty;
    });

    it("servicesInstalled should be false", function() {
      expect(controller.get('servicesInstalled')).to.be.false;
    });
  });

  describe("#loadStep()", function () {

    beforeEach(function() {
      this.mockStackService = sinon.stub(App.StackService, 'find').returns([{
        serviceName: 'KERBEROS'
      }]);
      sinon.stub(controller, 'clearStep');
      sinon.stub(App.config, 'setPreDefinedServiceConfigs');
      sinon.stub(App.config, 'mergeStoredValue');
      sinon.stub(controller, 'filterConfigs');
      sinon.stub(controller, 'getKerberosConfigs');
      sinon.stub(controller, 'initializeKDCStoreProperties');
      sinon.stub(controller, 'applyServicesConfigs');
      sinon.stub(controller, 'updateKDCStoreProperties');
      controller.reopen({
        isConfigsLoaded: true,
        stepConfigs: [Em.Object.create({serviceName: 'KERBEROS'})],
        content: Em.Object.create({
          serviceConfigProperties: [{}]
        }),
        wizardController: {
          skipClientInstall: true
        }
      });
    });

    afterEach(function() {
      this.mockStackService.restore();
      controller.clearStep.restore();
      App.config.setPreDefinedServiceConfigs.restore();
      App.config.mergeStoredValue.restore();
      controller.filterConfigs.restore();
      controller.getKerberosConfigs.restore();
      controller.initializeKDCStoreProperties.restore();
      controller.applyServicesConfigs.restore();
      controller.updateKDCStoreProperties.restore();
    });

    it("KERBEROS service absent", function() {
      this.mockStackService.returns([]);
      expect(controller.loadStep()).to.be.false;
    });

    it("configs not loaded", function() {
      controller.set('isConfigsLoaded', false);
      expect(controller.loadStep()).to.be.false;
    });

    it("clearStep should be called", function() {
      controller.loadStep();
      expect(controller.clearStep.calledOnce).to.be.true;
    });

    it("App.config.setPreDefinedServiceConfigs should be called", function() {
      controller.loadStep();
      expect(App.config.setPreDefinedServiceConfigs.calledOnce).to.be.true;
    });

    it("getKerberosConfigs should be called", function() {
      controller.set('content.serviceConfigProperties', null);
      controller.loadStep();
      expect(controller.getKerberosConfigs.calledOnce).to.be.true;
    });

    it("filterConfigs should be called", function() {
      controller.loadStep();
      expect(controller.filterConfigs.calledOnce).to.be.true;
    });

    it("initializeKDCStoreProperties should be called", function() {
      controller.set('wizardController.skipClientInstall', false);
      controller.loadStep();
      expect(controller.initializeKDCStoreProperties.calledOnce).to.be.true;
    });

    it("applyServicesConfigs should be called", function() {
      controller.loadStep();
      expect(controller.applyServicesConfigs.calledOnce).to.be.true;
    });

    it("updateKDCStoreProperties should be called", function() {
      controller.set('wizardController.skipClientInstall', false);
      controller.loadStep();
      expect(controller.updateKDCStoreProperties.calledOnce).to.be.true;
    });
  });

  describe("#getKerberosConfigs()", function () {

    beforeEach(function() {
      this.mock = sinon.stub(App.configsCollection, 'getAll');
      sinon.stub(App.config, 'getConfigTagFromFileName').returns('t1');
      sinon.stub(App.config, 'get').returns([
        Em.Object.create({
          serviceName: 'KERBEROS',
          configTypes: {
            't1': {}
          }
        })
      ]);
    });

    afterEach(function() {
      this.mock .restore();
      App.config.getConfigTagFromFileName.restore();
      App.config.get.restore();
    });

    it("fileName not specified (serviceName S1)", function() {
      this.mock.returns([
        {
          serviceName: 'S1'
        }
      ]);
      expect(controller.getKerberosConfigs()).to.be.empty;
    });

    it("fileName not specified (serviceName KERBEROS)", function() {
      this.mock.returns([
        {
          serviceName: 'KERBEROS'
        }
      ]);
      expect(controller.getKerberosConfigs()).to.be.eql([
        {
          serviceName: 'KERBEROS'
        }
      ]);
    });

    it("incorrect service", function() {
      this.mock.returns([
        {
          fileName: 'f1',
          serviceName: 'S1'
        }
      ]);
      expect(controller.getKerberosConfigs()).to.be.eql([
        {
          fileName: 'f1',
          serviceName: 'S1'
        }
      ]);
    });

    it("fileName and service correct", function() {
      this.mock.returns([
        {
          fileName: 'f1',
          serviceName: 'KERBEROS'
        }
      ]);
      expect(controller.getKerberosConfigs()).to.be.eql([
        {
          fileName: 'f1',
          serviceName: 'KERBEROS'
        }
      ]);
    });
  });

  describe("#filterConfigs()", function () {
    var configs = [
      Em.Object.create({
        serviceName: 'KERBEROS',
        isVisible: false
      }),
      Em.Object.create({
        serviceName: 'S1',
        isVisible: false
      })
    ];

    beforeEach(function() {
      controller.set('controllers', {
        kerberosWizardController: Em.Object.create({
          skipClientInstall: false,
          overrideVisibility: Em.K
        })
      });
      controller.set('content', Em.Object.create({
        kerberosOption: null
      }));
      sinon.stub(controller.get('controllers.kerberosWizardController'), 'overrideVisibility');
      sinon.stub(controller, 'setKDCTypeProperty');
      sinon.stub(controller, 'setConfigVisibility');
    });

    afterEach(function() {
      controller.setKDCTypeProperty.restore();
      controller.setConfigVisibility.restore();
      controller.get('controllers.kerberosWizardController').overrideVisibility.restore();
    });

    it("KERBEROS config should be visible", function() {
      controller.filterConfigs(configs);
      expect(configs.mapProperty('isVisible')).to.be.eql([true, false]);
    });

    it("setKDCTypeProperty should be called", function() {
      controller.filterConfigs(configs);
      expect(controller.setKDCTypeProperty.calledOnce).to.be.true;
    });

    it("setConfigVisibility should not be called", function() {
      controller.set('content.kerberosOption', Em.I18n.t('admin.kerberos.wizard.step1.option.manual'));
      controller.filterConfigs(configs);
      expect(controller.setConfigVisibility.called).to.be.false;
    });

    it("overrideVisibility should be called", function() {
      controller.set('content.kerberosOption', Em.I18n.t('admin.kerberos.wizard.step1.option.manual'));
      controller.set('controllers.kerberosWizardController.skipClientInstall', true);
      controller.filterConfigs(configs);
      expect(controller.get('controllers.kerberosWizardController').overrideVisibility.calledOnce).to.be.true;
    });

    it("overrideVisibility results are valid", function() {
      configs = [{
        name: 'manage_identities'
      }];
      controller.filterConfigs(configs);
      expect(configs[0].isVisible).to.be.false;
      expect(configs[0].value).to.be.equal('true');
    });

    it("setConfigVisibility should be called", function() {
      controller.filterConfigs(configs);
      expect(controller.setConfigVisibility.calledThrice).to.be.true;
    });
  });

  describe("#setConfigVisibility()", function () {

    it("ad type configs", function() {
      var configs = [{name: 'ldap_url'}];
      controller.setConfigVisibility('ad', configs, Em.I18n.t('admin.kerberos.wizard.step1.option.ad'));
      expect(configs[0].isVisible).to.be.true;
    });

    it("mit type configs", function() {
      var configs = [{name: 'kdc_create_attributes'}];
      controller.setConfigVisibility('mit', configs, Em.I18n.t('admin.kerberos.wizard.step1.option.kdc'));
      expect(configs[0].isVisible).to.be.true;
    });

    it("ipa type configs", function() {
      var configs = [{name: 'group'}];
      controller.setConfigVisibility('ipa', configs, Em.I18n.t('admin.kerberos.wizard.step1.option.ipa'));
      expect(configs[0].isVisible).to.be.true;
    });
  });

  describe("#submit()", function () {

    beforeEach(function() {
      sinon.stub(controller.get('wizardController'), 'deleteKerberosService').returns({
        always: Em.clb
      });
      sinon.stub(controller, 'configureKerberos');
      controller.reopen({
        isSubmitDisabled: false
      });
    });

    afterEach(function() {
      controller.get('wizardController').deleteKerberosService.restore();
      controller.configureKerberos.restore();
    });

    it("deleteKerberosService should not be called", function() {
      controller.set('isSubmitDisabled', true);
      expect(controller.submit()).to.be.false;
      expect(controller.get('wizardController').deleteKerberosService.called).to.be.false;
    });

    it("deleteKerberosService should be called", function() {
      controller.submit();
      expect(controller.get('wizardController').deleteKerberosService.called).to.be.true;
    });

    it("configureKerberos should be called", function() {
      controller.submit();
      expect(controller.configureKerberos.calledOnce).to.be.true;
    });
  });

  describe("#configureKerberos()", function () {
    var mock = Em.Object.create({
      createKerberosResources: Em.K
    });

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns(mock);
      sinon.stub(controller, 'createConfigurations').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'createKerberosAdminSession').returns({
        done: Em.clb
      });
      sinon.stub(App.router, 'send');
      sinon.stub(mock, 'createKerberosResources');
    });

    afterEach(function() {
      App.router.get.restore();
      controller.createConfigurations.restore();
      controller.createKerberosAdminSession.restore();
      App.router.send.restore();
      mock.createKerberosResources.restore();
    });

    it("createConfigurations should be called", function() {
      mock.set('skipClientInstall', true);
      controller.configureKerberos();
      expect(controller.createConfigurations.calledOnce).to.be.true;
    });

    it("createKerberosAdminSession should be called", function() {
      mock.set('skipClientInstall', true);
      controller.configureKerberos();
      expect(controller.createKerberosAdminSession.calledOnce).to.be.true;
    });

    it("App.router.send should be called", function() {
      mock.set('skipClientInstall', true);
      controller.configureKerberos();
      expect(App.router.send.calledWith('next')).to.be.true;
    });

    it("createKerberosResources should be called", function() {
      mock.set('skipClientInstall', false);
      controller.configureKerberos();
      expect(mock.createKerberosResources.calledOnce).to.be.true;
    });
  });

  describe("#createConfigurations()", function () {

    beforeEach(function() {
      sinon.stub(App.StackService, 'find').returns([
        Em.Object.create({
          serviceName: 'KERBEROS',
          configTypes: {
            t1: {},
            t3: {}
          },
          configTypesRendered: {
            t1: {},
            t2: {}
          }
        })
      ]);
      sinon.stub(controller, 'createKerberosSiteObj').returns({
        type: 't1'
      });
    });

    afterEach(function() {
      App.StackService.find.restore();
      controller.createKerberosSiteObj.restore();
    });

    it("App.ajax.send should be called", function() {
      controller.createConfigurations();
      var args = testHelpers.findAjaxRequest('name', 'common.across.services.configurations');
      expect(args[0]).to.be.eql({
        name: 'common.across.services.configurations',
        sender: controller,
        data: {
          data: '[' + JSON.stringify({
            Clusters: {
              desired_config: [
                {
                  type: 't1',
                  service_config_version_note: Em.I18n.t('admin.kerberos.wizard.configuration.note')
                }
              ]
            }
          }).toString() + ']'
        }
      });
    });
  });

  describe("#createKerberosSiteObj()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'tweakKdcTypeValue');
      sinon.stub(controller, 'tweakManualKdcProperties');
      sinon.stub(controller, 'tweakIpaKdcProperties');
      sinon.stub(App.config, 'trimProperty', function(arg) {
        return arg;
      });
      controller.set('stepConfigs', [Em.Object.create({
        configs: []
      })]);
    });

    afterEach(function() {
      controller.tweakKdcTypeValue.restore();
      controller.tweakManualKdcProperties.restore();
      controller.tweakIpaKdcProperties.restore();
      App.config.trimProperty.restore();
    });

    it("tweakKdcTypeValue should be called", function() {
      controller.createKerberosSiteObj();
      expect(controller.tweakKdcTypeValue.calledWith({})).to.be.true;
    });

    it("tweakManualKdcProperties should be called", function() {
      controller.createKerberosSiteObj();
      expect(controller.tweakManualKdcProperties.calledWith({})).to.be.true;
    });

    it("tweakIpaKdcProperties should be called", function() {
      controller.createKerberosSiteObj();
      expect(controller.tweakIpaKdcProperties.calledWith({})).to.be.true;
    });

    it("properties should be empty", function() {
      controller.set('stepConfigs', [Em.Object.create({
        configs: [{
          isRequiredByAgent: false,
          filename: 'site.xml'
        }]
      })]);
      expect(controller.createKerberosSiteObj('site', 'tag')).to.be.eql({
        "type": 'site',
        "tag": 'tag',
        "properties": {}
      });
    });

    it("properties should contain kdc_hosts", function() {
      controller.set('stepConfigs', [Em.Object.create({
        configs: [{
          name: 'kdc_hosts',
          value: 'v1',
          filename: 'site.xml'
        }]
      })]);
      expect(controller.createKerberosSiteObj('site', 'tag')).to.be.eql({
        "type": 'site',
        "tag": 'tag',
        "properties": {
          'kdc_hosts': {
            displayType: 'host',
            value: 'v1'
          }
        }
      });
    });

    it("properties should contain n1", function() {
      controller.set('stepConfigs', [Em.Object.create({
        configs: [{
          name: 'n1',
          value: 'v1',
          filename: 'site.xml'
        }]
      })]);
      expect(controller.createKerberosSiteObj('site', 'tag')).to.be.eql({
        "type": 'site',
        "tag": 'tag',
        "properties": {
          'n1': {
            name: 'n1',
            value: 'v1',
            filename: 'site.xml'
          }
        }
      });
    });
  });

  describe("#tweakKdcTypeValue()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns({
        'k1': 'p1'
      });
    });

    afterEach(function() {
      App.router.get.restore();
    });

    it("kdc_type should be p2", function() {
      var properties = {'kdc_type': 'p2'};
      controller.tweakKdcTypeValue(properties);
      expect(properties.kdc_type).to.be.equal('p2')
    });

    it("kdc_type should be k1", function() {
      var properties = {'kdc_type': 'p1'};
      controller.tweakKdcTypeValue(properties);
      expect(properties.kdc_type).to.be.equal('k1')
    });
  });

  describe("#tweakManualKdcProperties()", function () {

    it("properties shouldn't be changed", function() {
      var properties = {
        'kdc_type': 'p1'
      };
      controller.set('controllers.kerberosWizardController', Em.Object.create({
        skipClientInstall: false
      }));
      controller.tweakManualKdcProperties(properties);
      expect(properties).to.be.eql({
        'kdc_type': 'p1'
      });
    });

    it("kdc_type is none", function() {
      var properties = {
        'kdc_type': 'none',
        'manage_identities': 'true'
      };
      controller.set('controllers.kerberosWizardController', Em.Object.create({
        skipClientInstall: false
      }));
      controller.tweakManualKdcProperties(properties);
      expect(properties).to.be.eql({
        'kdc_type': 'none',
        'manage_identities': 'false'
      });
    });

    it("skipClientInstall is true", function() {
      var properties = {
        'kdc_type': 'p1',
        'manage_identities': 'true',
        'install_packages': 'true',
        'manage_krb5_conf': 'true'
      };
      controller.set('controllers.kerberosWizardController', Em.Object.create({
        skipClientInstall: true
      }));
      controller.tweakManualKdcProperties(properties);
      expect(properties).to.be.eql({
        'kdc_type': 'p1',
        'manage_identities': 'false',
        'install_packages': 'false',
        'manage_krb5_conf': 'false'
      });
    });
  });

  describe("#tweakIpaKdcProperties()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns({'ipa': 'p1'});
    });

    afterEach(function() {
      App.router.get.restore();
    });

    it("properties should be empty, kdc_type undefined", function() {
      var properties = {};
      controller.tweakIpaKdcProperties(properties);
      expect(properties).to.be.empty;
    });

    it("properties should not be empty", function() {
      var properties = {
        kdc_type: 'p1'
      };
      controller.set('content.kerberosOption', 'p2');
      controller.tweakIpaKdcProperties(properties);
      expect(properties).to.be.eql({
        kdc_type: 'p1'
      });
    });

    it("properties should set config values", function() {
      var properties = {
        'kdc_type': 'p1',
        'install_packages': 'true',
        'manage_krb5_conf': 'true'
      };
      controller.set('content.kerberosOption', 'p1');
      controller.tweakIpaKdcProperties(properties);
      expect(properties).to.be.eql({
        'kdc_type': 'p1',
        'install_packages': 'false',
        'manage_krb5_conf': 'false'
      });
    });
  });

  describe("#createKerberosAdminSession()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'createKDCCredentials');
    });

    afterEach(function() {
      controller.createKDCCredentials.restore();
    });

    it("createKDCCredentials should be called", function() {
      controller.set('wizardController.skipClientInstall', false);
      controller.createKerberosAdminSession([]);
      expect(controller.createKDCCredentials.calledWith([])).to.be.true;
    });

    it("createKDCCredentials should be called, with non-empty configs", function() {
      controller.set('stepConfigs', [Em.Object.create({configs: [{}]})]);
      controller.set('wizardController.skipClientInstall', false);
      controller.createKerberosAdminSession();
      expect(controller.createKDCCredentials.calledWith([{}])).to.be.true;
    });

    it("App.ajax.send should be called", function() {
      App.set('clusterName', 'c1');
      var configs = [
        {
          name: 'admin_principal',
          value: 'v1'
        },
        {
          name: 'admin_password',
          value: 'v2'
        }
      ];
      controller.set('wizardController.skipClientInstall', true);

      controller.createKerberosAdminSession(configs);
      var args = testHelpers.findAjaxRequest('name', 'common.cluster.update');
      expect(args[0]).to.be.eql({
        name: 'common.cluster.update',
        sender: controller,
        data: {
          clusterName: 'c1',
          data: [{
            session_attributes: {
              kerberos_admin: {principal: 'v1', password: 'v2'}
            }
          }]
        }
      });
    });
  });

  describe("#showConnectionInProgressPopup()", function () {

    beforeEach(function() {
      sinon.stub(App, 'showConfirmationPopup');
    });

    afterEach(function() {
      App.showConfirmationPopup.restore();
    });

    it("App.showConfirmationPopup should be called", function() {
      var primary = Em.K;
      controller.showConnectionInProgressPopup(primary);
      expect(App.showConfirmationPopup.calledWith(primary, Em.I18n.t('services.service.config.connection.exitPopup.msg'), null, null, Em.I18n.t('common.exitAnyway'))).to.be.true;
    });
  });


  describe("#setKDCTypeProperty()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns({
        'k1': 'p1'
      });
    });

    afterEach(function() {
      App.router.get.restore();
    });

    it("kdcTypeProperty should be set", function() {
      var configs = [{
        filename: 'kerberos-env.xml',
        name: 'kdc_type'
      }];
      controller.set('content.kerberosOption', 'p1');
      controller.setKDCTypeProperty(configs);
      expect(configs[0].value).to.be.equal('p1');
    });
  });
});

});

require.register("test/controllers/main/admin/kerberos/step3_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

describe('App.KerberosWizardStep3Controller', function() {
  var controller;

  beforeEach(function() {
    controller = App.KerberosWizardStep3Controller.create({});
  });

  describe('#onTestKerberosError', function() {

    beforeEach(function(){
      sinon.stub(App.ajax, 'defaultErrorHandler', Em.K);
      sinon.stub(controller, 'onTaskError', Em.K);
    });

    afterEach(function(){
      App.ajax.defaultErrorHandler.restore();
      controller.onTaskError.restore();
    });

    it('should call App.ajax.defaultErrorHandler and onTaskError', function () {
      controller.onTestKerberosError({status: 3}, null, null, {url: 1, type: 2});
      expect(App.ajax.defaultErrorHandler.calledWith({status: 3}, 1, 2, 3)).to.be.true;
      expect(controller.onTaskError.calledOnce).to.be.true;
    });
  });

  describe("#loadStep()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'enableDisablePreviousSteps');
    });

    afterEach(function() {
      controller.enableDisablePreviousSteps.restore();
    });

    it("enableDisablePreviousSteps should be called", function() {
      controller.loadStep();
      expect(controller.enableDisablePreviousSteps.calledOnce).to.be.true;
    });
  });

  describe("#installKerberos()", function () {

    beforeEach(function() {
      this.mock = sinon.stub(controller, 'getKerberosClientState');
      sinon.stub(controller, 'updateComponent');
    });

    afterEach(function() {
      this.mock.restore();
      controller.updateComponent.restore();
    });

    it("not INIT state", function() {
      this.mock.returns({
        done: function(callback) {
          callback({ServiceComponentInfo: {
            state: ""
          }});
        }
      });
      App.set('allHostNames', ['host1']);
      controller.installKerberos();
      expect(controller.updateComponent.calledWith('KERBEROS_CLIENT', ['host1'], "KERBEROS", "Install")).to.be.true;
    });

    it("INIT state", function() {
      this.mock.returns({
        done: function(callback) {
          callback({ServiceComponentInfo: {
            state: "INIT"
          }});
        }
      });
      controller.installKerberos();
      var args = testHelpers.findAjaxRequest('name', 'common.services.update');
      expect(args[0]).to.be.eql({
        name: 'common.services.update',
        sender: controller,
        data: {
          context: Em.I18n.t('requestInfo.kerberosService'),
          ServiceInfo: {"state": "INSTALLED"},
          urlParams: "ServiceInfo/state=INSTALLED&ServiceInfo/service_name=KERBEROS"
        },
        success: 'startPolling',
        error: 'onTaskError'
      });
    });
  });

  describe("#getKerberosClientState()", function () {

    it("App.ajax.send should be called", function() {
      controller.setProperties({
        serviceName: 'S1',
        componentName: 'C1'
      });
      controller.getKerberosClientState();
      var args = testHelpers.findAjaxRequest('name', 'common.service_component.info');
      expect(args[0]).to.be.eql({
        name: 'common.service_component.info',
        sender: controller,
        data: {
          serviceName: 'S1',
          componentName: 'C1',
          urlParams: "fields=ServiceComponentInfo/state"
        }
      });
    });
  });

  describe("#testKerberos()", function () {

    it("App.ajax.send should be called", function() {
      controller.testKerberos();
      var args = testHelpers.findAjaxRequest('name', 'service.item.smoke');
      expect(args[0]).to.exists;
    });
  });

  describe("#onTestKerberosError()", function () {

    beforeEach(function() {
      sinon.stub(App.ajax, 'defaultErrorHandler');
      sinon.stub(controller, 'onTaskError');
      controller.onTestKerberosError({status: 's1'}, {}, "error", {type: 't1', url: 'u1'});
    });

    afterEach(function() {
      App.ajax.defaultErrorHandler.restore();
      controller.onTaskError.restore();
    });

    it("App.ajax.defaultErrorHandler should be called", function() {
      expect(App.ajax.defaultErrorHandler.calledWith({status: 's1'}, 'u1', 't1', 's1')).to.be.true;
    });

    it("onTaskError should be called", function() {
      expect(controller.onTaskError.calledWith({status: 's1'}, {}, "error", {type: 't1', url: 'u1'})).to.be.true;
    });
  });

  describe("#enableDisablePreviousSteps()", function () {
    var mock = {
      setStepsEnable: Em.K,
      setLowerStepsDisable: Em.K
    };

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns(mock);
      sinon.stub(mock, 'setStepsEnable');
      sinon.stub(mock, 'setLowerStepsDisable');
    });

    afterEach(function() {
      App.router.get.restore();
      mock.setStepsEnable.restore();
      mock.setLowerStepsDisable.restore();
    });

    it("setLowerStepsDisable should be called", function() {
      controller.set('tasks', [{
        status: 'COMPLETED'
      }]);
      controller.enableDisablePreviousSteps();
      expect(mock.setLowerStepsDisable.calledWith(3)).to.be.true;
    });

    it("setStepsEnable should be called", function() {
      controller.set('tasks', [{
        status: 'FAILED'
      }]);
      controller.enableDisablePreviousSteps();
      expect(mock.setStepsEnable.called).to.be.true;
    });
  });

  describe("#ignoreAndProceed()", function () {

    it("isSubmitDisabled should be true", function() {
      controller.setProperties({
        showIgnore: true,
        ignore: false
      });
      controller.ignoreAndProceed();
      expect(controller.get('isSubmitDisabled')).to.be.true;
    });

    it("isSubmitDisabled should be false", function() {
      controller.setProperties({
        showIgnore: true,
        ignore: true
      });
      controller.ignoreAndProceed();
      expect(controller.get('isSubmitDisabled')).to.be.true;
    });

    it("isSubmitDisabled should not be changed", function() {
      controller.setProperties({
        showIgnore: false,
        ignore: true,
        isSubmitDisabled: false
      });
      controller.ignoreAndProceed();
      expect(controller.get('isSubmitDisabled')).to.be.false;
    });

  });

  describe('#statusDidChange', function() {
    var cases;
    beforeEach(function() {
      controller.set('status', 'PENDING');
      controller.set('tasks', [
        Em.Object.create({
          id: 0,
          status: 'COMPLETED'
        }),
        Em.Object.create({
          id: 1,
          status: 'COMPLETED'
        })
      ]);
      this.getHeartbeatLostHostsStub = sinon.stub(controller, 'getHeartbeatLostHosts');
    });
    afterEach(function() {
      controller.getHeartbeatLostHosts.restore();
    });

    cases = [
      {
        m: 'Heartbeat lost host during kerberization',
        heartBeatHosts: ['host1'],
        getHeartbeatLostHostsResponse: {
          items: [
            {
              Hosts: {
                host_name: 'host1'
              }
            }
          ]
        },
        expected: {
          heartbeatHosts: ['host1'],
          installClientsTaskStatus: ['FAILED']
        }
      },
      {
        m: 'All hosts in HEALTHY state',
        heartBeatHosts: [],
        getHeartbeatLostHostsResponse: {
          items: []
        },
        expected: {
          heartbeatHosts: [],
          installClientsTaskStatus: ['COMPLETED']
        }
      }
    ];

    cases.forEach(function(test) {
      it(test.m, function() {
        this.getHeartbeatLostHostsStub.returns($.Deferred().resolve(test.getHeartbeatLostHostsResponse).promise());
        controller.set('status', 'COMPLETED');
        controller.propertyDidChange('status');
        assert.sameMembers(controller.get('heartBeatLostHosts'), test.expected.heartbeatHosts, 'heartbeat lost host stored in controller');
        assert.equal(controller.get('tasks').objectAt(0).get('status'), test.expected.installClientsTaskStatus, 'Install Clients task status')
      });
    });
  });
});

});

require.register("test/controllers/main/admin/kerberos/step4_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

function getController() {
  return App.KerberosWizardStep4Controller.create({
    wizardController: Em.Object.create({
      name: ''
    })
  });
}

describe('App.KerberosWizardStep4Controller', function() {
  var c;

  beforeEach(function() {
    c = getController();
  });

  App.TestAliases.testAsComputedEqual(getController(), 'isWithinAddService', 'wizardController.name', 'addServiceController');

  describe("#clearStep()", function () {

    beforeEach(function() {
      c.clearStep();
    });

    it("isRecommendedLoaded should be set to false", function() {
      expect(c.get('isRecommendedLoaded')).to.be.false;
    });

    it("selectedService should be set to null", function() {
      expect(c.get('selectedService')).to.be.null;
    });

    it("stepConfigs should be set to false", function() {
      expect(c.get('stepConfigs')).to.be.empty;
    });
  });

  describe('#isSubmitDisabled', function() {
    var controller, configs;
    beforeEach(function() {
      controller = App.KerberosWizardStep4Controller.create({});
      configs = Em.A([
        App.ServiceConfigProperty.create({
          name: 'prop1',
          value: 'someVal1',
          identityType: 'user',
          category: 'Ambari Principals',
          serviceName: 'Cluster'
        })
      ]);
      controller.set('stepConfigs', controller.createServiceConfig(configs));
    });

    it('configuration errors are absent, submit should be not disabled', function() {
      expect(controller.get('stepConfigs')[0].get('errorCount')).to.be.equal(0);
      expect(controller.get('isSubmitDisabled')).to.be.false;
    });

    it('config has invalid value, submit should be disabled', function() {
      var serviceConfig = controller.get('stepConfigs')[0];
      serviceConfig.get('configs').findProperty('name', 'prop1').set('value', '');
      serviceConfig.setActivePropertiesOnce();
      serviceConfig.setConfigsWithErrorsOnce();
      expect(serviceConfig.get('errorCount')).to.be.equal(1);
      expect(controller.get('isSubmitDisabled')).to.be.true;
    });
  });

  describe('#createServiceConfig', function() {
    var controller = App.KerberosWizardStep4Controller.create({});
    it('should create instance of App.ServiceConfig', function() {
      var configs = controller.createServiceConfig([], []);
      expect(configs).to.have.property('length').equal(2);
      expect(configs[0]).to.be.instanceof(App.ServiceConfig);
      expect(configs[1]).to.be.instanceof(App.ServiceConfig);
    });
  });

  describe('#prepareConfigProperties', function() {

    var properties = Em.A([
      Em.Object.create({ name: 'realm', value: '', serviceName: 'Cluster' }),
      Em.Object.create({ name: 'spnego_keytab', value: 'spnego_keytab_value', serviceName: 'Cluster' }),
      Em.Object.create({ name: 'hdfs_keytab', value: '', serviceName: 'HDFS', identityType: 'user', observesValueFrom: 'spnego_keytab' }),
      Em.Object.create({ name: 'falcon_keytab', value: 'falcon_keytab_value', serviceName: 'FALCON' }),
      Em.Object.create({ name: 'mapreduce_keytab', value: 'mapreduce_keytab_value', serviceName: 'MAPREDUCE2' }),
      Em.Object.create({ name: 'hdfs_principal', value: 'hdfs_principal_value', identityType: 'user', serviceName: 'HDFS' }),
      Em.Object.create({ name: 'hadoop.security.auth_to_local', serviceName: 'HDFS' }),
      App.ServiceConfigProperty.create({ name: 'null_value', serviceName: 'HDFS', value: null, isVisible: true }),
      App.ServiceConfigProperty.create({ name: 'null_value_observed_value_ok', serviceName: 'HDFS', value: null, isVisible: false, observesValueFrom: 'spnego_keytab' })
    ]);

    var propertyValidationCases = [
      {
        property: 'spnego_keytab',
        e: [
          { key: 'category', value: 'Global' },
          { key: 'observesValueFrom', absent: true }
        ]
      },
      {
        property: 'realm',
        e: [
          { key: 'category', value: 'Global' },
          { key: 'value', value: 'realm_value' }
        ]
      },
      {
        property: 'hdfs_keytab',
        e: [
          { key: 'category', value: 'Ambari Principals' },
          { key: 'value', value: 'spnego_keytab_value' },
          { key: 'observesValueFrom', value: 'spnego_keytab' }
        ]
      },
      {
        property: 'hadoop.security.auth_to_local',
        e: [
          { key: 'displayType', value: 'multiLine' }
        ]
      },
      {
        property: 'null_value',
        e: [
          { key: 'isVisible', value: false }
        ]
      },
      {
        property: 'null_value_observed_value_ok',
        e: [
          { key: 'isVisible', value: true }
        ]
      }
    ];

    var absentPropertiesTest = ['falcon_keytab', 'mapreduce_keytab'];

    before(function() {
      var controller = App.KerberosWizardStep4Controller.create({
        wizardController: {
          content: {
            serviceConfigProperties: Em.A([
              Em.Object.create({ name: 'realm', value: 'realm_value' })
            ])
          },
          loadCachedStepConfigValues: function() {
            return null;
          }
        }
      });
      sinon.stub(App.Service, 'find').returns(Em.A([
        { serviceName: 'HDFS' }
      ]));
      sinon.stub(App.configsCollection, 'getAll').returns([
        {
          name: 'hadoop.security.auth_to_local',
          displayType: 'multiLine'
        }
      ]);
      sinon.stub(App.router, 'get').withArgs('mainAdminKerberosController.isManualKerberos').returns(false);
      this.result = controller.prepareConfigProperties(properties);
    });

    after(function() {
      App.Service.find.restore();
      App.configsCollection.getAll.restore();
      App.router.get.restore();
    });

    it('should contains properties only for installed services', function() {
      expect(this.result.mapProperty('serviceName').uniq()).to.be.eql(['Cluster', 'HDFS']);
    });

    absentPropertiesTest.forEach(function(item) {
      it('property `{0}` should be absent'.format(item), function() {
        expect(this.result.findProperty('name', item)).to.be.undefined;
      });
    }, this);

    propertyValidationCases.forEach(function(test) {
      it('property {0} should be created'.format(test.property), function() {
        expect(this.result.findProperty('name', test.property)).to.be.ok;
      });
      test.e.forEach(function(expected) {
        it('property `{0}` should have `{1}` with value `{2}`'.format(test.property, expected.key, expected.value), function() {
          if (!!expected.absent) {
            expect(this.result.findProperty('name', test.property)).to.not.have.deep.property(expected.key);
          } else {
            expect(this.result.findProperty('name', test.property)).to.have.deep.property(expected.key, expected.value);
          }
        }, this);
      }, this);
    });
  });

  describe('#setStepConfigs', function() {
    describe('Add Service Wizard', function() {

      var properties = Em.A([
        Em.Object.create({ name: 'realm', value: '', serviceName: 'Cluster' }),
        Em.Object.create({ name: 'spnego_keytab', value: 'spnego_keytab_value', serviceName: 'Cluster', isEditable: true }),
        Em.Object.create({ name: 'hdfs_keytab', value: '', serviceName: 'HDFS', observesValueFrom: 'spnego_keytab', isEditable: true }),
        Em.Object.create({ name: 'falcon_keytab', value: 'falcon_keytab_value', serviceName: 'FALCON', isEditable: true }),
        Em.Object.create({ name: 'mapreduce_keytab', value: 'mapreduce_keytab_value', serviceName: 'MAPREDUCE2', isEditable: true })
      ]);

      var res;
      var controller;
      before(function() {
        sinon.stub(App.StackService, 'find').returns([
          Em.Object.create({
            serviceName: 'KERBEROS',
            configCategories: [],
            configTypeList: []
          }),
          Em.Object.create({
            serviceName: 'HDFS',
            configCategories: [],
            configTypeList: []
          }),
          Em.Object.create({
            serviceName: 'MAPREDUCE2',
            configTypeList: []
          })
        ]);
        sinon.stub(App.Service, 'find').returns([
          Em.Object.create({
            serviceName: 'HDFS'
          }),
          Em.Object.create({
            serviceName: 'KERBEROS'
          })
        ]);
        controller = App.KerberosWizardStep4Controller.create({
          selectedServiceNames: ['FALCON', 'MAPREDUCE2'],
          installedServiceNames: ['HDFS', 'KERBEROS'],
          wizardController: Em.Object.create({
            name: 'addServiceController',
            getDBProperty: function() {
              return Em.A([
                Em.Object.create({ name: 'realm', value: 'realm_value' })
              ]);
            },
            loadCachedStepConfigValues : function() {
              return null;
            }
          })
        });
        sinon.stub(App.router, 'get').withArgs('mainAdminKerberosController.isManualKerberos').returns(false);
        var stepConfigs = controller.setStepConfigs(properties);
        res = stepConfigs[0].get('configs').concat(stepConfigs[1].get('configs'));
      });

      Em.A([
        { name: 'spnego_keytab', e: false },
        { name: 'falcon_keytab', e: true },
        { name: 'hdfs_keytab', e: false },
        { name: 'mapreduce_keytab', e: true }
      ]).forEach(function(test) {
        it('Add Service: property `{0}` should be {1} editable'.format(test.name, !!test.e ? '' : 'not '), function() {
          expect(res.findProperty('name', test.name).get('isEditable')).to.eql(test.e);
        });
      });

      after(function() {
        controller.destroy();
        controller = null;
        App.StackService.find.restore();
        App.Service.find.restore();
        App.router.get.restore();
      });
    });
  });

  describe("#createCategoryForServices()", function() {
    var controller = App.KerberosWizardStep4Controller.create({
      wizardController: {
        name: 'addServiceController'
      }
    });
    beforeEach(function() {
      sinon.stub(App.Service, 'find').returns([
        Em.Object.create({
          serviceName: 'HDFS',
          displayName: 'HDFS'
        })
      ]);
      sinon.stub(App.StackService, 'find').returns([
        Em.Object.create({
          serviceName: 'HDFS',
          displayName: 'HDFS',
          isInstalled: true
        }),
        Em.Object.create({
          serviceName: 'MAPREDUCE2',
          displayName: 'MapReduce 2',
          isInstalled: false,
          isSelected: true
        })
      ]);
    });

    afterEach(function() {
      App.Service.find.restore();
      App.StackService.find.restore();
    });

    it('for add service', function() {
      expect(controller.createCategoryForServices()).to.eql([App.ServiceConfigCategory.create({ name: 'HDFS', displayName: 'HDFS', collapsedByDefault: true}),
        App.ServiceConfigCategory.create({ name: 'MAPREDUCE2', displayName: 'MapReduce 2', collapsedByDefault: true})]);
    });

    it('for kerberos wizard', function() {
      controller.set('wizardController.name', 'KerberosWizard');
      expect(controller.createCategoryForServices()).to.eql([App.ServiceConfigCategory.create({ name: 'HDFS', displayName: 'HDFS', collapsedByDefault: true})]);
    });
  });

  describe('#loadStep', function() {
    var controller;
    describe('skip "Configure Identities" step. ', function() {
      beforeEach(function() {
        controller = App.KerberosWizardStep4Controller.create({});
        this.wizardController = App.AddServiceController.create({});
        controller.set('wizardController', this.wizardController);
        sinon.stub(controller, 'clearStep').returns(true);
        sinon.stub(controller, 'getDescriptor').returns({ then: function() { return { always: function() {}}}});
        sinon.stub(controller, 'setStepConfigs').returns(true);
        sinon.stub(App.router, 'send').withArgs('next');
      });

      afterEach(function() {
        controller.clearStep.restore();

        controller.setStepConfigs.restore();
        App.router.send.restore();
      });

      var tests = [
        {
          securityEnabled: true,
          stepSkipped: false
        },
        {
          securityEnabled: false,
          stepSkipped: true
        }
      ];

      tests.forEach(function(test) {
        var message = 'Security {0} configure identities step should be {1}'.format(!!test.securityEnabled ? 'enabled' : 'disabled', !!test.stepSkipped ? 'skipped' : 'not skipped');
        describe(message, function() {

          beforeEach(function () {
            sinon.stub(App, 'get').withArgs('isKerberosEnabled').returns(test.securityEnabled);
            this.wizardController.checkSecurityStatus();
            controller.loadStep();
          });

          afterEach(function () {
            App.get.restore();
          });

          it('`send` is ' + (test.stepSkipped ? '' : 'not') + ' called with `next`', function () {
            expect(App.router.send.calledWith('next')).to.be.eql(test.stepSkipped);
          });

        });
      }, this);

      it('step should not be disabled for Add Kerberos wizard', function() {
        controller.set('wizardController', App.KerberosWizardController.create({}));
        controller.loadStep();
        expect(App.router.send.calledWith('next')).to.be.false;
      });
    });
  });

  describe('#mergeDescriptorToConfigurations', function() {
    var genAppConfigProperty = function(name, fileName, value) {
      return App.ServiceConfigProperty.create({
        name: name,
        filename: fileName,
        value: value
      });
    };

    var genPropertyCollection = function(configsList) {
      return configsList.map(function(i) {
        return genAppConfigProperty.apply(undefined, i);
      });
    };

    var genConfigType = function(fileName, properties) {
      var configTypeObj = {};
      configTypeObj.type = fileName;
      configTypeObj.properties = properties.reduce(function(p, _c) {
        p[_c[0]] = _c[1];
        return p;
      }, {});
      return configTypeObj;
    };

    var genConfigTypeCollection = function(coll) {
      return coll.map(function(i) {
        return genConfigType(i[0], i[1]);
      });
    };

    var cases = [
      {
        kerberosDescriptor: genPropertyCollection([]),
        configurations: [],
        e: [],
        m: 'should return empty array'
      },
      {
        kerberosDescriptor: genPropertyCollection([
          ['hadoop.proxy.group', 'hadoop-env', 'val1']
        ]),
        configurations: genConfigTypeCollection([
          ['hadoop-env', [
           ['hadoop.proxy.group', 'change_me'],
           ['hadoop.proxy', 'val2']
          ]],
          ['core-site', [
            ['hadoop.proxyuser.hcat.groups', '*']
          ]]
        ]),
        e: [
          {
            type: 'hadoop-env',
            properties: {
              'hadoop.proxy.group': 'val1',
              'hadoop.proxy': 'val2'
            }
          },
          {
            type: 'core-site',
            properties: {
              'hadoop.proxyuser.hcat.groups': '*'
            }
          }
        ],
        m: 'should change value of `hadoop.proxy.group`, rest object should not be changed.'
      },
      {
        kerberosDescriptor: genPropertyCollection([
          ['hadoop.proxy.group', 'hadoop-env', 'val1'],
          ['new_site_prop', 'core-site', 'new_val']
        ]),
        configurations: genConfigTypeCollection([
          ['hadoop-env', [
            ['hadoop.proxy.group', 'val1'],
            ['hadoop.proxy', 'val2']
          ]],
          ['core-site', [
            ['hadoop.proxyuser.hcat.groups', '*']
          ]]
        ]),
        e: [
          {
            type: 'hadoop-env',
            properties: {
              'hadoop.proxy.group': 'val1',
              'hadoop.proxy': 'val2'
            }
          },
          {
            type: 'core-site',
            properties: {
              'hadoop.proxyuser.hcat.groups': '*',
              'new_site_prop': 'new_val'
            }
          }
        ],
        m: 'should add property `new_site_prop` value to `core-site` file type, rest object should not be changed.'
      }
    ];

    cases.forEach(function(test) {
      it(test.m, function() {
        var toObj = function(res) {
          return JSON.parse(JSON.stringify(res));
        };
        expect(toObj(c.mergeDescriptorToConfigurations(test.configurations, test.kerberosDescriptor))).to.be.eql(test.e);
      });
    });
  });

  describe('#groupRecommendationProperties', function() {
    var cases, controller;
    beforeEach(function() {
      controller = App.KerberosWizardStep4Controller.create({});
    });

    afterEach(function() {
      controller.destroy();
      controller = null;
    });

    cases = [
      {
        recommendedConfigurations: {},
        servicesConfigurations: [],
        allConfigs: [],
        m: 'empty objects should not fail the code',
        e: {
          add: {},
          update: {},
          delete: {}
        }
      },
      {
        recommendedConfigurations: {
          'some-site': {
            properties: {
              // property absent from servicesConfigurations and allConfigs
              // should be added
              'new_prop1': 'val1',
              // property present in servicesConfigurations but absent in  allConfigs
              // should be skipped
              'new_prop2': 'val2',
              'existing-prop': 'updated_val2'
            },
            property_attributes: {
              'delete_prop1': {
                'delete': true
              }
            }
          }
        },
        servicesConfigurations: [
          {
            type: 'some-site',
            properties: {
              'existing-prop': 'val2',
              'new_prop2': 'val2'
            }
          }
        ],
        allConfigs: [
          Em.Object.create({ name: 'existing-prop', value: 'val3', filename: 'some-site'}),
          Em.Object.create({ name: 'delete_prop1', value: 'val', filename: 'some-site'})
        ],
        m: 'should add "new_prop1", remove "delete_prop1", skip adding "new_prop2" and update value for "existing-prop"',
        e: {
          update: {
            'some-site': {
              'existing-prop': 'updated_val2'
            }
          },
          add: {
            'some-site': {
              'new_prop1': 'val1'
            }
          },
          delete: {
            'some-site': {
              'delete_prop1': ''
            }
          }
        }
      }
    ];

    cases.forEach(function(test) {
      it(test.m, function() {
        expect(controller.groupRecommendationProperties(test.recommendedConfigurations, test.servicesConfigurations, test.allConfigs))
          .to.be.eql(test.e);
      });
    });
  });

  describe("#getDescriptor()", function () {
    var mock = {
      then: Em.K
    };

    beforeEach(function() {
      c.reopen({
        isWithinAddService: true,
        selectedServiceNames: []
      });
      sinon.stub(c, 'storeClusterDescriptorStatus');
      sinon.stub(c, 'loadClusterDescriptorConfigs').returns(mock);
      sinon.stub(mock, 'then');
    });

    afterEach(function() {
      c.loadClusterDescriptorConfigs.restore();
      c.storeClusterDescriptorStatus.restore();
      mock.then.restore();
    });

    it("App.ajax.send should be called", function() {
      c.getDescriptor();
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberize.cluster_descriptor_artifact');
      expect(args[0]).to.be.eql({
        sender: c,
        name: 'admin.kerberize.cluster_descriptor_artifact'
      });
    });

    it("storeClusterDescriptorStatus should be called", function() {
      c.getDescriptor();
      expect(c.storeClusterDescriptorStatus.calledOnce).to.be.true;
    });

    it("loadClusterDescriptorConfigs should be called", function() {
      c.getDescriptor();
      expect(c.loadClusterDescriptorConfigs.calledOnce).to.be.true;
    });

    it("then should be called", function() {
      c.getDescriptor();
      expect(mock.then.calledOnce).to.be.true;
    });

    it("then should be called, isWithinAddService is false", function() {
      c.set('isWithinAddService', false);
      c.getDescriptor();
      expect(mock.then.calledOnce).to.be.true;
    });
  });

  describe("#tweakConfigProperty()", function () {

    beforeEach(function() {
      this.mock = sinon.stub(App.HostComponent, 'find');
    });

    afterEach(function() {
      this.mock.restore();
    });

    it("config value should not be set", function() {
      this.mock.returns([
        Em.Object.create({
          componentName: 'HIVE_METASTORE',
          hostName: 'host1'
        })
      ]);
      var config = Em.Object.create({
        name: 'templeton.hive.properties',
        value: 'thrift://host1:9000\,,',
        recommendedValue: ''
      });
      c.tweakConfigProperty(config);
      expect(config.get('value')).to.be.equal('thrift://host1:9000\,,');
      expect(config.get('recommendedValue')).to.be.equal('');
    });

    it("config value should be set", function() {
      this.mock.returns([
        Em.Object.create({
          componentName: 'HIVE_METASTORE',
          hostName: 'host1'
        }),
        Em.Object.create({
          componentName: 'HIVE_METASTORE',
          hostName: 'host2'
        })
      ]);
      var config = Em.Object.create({
        name: 'templeton.hive.properties',
        value: 'thrift://host1:9000\,,'
      });
      c.tweakConfigProperty(config);
      expect(config.get('value')).to.be.equal("thrift://host1:9000\\,thrift://host2:9000,,");
      expect(config.get('recommendedValue')).to.be.equal("thrift://host1:9000\\,thrift://host2:9000,,");
    });
  });

  describe("#spnegoPropertiesObserver()", function () {

    beforeEach(function() {
      sinon.stub(Em.run, 'once', function(context, callback) {
        callback();
      });
    });

    afterEach(function() {
      Em.run.once.restore();
    });

    it("value should not be changed", function() {
      var configProperty = Em.Object.create({
        name: 'n1',
        value: 'new',
        recommendedValue: 'new'
      });
      var config = Em.Object.create({
        observesValueFrom: 'n2',
        value: '',
        recommendedValue: ''
      });
      c.set('stepConfigs', [Em.Object.create({
        name: 'ADVANCED',
        configs: [config]
      })]);
      c.spnegoPropertiesObserver(configProperty);
      expect(config.get('value')).to.be.empty;
      expect(config.get('recommendedValue')).to.be.empty;
    });

    it("value should be changed", function() {
      var configProperty = Em.Object.create({
        name: 'n1',
        value: 'new',
        recommendedValue: 'new'
      });
      var config = Em.Object.create({
        observesValueFrom: 'n1',
        value: '',
        recommendedValue: ''
      });
      c.set('stepConfigs', [Em.Object.create({
        name: 'ADVANCED',
        configs: [config]
      })]);
      c.spnegoPropertiesObserver(configProperty);
      expect(config.get('value')).to.be.equal('new');
      expect(config.get('recommendedValue')).to.be.equal('new');
    });
  });

  describe("#submit()", function () {

    beforeEach(function() {
      sinon.stub(c, 'saveConfigurations');
      sinon.stub(App.router, 'send');
    });

    afterEach(function() {
      c.saveConfigurations.restore();
      App.router.send.restore();
    });

    it("saveConfigurations should be called", function() {
      c.submit();
      expect(c.saveConfigurations.calledOnce).to.be.true;
    });

    it("App.router.send should be called", function() {
      c.submit();
      expect(App.router.send.calledWith('next')).to.be.true;
    });
  });

  describe("#saveConfigurations()", function () {
    var mock = {
      saveKerberosDescriptorConfigs: Em.K
    };

    beforeEach(function() {
      sinon.stub(c, 'updateKerberosDescriptor');
      sinon.stub(App, 'get').returns(mock);
      sinon.spy(mock, 'saveKerberosDescriptorConfigs');
      c.set('kerberosDescriptor', {});
      c.set('stepConfigs', [
        Em.Object.create({
          configs: [{}]
        }),
        Em.Object.create({
          configs: [{}]
        })
      ]);
      c.saveConfigurations();
    });

    afterEach(function() {
      c.updateKerberosDescriptor.restore();
      App.get.restore();
      mock.saveKerberosDescriptorConfigs.restore();
    });

    it("updateKerberosDescriptor should be called", function() {
      expect(c.updateKerberosDescriptor.calledWith({}, [{}, {}])).to.be.true;
    });

    it("saveKerberosDescriptorConfigs should be called", function() {
      expect(mock.saveKerberosDescriptorConfigs.calledWith({})).to.be.true;
    });
  });

  describe("#loadServerSideConfigsRecommendations()", function () {

    it("App.ajax.send should be called", function() {
      c.loadServerSideConfigsRecommendations([]);
      var args = testHelpers.findAjaxRequest('name', 'config.recommendations');
      expect(args[0]).to.be.exists;
    });
  });

  describe("#applyServiceConfigs()", function () {

    it("isRecommendedLoaded should be true", function() {
      c.applyServiceConfigs([Em.Object.create({configGroups: []})]);
      expect(c.get('isRecommendedLoaded')).to.be.true;
    });

    it("selectedService should be set", function() {
      c.applyServiceConfigs([Em.Object.create({configGroups: []})]);
      expect(c.get('selectedService')).to.be.eql(Em.Object.create({configGroups: []}));
    });
  });

  describe("#bootstrapRecommendationPayload()", function () {

    beforeEach(function() {
      sinon.stub(c, 'getServicesConfigurations').returns({
        then: function(callback) {
          callback([{}]);
        }
      });
      sinon.stub(c, 'getBlueprintPayloadObject').returns({blueprint: {
        configurations: []
      }});
      c.bootstrapRecommendationPayload({});
    });

    afterEach(function() {
      c.getServicesConfigurations.restore();
      c.getBlueprintPayloadObject.restore();
    });

    it("getServicesConfigurations should be called", function() {
      expect(c.getServicesConfigurations.calledOnce).to.be.true;
    });

    it("getBlueprintPayloadObject should be called", function() {
      expect(c.getBlueprintPayloadObject.calledWith([{}], {})).to.be.true;
    });

    it("servicesConfigurations should be set", function() {
      expect(c.get('servicesConfigurations')).to.be.eql([{}]);
    });

    it("initialConfigValues should be set", function() {
      expect(c.get('initialConfigValues')).to.be.eql([]);
    });
  });

  describe("#getBlueprintPayloadObject()", function () {

    beforeEach(function() {
      sinon.stub(c, 'mergeDescriptorToConfigurations').returns([{
        type: 't1',
        properties: []
      }]);
      sinon.stub(c, 'createServicesStackDescriptorConfigs');
    });

    afterEach(function() {
      c.createServicesStackDescriptorConfigs.restore();
      c.mergeDescriptorToConfigurations.restore();
    });

    it("should return recommendations", function () {
      c.reopen({
        hostGroups: {
          blueprint: {
            configurations: []
          }
        }
      });
      expect(c.getBlueprintPayloadObject([], {})).to.be.eql({
        "blueprint": {
          "host_groups": [],
          "configurations": {
            "t1": {
              "properties": []
            }
          }
        },
        "blueprint_cluster_binding": {
          "host_groups": []
        }
      });
    });
  });

  describe("#getServicesConfigObject()", function () {

    it("should return ADVANCED step config", function() {
      c.set('stepConfigs', [{name: 'ADVANCED'}]);
      expect(c.getServicesConfigObject()).to.be.eql({name: 'ADVANCED'});
    });
  });

  describe("#getServiceByFilename()", function () {

    beforeEach(function() {
      this.mockService = sinon.stub(App.Service, 'find');
      sinon.stub(App.StackService, 'find').returns([
        Em.Object.create({
          serviceName: 'S1',
          configTypes: {
            site1: {}
          }
        })
      ]);
    });

    afterEach(function() {
      this.mockService.restore();
      App.StackService.find.restore();
    });

    it("should return 'HDFS' ", function() {
      this.mockService.returns([{serviceName: 'HDFS'}]);
      expect(c.getServiceByFilename('core-site')).to.be.equal('HDFS');
    });

    it("should return 'S1' ", function() {
      expect(c.getServiceByFilename('site1')).to.be.equal('S1');
    });

    it("should return empty", function() {
      expect(c.getServiceByFilename('site2')).to.be.empty;
    });
  });
});

});

require.register("test/controllers/main/admin/kerberos/step5_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');
var stringUtils = require('utils/string_utils');
var fileUtils = require('utils/file_utils');

describe('App.KerberosWizardStep5Controller', function() {
  var c;
  beforeEach(function () {
    c = App.KerberosWizardStep5Controller.create({});
  });

  describe('#prepareCSVData', function () {

    it('should split data', function () {
      var data = [
        'a,b,c',
        'd,e',
        '1,2,3,4'
      ];

      var result = c.prepareCSVData(data);
      expect(result).to.be.eql([['a', 'b', 'c'], ['d', 'e'], ['1', '2', '3', '4']]);
    });
  });

  describe("#submit()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'send');
    });

    afterEach(function() {
      App.router.send.restore();
    });

    it("App.router.send should be called", function() {
      c.submit();
      expect(App.router.send.calledWith('next')).to.be.true;
    });
  });

  describe("#getCSVData()", function () {

    it("App.ajax.send should be called", function() {
      c.getCSVData(true);
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos.cluster.csv');
      expect(args[0]).to.be.eql({
        name: 'admin.kerberos.cluster.csv',
        sender: c,
        data: {
          'skipDownload': true
        },
        success: 'getCSVDataSuccessCallback',
        error: 'getCSVDataSuccessCallback'
      });
    });
  });

  describe("#getCSVDataSuccessCallback()", function () {

    beforeEach(function() {
      sinon.stub(fileUtils, 'downloadTextFile');
      sinon.stub(stringUtils, 'arrayToCSV').returns('arrayToCSV');
      sinon.stub(c, 'prepareCSVData').returns('csvData');
      c.getCSVDataSuccessCallback("a\nb", {}, {skipDownload: false});
    });

    afterEach(function() {
      fileUtils.downloadTextFile.restore();
      stringUtils.arrayToCSV.restore();
      c.prepareCSVData.restore();
    });

    it("csvData should be set", function() {
      expect(c.get('csvData')).to.be.equal('csvData');
    });

    it("fileUtils.downloadTextFile should be called", function() {
      expect(fileUtils.downloadTextFile.calledWith('arrayToCSV', 'csv', 'kerberos.csv')).to.be.true;
    });
  });

  describe("#postKerberosDescriptor()", function () {

    it("App.ajax.send should be called", function() {
      c.postKerberosDescriptor('kerberosDescriptor');
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos.cluster.artifact.create');
      expect(args[0]).to.be.eql({
        name: 'admin.kerberos.cluster.artifact.create',
        sender: c,
        data: {
          artifactName: 'kerberos_descriptor',
          data: {
            artifact_data: 'kerberosDescriptor'
          }
        }
      });
    });
  });

  describe("#putKerberosDescriptor()", function () {

    it("App.ajax.send should be called", function() {
      c.putKerberosDescriptor('kerberosDescriptor');
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos.cluster.artifact.update');
      expect(args[0]).to.be.eql({
        name: 'admin.kerberos.cluster.artifact.update',
        sender: c,
        data: {
          artifactName: 'kerberos_descriptor',
          data: {
            artifact_data: 'kerberosDescriptor'
          }
        },
        success: 'unkerberizeCluster',
        error: 'unkerberizeCluster'
      });
    });
  });

  describe("#unkerberizeCluster()", function () {

    it("App.ajax.send should be called", function() {
      c.unkerberizeCluster();
      var args = testHelpers.findAjaxRequest('name', 'admin.unkerberize.cluster');
      expect(args[0]).to.be.eql({
        name: 'admin.unkerberize.cluster',
        sender: c,
        success: 'goToNextStep',
        error: 'goToNextStep'
      });
    });
  });

  describe("#goToNextStep()", function () {

    beforeEach(function() {
      sinon.stub(c, 'clearStage');
      sinon.stub(App.router, 'transitionTo');
      c.goToNextStep();
    });

    afterEach(function() {
      c.clearStage.restore();
      App.router.transitionTo.restore();
    });

    it("clearStage should be called", function() {
      expect(c.clearStage.calledOnce).to.be.true;
    });

    it("App.router.transitionTo should be called", function() {
      expect(App.router.transitionTo.calledWith('step5')).to.be.true;
    });
  });

  describe("#confirmProperties", function () {

    beforeEach(function() {
      this.mock = sinon.stub(App.router, 'get');
    });

    afterEach(function() {
      this.mock.restore();
    });

    it("should return properties", function() {
      this.mock.returns(Em.Object.create({
        content: {
          kerberosOption: Em.I18n.t('admin.kerberos.wizard.step1.option.kdc'),
          serviceConfigProperties: [{name: 'kdc_type'}]
        }
      }));
      c.propertyDidChange('confirmProperties');
      expect(c.get('confirmProperties')).to.be.eql([
        {
          name: 'kdc_type',
          label: Em.I18n.t('admin.kerberos.wizard.step5.kdc_type.label')
        }
      ]);
    });

    it("should return empty properties", function() {
      this.mock.returns(Em.Object.create({
        content: {
          kerberosOption: null,
          serviceConfigProperties: [{name: 'kdc_type'}]
        }
      }));
      c.propertyDidChange('confirmProperties');
      expect(c.get('confirmProperties')).to.be.empty;
    });
  });
});
});

require.register("test/controllers/main/admin/kerberos/step6_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

describe('App.KerberosWizardStep6Controller', function() {
  var controller;

  beforeEach(function() {
    controller = App.KerberosWizardStep6Controller.create({ commands: ['stopServices'] });
  });


  describe('#checkComponentsRemoval', function() {

    afterEach(function () {
      Em.tryInvoke(App.get, 'restore');
      Em.tryInvoke(App.Service.find, 'restore');
      Em.tryInvoke(App.HostComponent.find, 'restore');
    });

    var tests = [
      { yarnInstalled: true, doesATSSupportKerberos: false, commands: ['stopServices', 'deleteATS'], ATSInstalled: true},
      { yarnInstalled: false, doesATSSupportKerberos: true, commands: ['stopServices'], ATSInstalled: true},
      { yarnInstalled: false, doesATSSupportKerberos: false, commands: ['stopServices'], ATSInstalled: true},
      { yarnInstalled: true, doesATSSupportKerberos: true, commands: ['stopServices'], ATSInstalled: false},
      { yarnInstalled: true, doesATSSupportKerberos: true, commands: ['stopServices'], ATSInstalled: true}
    ];

    tests.forEach(function(test) {
      var message = 'YARN installed: {0}, ATS supported: {1} list of commands should be {2}'.format(test.yarnInstalled, test.doesATSSupportKerberos, test.commands.toString());
      describe(message, function () {
        beforeEach(function () {
          sinon.stub(App, 'get').withArgs('doesATSSupportKerberos').returns(test.doesATSSupportKerberos);
          sinon.stub(App.Service, 'find').returns(test.yarnInstalled ? [Em.Object.create({serviceName: 'YARN'})] : []);
          sinon.stub(App.HostComponent, 'find').returns(test.ATSInstalled ? [Em.Object.create({componentName: 'APP_TIMELINE_SERVER'})] : []);
          controller.checkComponentsRemoval();
        });

        it('commands are valid', function () {
          expect(controller.get('commands').toArray()).to.eql(test.commands);
        });

      });
    });
  });


  describe("#stopServices()", function () {

    it("App.ajax.send should be called", function() {
      controller.stopServices();
      var args = testHelpers.findAjaxRequest('name', 'common.services.update');
      expect(args[0]).to.be.eql({
        name: 'common.services.update',
        data: {
          context: "Stop services",
          "ServiceInfo": {
            "state": "INSTALLED"
          }
        },
        sender: controller,
        success: 'startPolling',
        error: 'onTaskError'
      });
    });
  });

  describe("#loadStep()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'checkComponentsRemoval');
    });

    afterEach(function() {
      controller.checkComponentsRemoval.restore();
    });

    it("loadStep should be called", function() {
      controller.loadStep();
      expect(controller.checkComponentsRemoval.calledOnce).to.be.true;
    });
  });

  describe("#deleteATS()", function () {

    beforeEach(function() {
      sinon.stub(App.HostComponent, 'find').returns([Em.Object.create({
        componentName: 'APP_TIMELINE_SERVER',
        hostName: 'host1'
      })]);
    });

    afterEach(function() {
      App.HostComponent.find.restore();
    });

    it("deleteATS should be called", function() {
      controller.deleteATS();
      var args = testHelpers.findAjaxRequest('name', 'common.delete.host_component');
      expect(args[0]).to.be.eql({
        name: 'common.delete.host_component',
        sender: controller,
        data: {
          componentName: 'APP_TIMELINE_SERVER',
          hostName: 'host1'
        },
        success: 'onDeleteATSSuccess',
        error: 'onDeleteATSError'
      });
    });
  });

  describe("#onDeleteATSSuccess", function () {

    beforeEach(function() {
      sinon.stub(controller, 'onTaskCompleted');
    });

    afterEach(function() {
      controller.onTaskCompleted.restore();
    });

    it("onDeleteATSSuccess should be called", function() {
      controller.onDeleteATSSuccess();
      expect(controller.onTaskCompleted.calledOnce).to.be.true;
    });
  });

  describe("#onDeleteATSError()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'onDeleteATSSuccess');
    });

    afterEach(function() {
      controller.onDeleteATSSuccess.restore();
    });

    it("onDeleteATSSuccess should not be called", function() {
      controller.onDeleteATSError({responseText: ""});
      expect(controller.onDeleteATSSuccess.called).to.be.false;
    });

    it("onDeleteATSSuccess should be called", function() {
      controller.onDeleteATSError({responseText: "org.apache.ambari.server.controller.spi.NoSuchResourceException"});
      expect(controller.onDeleteATSSuccess.calledOnce).to.be.true;
    });
  });

});

});

require.register("test/controllers/main/admin/kerberos/step7_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

function getController() {
  return App.KerberosWizardStep7Controller.create({});
}

describe('App.KerberosWizardStep7Controller', function () {
  var controller;

  beforeEach(function () {
    controller = getController();
  });

  describe("#setRequest()", function () {

    beforeEach(function () {
      sinon.stub(controller, 'clearStage');
      sinon.stub(controller, 'loadStep');
    });

    afterEach(function () {
      controller.clearStage.restore();
      controller.loadStep.restore();
    });

    it("request should be set", function () {
      controller.setRequest(true);
      expect(controller.get('request')).to.be.eql({
        name: 'KERBERIZE_CLUSTER',
        ajaxName: 'admin.kerberize.cluster.force'
      });
    });

    it("clearStage should be called", function () {
      controller.setRequest(true);
      expect(controller.clearStage.calledOnce).to.be.true;
    });

    it("loadStep should be called", function () {
      controller.setRequest(true);
      expect(controller.loadStep.calledOnce).to.be.true;
    });

    it("kerberize request should be set", function () {
      controller.setRequest(false);
      expect(controller.get('request')).to.be.eql({
        name: 'KERBERIZE_CLUSTER',
        ajaxName: 'admin.kerberize.cluster',
        ajaxData: {
          data: {
            Clusters: {
              security_type: "KERBEROS"
            }
          }
        }
      });
    });
  });

  describe("#unkerberizeCluster()", function () {

    it("App.ajax.send should be called", function () {
      controller.unkerberizeCluster();
      var args = testHelpers.findAjaxRequest('name', 'admin.unkerberize.cluster');
      expect(args[0]).to.be.eql({
        name: 'admin.unkerberize.cluster',
        sender: controller,
        success: 'goToNextStep',
        error: 'goToNextStep'
      });
    });
  });

  describe("#goToNextStep()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'clearStage');
      sinon.stub(App.router, 'transitionTo');
      controller.goToNextStep();
    });

    afterEach(function() {
      controller.clearStage.restore();
      App.router.transitionTo.restore();
    });

    it("clearStage should be called", function() {
      expect(controller.clearStage.calledOnce).to.be.true;
    });

    it("App.router.transitionTo should be called", function() {
      expect(App.router.transitionTo.calledWith('step7')).to.be.true;
    });
  });

  describe("#postKerberosDescriptor()", function () {

    it("App.ajax.send should be called", function () {
      controller.postKerberosDescriptor(true);
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos.cluster.artifact.create');
      expect(args[0]).to.be.eql({
        name: 'admin.kerberos.cluster.artifact.create',
        sender: controller,
        data: {
          artifactName: 'kerberos_descriptor',
          data: {
            artifact_data: true
          }
        }
      });
    });
  });

  describe("#putKerberosDescriptor()", function () {

    it("App.ajax.send should be called", function () {
      controller.putKerberosDescriptor(true);
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos.cluster.artifact.update');
      expect(args[0]).to.be.eql({
        name: 'admin.kerberos.cluster.artifact.update',
        sender: controller,
        data: {
          artifactName: 'kerberos_descriptor',
          data: {
            artifact_data: true
          }
        },
        success: 'unkerberizeCluster',
        error: 'unkerberizeCluster'
      });
    });
  });

  describe("#retry()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'removeObserver');
      sinon.stub(controller, 'setRequest');
      controller.set('tasks', [Em.Object.create()]);
      controller.retry();
    });

    afterEach(function() {
      controller.removeObserver.restore();
      controller.setRequest.restore();
    });

    it("showRetry should be false", function() {
      expect(controller.get('showRetry')).to.be.false;
    });

    it("removeObserver should be called", function() {
      expect(controller.removeObserver.calledWith('tasks.@each.status', controller, 'onTaskStatusChange')).to.be.true;
    });

    it("status should be IN_PROGRESS", function() {
      expect(controller.get('status')).to.be.equal('IN_PROGRESS');
    });

    it("tasks status should be PENDING", function() {
      expect(controller.get('tasks').mapProperty('status')).to.be.eql(['PENDING']);
    });

    it("setRequest should be called", function() {
      expect(controller.setRequest.calledWith(true)).to.be.true;
    });
  });

  describe("#enableDisablePreviousSteps()", function () {
    var mock = {
      enableStep: Em.K,
      setLowerStepsDisable: Em.K
    };

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns(mock);
      sinon.stub(mock, 'setLowerStepsDisable');
      sinon.stub(mock, 'enableStep');
    });

    afterEach(function() {
      App.router.get.restore();
      mock.enableStep.restore();
      mock.setLowerStepsDisable.restore();
    });

    it("FAILED tasks", function() {
      controller.set('tasks', [{status: 'FAILED'}]);
      controller.enableDisablePreviousSteps();
      expect(controller.get('isBackButtonDisabled')).to.be.false;
      expect(mock.enableStep.calledWith(4)).to.be.true;
    });

    it("COMPLETED tasks", function() {
      controller.set('tasks', [{status: 'COMPLETED'}]);
      controller.enableDisablePreviousSteps();
      expect(controller.get('isBackButtonDisabled')).to.be.true;
      expect(mock.setLowerStepsDisable.calledWith(6)).to.be.true;
    });
  });
});

});

require.register("test/controllers/main/admin/kerberos/step8_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

function getController() {
  return App.KerberosWizardStep8Controller.create({});
}

describe('App.KerberosWizardStep8Controller', function() {
  var controller;

  beforeEach(function() {
    controller = getController();
  });

  describe("#startServices()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'get').returns({
        "skip.service.checks": "true"
      });
    });

    afterEach(function() {
      App.router.get.restore();
    });

    it("App.ajax.send should be called", function() {
      controller.startServices();
      var args = testHelpers.findAjaxRequest('name', 'common.services.update');
      expect(args[0]).to.be.eql({
        name: 'common.services.update',
        sender: controller,
        data: {
          "context": "Start services",
          "ServiceInfo": {
            "state": "STARTED"
          },
          urlParams: "params/run_smoke_test=false"
        },
        success: 'startPolling',
        error: 'startServicesErrorCallback'
      });
    });
  });

});

});

require.register("test/controllers/main/admin/kerberos_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

describe('App.MainAdminKerberosController', function() {

  var controller = App.MainAdminKerberosController.create({});

  App.TestAliases.testAsComputedEqual(controller, 'isManualKerberos', 'kdc_type', 'none');

  App.TestAliases.testAsComputedSomeBy(controller, 'isPropertiesChanged', 'stepConfigs', 'isPropertiesChanged', true);

  App.TestAliases.testAsComputedOr(controller, 'isSaveButtonDisabled', ['isSubmitDisabled', '!isPropertiesChanged']);

  describe('#prepareConfigProperties', function() {
    beforeEach(function() {
      sinon.stub(App.Service, 'find').returns([
        Em.Object.create({ serviceName: 'KERBEROS'}),
        Em.Object.create({ serviceName: 'HDFS' })
      ]);
      this.result = controller.prepareConfigProperties([
        Em.Object.create({ name: 'prop1', isEditable: true, serviceName: 'SERVICE1'}),
        Em.Object.create({ name: 'prop2', isEditable: true, serviceName: 'KERBEROS'}),
        Em.Object.create({ name: 'prop3', isEditable: true, serviceName: 'HDFS'}),
        Em.Object.create({ name: 'prop4', isEditable: true, serviceName: 'Cluster'}),
        Em.Object.create({ name: 'prop5', isEditable: true, serviceName: 'SERVICE1'})
      ]);
    });

    afterEach(function() {
      App.Service.find.restore();
    });

    ['prop1', 'prop5'].forEach(function(item) {
      it('property `{0}` should be absent'.format(item), function() {
        expect(this.result.findProperty('name', item)).to.be.undefined;
      });
    });

    ['prop2', 'prop3', 'prop4'].forEach(function(item) {
      it('property `{0}` should be present and not editable'.format(item), function() {
        var prop = this.result.findProperty('name', item);
        expect(prop).to.be.ok;
        expect(prop.get('isEditable')).to.be.false;
      });
    });

    describe('should take displayType from predefinedSiteProperties', function () {

      beforeEach(function () {
        sinon.stub(App.configsCollection, 'getAll').returns([
          {
            name: 'hadoop.security.auth_to_local',
            displayType: 'multiLine'
          }
        ]);
      });

      afterEach(function () {
        App.configsCollection.getAll.restore();
      });

      it('displayType is valid', function () {
        expect(controller.prepareConfigProperties([
          Em.Object.create({
            name: 'hadoop.security.auth_to_local',
            serviceName: 'HDFS'
          })
        ])[0].get('displayType')).to.equal('multiLine');
      });

    });
  });

  describe("#runSecurityCheckSuccess()", function () {
    beforeEach(function () {
      sinon.stub(App, 'showClusterCheckPopup', Em.K);
      sinon.stub(controller, 'startKerberosWizard', Em.K);
    });
    afterEach(function () {
      App.showClusterCheckPopup.restore();
      controller.startKerberosWizard.restore();
    });
    it("shows popup", function () {
      var check = { items: [{
        UpgradeChecks: {
          "check": "Work-preserving RM/NM restart is enabled in YARN configs",
          "status": "FAIL",
          "reason": "FAIL",
          "failed_on": [],
          "check_type": "SERVICE"
        }
      }]};
      controller.runSecurityCheckSuccess(check,null,{label: "name"});
      expect(controller.startKerberosWizard.called).to.be.false;
      expect(App.showClusterCheckPopup.called).to.be.true;
    });
    it("runs startKerberosWizard", function () {
      var check = { items: [{
        UpgradeChecks: {
          "check": "Work-preserving RM/NM restart is enabled in YARN configs",
          "status": "PASS",
          "reason": "OK",
          "failed_on": [],
          "check_type": "SERVICE"
        }
      }]};
      controller.runSecurityCheckSuccess(check,null,{label: "name"});
      expect(controller.startKerberosWizard.called).to.be.true;
      expect(App.showClusterCheckPopup.called).to.be.false;
    });
  });

  describe('#regenerateKeytabs()', function () {

    beforeEach(function () {
      sinon.spy(App.ModalPopup, "show");
      sinon.spy(controller, 'restartServicesAfterRegenerate');
      sinon.spy(controller, 'restartAllServices');
    });
    afterEach(function () {
      App.ModalPopup.show.restore();
      controller.restartServicesAfterRegenerate.restore();
      controller.restartAllServices.restore();
    });

    it('both confirmation popups should be displayed', function () {
      var popup = controller.regenerateKeytabs();
      expect(App.ModalPopup.show.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.restartServicesAfterRegenerate.calledOnce).to.be.true;
      expect(App.ModalPopup.show.calledTwice).to.be.true;
    });

    it('user checked regeneration only for missing host/components', function () {
      var popup = controller.regenerateKeytabs();
      popup.set('regenerateKeytabsOnlyForMissing', true);

      var popup2 = popup.onPrimary();
      popup2.set('restartComponents', true)
      popup2.onPrimary();
      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos_security.regenerate_keytabs');
      expect(args[0].data.type).to.be.equal('missing');
    });

    it('user didn\'t check regeneration only for missing host/components', function () {
      var popup = controller.regenerateKeytabs();
      popup.set('regenerateKeytabsOnlyForMissing', false);

      var popup2 = popup.onPrimary();
      popup2.set('restartComponents', true)
      popup2.onPrimary();

      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos_security.regenerate_keytabs');
      expect(args[0].data.type).to.be.equal('all');
    });

    it('user checked restart services automatically', function () {
      var popup = controller.regenerateKeytabs();
      popup.set('regenerateKeytabsOnlyForMissing', true);

      var popup2 = popup.onPrimary();
      popup2.set('restartComponents', true)
      popup2.onPrimary();

      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos_security.regenerate_keytabs');
      expect(args[0].data.withAutoRestart).to.be.true;
    });

    it('user didn\'t check restart services automatically', function () {
      var popup = controller.regenerateKeytabs();
      popup.set('regenerateKeytabsOnlyForMissing', true);

      var popup2 = popup.onPrimary();
      popup2.set('restartComponents', false)
      popup2.onPrimary();

      var args = testHelpers.findAjaxRequest('name', 'admin.kerberos_security.regenerate_keytabs');
      expect(args[0].data.withAutoRestart).to.be.false;
    });
  });

  describe('#getKDCSessionState()', function () {

    var mock = {callback: Em.K};

    beforeEach(function () {
      sinon.spy(mock, 'callback');
      sinon.stub(controller, 'getSecurityType', function (c) {
        c();
      });
    });

    afterEach(function () {
      mock.callback.restore();
      controller.getSecurityType.restore();
      Em.tryInvoke(App.get, 'restore');
    });

    [
      {
        m: 'Skip request, as securityEnabled and isKerberosEnabled are false',
        securityEnabled: false,
        isKerberosEnabled: false,
        kdc_type: 'not_none',
        result: false
      },
      {
        m: 'Skip request, as isManualKerberos is true',
        securityEnabled: true,
        isKerberosEnabled: true,
        kdc_type: 'none',
        result: false
      },
      {
        m: 'Make request',
        securityEnabled: true,
        isKerberosEnabled: true,
        kdc_type: 'not_none',
        result: true
      }
    ].forEach(function (test) {
          describe(test.m, function () {

            beforeEach(function () {
              sinon.stub(App, 'get').returns(test.isKerberosEnabled);
              controller.set('securityEnabled', test.securityEnabled);
              controller.set('kdc_type', test.kdc_type);
              controller.getKDCSessionState(mock.callback);
              this.args = testHelpers.findAjaxRequest('name', 'kerberos.session.state');
            });


            if (test.result) {
              it('callback is not called', function () {
                expect(mock.callback.calledOnce).to.be.false;
              });
              it('1 request is sent', function () {
                expect(this.args).to.exists;
              });
            }
            else {
              it('callback is called once', function () {
                expect(mock.callback.calledOnce).to.be.true;
              });
              it('no request is sent', function () {
                expect(this.args).to.not.exists;
              });
            }
          });
        });
  });

  describe('#getSecurityType()', function () {

    var mock = {callback: Em.K};

    beforeEach(function () {
      sinon.spy(mock, 'callback');
    });

    afterEach(function () {
      mock.callback.restore();
      Em.tryInvoke(App.get, 'restore');
    });

    [
      {
        m: 'Skip request, as securityEnabled and isKerberosEnabled are false',
        securityEnabled: false,
        isKerberosEnabled: false,
        kdc_type: '',
        result: false
      },
      {
        m: 'Skip request, as kdc_type exists',
        securityEnabled: true,
        isKerberosEnabled: true,
        kdc_type: 'none',
        result: false
      },
      {
        m: 'Make request',
        securityEnabled: true,
        isKerberosEnabled: true,
        kdc_type: '',
        result: true
      }
    ].forEach(function (test) {
          describe(test.m, function () {

            beforeEach(function () {
              sinon.stub(App, 'get').returns(test.isKerberosEnabled);
              controller.set('securityEnabled', test.securityEnabled);
              controller.set('kdc_type', test.kdc_type);
              controller.getSecurityType(mock.callback);
              this.args = testHelpers.findAjaxRequest('name', 'admin.security.cluster_configs.kerberos');
            });

            if (test.result) {
              it('callback os not called', function () {
                expect(mock.callback.calledOnce).to.be.false;
              });
              it('1 request is sent', function () {
                expect(this.args).to.exists;
              });
            } else {
              it('callback is called once', function () {
                expect(mock.callback.calledOnce).to.be.true;
              });
              it('no request is sent', function () {
                expect(this.args).to.not.exists;
              });
            }
          });
        });
  });

  describe('#getSecurityTypeSuccess', function() {
    [
      {
        data: { },
        e: 'none'
      },
      {
        data: {
          items: []
        },
        e: 'none'
      },
      {
        data: {
          items: [
            {
              configurations: []
            }
          ]
        },
        e: 'none'
      },
      {
        data: {
          items: [
            {
              configurations: [
                {
                  type: 'krb-conf',
                  properties: {
                    'kdc_type': 'mit'
                  }
                }
              ]
            }
          ]
        },
        e: 'none'
      },
      {
        data: {
          items: [
            {
              configurations: [
                {
                  type: 'kerberos-env',
                  properties: {
                    'kdc_type': 'mit'
                  }
                }
              ]
            }
          ]
        },
        e: 'mit'
      },
      {
        data: {
          items: [
            {
              configurations: [
                {
                  type: 'kerberos-env',
                  properties: {
                    'kdc_type': 'none'
                  }
                }
              ]
            }
          ]
        },
        e: 'none'
      }
    ].forEach(function(test) {
      it('json is ' + JSON.stringify(test.data) + ' kdc type should be ' + test.e, function() {
        controller.set('isManualKerberos', undefined);
        controller.getSecurityTypeSuccess(test.data, {}, {});
        expect(controller.get('kdc_type')).to.eql(test.e);
      });
    });
  });
});

});

require.register("test/controllers/main/admin/serviceAccounts_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/serviceAccounts_controller');


describe('App.MainAdminServiceAccountsController', function () {

  var controller = App.MainAdminServiceAccountsController.create();

  describe('#sortByOrder()', function () {
    var testCases = [
      {
        title: 'sortOrder is null',
        content: {
          sortOrder: null,
          arrayToSort: [
            {
              name: 'one',
              displayName: 'one'
            }
          ]
        },
        result: ['one']
      },
      {
        title: 'sortOrder is empty',
        content: {
          sortOrder: [],
          arrayToSort: [
            {
              name: 'one',
              displayName: 'one'
            }
          ]
        },
        result: ['one']
      },
      {
        title: 'sortOrder items don\'t match items of array',
        content: {
          sortOrder: ['one'],
          arrayToSort: [
            {name: 'two'}
          ]
        },
        result: []
      },
      {
        title: 'sort items in reverse order',
        content: {
          sortOrder: ['two', 'one'],
          arrayToSort: [
            Em.Object.create({
              name: 'one',
              displayName: 'one'
            }),
            Em.Object.create({
              name: 'two',
              displayName: 'two'
            })
          ]
        },
        result: ['two', 'one']
      },
      {
        title: 'sort items in correct order',
        content: {
          sortOrder: ['one', 'two'],
          arrayToSort: [
            Em.Object.create({
              name: 'one',
              displayName: 'one'
            }),
            Em.Object.create({
              name: 'two',
              displayName: 'two'
            })
          ]
        },
        result: ['one', 'two']
      }
    ];
    testCases.forEach(function (test) {
      it(test.title, function () {
        expect(controller.sortByOrder(test.content.sortOrder, test.content.arrayToSort).mapProperty('displayName')).to.eql(test.result);
      });
    });
  });
});

});

require.register("test/controllers/main/admin/stack_and_upgrade_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/stack_and_upgrade_controller');
require('utils/string_utils');
var testHelpers = require('test/helpers');

describe('App.MainAdminStackAndUpgradeController', function() {

  var controller = App.MainAdminStackAndUpgradeController.create({
    getDBProperty: Em.K,
    setDBProperty: Em.K,
    setDBProperties: Em.K,
    getDBProperties: Em.K
  });

  controller.removeObserver('App.upgradeState', controller, 'finish');


  describe("#realRepoUrl", function() {
    before(function () {
      this.mock = sinon.stub(App, 'get');
      this.mock.withArgs('apiPrefix').returns('apiPrefix');
    });
    after(function () {
      this.mock.restore();
    });
    it("should be valid", function() {
      var expected = 'apiPrefix/stacks?fields=versions/repository_versions/RepositoryVersions,' +
        'versions/repository_versions/operating_systems/*,versions/repository_versions/operating_systems/repositories/*';
      controller.propertyDidChange('realRepoUrl');
      expect(controller.get('realRepoUrl')).to.equal(expected);
    });
  });

  describe("#realStackUrl", function() {
    before(function () {
      this.mock = sinon.stub(App, 'get');
      this.mock.withArgs('apiPrefix').returns('apiPrefix')
        .withArgs('clusterName').returns('clusterName');
    });
    after(function () {
      this.mock.restore();
    });
    it("should be valid", function() {
      controller.propertyDidChange('realStackUrl');
      expect(controller.get('realStackUrl')).to.equal('apiPrefix/clusters/clusterName/stack_versions?fields=*,repository_versions/*,repository_versions/operating_systems/OperatingSystems/*,repository_versions/operating_systems/repositories/*');
    });
  });

  describe("#realUpdateUrl", function() {
    before(function () {
      this.mock = sinon.stub(App, 'get');
      this.mock.withArgs('apiPrefix').returns('apiPrefix')
        .withArgs('clusterName').returns('clusterName');
    });
    after(function () {
      this.mock.restore();
    });
    it("realUpdateUrl is valid", function() {
      controller.propertyDidChange('realUpdateUrl');
      expect(controller.get('realUpdateUrl')).to.equal('apiPrefix/clusters/clusterName/stack_versions?fields=ClusterStackVersions/*');
    });
  });

  describe("#requestStatus", function() {

    beforeEach(function() {
      this.mock = sinon.stub(App, 'get');
    });
    afterEach(function() {
      this.mock.restore();
    });

    it("App.upgradeSuspended is true", function() {
      this.mock.returns(true);
      controller.set('upgradeData', { Upgrade: {request_status: 'ABORTED'}});
      controller.propertyDidChange('requestStatus');
      expect(controller.get('requestStatus')).to.equal('SUSPENDED');
    });

    it("state not ABORTED", function() {
      this.mock.returns(false);
      controller.set('upgradeData', { Upgrade: {request_status: 'NOT_REQUIRED'}});
      controller.propertyDidChange('requestStatus');
      expect(controller.get('requestStatus')).to.equal('NOT_REQUIRED');
    });

    it("upgradeData is null", function() {
      this.mock.returns(false);
      controller.set('upgradeData', null);
      controller.propertyDidChange('requestStatus');
      expect(controller.get('requestStatus')).to.equal('INIT');
    });
  });

  describe("#load()", function() {
    beforeEach(function(){
      sinon.stub(controller, 'loadUpgradeData').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'loadStackVersionsToModel').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'loadRepoVersionsToModel').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'loadCompatibleVersions').returns({
        done: Em.clb
      });
      sinon.stub(App.StackVersion, 'find').returns([Em.Object.create({
        state: 'CURRENT',
        repositoryVersion: {
          id: '1',
          repositoryVersion: '2.2',
          displayName: 'HDP-2.2',
          stackVersionType: 'HDP'
        }
      })]);
      controller.load();
    });
    afterEach(function(){
      controller.loadUpgradeData.restore();
      controller.loadStackVersionsToModel.restore();
      controller.loadRepoVersionsToModel.restore();
      controller.loadCompatibleVersions.restore();
      App.StackVersion.find.restore();
    });
    it("loadUpgradeData called with valid arguments", function() {
      expect(controller.loadUpgradeData.calledWith(true)).to.be.true;
    });
    it('loadStackVersionsToModel called with valid arguments', function () {
      expect(controller.loadStackVersionsToModel.calledWith(true)).to.be.true;
    });
    it('loadRepoVersionsToModel called once', function () {
      expect(controller.loadRepoVersionsToModel.calledOnce).to.be.true;
    });
    it('loadCompatibleVersions called once', function () {
      expect(controller.loadCompatibleVersions.calledOnce).to.be.true;
    });
    it('currentVersion is corrent', function () {
      expect(controller.get('currentVersion')).to.eql({
        "id": "1",
        "repository_version": "2.2",
        "repository_name": "HDP-2.2",
        "stack_name": "HDP"
      });
    });
  });

  describe("#loadUpgradeData()", function() {

    it("get entire data", function() {
      controller.set('upgradeId', 1);
      controller.loadUpgradeData();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.data');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        id: 1
      });
    });
    it("get only state", function() {
      controller.set('upgradeId', 1);
      controller.loadUpgradeData(true);
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.state');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        id: 1
      });
    });
    it("upgrade id is null", function() {
      controller.set('upgradeId', null);
      controller.loadUpgradeData();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.state');
      var args2 = testHelpers.findAjaxRequest('name', 'admin.upgrade.data');
      expect(args).to.not.exists;
      expect(args2).to.not.exists;
    });
  });

  describe("#loadUpgradeDataSuccessCallback()", function() {
    var retryCases = [
      {
        isRetryPendingInitial: true,
        status: 'ABORTED',
        isRetryPending: true,
        requestInProgress: true,
        title: 'retry request not yet applied'
      },
      {
        isRetryPendingInitial: true,
        status: 'UPGRADING',
        isRetryPending: false,
        requestInProgress: false,
        title: 'retry request applied'
      },
      {
        isRetryPendingInitial: false,
        status: 'ABORTED',
        isRetryPending: false,
        requestInProgress: true,
        title: 'no retry request sent'
      },
      {
        isRetryPendingInitial: false,
        status: 'UPGRADING',
        isRetryPending: false,
        requestInProgress: true,
        title: 'upgrade wasn\'t aborted'
      }
    ];
    beforeEach(function () {
      sinon.stub(controller, 'updateUpgradeData', Em.K);
      sinon.stub(controller, 'setDBProperty', Em.K);
      sinon.stub(controller, 'finish');
    });
    afterEach(function () {
      controller.updateUpgradeData.restore();
      controller.setDBProperty.restore();
      controller.finish.restore();
      App.set('upgradeState', 'NOT_REQUIRED');
    });

    it("correct data", function() {
      var data = {
        "Upgrade": {
          "request_status": "UPGRADED"
        },
        "upgrade_groups": [
          {
            "UpgradeGroup": {
              "id": 1
            },
            "upgrade_items": []
          }
        ]};
      controller.loadUpgradeDataSuccessCallback(data);
      expect(App.get('upgradeState')).to.equal('UPGRADED');
      expect(controller.updateUpgradeData.calledOnce).to.be.true;
      expect(controller.setDBProperty.calledWith('upgradeState', 'UPGRADED')).to.be.true;
    });

    it("data is null", function() {
      var data = null;
      controller.loadUpgradeDataSuccessCallback(data);
      expect(controller.updateUpgradeData.called).to.be.false;
      expect(controller.setDBProperty.called).to.be.false;
    });

    it("finish should be called", function() {
      var data = {
        "Upgrade": {
          "request_status": "COMPLETED"
        }
      };
      controller.loadUpgradeDataSuccessCallback(data);
      expect(controller.finish.calledOnce).to.be.true;
    });

    retryCases.forEach(function (item) {
      it(item.title, function () {
        var data = {
          "Upgrade": {
            "request_status": item.status
          }
        };
        controller.setProperties({
          isRetryPending: item.isRetryPendingInitial,
          requestInProgress: true
        });
        controller.loadUpgradeDataSuccessCallback(data);
        expect(controller.getProperties(['isRetryPending', 'requestInProgress'])).to.eql({
          isRetryPending: item.isRetryPending,
          requestInProgress: item.requestInProgress
        });
      });
    });
  });

  describe("#getUpgradeItem()", function() {

    it("default callback", function() {
      var item = Em.Object.create({
        request_id: 1,
        group_id: 2,
        stage_id: 3
      });
      controller.getUpgradeItem(item);
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.upgrade_item');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].success).to.be.equal('getUpgradeItemSuccessCallback');
      expect(args[0].data).to.be.eql({
        upgradeId: 1,
        groupId: 2,
        stageId: 3
      });
    });
    it("custom callback", function() {
      var item = Em.Object.create({
        request_id: 1,
        group_id: 2,
        stage_id: 3
      });
      controller.getUpgradeItem(item, 'customCallback');
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.upgrade_item');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].success).to.be.equal('customCallback');
      expect(args[0].data).to.be.eql({
        upgradeId: 1,
        groupId: 2,
        stageId: 3
      });
    });
  });

  describe("#openUpgradeDialog()", function () {
    var mock = {
      observer: Em.K
    };
    beforeEach(function () {
      sinon.stub(App.router, 'transitionTo', Em.K);
      sinon.spy(mock, 'observer');
      this.mockAuthorized = sinon.stub(App, 'isAuthorized');
      Em.addObserver(App, 'upgradeSuspended', mock, 'observer');
    });
    afterEach(function () {
      App.router.transitionTo.restore();
      mock.observer.restore();
      this.mockAuthorized.restore();
      Em.removeObserver(App, 'upgradeSuspended', mock, 'observer');
    });

    it('should open dialog', function () {
      this.mockAuthorized.returns(true);
      controller.openUpgradeDialog();
      expect(App.router.transitionTo.calledWith('admin.stackUpgrade')).to.be.true;
    });

    it('upgradeSuspended should receive actual value', function () {
      this.mockAuthorized.returns(true);
      controller.openUpgradeDialog();
      expect(mock.observer.calledOnce).to.be.true;
    });

    it('should not open dialog', function () {
      this.mockAuthorized.returns(false);
      controller.openUpgradeDialog();
      expect(App.router.transitionTo.called).to.be.false;
    });

    it('should not open dialog, isWizardRestricted=true', function () {
      this.mockAuthorized.returns(true);
      controller.set('isWizardRestricted', true);
      controller.openUpgradeDialog();
      expect(App.router.transitionTo.called).to.be.false;
    });

    it('upgradeSuspended should not receive value', function () {
      this.mockAuthorized.returns(false);
      controller.openUpgradeDialog();
      expect(mock.observer.called).to.be.false;
    });

    it('upgradeSuspended should not receive value, isWizardRestricted=true', function () {
      this.mockAuthorized.returns(true);
      controller.set('isWizardRestricted', true);
      controller.openUpgradeDialog();
      expect(mock.observer.called).to.be.false;
    });
  });

  describe("#runPreUpgradeCheck()", function() {
    it("make ajax call", function() {
      controller.runPreUpgradeCheck(Em.Object.create({
        id: '1',
        repositoryVersion: '2.2',
        displayName: 'HDP-2.2',
        upgradeType: 'ROLLING',
        skipComponentFailures: false,
        skipSCFailures: false
      }));
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.pre_upgrade_check');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        id: '1',
        value: '2.2',
        label: 'HDP-2.2',
        type: 'ROLLING',
        skipComponentFailures: 'false',
        skipSCFailures: 'false'
      });
    });
  });

  describe("#runPreUpgradeCheckSuccess()", function () {
    var cases = [
      {
        check: {
          "check": "Work-preserving RM/NM restart is enabled in YARN configs",
          "status": "FAIL",
          "reason": "FAIL",
          "failed_on": [],
          "check_type": "SERVICE"
        },
        showClusterCheckPopupCalledCount: 1,
        upgradeCalledCount: 0,
        title: 'popup is displayed if fails are present'
      },
      {
        check: {
          "check": "Configuration Merge Check",
          "status": "WARNING",
          "reason": "Conflict",
          "failed_on": [],
          "failed_detail": [
            {
              type: 't0',
              property: 'p0',
              current: 'c0',
              new_stack_value: 'n0',
              result_value: 'n0'
            },
            {
              type: 't1',
              property: 'p1',
              current: 'c1',
              new_stack_value: null,
              result_value: 'c1'
            },
            {
              type: 't2',
              property: 'p2',
              current: 'c2',
              new_stack_value: null,
              result_value: null
            }
          ],
          "check_type": "CLUSTER",
          "id": "CONFIG_MERGE"
        },
        showClusterCheckPopupCalledCount: 1,
        upgradeCalledCount: 0,
        configs: [
          {
            type: 't0',
            name: 'p0',
            currentValue: 'c0',
            recommendedValue: 'n0',
            resultingValue: 'n0',
            isDeprecated: false,
            wasModified: false,
            willBeRemoved: false
          },
          {
            type: 't1',
            name: 'p1',
            currentValue: 'c1',
            recommendedValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.deprecated'),
            resultingValue: 'c1',
            isDeprecated: true,
            wasModified: false,
            willBeRemoved: false
          },
          {
            type: 't2',
            name: 'p2',
            currentValue: 'c2',
            recommendedValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.deprecated'),
            resultingValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.willBeRemoved'),
            isDeprecated: true,
            wasModified: false,
            willBeRemoved: true
          }
        ],
        title: 'popup is displayed if warnings are present; configs merge conflicts'
      },
      {
        check: {
          "check": "Work-preserving RM/NM restart is enabled in YARN configs",
          "status": "PASS",
          "reason": "OK",
          "failed_on": [],
          "check_type": "SERVICE"
        },
        showClusterCheckPopupCalledCount: 0,
        upgradeCalledCount: 1,
        title: 'upgrade is started if fails and warnings are absent'
      }
    ];
    beforeEach(function () {
      sinon.stub(App, 'showClusterCheckPopup', Em.K);
      sinon.stub(controller, 'upgrade', Em.K);
    });
    afterEach(function () {
      App.showClusterCheckPopup.restore();
      controller.upgrade.restore();
    });
    cases.forEach(function (item) {
      it(item.title, function () {
        controller.runPreUpgradeCheckSuccess(
          {
            items: [
              {
                UpgradeChecks: item.check
              }
            ]
          }, null, {
            label: 'name'
          }
        );
        expect(controller.upgrade.callCount).to.equal(item.upgradeCalledCount);
        expect(App.showClusterCheckPopup.callCount).to.equal(item.showClusterCheckPopupCalledCount);
        if (item.check.id === 'CONFIG_MERGE') {
          expect(App.showClusterCheckPopup.firstCall.args[2]).to.eql(item.configs);
        }
      });
    });
  });

  describe("#initDBProperties()", function() {
    before(function () {
      this.mock = sinon.stub(controller, 'getDBProperties');
    });
    after(function () {
      this.mock.restore();
    });
    it("set string properties", function () {
      this.mock.returns({prop: 'string'});
      controller.initDBProperties();
      expect(controller.get('prop')).to.equal('string');
    });
    it("set number properties", function () {
      this.mock.returns({prop: 0});
      controller.initDBProperties();
      expect(controller.get('prop')).to.equal(0);
    });
    it("set boolean properties", function () {
      this.mock.returns({prop: false});
      controller.initDBProperties();
      expect(controller.get('prop')).to.be.false;
    });
    it("set undefined properties", function () {
      this.mock.returns({prop: undefined});
      controller.set('prop', 'value');
      controller.initDBProperties();
      expect(controller.get('prop')).to.equal('value');
    });
    it("set null properties", function () {
      this.mock.returns({prop: null});
      controller.set('prop', 'value');
      controller.initDBProperties();
      expect(controller.get('prop')).to.equal('value');
    });
  });

  describe("#init()", function() {
    before(function () {
      sinon.stub(controller, 'initDBProperties', Em.K);
    });
    after(function () {
      controller.initDBProperties.restore();
    });
    it("call initDBProperties", function () {
      controller.init();
      expect(controller.initDBProperties.calledOnce).to.be.true;
    });
  });

  describe("#upgrade()", function() {
    var callArgs;

    beforeEach(function () {
      sinon.stub(controller, 'setDBProperty', Em.K);
      controller.set('currentVersion', {
        repository_version: '2.2'
      });
      controller.upgrade({
        value: '2.2',
        label: 'HDP-2.2'
      });
      callArgs = testHelpers.findAjaxRequest('name', 'admin.upgrade.start')[0];
    });

    afterEach(function () {
      controller.setDBProperty.restore();
    });

    it("request-data is valid", function() {
      expect(callArgs.data).to.eql({"value": '2.2', "label": 'HDP-2.2'});
    });
    it('request-name is valid', function () {
      expect(callArgs.name).to.equal('admin.upgrade.start');
    });
    it('request-sender is valid', function () {
      expect(callArgs.sender).to.eql(controller);
    });
    it('callback is valid', function () {
      expect(callArgs.success).to.equal('upgradeSuccessCallback');
    });
    it('callback is called', function () {
      expect(callArgs.callback).to.be.called;
    });
    it('setDBProperty is called with valid data', function () {
      expect(controller.setDBProperty.calledWith('currentVersion', {
        repository_version: '2.2'
      })).to.be.true;
    });
  });

  describe("#upgradeSuccessCallback()", function() {

    beforeEach(function () {
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      sinon.stub(controller, 'openUpgradeDialog', Em.K);
      sinon.stub(controller, 'setDBProperties', Em.K);
      sinon.stub(controller, 'load', Em.K);
      var data = {
        resources: [
          {
            Upgrade: {
              request_id: 1
            }
          }
        ]
      };
      controller.upgradeSuccessCallback(data, {}, {label: 'HDP-2.2.1', isDowngrade: true});
    });

    afterEach(function () {
      App.clusterStatus.setClusterStatus.restore();
      controller.openUpgradeDialog.restore();
      controller.setDBProperties.restore();
      controller.load.restore();
    });

    it('load is called ocne', function() {
      expect(controller.load.calledOnce).to.be.true;
    });
    it('upgradeVersion is HDP-2.2.1', function() {
      expect(controller.get('upgradeVersion')).to.equal('HDP-2.2.1');
    });
    it('upgradeData is null', function() {
      expect(controller.get('upgradeData')).to.be.null;
    });
    it('isDowngrade is true', function() {
      expect(controller.get('isDowngrade')).to.be.true;
    });
    it('App.clusterStatus.setClusterStatus is called once', function() {
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
    it('controller.openUpgradeDialog is called once', function() {
      expect(controller.openUpgradeDialog.calledOnce).to.be.true;
    });
  });

  describe("#updateUpgradeData()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'initUpgradeData', Em.K);
    });
    afterEach(function () {
      controller.initUpgradeData.restore();
    });
    it("data loaded first time", function() {
      controller.set('upgradeData', null);
      controller.updateUpgradeData({});
      expect(controller.initUpgradeData.calledWith({})).to.be.true;
    });

    describe('upgradeData exists', function () {

      var groups;

      beforeEach(function() {
        var oldData = Em.Object.create({
          upgradeGroups: [
            Em.Object.create({
              group_id: 1,
              upgradeItems: [
                Em.Object.create({
                  stage_id: 1
                })
              ]
            }),
            Em.Object.create({
              group_id: 2,
              upgradeItems: [
                Em.Object.create({
                  stage_id: 2
                }),
                Em.Object.create({
                  stage_id: 3
                })
              ]
            })
          ]
        });
        var newData = {
          Upgrade: {
            request_id: 1
          },
          upgrade_groups: [
            {
              UpgradeGroup: {
                group_id: 1,
                status: 'COMPLETED',
                display_status: 'COMPLETED',
                progress_percent: 100,
                completed_task_count: 3
              },
              upgrade_items: [
                {
                  UpgradeItem: {
                    stage_id: 1,
                    status: 'COMPLETED',
                    display_status: 'COMPLETED',
                    progress_percent: 100
                  }
                }
              ]
            },
            {
              UpgradeGroup: {
                group_id: 2,
                status: 'ABORTED',
                display_status: 'ABORTED',
                progress_percent: 50,
                completed_task_count: 1
              },
              upgrade_items: [
                {
                  UpgradeItem: {
                    stage_id: 2,
                    status: 'ABORTED',
                    display_status: 'ABORTED',
                    progress_percent: 99
                  }
                },
                {
                  UpgradeItem: {
                    stage_id: 3,
                    status: 'PENDING',
                    display_status: 'PENDING',
                    progress_percent: 0
                  }
                }
              ]
            }
          ]
        };
        controller.set('upgradeData', oldData);
        controller.updateUpgradeData(newData);
        groups = controller.get('upgradeData.upgradeGroups');
      });

      describe("checking 1st group", function() {
        it('status is COMPLETED', function () {
          expect(groups[0].get('status')).to.equal('COMPLETED');
        });
        it('display_status is COMPLETED', function () {
          expect(groups[0].get('display_status')).to.equal('COMPLETED');
        });
        it('progress_percent is 100', function () {
          expect(groups[0].get('progress_percent')).to.equal(100);
        });
        it('completed_task_count = 3', function () {
          expect(groups[0].get('completed_task_count')).to.equal(3);
        });
        it('upgradeItems.0.status is COMPLETED', function () {
          expect(groups[0].get('upgradeItems')[0].get('status')).to.equal('COMPLETED');
        });
        it('upgradeItems.0.display_status is COMPLETED', function () {
          expect(groups[0].get('upgradeItems')[0].get('display_status')).to.equal('COMPLETED');
        });
        it('upgradeItems.0.progress_percent is 100', function () {
          expect(groups[0].get('upgradeItems')[0].get('progress_percent')).to.equal(100);
        });
        it('hasExpandableItems is true', function () {
          expect(groups[0].get('hasExpandableItems')).to.be.true;
        });
      });

      describe('checking 2nd group', function () {
        it('status is ABORTED', function () {
          expect(groups[1].get('status')).to.equal('ABORTED');
        });
        it('display_status is ABORTED', function () {
          expect(groups[1].get('display_status')).to.equal('ABORTED');
        });
        it('progress_percent is 50', function () {
          expect(groups[1].get('progress_percent')).to.equal(50);
        });
        it('completed_task_count = 1', function () {
          expect(groups[1].get('completed_task_count')).to.equal(1);
        });
        it('upgradeItems.[].status = ["ABORTED", "PENDING"]', function () {
          expect(groups[1].get('upgradeItems').mapProperty('status')).to.eql(['ABORTED', 'PENDING']);
        });
        it('upgradeItems.[].display_status = ["ABORTED", "PENDING"]', function () {
          expect(groups[1].get('upgradeItems').mapProperty('display_status')).to.eql(['ABORTED', 'PENDING']);
        });
        it('upgradeItems.[].progress_percent = [99, 0]', function () {
          expect(groups[1].get('upgradeItems').mapProperty('progress_percent')).to.eql([99, 0]);
        });
        it('hasExpandableItems is false', function () {
          expect(groups[1].get('hasExpandableItems')).to.be.false;
        });
      });

    });
  });

  describe("#initUpgradeData()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'setDBProperty');
      sinon.stub(controller, 'formatMessages');
      var newData = {
        Upgrade: {
          request_id: 1,
          downgrade_allowed: false
        },
        upgrade_groups: [
          {
            UpgradeGroup: {
              group_id: 1
            },
            upgrade_items: [
              {
                UpgradeItem: {
                  stage_id: 1,
                  status: 'IN_PROGRESS'
                }
              },
              {
                UpgradeItem: {
                  stage_id: 2
                }
              }
            ]
          },
          {
            UpgradeGroup: {
              group_id: 2
            },
            upgrade_items: []
          },
          {
            UpgradeGroup: {
              group_id: 3
            },
            upgrade_items: [
              {
                UpgradeItem: {
                  stage_id: 3,
                  status: 'ABORTED'
                }
              },
              {
                UpgradeItem: {
                  stage_id: 4,
                  status: 'PENDING'
                }
              }
            ]
          }
        ]
      };
      controller.initUpgradeData(newData);
    });
    afterEach(function () {
      controller.setDBProperty.restore();
      controller.formatMessages.restore();
    });
    it("setDBProperty called with valid arguments", function() {
      expect(controller.setDBProperty.calledWith('downgradeAllowed', false)).to.be.true;
    });
    it('downgradeAllowed is false', function () {
      expect(controller.get('downgradeAllowed')).to.be.false;
    });
    it('upgradeData.Upgrade.request_id is 1', function () {
      expect(controller.get('upgradeData.Upgrade.request_id')).to.equal(1);
    });
    it('upgradeData.upgradeGroups contain valid data', function () {
      var groups = controller.get('upgradeData.upgradeGroups');
      expect(groups.mapProperty('group_id')).to.eql([3,2,1]);
      expect(groups[2].get('upgradeItems').mapProperty('stage_id')).to.eql([2,1]);
      expect(groups.mapProperty('hasExpandableItems')).to.eql([false, false, true]);
    });
  });

  describe.skip("#finish()", function() {
    before(function () {
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      sinon.stub(controller, 'setDBProperty', Em.K);
    });
    after(function () {
      App.clusterStatus.setClusterStatus.restore();
      controller.setDBProperty.restore();
    });
    it("upgradeState is not COMPLETED", function() {
      App.set('upgradeState', 'UPGRADING');
      controller.finish();
      expect(App.clusterStatus.setClusterStatus.called).to.be.false;
    });
    it("upgradeState is COMPLETED", function() {
      App.set('upgradeState', 'COMPLETED');
      controller.finish();
      expect(controller.setDBProperty.calledWith('upgradeId', undefined)).to.be.true;
      expect(controller.setDBProperty.calledWith('upgradeVersion', undefined)).to.be.true;
      expect(controller.setDBProperty.calledWith('upgradeState', 'INIT')).to.be.true;
      expect(controller.setDBProperty.calledWith('currentVersion', undefined)).to.be.true;
      expect(App.get('upgradeState')).to.equal('INIT');
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
  });

  describe("#confirmDowngrade()", function() {

    before(function () {
      sinon.spy(App, 'showConfirmationPopup');
      sinon.stub(controller, 'downgrade', Em.K);
    });

    after(function () {
      App.showConfirmationPopup.restore();
      controller.downgrade.restore();
    });

    it("show confirmation popup", function() {
      controller.set('currentVersion', Em.Object.create({
        repository_version: '2.2',
        repository_name: 'HDP-2.2'
      }));
      var popup = controller.confirmDowngrade();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.downgrade.calledWith(Em.Object.create({
        repository_version: '2.2',
        repository_name: 'HDP-2.2'
      }))).to.be.true;
    });
  });

  describe("#upgradeOptions()", function() {
    var version = Em.Object.create({displayName: 'HDP-2.2'});
    beforeEach(function () {
      sinon.spy(App.ModalPopup, 'show');
      sinon.spy(App, 'showConfirmationFeedBackPopup');
      sinon.stub(controller, 'getSupportedUpgradeTypes').returns({
        done: function (callback) {
          callback([1]);
          return {
            always: function (alwaysCallback) {
              alwaysCallback();
              return {};
            }
          };
        }
      });
      sinon.stub(controller, 'runPreUpgradeCheck', Em.K);
      sinon.stub(App.RepositoryVersion, 'find').returns([
        Em.Object.create({
          status: 'CURRENT'
        })
      ]);
      controller.get('runningCheckRequests').clear();
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
      App.showConfirmationFeedBackPopup.restore();
      controller.runPreUpgradeCheck.restore();
      controller.getSupportedUpgradeTypes.restore();
      controller.get('upgradeMethods').setEach('selected', false);
      App.RepositoryVersion.find.restore();
    });

    describe("show confirmation popup", function() {

      beforeEach(function () {
        controller.set('isDowngrade', false);
        this.popup = controller.upgradeOptions(false, version);
      });

      it('popup is shown', function () {
        expect(App.ModalPopup.show.calledOnce).to.be.true;
      });

      it('all upgradeMethods have isCheckRequestInProgress = true', function () {
        expect(controller.get('upgradeMethods').everyProperty('isCheckRequestInProgress')).to.be.true;
      });

      it('upgradeMethods no one is selected', function () {
        expect(controller.get('upgradeMethods').someProperty('selected')).to.be.false;
      });

      describe('#popup.onPrimary', function () {

        beforeEach(function () {
          controller.get('upgradeMethods')[0].set('selected', true);
          this.confirmPopup = this.popup.onPrimary();
        });

        it('showConfirmationFeedBackPopup is called once', function () {
          expect(App.showConfirmationFeedBackPopup.calledOnce).to.be.true;
        });

        describe('#confirmPopup.onPrimary', function () {
          beforeEach(function () {
            this.confirmPopup.onPrimary();
          });

          it('runPreUpgradeCheck is called with correct version', function () {
            expect(controller.runPreUpgradeCheck.calledWith(version)).to.be.true;
          });

          it('runningCheckRequests has 1 item', function () {
            expect(controller.get('runningCheckRequests')).to.have.length(1);
          });

        });

      });

      describe('#popup.disablePrimary', function () {

        beforeEach(function() {
          this.mock = sinon.stub(App, 'get');
        });

        afterEach(function() {
          App.get.restore();
        });

        it('should be disabled if no method is selected', function () {
          expect(this.popup.get('disablePrimary')).to.be.true;
        });

        it('should be disabled if preupgradecheck is supproted and isPrecheckFailed is true', function () {
          this.mock.returns(true);
          this.popup.set('selectedMethod', Em.Object.create({
            selected: true,
            isPrecheckFailed: true,
            isCheckRequestInProgress: false
          }));

          expect(this.popup.get('disablePrimary')).to.be.true;
        });

        it('should be disabled if preupgradecheck is supproted and isCheckRequestInProgress is true', function () {
          this.popup.set('selectedMethod', Em.Object.create({
            selected: true,
            isPrecheckFailed: false,
            isCheckRequestInProgress: true
          }));
          this.mock.returns(true);
          expect(this.popup.get('disablePrimary')).to.be.true;
        });

        it('should be enabled with preupgrade check', function () {
          this.popup.set('selectedMethod', Em.Object.create({
            selected: true,
            isPrecheckFailed: false,
            isCheckRequestInProgress: false
          }));
          this.mock.returns(true);
          expect(this.popup.get('disablePrimary')).to.be.false;
        });

        it('should be enabled without preupgrade check', function () {
          this.popup.set('selectedMethod', Em.Object.create({
            selected: true
          }));
          this.mock.returns(false);
          expect(this.popup.get('disablePrimary')).to.be.false;
        });

      });

    });

    describe("NOT show confirmation popup on Downgrade", function() {
      beforeEach(function () {
        controller.set('isDowngrade', true);
        controller.upgradeOptions(false, version);
      });

      it('runningCheckRequests has 1 item', function () {
        expect( controller.get('runningCheckRequests')).to.have.length(1);
      });

    });
  });

  describe("#confirmUpgrade()", function() {
    before(function () {
      sinon.stub(controller, 'upgradeOptions', Em.K);
    });
    after(function () {
      controller.upgradeOptions.restore();
    });
    it("show show upgrade options popup window", function() {
      var version = Em.Object.create({displayName: 'HDP-2.2'});
      controller.confirmUpgrade(version);
      expect(controller.upgradeOptions.calledWith(false, version)).to.be.true;
    });
  });

  describe("#downgrade", function() {
    beforeEach(function () {
      sinon.stub(controller, 'abortUpgrade').returns({
        done: function(callback) {callback()}
      });
      sinon.stub(controller, 'startDowngrade');
      controller.downgrade('versionInfo');
    });

    afterEach(function () {
      controller.abortUpgrade.restore();
      controller.startDowngrade.restore();
    });

    it('should run abortUpgrade', function() {
      expect(controller.abortUpgrade.calledOnce).to.be.true;
    });

  });

  describe("#startDowngrade()", function() {
    beforeEach(function () {
      sinon.stub(App.RepositoryVersion, 'find').returns([
        Em.Object.create({
          displayName: 'HDP-2.3',
          repositoryVersion: '2.3'
        })
      ]);
      controller.set('upgradeVersion', 'HDP-2.3');
      controller.set('upgradeType', 'NON_ROLLING');
      controller.startDowngrade(Em.Object.create({
        id: '1',
        repository_version: '2.2',
        repository_name: 'HDP-2.2'
      }));
      this.callArgs = testHelpers.findAjaxRequest('name', 'admin.downgrade.start')[0];
    });

    afterEach(function () {
      App.RepositoryVersion.find.restore();
    });

    it('request-data is valid', function () {
      expect(this.callArgs.data).to.eql({
        id: '1',
        value: '2.2',
        label: 'HDP-2.3',
        isDowngrade: true,
        upgradeType: "NON_ROLLING"
      });
    });
    it('request-name is valid', function () {
      expect(this.callArgs.name).to.be.equal('admin.downgrade.start');
    });
    it('request-sender is valid', function () {
      expect(this.callArgs.sender).to.be.eql(controller);
    });
    it('callback is valid', function () {
      expect(this.callArgs.success).to.be.equal('upgradeSuccessCallback');
    });
    it('callback is called', function () {
      expect(this.callArgs.callback).to.be.called;
    });
  });

  describe("#installRepoVersionPopup()", function () {
    before(function () {
      sinon.stub(controller, 'installRepoVersion', Em.K);
      sinon.stub(App.Service, 'find').returns(Em.Object.create({
        isLoaded: true
      }));
    });
    after(function () {
      controller.installRepoVersion.restore();
      App.Service.find.restore();
    });
    it("show confirmation popup for non standart and available services", function () {
      var repo = Em.Object.create({'displayName': 'HDP-2.2', isStandard: false, stackServices: [Em.Object.create({
        name: 'HDFS',
        isUpgradable: true,
        isAvailable: true
      })]});
      var popup = controller.installRepoVersionPopup(repo);
      popup.onPrimary();
      expect(controller.installRepoVersion.calledWith(repo)).to.be.true;
    });
    it("show pre-check popup for non standard and empty available services", function () {
      var repo = Em.Object.create({'displayName': 'HDP-2.2', isStandard: false, stackServices: []});
      var popup = controller.installRepoVersionPopup(repo);
      popup.onPrimary();
      expect(controller.installRepoVersion.calledWith(repo)).to.be.false;
    });
    it("show confirmation popup for standart", function () {
      var repo = Em.Object.create({'displayName': 'HDP-2.2', isStandard: true, stackServices: []});
      var popup = controller.installRepoVersionPopup(repo);
      popup.onPrimary();
      expect(controller.installRepoVersion.calledWith(repo)).to.be.true;
    });
  });

  describe("#installRepoVersion()", function () {

    it("make ajax call", function () {
      var repo = Em.Object.create({
        stackVersionType: 'HDP',
        stackVersionNumber: '2.2',
        repositoryVersion: '2.2.1',
        repoId: 1
      });
      controller.installRepoVersion(repo);
      var args = testHelpers.findAjaxRequest('name', 'admin.stack_version.install.repo_version');
      expect(args).to.exists;
    });
  });

  describe("#installRepoVersionSuccess()", function() {
    var mock = Em.Object.create({
      id: 1,
      defaultStatus: 'NOT_REQUIRED',
      stackVersion: {}
    });
    beforeEach(function () {
      sinon.spy(mock, 'set');
      sinon.stub(App.db, 'set', Em.K);
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      sinon.stub(App.RepositoryVersion, 'find').returns(mock);
      sinon.stub(App, 'showAlertPopup');
    });
    afterEach(function () {
      App.db.set.restore();
      App.clusterStatus.setClusterStatus.restore();
      App.RepositoryVersion.find.restore();
      mock.set.restore();
      App.showAlertPopup.restore();
    });

    it("App.showAlertPopup should be called", function() {
      expect(controller.installRepoVersionSuccess({statusText: 'timeout'}, {}, {id: 1})).to.be.false;
      expect(App.showAlertPopup.calledWith(
        Em.I18n.t('admin.stackVersions.upgrade.installPackage.fail.title'),
        Em.I18n.t('admin.stackVersions.upgrade.installPackage.fail.timeout')
      )).to.be.true;
    });

    it("data sdtored to the local db", function() {
      controller.installRepoVersionSuccess({Requests: {id: 1}}, {}, {id: 1});
      expect(App.db.set.calledWith('repoVersionInstall', 'id', [1])).to.be.true;
    });

    it('clusterStatus is updated', function () {
      controller.installRepoVersionSuccess({Requests: {id: 1}}, {}, {id: 1});
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });

    it('App.RepositoryVersion models have valid states', function () {
      controller.installRepoVersionSuccess({Requests: {id: 1}}, {}, {id: 1});
      expect(App.RepositoryVersion.find.calledWith(1)).to.be.true;
      expect(App.RepositoryVersion.find(1).get('defaultStatus')).to.equal('INSTALLING');
      expect(App.RepositoryVersion.find(1).get('stackVersion.state')).to.equal('INSTALLING');
    });
  });

  describe("#setUpgradeItemStatus()", function () {
    var item;
    beforeEach(function () {
      item = Em.Object.create({
        request_id: 1,
        stage_id: 1,
        group_id: 1
      });
      controller.setUpgradeItemStatus(item, 'PENDING');
      this.callArgs = testHelpers.findAjaxRequest('name', 'admin.upgrade.upgradeItem.setState')[0];
    });

    it('request-data is valid', function () {
      expect(this.callArgs.data).to.be.eql({upgradeId: 1, itemId: 1, groupId: 1, status: 'PENDING'});
    });
    it('request-name is valid', function () {
      expect(this.callArgs.name).to.be.equal('admin.upgrade.upgradeItem.setState');
    });
    it('request-sendeer is valid', function () {
      expect(this.callArgs.sender).to.be.eql(controller);
    });
    it('callback is called', function () {
      expect(this.callArgs.callback).to.be.called;
    });
    it('item.status is PENDING', function () {
      expect(item.get('status')).to.equal('PENDING');
    });
  });

  describe("#prepareRepoForSaving()", function () {
    it("prepare date for saving", function () {
      var repo = Em.Object.create({
        operatingSystems: [
          Em.Object.create({
            osType: "redhat6",
            isDisabled: Em.computed.not('isSelected'),
            repositories: [Em.Object.create({
                "baseUrl": "111121",
                "repoId": "HDP-2.2",
                "repoName": "HDP",
                hasError: false
            }),
              Em.Object.create({
                "baseUrl": "1",
                "repoId": "HDP-UTILS-1.1.0.20",
                "repoName": "HDP-UTILS",
                hasError: false
              })]
           })
        ]
      });
      var result = {
        "operating_systems": [
          {
            "OperatingSystems": {
              "os_type": "redhat6",
              "ambari_managed_repositories": true
            },
            "repositories": [
              {
                "Repositories": {
                  "base_url": "111121",
                  "repo_id": "HDP-2.2",
                  "repo_name": "HDP"
                }
              },
              {
                "Repositories": {
                  "base_url": "1",
                  "repo_id": "HDP-UTILS-1.1.0.20",
                  "repo_name": "HDP-UTILS"
                }
              }
            ]
          }
        ]};
      expect(controller.prepareRepoForSaving(repo)).to.eql(result);
    });
  });

  describe("#getStackVersionNumber()", function(){
    it("get stack version number", function(){
      var repo = Em.Object.create({
        "stackVersionType": 'HDP',
        "stackVersion": '2.3',
        "repositoryVersion": '2.2.1'
      });

      var stackVersion = controller.getStackVersionNumber(repo);
      expect(stackVersion).to.equal('2.3');
    });

    it("get default stack version number", function(){
      App.set('currentStackVersion', '1.2.3');
      var repo = Em.Object.create({
        "stackVersionType": 'HDP',
        "repositoryVersion": '2.2.1'
      });

      var stackVersion = controller.getStackVersionNumber(repo);
      expect(stackVersion).to.equal('1.2.3');
    });
  });

  describe("#saveRepoOS()", function() {
    before(function(){
      this.mock = sinon.stub(controller, 'validateRepoVersions');
      sinon.stub(controller, 'prepareRepoForSaving', Em.K);
    });
    after(function(){
      this.mock.restore();
      controller.prepareRepoForSaving.restore();
    });
    describe("validation errors present", function() {

      beforeEach(function () {
        this.mock.returns({
          done: function(callback) {callback([1]);}
        });
        controller.saveRepoOS(Em.Object.create({repoVersionId: 1}), true);
        this.args = testHelpers.findAjaxRequest('name', 'admin.stack_versions.edit.repo');
      });

      it('validateRepoVersions is called with valid arguments', function () {
        expect(controller.validateRepoVersions.calledWith(Em.Object.create({repoVersionId: 1}), true)).to.be.true;
      });

      it('prepareRepoForSaving is not called', function () {
        expect(controller.prepareRepoForSaving.called).to.be.false;
      });

      it('no requests are sent', function () {
        expect(this.args).to.not.exists;
      });
    });

    describe("no validation errors", function() {

      beforeEach(function () {
        this.mock.returns({
          done: function(callback) {callback([]);}
        });
        controller.saveRepoOS(Em.Object.create({repoVersionId: 1}), true);
      });
      it('validateRepoVersions is called with valid arguments', function () {
        expect(controller.validateRepoVersions.calledWith(Em.Object.create({repoVersionId: 1}), true)).to.be.true;
      });
      it('prepareRepoForSaving is called with valid arguments', function () {
        expect(controller.prepareRepoForSaving.calledWith(Em.Object.create({repoVersionId: 1}))).to.be.true;
      });
    });
  });

  describe("#validateRepoVersions()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'validationCall').returns({
        success: function() {
          return {error: Em.K}
        }
      });
      sinon.stub(controller, 'getStackVersionNumber').returns('v1')
    });

    afterEach(function() {
      controller.validationCall.restore();
      controller.getStackVersionNumber.restore();
    });


    it("validationCall should not be called", function () {
      controller.validateRepoVersions(Em.Object.create({repoVersionId: 1}), true);
      expect(controller.validationCall.called).to.be.false;
    });
    it("validationCall should be called", function () {
      var os = Em.Object.create({
        isSelected: true,
        repositories: [
          Em.Object.create()
        ]
      });
      var repo = Em.Object.create({
        repoVersionId: 1,
        operatingSystems: [ os ]
      });
      controller.validateRepoVersions(repo, false);
      expect(controller.validationCall.calledOnce).to.be.true;
    });
  });

  describe("#validationCall()", function () {

    it("App.ajax.send should be called", function() {
      controller.validationCall(Em.Object.create(), Em.Object.create(), 'v1');
      var args = testHelpers.findAjaxRequest('name', 'admin.stack_versions.validate.repo');
      expect(args[0]).to.exists;
    });
  });

  describe("#getUrl()", function() {
    beforeEach(function(){
      controller.reopen({
        realStackUrl: 'realStackUrl',
        realRepoUrl: 'realRepoUrl',
        realUpdateUrl: 'realUpdateUrl'
      });
    });

    it("full load is true, stack is null", function() {
      expect(controller.getUrl(null, true)).to.equal('realRepoUrl');
    });
    it("full load is true, stack is valid", function() {
      expect(controller.getUrl({}, true)).to.equal('realStackUrl');
    });
    it("full load is false, stack is valid", function() {
      expect(controller.getUrl({}, false)).to.equal('realUpdateUrl');
    });
  });

  describe("#loadStackVersionsToModel()", function () {
    before(function () {
      sinon.stub(App.HttpClient, 'get');
    });
    after(function () {
      App.HttpClient.get.restore();
    });
    it("HttpClient did get-request", function () {
      controller.loadStackVersionsToModel();
      expect(App.HttpClient.get.calledOnce).to.be.true;
    });
  });

  describe("#loadRepoVersionsToModel()", function () {
    before(function () {
      sinon.stub(App.HttpClient, 'get');
    });
    after(function () {
      App.HttpClient.get.restore();
    });
    it("HttpClient did get-request", function () {
      controller.loadRepoVersionsToModel();
      expect(App.HttpClient.get.calledOnce).to.be.true;
    });
  });

  describe('#currentVersionObserver()', function () {

    var cases = [
      {
        stackVersionType: 'HDP',
        repoVersion: '2.2.1.1.0-1',
        isStormMetricsSupported: false,
        title: 'HDP < 2.2.2'
      },
      {
        stackVersionType: 'HDP',
        repoVersion: '2.2.2.1.0-1',
        isStormMetricsSupported: true,
        title: 'HDP 2.2.2'
      },
      {
        stackVersionType: 'HDP',
        repoVersion: '2.2.3.1.0-1',
        isStormMetricsSupported: true,
        title: 'HDP > 2.2.2'
      },
      {
        stackVersionType: 'BIGTOP',
        repoVersion: '0.8.1.1.0-1',
        isStormMetricsSupported: true,
        title: 'not HDP'
      }
    ];

    afterEach(function () {
      App.RepositoryVersion.find.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(App.RepositoryVersion, 'find').returns([
            Em.Object.create({
              status: 'CURRENT',
              stackVersionType: item.stackVersionType
            })
          ]);
          controller.set('currentVersion', {
            repository_version: item.repoVersion
          });
        });

        it('isStormMetricsSupported is ' + (item.isStormMetricsSupported ? '' : 'not') + ' supported', function () {
          expect(App.get('isStormMetricsSupported')).to.equal(item.isStormMetricsSupported);
        });

      });
    });

  });

  describe('#updateFinalize', function () {

    beforeEach(function() {
      controller.set('isFinalizeItem', true);
      this.stub = sinon.stub(App, 'get');
    });

    afterEach(function () {
      this.stub.restore();
    });

    describe('should do ajax-request', function () {

      beforeEach(function () {
        this.stub.withArgs('upgradeState').returns('HOLDING');
        controller.updateFinalize();
        this.args = testHelpers.findAjaxRequest('name', 'admin.upgrade.finalizeContext');
      });

      it('request is sent', function () {
        expect(this.args[0]).to.exists;
      });

    });

    describe('shouldn\'t do ajax-request', function () {

      beforeEach(function () {
        this.stub.withArgs('upgradeState').returns('HOLDING_TIMEDOUT');
        controller.updateFinalize();
        this.args = testHelpers.findAjaxRequest('name', 'admin.upgrade.finalizeContext');
      });

      it('request is not sent', function () {
        expect(this.args).to.not.exists;
      });

      it('isFinalizeItem is false', function () {
        expect(controller.get('isFinalizeItem')).to.be.false;
      });

    });

  });

  describe('#updateFinalizeSuccessCallback', function () {

    it('data exists and Finalize should be true', function() {
      var data = {
        items: [
          {
            upgrade_groups: [
              {
                upgrade_items: [
                  {
                    UpgradeItem: {
                      context: controller.get('finalizeContext'),
                      status: "HOLDING"
                    }
                  }
                ]
              }
            ]
          }
        ]
      };
      controller.set('isFinalizeItem', false);
      controller.updateFinalizeSuccessCallback(data);
      expect(controller.get('isFinalizeItem')).to.be.true;
    });

    it('data exists and Finalize should be false', function() {
      var data = {
        upgrade_groups: [
          {
            upgrade_items: [
              {
                UpgradeItem: {
                  context: '!@#$%^&',
                  status: "HOLDING"
                }
              }
            ]
          }
        ]
      };
      controller.set('isFinalizeItem', true);
      controller.updateFinalizeSuccessCallback(data);
      expect(controller.get('isFinalizeItem')).to.be.false;
    });

    it('data doesn\'t exist', function() {
      var data = null;
      controller.set('isFinalizeItem', true);
      controller.updateFinalizeSuccessCallback(data);
      expect(controller.get('isFinalizeItem')).to.be.false;
    });

  });

  describe('#updateFinalizeErrorCallback', function () {

    it('should set isFinalizeItem to false', function () {
      controller.set('isFinalizeItem', true);
      controller.updateFinalizeErrorCallback();
      expect(controller.get('isFinalizeItem')).to.be.false;
    });

  });

  describe("#suspendUpgrade()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'abortUpgradeWithSuspend').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'setDBProperty', Em.K);
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      controller.suspendUpgrade();
    });
    afterEach(function () {
      controller.abortUpgradeWithSuspend.restore();
      controller.setDBProperty.restore();
      App.clusterStatus.setClusterStatus.restore();
    });
    it("upgrade aborted", function() {
      expect(controller.abortUpgradeWithSuspend.calledOnce).to.be.true;
    });
    it('App.upgradeState is ABORTED', function () {
      expect(App.get('upgradeState')).to.equal('ABORTED');
    });
    it('new upgradeState is saved to the localDB', function () {
      expect(controller.setDBProperty.calledWith('upgradeState', 'ABORTED')).to.be.true;
    });
    it('clusterStatus is updated', function () {
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
  });

  describe("#resumeUpgrade()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'retryUpgrade').returns({
        done: Em.clb
      });
      sinon.stub(controller, 'setDBProperty', Em.K);
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      controller.resumeUpgrade();
    });
    afterEach(function () {
      controller.retryUpgrade.restore();
      controller.setDBProperty.restore();
      App.clusterStatus.setClusterStatus.restore();
    });
    it("Upgrade is retrying", function() {
      expect(controller.retryUpgrade.calledOnce).to.be.true;
    });
    it('App.upgradeState is PENDING', function () {
      expect(App.get('upgradeState')).to.equal('PENDING');
    });
    it('new upgradeState is saved to the localDB', function () {
      expect(controller.setDBProperty.calledWith('upgradeState', 'PENDING')).to.be.true;
    });
    it('clusterStatus is updated', function () {
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
  });

  describe("#runUpgradeMethodChecks()", function() {
    beforeEach(function () {
      sinon.stub(controller, 'runPreUpgradeCheckOnly');
    });
    afterEach(function () {
      controller.runPreUpgradeCheckOnly.restore();
      controller.get('upgradeMethods').setEach('allowed', true);
    });
    it("no allowed upgrade methods", function () {
      controller.get('upgradeMethods').setEach('allowed', false);
      controller.runUpgradeMethodChecks();
      expect(controller.runPreUpgradeCheckOnly.called).to.be.false;
    });
    it("Rolling method allowed", function () {
      controller.get('upgradeMethods').setEach('allowed', true);
      controller.runUpgradeMethodChecks(Em.Object.create({
        id: 1,
        repositoryVersion: '1.2',
        displayName: 'V1'
      }));
      expect(controller.runPreUpgradeCheckOnly.calledWith({
        id: 1,
        label: 'V1',
        type: 'ROLLING'
      })).to.be.true;
    });
  });

  describe("#restoreLastUpgrade()", function () {

    var data = {
      Upgrade: {
        associated_version: '1.1',
        request_id: 1,
        direction: 'UPGRADE',
        request_status: 'PENDING',
        upgrade_type: 'ROLLING',
        downgrade_allowed: true,
        skip_failures: true,
        skip_service_check_failures: true,
        to_version: '1'
      }
    };

    beforeEach(function () {
      sinon.stub(App.RepositoryVersion, 'find').returns([Em.Object.create({
        repositoryVersion: '1',
        displayName: 'HDP-1'
      })]);
      sinon.stub(controller, 'setDBProperties');
      sinon.stub(controller, 'loadRepoVersionsToModel', function () {
        return {
          done: function (callback) {
            callback();
          }
        }
      });
      sinon.stub(controller, 'setDBProperty');
      sinon.stub(controller, 'initDBProperties');
      sinon.stub(controller, 'loadUpgradeData');
      controller.restoreLastUpgrade(data);
    });
    afterEach(function () {
      App.RepositoryVersion.find.restore();
      controller.setDBProperties.restore();
      controller.loadRepoVersionsToModel.restore();
      controller.setDBProperty.restore();
      controller.initDBProperties.restore();
      controller.loadUpgradeData.restore();
    });
    it('proper data is saved to the localDB', function () {
      expect(controller.setDBProperties.getCall(0).args[0]).to.eql({
        toVersion: '1.1',
        upgradeId: 1,
        isDowngrade: false,
        upgradeState: 'PENDING',
        upgradeType: "ROLLING",
        isWizardRestricted: false,
        downgradeAllowed: true,
        upgradeTypeDisplayName: Em.I18n.t('admin.stackVersions.version.upgrade.upgradeOptions.RU.title'),
        failuresTolerance: Em.Object.create({
          skipComponentFailures: true,
          skipSCFailures: true
        })
      });
    });
    it('models are saved', function () {
      expect(controller.loadRepoVersionsToModel.calledOnce).to.be.true;
    });
    it('initDBProperties is called', function () {
      expect(controller.initDBProperties.calledOnce).to.be.true;
    });
    it('loadUpgradeData called with valid arguments', function () {
      expect(controller.loadUpgradeData.calledWith(true)).to.be.true;
    });
  });

  describe("#getServiceCheckItemSuccessCallback()", function() {
    var testCases = [
      {
        title: 'no tasks',
        data: {
          tasks: []
        },
        expected: {
          slaveComponentStructuredInfo: null,
          serviceCheckFailuresServicenames: []
        }
      },
      {
        title: 'no structured_out property',
        data: {
          tasks: [
            {
              Tasks: {}
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: null,
          serviceCheckFailuresServicenames: []
        }
      },
      {
        title: 'no failures',
        data: {
          tasks: [
            {
              Tasks: {
                structured_out: {}
              }
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: null,
          serviceCheckFailuresServicenames: []
        }
      },
      {
        title: 'service check failures',
        data: {
          tasks: [
            {
              Tasks: {
                structured_out: {
                  failures: {
                    service_check: ['HDSF', 'YARN']
                  }
                }
              }
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: {
            hosts: [],
            host_detail: {}
          },
          serviceCheckFailuresServicenames: ['HDSF', 'YARN']
        }
      },
      {
        title: 'host-component failures',
        data: {
          tasks: [
            {
              Tasks: {
                structured_out: {
                  failures: {
                    service_check: ['HDSF'],
                    host_component: {
                      "host1": [
                        {
                          component: "DATANODE",
                          service: 'HDFS'
                        }
                      ]
                    }
                  }
                }
              }
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: {
            hosts: ['host1'],
            host_detail: {
              "host1": [
                {
                  component: "DATANODE",
                  service: 'HDFS'
                }
              ]
            }
          },
          serviceCheckFailuresServicenames: ['HDSF']
        }
      }
    ];

    testCases.forEach(function(test) {
      it(test.title, function() {
        controller.set('slaveComponentStructuredInfo', null);
        controller.set('serviceCheckFailuresServicenames', []);
        controller.getServiceCheckItemSuccessCallback(test.data);
        expect(controller.get('serviceCheckFailuresServicenames')).eql(test.expected.serviceCheckFailuresServicenames);
        expect(controller.get('slaveComponentStructuredInfo')).eql(test.expected.slaveComponentStructuredInfo);
      });
    });
  });

  describe("#getSlaveComponentItemSuccessCallback()", function () {
    var testCases = [
      {
        title: 'no tasks',
        data: {
          tasks: []
        },
        expected: {
          slaveComponentStructuredInfo: null
        }
      },
      {
        title: 'structured_out property absent',
        data: {
          tasks: [
            {
              Tasks: {}
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: null
        }
      },
      {
        title: 'structured_out property present',
        data: {
          tasks: [
            {
              Tasks: {
                "structured_out" : {
                  "hosts" : [
                    "host1"
                  ],
                  "host_detail" : {
                    "host1" : [
                      {
                        "service" : "FLUME",
                        "component" : "FLUME_HANDLER"
                      }
                    ]
                  }
                }
              }
            }
          ]
        },
        expected: {
          slaveComponentStructuredInfo: {
            "hosts" : [
              "host1"
            ],
            "host_detail" : {
              "host1" : [
                {
                  "service" : "FLUME",
                  "component" : "FLUME_HANDLER"
                }
              ]
            }
          }
        }
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.set('slaveComponentStructuredInfo', null);
        controller.getSlaveComponentItemSuccessCallback(test.data);
        expect(controller.get('slaveComponentStructuredInfo')).eql(test.expected.slaveComponentStructuredInfo);
      });
    });
  });

  describe('#getConfigsWarnings', function () {

    var cases = [
      {
        configs: [],
        title: 'no warning'
      },
      {
        configsMergeWarning: {},
        configs: [],
        title: 'empty data'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {}
        },
        configs: [],
        title: 'incomplete data'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {
            failed_detail: {}
          }
        },
        configs: [],
        title: 'invalid data'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {
            failed_detail: []
          }
        },
        configs: [],
        title: 'empty configs array'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {
            status: 'FAIL',
            failed_detail: [
              {
                type: 't0',
                property: 'p0',
                current: 'c0',
                new_stack_value: 'n0',
                result_value: 'r0'
              },
              {
                type: 't1',
                property: 'p1',
                current: 'c1',
                new_stack_value: 'n1'
              },
              {
                type: 't2',
                property: 'p2',
                current: 'c2',
                result_value: 'r2'
              }
            ]
          }
        },
        configs: [],
        title: 'not a warning'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {
            status: 'WARNING',
            failed_detail: [
              {
                type: 't0',
                property: 'p0',
                current: 'c0',
                new_stack_value: 'n0',
                result_value: 'r0'
              },
              {
                type: 't1',
                property: 'p1',
                current: 'c1',
                new_stack_value: 'n1'
              },
              {
                type: 't2',
                property: 'p2',
                current: 'c2',
                result_value: 'r2'
              }
            ]
          }
        },
        configs: [
          {
            type: 't0',
            name: 'p0',
            currentValue: 'c0',
            recommendedValue: 'n0',
            isDeprecated: false,
            resultingValue: 'r0',
            wasModified: false,
            willBeRemoved: false
          },
          {
            type: 't1',
            name: 'p1',
            currentValue: 'c1',
            recommendedValue: 'n1',
            isDeprecated: false,
            resultingValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.willBeRemoved'),
            wasModified: false,
            willBeRemoved: true
          },
          {
            type: 't2',
            name: 'p2',
            currentValue: 'c2',
            recommendedValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.deprecated'),
            isDeprecated: true,
            resultingValue: 'r2',
            wasModified: false,
            willBeRemoved: false
          }
        ],
        title: 'normal case'
      },
      {
        configsMergeWarning: {
          UpgradeChecks: {
            status: 'WARNING',
            failed_detail: [
              {
                type: 't0',
                property: 'p0',
                current: 'c0',
                new_stack_value: 'n0',
                result_value: 'r0'
              },
              {
                type: 't1',
                property: 'p1',
                current: 'c1',
                new_stack_value: 'n1'
              },
              {
                type: 't2',
                property: 'p2',
                current: 'c2',
                result_value: 'r2'
              },
              {
                type: 't3',
                property: 'p3',
                current: 'c3',
                new_stack_value: 'c2',
                result_value: 'c3'
              }
            ]
          }
        },
        configs: [
          {
            type: 't0',
            name: 'p0',
            currentValue: 'c0',
            recommendedValue: 'n0',
            isDeprecated: false,
            resultingValue: 'r0',
            wasModified: false,
            willBeRemoved: false
          },
          {
            type: 't1',
            name: 'p1',
            currentValue: 'c1',
            recommendedValue: 'n1',
            isDeprecated: false,
            resultingValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.willBeRemoved'),
            wasModified: false,
            willBeRemoved: true
          },
          {
            type: 't2',
            name: 'p2',
            currentValue: 'c2',
            recommendedValue: Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.deprecated'),
            isDeprecated: true,
            resultingValue: 'r2',
            wasModified: false,
            willBeRemoved: false
          },
          {
            "currentValue": "c3",
            "isDeprecated": false,
            "name": "p3",
            "recommendedValue": "c2",
            "resultingValue": "c3",
            "type": "t3",
            "wasModified": true,
            "willBeRemoved": false
          }
        ],
        title: 'should skip warning when current and result_value are the same'
      }
    ];

    cases.forEach(function (item) {
      it(item.title, function () {
        expect(controller.getConfigsWarnings(item.configsMergeWarning)).to.eql(item.configs);
      });
    });

  });

  describe('#runPreUpgradeCheckOnly', function () {

    var appGetMock,
      upgradeMethods = controller.get('upgradeMethods'),
      cases = [
      {
        supportsPreUpgradeCheck: false,
        ru: {
          isCheckComplete: true,
          isCheckRequestInProgress: false,
          action: 'a'
        },
        eu: {
          isCheckComplete: true,
          isCheckRequestInProgress: false,
          action: 'a'
        },
        ajaxCallCount: 0,
        runningCheckRequestsLength: 0,
        title: 'pre-upgrade checks not supported'
      },
      {
        supportsPreUpgradeCheck: true,
        ru: {
          isCheckComplete: false,
          isCheckRequestInProgress: true,
          action: ''
        },
        eu: {
          isCheckComplete: true,
          isCheckRequestInProgress: false,
          action: 'a'
        },
        ajaxCallCount: 1,
        type: 'ROLLING',
        runningCheckRequestsLength: 1,
        title: 'rolling upgrade'
      },
      {
        supportsPreUpgradeCheck: true,
        ru: {
          isCheckComplete: true,
          isCheckRequestInProgress: false,
          action: 'a'
        },
        eu: {
          isCheckComplete: false,
          isCheckRequestInProgress: true,
          action: ''
        },
        ajaxCallCount: 1,
        type: 'NON_ROLLING',
        runningCheckRequestsLength: 1,
        title: 'express upgrade'
      }
    ];

    beforeEach(function () {
      appGetMock = sinon.stub(App, 'get');
      controller.get('runningCheckRequests').clear();
      upgradeMethods.forEach(function (method) {
        method.setProperties({
          isCheckComplete: true,
          isCheckRequestInProgress: false,
          action: 'a'
        });
      });
      App.ajax.send.restore();
      sinon.stub(App.ajax, 'send').returns({});
    });

    afterEach(function () {
      appGetMock.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {
        var runningCheckRequests;
        beforeEach(function () {
          runningCheckRequests = controller.get('runningCheckRequests');
          appGetMock.returns(item.supportsPreUpgradeCheck);
          controller.runPreUpgradeCheckOnly({
            type: item.type
          });
          this.ajaxCalls = testHelpers.filterAjaxRequests('name', 'admin.upgrade.pre_upgrade_check');
        });

        it('ROLLING properties', function () {
          expect(upgradeMethods.findProperty('type', 'ROLLING').getProperties('isCheckComplete', 'isCheckRequestInProgress', 'action')).to.eql(item.ru);
        });

        it('NON_ROLLING properties', function () {
          expect(upgradeMethods.findProperty('type', 'NON_ROLLING').getProperties('isCheckComplete', 'isCheckRequestInProgress', 'action')).to.eql(item.eu);
        });

        it(item.ajaxCallCount + ' requests sent', function () {
          expect(this.ajaxCalls.length).to.be.equal(item.ajaxCallCount);
        });

        it('runningCheckRequests length is ' + item.runningCheckRequestsLength, function () {
          expect(runningCheckRequests).to.have.length(item.runningCheckRequestsLength);
        });

        if (item.runningCheckRequestsLength) {
          it('runningCheckRequests.type is ' + item.type, function () {
            expect(runningCheckRequests[0].type).to.equal(item.type);
          });
        }

      });
    });

  });


  describe("#openConfigsInNewWindow()", function () {

    var mock = {
      document: {
        write: function () {}
      },
      focus: function () {}
    };

    beforeEach(function(){
      sinon.stub(window, 'open', function () {
        return mock;
      });
      sinon.spy(mock.document, 'write');
      sinon.spy(mock, 'focus');
      controller.openConfigsInNewWindow({
        context: [
          {
            type: 'type1',
            name: 'name1',
            currentValue: 'currentValue1',
            recommendedValue: 'recommendedValue1',
            resultingValue: 'resultingValue1'
          },
          {
            type: 'type2',
            name: 'name2',
            currentValue: 'currentValue2',
            recommendedValue: 'recommendedValue2',
            resultingValue: 'resultingValue2'
          }
        ]
      });
    });

    afterEach(function(){
      window.open.restore();
      mock.document.write.restore();
      mock.focus.restore();
    });

    it('new window is open', function () {
      expect(window.open.calledOnce).to.be.true;
    });

    it('new window content is valid', function () {
      /*eslint-disable no-useless-concat */
      expect(mock.document.write.calledWith('<table style="text-align: left;"><thead><tr>' +
        '<th>' + Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.configType') + '</th>' +
        '<th>' + Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.propertyName') + '</th>' +
        '<th>' + Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.currentValue') + '</th>' +
        '<th>' + Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.recommendedValue') + '</th>' +
        '<th>' + Em.I18n.t('popup.clusterCheck.Upgrade.configsMerge.resultingValue') + '</th>' +
        '</tr></thead><tbody>' +
        '<tr>' +
        '<td>' + 'type1' + '</td>' +
        '<td>' + 'name1' + '</td>' +
        '<td>' + 'currentValue1' + '</td>' +
        '<td>' + 'recommendedValue1' + '</td>' +
        '<td>' + 'resultingValue1' + '</td>' +
        '</tr>' +
        '<tr>' +
        '<td>' + 'type2' + '</td>' +
        '<td>' + 'name2' + '</td>' +
        '<td>' + 'currentValue2' + '</td>' +
        '<td>' + 'recommendedValue2' + '</td>' +
        '<td>' + 'resultingValue2' + '</td>' +
        '</tr></tbody></table>')).to.be.true;
      /*eslint-enable no-useless-concat */
    });

    it('document.focus is called once', function () {
      expect(mock.focus.calledOnce).to.be.true;
    });
  });

  describe("#formatMessages()", function () {

    it("item with malformed text", function() {
      var item = Em.Object.create({
        text: null
      });
      controller.formatMessages(item);
      expect(item.get('messages')).to.be.empty;
      expect(item.get('text')).to.be.null;
    });

    it("item with correct text", function() {
      var item = Em.Object.create({
        text: '[{"message":"msg1"},{"message":"msg2"}]'
      });
      controller.formatMessages(item);
      expect(item.get('messages')).to.be.eql(['msg1', 'msg2']);
      expect(item.get('text')).to.be.equal('msg1 msg2');
    });
  });

  describe("#getUpgradeItemSuccessCallback()", function () {

    beforeEach(function() {
      controller.set('upgradeData', Em.Object.create({
        upgradeGroups: [
          Em.Object.create({
            group_id: 'g1',
            upgradeItems: [Em.Object.create({
              stage_id: 'i1',
              tasks: [],
              isTasksLoaded: false
            })]
          })
        ]
      }));
    });

    it("group has different id", function() {
      var data = {UpgradeItem: {group_id: 'g2'}};
      controller.getUpgradeItemSuccessCallback(data);
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('isTasksLoaded')).to.be.false;
    });

    it("item has different id", function() {
      var data = {UpgradeItem: {group_id: 'g1', stage_id: 'i2'}};
      controller.getUpgradeItemSuccessCallback(data);
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('isTasksLoaded')).to.be.false;
    });

    it("item has no tasks", function() {
      var data = {
        UpgradeItem: {
          group_id: 'g1',
          stage_id: 'i1'
        },
        tasks: [
          {
            Tasks: {id: 't1'}
          }
        ]
      };
      controller.getUpgradeItemSuccessCallback(data);
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('isTasksLoaded')).to.be.true;
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('tasks')).to.not.be.empty;
    });

    it("item has tasks", function() {
      controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].set('tasks', [
        Em.Object.create({
          id: 't1',
          status: 'OLD'
        })
      ]);
      var data = {
        UpgradeItem: {
          group_id: 'g1',
          stage_id: 'i1'
        },
        tasks: [
          {
            Tasks: {
              id: 't1',
              status: 'NEW'
            }
          }
        ]
      };
      controller.getUpgradeItemSuccessCallback(data);
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('isTasksLoaded')).to.be.true;
      expect(controller.get('upgradeData.upgradeGroups')[0].get('upgradeItems')[0].get('tasks')[0].get('status')).to.be.equal('NEW');
    });
  });

  describe("#abortUpgrade()", function () {

    it("isDowngrade is true", function() {
      controller.set('isDowngrade', true);
      controller.set('upgradeId', 1);
      controller.abortUpgrade();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.abort');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.abort',
        sender: controller,
        data: {
          upgradeId: 1,
          isDowngrade: true
        },
        error: 'abortDowngradeErrorCallback'
      });
    });

    it("isDowngrade is false", function() {
      controller.set('isDowngrade', false);
      controller.set('upgradeId', 1);
      controller.abortUpgrade();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.abort');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.abort',
        sender: controller,
        data: {
          upgradeId: 1,
          isDowngrade: false
        },
        error: 'abortUpgradeErrorCallback'
      });
    });
  });

  describe("#abortUpgradeWithSuspend()", function () {

    it("isDowngrade is true", function() {
      controller.set('isDowngrade', true);
      controller.set('upgradeId', 1);
      controller.abortUpgradeWithSuspend();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.suspend');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.suspend',
        sender: controller,
        data: {
          upgradeId: 1,
          isDowngrade: true
        },
        error: 'abortDowngradeErrorCallback'
      });
    });

    it("isDowngrade is false", function() {
      controller.set('isDowngrade', false);
      controller.set('upgradeId', 1);
      controller.abortUpgradeWithSuspend();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.suspend');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.suspend',
        sender: controller,
        data: {
          upgradeId: 1,
          isDowngrade: false
        },
        error: 'abortUpgradeErrorCallback'
      });
    });
  });

  describe("#abortUpgradeErrorCallback()", function () {
    var header = Em.I18n.t('admin.stackUpgrade.state.paused.fail.header');
    var body = Em.I18n.t('admin.stackUpgrade.state.paused.fail.body');

    beforeEach(function() {
      sinon.stub(App, 'showAlertPopup');
    });

    afterEach(function() {
      App.showAlertPopup.restore();
    });

    it("data is null", function() {
      controller.abortUpgradeErrorCallback(null);
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is null", function() {
      controller.abortUpgradeErrorCallback({responseText: null});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is incorrect", function() {
      controller.abortUpgradeErrorCallback({responseText: "//"});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is correct", function() {
      controller.abortUpgradeErrorCallback({responseText: '{"message": "msg"}'});
      expect(App.showAlertPopup.calledWith(header, body + ' msg')).to.be.true;
    });
  });

  describe("#abortDowngradeErrorCallback()", function () {
    var header = Em.I18n.t('admin.stackDowngrade.state.paused.fail.header');
    var body = Em.I18n.t('admin.stackDowngrade.state.paused.fail.body');

    beforeEach(function() {
      sinon.stub(App, 'showAlertPopup');
    });

    afterEach(function() {
      App.showAlertPopup.restore();
    });

    it("data is null", function() {
      controller.abortDowngradeErrorCallback(null);
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is null", function() {
      controller.abortDowngradeErrorCallback({responseText: null});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is incorrect", function() {
      controller.abortDowngradeErrorCallback({responseText: "//"});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is correct", function() {
      controller.abortDowngradeErrorCallback({responseText: '{"message": "msg"}'});
      expect(App.showAlertPopup.calledWith(header, body + ' msg')).to.be.true;
    });
  });

  describe("#retryUpgrade()", function () {

    it("requestInProgress should be true", function() {
      controller.retryUpgrade();
      expect(controller.get('requestInProgress')).to.be.true;
    });

    it("isRetryPending should be true", function() {
      controller.retryUpgrade();
      expect(controller.get('isRetryPending')).to.be.true;
    });

    it("App.ajax.send should be called", function() {
      controller.set('upgradeId', 1);
      controller.retryUpgrade();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.retry');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.retry',
        sender: controller,
        data: {
          upgradeId: 1
        }
      });
    });
  });

  describe("#upgradeErrorCallback()", function () {
    var header = Em.I18n.t('admin.stackVersions.upgrade.start.fail.title');
    var body = "";

    beforeEach(function() {
      sinon.stub(App, 'showAlertPopup');
    });

    afterEach(function() {
      App.showAlertPopup.restore();
    });

    it("data is null", function() {
      controller.upgradeErrorCallback(null);
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is null", function() {
      controller.upgradeErrorCallback({responseText: null});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is incorrect", function() {
      controller.upgradeErrorCallback({responseText: "//"});
      expect(App.showAlertPopup.calledWith(header, body)).to.be.true;
    });

    it("data.responseText is correct", function() {
      controller.upgradeErrorCallback({responseText: '{"message": "msg"}'});
      expect(App.showAlertPopup.calledWith(header, 'msg')).to.be.true;
    });
  });

  describe("#updateOptionsSuccessCallback()", function () {

    it("skipComponentFailures: true, skipSCFailures: true", function() {
      var params = {
        skipComponentFailures: 'true',
        skipSCFailures: 'true'
      };
      controller.updateOptionsSuccessCallback({}, {}, params);
      expect(controller.get('failuresTolerance')).to.be.eql(Em.Object.create({
        skipComponentFailures: true,
        skipSCFailures: true
      }));
    });

    it("skipComponentFailures: false, skipSCFailures: false", function() {
      var params = {
        skipComponentFailures: 'false',
        skipSCFailures: 'false'
      };
      controller.updateOptionsSuccessCallback({}, {}, params);
      expect(controller.get('failuresTolerance')).to.be.eql(Em.Object.create({
        skipComponentFailures: false,
        skipSCFailures: false
      }));
    });
  });

  describe("#openUpgradeOptions()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'upgradeOptions');
    });

    afterEach(function() {
      controller.upgradeOptions.restore();
    });

    it("upgradeOptions should not be called", function() {
      controller.set('isDowngrade', true);
      controller.openUpgradeOptions();
      expect(controller.upgradeOptions.called).to.be.false;
    });

    it("upgradeOptions should be called", function() {
      controller.set('isDowngrade', false);
      controller.openUpgradeOptions();
      expect(controller.upgradeOptions.calledWith(true, null)).to.be.true;
    });
  });

  describe("#getSupportedUpgradeTypes()", function () {

    it("App.ajax.send should be called", function() {
      controller.getSupportedUpgradeTypes({});
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.get_supported_upgradeTypes');
      expect(args[0]).to.be.eql({
        name: "admin.upgrade.get_supported_upgradeTypes",
        sender: controller,
        data: {},
        success: "getSupportedUpgradeTypesSuccess"
      });
    });
  });

  describe("#getSupportedUpgradeTypesSuccess()", function () {
    var testCases = [
      {
        data: {
          items: []
        },
        expected: false
      },
      {
        data: {
          items: [{
            CompatibleRepositoryVersions: {}
          }]
        },
        expected: false
      },
      {
        data: {
          items: [{
            CompatibleRepositoryVersions: {
              upgrade_types: []
            }
          }]
        },
        expected: false
      },
      {
        data: {
          items: [{
            CompatibleRepositoryVersions: {
              upgrade_types: ['t1']
            }
          }]
        },
        expected: true
      }
    ];

    testCases.forEach(function(test) {
      it("data: " + JSON.stringify(test.data), function() {
        controller.set('upgradeMethods', [Em.Object.create({
          type: 't1',
          allowed: true
        })]);
        controller.getSupportedUpgradeTypesSuccess(test.data);
        expect(controller.get('upgradeMethods')[0].get('allowed')).to.be.equal(test.expected);
      });
    });
  });

  describe("#runPreUpgradeCheckOnlySuccess()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'formatPreCheckMessage').returns({precheckResultsMessage: 'formatted'});
      sinon.stub(controller, 'updateSelectedMethod');
      sinon.stub(controller, 'addPrecheckMessageTooltip');
      controller.set('upgradeMethods', [Em.Object.create({
        type: 'ROLLING'
      })]);
    });

    afterEach(function() {
      controller.formatPreCheckMessage.restore();
      controller.updateSelectedMethod.restore();
      controller.addPrecheckMessageTooltip.restore();
    });

    it("failed check", function() {
      var data = {
        items: [
          {
            UpgradeChecks: {
              status: 'FAIL'
            }
          }
        ]
      };
      var properties = {
        precheckResultsTitle: Em.I18n.t('admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.title'),
        precheckResultsData: data,
        isCheckComplete: true,
        action: 'openMessage',
        precheckResultsMessage: '',
        recheckResultsMessageClass: 'GREEN',
        isPrecheckFailed: false,
        precheckResultsMessageIconClass: 'icon-ok',
        bypassedFailures: false
      };
      controller.runPreUpgradeCheckOnlySuccess(data, {}, {type: 'ROLLING'});
      expect(controller.formatPreCheckMessage.calledWith('FAIL', data, properties)).to.be.true;
      var msg = controller.get('upgradeMethods').findProperty('type', 'ROLLING').get('precheckResultsMessage');
      expect(msg).to.be.equal('formatted');
    });

    it("success check", function() {
      var data = {
        items: []
      };
      controller.runPreUpgradeCheckOnlySuccess(data, {}, {type: 'ROLLING'});
      var msg = controller.get('upgradeMethods').findProperty('type', 'ROLLING').get('precheckResultsMessage');
      expect(msg).to.be.equal(Em.I18n.t('admin.stackVersions.version.upgrade.upgradeOptions.preCheck.allPassed'));
    });

    it("updateSelectedMethod should be called", function() {
      var data = {
        items: []
      };
      controller.runPreUpgradeCheckOnlySuccess(data, {}, {type: 'ROLLING'});
      expect(controller.updateSelectedMethod.calledWith(false)).to.be.true;
    });

    it("addPrecheckMessageTooltip should be called", function() {
      var data = {
        items: []
      };
      controller.runPreUpgradeCheckOnlySuccess(data, {}, {type: 'ROLLING'});
      expect(controller.addPrecheckMessageTooltip.calledOnce).to.be.true;
    });
  });

  describe("#formatPreCheckMessage()", function () {

    it("should return formatted message", function() {
      var data = {
        items: [{
          UpgradeChecks: {
            status: 'FAIL'
          }
        }]
      };
      expect(controller.formatPreCheckMessage('FAIL', data, {precheckResultsMessage: 'pre'})).to.be.eql({
        "precheckResultsMessage": "1 Required pre",
        "precheckResultsMessageClass": "RED",
        "isPrecheckFailed": true,
        "precheckResultsMessageIconClass": "icon-remove"
      });
    });
  });

  describe("#addPrecheckMessageTooltip()", function () {

    beforeEach(function() {
      sinon.stub(Em.run, 'later', function(ctx, callback) {
        callback();
      });
      sinon.stub(App, 'tooltip');
    });

    afterEach(function() {
      Em.run.later.restore();
      App.tooltip.restore();
    });

    it("App.tooltip should be called", function() {
      controller.addPrecheckMessageTooltip();
      expect(App.tooltip.calledOnce).to.be.true;
    });
  });

  describe("#runPreUpgradeCheckOnlyError()", function () {

    it("upgradeMethod should be updated", function() {
      controller.set('upgradeMethods', [Em.Object.create({
        type: 'ROLLING'
      })]);
      controller.runPreUpgradeCheckOnlyError({}, {}, '', {}, {type: 'ROLLING'});
      expect(JSON.stringify(controller.get('upgradeMethods').findProperty('type', 'ROLLING'))).to.be.equal(JSON.stringify({
        "type": "ROLLING",
        "precheckResultsMessage": Em.I18n.t('admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.failed.link'),
        "precheckResultsTitle": Em.I18n.t('admin.stackVersions.version.upgrade.upgradeOptions.preCheck.msg.failed.title'),
        "precheckResultsMessageClass": "RED",
        "isPrecheckFailed": true,
        "precheckResultsMessageIconClass": "icon-warning-sign",
        "action": "rerunCheck"
      }));
    });
  });

  describe("#updateSelectedMethod()", function () {

    beforeEach(function() {
      controller.set('upgradeMethods', [
        Em.Object.create({
          type: 'ROLLING',
          isPrecheckFailed: false,
          selected: true
        }),
        Em.Object.create({
          type: 'NON_ROLLING',
          isPrecheckFailed: false,
          selected: true
        })
      ]);
    });

    it("should select upgrade method", function() {
      controller.set('upgradeType', 'ROLLING');
      controller.updateSelectedMethod(true);
      expect(controller.get('upgradeMethods').findProperty('type', 'ROLLING').get('selected')).to.be.true;
    });

    it("isPrecheckFailed true for ROLLING and NON_ROLLING", function() {
      controller.updateSelectedMethod(false);
      expect(controller.get('upgradeMethods').findProperty('type', 'ROLLING').get('selected')).to.be.true;
      expect(controller.get('upgradeMethods').findProperty('type', 'NON_ROLLING').get('selected')).to.be.true;
    });

    it("isPrecheckFailed false for ROLLING and NON_ROLLING", function() {
      controller.get('upgradeMethods').setEach('isPrecheckFailed', true);
      controller.updateSelectedMethod(false);
      expect(controller.get('upgradeMethods').findProperty('type', 'ROLLING').get('selected')).to.be.false;
      expect(controller.get('upgradeMethods').findProperty('type', 'NON_ROLLING').get('selected')).to.be.false;
    });
  });

  describe("#runPreUpgradeCheckError()", function () {

    it("requestInProgress should be false", function() {
      controller.runPreUpgradeCheckError();
      expect(controller.get('requestInProgress')).to.be.false;
    });
  });

  describe("#confirmRetryUpgrade()", function () {

    beforeEach(function() {
      sinon.spy(App, 'showConfirmationPopup');
      sinon.stub(controller, 'retryUpgrade');
    });

    afterEach(function() {
      App.showConfirmationPopup.restore();
      controller.retryUpgrade.restore();
    });

    it("App.showConfirmationPopup should be called", function() {
      var popup = controller.confirmRetryUpgrade(Em.Object.create());
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.retryUpgrade.calledOnce).to.be.true;
    });
  });

  describe("#confirmRetryDowngrade()", function () {

    beforeEach(function() {
      sinon.spy(App, 'showConfirmationPopup');
      sinon.stub(controller, 'retryUpgrade');
    });

    afterEach(function() {
      App.showConfirmationPopup.restore();
      controller.retryUpgrade.restore();
    });

    it("App.showConfirmationPopup should be called", function() {
      var popup = controller.confirmRetryDowngrade(Em.Object.create());
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.retryUpgrade.calledOnce).to.be.true;
    });
  });

  describe("#installRepoVersionError()", function () {
    var header = Em.I18n.t('admin.stackVersions.upgrade.installPackage.fail.title');
    var mock = Em.Object.create({
      id: 1,
      defaultStatus: 'NOT_REQUIRED',
      stackVersion: {}
    });

    beforeEach(function() {
      sinon.stub(App, 'showAlertPopup');
      sinon.stub(App.RepositoryVersion, 'find').returns(mock);
    });

    afterEach(function() {
      App.showAlertPopup.restore();
      App.RepositoryVersion.find.restore();
    });

    it("responseText is incorrect", function() {
      var data = {
        responseText: null
      };
      controller.installRepoVersionError(data, null, mock);
      expect(App.showAlertPopup.calledWith(header, "")).to.be.true;
    });

    it("statusText is timeout", function() {
      var data = {
        responseText: '',
        statusText: 'timeout'
      };
      controller.installRepoVersionError(data, null, mock);
      expect(App.showAlertPopup.calledWith(header, Em.I18n.t('admin.stackVersions.upgrade.installPackage.fail.timeout'))).to.be.true;
    });

    it("responseText is correct", function() {
      var data = {
        responseText: '{"message":"msg"}'
      };
      controller.installRepoVersionError(data, null, mock);
      expect(App.showAlertPopup.calledWith(header, 'msg')).to.be.true;
    });
  });

  describe("#showProgressPopup()", function () {
    var mock = {
      initPopup: Em.K
    };

    beforeEach(function() {
      sinon.stub(App.router, 'get').withArgs('highAvailabilityProgressPopupController').returns(mock);
      sinon.stub(mock, 'initPopup');
      sinon.stub(controller, 'getRepoVersionInstallId').returns([1]);
    });

    afterEach(function() {
      App.router.get.restore();
      mock.initPopup.restore();
      controller.getRepoVersionInstallId.restore();
    });

    it("initPopup should be called", function() {
      controller.showProgressPopup(Em.Object.create({displayName: 'v1'}));
      expect(mock.initPopup.calledWith(
        Em.I18n.t('admin.stackVersions.details.install.hosts.popup.title').format('v1'),
        [1],
        controller
      )).to.be.true;
    });
  });

  describe('#getRepoVersionInstallId', function() {
    beforeEach(function() {
      this.mockDB = sinon.stub(App.db, 'get');
      this.mockRequests = sinon.stub(App.router, 'get');
    });
    afterEach(function() {
      this.mockDB.restore();
      this.mockRequests.restore();
    });

    it('should return id from latest version install', function() {
      this.mockDB.returns(null);
      this.mockRequests.returns([Em.Object.create({
        name: 'Install version',
        id: 1
      })]);
      expect(controller.getRepoVersionInstallId()[0]).to.be.equal(1);
    });
    it('should return id from localDB', function() {
      this.mockDB.returns([2]);
      this.mockRequests.returns([Em.Object.create({
        name: 'Install version',
        id: 2
      })]);
      expect(controller.getRepoVersionInstallId()[0]).to.be.equal(2);
    });
    it('should return id from latest version install and ignore deprecated localDb value', function() {
      this.mockDB.returns([2]);
      this.mockRequests.returns([Em.Object.create({
        name: 'Install version',
        id: 3
      })]);
      expect(controller.getRepoVersionInstallId()[0]).to.be.equal(3);
    });
  });

  describe("#finish()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'setDBProperties', Em.K);
      sinon.stub(App.clusterStatus, 'setClusterStatus');
      App.set('upgradeState', 'COMPLETED');
      controller.set('upgradeVersion', '');
    });

    afterEach(function() {
      controller.setDBProperties.restore();
      App.clusterStatus.setClusterStatus.restore();
    });

    it("setDBProperties should be called", function() {
      controller.finish();
      expect(controller.setDBProperties.calledWith({
        upgradeId: undefined,
        upgradeState: 'NOT_REQUIRED',
        upgradeVersion: undefined,
        currentVersion: undefined,
        upgradeTypeDisplayName: undefined,
        upgradeType: undefined,
        isWizardRestricted: false,
        failuresTolerance: undefined,
        isDowngrade: undefined,
        downgradeAllowed: undefined
      })).to.be.true;
    });

    it("App.clusterStatus.setClusterStatus should be called", function() {
      controller.finish();
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });

    it("upgradeState should be NOT_REQUIRED", function() {
      controller.finish();
      expect(App.get('upgradeState')).to.be.equal('NOT_REQUIRED');
    });

    it("currentStackVersion should be set", function() {
      controller.set('upgradeVersion', 'HDP-2.2');
      controller.finish();
      expect(controller.get('upgradeVersion')).to.be.equal('HDP-2.2');
    });
  });

  describe("#loadRepositories()", function () {

    beforeEach(function() {
      sinon.stub(App.router, 'get').withArgs('clusterController.isLoaded').returns(true);
    });

    afterEach(function() {
      App.router.get.restore();
    });

    it("App.ajax.send should be called", function() {
      App.set('currentStackVersion', 'HDP-2.2');
      controller.loadRepositories();
      var args = testHelpers.findAjaxRequest('name', 'cluster.load_repositories');
      expect(args[0]).to.be.eql({
        name: 'cluster.load_repositories',
        sender: controller,
        data: {
          stackName: 'HDP',
          stackVersion: '2.2'
        },
        success: 'loadRepositoriesSuccessCallback',
        error: 'loadRepositoriesErrorCallback'
      });
    });
  });

  describe("#loadRepositoriesSuccessCallback()", function () {

    it("allRepos should be set", function() {
      var data = {
        items: [
          {
            repositories: [
              {
                Repositories: {
                  os_type: 'redhat',
                  base_url: 'base_url',
                  repo_id: 'repo_id',
                  repo_name: 'repo_name',
                  stack_name: 'stack_name',
                  stack_version: 'stack_version'
                }
              }
            ]
          }
        ]
      };
      controller.loadRepositoriesSuccessCallback(data);
      expect(controller.get('allRepos')[0].name).to.be.equal('redhat');
      expect(JSON.stringify(controller.get('allRepos')[0].repositories[0])).to.be.equal(JSON.stringify({
        "baseUrl": "base_url",
        "osType": "redhat",
        "repoId": "repo_id",
        "repoName": "repo_name",
        "stackName": "stack_name",
        "stackVersion": "stack_version",
        "isFirst": true
      }));
    });
  });

  describe("#getServiceVersionFromRepo()", function () {

    var cases = [
      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.6',
        repoVersions: [
          Em.Object.create({
            'id': '1',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.5',
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.6.2'
              })
            ]
          }),
          Em.Object.create({
            'id': '2',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.7.3'
              })
            ]
          })
        ],
        services: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'desiredRepositoryVersionId': '2'
          })
        ],
        stackServices: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'stackName': 'HDP',
            'stackVersion': '2.6'
          })
        ],
        title: 'If multiple stacks should select the repo on the current stack',
        expected: {'HDFS': '2.7.3'}
      },

      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.6',
        repoVersions : [
          Em.Object.create({
            'id': '1',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.6.5'
              })
            ]
          }),
          Em.Object.create({
            'id': '2',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.7.3'
              })
            ]
          })
        ],
        services: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'desiredRepositoryVersionId': '2'
          })
        ],
        stackServices: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'stackName': 'HDP',
            'stackVersion': '2.6'
          })
        ],
        title: 'If multiple repositories in the same stack should select by id',
        expected: {'HDFS': '2.7.3'}
      },

      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.6',
        repoVersions : [
          Em.Object.create({
            'id': '1',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'isCurrent': false,
            'isStandard': true,
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.6.5'
              })
            ]
          }),
          Em.Object.create({
            'id': '2',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'isCurrent': false,
            'isStandard': true,
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.7.3'
              })
            ]
          })
        ],

        services: [
          Em.Object.create({
            'serviceName': 'YARN',
            'desiredRepositoryVersionId': '2'
          })
        ],

        stackServices: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'stackName': 'HDP',
            'stackVersion': '2.6'
          })
        ],
        title: 'No standard repo in current state - nothing should be returned',
        expected: {'HDFS': ''}
      },
      {
        currentStackName: 'HDP',
        currentStackVersionNumber: '2.6',
        repoVersions : [
          Em.Object.create({
            'id': '1',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'isCurrent': true,
            'isStandard': true,
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.6.5'
              })
            ]
          }),
          Em.Object.create({
            'id': '2',
            'stackVersionType': 'HDP',
            'stackVersionNumber': '2.6',
            'isCurrent': false,
            'isStandard': true,
            'stackServices': [
              Em.Object.create({
                'name': 'HDFS',
                'latestVersion': '2.7.3'
              })
            ]
          })
        ],

        services: [
          Em.Object.create({
            'serviceName': 'YARN',
            'desiredRepositoryVersionId': '2'
          })
        ],

        stackServices: [
          Em.Object.create({
            'serviceName': 'HDFS',
            'stackName': 'HDP',
            'stackVersion': '2.6'
          })
        ],
        title: 'Service not installed - get version from current & standard repo',
        expected: {'HDFS': '2.6.5'}
      },

    ];

    afterEach(function() {
      App.get.restore();
      App.Service.find.restore();
      App.StackService.find.restore();
      App.RepositoryVersion.find.restore();
      controller.set('serviceVersionsMap', {});
    });

    cases.forEach(function(item) {
      it(item.title, function() {
        sinon.stub(App, 'get').withArgs('currentStackName').returns(item.currentStackName).withArgs('currentStackVersionNumber').returns(item.currentStackVersionNumber);
        sinon.stub(App.Service, 'find').returns(item.services);
        sinon.stub(App.StackService, 'find').returns(item.stackServices);
        sinon.stub(App.RepositoryVersion, 'find').returns(item.repoVersions);
        controller.getServiceVersionFromRepo();
        expect(controller.get('serviceVersionsMap')).to.be.eql(item.expected);
      });
    });
  });

  describe("#loadCompatibleVersions()", function () {

    beforeEach(function() {
      sinon.stub(App, 'get').returns('stack');
    });

    afterEach(function() {
      App.get.restore();
    });

    it("App.ajax.send should be called", function() {
      controller.loadCompatibleVersions();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.get_compatible_versions');
      expect(args[0]).to.be.eql({
        name: 'admin.upgrade.get_compatible_versions',
        sender: controller,
        data: {
          stackName: 'stack',
          stackVersion: 'stack'
        },
        success: 'loadCompatibleVersionsSuccessCallback'
      });
    });
  });

  describe("#loadCompatibleVersionsSuccessCallback()", function () {
    var mock = [
      Em.Object.create({
        repositoryVersion: 'HDP-1',
        isCompatible: false
      }),
      Em.Object.create({
        repositoryVersion: 'HDP-2',
        isCompatible: false
      })
    ];

    beforeEach(function() {
      sinon.stub(App.RepositoryVersion, 'find').returns(mock);
    });

    afterEach(function() {
      App.RepositoryVersion.find.restore();
    });

    it("should set isCompatible property", function() {
      var data = {
        items: [
          {
            CompatibleRepositoryVersions: {
              repository_version: 'HDP-2'
            }
          }
        ]
      };
      controller.loadCompatibleVersionsSuccessCallback(data);
      expect(mock.mapProperty('isCompatible')).to.be.eql([false, true])
    });
  });

  describe('#removeIopSelect', function() {
    beforeEach(function() {
      sinon.stub(App, 'showConfirmationPopup', Em.clb);
      sinon.stub(App, 'showAlertPopup');
      sinon.stub(App.ModalPopup, 'show');
    });
    afterEach(function() {
      App.showConfirmationPopup.restore();
      App.showAlertPopup.restore();
      App.ModalPopup.show.restore();
    });

    it('App.ajax.send should be called', function() {
      controller.removeIopSelect();
      var args = testHelpers.findAjaxRequest('name', 'admin.stack_versions.removeIopSelect');
      expect(args[0]).exists;
    });
  });

  describe('#confirmRevertPatchUpgrade', function() {
    beforeEach(function() {
      sinon.stub(App.RepositoryVersion, 'find').returns(Em.Object.create());
      sinon.stub(App.ModalPopup, 'show');
      sinon.stub(controller, 'getServicesToBeReverted');
    });
    afterEach(function() {
      App.RepositoryVersion.find.restore();
      App.ModalPopup.show.restore();
      controller.getServicesToBeReverted.restore();
    });

    it('App.ModalPopup.show should be called', function() {
      controller.confirmRevertPatchUpgrade({context: Em.Object.create()});
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe('#getServicesToBeReverted', function() {
    beforeEach(function() {
      sinon.stub(App.Service, 'find').returns(Em.Object.create({isLoaded: true}));
    });
    afterEach(function() {
      App.Service.find.restore();
    });

    it('should return services which will be reverted', function() {
      var version = Em.Object.create({
        stackServices: [
          Em.Object.create({
            name: 'S1',
            isAvailable: false,
            displayName: 's1',
            latestVersion: '1.0'
          }),
          Em.Object.create({
            name: 'S2',
            isAvailable: true,
            displayName: 's2',
            latestVersion: '2.0'
          })
        ]
      });
      var currentStack = Em.Object.create({
        stackServices: [
          Em.Object.create({
            name: 'S2',
            latestVersion: '2.1'
          })
        ]
      });
      expect(controller.getServicesToBeReverted(version, currentStack)).to.be.eql([
        {
          displayName: 's2',
          fromVersion: '2.0',
          toVersion: '2.1'
        }
      ]);
    });
  });

  describe('#revertPatchUpgrade', function() {
    it('App.ajax.send should be called', function() {
      var version = Em.Object.create({
        repositoryVersion: '1.1',
        id: 2,
        displayName: '1.2',
        upgradeType: 'EXPRESS',
        stackVersion: Em.Object.create({
          revertUpgradeId: 1
        })
      });
      controller.revertPatchUpgrade(version);
      expect(controller.get('requestInProgress')).to.be.true;
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.revert');
      expect(args[0]).to.exists;
      expect(args[0].data).to.be.eql({
        upgradeId: 1,
        isDowngrade: true,
        id: 2,
        value: '1.1',
        label: '1.2'
      });
      args[0].callback();
      expect(controller.get('requestInProgress')).to.be.false;
    });
  });

  describe('#getUpgradeDowngradeHeader', function() {

    it('should return downgrade header', function() {
      expect(controller.getUpgradeDowngradeHeader('t1', 'v1', true)).to.be.equal(
        Em.I18n.t('admin.stackUpgrade.dialog.downgrade.header').format('v1')
      );
    });
    it('should return patch upgrade header', function() {
      expect(controller.getUpgradeDowngradeHeader('t1', 'v1', false, Em.Object.create({isPatch: true}))).to.be.equal(
        Em.I18n.t('admin.stackUpgrade.dialog.upgrade.patch.header').format('t1', 'v1')
      );
    });
    it('should return maint upgrade header', function() {
      expect(controller.getUpgradeDowngradeHeader('t1', 'v1', false, Em.Object.create({isMaint: true}))).to.be.equal(
        Em.I18n.t('admin.stackUpgrade.dialog.upgrade.maint.header').format('t1', 'v1')
      );
    });
    it('should return upgrade header', function() {
      expect(controller.getUpgradeDowngradeHeader('t1', 'v1', false, false)).to.be.equal(
        Em.I18n.t('admin.stackUpgrade.dialog.upgrade.header').format('t1', 'v1')
      );
    });
  });

  describe('#confirmDiscardRepoVersion', function() {
    beforeEach(function() {
      sinon.stub(App, 'showConfirmationPopup', Em.clb);
      sinon.stub(controller, 'discardRepoVersion');
    });
    afterEach(function() {
      App.showConfirmationPopup.restore();
      controller.discardRepoVersion.restore();
    });

    it('discardRepoVersion should be called', function() {
      controller.confirmDiscardRepoVersion(Em.Object.create());
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      expect(controller.discardRepoVersion.calledWith(Em.Object.create())).to.be.true;
    });
  });


  describe('#discardRepoVersion', function() {

    it('App.ajax.send should be called', function() {
      var version = Em.Object.create({
        id: 2,
        stackVersionType: 'HDP',
        stackVersionNumber: '2.5'
      });
      controller.discardRepoVersion(version);
      expect(controller.get('requestInProgress')).to.be.true;
      var args = testHelpers.findAjaxRequest('name', 'admin.stack_versions.discard');
      expect(args[0]).to.exists;
      expect(args[0].data).to.be.eql({
        id: 2,
        stackName: 'HDP',
        stackVersion: '2.5'
      });
      args[0].callback();
      expect(controller.get('requestInProgress')).to.be.false;
    });
  });

  describe('#showUpgradeOptions', function () {
    before(function () {
      sinon.stub(controller, 'upgradeOptions', Em.K);
    });
    after(function () {
      controller.upgradeOptions.restore();
    });
    it("show upgrade options popup window", function() {
      var version = Em.Object.create({displayName: 'HDP-2.2'});
      controller.showUpgradeOptions(version);
      expect(controller.upgradeOptions.calledWith(false, version, true)).to.be.true;
    });

    it("runningCheckRequests has 1 item" + Em.I18n.t('common.dismiss'), function () {
      var version = Em.Object.create({displayName: 'HDP-2.2'});
      var popup = controller.upgradeOptions(false, version, true);
      expect( controller.get('runningCheckRequests')).to.have.length(1);
    })
  })

});

});

require.register("test/controllers/main/admin/stack_upgrade_history_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/admin/stack_upgrade_history_controller');
require('utils/string_utils');
var testHelpers = require('test/helpers');
describe('App.MainAdminStackUpgradeHistoryController', function() {

  var controller = App.MainAdminStackUpgradeHistoryController.create({

  });

  describe("#upgradeHistoryUrl", function() {
    before(function () {
      this.mock = sinon.stub(App, 'get');
      this.mock.withArgs('apiPrefix').returns('apiPrefix')
        .withArgs('clusterName').returns('clusterName');
    });
    after(function () {
      this.mock.restore();
    });
    it("should be valid", function() {
      controller.propertyDidChange('upgradeHistoryUrl');
      expect(controller.get('upgradeHistoryUrl')).to.equal('apiPrefix/clusters/clusterName/upgrades?fields=Upgrade');
    });
  });

  describe("#requestStatus", function() {
    beforeEach(function() {
      this.mock = sinon.stub(App, 'get');
    });
    afterEach(function() {
      this.mock.restore();
    });
    it("state should be what the record states", function() {
      this.mock.returns(false);
      controller.set('upgradeData', { Upgrade: {request_status: 'COMPLETED'}});
      controller.propertyDidChange('requestStatus');
      expect(controller.get('requestStatus')).to.equal('COMPLETED');
    });

    it("upgradeData is null", function() {
      this.mock.returns(false);
      controller.set('upgradeData', null);
      controller.propertyDidChange('requestStatus');
      expect(controller.get('requestStatus')).to.be.empty;
    });
  });

  describe("#loadStackUpgradeRecord()", function() {
    it("get upgrade record data", function() {
      controller.set('currentUpgradeRecord', Em.Object.create({'requestId':1, 'direction':'DOWNGRADE'}));
      controller.loadStackUpgradeRecord();
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.data');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        id: 1
      });
    });
  });

  describe("#loadUpgradeRecordSuccessCallback()", function() {
    it("correct data", function() {
      var data = {
        "Upgrade": {
          "request_status": "COMPLETED"
        },
        "upgrade_groups": [
          {
            "UpgradeGroup": {
              "id": 1
            },
            "upgrade_items": []
          }
        ]};
      controller.loadUpgradeRecordSuccessCallback(data);
      expect(controller.get('upgradeData') == null).to.be.false;
    });

    it("data is null", function() {
      var data = null;
      controller.set('upgradeData', null)
      controller.loadUpgradeRecordSuccessCallback(data);
      expect(controller.get('upgradeData') == null).to.be.true;
    });
  });

  describe("#getUpgradeItem()", function() {
    it("default callback", function() {
      var item = Em.Object.create({
        request_id: 1,
        group_id: 2,
        stage_id: 3
      });
      controller.getUpgradeItem(item);
      var args = testHelpers.findAjaxRequest('name', 'admin.upgrade.upgrade_item');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].success).to.be.equal('getUpgradeItemSuccessCallback');
      expect(args[0].data).to.be.eql({
        upgradeId: 1,
        groupId: 2,
        stageId: 3
      });
    });
  });
});

});

require.register("test/controllers/main/admin_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');

require('models/service');
require('models/host_component');
require('controllers/main/admin');

describe('MainAdminController', function () {

  var controller = App.MainAdminController.create();

  describe('#isAccessAvailable()', function () {

    beforeEach(function () {
      Em.propertyDidChange(controller, 'isAccessAvailable');
    });

    it('Services do not match dependencies', function () {
      App.Service.find().clear();
      App.store.safeLoad(App.Service, {
        id: 'HDFS',
        service_name: 'HDFS'
      });
      expect(controller.get("isAccessAvailable")).to.be.false;
    });
    it('APP_TIMELINE_SERVER is absent', function () {
      App.Service.find().clear();
      App.HostComponent.find().clear();
      expect(controller.get("isAccessAvailable")).to.be.false;
    });
    it('Only one YARN service installed', function () {
      App.store.safeLoad(App.Service, {
        id: 'YARN',
        service_name: 'YARN'
      });
      expect(controller.get("isAccessAvailable")).to.be.false;
    });
    it('TEZ and YARN services installed', function () {
      App.store.safeLoad(App.Service, {
        id: 'TEZ',
        service_name: 'TEZ'
      });
      expect(controller.get("isAccessAvailable")).to.be.false;
    });
    it('TEZ and YARN services, APP_TIMELINE_SERVER component installed', function () {
      App.store.safeLoad(App.HostComponent, {
        id: 'APP_TIMELINE_SERVER_host1',
        component_name: 'APP_TIMELINE_SERVER'
      });
      expect(controller.get("isAccessAvailable")).to.be.true;
    });
  });
});

});

require.register("test/controllers/main/alert_definitions_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

require('controllers/main/alert_definitions_controller');
require('models/alerts/alert_definition');
var testHelpers = require('test/helpers');

var controller;
describe('App.MainAlertDefinitionsController', function() {

  beforeEach(function() {

    controller = App.MainAlertDefinitionsController.create();

  });

  describe('#toggleDefinitionState', function() {

    beforeEach(function() {
      controller.reopen({
        content: [
          App.AlertDefinition.createRecord({id: 1, enabled: true})
        ]
      });
    });

    it('should do ajax-request', function() {
      var alertDefinition = controller.get('content')[0];
      controller.toggleDefinitionState(alertDefinition);
      var args = testHelpers.findAjaxRequest('name', 'alerts.update_alert_definition');
      expect(args).to.exists;
    });

  });

  describe('#isCriticalAlerts', function () {

    beforeEach(function () {
      controller.set('content', Em.A([
        Em.Object.create({summary: {CRITICAL: {count: 0}}}),
        Em.Object.create({summary: {CRITICAL: {}}})
      ]));
    });

    it('if summary is undefined, 0 should be used', function () {
      expect(controller.get('isCriticalAlerts')).to.be.false;
    });

    it('should be true, if some CRITICAL count is greater than 0', function () {
      controller.get('content').pushObject(Em.Object.create({summary: {CRITICAL: {count: 1}}}));
      expect(controller.get('isCriticalAlerts')).to.be.true;
    });

  });

  describe("#toggleState()", function() {

    beforeEach(function() {
      sinon.stub(App, 'showConfirmationFeedBackPopup', Em.clb);
      sinon.stub(controller, 'toggleDefinitionState');
    });
    afterEach(function() {
      App.showConfirmationFeedBackPopup.restore();
      controller.toggleDefinitionState.restore();
    });

    it("toggleDefinitionState should be called", function() {
      var def = Em.Object.create();
      controller.toggleState({context: def});
      expect(App.showConfirmationFeedBackPopup.calledOnce).to.be.true;
      expect(controller.toggleDefinitionState.calledWith(def)).to.be.true;
    });
  });

});

});

require.register("test/controllers/main/alerts/add_alert_definition/add_alert_definition_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/alerts/add_alert_definition/add_alert_definition_controller');
var testHelpers = require('test/helpers');
var controller;

describe('App.AddAlertDefinitionController', function () {

  beforeEach(function () {
    controller = App.AddAlertDefinitionController.create();
  });

  describe("#createNewAlertDefinition()", function () {
    it("valid request is sent", function () {
      controller.createNewAlertDefinition('data');
      var args = testHelpers.findAjaxRequest('name', 'alerts.create_alert_definition');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({data: 'data'});
    });
  });

  describe("#finish()", function () {
    beforeEach(function () {
      sinon.stub(controller, 'clear', Em.K);
    });
    afterEach(function () {
      controller.clear.restore();
    });

    it("clear is called", function () {
      controller.finish();
      expect(controller.clear.calledOnce).to.be.true;
    });
  });
});
});

require.register("test/controllers/main/alerts/add_alert_definition/step1_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/alerts/add_alert_definition/step1_controller');

var controller;

describe('App.AddAlertDefinitionStep1Controller', function () {

  beforeEach(function () {
    controller = App.AddAlertDefinitionStep1Controller.create({content: {}});
  });

  describe('#selectType', function() {

    beforeEach(function () {
      controller.get('alertDefinitionsTypes').setEach('isActive', false);
    });

    it('should set isActive for selected type', function () {
      var e = {context: {value: 'PORT'}};
      controller.selectType(e);
      expect(controller.get('alertDefinitionsTypes').findProperty('value', 'PORT').get('isActive')).to.be.true;
    });

  });

  describe('#loadStep', function () {

    beforeEach(function () {
      controller.set('content.selectedType', 'PORT');

    });

    it('should set predefined type', function () {
      controller.loadStep();
      expect(controller.get('alertDefinitionsTypes').findProperty('value', 'PORT').get('isActive')).to.be.true;
    });

  });

  describe('#isSubmitDisabled', function () {

    beforeEach(function () {
      controller.get('alertDefinitionsTypes').setEach('isActive', false);
    });

    it('should be based on isActive', function () {

      expect(controller.get('isSubmitDisabled')).to.be.true;
      controller.get('alertDefinitionsTypes').objectAt(0).set('isActive', true);
      expect(controller.get('isSubmitDisabled')).to.be.false;

    });

  });

});
});

require.register("test/controllers/main/alerts/alert_definitions_actions_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

var controller;

describe('App.MainAlertDefinitionActionsController', function () {

  beforeEach(function () {
    controller = App.MainAlertDefinitionActionsController.create({});
  });

  describe('#actionHandler', function () {

    beforeEach(function () {
      sinon.stub(controller, 'createNewAlertDefinition', Em.K);
      sinon.stub(controller, 'manageAlertGroups', Em.K);
      sinon.stub(controller, 'manageNotifications', Em.K);
    });

    afterEach(function () {
      controller.createNewAlertDefinition.restore();
      controller.manageAlertGroups.restore();
      controller.manageNotifications.restore();
    });

    it('should call proper methods', function () {

      controller.actionHandler({context: {action: 'createNewAlertDefinition'}});
      controller.actionHandler({context: {action: 'manageAlertGroups'}});
      controller.actionHandler({context: {action: 'manageNotifications'}});
      expect(controller.createNewAlertDefinition.calledOnce).to.be.ok;
      expect(controller.manageAlertGroups.calledOnce).to.be.ok;
      expect(controller.manageNotifications.calledOnce).to.be.ok;

    });

  });

  describe('#manageAlertGroups', function () {

    beforeEach(function () {
      sinon.stub(App.ModalPopup, 'show', Em.K);
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it('should show modal popup', function () {
      controller.manageAlertGroups();
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });

  });

  describe('#createNewAlertDefinition', function () {

    beforeEach(function () {
      sinon.stub(App.router, 'transitionTo', Em.K);
    });

    afterEach(function () {
      App.router.transitionTo.restore();
    });

    it('should navigate to wizard', function () {

      controller.createNewAlertDefinition();
      expect(App.router.transitionTo.calledWith('alertAdd')).to.be.true;

    });

  });

});
});

require.register("test/controllers/main/alerts/alert_instances_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

var controller;

describe('App.MainAlertInstancesController', function () {

  beforeEach(function () {
    controller = App.MainAlertInstancesController.create({});
  });

  afterEach(function () {
    clearTimeout(controller.get('updateTimer'));
  });

  describe('#fetchAlertInstances', function () {

    describe('loading instances from correct endpoint', function () {

      it('should load by Host name', function () {

        controller.loadAlertInstancesByHost('host');
        var callArgs = testHelpers.findAjaxRequest('name', 'alerts.instances.by_host')[0];
        expect(callArgs.name).to.equal('alerts.instances.by_host');
        expect(callArgs.data.hostName).to.equal('host');

      });

      it('should load by AlertDefinition id', function () {

        controller.loadAlertInstancesByAlertDefinition('1');
        var callArgs = testHelpers.findAjaxRequest('name', 'alerts.instances.by_definition')[0];
        expect(callArgs.name).to.equal('alerts.instances.by_definition');
        expect(callArgs.data.definitionId).to.equal('1');

      });

      it('should load all', function () {
        controller.loadAlertInstances();
        var callArgs = testHelpers.findAjaxRequest('name', 'alerts.instances')[0];
        expect(callArgs).to.exists;

      });

    });

  });


  describe('#showPopup', function () {

    describe('#bodyClass', function () {

      var bodyView;

      beforeEach(function () {
        controller.reopen({unhealthyAlertInstances: [
          App.AlertInstance.createRecord({state: 'CRITICAL'}),
          App.AlertInstance.createRecord({state: 'WARNING'}),
          App.AlertInstance.createRecord({state: 'WARNING'}),
          App.AlertInstance.createRecord({state: 'CRITICAL'})
        ]});
        bodyView = controller.showPopup().get('bodyClass').create();
      });

      it('#content', function () {
        expect(bodyView.get('content.length')).to.equal(4);
      });

      it('#isLoaded', function () {
        expect(bodyView.get('isLoaded')).to.be.true;
      });

      it('#isAlertEmptyList', function () {
        expect(bodyView.get('isAlertEmptyList')).to.be.false;
      });

    });

  });

});
});

require.register("test/controllers/main/alerts/definitions_configs_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');
var controller;

function getController() {
  return App.MainAlertDefinitionConfigsController.create({
    allServices: ['service1', 'service2', 'service3'],
    allComponents: ['component1', 'component2', 'component3'],
    aggregateAlertNames: ['alertDefinitionName', 'alertDefinitionName2', 'alertDefinitionName3']
  });
}

function getEmptyArray() {
  return [];
}

describe('App.MainAlertDefinitionConfigsController', function () {

  beforeEach(function () {
    controller = getController();
  });

  App.TestAliases.testAsComputedOr(getController(), 'hasErrors', ['someConfigIsInvalid', 'hasThresholdsError']);

  describe('#renderConfigs()', function () {

    beforeEach(function () {
      controller.set('content', Em.Object.create({}));
      sinon.stub(controller, 'renderPortConfigs', getEmptyArray);
      sinon.stub(controller, 'renderMetricConfigs', getEmptyArray);
      sinon.stub(controller, 'renderWebConfigs', getEmptyArray);
      sinon.stub(controller, 'renderScriptConfigs', getEmptyArray);
      sinon.stub(controller, 'renderAggregateConfigs', getEmptyArray);
    });

    afterEach(function () {
      controller.renderPortConfigs.restore();
      controller.renderMetricConfigs.restore();
      controller.renderWebConfigs.restore();
      controller.renderScriptConfigs.restore();
      controller.renderAggregateConfigs.restore();
    });

    it('should call renderPortConfigs method', function () {
      controller.set('alertDefinitionType', 'PORT');
      controller.renderConfigs();
      expect(controller.renderPortConfigs.calledOnce).to.be.true;
    });

    it('should call renderMetricConfigs method', function () {
      controller.set('alertDefinitionType', 'METRIC');
      controller.renderConfigs();
      expect(controller.renderMetricConfigs.calledOnce).to.be.true;
    });

    it('should call renderWebConfigs method', function () {
      controller.set('alertDefinitionType', 'WEB');
      controller.renderConfigs();
      expect(controller.renderWebConfigs.calledOnce).to.be.true;
    });

    it('should call renderScriptConfigs method', function () {
      controller.set('alertDefinitionType', 'SCRIPT');
      controller.renderConfigs();
      expect(controller.renderScriptConfigs.calledOnce).to.be.true;
    });

    it('should call renderAggregateConfigs method', function () {
      controller.set('alertDefinitionType', 'AGGREGATE');
      controller.renderConfigs();
      expect(controller.renderAggregateConfigs.calledOnce).to.be.true;
    });

  });

  describe('#renderPortConfigs()', function () {

    beforeEach(function () {
      controller.set('content', Em.Object.create({
        name: 'alertDefinitionName',
        service: {displayName: 'alertDefinitionService'},
        componentName: 'component1',
        scope: 'HOST',
        description: 'alertDefinitionDescription',
        interval: 60,
        reporting: [
          Em.Object.create({
            type: 'warning',
            value: 10
          }),
          Em.Object.create({
            type: 'critical',
            value: 20
          }),
          Em.Object.create({
            type: 'ok',
            value: 30
          })
        ],
        uri: 'alertDefinitionUri',
        defaultPort: '777'
      }));
    });

    it('isWizard = true', function () {
      controller.set('isWizard', true);
      var result = controller.renderPortConfigs();
      expect(result.length).to.equal(11);
    });

    it('isWizard = false', function () {
      controller.set('isWizard', false);
      var result = controller.renderPortConfigs();
      expect(result.length).to.equal(5);
    });

  });

  describe('#renderMetricConfigs()', function () {

    beforeEach(function () {
      controller.set('content', Em.Object.create({
        name: 'alertDefinitionName',
        service: {displayName: 'alertDefinitionService'},
        componentName: 'component1',
        scope: 'HOST',
        description: 'alertDefinitionDescription',
        interval: 60,
        reporting: [
          Em.Object.create({
            type: 'warning',
            value: 10
          }),
          Em.Object.create({
            type: 'critical',
            value: 20
          }),
          Em.Object.create({
            type: 'ok',
            value: 30
          })
        ],
        uri: {
          "http": "{{mapred-site/mapreduce.jobhistory.webapp.address}}",
          "https": "{{mapred-site/mapreduce.jobhistory.webapp.https.address}}",
          "https_property": "{{mapred-site/mapreduce.jobhistory.http.policy}}",
          "https_property_value": "HTTPS_ONLY",
          "default_port": 0.0,
          "connection_timeout": 123
        },
        jmx: {
          propertyList: ['property1', 'property2'],
          value: 'jmxValue'
        },
        ganglia: {
          propertyList: null,
          value: null
        }
      }));
    });

    it('isWizard = true', function () {
      controller.set('isWizard', true);
      var result = controller.renderMetricConfigs();
      expect(result.length).to.equal(12);
    });

    it('isWizard = false', function () {
      controller.set('isWizard', false);
      var result = controller.renderMetricConfigs();
      expect(result.length).to.equal(6);
    });

  });

  describe('#renderWebConfigs()', function () {

    beforeEach(function () {
      controller.set('content', Em.Object.create({
        name: 'alertDefinitionName',
        service: {displayName: 'alertDefinitionService'},
        componentName: 'component1',
        scope: 'HOST',
        description: 'alertDefinitionDescription',
        interval: 60,
        reporting: [
          Em.Object.create({
            type: 'warning',
            value: 10
          }),
          Em.Object.create({
            type: 'critical',
            value: 20
          }),
          Em.Object.create({
            type: 'ok',
            value: 30
          })
        ],
        uri: {
          "http": "{{mapred-site/mapreduce.jobhistory.webapp.address}}",
          "https": "{{mapred-site/mapreduce.jobhistory.webapp.https.address}}",
          "https_property": "{{mapred-site/mapreduce.jobhistory.http.policy}}",
          "https_property_value": "HTTPS_ONLY",
          "default_port": 0.0,
          "connection_timeout": 123
        }
      }));
    });

    it('isWizard = true', function () {
      controller.set('isWizard', true);
      var result = controller.renderWebConfigs();
      expect(result.length).to.equal(12);
    });

    it('isWizard = false', function () {
      controller.set('isWizard', false);
      var result = controller.renderWebConfigs();
      expect(result.length).to.equal(6);
    });

  });

  describe('#renderScriptConfigs()', function () {

    beforeEach(function () {
      controller.set('content', Em.Object.create({
        name: 'alertDefinitionName',
        service: {displayName: 'alertDefinitionService'},
        componentName: 'component1',
        scope: 'HOST',
        description: 'alertDefinitionDescription',
        interval: 60,
        parameters: [
          Em.Object.create({}),
          Em.Object.create({}),
        ],
        reporting: [
          Em.Object.create({
            type: 'warning',
            value: 10
          }),
          Em.Object.create({
            type: 'critical',
            value: 20
          }),
          Em.Object.create({
            type: 'ok',
            value: 30
          })
        ],
        location: 'path to script'
      }));
    });

    it('isWizard = true', function () {
      controller.set('isWizard', true);
      var result = controller.renderScriptConfigs();
      expect(result.length).to.equal(10);
    });

    it('isWizard = false', function () {
      controller.set('isWizard', false);
      var result = controller.renderScriptConfigs();
      expect(result.length).to.equal(4);
    });

  });

  describe('#renderAggregateConfigs()', function () {

    it('should render array of configs with correct values', function () {

      controller.set('content', Em.Object.create({
        name: 'alertDefinitionName',
        description: 'alertDefinitionDescription',
        interval: 60,
        reporting: [
          Em.Object.create({
            type: 'warning',
            value: 10
          }),
          Em.Object.create({
            type: 'critical',
            value: 20
          }),
          Em.Object.create({
            type: 'ok',
            value: 30
          })
        ]
      }));

      var result = controller.renderAggregateConfigs();

      expect(result.length).to.equal(5);
    });

  });

  describe('#editConfigs()', function () {

    beforeEach(function () {
      controller.set('configs', [
        Em.Object.create({value: 'value1', previousValue: '', isDisabled: true}),
        Em.Object.create({value: 'value2', previousValue: '', isDisabled: true}),
        Em.Object.create({value: 'value3', previousValue: '', isDisabled: true})
      ]);
      controller.set('canEdit', false);
      controller.editConfigs();
    });

    it('should set previousValue', function () {
      expect(controller.get('configs').mapProperty('previousValue')).to.eql(['value1', 'value2', 'value3']);
    });
    it('should set isDisabled for each config', function () {
      expect(controller.get('configs').someProperty('isDisabled', true)).to.be.false;
    });
    it('should change canEdit flag', function () {
      expect(controller.get('canEdit')).to.be.true;
    });

  });

  describe('#cancelEditConfigs()', function () {

    beforeEach(function () {
      controller.set('configs', [
        Em.Object.create({value: '', previousValue: 'value1', isDisabled: false}),
        Em.Object.create({value: '', previousValue: 'value2', isDisabled: false}),
        Em.Object.create({value: '', previousValue: 'value3', isDisabled: false})
      ]);
      controller.set('canEdit', true);
      controller.cancelEditConfigs();
    });

    it('should set previousValue', function () {
      expect(controller.get('configs').mapProperty('value')).to.eql(['value1', 'value2', 'value3']);
    });
    it('should set isDisabled for each config', function () {
      expect(controller.get('configs').someProperty('isDisabled', false)).to.be.false;
    });
    it('should change canEdit flag', function () {
      expect(controller.get('canEdit')).to.be.false;
    });

  });

  describe('#saveConfigs()', function () {

    beforeEach(function () {
      controller.set('configs', [
        Em.Object.create({isDisabled: true}),
        Em.Object.create({isDisabled: true}),
        Em.Object.create({isDisabled: true})
      ]);
      controller.set('canEdit', true);
      controller.saveConfigs();
    });

    it('should set isDisabled for each config', function () {
      expect(controller.get('configs').someProperty('isDisabled', false)).to.be.false;
    });
    it('should change canEdit flag', function () {
      expect(controller.get('canEdit')).to.be.false;
    });
    it('should sent 1 request', function () {
      var args = testHelpers.findAjaxRequest('name', 'alerts.update_alert_definition');
      expect(args[0]).to.exists;
    });

  });

  describe('#getPropertiesToUpdate()', function () {

    beforeEach(function () {
      controller.set('content', {
        rawSourceData: {
          path1: 'value',
          path2: {
            path3: 'value'
          }
        }
      });
    });

    var testCases = [
      {
        m: 'should ignore configs with wasChanged false',
        configs: [
          Em.Object.create({
            wasChanged: false,
            apiProperty: 'name1',
            apiFormattedValue: 'test1'
          }),
          Em.Object.create({
            wasChanged: true,
            apiProperty: 'name2',
            apiFormattedValue: 'test2'
          }),
          Em.Object.create({
            wasChanged: false,
            apiProperty: 'name3',
            apiFormattedValue: 'test3'
          })
        ],
        result: {
          'AlertDefinition/name2': 'test2'
        }
      },
      {
        m: 'should correctly map deep source properties',
        configs: [
          Em.Object.create({
            wasChanged: true,
            apiProperty: 'name1',
            apiFormattedValue: 'test1'
          }),
          Em.Object.create({
            wasChanged: true,
            apiProperty: 'source.path1',
            apiFormattedValue: 'value1'
          }),
          Em.Object.create({
            wasChanged: true,
            apiProperty: 'source.path2.path3',
            apiFormattedValue: 'value2'
          })
        ],
        result: {
          'AlertDefinition/name1': 'test1',
          'AlertDefinition/source': {
            path1: 'value1',
            path2: {
              path3: 'value2'
            }
          }
        }
      },
      {
        m: 'should correctly multiple apiProperties',
        configs: [
          Em.Object.create({
            wasChanged: true,
            apiProperty: ['name1', 'name2'],
            apiFormattedValue: ['value1', 'value2']
          })
        ],
        result: {
          'AlertDefinition/name1': 'value1',
          'AlertDefinition/name2': 'value2'
        }
      }
    ];

    testCases.forEach(function (testCase) {

      it(testCase.m, function () {

        controller.set('configs', testCase.configs);
        var result = controller.getPropertiesToUpdate(true);

        expect(result).to.eql(testCase.result);
      });
    });

    describe('Some fields should be removed', function () {

      beforeEach(function () {
        controller.set('content', Em.Object.create({
          rawSourceData: {
            uri: {
              id: 123
            }
          }
        }));
        controller.set('configs', [
          Em.Object.create({
            apiProperty: 'source.uri.connection_timeout',
            apiFormattedValue: 123,
            wasChanged: true
          })
        ]);
        this.result = controller.getPropertiesToUpdate();
      });

      it('`AlertDefinition/source.uri.id`', function () {
        expect(this.result).to.not.have.deep.property('AlertDefinition/source.uri.id');
      });

    });

    describe('`source/parameters` for SCRIPT configs', function () {

      beforeEach(function () {
        controller.set('content', Em.Object.create({
          parameters: [
            Em.Object.create({name: 'p1', value: 'v1'}),
            Em.Object.create({name: 'p2', value: 'v2'}),
            Em.Object.create({name: 'p3', value: 'v3'}),
            Em.Object.create({name: 'p4', value: 'v4'})
          ],
          rawSourceData: {
            parameters: [
              {name: 'p1', value: 'v1'},
              {name: 'p2', value: 'v2'},
              {name: 'p3', value: 'v3'},
              {name: 'p4', value: 'v4'}
            ]
          }
        }));
        controller.set('configs', [
          Em.Object.create({apiProperty:'p1', apiFormattedValue: 'v11', wasChanged: true, name: 'parameter'}),
          Em.Object.create({apiProperty:'p2', apiFormattedValue: 'v21', wasChanged: true, name: 'parameter'}),
          Em.Object.create({apiProperty:'p3', apiFormattedValue: 'v31', wasChanged: true, name: 'parameter'}),
          Em.Object.create({apiProperty:'p4', apiFormattedValue: 'v41', wasChanged: true, name: 'parameter'})
        ]);
        this.result = controller.getPropertiesToUpdate();
      });

      it('should update parameters', function () {
        expect(this.result['AlertDefinition/source'].parameters).to.have.property('length').equal(4);
        expect(this.result['AlertDefinition/source'].parameters.mapProperty('value')).to.be.eql(['v11', 'v21', 'v31', 'v41']);
      });

    });

  });

  describe('#changeType()', function () {

    beforeEach(function () {
      controller.set('allServices', ['service1', 'service2']);
      controller.set('allScopes', ['scope1', 'scope2']);

      controller.set('configs', [
        Em.Object.create({name: 'service', isDisabled: false}),
        Em.Object.create({name: 'component', isDisabled: false}),
        Em.Object.create({name: 'scope', isDisabled: false})
      ]);
    });

    describe('Host Alert Definition', function () {

      beforeEach(function () {
        controller.changeType('Host Alert Definition');
      });

      it('all configs are disabled', function () {
        expect(controller.get('configs').everyProperty('isDisabled', true)).to.be.true;
      });
      it('service.options = ["Ambari"]', function () {
        expect(controller.get('configs').findProperty('name', 'service').get('options')).to.eql(['Ambari']);
      });
      it('service.value = "Ambari"', function () {
        expect(controller.get('configs').findProperty('name', 'service').get('value')).to.equal('Ambari');
      });
      it('component.value = "Ambari Agent"', function () {
        expect(controller.get('configs').findProperty('name', 'component').get('value')).to.equal('Ambari Agent');
      });
      it('scope.options = ["Host"]', function () {
        expect(controller.get('configs').findProperty('name', 'scope').get('options')).to.eql(['Host']);
      });
      it('isDisabled.value = "Host"', function () {
        expect(controller.get('configs').findProperty('name', 'scope').get('value')).to.equal('Host');
      });
    });

    describe('alert_type_service', function () {

      beforeEach(function () {
        controller.changeType('alert_type_service');
      });
      it('all configs are not disabled', function () {
        expect(controller.get('configs').everyProperty('isDisabled', false)).to.be.true;
      });
      it('service.options = ["service1", "service2"]', function () {
        expect(controller.get('configs').findProperty('name', 'service').get('options')).to.eql(['service1', 'service2']);
      });
      it('service.value = "service1"', function () {
        expect(controller.get('configs').findProperty('name', 'service').get('value')).to.equal('service1');
      });
      it('component.value = "No component"', function () {
        expect(controller.get('configs').findProperty('name', 'component').get('value')).to.equal('No component');
      });
      it('scope.options = ["scope1", "scope2"]', function () {
        expect(controller.get('configs').findProperty('name', 'scope').get('options')).to.eql(['scope1', 'scope2']);
      });
      it('scope.value = "scope1"', function () {
        expect(controller.get('configs').findProperty('name', 'scope').get('value')).to.equal('scope1');
      });
    });

  });

  describe('#renderCommonWizardConfigs()', function () {

    it('should return correct number of configs', function () {

      var result = controller.renderCommonWizardConfigs();

      expect(result.length).to.equal(6);

    });

  });

  describe('#getConfigsValues()', function () {

    it('should create key-value map from configs', function () {

      controller.set('configs', [
        Em.Object.create({name: 'name1', value: 'value1'}),
        Em.Object.create({name: 'name2', value: 'value2'}),
        Em.Object.create({name: 'name3', value: 'value3'})
      ]);

      var result = controller.getConfigsValues();

      expect(result).to.eql([
        {name: 'name1', value: 'value1'},
        {name: 'name2', value: 'value2'},
        {name: 'name3', value: 'value3'}
      ]);

    });

  });

});

});

require.register("test/controllers/main/alerts/definitions_details_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

var controller;

function getController() {
  return App.MainAlertDefinitionDetailsController.create({
    content: Em.Object.create({
      label: 'label'
    })
  });
}

describe('App.MainAlertDefinitionDetailsController', function () {

  beforeEach(function () {
    controller = getController();
  });

  App.TestAliases.testAsComputedMapBy(getController(), 'groupsList', 'content.groups', 'displayName');

  App.TestAliases.testAsComputedOr(getController(), 'isEditing', ['editing.label.isEditing', 'App.router.mainAlertDefinitionConfigsController.canEdit']);

  describe('#showSavePopup', function () {
    App.TestAliases.testAsComputedOr(getController().showSavePopup(), 'disablePrimary', ['App.router.mainAlertDefinitionDetailsController.editing.label.isError', 'App.router.mainAlertDefinitionConfigsController.hasErrors']);
  });

  describe('#labelValidation()', function () {

    it('should set editing.label.isError to true', function () {
      controller.set('editing.label.value', ' ');
      expect(controller.get('editing.label.isError')).to.be.true;
    });

  });

  describe('#edit()', function () {

    it('should change value of value, originalValue and isEditing properties', function () {
      controller.set('editing.label.value', 'test');
      controller.set('editing.label.originalValue', 'test');
      controller.set('editing.label.isEditing', false);

      controller.edit({context: controller.get('editing.label')});

      expect(controller.get('editing.label.value')).to.equal('label');
      expect(controller.get('editing.label.originalValue')).to.equal('label');
      expect(controller.get('editing.label.isEditing')).to.be.true;
    });

  });

  describe('#saveEdit()', function () {

    it('should change values of content.label and isEditing properties', function () {
      controller.set('editing.label.value', 'test');
      controller.set('editing.label.isEditing', true);

      controller.saveEdit({context: controller.get('editing.label')});

      expect(controller.get('content.label')).to.equal('test');
      expect(controller.get('editing.label.isEditing')).to.be.false;
    });

  });

  describe("#deleteAlertDefinition()", function () {
    beforeEach(function () {
      sinon.stub(App.get('router'), 'transitionTo', Em.K);
    });
    afterEach(function () {
      App.get('router').transitionTo.restore();
    });
    it("deleteAlertDefinitionSuccess", function () {
      controller.deleteAlertDefinitionSuccess();
      expect(App.get('router').transitionTo.calledWith('main.alerts.index')).to.be.true;
    });
  });

  describe("#loadAlertInstancesHistory()", function () {
    it("should set lastDayAlertsCount = null", function () {
      controller.set('lastDayAlertsCount', 'test');
      controller.loadAlertInstancesHistory();
      expect(controller.get('lastDayAlertsCount')).to.equal(null);
    });

  });

  describe("#loadAlertInstancesHistorySuccess()", function () {

    it("should calculate alerts count in different hosts", function () {

      controller.set('lastDayAlertsCount', null);

      controller.loadAlertInstancesHistorySuccess({
        items: [
          {
            AlertHistory: {
              host_name: 'host1'
            }
          },
          {
            AlertHistory: {
              host_name: 'host2'
            }
          },
          {
            AlertHistory: {
              host_name: 'host1'
            }
          },
          {
            AlertHistory: {
              host_name: 'host3'
            }
          }
        ]
      });

      expect(controller.get('lastDayAlertsCount')).to.eql({
        host1: 2,
        host2: 1,
        host3: 1
      });
    });
  });

});

});

require.register("test/controllers/main/alerts/manage_alert_groups_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

var manageAlertGroupsController;

function getController() {
  return App.ManageAlertGroupsController.create({});
}

describe('App.ManageAlertGroupsController', function () {

  beforeEach(function () {
    manageAlertGroupsController = getController();
  });

  App.TestAliases.testAsComputedFilterBy(getController(), 'alertGlobalNotifications', 'alertNotifications', 'global', true);

  describe('#duplicateAlertGroup', function () {
    beforeEach(function () {
      var group = Ember.Object.create({
        name: 'test'
      });

      manageAlertGroupsController.set('selectedAlertGroup', group);
      manageAlertGroupsController.duplicateAlertGroup();
    });

    describe("#validate", function () {
      it("should display no warning if user duplicate an existed group", function () {
        manageAlertGroupsController.addGroupPopup.set('alertGroupName', 'test Copy');

        expect(manageAlertGroupsController.addGroupPopup.warningMessage).to.be.empty;
      });
    });
  });

  describe('#deleteDefinitions', function () {
    var definitions = [
      Em.Object.create({
        name: 'def1',
        serviceName: 'HDFS',
        label: "Alert Definition 1",
        id: 1
      }),
      Em.Object.create({
        name: 'def2',
        serviceName: 'HDFS',
        label: "Alert Definition 2",
        id: 2
      }),
      Em.Object.create({
        name: 'def3',
        serviceName: 'HDFS',
        label: "Alert Definition 3",
        id: 3
      })
    ];

    beforeEach(function () {
      manageAlertGroupsController = App.ManageAlertGroupsController.create({});
    });

    var createAlertGroupMock = function (groupDefs) {
      return Em.Object.create({
        definitions: groupDefs,
        name: 'group'
      });
    };

    var tests = [
      {
        selectedDefinitions: definitions.slice(0, 1),
        selectedAlertGroup: createAlertGroupMock(definitions),
        e: definitions.slice(1)
      },
      {
        selectedDefinitions: definitions.slice(0, 2),
        selectedAlertGroup: createAlertGroupMock(definitions),
        e: definitions.slice(2)
      },
      {
        selectedDefinitions: definitions,
        selectedAlertGroup: createAlertGroupMock(definitions),
        e: []
      }
    ];

    tests.forEach(function (test) {
      it('delete definitions length {0} definitions'.format(test.selectedDefinitions.slice(0).length), function () {
        manageAlertGroupsController.reopen({
          selectedDefinitions: test.selectedDefinitions,
          selectedAlertGroup: test.selectedAlertGroup
        });
        manageAlertGroupsController.deleteDefinitions();
        expect(manageAlertGroupsController.get('selectedAlertGroup.definitions').toArray()).to.eql(test.e);
      });
    });

  });

  describe('#addDefinitionsCallback', function () {

    var definitions = [
      Em.Object.create({
        name: 'def1',
        serviceName: 'HDFS',
        label: "Alert Definition 1",
        id: 1
      }),
      Em.Object.create({
        name: 'def2',
        serviceName: 'HDFS',
        label: "Alert Definition 2",
        id: 2
      }),
      Em.Object.create({
        name: 'def3',
        serviceName: 'HDFS',
        label: "Alert Definition 3",
        id: 3
      })
    ];

    var definitionsToAdd = [
      Em.Object.create({
        name: 'def4',
        serviceName: 'HDFS',
        label: "Alert Definition 4",
        id: 4
      }),
      Em.Object.create({
        name: 'def5',
        serviceName: 'HDFS',
        label: "Alert Definition 5",
        id: 5
      }),
      Em.Object.create({
        name: 'def6',
        serviceName: 'HDFS',
        label: "Alert Definition 6",
        id: 6
      })
    ];

    beforeEach(function () {
      manageAlertGroupsController = App.ManageAlertGroupsController.create({});
    });

    var createAlertGroupMock = function (groupDefs) {
      return Em.Object.create({
        definitions: groupDefs,
        name: 'group'
      });
    };

    var result = function (originalDefs, addedDefs) {
      return originalDefs.concat(addedDefs);
    };

    var tests = [
      {
        selectedDefinitions: definitionsToAdd.slice(0, 1),
        selectedAlertGroup: createAlertGroupMock(definitions.slice(0, 1)),
        e: result(definitions.slice(0, 1), definitionsToAdd.slice(0, 1))
      },
      {
        selectedDefinitions: definitionsToAdd.slice(0, 2),
        selectedAlertGroup: createAlertGroupMock(definitions.slice(0, 2)),
        e: result(definitions.slice(0, 2), definitionsToAdd.slice(0, 2))
      },
      {
        selectedDefinitions: definitionsToAdd,
        selectedAlertGroup: createAlertGroupMock(definitions),
        e: result(definitions, definitionsToAdd)
      }
    ];

    tests.forEach(function (test) {
      it('add Definitions length {0} definitions'.format(test.selectedDefinitions.slice(0).length), function () {
        manageAlertGroupsController.set('selectedAlertGroup', test.selectedAlertGroup);
        manageAlertGroupsController.addDefinitionsCallback(test.selectedDefinitions);
        expect(manageAlertGroupsController.get('selectedAlertGroup.definitions').toArray()).to.eql(test.e);
      });
    });

  });

});


});

require.register("test/controllers/main/alerts/manage_alert_notifications_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var controller;
var helpers = require('test/helpers');
require('templates/main/alerts/alert_instance/status');


function getController() {
  return App.ManageAlertNotificationsController.create({});
}

function getInputFields() {
  return Em.Object.create({
    name: {
      value: ''
    },
    groups: {
      value: []
    },
    global: {
      value: false
    },
    allGroups: {
      value: false
    },
    method: {
      value: ''
    },
    email: {
      value: ''
    },
    severityFilter: {
      value: []
    },
    description: {
      value: ''
    },
    SMTPServer: {
      value: ''
    },
    SMTPPort: {
      value: ''
    },
    SMTPUseAuthentication: {
      value: ''
    },
    SMTPUsername: {
      value: ''
    },
    SMTPPassword: {
      value: ''
    },
    retypeSMTPPassword: {
      value: ''
    },
    SMTPSTARTTLS: {
      value: ''
    },
    emailFrom: {
      value: ''
    },
    version: {
      value: ''
    },
    OIDs: {
      value: ''
    },
    community: {
      value: ''
    },
    host: {
      value: ''
    },
    port: {
      value: ''
    }
  });
}

var createEditPopupView = getController().showCreateEditPopup();

describe('App.ManageAlertNotificationsController', function () {

  beforeEach(function () {
    controller = getController();
  });

  describe('#alertNotifications', function () {

    beforeEach(function () {
      sinon.stub(App.AlertNotification, 'find', function () {
        return [1, 2, 3];
      });
    });

    afterEach(function () {
      App.AlertNotification.find.restore();
    });

    it("should return all alert notifications if controller isLoaded", function () {

      controller.set('isLoaded', true);
      expect(controller.get('alertNotifications')).to.eql([1, 2, 3]);
    });

    it("should return [] if controller isLoaded=false", function () {

      controller.set('isLoaded', false);
      expect(controller.get('alertNotifications')).to.eql([]);
    });

  });

  describe('#loadAlertNotifications()', function () {

    it("should send ajax request and set isLoaded to false", function () {

      controller.set('isLoaded', true);
      controller.loadAlertNotifications();
      expect(controller.get('isLoaded')).to.be.false;
    });

  });

  describe('#getAlertNotificationsSuccessCallback()', function () {

    beforeEach(function () {
      sinon.spy(App.alertNotificationMapper, 'map');
    });

    afterEach(function () {
      App.alertNotificationMapper.map.restore();
    });

    it("should call mapper and set isLoaded to true", function () {

      controller.set('isLoaded', false);
      controller.getAlertNotificationsSuccessCallback('test');
      expect(controller.get('isLoaded')).to.be.true;
      expect(App.alertNotificationMapper.map.calledWith('test')).to.be.true;
    });

  });

  describe('#getAlertNotificationsErrorCallback()', function () {

    it("should set isLoaded to true", function () {

      controller.set('isLoaded', false);
      controller.getAlertNotificationsSuccessCallback('test');
      expect(controller.get('isLoaded')).to.be.true;
    });

  });

  describe('#addAlertNotification()', function () {

    var inputFields = Em.Object.create({
      a: {
        value: '',
        defaultValue: 'a'
      },
      b: {
        value: '',
        defaultValue: 'b'
      },
      c: {
        value: '',
        defaultValue: 'c'
      },
      severityFilter: {
        value: [],
        defaultValue: ['OK', 'WARNING', 'CRITICAL', 'UNKNOWN']
      },
      global: {
        value: false
      },
      allGroups: Em.Object.create({
        value: 'custom'
      })
    });

    beforeEach(function () {
      sinon.stub(controller, 'showCreateEditPopup');
      controller.set('inputFields', inputFields);
      controller.addAlertNotification();
    });

    afterEach(function () {
      controller.showCreateEditPopup.restore();
    });

    Object.keys(inputFields).forEach(function (key) {
      it(key, function () {
        expect(controller.get('inputFields.' + key + '.value')).to.be.eql(controller.get('inputFields.' + key + '.defaultValue'));
      });
    });

    it("should call showCreateEditPopup", function () {
      expect(controller.showCreateEditPopup.calledOnce).to.be.true;
    });

  });

  describe('#editAlertNotification()', function () {

    beforeEach(function () {
      sinon.stub(controller, 'showCreateEditPopup', Em.K);
      sinon.stub(controller, 'fillEditCreateInputs', Em.K);
    });

    afterEach(function () {
      controller.showCreateEditPopup.restore();
      controller.fillEditCreateInputs.restore();
    });

    it("should call fillEditCreateInputs and showCreateEditPopup", function () {

      controller.editAlertNotification();

      expect(controller.fillEditCreateInputs.calledOnce).to.be.true;
      expect(controller.showCreateEditPopup.calledWith(true)).to.be.true;
    });

  });

  describe('#fillEditCreateInputs()', function () {

    it("should map properties from selectedAlertNotification to inputFields (ambari.dispatch.recipients ignored) - EMAIL", function () {

      controller.set('selectedAlertNotification', Em.Object.create({
        name: 'test_name',
        global: true,
        description: 'test_description',
        groups: ['test1', 'test2'],
        type: 'EMAIL',
        alertStates: ['OK', 'UNKNOWN'],
        properties: {
          'ambari.dispatch.recipients': [
            'test1@test.test',
            'test2@test.test'
          ],
          'customName': 'customValue',
          "mail.smtp.from" : "from",
          "ambari.dispatch.credential.username" : "user",
          "mail.smtp.host" : "s1",
          "mail.smtp.port" : "25",
          "mail.smtp.auth" : "true",
          "ambari.dispatch.credential.password" : "pass",
          "mail.smtp.starttls.enable" : "true"
        }
      }));

      controller.set('inputFields', Em.Object.create({
        name: {
          value: ''
        },
        groups: {
          value: []
        },
        global: {
          value: false
        },
        allGroups: {
          value: false
        },
        method: {
          value: ''
        },
        email: {
          value: ''
        },
        severityFilter: {
          value: []
        },
        description: {
          value: ''
        },
        SMTPServer: {
          value: ''
        },
        SMTPPort: {
          value: ''
        },
        SMTPUseAuthentication: {
          value: ''
        },
        SMTPUsername: {
          value: ''
        },
        SMTPPassword: {
          value: ''
        },
        retypeSMTPPassword: {
          value: ''
        },
        SMTPSTARTTLS: {
          value: ''
        },
        emailFrom: {
          value: ''
        },
        version: {
          value: ''
        },
        OIDs: {
          value: ''
        },
        community: {
          value: ''
        },
        host: {
          value: ''
        },
        port: {
          value: ''
        },
        customProperties: [
          {name: 'customName', value: 'customValue1', defaultValue: 'customValue1'},
          {name: 'customName2', value: 'customValue1', defaultValue: 'customValue1'}
        ]
      }));

      controller.fillEditCreateInputs();

      expect(JSON.stringify(controller.get('inputFields'))).to.equal(JSON.stringify({
        name: {
          value: 'test_name'
        },
        groups: {
          value: ['test1', 'test2']
        },
        global: {
          value: true,
          disabled: true
        },
        allGroups: {
          value: 'all'
        },
        method: {
          value: 'EMAIL'
        },
        email: {
          value: 'test1@test.test, test2@test.test'
        },
        severityFilter: {
          value: ['OK', 'UNKNOWN']
        },
        description: {
          value: 'test_description'
        },
        SMTPServer: {
          value: 's1'
        },
        SMTPPort: {
          value: '25'
        },
        SMTPUseAuthentication: {
          value: true
        },
        SMTPUsername: {
          value: 'user'
        },
        SMTPPassword: {
          value: 'pass'
        },
        retypeSMTPPassword: {
          value: 'pass'
        },
        SMTPSTARTTLS: {
          value: true
        },
        emailFrom: {
          value: 'from'
        },
        version: {},
        OIDs: {},
        community: {},
        host: {
          value: 'test1@test.test, test2@test.test'
        },
        port: {},
        customProperties: [
          {name: 'customName', value: 'customValue', defaultValue: 'customValue'}
        ]
      }));

    });

    it("should map properties from selectedAlertNotification to inputFields (ambari.dispatch.recipients ignored) - SNMP", function () {

      controller.set('selectedAlertNotification', Em.Object.create({
        name: 'test_SNMP_name',
        global: true,
        description: 'test_description',
        groups: ['test1', 'test2'],
        type: 'SNMP',
        alertStates: ['OK', 'UNKNOWN'],
        properties: {
          'ambari.dispatch.recipients': [
            'c6401.ambari.apache.org',
            'c6402.ambari.apache.org'
          ],
          'customName': 'customValue',
          'ambari.dispatch.snmp.version': 'SNMPv1',
          'ambari.dispatch.snmp.oids.trap': '1',
          'ambari.dispatch.snmp.community': 'snmp',
          'ambari.dispatch.snmp.port': 161

        }
      }));

      controller.set('inputFields', Em.Object.create({
        name: {
          value: ''
        },
        groups: {
          value: []
        },
        global: {
          value: false
        },
        allGroups: {
          value: false
        },
        method: {
          value: ''
        },
        email: {
          value: ''
        },
        severityFilter: {
          value: []
        },
        description: {
          value: ''
        },
        SMTPServer: {
          value: ''
        },
        SMTPPort: {
          value: ''
        },
        SMTPUseAuthentication: {
          value: ''
        },
        SMTPUsername: {
          value: ''
        },
        SMTPPassword: {
          value: ''
        },
        retypeSMTPPassword: {
          value: ''
        },
        SMTPSTARTTLS: {
          value: ''
        },
        emailFrom: {
          value: ''
        },
        version: {
          value: ''
        },
        OIDs: {
          value: ''
        },
        community: {
          value: ''
        },
        host: {
          value: ''
        },
        port: {
          value: ''
        },
        customProperties: [
          {name: 'customName', value: 'customValue1', defaultValue: 'customValue1'},
          {name: 'customName2', value: 'customValue1', defaultValue: 'customValue1'}
        ]
      }));

      controller.fillEditCreateInputs();

      expect(JSON.stringify(controller.get('inputFields'))).to.equal(JSON.stringify({
        name: {
          value: 'test_SNMP_name'
        },
        groups: {
          value: ['test1', 'test2']
        },
        global: {
          value: true,
          disabled: true
        },
        allGroups: {
          value: 'all'
        },
        method: {
          value: 'Custom SNMP'
        },
        email: {
          value: 'c6401.ambari.apache.org, c6402.ambari.apache.org'
        },
        severityFilter: {
          value: ['OK', 'UNKNOWN']
        },
        description: {
          value: 'test_description'
        },
        SMTPServer: {},
        SMTPPort: {},
        SMTPUseAuthentication: {
          value: true
        },
        SMTPUsername: {},
        SMTPPassword: {},
        retypeSMTPPassword: {},
        SMTPSTARTTLS: {
          value: true
        },
        emailFrom: {},
        version: {
          value:'SNMPv1'
        },
        OIDs: {
          value: '1'
        },
        community: {
          value: 'snmp'
        },
        host: {
          value: 'c6401.ambari.apache.org, c6402.ambari.apache.org'
        },
        port: {
          value: 161
        },
        customProperties: [
          {name: 'customName', value: 'customValue', defaultValue: 'customValue'}
        ]
      }));

    });

    it("should map properties from selectedAlertNotification to inputFields (ambari.dispatch.recipients ignored) - AMBARI_SNMP", function () {

      controller.set('selectedAlertNotification', Em.Object.create({
        name: 'AMBARI_SNMP_name',
        global: true,
        description: 'test_description',
        groups: ['test1', 'test2'],
        type: 'AMBARI_SNMP',
        alertStates: ['OK', 'UNKNOWN'],
        properties: {
          'ambari.dispatch.recipients': [
            'c6401.ambari.apache.org',
            'c6402.ambari.apache.org'
          ],
          'customName': 'customValue',
          'ambari.dispatch.snmp.version': 'SNMPv1',
          'ambari.dispatch.snmp.community': 'public',
          'ambari.dispatch.snmp.port': 161

        }
      }));

      controller.set('inputFields', Em.Object.create({
        name: {
          value: ''
        },
        groups: {
          value: []
        },
        global: {
          value: false
        },
        allGroups: {
          value: false
        },
        method: {
          value: ''
        },
        email: {
          value: ''
        },
        severityFilter: {
          value: []
        },
        description: {
          value: ''
        },
        SMTPServer: {
          value: ''
        },
        SMTPPort: {
          value: ''
        },
        SMTPUseAuthentication: {
          value: ''
        },
        SMTPUsername: {
          value: ''
        },
        SMTPPassword: {
          value: ''
        },
        retypeSMTPPassword: {
          value: ''
        },
        SMTPSTARTTLS: {
          value: ''
        },
        emailFrom: {
          value: ''
        },
        version: {
          value: ''
        },
        OIDs: {
          value: ''
        },
        community: {
          value: ''
        },
        host: {
          value: ''
        },
        port: {
          value: ''
        },
        customProperties: [
          {name: 'customName', value: 'customValue1', defaultValue: 'customValue1'},
          {name: 'customName2', value: 'customValue1', defaultValue: 'customValue1'}
        ]
      }));

      controller.fillEditCreateInputs();

      expect(JSON.stringify(controller.get('inputFields'))).to.equal(JSON.stringify({
        name: {
          value: 'AMBARI_SNMP_name'
        },
        groups: {
          value: ['test1', 'test2']
        },
        global: {
          value: true,
          disabled: true
        },
        allGroups: {
          value: 'all'
        },
        method: {
          value: 'SNMP'
        },
        email: {
          value: 'c6401.ambari.apache.org, c6402.ambari.apache.org'
        },
        severityFilter: {
          value: ['OK', 'UNKNOWN']
        },
        description: {
          value: 'test_description'
        },
        SMTPServer: {},
        SMTPPort: {},
        SMTPUseAuthentication: {
          value: true
        },
        SMTPUsername: {},
        SMTPPassword: {},
        retypeSMTPPassword: {},
        SMTPSTARTTLS: {
          value: true
        },
        emailFrom: {},
        version: {
          value:'SNMPv1'
        },
        OIDs: {},
        community: {
          value: 'public'
        },
        host: {
          value: 'c6401.ambari.apache.org, c6402.ambari.apache.org'
        },
        port: {
          value: 161
        },
        customProperties: [
          {name: 'customName', value: 'customValue', defaultValue: 'customValue'}
        ]
      }));
    })
  });

  describe("#showCreateEditPopup()", function () {

    beforeEach(function () {
      sinon.spy(App.ModalPopup, 'show');
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it("should open popup and set popup object to createEditPopup", function () {

      controller.showCreateEditPopup();
      expect(App.ModalPopup.show.calledOnce).to.be.true;

    });

    App.TestAliases.testAsComputedOr(getController().showCreateEditPopup(), 'disablePrimary', ['isSaving', 'hasErrors']);

    describe('#bodyClass', function () {
      function getBodyClass() {
        return createEditPopupView.get('bodyClass').create({
          controller: Em.Object.create({
            inputFields: {
              name: {},
              global: {},
              allGroups: {},
              SMTPUseAuthentication: {},
              SMTPUsername: {},
              SMTPPassword: {},
              retypeSMTPPassword: {},
              method: {}
            }
          }),
          groupSelect: Em.Object.create({
            selection: [],
            content: [{}, {}]
          }),
          parentView: Em.Object.create({
            hasErrors: false
          })
        });
      }

      var view;

      beforeEach(function () {
        view = getBodyClass();
      });

      App.TestAliases.testAsComputedOr(getBodyClass(), 'someErrorExists', ['nameError', 'emailToError', 'emailFromError', 'smtpPortError', 'hostError', 'portError', 'smtpUsernameError', 'smtpPasswordError', 'passwordError']);

      describe('#selectAllGroups', function () {

        it('should check inputFields.allGroups.value', function () {

          view.set('controller.inputFields.allGroups.value', 'all');
          view.selectAllGroups();
          expect(view.get('groupSelect.selection')).to.eql([]);

          view.set('controller.inputFields.allGroups.value', 'custom');
          view.selectAllGroups();
          expect(view.get('groupSelect.selection')).to.eql([{}, {}]);

        });

      });

      describe('#clearAllGroups', function () {

        it('should check inputFields.allGroups.value', function () {

          view.set('controller.inputFields.allGroups.value', 'custom');
          view.selectAllGroups();

          view.set('controller.inputFields.allGroups.value', 'all');
          view.clearAllGroups();
          expect(view.get('groupSelect.selection')).to.eql([{}, {}]);

          view.set('controller.inputFields.allGroups.value', 'custom');
          view.clearAllGroups();
          expect(view.get('groupSelect.selection')).to.eql([]);

        });

      });

      describe('#nameValidation', function () {

        it('should check inputFields.name.value', function () {
          view.set('controller.inputFields.name.value', '');
          expect(view.get('controller.inputFields.name.errorMsg')).to.equal(Em.I18n.t('alerts.actions.manage_alert_notifications_popup.error.name.empty'));
          expect(view.get('parentView.hasErrors')).to.be.true;
        });

        it('should check inputFields.name.value (2)', function () {
          view.set('controller.inputFields.name.errorMsg', 'error');
          view.set('controller.inputFields.name.value', 'test');
          expect(view.get('controller.inputFields.name.errorMsg')).to.equal('');
        });

        it('should check inputFields.name.value (3)', function () {
          view.set('isEdit', true);
          view.set('controller.inputFields.name.value', '');
          expect(view.get('controller.inputFields.name.errorMsg')).to.equal(Em.I18n.t('alerts.actions.manage_alert_notifications_popup.error.name.empty'));
          expect(view.get('parentView.hasErrors')).to.be.true;
        });

        it('should check inputFields.name.value (4)', function () {
          view.set('isEdit', true);
          view.set('controller.inputFields.name.errorMsg', 'error');
          view.set('controller.inputFields.name.value', 'test');
          expect(view.get('controller.inputFields.name.errorMsg')).to.equal('');
        });
        
        it('should check inputFields.name.value (5)', function () {
         view.set('isEdit', true);
         view.set('controller.inputFields.name.errorMsg', 'error');
         view.set('controller.inputFields.name.value', 'test%');
         expect(view.get('controller.inputFields.name.errorMsg')).to.equal(Em.I18n.t('form.validator.alertNotificationName'));
       });

      });

      describe('#smtpUsernameValidation', function () {

        beforeEach(function () {
          view.set('controller.inputFields', getInputFields());
          view.set('controller.inputFields.emailFrom.value', '1@2.com');
          view.set('controller.inputFields.method.value', 'EMAIL');
        });

        it('should check inputFields.SMTPUsername.value', function () {

          view.set('parentView.hasErrors', false);
          view.set('controller.inputFields.SMTPUsername.errorMsg', null);
          view.set('controller.inputFields.SMTPUseAuthentication.value', true);
          view.set('controller.inputFields.SMTPUsername.value', '');
          view.set('controller.inputFields.SMTPPassword.value', 'pass');
          view.set('controller.inputFields.retypeSMTPPassword.value', 'pass');
          expect(view.get('controller.inputFields.SMTPUsername.errorMsg')).to.equal(Em.I18n.t('alerts.notifications.error.SMTPUsername'));
          expect(view.get('smtpUsernameError')).to.be.true;

        });

        it('should check inputFields.SMTPUsername.value (2)', function () {

          view.set('parentView.hasErrors', true);
          view.set('controller.inputFields.SMTPUsername.errorMsg', 'error');
          view.set('controller.inputFields.SMTPUseAuthentication.value', true);
          view.set('controller.inputFields.SMTPUsername.value', 'test');
          view.set('controller.inputFields.SMTPPassword.value', 'pass');
          view.set('controller.inputFields.retypeSMTPPassword.value', 'pass');
          expect(view.get('controller.inputFields.SMTPUsername.errorMsg')).to.equal(null);
          expect(view.get('smtpUsernameError')).to.be.false;

        });

        it('should check inputFields.SMTPUsername.value (3)', function () {

          view.set('parentView.hasErrors', true);
          view.set('controller.inputFields.SMTPUsername.errorMsg', 'error');
          view.set('controller.inputFields.SMTPUseAuthentication.value', false);
          view.set('controller.inputFields.SMTPUsername.value', '');
          view.set('controller.inputFields.SMTPPassword.value', '');
          view.set('controller.inputFields.retypeSMTPPassword.value', '');
          expect(view.get('controller.inputFields.SMTPUsername.errorMsg')).to.equal(null);
          expect(view.get('smtpUsernameError')).to.be.false;

        });

      });

      describe('#smtpPasswordValidation', function () {

        beforeEach(function () {
          view.set('controller.inputFields', getInputFields());
          view.set('controller.inputFields.emailFrom.value', '1@2.com');
          view.set('controller.inputFields.method.value', 'EMAIL');
        });

        it('should check inputFields.SMTPPassword.value', function () {

          view.set('parentView.hasErrors', false);
          view.set('controller.inputFields.SMTPPassword.errorMsg', null);
          view.set('controller.inputFields.SMTPUseAuthentication.value', true);
          view.set('controller.inputFields.SMTPUsername.value', 'user');
          view.set('controller.inputFields.SMTPPassword.value', '');
          view.set('controller.inputFields.retypeSMTPPassword.value', '');
          expect(view.get('controller.inputFields.SMTPPassword.errorMsg')).to.equal(Em.I18n.t('alerts.notifications.error.SMTPPassword'));
          expect(view.get('smtpPasswordError')).to.be.true;

        });

        it('should check inputFields.SMTPPassword.value (2)', function () {

          view.set('parentView.hasErrors', true);
          view.set('controller.inputFields.SMTPPassword.errorMsg', 'error');
          view.set('controller.inputFields.SMTPUseAuthentication.value', true);
          view.set('controller.inputFields.SMTPUsername.value', 'user');
          view.set('controller.inputFields.SMTPPassword.value', 'test');
          view.set('controller.inputFields.retypeSMTPPassword.value', 'test');
          expect(view.get('controller.inputFields.SMTPPassword.errorMsg')).to.equal(null);
          expect(view.get('smtpPasswordError')).to.be.false;

        });

        it('should check inputFields.SMTPPassword.value (3)', function () {

          view.set('parentView.hasErrors', true);
          view.set('controller.inputFields.SMTPPassword.errorMsg', 'error');
          view.set('controller.inputFields.SMTPUseAuthentication.value', false);
          view.set('controller.inputFields.SMTPUsername.value', '');
          view.set('controller.inputFields.SMTPPassword.value', '');
          view.set('controller.inputFields.retypeSMTPPassword.value', '');
          expect(view.get('controller.inputFields.SMTPPassword.errorMsg')).to.equal(null);
          expect(view.get('smtpPasswordError')).to.be.false;

        });

      });

      describe('#retypePasswordValidation', function () {

        it('should check inputFields.retypeSMTPPassword.value', function () {

          view.set('controller.inputFields.retypeSMTPPassword.errorMsg', null);
          view.set('controller.inputFields.SMTPPassword.value', 'pass');
          view.set('controller.inputFields.retypeSMTPPassword.value', 'pas');

          expect(view.get('controller.inputFields.retypeSMTPPassword.errorMsg')).to.equal(Em.I18n.t('alerts.notifications.error.retypePassword'));
          expect(view.get('parentView.hasErrors')).to.be.true;

        });

        it('should check inputFields.retypeSMTPPassword.value (2)', function () {

          view.set('parentView.hasErrors', true);
          view.set('controller.inputFields.retypeSMTPPassword.errorMsg', 'error');
          view.set('controller.inputFields.SMTPPassword.value', 'pass');
          view.set('controller.inputFields.retypeSMTPPassword.value', 'pass');

          expect(view.get('controller.inputFields.retypeSMTPPassword.errorMsg')).to.equal(null);
          expect(view.get('parentView.hasErrors')).to.be.false;

        });

      });

      describe('#methodObserver', function () {

        var cases = [
            {
              method: 'EMAIL',
              errors: ['portError', 'hostError'],
              validators: ['emailToValidation', 'emailFromValidation', 'smtpPortValidation', 'smtpUsernameValidation', 'smtpPasswordValidation', 'retypePasswordValidation']
            },
            {
              method: 'SNMP',
              errors: ['emailToError', 'emailFromError', 'smtpPortError', 'smtpUsernameError', 'smtpPasswordError', 'passwordError'],
              validators: ['portValidation', 'hostsValidation']
            }
          ],
          validators = [];

        before(function () {
          cases.forEach(function (item) {
            validators.pushObjects(item.validators);
          });
        });

        beforeEach(function () {
          validators.forEach(function (item) {
            sinon.stub(view, item, Em.K);
          });
        });

        afterEach(function () {
          validators.forEach(function (item) {
            view.get(item).restore();
          });
        });

        cases.forEach(function (item) {
          describe(item.method, function () {

            beforeEach(function () {
              item.errors.forEach(function (errorName) {
                view.set(errorName, true);
              });
              view.set('controller.inputFields.method.value', item.method);
            });

            item.errors.forEach(function (errorName) {
              it(errorName + ' is false', function () {
                expect(view.get(errorName)).to.be.false;
              });

            });
            validators.forEach(function (validatorName) {
              var called = item.validators.contains(validatorName);
              it(validatorName + ' ' + (called ? '' : 'not') + ' called', function () {
                expect(view.get(validatorName).calledOnce).to.equal(called);
              });
            });
          });
        });

      });

    });

  });

  describe("#formatNotificationAPIObject()", function () {

    var inputFields = Em.Object.create({
      name: {
        value: 'test_name'
      },
      groups: {
        value: [{id: 1}, {id: 2}, {id: 3}]
      },
      allGroups: {
        value: 'custom'
      },
      global: {
        value: false
      },
      method: {
        value: 'EMAIL'
      },
      email: {
        value: 'test1@test.test, test2@test.test,test3@test.test , test4@test.test'
      },
      severityFilter: {
        value: ['OK', 'CRITICAL']
      },
      SMTPServer: {
        value: 's1'
      },
      SMTPPort: {
        value: '25'
      },
      SMTPUseAuthentication: {
        value: "true"
      },
      SMTPUsername: {
        value: 'user'
      },
      SMTPPassword: {
        value: 'pass'
      },
      SMTPSTARTTLS: {
        value: "true"
      },
      emailFrom: {
        value: 'from'
      },
      description: {
        value: 'test_description'
      },
      customProperties: [
        {name: 'n1', value: 'v1'},
        {name: 'n2', value: 'v2'}
      ]
    });

    it("should create object with properties from inputFields values", function () {

      controller.set('inputFields', inputFields);

      var result = controller.formatNotificationAPIObject();

      expect(JSON.stringify(result)).to.eql(JSON.stringify({
        AlertTarget: {
          name: 'test_name',
          description: 'test_description',
          global: false,
          notification_type: 'EMAIL',
          alert_states: ['OK', 'CRITICAL'],
          properties: {
            'ambari.dispatch.recipients': [
              'test1@test.test',
              'test2@test.test',
              'test3@test.test',
              'test4@test.test'
            ],
            "mail.smtp.host" : "s1",
            "mail.smtp.port" : "25",
            "mail.smtp.from" : "from",
            "mail.smtp.auth" : "true",
            "ambari.dispatch.credential.username" : "user",
            "ambari.dispatch.credential.password" : "pass",
            "mail.smtp.starttls.enable" : "true",
            'n1': 'v1',
            'n2': 'v2'
          },
          groups: [1,2,3]
        }
      }));
    });

    it('should ignore groups if global is true', function () {

      controller.set('inputFields', inputFields);
      controller.set('inputFields.allGroups.value', 'all');

      var result = controller.formatNotificationAPIObject();
      expect(Em.keys(result.AlertTarget)).to.not.contain('groups');

    });

  });

  describe('#createAlertNotification()', function () {

    it("should send ajax request", function () {

      controller.createAlertNotification();
      var args = helpers.findAjaxRequest('name', 'alerts.create_alert_notification');
      expect(args[0]).to.exists;
    });

  });

  describe('#createAlertNotificationSuccessCallback()', function () {

    beforeEach(function () {
      controller.set('createEditPopup', {
        hide: Em.K
      });
      sinon.stub(controller, 'loadAlertNotifications', Em.K);
      sinon.spy(controller.createEditPopup, 'hide');
    });

    afterEach(function () {
      controller.loadAlertNotifications.restore();
      controller.createEditPopup.hide.restore();
    });

    it("should call loadAlertNotifications and createEditPopup.hide", function () {

      controller.createAlertNotificationSuccessCallback();

      expect(controller.loadAlertNotifications.calledOnce).to.be.true;
      expect(controller.createEditPopup.hide.calledOnce).to.be.true;
    });

  });

  describe('#updateAlertNotification()', function () {

    it("should send ajax request", function () {

      controller.updateAlertNotification();
      var args = helpers.findAjaxRequest('name', 'alerts.update_alert_notification');
      expect(args[0]).to.exists;
    });

  });

  describe('#updateAlertNotificationSuccessCallback()', function () {

    beforeEach(function () {
      controller.set('createEditPopup', {
        hide: Em.K
      });
      sinon.stub(controller, 'loadAlertNotifications', Em.K);
      sinon.spy(controller.createEditPopup, 'hide');
    });

    afterEach(function () {
      controller.loadAlertNotifications.restore();
      controller.createEditPopup.hide.restore();
    });

    it("should call loadAlertNotifications and createEditPopup.hide", function () {

      controller.updateAlertNotificationSuccessCallback();

      expect(controller.loadAlertNotifications.calledOnce).to.be.true;
      expect(controller.createEditPopup.hide.calledOnce).to.be.true;
    });

  });

  describe('#deleteAlertNotification()', function () {

    beforeEach(function () {
      sinon.spy(App, 'showConfirmationPopup');
    });

    afterEach(function () {
      App.showConfirmationPopup.restore();
    });

    it("should show popup and send request on confirmation", function () {

      var popup = controller.deleteAlertNotification();

      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      var args = helpers.findAjaxRequest('name', 'alerts.delete_alert_notification');
      expect(args[0]).to.exists;
    });

  });

  describe('#deleteAlertNotificationSuccessCallback()', function () {
    var mockSelectedAlertNotification;

    beforeEach(function () {
      mockSelectedAlertNotification = {
        deleteRecord: Em.K
      };
      controller.set('selectedAlertNotification', mockSelectedAlertNotification);
      sinon.stub(controller, 'loadAlertNotifications', Em.K);
      sinon.spy(mockSelectedAlertNotification, 'deleteRecord');
      controller.deleteAlertNotificationSuccessCallback();
    });

    afterEach(function () {
      controller.loadAlertNotifications.restore();
      mockSelectedAlertNotification.deleteRecord.restore();
    });

    it("should call loadAlertNotifications", function () {
      expect(controller.loadAlertNotifications.calledOnce).to.be.true;
    });

    it("should call selectedAlertNotification.deleteRecord", function () {
      expect(mockSelectedAlertNotification.deleteRecord.calledOnce).to.be.true;
    });

    it("should set null to selectedAlertNotification", function () {
      expect(controller.get('selectedAlertNotification')).to.equal(null);
    });

  });

  describe('#duplicateAlertNotification()', function () {

    beforeEach(function () {
      sinon.stub(controller, 'fillEditCreateInputs', Em.K);
      sinon.stub(controller, 'showCreateEditPopup', Em.K);
    });

    afterEach(function () {
      controller.fillEditCreateInputs.restore();
      controller.showCreateEditPopup.restore();
    });

    it("should call fillEditCreateInputs and showCreateEditPopup", function () {

      controller.duplicateAlertNotification();

      expect(controller.fillEditCreateInputs.calledWith(true)).to.be.true;
      expect(controller.showCreateEditPopup.calledOnce).to.be.true;
    });

  });

  describe('#addCustomProperty', function () {

    beforeEach(function () {
      controller.set('inputFields.customProperties', []);
    });

    /*eslint-disable mocha-cleanup/asserts-limit */
    it('should add custom Property to customProperties', function () {
      controller.set('newCustomProperty', {name: 'n1', value: 'v1'});
      controller.addCustomProperty();
      helpers.nestedExpect([{name: 'n1', value: 'v1', defaultValue: 'v1'}], controller.get('inputFields.customProperties'));
    });
    /*eslint-enable mocha-cleanup/asserts-limit */

  });

  describe('#removeCustomPropertyHandler', function () {

    var c = {name: 'n2', value: 'v2', defaultValue: 'v2'};

    beforeEach(function () {
      controller.set('inputFields.customProperties', [
        {name: 'n1', value: 'v1', defaultValue: 'v1'},
        c,
        {name: 'n3', value: 'v3', defaultValue: 'v3'}
      ]);
    });

    /*eslint-disable mocha-cleanup/asserts-limit */
    it('should remove selected custom property', function () {
      controller.removeCustomPropertyHandler({context: c});
      helpers.nestedExpect(
        [
          {name: 'n1', value: 'v1', defaultValue: 'v1'},
          {name: 'n3', value: 'v3', defaultValue: 'v3'}
        ],
        controller.get('inputFields.customProperties')
      );
    });
    /*eslint-enable mocha-cleanup/asserts-limit */

  });

  describe('#addCustomPropertyHandler', function () {

    it('should clean up newCustomProperty on primary click', function () {

      controller.set('newCustomProperty', {name: 'n1', value: 'v1'});
      controller.addCustomPropertyHandler().onPrimary();
      expect(controller.get('newCustomProperty')).to.eql({name: '', value: ''});

    });

  });

});

});

require.register("test/controllers/main/charts/heatmap_metrics/heatmap_metric_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with this
 * work for additional information regarding copyright ownership. The ASF
 * licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

var App = require('app');
require('controllers/main/charts/heatmap_metrics/heatmap_metric');
var date = require('utils/date/date');

describe('MainChartHeatmapMetric', function () {
  var mainChartHeatmapMetric = App.MainChartHeatmapMetric.create({});

  beforeEach(function () {
    mainChartHeatmapMetric = App.MainChartHeatmapMetric.create({});
  });

  describe('#formatLegendNumber', function () {
    var tests = [
      {m:'undefined to undefined',i:undefined,e:undefined},
      {m:'0 to 0',i:0,e:0},
      {m:'1 to 1',i:1,e:1},
      {m:'1.23 to 1.2',i:1.23,e:1.2}
    ];
    tests.forEach(function(test) {
      it(test.m + ' ', function () {
        expect(mainChartHeatmapMetric.formatLegendNumber(test.i)).to.equal(test.e);
      });
    });
    it('NaN to NaN', function () {
      expect(isNaN(mainChartHeatmapMetric.formatLegendNumber(NaN))).to.equal(true);
    });
  });


  describe('#slotDefinitions', function () {
    beforeEach(function () {
      sinon.stub(mainChartHeatmapMetric, 'generateSlot', Em.K);
      mainChartHeatmapMetric.set('maximumValue', 100);
      mainChartHeatmapMetric.set('minimumValue', 0);
    });
    afterEach(function () {
      mainChartHeatmapMetric.generateSlot.restore();
    });

    describe('one slot', function () {

      beforeEach(function () {
        mainChartHeatmapMetric.set('numberOfSlots', 1);
        mainChartHeatmapMetric.propertyDidChange('slotDefinitions');
        this.slotDefinitions = mainChartHeatmapMetric.get('slotDefinitions');
      });

      it('3 slotDefinitions', function () {
        expect(this.slotDefinitions.length).to.equal(3);
      });
      it('generateSlot is called 1 time', function () {
        expect(mainChartHeatmapMetric.generateSlot.callCount).to.be.equal(1);
      });
      it('generateSlot is called with correct arguments', function () {
        expect(mainChartHeatmapMetric.generateSlot.getCall(0).args).to.eql([0, 100, '', {r: 0, g: 204, b: 0}]);
      });

    });

    describe('two slots', function () {

      beforeEach(function () {
        mainChartHeatmapMetric.set('numberOfSlots', 2);
        mainChartHeatmapMetric.propertyDidChange('slotDefinitions');
        this.slotDefinitions = mainChartHeatmapMetric.get('slotDefinitions');
      });

      it('4 slotDefinitions', function () {
        expect(this.slotDefinitions.length).to.equal(4);
      });
      it('generateSlot is called 2 times', function () {
        expect(mainChartHeatmapMetric.generateSlot.callCount).to.be.equal(2);
      });
      it('generateSlot 1st call has valid arguments', function () {
        expect(mainChartHeatmapMetric.generateSlot.getCall(0).args).to.eql([0, 50, '', {r: 0, g: 204, b: 0}]);
      });
      it('generateSlot 2nd call has valid arguments', function () {
        expect(mainChartHeatmapMetric.generateSlot.getCall(1).args).to.eql([50, 100, '', {r: 159, g: 238, b: 0}]);
      });

    });
  });

  describe('#generateSlot()', function () {

    beforeEach(function () {
      sinon.stub(mainChartHeatmapMetric, 'formatLegendNumber').returns('val');
      sinon.stub(date, 'timingFormat').returns('time');
    });

    afterEach(function () {
      mainChartHeatmapMetric.formatLegendNumber.restore();
      date.timingFormat.restore();
    });

    describe('label suffix is empty', function () {

      beforeEach(function () {
        this.result = mainChartHeatmapMetric.generateSlot(0, 1, '', {r: 0, g: 0, b: 0});
      });

      it('generateSlot result is valid', function () {
        expect(this.result).to.eql(Em.Object.create({
          "from": "val",
          "to": "val",
          "label": "val - val",
          "cssStyle": "background-color:rgb(0,0,0)"
        }));
      });

      it('formatLegendNumber 1st call with valid arguments', function () {
        expect(mainChartHeatmapMetric.formatLegendNumber.getCall(0).args).to.eql([0]);
      });

      it('formatLegendNumber 2nd call with valid arguments', function () {
        expect(mainChartHeatmapMetric.formatLegendNumber.getCall(1).args).to.eql([1]);
      });
    });

    describe('label suffix is "ms"', function () {

      beforeEach(function () {
        this.result = mainChartHeatmapMetric.generateSlot(0, 1, 'ms', {r: 0, g: 0, b: 0});
      });

      it('generateSlot result is valid', function () {
        expect(this.result).to.eql(Em.Object.create({
          "from": "val",
          "to": "val",
          "label": "time - time",
          "cssStyle": "background-color:rgb(0,0,0)"
        }));
      });
      it('formatLegendNumber 1st call with valid arguments', function () {
        expect(mainChartHeatmapMetric.formatLegendNumber.getCall(0).args).to.eql([0]);
      });
      it('formatLegendNumber 2nd call with valid arguments', function () {
        expect(mainChartHeatmapMetric.formatLegendNumber.getCall(1).args).to.eql([1]);
      });
      it('timingFormat 1st call with valid arguments', function () {
        expect(date.timingFormat.getCall(0).args).to.eql(['val', 'zeroValid']);
      });
      it('timingFormat 2nd call with valid arguments', function () {
        expect(date.timingFormat.getCall(1).args).to.eql(['val', 'zeroValid']);
      });

    });

  });

  describe('#getHatchStyle()', function () {
    var testCases = [
      {
        title: 'unknown browser',
        data: {},
        result: 'background-color:rgb(135, 206, 250)'
      },
      {
        title: 'webkit browser',
        data: {
          webkit: true
        },
        result: 'background-image:-webkit-repeating-linear-gradient(-45deg, #FF1E10, #FF1E10 3px, #ff6c00 3px, #ff6c00 6px)'
      },
      {
        title: 'mozilla browser',
        data: {
          mozilla: true
        },
        result: 'background-image:repeating-linear-gradient(-45deg, #FF1E10, #FF1E10 3px, #ff6c00 3px, #ff6c00 6px)'
      },
      {
        title: 'IE version 9',
        data: {
          msie: true,
          version: '9.0'
        },
        result: 'background-color:rgb(135, 206, 250)'
      },
      {
        title: 'IE version 10',
        data: {
          msie: true,
          version: '10.0'
        },
        result: 'background-image:repeating-linear-gradient(-45deg, #FF1E10, #FF1E10 3px, #ff6c00 3px, #ff6c00 6px)'
      }
    ];

    testCases.forEach(function(test){
      it(test.title, function () {
        jQuery.browser = test.data;
        expect(mainChartHeatmapMetric.getHatchStyle()).to.equal(test.result);
      });
    });
  });

  describe('#hostToSlotMap', function () {

    beforeEach(function () {
      this.stub = sinon.stub(mainChartHeatmapMetric, 'calculateSlot');
    });

    afterEach(function () {
      this.stub.restore();
    });

    it('hostToValueMap is null', function () {
      mainChartHeatmapMetric.set('hostToValueMap', null);
      mainChartHeatmapMetric.set('hostNames', []);
      mainChartHeatmapMetric.propertyDidChange('hostToSlotMap');
      expect(mainChartHeatmapMetric.get('hostToSlotMap')).to.be.empty;
    });
    it('hostNames is null', function () {
      mainChartHeatmapMetric.set('hostToValueMap', {});
      mainChartHeatmapMetric.set('hostNames', null);
      mainChartHeatmapMetric.propertyDidChange('hostToSlotMap');
      expect(mainChartHeatmapMetric.get('hostToSlotMap')).to.be.empty;
    });
    it('slot greater than -1', function () {
      mainChartHeatmapMetric.set('hostToValueMap', {});
      mainChartHeatmapMetric.set('hostNames', ['host1']);
      this.stub.returns(0);
      mainChartHeatmapMetric.propertyDidChange('hostToSlotMap');
      expect(mainChartHeatmapMetric.get('hostToSlotMap')).to.eql({'host1': 0});
      expect(mainChartHeatmapMetric.calculateSlot.calledWith({}, 'host1')).to.be.true;
    });
    it('slot equal to -1', function () {
      mainChartHeatmapMetric.set('hostToValueMap', {});
      mainChartHeatmapMetric.set('hostNames', ['host1']);
      this.stub.returns('-1');
      mainChartHeatmapMetric.propertyDidChange('hostToSlotMap');
      expect(mainChartHeatmapMetric.get('hostToSlotMap')).to.be.empty;
      expect(mainChartHeatmapMetric.calculateSlot.calledWith({}, 'host1')).to.be.true;
    });
  });

  describe('#calculateSlot()', function () {
    var testCases = [
      {
        title: 'hostToValueMap is empty',
        data: {
          hostToValueMap: {},
          hostName: 'host1',
          slotDefinitions: []
        },
        result: -1
      },
      {
        title: 'host value is NaN',
        data: {
          hostToValueMap: {'host1': NaN},
          hostName: 'host1',
          slotDefinitions: []
        },
        result: -2
      },
      {
        title: 'host value correct but slotDefinitions does not contain host value',
        data: {
          hostToValueMap: {'host1': 1},
          hostName: 'host1',
          slotDefinitions: [{}, {}]
        },
        result: -1
      },
      {
        title: 'host value -1',
        data: {
          hostToValueMap: {'host1': -1},
          hostName: 'host1',
          slotDefinitions: [
            {
              from: 0,
              to: 10
            },
            {},
            {}
          ]
        },
        result: 0
      },
      {
        title: 'host value 11',
        data: {
          hostToValueMap: {'host1': 11},
          hostName: 'host1',
          slotDefinitions: [
            {
              from: 0,
              to: 10
            },
            {},
            {}
          ]
        },
        result: 0
      },
      {
        title: 'host value 5',
        data: {
          hostToValueMap: {'host1': 5},
          hostName: 'host1',
          slotDefinitions: [
            {},
            {
              from: 0,
              to: 10
            },
            {},
            {}
          ]
        },
        result: 1
      }
    ];

    testCases.forEach(function (test) {
      describe(test.title, function () {

        beforeEach(function () {
          sinon.stub(mainChartHeatmapMetric, 'get').withArgs('slotDefinitions').returns(test.data.slotDefinitions);
        });

        afterEach(function () {
          mainChartHeatmapMetric.get.restore();
        });

        it('calculateSlot result is valid', function () {
          expect(mainChartHeatmapMetric.calculateSlot(test.data.hostToValueMap, test.data.hostName)).to.equal(test.result);
        });

      });
    });
  });

});

});

require.register("test/controllers/main/charts/heatmap_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
var controller;
require('models/rack');
require('controllers/main/charts/heatmap');
var testHelpers = require('test/helpers');

function getController() {
  return App.MainChartsHeatmapController.create();
}

describe('MainChartsHeatmapController', function () {

  before(function () {
    controller = getController();
  });

  App.TestAliases.testAsComputedAlias(getController(), 'activeWidget', 'widgets.firstObject', 'object');

  App.TestAliases.testAsComputedAlias(getController(), 'hostToSlotMap', 'selectedMetric.hostToSlotMap', 'object');

  describe('#validation()', function () {

    beforeEach(function() {
      controller.setProperties({
        allMetrics: [],
        selectedMetric: Ember.Object.create({maximumValue: 100})
      });
    });

    it('should set maximumValue if inputMaximum consists only of digits', function () {
      controller.set("inputMaximum", 5);
      expect(controller.get('selectedMetric.maximumValue')).to.equal(5);
    });
    it('should not set maximumValue if inputMaximum consists not only of digits', function () {
      controller.set("inputMaximum", 'qwerty');
      expect(controller.get('selectedMetric.maximumValue')).to.equal(100);
    });
    it('should not set maximumValue if inputMaximum consists not only of digits (2)', function () {
      controller.set("inputMaximum", '100%');
      expect(controller.get('selectedMetric.maximumValue')).to.equal(100);
    });
    it('should set maximumValue if inputMaximum consists only of digits (2)', function () {
      controller.set("inputMaximum", 1000);
      expect(controller.get('selectedMetric.maximumValue')).to.equal(1000);
    })
  });

  describe('#showHeatMapMetric()', function () {
    beforeEach(function () {
      controller.setProperties({
        activeWidgetLayout: Em.Object.create({
          displayName: 'widget',
          id: '1',
          scope: 'CLUSTER',
          layoutName: 'defualt_layout',
          sectionName: 'default_section'
        })
      });
    });

    it('should call App.ajax', function () {
      controller.showHeatMapMetric({context:{id: 2}});
      var args = testHelpers.findAjaxRequest('name', 'widget.layout.edit');
      expect(args).to.exists;
    });
  });

  describe('#rackClass', function () {

    beforeEach(function () {
      controller.setProperties({
        allMetrics: [],
        racks: [1]
      });
    });

    it('should return "span12" for 1 cluster rack', function () {
      expect(controller.get('rackClass')).to.equal('span12');
    });
    it('should return "span6" for 2 cluster racks', function () {
      controller.set('racks', [1, 2]);
      expect(controller.get('rackClass')).to.equal('span6');
    });
    it('should return "span4" for 3 cluster racks', function () {
      controller.set('racks', [1, 2, 3]);
      expect(controller.get('rackClass')).to.equal('span4');
    });
  });

  describe("#loadHeatmapsUrlParams", function() {

    it("content.serviceName is null", function() {
      controller.set('content', Em.Object.create({serviceName: null}));
      expect(controller.get('loadHeatmapsUrlParams')).to.equal('WidgetInfo/widget_type=HEATMAP&WidgetInfo/scope=CLUSTER&fields=WidgetInfo/metrics');
    });

    it("content.serviceName is correct", function() {
      controller.set('content', Em.Object.create({serviceName: 'S1'}));
      expect(controller.get('loadHeatmapsUrlParams')).to.equal('WidgetInfo/widget_type=HEATMAP&WidgetInfo/scope=CLUSTER&WidgetInfo/metrics.matches(.*\"service_name\":\"S1\".*)&fields=WidgetInfo/metrics');
    });
  });

  describe("#loadPageData()", function() {
    var allHeatmapData = {
      items: [
        {
          WidgetInfo: 'info'
        }
      ]
    };

    beforeEach(function(){
      sinon.stub(controller, 'loadRacks').returns({
        always: function(callback) {
          callback();
        }
      });
      sinon.stub(controller, 'getAllHeatMaps').returns({
        done: function(callback) {
          callback(allHeatmapData);
        }
      });
      sinon.stub(controller, 'resetPageData');
      sinon.stub(controller, 'categorizeByServiceName').returns('categories');
      sinon.stub(controller, 'getActiveWidgetLayout');
      controller.get('allHeatmaps').clear();
      controller.loadPageData();
    });

    afterEach(function() {
      controller.loadRacks.restore();
      controller.resetPageData.restore();
      controller.getAllHeatMaps.restore();
      controller.categorizeByServiceName.restore();
      controller.getActiveWidgetLayout.restore();
    });

    it("loadRacks() should be called", function() {
      expect(controller.loadRacks.calledOnce).to.be.true;
      expect(controller.resetPageData.calledOnce).to.be.true;
    });

    it("getAllHeatMaps() should be called", function() {
      expect(controller.getAllHeatMaps.calledOnce).to.be.true;
      expect(controller.get('isLoaded')).to.be.true;
      expect(controller.get('allHeatmaps')[0]).to.equal('info')
    });

    it("categorizeByServiceName() should be called", function() {
      expect(controller.categorizeByServiceName.calledOnce).to.be.true;
      expect(controller.get('heatmapCategories')).to.equal('categories');
    });

    it("getActiveWidgetLayout() should be called", function() {
      expect(controller.getActiveWidgetLayout.calledOnce).to.be.true;
    });
  });

  describe("#categorizeByServiceName()", function() {

    beforeEach(function() {
      sinon.stub(App.format, 'role').returns('S1');
    });

    afterEach(function() {
      App.format.role.restore();
    });

    it("single category", function() {
      var allHeatmaps = [
        {
          metrics: JSON.stringify([{service_name: 'S1'}])
        }
      ];
      var categories = controller.categorizeByServiceName(allHeatmaps);
      expect(categories[0].get('serviceName')).to.equal('S1');
      expect(categories[0].get('displayName')).to.equal('S1');
      expect(categories[0].get('heatmaps')).to.eql(allHeatmaps);
    });

    describe("two categories", function() {
      var allHeatmaps;
      beforeEach(function () {
        allHeatmaps = [
          {
            metrics: JSON.stringify([{service_name: 'S1'}])
          },
          {
            metrics: JSON.stringify([{service_name: 'S1'}])
          }
        ];
        this.categories = controller.categorizeByServiceName(allHeatmaps);
      });

      it('serviceName is S1', function () {
        expect(this.categories[0].get('serviceName')).to.equal('S1');
      });
      it('displayName is S1', function () {
        expect(this.categories[0].get('displayName')).to.equal('S1');
      });
      it('heatmaps.0 is valid', function () {
        expect(this.categories[0].get('heatmaps')[0]).to.eql(allHeatmaps[0]);
      });
      it('heatmaps.1 is valid', function () {
        expect(this.categories[0].get('heatmaps')[1]).to.eql(allHeatmaps[1]);
      });
    });
  });

  describe("#resetPageData()", function() {

    it("should clean heatmapCategories and allHeatmaps", function() {
      controller.set('heatmapCategories', [{}]);
      controller.set('allHeatmaps', [{}]);
      controller.resetPageData();
      expect(controller.get('heatmapCategories')).to.be.empty;
      expect(controller.get('allHeatmaps')).to.be.empty;
    });
  });

  describe("#getAllHeatMaps()", function() {

    it("should call App.ajax.send", function() {
      controller.reopen({
        loadHeatmapsUrlParams: 'url',
        sectionName: 's1'
      });
      controller.getAllHeatMaps();
      var args = testHelpers.findAjaxRequest('name', 'widgets.get');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: 'url',
        sectionName: 's1'
      });
    });
  });

  describe("#loadRacks()", function() {

    it("should call App.ajax.send", function() {
      controller.reopen({
        loadRacksUrlParams: 'url'
      });
      controller.loadRacks();
      var args = testHelpers.findAjaxRequest('name', 'hosts.heatmaps');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: 'url'
      });
    });
  });

  describe("#loadRacksSuccessCallback()", function() {

    var data = {
      items: [
        {
          Hosts: {
            host_name: 'host1',
            public_host_name: 'host1',
            os_type: 'os1',
            ip: 'ip1',
            rack_info: 'info'
          },
          host_components: [
            {
              HostRoles: {
                component_name: 'c1'
              }
            }
          ]
        }
      ]
    };

    beforeEach(function() {
      sinon.stub(controller, 'indexByRackId').returns({rack: {}});
      sinon.stub(controller, 'toList').returns(['rack']);
      controller.loadRacksSuccessCallback(data);
    });

    afterEach(function(){
      controller.indexByRackId.restore();
      controller.toList.restore();
    });

    it("indexByRackId should be called", function() {
      expect(controller.indexByRackId.calledWith([{
        hostName: 'host1',
        publicHostName: 'host1',
        osType: 'os1',
        ip: 'ip1',
        rack: 'info',
        diskTotal: 0,
        diskFree: 0,
        cpuSystem: 0,
        cpuUser: 0,
        memTotal: 0,
        memFree: 0,
        hostComponents: ['c1']
      }])).to.be.true;
    });

    it("toList should be called", function() {
      expect(controller.toList.calledWith({rack: {}})).to.be.true;
      expect(controller.get('rackMap')).to.eql({rack: {}});
      expect(controller.get('racks')).to.eql(['rack']);
    });
  });

  describe("#indexByRackId()", function() {

    it("should return rack map", function() {
      var hosts = [
        {rack: 'r1'},
        {rack: 'r1'}
      ];
      var rackMap = controller.indexByRackId(hosts);
      expect(rackMap.r1.name).to.equal('r1');
      expect(rackMap.r1.rackId).to.equal('r1');
      expect(rackMap.r1.hosts).to.eql([{rack: 'r1'}, {rack: 'r1'}]);
    });
  });

  describe("#toList()", function() {
    var rackMap = {'r1': {
      name: 'r1',
      rackId: 'r1',
      hosts: [{rack: 'r1'}, {rack: 'r1'}]
    }};

    it('toList result is valid', function() {
      expect(controller.toList(rackMap)).to.eql([Em.Object.create(rackMap.r1, {
        isLoaded: false,
        index: 0
      })]);
    });
  });

  describe("#addRackView()", function() {

    beforeEach(function() {
      sinon.stub(controller, 'displayAllRacks');
    });

    afterEach(function() {
      controller.displayAllRacks.restore();
    });

    it("displayAllRacks should be called", function() {
      controller.set('racks', [{}]);
      controller.set('rackViews', []);
      controller.addRackView({});
      expect(controller.displayAllRacks.calledOnce).to.be.true;
    });
  });

  describe("#displayAllRacks", function() {
    var rackView = {
      displayHosts: Em.K
    };

    beforeEach(function() {
      sinon.spy(controller, 'displayAllRacks');
      sinon.spy(rackView, 'displayHosts');
    });

    afterEach(function() {
      controller.displayAllRacks.restore();
      rackView.displayHosts.restore();
    });

    it("displayAllRacks should be called again", function() {
      controller.set('rackViews', [rackView]);
      controller.displayAllRacks();
      expect(controller.displayAllRacks.calledTwice).to.be.true;
      expect(rackView.displayHosts.calledOnce).to.be.true;
    });

    it("displayAllRacks should not be called again", function() {
      controller.set('rackViews', []);
      controller.displayAllRacks();
      expect(controller.displayAllRacks.calledOnce).to.be.true;
    });
  });


});


});

require.register("test/controllers/main/dashboard/config_history_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
var testHelpers = require('test/helpers');
require('controllers/main/dashboard/config_history_controller');

describe('MainConfigHistoryController', function () {

  var controller;

  beforeEach(function () {
    controller = App.MainConfigHistoryController.create();
  });

  afterEach(function () {
    clearTimeout(controller.get('timeoutRef'));
    controller.destroy();
  });

  describe('#realUrl', function () {
    it('cluster name is empty', function () {
      App.set('clusterName', '');
      expect(controller.get('realUrl')).to.equal('/api/v1/clusters//configurations/service_config_versions?<parameters>fields=service_config_version,user,group_id,group_name,is_current,createtime,service_name,hosts,service_config_version_note,is_cluster_compatible,stack_id&minimal_response=true');
    });
    it('cluster name is "mycluster"', function () {
      App.set('clusterName', 'mycluster');
      expect(controller.get('realUrl')).to.equal('/api/v1/clusters/mycluster/configurations/service_config_versions?<parameters>fields=service_config_version,user,group_id,group_name,is_current,createtime,service_name,hosts,service_config_version_note,is_cluster_compatible,stack_id&minimal_response=true');
    });
  });
  describe('#load()', function () {

    beforeEach(function () {
      sinon.stub(controller, 'updateTotalCounter', Em.K);
      sinon.stub(controller, 'loadConfigVersionsToModel').returns({done: Em.K});
      controller.load();
    });

    afterEach(function () {
      controller.updateTotalCounter.restore();
      controller.loadConfigVersionsToModel.restore();
    });

    it('updateTotalCounter is called once', function () {
      expect(controller.updateTotalCounter.calledOnce).to.be.true;
    });
  });
  describe('#loadConfigVersionsToModel()', function () {

    beforeEach(function () {
      sinon.stub(App.HttpClient, 'get', Em.K);
      sinon.stub(controller, 'getUrl', Em.K);
      sinon.stub(controller, 'getQueryParameters', function(){
        return [1];
      });
      controller.loadConfigVersionsToModel();
    });

    afterEach(function () {
      controller.getUrl.restore();
      controller.getQueryParameters.restore();
      App.HttpClient.get.restore();
    });

    it('HttpClient.get is called once', function () {
      expect(App.HttpClient.get.calledOnce).to.be.true;
    });

    it('getQueryParameters is called once', function () {
      expect(controller.getQueryParameters.calledOnce).to.be.true;
    });

    it('getUrl is called with correct data', function () {
      expect(controller.getUrl.calledWith([1])).to.be.true;
    });
  });

  describe('#updateTotalCounter()', function () {

    beforeEach(function () {
      controller.updateTotalCounter();
    });

    it('ajax-request is sent', function () {
      var args = testHelpers.findAjaxRequest('name', 'service.serviceConfigVersions.get.total');
      expect(args).to.exists;
    });
  });

  describe('#updateTotalCounterSuccess()', function () {
    it('totalCount is updated', function () {
      controller.updateTotalCounterSuccess({itemTotal: 1});
      expect(controller.get('totalCount')).to.equal(1);
    });
  });
  describe('#getUrl()', function () {
    beforeEach(function () {
      sinon.stub(App.router, 'get', function () {
        return {
          computeParameters: function () {
            return 'params'
          }
        }
      });
    });
    afterEach(function () {
      App.router.get.restore();
    });
    it('query params is empty', function () {

      expect(controller.getUrl()).to.equal('/api/v1/clusters/mycluster/configurations/service_config_versions?fields=service_config_version,user,group_id,group_name,is_current,createtime,service_name,hosts,service_config_version_note,is_cluster_compatible,stack_id&minimal_response=true');
    });
    it('query params is correct', function () {
      expect(controller.getUrl({})).to.equal('/api/v1/clusters/mycluster/configurations/service_config_versions?params&fields=service_config_version,user,group_id,group_name,is_current,createtime,service_name,hosts,service_config_version_note,is_cluster_compatible,stack_id&minimal_response=true');
    });
  });

  describe('#doPolling()', function () {
    beforeEach(function () {
      sinon.stub(controller, 'load', function(){
        return {done: Em.K};
      });
      this.clock = sinon.useFakeTimers();
    });
    afterEach(function () {
      this.clock.restore();
      controller.load.restore();
    });
    it('isPolling false', function () {
      controller.set('isPolling', false);
      controller.doPolling();
      this.clock.tick(App.componentsUpdateInterval);
      expect(controller.load.called).to.be.false;
    });
    it('isPolling true', function () {
      controller.set('isPolling', true);
      controller.doPolling();
      this.clock.tick(App.componentsUpdateInterval);
      expect(controller.load.calledOnce).to.be.true;
    });
  });
});


});

require.register("test/controllers/main/dashboard_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
});

;require.register("test/controllers/main/host/addHost/step4_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var testHelpers = require('test/helpers');

describe('App.AddHostStep4Controller', function() {
  var controller;

  before(function() {
    controller = App.AddHostStep4Controller.create();
  });

  describe("#loadConfigGroups()", function () {

    it("App.ajax.send should be called", function() {
      controller.loadConfigGroups();
      var args = testHelpers.filterAjaxRequests('name', 'config_groups.all_fields');
      expect(args[0][0]).to.eql({
        name: 'config_groups.all_fields',
        sender: controller,
        success: 'successLoadingConfigGroup',
        error: 'errorLoadingConfigGroup'
      });
    });
  });

  describe('#successLoadingConfigGroup()', function() {
    before(function() {
      controller.successLoadingConfigGroup({items: [{}]});
    });
    it('should set config groups on succeeded request', function() {
      expect(App.router.get('addHostController.content.configGroups')).to.eql([{}]);
    });
    it('should set `isConfigGroupLoaded` to true', function() {
      expect(controller.get('isConfigGroupLoaded')).to.true;
    });
  });
  
  describe('#errorLoadingConfigGroup()', function() {
    before(function() {
      controller.errorLoadingConfigGroup();
    });
    it('should set config groups on failed request', function() {
      expect(App.router.get('addHostController.content.configGroups')).to.eql([]);
    });
    it('should set `isConfigGroupLoaded` to true', function() {
      expect(controller.get('isConfigGroupLoaded')).to.true;
    });
  });
});

});

require.register("test/controllers/main/host/add_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/wizard');
require('controllers/main/host/add_controller');
require('models/host_component');
require('models/service');
require('mappers/server_data_mapper');
var testHelpers = require('test/helpers');

describe('App.AddHostController', function () {

  var controller = App.AddHostController.create({
    testDBHosts: null,
    getDBProperty: function () {
      return this.get('testDBHosts');
    },
    setDBProperty: function () {
    },
    loadClients: function () {
    }
  });

  describe('#removeHosts()', function () {
    var testCases = [
      {
        title: 'No hosts, db is empty',
        content: {
          hosts: [],
          dbHosts: {}
        },
        result: {}
      },
      {
        title: 'Host is passed, db is empty',
        content: {
          hosts: [
            {name: 'host1'}
          ],
          dbHosts: {}
        },
        result: {}
      },
      {
        title: 'Passed host different from hosts in db',
        content: {
          hosts: [
            {name: 'host1'}
          ],
          dbHosts: {
            'host2': {}
          }
        },
        result: {
          'host2': {}
        }
      },
      {
        title: 'Passed host match host in db',
        content: {
          hosts: [
            {name: 'host1'}
          ],
          dbHosts: {
            'host1': {}
          }
        },
        result: {}
      }
    ];
    beforeEach(function () {
      sinon.spy(controller, "setDBProperty");
    });
    afterEach(function () {
      controller.setDBProperty.restore();
    });
    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.set('testDBHosts', test.content.dbHosts);
        controller.removeHosts(test.content.hosts);
        expect(controller.setDBProperty.calledWith('hosts', test.result)).to.be.true;
      });
    });
  });

  describe('#sortServiceConfigGroups()', function () {
    var testCases = [
      {
        title: 'No selected services',
        selectedServices: [
          {configGroups: []}
        ],
        result: [
          {configGroups: []}
        ]
      },
      {
        title: 'Only one group is present',
        selectedServices: [
          {configGroups: [
            {configGroups: {group_name: 'b'}}
          ]}
        ],
        result: [
          {configGroups: [
            {configGroups: {group_name: 'b'}}
          ]}
        ]
      },
      {
        title: 'Reverse order of groups',
        selectedServices: [
          {configGroups: [
            {ConfigGroup: {group_name: 'b2'}},
            {ConfigGroup: {group_name: 'a1'}}
          ]}
        ],
        result: [
          {configGroups: [
            {ConfigGroup: {group_name: 'a1'}},
            {ConfigGroup: {group_name: 'b2'}}
          ]}
        ]
      },
      {
        title: 'Correct order of groups',
        selectedServices: [
          {configGroups: [
            {ConfigGroup: {group_name: 'a1'}},
            {ConfigGroup: {group_name: 'b2'}}
          ]}
        ],
        result: [
          {configGroups: [
            {ConfigGroup: {group_name: 'a1'}},
            {ConfigGroup: {group_name: 'b2'}}
          ]}
        ]
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.sortServiceConfigGroups(test.selectedServices);
        expect(test.selectedServices).to.eql(test.result);
      });
    });
  });

  describe('#loadServiceConfigGroupsBySlaves()', function () {
    var testCases = [
      {
        title: 'slaveComponentHosts is null',
        slaveComponentHosts: null,
        result: {
          output: false,
          selectedServices: []
        }
      },
      {
        title: 'slaveComponentHosts is empty',
        slaveComponentHosts: [],
        result: {
          output: false,
          selectedServices: []
        }
      },
      {
        title: 'Component does not have hosts',
        slaveComponentHosts: [
          {hosts: []}
        ],
        result: {
          output: true,
          selectedServices: []
        }
      },
      {
        title: 'Only client component is present',
        slaveComponentHosts: [
          {
            hosts: [
              {hostName: 'host1'}
            ],
            componentName: 'CLIENT'
          }
        ],
        result: {
          output: true,
          selectedServices: []
        }
      }
    ];

    controller.set('content.configGroups', [
      {
        ConfigGroup: {
          tag: 'HDFS',
          group_name: 'HDFS test'
        }
      }
    ]);
    testCases.forEach(function (test) {
      it(test.title, function () {
        var selectedServices = [];
        controller.set('content.slaveComponentHosts', test.slaveComponentHosts);
        expect(controller.loadServiceConfigGroupsBySlaves(selectedServices)).to.equal(test.result.output);
        expect(selectedServices).to.eql(test.result.selectedServices);
      });
    });
  });

  describe('#loadServiceConfigGroupsByClients()', function () {
    var testCases = [
      {
        title: 'slaveComponentHosts is null',
        content: {
          slaveComponentHosts: null,
          clients: [],
          selectedServices: []
        },
        result: {
          output: false,
          selectedServices: []
        }
      },
      {
        title: 'slaveComponentHosts is empty',
        content: {
          slaveComponentHosts: [],
          clients: [],
          selectedServices: []
        },
        result: {
          output: false,
          selectedServices: []
        }
      },
      {
        title: 'Client does not have hosts',
        content: {
          slaveComponentHosts: [
            {
              componentName: 'CLIENT',
              hosts: []
            }
          ],
          clients: [],
          selectedServices: []
        },
        result: {
          output: false,
          selectedServices: []
        }
      },
      {
        title: 'Client has hosts, but clients is empty',
        content: {
          slaveComponentHosts: [
            {
              componentName: 'CLIENT',
              hosts: [
                {hostName: 'host1'}
              ]
            }
          ],
          clients: [],
          selectedServices: []
        },
        result: {
          output: false,
          selectedServices: []
        }
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.set('content.slaveComponentHosts', test.content.slaveComponentHosts);
        controller.set('content.clients', test.content.clients);
        expect(controller.loadServiceConfigGroupsByClients(test.content.selectedServices)).to.equal(test.result.output);
        expect(test.content.selectedServices).to.eql(test.result.selectedServices);
      });
    });
  });

  describe('#installServices()', function () {

    it('No hosts', function () {
      controller.set('content.cluster', {name: 'cl'});
      controller.set('testDBHosts', {});
      expect(controller.installServices()).to.be.false;
      var args = testHelpers.findAjaxRequest('name', 'common.host_components.update');
      expect(args).to.not.exists;
    });
    it('Cluster name is empty', function () {
      controller.set('content.cluster', {name: ''});
      controller.set('testDBHosts', {'host1': {}});
      expect(controller.installServices()).to.be.false;
      var args = testHelpers.findAjaxRequest('name', 'common.host_components.update');
      expect(args).to.not.exists;
    });
    it('Cluster name is correct and hosts are present', function () {
      controller.set('content.cluster', {name: 'cl'});
      controller.set('testDBHosts', {'host1': {isInstalled: false}});
      expect(controller.installServices()).to.be.true;
      var args = testHelpers.findAjaxRequest('name', 'common.host_components.update');
      expect(args).to.exists;
    });
  });

  describe('#getClientsToInstall', function () {
    var services = [
      Em.Object.create({
        serviceName: 'service1'
      }),
      Em.Object.create({
        serviceName: 'service2'
      })
    ];
    var components = [
      Em.Object.create({
        componentName: 'comp1',
        displayName: 'comp1',
        serviceName: 'service1',
        isClient: true
      }),
      Em.Object.create({
        componentName: 'comp2',
        displayName: 'comp2',
        serviceName: 'service1',
        isClient: true
      }),
      Em.Object.create({
        componentName: 'comp3',
        displayName: 'comp3',
        serviceName: 'service2',
        isClient: false
      }),
      Em.Object.create({
        componentName: 'comp4',
        displayName: 'comp4',
        serviceName: 'service3',
        isClient: true
      })
    ];
    var clients = [
      {
        component_name: 'comp1',
        display_name: 'comp1',
        isInstalled: false
      },
      {
        component_name: 'comp2',
        display_name: 'comp2',
        isInstalled: false
      }
    ];
    it("generatel list of clients to install", function () {
      expect(controller.getClientsToInstall(services, components)).to.eql(clients);
    })
  });

  describe("#setCurrentStep()", function () {
    before(function () {
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      sinon.stub(App.db, 'setWizardCurrentStep', Em.K);
    });
    after(function () {
      App.clusterStatus.setClusterStatus.restore();
      App.db.setWizardCurrentStep.restore();
    });
    it("call App.clusterStatus.setClusterStatus()", function () {
      controller.setCurrentStep();
      expect(App.clusterStatus.setClusterStatus.getCall(0).args[0].wizardControllerName).to.be.equal('addHostController');
    });
  });

  describe("#getCluster()", function () {
    before(function () {
      sinon.stub(App.router, 'getClusterName').returns('c1');
    });
    after(function () {
      App.router.getClusterName.restore();
    });
    it("cluster data is valid", function () {
      controller.set('clusterStatusTemplate', {'prop': 'clusterStatusTemplate'});
      expect(controller.getCluster()).to.be.eql({
        prop: 'clusterStatusTemplate',
        name: 'c1'
      });
    });
  });

  /*describe("#loadServices", function () {
    var services = {
      db: null,
      stack: [],
      model: []
    };

    beforeEach(function () {
      sinon.stub(controller, 'getDBProperty', function () {
        return services.db;
      });
      sinon.stub(App.StackService, 'find', function () {
        return services.stack;
      });
      sinon.stub(App.Service, 'find', function () {
        return services.model;
      });
      sinon.stub(controller, 'setDBProperty', Em.K);
    });

    afterEach(function () {
      controller.getDBProperty.restore();
      App.StackService.find.restore();
      App.Service.find.restore();
      controller.setDBProperty.restore();
    });

    Em.A([
      {
        m: 'No services in db, no installed services',
        service: {
          db: null,
          stack: [Em.Object.create({
            serviceName: 'S1'
          })],
          model: []
        },
        e: {

          db: ['services',
            {
              selectedServices: [],
              installedServices: []
            }
          ],
          services: [
            Em.Object.create({
              serviceName: 'S1',
              isInstalled: false,
              isSelected: false
            })
          ]
        }
      },
      {
        m: 'No services in db, installed service present',
        service: {
          db: null,
          stack: [
            Em.Object.create({
              serviceName: 'S1'
            }),
            Em.Object.create({
              serviceName: 'S2'
            })
          ],
          model: [
            Em.Object.create({
              serviceName: 'S1'
            })
          ]
        },
        e: {
          db: ['services',
            {
              selectedServices: ['S1'],
              installedServices: ['S1']
            }
          ],
          services: [
            Em.Object.create({
              serviceName: 'S1',
              isInstalled: true,
              isSelected: true
            }),
            Em.Object.create({
              serviceName: 'S2',
              isInstalled: false,
              isSelected: false
            })
          ]
        }
      },
      {
        m: 'DB is empty',
        service: {
          db: {
            selectedServices: [],
            installedServices: []
          },
          stack: [Em.Object.create({
            serviceName: 'S1'
          })],
          model: []
        },
        e: {
          db: false,
          services: [
            Em.Object.create({
              serviceName: 'S1',
              isSelected: false,
              isInstalled: false
            })
          ]
        }
      },
      {
        m: 'DB has selected and installed services',
        service: {
          db: {
            selectedServices: ['S1'],
            installedServices: ['S2']
          },
          stack: [
            Em.Object.create({
              serviceName: 'S1'
            }),
            Em.Object.create({
              serviceName: 'S2'
            })
          ],
          model: []
        },
        e: {
          db: false,
          services: [
            Em.Object.create({
              serviceName: 'S1',
              isInstalled: false,
              isSelected: true
            }),
            Em.Object.create({
              serviceName: 'S2',
              isInstalled: true,
              isSelected: false
            })
          ]
        }
      }
    ]).forEach(function (test) {

      describe(test.m, function () {

        beforeEach(function () {
          services = test.service;
          controller.loadServices();
        });

        it('services are valid', function () {
          expect(controller.get('content.services')).to.be.eql(test.e.services);
        });

        if (test.e.db) {
          it('setDBProperty is called with valid arguments', function () {
            expect(controller.setDBProperty.getCall(0).args).to.eql(test.e.db);
          });
        }
        else {
          it('setDBProperty is not called', function () {
            expect(controller.setDBProperty.called).to.be.false;
          });
        }

      });

    });

  });
*/
  describe("#loadSlaveComponentHosts()", function () {

    var mock = {
      hosts: null,
      slaveComponentHosts: null
    };

    beforeEach(function () {
      sinon.stub(controller, 'getDBProperties', function (propsList) {
        var ret = {};
        propsList.forEach(function(k) {
          ret[k] = mock[k];
        });
        return ret;
      });
    });

    afterEach(function () {
      controller.getDBProperties.restore();
    });

    it("No slaveComponentHosts in db, null", function () {
      controller.loadSlaveComponentHosts();
      expect(controller.get('content.slaveComponentHosts')).to.be.empty;
    });

    it("No slaveComponentHosts in db", function () {
      mock.slaveComponentHosts = [];
      controller.loadSlaveComponentHosts();
      expect(controller.get('content.slaveComponentHosts')).to.be.empty;
    });

    it("One slaveComponent without hosts", function () {
      mock.slaveComponentHosts = [
        {hosts: []}
      ];
      mock.hosts = {};
      controller.loadSlaveComponentHosts();
      expect(controller.get('content.slaveComponentHosts')).to.be.eql([
        {hosts: []}
      ]);
    });

    it("One slaveComponent with host", function () {
      mock.slaveComponentHosts = [
        {hosts: [
          {host_id: 1}
        ]}
      ];
      mock.hosts = {'host1': {id: 1}};
      controller.loadSlaveComponentHosts();
      expect(controller.get('content.slaveComponentHosts')).to.be.eql([
        {hosts: [
          {
            host_id: 1,
            hostName: 'host1'
          }
        ]}
      ]);
    });

  });

  describe("#saveClients()", function () {
    beforeEach(function () {
      sinon.stub(App.StackServiceComponent, 'find').returns('StackServiceComponent');
      sinon.stub(controller, 'getClientsToInstall').returns(['client']);
      sinon.stub(controller, 'setDBProperty', Em.K);
      controller.set('content.services', [Em.Object.create({'isSelected': true, 'isInstallable': true})]);
      controller.saveClients();
    });
    afterEach(function () {
      controller.setDBProperty.restore();
      App.StackServiceComponent.find.restore();
      controller.getClientsToInstall.restore();
    });
    it("getClientsToInstall called with valid arguments", function () {
      expect(controller.getClientsToInstall.calledWith(
        [Em.Object.create({'isSelected': true, 'isInstallable': true})],
        'StackServiceComponent'
      )).to.be.true;
    });
    it('setDBProperty called with valid arguments', function () {
      expect(controller.setDBProperty.calledWith('clientInfo', ['client'])).to.be.true;
    });
    it('content.clients are valid', function () {
      expect(controller.get('content.clients')).to.be.eql(['client']);
    });
  });

  describe("#getClientsToInstall()", function () {
    var testCases = [
      {
        title: 'No services',
        data: {
          services: [],
          components: []
        },
        result: []
      },
      {
        title: 'No components',
        data: {
          services: [
            {}
          ],
          components: []
        },
        result: []
      },
      {
        title: 'Component is not client',
        data: {
          services: [Em.Object.create({serviceName: 'S1'})],
          components: [Em.Object.create({serviceName: 'S1'})]
        },
        result: []
      },
      {
        title: 'Component is not client',
        data: {
          services: [Em.Object.create({serviceName: 'S1'})],
          components: [Em.Object.create({serviceName: 'S1', isClient: false})]
        },
        result: []
      },
      {
        title: 'Component is client',
        data: {
          services: [Em.Object.create({serviceName: 'S1'})],
          components: [Em.Object.create({
            serviceName: 'S1',
            isClient: true,
            componentName: 'C1',
            displayName: 'C1'
          })]
        },
        result: [
          {
            component_name: 'C1',
            display_name: 'C1',
            isInstalled: false
          }
        ]
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        expect(controller.getClientsToInstall(test.data.services, test.data.components)).to.eql(test.result);
      });
    });
  });

  describe("#applyConfigGroup()", function () {

    it("No config groups", function () {
      controller.set('content.configGroups', []);
      controller.applyConfigGroup();
      var args = testHelpers.findAjaxRequest('name', 'config_groups.update_config_group');
      expect(args).to.not.exists;
    });
    it("selectedConfigGroup absent", function () {
      controller.set('content.configGroups', [
        {
          configGroups: [],
          selectedConfigGroup: ''
        }
      ]);
      controller.applyConfigGroup();
      var args = testHelpers.findAjaxRequest('name', 'config_groups.update_config_group');
      expect(args).to.not.exists;
    });
    it("selectedConfigGroup present", function () {
      controller.set('content.configGroups', [
        {
          configGroups: [
            {
              ConfigGroup: {
                id: 1,
                group_name: 'G1',
                hosts: []
              }
            }
          ],
          selectedConfigGroup: 'G1',
          hosts: ['host1']
        }
      ]);
      controller.applyConfigGroup();
      var args = testHelpers.findAjaxRequest('name', 'config_groups.update_config_group');
      expect(args[0]).to.exists;
      expect(args[0].data).to.be.eql({
        "id": 1,
        "configGroup": {
          "ConfigGroup": {
            "id": 1,
            "group_name": "G1",
            "hosts": [
              {
                "host_name": "host1"
              }
            ]
          }
        }
      });
    });
  });

  describe("#getServiceConfigGroups()", function () {
    before(function () {
      sinon.stub(controller, 'getDBProperty').withArgs('serviceConfigGroups').returns(['serviceConfigGroup']);
    });
    after(function () {
      controller.getDBProperty.restore();
    });
    it("content.configGroups are valid", function () {
      controller.getServiceConfigGroups();
      expect(controller.get('content.configGroups')).to.eql(['serviceConfigGroup']);
    });
  });

  describe("#saveServiceConfigGroups()", function () {
    before(function () {
      sinon.stub(controller, 'setDBProperty', Em.K);
    });
    after(function () {
      controller.setDBProperty.restore();
    });
    it("call setDBProperty()", function () {
      controller.set('content.configGroups', [
        {}
      ]);
      controller.saveServiceConfigGroups();
      expect(controller.setDBProperty.calledWith('serviceConfigGroups', [
        {}
      ])).to.be.true;
    });
  });

  describe("#loadServiceConfigGroups()", function () {
    beforeEach(function () {
      sinon.stub(controller, 'loadServiceConfigGroupsBySlaves', Em.K);
      sinon.stub(controller, 'loadServiceConfigGroupsByClients', Em.K);
      sinon.stub(controller, 'sortServiceConfigGroups', Em.K);
      controller.loadServiceConfigGroups();
    });
    afterEach(function () {
      controller.loadServiceConfigGroupsBySlaves.restore();
      controller.loadServiceConfigGroupsByClients.restore();
      controller.sortServiceConfigGroups.restore();
    });
    it("loadServiceConfigGroupsByClients called with []", function () {
      expect(controller.loadServiceConfigGroupsByClients.calledWith([])).to.be.true;
    });
    it('loadServiceConfigGroupsBySlaves called with []', function () {
      expect(controller.loadServiceConfigGroupsBySlaves.calledWith([])).to.be.true;
    });
    it('sortServiceConfigGroups called with []', function () {
      expect(controller.sortServiceConfigGroups.calledWith([])).to.be.true;
    });
    it('content.configGroups are empty', function () {
      expect(controller.get('content.configGroups')).to.eql([]);
    })
  });

  describe("#sortServiceConfigGroups", function () {
    var testCases = [
      {
        title: 'sorted',
        selectedServices: [
          {
            configGroups: [
              {
                ConfigGroup: {
                  group_name: 'a'
                }
              },
              {
                ConfigGroup: {
                  group_name: 'b'
                }
              }
            ]
          }
        ],
        result: ['a', 'b']
      },
      {
        title: 'not sorted',
        selectedServices: [
          {
            configGroups: [
              {
                ConfigGroup: {
                  group_name: 'b'
                }
              },
              {
                ConfigGroup: {
                  group_name: 'a'
                }
              }
            ]
          }
        ],
        result: ['a', 'b']
      },
      {
        title: 'sort equal',
        selectedServices: [
          {
            configGroups: [
              {
                ConfigGroup: {
                  group_name: 'a'
                }
              },
              {
                ConfigGroup: {
                  group_name: 'a'
                }
              }
            ]
          }
        ],
        result: ['a', 'a']
      }
    ];
    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.sortServiceConfigGroups(test.selectedServices);
        expect(test.selectedServices[0].configGroups.mapProperty('ConfigGroup.group_name')).to.eql(test.result);
      });
    });
  });

  describe("#loadServiceConfigGroupsBySlaves()", function () {
    beforeEach(function () {
      sinon.stub(App.StackServiceComponent, 'find').returns(Em.Object.create({
        stackService: Em.Object.create({
          serviceName: 'S1',
          displayName: 's1'
        })
      }));
      controller.set('content.configGroups', [
        {
          ConfigGroup: {
            tag: 'S1',
            group_name: 'G1'
          }
        }
      ]);
    });
    afterEach(function () {
      App.StackServiceComponent.find.restore();
    });
    it("slaveComponentHosts is empty", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', []);
      expect(controller.loadServiceConfigGroupsBySlaves(selectedServices)).to.be.false;
      expect(selectedServices).to.be.empty;
    });
    it("slaveComponentHosts has ho hosts", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {hosts: []}
      ]);
      expect(controller.loadServiceConfigGroupsBySlaves(selectedServices)).to.be.true;
      expect(selectedServices).to.be.empty;
    });
    it("slaveComponentHosts is CLIENT", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {
          hosts: [
            {hostName: 'host1'}
          ],
          componentName: 'CLIENT'
        }
      ]);
      expect(controller.loadServiceConfigGroupsBySlaves(selectedServices)).to.be.true;
      expect(selectedServices).to.be.empty;
    });
    it("slaveComponentHosts is slave", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {
          hosts: [
            {hostName: 'host1'}
          ],
          componentName: 'C1'
        },
        {
          hosts: [
            {hostName: 'host2'}
          ],
          componentName: 'C2'
        }
      ]);
      expect(controller.loadServiceConfigGroupsBySlaves(selectedServices)).to.be.true;
      expect(selectedServices.toArray()).to.eql([
        {
          "serviceId": "S1",
          "displayName": "s1",
          "hosts": [
            "host1",
            "host2"
          ],
          "configGroupsNames": [
            "Default",
            "G1"
          ],
          "configGroups": [
            {
              "ConfigGroup": {
                "tag": "S1",
                "group_name": "G1"
              }
            }
          ],
          "selectedConfigGroup": "Default"
        }
      ]);
    });
  });

  describe("#loadServiceConfigGroupsByClients()", function () {
    beforeEach(function () {
      sinon.stub(App.StackServiceComponent, 'find').returns(Em.Object.create({
        stackService: Em.Object.create({
          serviceName: 'S1',
          displayName: 's1'
        })
      }));
      sinon.stub(controller, 'loadClients', Em.K);
      controller.set('content.configGroups', [
        {
          ConfigGroup: {
            tag: 'S1',
            group_name: 'G1'
          }
        }
      ]);
    });
    afterEach(function () {
      controller.loadClients.restore();
      App.StackServiceComponent.find.restore();
    });
    it("Clients is null", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', null);
      controller.set('content.clients', null);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.false;
      expect(selectedServices).to.be.empty;
    });
    it("No CLIENT component", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', []);
      controller.set('content.clients', []);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.false;
      expect(selectedServices).to.be.empty;
    });
    it("Clients is empty", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {
          componentName: 'CLIENT',
          hosts: []
        }
      ]);
      controller.set('content.clients', []);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.false;
      expect(selectedServices).to.be.empty;
    });
    it("Client component does not have hosts", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {
          componentName: 'CLIENT',
          hosts: []
        }
      ]);
      controller.set('content.clients', [
        {}
      ]);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.false;
      expect(selectedServices).to.be.empty;
    });
    it("Client present, selectedServices is empty", function () {
      var selectedServices = [];
      controller.set('content.slaveComponentHosts', [
        {
          componentName: 'CLIENT',
          hosts: [
            {hostName: 'host1'}
          ]
        }
      ]);
      controller.set('content.clients', [
        {
          component_name: 'C1'
        }
      ]);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.true;
      expect(selectedServices).to.be.eql([
        {
          "serviceId": "S1",
          "displayName": "s1",
          "hosts": [
            "host1"
          ],
          "configGroupsNames": [
            "Default",
            "G1"
          ],
          "configGroups": [
            {
              "ConfigGroup": {
                "tag": "S1",
                "group_name": "G1"
              }
            }
          ],
          "selectedConfigGroup": "Default"
        }
      ]);
    });
    it("Client present, selectedServices has service", function () {
      var selectedServices = [
        {
          serviceId: 'S1',
          hosts: ['host1', 'host2']
        }
      ];
      controller.set('content.slaveComponentHosts', [
        {
          componentName: 'CLIENT',
          hosts: [
            {hostName: 'host1'}
          ]
        }
      ]);
      controller.set('content.clients', [
        {
          component_name: 'C1'
        }
      ]);

      expect(controller.loadServiceConfigGroupsByClients(selectedServices)).to.be.true;
      expect(selectedServices[0].hosts).to.be.eql(["host1", "host2"]);
    });
  });

  describe("#loadServiceConfigProperties()", function () {
    beforeEach(function () {
      this.mock = sinon.stub(App.db, 'get');
      this.mock.withArgs('Installer', 'serviceConfigProperties').returns([1]);
    });
    afterEach(function () {
      this.mock.restore();
    });
    it("serviceConfigProperties is null", function () {
      this.mock.withArgs('AddService', 'serviceConfigProperties').returns(null);
      controller.loadServiceConfigProperties();
      expect(controller.get('content.serviceConfigProperties')).to.eql([1]);
    });
    it("serviceConfigProperties is empty", function () {
      this.mock.withArgs('AddService', 'serviceConfigProperties').returns([]);
      controller.loadServiceConfigProperties();
      expect(controller.get('content.serviceConfigProperties')).to.eql([1]);
    });
    it("serviceConfigProperties has data", function () {
      this.mock.withArgs('AddService', 'serviceConfigProperties').returns([1]);
      controller.loadServiceConfigProperties();
      expect(controller.get('content.serviceConfigProperties')).to.eql([1]);
    });
  });

  describe("#clearAllSteps()", function () {
    beforeEach(function () {
      sinon.stub(controller, 'clearInstallOptions', Em.K);
      sinon.stub(controller, 'getCluster').returns({});
      controller.clearAllSteps();
    });
    afterEach(function () {
      controller.clearInstallOptions.restore();
      controller.getCluster.restore();
    });
    it("getCluster called once", function () {
      expect(controller.getCluster.calledOnce).to.be.true;
    });
    it('clearInstallOptions called once', function () {
      expect(controller.clearInstallOptions.calledOnce).to.be.true;
    });
    it('content.cluster is empty object', function () {
      expect(controller.get('content.cluster')).to.eql({});
    });
  });

  describe("#clearStorageData()", function () {
    beforeEach(function () {
      sinon.stub(controller, 'resetDbNamespace', Em.K);
    });
    afterEach(function () {
      controller.resetDbNamespace.restore();
    });
    it("launch resetDbNamespace", function () {
      controller.clearStorageData();
      expect(controller.resetDbNamespace.calledOnce).to.be.true;
    });
  });

  describe("#finish()", function () {
    beforeEach(function () {
      sinon.stub(controller, 'clearAllSteps', Em.K);
      sinon.stub(controller, 'clearStorageData', Em.K);
      controller.finish();
    });
    afterEach(function () {
      controller.clearAllSteps.restore();
      controller.clearStorageData.restore();
    });
    it("clearAllSteps called once", function () {
      expect(controller.clearAllSteps.calledOnce).to.be.true;
    });
    it('clearStorageData called once', function () {
      expect(controller.clearStorageData.calledOnce).to.be.true;
    });
  });
});

});

require.register("test/controllers/main/host/bulk_operations_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

describe('BulkOperationsController', function () {

  var hostController;

  describe('#bulkOperation', function() {

    beforeEach(function() {
      hostController = App.BulkOperationsController.create({});
      sinon.stub(hostController, 'bulkOperationForHostsRestart', Em.K);
      sinon.stub(hostController, 'bulkOperationForHosts', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostsReinstall', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostComponentsRestart', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostComponentsDecommission', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostComponents', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostComponentsAdd', Em.K);
      sinon.stub(hostController, 'bulkOperationForHostsPassiveState', Em.K);
    });

    afterEach(function() {
      hostController.bulkOperationForHosts.restore();
      hostController.bulkOperationForHostsRestart.restore();
      hostController.bulkOperationForHostsReinstall.restore();
      hostController.bulkOperationForHostComponentsRestart.restore();
      hostController.bulkOperationForHostComponentsDecommission.restore();
      hostController.bulkOperationForHostComponents.restore();
      hostController.bulkOperationForHostComponentsAdd.restore();
      hostController.bulkOperationForHostsPassiveState.restore();

    });

    it('RESTART for hosts', function() {
      var operationData = {
        action: 'RESTART'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostsRestart.calledOnce).to.equal(true);
    });

    it('START for hosts', function() {
      var operationData = {
        action: 'STARTED'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHosts.calledOnce).to.equal(true);
    });

    it('STOP for hosts', function() {
      var operationData = {
        action: 'INSTALLED'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHosts.calledOnce).to.equal(true);
    });

    it('REINSTALL for hosts', function() {
      var operationData = {
        action: 'REINSTALL'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostsReinstall.calledOnce).to.equal(true);
    });

    it('PASSIVE_STATE for hosts', function() {
      var operationData = {
        action: 'PASSIVE_STATE'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostsPassiveState.calledOnce).to.equal(true);
    });

    it('RESTART for hostComponents', function() {
      var operationData = {
        action: 'RESTART',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponentsRestart.calledOnce).to.equal(true);
    });

    it('START for hostComponents', function() {
      var operationData = {
        action: 'STARTED',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponents.calledOnce).to.equal(true);
    });

    it('STOP for hostComponents', function() {
      var operationData = {
        action: 'INSTALLED',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponents.calledOnce).to.equal(true);
    });

    it('ADD for hostComponents', function() {
      var operationData = {
        action: 'ADD',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponentsAdd.calledOnce).to.equal(true);
    });

    it('DECOMMISSION for hostComponents', function() {
      var operationData = {
        action: 'DECOMMISSION',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponentsDecommission.calledOnce).to.equal(true);
    });

    it('RECOMMISSION for hostComponents', function() {
      var operationData = {
        action: 'DECOMMISSION_OFF',
        componentNameFormatted: 'DataNodes'
      };
      hostController.bulkOperation(operationData, []);
      expect(hostController.bulkOperationForHostComponentsDecommission.calledOnce).to.equal(true);
    });

  });

  describe('#warnBeforeDecommissionSuccess()', function () {
    var mock = {
      showHbaseActiveWarning: Em.K,
      checkRegionServerState: Em.K
    };
    beforeEach(function () {
      hostController = App.BulkOperationsController.create({});
      sinon.stub(App.router, 'get', function () {
        return mock;
      });
      sinon.spy(mock, 'showHbaseActiveWarning');
      sinon.spy(mock, 'checkRegionServerState');
    });
    afterEach(function () {
      App.router.get.restore();
      mock.showHbaseActiveWarning.restore();
      mock.checkRegionServerState.restore();
    });

    it('items length more than 0', function () {
      hostController.warnBeforeDecommissionSuccess({items: [1]}, {}, {});
      expect(mock.showHbaseActiveWarning.calledOnce).to.be.true;
    });
    it('items length equal 0', function () {
      hostController.warnBeforeDecommissionSuccess({items: []}, {}, {hostNames: 'host1'});
      expect(mock.checkRegionServerState.calledWith('host1')).to.be.true;
    });
  });

});

});

require.register("test/controllers/main/host/configs_service_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/host/configs_service');


describe('App.MainHostServiceConfigsController', function () {

  var controller = App.MainHostServiceConfigsController.create({
    host: Em.Object.create()
  });


  describe('#filterServiceConfigs()', function () {
    var testCases = [
      {
        title: 'configCategories is empty',
        content: {
          configCategories: [],
          hostComponents: []
        },
        result: []
      },
      {
        title: 'Category hostComponentNames is null',
        content: {
          configCategories: [
            Em.Object.create({hostComponentNames: null})
          ],
          hostComponents: []
        },
        result: [
          Em.Object.create({hostComponentNames: null})
        ]
      },
      {
        title: 'Components of host are empty',
        content: {
          configCategories: [
            Em.Object.create({hostComponentNames: ['comp1']})
          ],
          hostComponents: []
        },
        result: []
      },
      {
        title: 'Host components do not match component of categories',
        content: {
          configCategories: [
            Em.Object.create({hostComponentNames: ['comp1']})
          ],
          hostComponents: [
            {
              componentName: 'comp2'
            }
          ]
        },
        result: []
      },
      {
        title: 'Host components match component of categories',
        content: {
          configCategories: [
            Em.Object.create({hostComponentNames: ['comp1']})
          ],
          hostComponents: [
            {
              componentName: 'comp1'
            }
          ]
        },
        result: [
          Em.Object.create({hostComponentNames: ['comp1']})
        ]
      }
    ];

    testCases.forEach(function (test) {
      it(test.title, function () {
        controller.set('host.hostComponents', test.content.hostComponents);
        expect(controller.filterServiceConfigs(test.content.configCategories)).to.eql(test.result);
      });
    });
  });

	describe("#loadStep()", function () {
    beforeEach(function() {
      sinon.stub(App.themesMapper, 'generateAdvancedTabs', Em.K);
      sinon.stub(controller, 'loadCurrentVersions', Em.K);
      sinon.stub(controller, 'loadConfigTheme', function() {
        return { always: Em.K };
      });
      sinon.stub(controller, 'trackRequest');
    });
    afterEach(function() {
      controller.loadCurrentVersions.restore();
      controller.loadConfigTheme.restore();
      App.themesMapper.generateAdvancedTabs.restore();
      controller.trackRequest.restore();
    });
		it("should set host", function () {
			controller.set('content', {
				host: 'host1',
        dependentServiceNames: []
			});
			controller.loadStep();
			expect(controller.get('host')).to.be.equal('host1');
		});
	});

	describe("#renderServiceConfigs()", function () {

    beforeEach(function () {
      sinon.stub(controller, 'filterServiceConfigs', function () {
        this._super = Em.K;
      });
    });

    afterEach(function () {
      controller.filterServiceConfigs.restore();
    });

		it("should call filterServiceConfigs", function () {
			var serviceConfigs = {
				configCategories: 'val'
			};
			controller.renderServiceConfigs(serviceConfigs);
			expect(controller.filterServiceConfigs.calledWith('val')).to.be.true;
		});
	});

	describe("#switchHostGroup()", function () {

    beforeEach(function() {
      sinon.stub(controller, 'launchSwitchConfigGroupOfHostDialog', Em.K);
      });

    afterEach(function () {
      controller.launchSwitchConfigGroupOfHostDialog.restore();
    });

		it("should call launchSwitchConfigGroupOfHostDialog", function () {
			controller.set('selectedConfigGroup', {});
			controller.set('configGroups', []);
			controller.set('host', {hostName: 'host1'});
			controller.switchHostGroup();

			expect(controller.launchSwitchConfigGroupOfHostDialog.calledWith({}, [], 'host1')).to.be.true;
		});
	});

});

});

require.register("test/controllers/main/host/details_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/host/details');
require('models/service');
require('models/host_component');
require('models/host_stack_version');
var batchUtils = require('utils/batch_scheduled_requests');
var hostsManagement = require('utils/hosts');
var testHelpers = require('test/helpers');
var controller;

function getController() {
  return App.MainHostDetailsController.create(App.InstallComponent, {
    content: Em.Object.create({
      hostComponents: []
    })
  });
}
describe('App.MainHostDetailsController', function () {

  beforeEach(function () {
    controller = getController();
  });

  App.TestAliases.testAsComputedFilterBy(getController(), 'serviceNonClientActiveComponents', 'serviceActiveComponents', 'isClient', false);

  describe('#routeHome()', function () {

    beforeEach(function () {
      sinon.stub(App.router, 'transitionTo', Em.K);
    });

    afterEach(function () {
      App.router.transitionTo.restore();
    });

    it('transition to dashboard', function () {
      controller.routeHome();
      expect(App.router.transitionTo.calledWith('main.dashboard.index')).to.be.true;
    });
  });

  describe('#startComponent()', function () {

    var event = {
      context: Em.Object.create({
        displayName: 'comp'
      })
    };

    beforeEach(function () {
      sinon.stub(App, 'showConfirmationPopup', function (callback) {
        callback();
      });
      sinon.stub(controller, 'sendComponentCommand');
      controller.startComponent(event);
    });

    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.sendComponentCommand.restore();
    });

    it('configmation popup is shown', function () {
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
    });

    it('call sendComponentCommand', function () {
      expect(controller.sendComponentCommand.calledWith(Em.Object.create({
        displayName: 'comp'
      })), Em.I18n.t('requestInfo.startHostComponent') + " comp", App.HostComponentStatus.started).to.be.true;

    });
  });

  describe('#stopComponent()', function () {

    beforeEach(function () {
      sinon.stub(App, 'showConfirmationPopup', Em.clb);
      sinon.stub(controller, 'checkNnLastCheckpointTime', Em.clb);
      sinon.stub(controller, 'sendComponentCommand');
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.sendComponentCommand.restore();
      controller.checkNnLastCheckpointTime.restore();
    });

    it('call sendComponentCommand', function () {
      var event = {
        context: Em.Object.create({
          displayName: 'comp'
        })
      };
      controller.stopComponent(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      expect(controller.sendComponentCommand.calledWith(Em.Object.create({
        displayName: 'comp'
      })), Em.I18n.t('requestInfo.stopHostComponent') + " comp", App.HostComponentStatus.stopped).to.be.true;
    });
    it('stop NN, should check last NN checkpoint before stop', function () {
      var event = {
        context: Em.Object.create({
          displayName: 'NameNode',
          componentName: 'NAMENODE'
        })
      };
      controller.stopComponent(event);
      expect(controller.checkNnLastCheckpointTime.calledOnce).to.be.true;
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      expect(controller.sendComponentCommand.calledWith(event.context, Em.I18n.t('requestInfo.stopHostComponent') + " NameNode", App.HostComponentStatus.stopped)).to.be.true;
    });
  });

  describe("#pullNnCheckPointTime()", function() {
    it("valid request is sent", function() {
      controller.pullNnCheckPointTime('host1');
      var args = testHelpers.findAjaxRequest('name', 'common.host_component.getNnCheckPointTime');
      expect(args[0]).to.exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        host: 'host1'
      });
    });
  });

  describe('#sendComponentCommand()', function () {

    describe('single component', function () {
      var component;
      beforeEach(function () {
        controller.set('content.hostName', 'host1');
        component = Em.Object.create({
          service: {serviceName: 'S1'},
          componentName: 'COMP1'
        });

        controller.sendComponentCommand(component, {}, 'state');
      });

      it('1st call endpoint is valid', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.host.host_component.update');
        expect(args).to.exists;
      });

      it('1st call data is valid', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.host.host_component.update');
        expect(args[0]).to.exists;
        expect(args[0].data).to.be.eql({
          "hostName": "host1",
          "context": {},
          "component": component,
          "HostRoles": {
            "state": "state"
          },
          "componentName": "COMP1",
          "serviceName": "S1"
        });
      });
    });

    describe('multiple component', function () {
      var component;
      beforeEach(function () {
        controller.set('content.hostName', 'host1');
        component = [
          Em.Object.create({
            service: {serviceName: 'S1'},
            componentName: 'COMP1'
          }),
          Em.Object.create({
            service: {serviceName: 'S1'},
            componentName: 'COMP2'
          })
        ];
        controller.sendComponentCommand(component, {}, 'state');
      });

      it('1st call endpoint is valid', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.host.host_components.update');
        expect(args).exists;
      });

      it('1st call data is valid', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.host.host_components.update');
        expect(args[0]).exists;
        expect(args[0].data).to.be.eql({
          "hostName": "host1",
          "context": {},
          "component": component,
          "HostRoles": {
            "state": "state"
          },
          "query": "HostRoles/component_name.in(COMP1,COMP2)"
        });
      });
    });

  });

  describe('#sendComponentCommandSuccessCallback()', function () {

    var params = {
      component: Em.Object.create({}),
      HostRoles: {
        state: App.HostComponentStatus.stopped
      }
    };

    beforeEach(function () {
      sinon.stub(controller, 'mimicWorkStatusChange', Em.K);
      sinon.stub(controller, 'showBackgroundOperationsPopup', Em.K);
      controller.sendComponentCommandSuccessCallback({}, {}, params);
    });

    afterEach(function () {
      controller.showBackgroundOperationsPopup.restore();
      controller.mimicWorkStatusChange.restore();
    });

    it('mimicWorkStatusChange is not called', function () {
      expect(controller.mimicWorkStatusChange.called).to.be.false;
    });
    it('showBackgroundOperationsPopup is called once', function () {
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#ajaxErrorCallback()', function () {
    beforeEach(function () {
      sinon.stub(controller, 'ajaxErrorCallback', Em.K);
    });
    afterEach(function () {
      controller.ajaxErrorCallback.restore();
    });
    it('call mainServiceItemController.ajaxErrorCallback', function () {
      controller.ajaxErrorCallback('request', 'ajaxOptions', 'error', 'opt', 'params');
      expect(controller.ajaxErrorCallback.calledWith('request', 'ajaxOptions', 'error', 'opt', 'params')).to.be.true;
    });
  });

  describe('#showBackgroundOperationsPopup()', function () {
    var mock = {
      done: function (callback) {
        callback(this.initValue);
      }
    };
    var bgController = {
      showPopup: Em.K
    };

    beforeEach(function () {
      var stub = sinon.stub(App.router, 'get');
      stub.withArgs('userSettingsController').returns({
        dataLoading: function () {
          return mock;
        }
      });
      stub.withArgs('backgroundOperationsController').returns(bgController);
      sinon.spy(bgController, 'showPopup');
      sinon.spy(mock, 'done');
      this.callback = sinon.stub();
    });

    afterEach(function () {
      bgController.showPopup.restore();
      mock.done.restore();
      App.router.get.restore();
    });

    it('initValue is true, callback is undefined', function () {
      mock.initValue = true;
      controller.showBackgroundOperationsPopup();
      expect(mock.done.calledOnce).to.be.true;
      expect(bgController.showPopup.calledOnce).to.be.true;
    });

    it('initValue is false, callback is defined', function () {
      mock.initValue = false;
      controller.showBackgroundOperationsPopup(this.callback);
      expect(mock.done.calledOnce).to.be.true;
      expect(bgController.showPopup.calledOnce).to.be.false;
      expect(this.callback.calledOnce).to.be.true;
    });
  });

  describe('#serviceActiveComponents', function () {

    it('No host-components', function () {
      controller.set('content', {hostComponents: []});
      expect(controller.get('serviceActiveComponents')).to.be.empty;
    });

    it('No host-components in active state', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          service: {
            isInPassive: true
          }
        })]
      });
      expect(controller.get('serviceActiveComponents')).to.be.empty;
    });
    it('Host-components in active state', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          service: {
            isInPassive: false
          }
        })]
      });
      expect(controller.get('serviceActiveComponents')).to.eql([Em.Object.create({
        service: {
          isInPassive: false
        }
      })]);
    });
  });

  describe('#serviceNonClientActiveComponents', function () {

    it('No active host-components', function () {
      controller.reopen({
        serviceActiveComponents: []
      });
      controller.set('serviceActiveComponents', []);
      expect(controller.get('serviceNonClientActiveComponents')).to.be.empty;
    });

    it('Active host-component is client', function () {
      controller.reopen({
        serviceActiveComponents: [Em.Object.create({
          isClient: true
        })]
      });
      expect(controller.get('serviceNonClientActiveComponents')).to.be.empty;
    });
    it('Active host-component is not client', function () {
      controller.reopen({
        serviceActiveComponents: [Em.Object.create({
          isClient: false
        })]
      });
      expect(controller.get('serviceNonClientActiveComponents')).to.eql([Em.Object.create({
        isClient: false
      })]);
    });
  });

  describe.skip('#deleteComponent()', function () {

    var jQueryMock,
      cases = [
        {
          isDisabled: false,
          showCallCount: 1,
          title: 'confirm popup should be displayed'
        },
        {
          isDisabled: true,
          showCallCount: 0,
          title: 'confirm popup shouldn\'t be displayed'
        }
      ];

    beforeEach(function () {
      jQueryMock = sinon.stub(window, '$');
      sinon.spy(App.ModalPopup, 'show');
      sinon.stub(controller, '_doDeleteHostComponent', Em.K);
    });

    afterEach(function () {
      jQueryMock.restore();
      App.ModalPopup.show.restore();
      controller._doDeleteHostComponent.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        jQueryMock.returns({
          closest: function () {
            return {
              hasClass: function () {
                return item.isDisabled;
              }
            }
          }
        });
        var event = {
            context: Em.Object.create({})
          },
          popup = controller.deleteComponent(event);
        expect(App.ModalPopup.show.callCount).to.equal(item.showCallCount);
        if (item.showCallCount) {
          popup.onPrimary();
          expect(controller._doDeleteHostComponent.calledWith(Em.Object.create({}))).to.be.true;
        }
      });
    });

  });

  describe('#mimicWorkStatusChange()', function () {

    var clock;
    beforeEach(function () {
      clock = sinon.useFakeTimers();
    });
    afterEach(function () {
      clock.restore();
    });

    it('change status of object', function () {
      var entity = Em.Object.create({
        workStatus: ''
      });
      controller.mimicWorkStatusChange(entity, 'STATE1', 'STATE2');
      expect(entity.get('workStatus')).to.equal('STATE1');
      clock.tick(App.testModeDelayForActions);
      expect(entity.get('workStatus')).to.equal('STATE2');
    });
    it('change status of objects in array', function () {
      var entity = [Em.Object.create({
        workStatus: ''
      })];
      controller.mimicWorkStatusChange(entity, 'STATE1', 'STATE2');
      expect(entity[0].get('workStatus')).to.equal('STATE1');
      clock.tick(App.testModeDelayForActions);
      expect(entity[0].get('workStatus')).to.equal('STATE2');
    });
  });

  describe('#upgradeComponent()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
    });

    it('confirm popup should be displayed', function () {
      var popup = controller.upgradeComponent({context: Em.Object.create()});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      var args = testHelpers.findAjaxRequest('name', 'host.host_component.upgrade');
      expect(args).exists;
    });
  });

  describe('#restartComponent()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(batchUtils, "restartHostComponents", Em.K);
      sinon.stub(controller, 'checkNnLastCheckpointTime', Em.clb);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      batchUtils.restartHostComponents.restore();
      controller.checkNnLastCheckpointTime.restore();
    });

    it('popup should be displayed', function () {
      var popup = controller.restartComponent({context: Em.Object.create({'displayName': 'Comp1'})});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(batchUtils.restartHostComponents.calledOnce).to.be.true;
    });

    it('restart NN, should check last NN checkpoint before restart', function () {
      var event = {
        context: Em.Object.create({
          displayName: 'NameNode',
          componentName: 'NAMENODE'
        })
      };
      controller.restartComponent(event);
      expect(controller.checkNnLastCheckpointTime.calledOnce).to.equal(true);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
    });
  });

  describe('#addComponent()', function () {
    var cases = [
      {
        componentName: 'ZOOKEEPER_SERVER',
        showAddComponentPopupCallCount: 1,
        showConfirmationPopupCallCount: 0
      },
      {
        componentName: 'RESOURCEMANAGER',
        showAddComponentPopupCallCount: 1,
        showConfirmationPopupCallCount: 0
      },
      {
        componentName: 'JOURNALNODE',
        showAddComponentPopupCallCount: 0,
        showConfirmationPopupCallCount: 1
      },
      {
        componentName: 'HIVE_CLIENT',
        showAddComponentPopupCallCount: 1,
        showConfirmationPopupCallCount: 0
      }
    ];
    beforeEach(function () {
      sinon.stub(controller, "checkComponentDependencies", Em.K);
      sinon.stub(controller, "showAddComponentPopup", Em.K);
      sinon.stub(controller, "clearConfigsChanges", Em.K);
      sinon.stub(App, "showConfirmationPopup", Em.K);
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: "HDFS_CLIENT"
        })]
      });
    });

    afterEach(function () {
      controller.checkComponentDependencies.restore();
      controller.showAddComponentPopup.restore();
      controller.clearConfigsChanges.restore();
      App.showConfirmationPopup.restore();
    });

    cases.forEach(function (testCase) {

      describe('add ' + testCase.componentName, function () {

        beforeEach(function () {
          var event = {
            context: Em.Object.create({
              componentName: testCase.componentName
            })
          };
          controller.addComponent(event);
        });

        it('controller.showAddComponentPopup', function () {
          expect(controller.showAddComponentPopup.callCount).to.equal(testCase.showAddComponentPopupCallCount);
        });

        it('App.showConfirmationPopup', function () {
          expect(App.showConfirmationPopup.callCount).to.equal(testCase.showConfirmationPopupCallCount);
        });

      });

    });

  });

  describe("#loadOozieConfigs()", function() {
    it("valid request is sent", function() {
      controller.loadOozieConfigs({Clusters: {
        desired_configs: {
          'oozie-env': {
            tag: 'tag'
          }
        }
      }});
      var args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: '(type=oozie-env&tag=tag)'
      });
    });
  });

  describe("#loadStormConfigs()", function() {
    it("valid request is sent", function() {
      controller.loadStormConfigs({Clusters: {
        desired_configs: {
          'storm-site': {
            tag: 'tag'
          }
        }
      }}, null, {});
      var args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: '(type=storm-site&tag=tag)'
      });
    });
  });

  describe("#onLoadStormConfigs()", function() {

    var data = {items: [
      {
        type: 'storm-site',
        properties: {
          'nimbus.seeds': ''
        }
      }
    ]};

    beforeEach(function () {
      sinon.stub(controller, 'getStormNimbusHosts').returns("host1");
      sinon.stub(controller, 'updateZkConfigs', Em.K);
      sinon.stub(controller, 'saveConfigsBatch', Em.K);
      sinon.stub(controller, 'saveLoadedConfigs', Em.K);
      controller.set('nimbusHost', 'host2');
      controller.onLoadStormConfigs(data);
    });
    afterEach(function () {
      controller.getStormNimbusHosts.restore();
      controller.updateZkConfigs.restore();
      controller.saveConfigsBatch.restore();
      controller.saveLoadedConfigs.restore();
    });
    it("updateZkConfigs called with valid arguments", function() {
      expect(controller.updateZkConfigs.calledWith({'storm-site': {
        'nimbus.seeds': "'host1'"
      }})).to.be.true;
    });
    it('saveConfigsBatch called with valid arguments', function () {
      expect(controller.saveConfigsBatch.calledWith([
        {
          properties: {
            'storm-site': {
              'nimbus.seeds': "'host1'"
            }
          },
          properties_attributes: {
            'storm-site': {}
          }
        }
      ], 'NIMBUS', 'host2')).to.be.true;
    });
  });

  describe("#loadHiveConfigs()", function() {
    it("valid request is sent", function() {
      controller.loadHiveConfigs({Clusters: {
        desired_configs: {
          'hive-site': {
            tag: 'tag'
          },
          'webhcat-site': {
            tag: 'tag'
          },
          'hive-env': {
            tag: 'tag'
          },
          'core-site': {
            tag: 'tag'
          }
        }
      }}, null, {});
      var args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: '(type=hive-site&tag=tag)|(type=webhcat-site&tag=tag)|(type=hive-env&tag=tag)|(type=core-site&tag=tag)'
      });
    });
  });

  describe("#loadAtlasConfigs()", function() {
    it("valid request is sent", function() {
      controller.loadAtlasConfigs({Clusters: {
        desired_configs: {
          'application-properties': {
            tag: 'tag'
          }
        }
      }}, null, {});
      var args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: '(type=application-properties&tag=tag)'
      });
    });
  });

  describe("#loadRangerConfigs()", function() {
    it("valid request is sent", function() {
      controller.loadRangerConfigs({Clusters: {
        desired_configs: {
          'hdfs-site': {
            tag: 'tag'
          },
          'kms-env': {
            tag: 'tag'
          },
          'core-site': {
            tag: 'tag'
          },
          'kms-site': {
            tag: 'tag'
          }
        }
      }}, null, {});
      var args = testHelpers.findAjaxRequest('name', 'admin.get.all_configurations');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        urlParams: '(type=core-site&tag=tag)|(type=hdfs-site&tag=tag)|(type=kms-env&tag=tag)|(type=kms-site&tag=tag)'
      });
    });
  });

  describe("#getRangerKMSServerHosts()", function() {
    beforeEach(function(){
      sinon.stub(App.HostComponent, 'find').returns([{
        componentName: 'RANGER_KMS_SERVER',
        hostName: 'host1'
      }]);
      controller.set('rangerKMSServerHost', 'host2');
      controller.set('content.hostName', 'host1');
      controller.set('deleteRangerKMSServer', true);
      controller.set('fromDeleteHost', true);
      this.hosts = controller.getRangerKMSServerHosts();
    });
    afterEach(function(){
      App.HostComponent.find.restore();
    });
    it('hosts list is valid', function() {
      expect(this.hosts).to.eql(['host2']);
    });
  });

  describe("#getStormNimbusHosts()", function() {
    beforeEach(function(){
      sinon.stub(App.HostComponent, 'find').returns([{
        componentName: 'NIMBUS',
        hostName: 'host1'
      }]);
      controller.set('nimbusHost', 'host2');
      controller.set('content.hostName', 'host1');
      controller.set('deleteNimbusHost', true);
      controller.set('fromDeleteHost', true);
      this.hosts = controller.getStormNimbusHosts();
    });
    afterEach(function(){
      App.HostComponent.find.restore();
    });
    it("hosts list is valid", function() {
      expect(this.hosts).to.eql(['host2']);
    });
    it('nimbusHost is empty', function () {
      expect(controller.get('nimbusHost')).to.be.empty;
    });
    it('deleteNimbusHost is false', function () {
      expect(controller.get('deleteNimbusHost')).to.be.false;
    });
    it('fromDeleteHost is false', function () {
      expect(controller.get('fromDeleteHost')).to.be.false;
    });
  });

  describe('#showAddComponentPopup()', function () {

    beforeEach(function () {
      sinon.stub(App.ModalPopup, 'show');
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it('should display add component confirmation', function () {
      controller.showAddComponentPopup(Em.Object.create());
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe('#installNewComponentSuccessCallback()', function () {

    beforeEach(function () {
      sinon.stub(controller, "showBackgroundOperationsPopup", Em.K);
    });
    afterEach(function () {
      controller.showBackgroundOperationsPopup.restore();
    });

    it('data is null', function () {
      expect(controller.installNewComponentSuccessCallback(null, {}, {})).to.be.false;
      expect(controller.showBackgroundOperationsPopup.called).to.be.false;
    });
    it('data.Requests is null', function () {
      var data = {Requests: null};
      expect(controller.installNewComponentSuccessCallback(data, {}, {})).to.be.false;
      expect(controller.showBackgroundOperationsPopup.called).to.be.false;
    });
    it('data.Requests.id is null', function () {
      var data = {Requests: {id: null}};
      expect(controller.installNewComponentSuccessCallback(data, {}, {})).to.be.false;
      expect(controller.showBackgroundOperationsPopup.called).to.be.false;
    });
    it('data.Requests.id is correct', function () {
      var data = {Requests: {id: 1}};
      expect(controller.installNewComponentSuccessCallback(data, {}, {component: []})).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#refreshComponentConfigs()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, "sendRefreshComponentConfigsCommand", Em.K);
    });

    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.sendRefreshComponentConfigsCommand.restore();
    });

    it('popup should be displayed', function () {
      var popup = controller.refreshComponentConfigs({context: Em.Object.create({'displayName': 'Comp1'})});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.sendRefreshComponentConfigsCommand.calledOnce).to.be.true;
    });
  });

  describe('#sendRefreshComponentConfigsCommand()', function () {
    it('Query should be sent', function () {
      var component = Em.Object.create({
        service: {},
        componentName: 'COMP1',
        host: {}
      });
      controller.sendRefreshComponentConfigsCommand(component, {});
      var args = testHelpers.findAjaxRequest('name', 'host.host_component.refresh_configs');
      expect(args[0]).exists;
    });
  });

  describe('#loadConfigs()', function () {
    it('Query should be sent', function () {
      controller.loadConfigs();
      var args = testHelpers.findAjaxRequest('name', 'config.tags');
      expect(args).exists;
    });
  });

  describe('#constructConfigUrlParams()', function () {

    function loadService(serviceName) {
      App.store.safeLoad(App.Service, {
        id: serviceName,
        service_name: serviceName
      });
    }

    var data = {
      Clusters: {
        desired_configs: {
          'core-site': {
            tag: 1
          },
          'hbase-site': {
            tag: 1
          },
          'webhcat-site': {
            tag: 1
          },
          'hive-site': {
            tag: 1
          },
          'storm-site': {
            tag: 1
          },
          'yarn-site': {
            tag: 1
          },
          'zoo.cfg': {
            tag: 1
          },
          'accumulo-site': {
            tag: 1
          },
          'application-properties': {
            tag: 1
          }
        }
      }
    };

    afterEach(function () {
      App.Service.find().clear();
    });

    it('URL params should be empty', function () {
      App.Service.find().clear();
      expect(controller.constructConfigUrlParams(data)).to.eql([]);
    });

    it('isHaEnabled = true', function () {
      loadService('HDFS');

      App.HostComponent.find().clear();
      App.propertyDidChange('isHaEnabled');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=core-site&tag=1)']);
      App.store.safeLoad(App.HostComponent, {
        id: 'SECONDARY_NAMENODE_host1',
        component_name: 'SECONDARY_NAMENODE'
      });
    });

    it('HBASE is installed', function () {
      loadService('HBASE');
      App.propertyDidChange('isHaEnabled');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=hbase-site&tag=1)']);
    });

    it('HIVE is installed', function () {
      loadService('HIVE');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=hive-site&tag=1)', '(type=webhcat-site&tag=1)']);
    });

    it('STORM is installed', function () {
      loadService('STORM');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=storm-site&tag=1)']);
    });

    it('YARN is installed', function () {
      loadService('YARN');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=yarn-site&tag=1)', '(type=zoo.cfg&tag=1)']);
    });

    it('ACCUMULO is installed', function () {
      loadService('ACCUMULO');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=accumulo-site&tag=1)']);
    });

    it('ATLAS is installed, AMBARI_INFRA isn\'t installed', function () {
      loadService('ATLAS');
      expect(controller.constructConfigUrlParams(data)).to.eql(['(type=application-properties&tag=1)']);
    });
  });

  describe('#loadConfigsSuccessCallback()', function () {
    var mockUrlParams = [];
    beforeEach(function () {
      sinon.stub(controller, "constructConfigUrlParams", function () {
        return mockUrlParams;
      });
    });
    afterEach(function () {
      controller.constructConfigUrlParams.restore();
    });

    it('url params is empty', function () {
      expect(controller.loadConfigsSuccessCallback(null, null, {})).to.be.false;
      var args = testHelpers.findAjaxRequest('name', 'reassign.load_configs');
      expect(args).not.exists;
    });
    it('url params are correct', function () {
      mockUrlParams = ['param1'];
      var args = testHelpers.findAjaxRequest('name', 'reassign.load_configs');
      expect(args).exists;
    });
    it('isConfigsLoadingInProgress is false', function () {
      mockUrlParams = [];
      controller.set('isConfigsLoadingInProgress', true);
      controller.loadConfigsSuccessCallback(null, null, {});
      expect(controller.get('isConfigsLoadingInProgress')).to.be.false;
    });
  });

  describe('#saveZkConfigs()', function () {

    var data = {
      items: [
        {
          type: 'yarn-site',
          properties: {
            p: 'ys'
          },
          properties_attributes: {
            p: 'pa_ys'
          }
        },
        {
          type: 'hive-site',
          properties: {
            hs: 'hs'
          },
          properties_attributes: {
            hs: 'pa_hs'
          }
        },
        {
          type: 'webhcat-site',
          properties: {
            ws: 'ws'
          },
          properties_attributes: {
            ws: 'pa_ws'
          }
        },
        {
          type: 'hbase-site',
          properties: {
            hbs: 'hbs'
          },
          properties_attributes: {
            hbs: 'pa_hbs'
          }
        },
        {
          type: 'accumulo-site',
          properties: {
            as: 'as'
          },
          properties_attributes: {
            as: 'pa_as'
          }
        }
      ]
    };

    beforeEach(function () {
      sinon.stub(controller, 'saveConfigsBatch', Em.K);
      sinon.stub(controller, 'updateZkConfigs', Em.K);
      sinon.stub(controller, 'saveLoadedConfigs', Em.K);
      sinon.stub(App.Service, 'find', function() {
        return [
          Em.Object.create({ serviceName: 'HIVE' }),
          Em.Object.create({ serviceName: 'YARN' }),
          Em.Object.create({ serviceName: 'HBASE' }),
          Em.Object.create({ serviceName: 'ACCUMULO' })
        ];
      });

      controller.saveZkConfigs(data);
      this.groups = controller.saveConfigsBatch.args[0][0];
    });
    afterEach(function () {
      App.Service.find.restore();
      controller.updateZkConfigs.restore();
      controller.saveConfigsBatch.restore();
      controller.saveLoadedConfigs.restore();
    });

    it('configs for YARN', function () {
      var expected = {
        properties: {
          'yarn-site': {
            p: 'ys'
          }
        },
        properties_attributes: {
          'yarn-site': {
            p: 'pa_ys'
          }
        }
      };
      expect(this.groups[1]).to.be.eql(expected);
    });

    it('configs for HIVE', function () {
      var expected = {
        "properties": {
          "hive-site": {
            "hs": "hs"
          },
          "webhcat-site": {
            "ws": "ws"
          }
        },
        "properties_attributes": {
          "hive-site": {
            "hs": "pa_hs"
          },
          "webhcat-site": {
            "ws": "pa_ws"
          }
        }
      };
      expect(this.groups[0]).to.be.eql(expected);
    });

    it('configs for HBASE', function () {
      var expected = {
        "properties": {
          "hbase-site": {
            "hbs": "hbs"
          }
        },
        "properties_attributes": {
          "hbase-site": {
            "hbs": "pa_hbs"
          }
        }
      };
      expect(this.groups[2]).to.be.eql(expected);
    });

    it('configs for ACCUMULO', function () {
      var expected = {
        "properties": {
          "accumulo-site": {
            "as": "as"
          }
        },
        "properties_attributes": {
          "accumulo-site": {
            "as": "pa_as"
          }
        }
      };
      expect(this.groups[3]).to.be.eql(expected);
    });

  });

  describe("#saveConfigsBatch()", function () {
    it("no groups", function () {
      controller.saveConfigsBatch([]);
      var args = testHelpers.filterAjaxRequests('name', 'common.service.configurations');
      expect(args).to.be.empty;
    });
    it("configs is empty", function () {
      controller.saveConfigsBatch([{}]);
      var args = testHelpers.filterAjaxRequests('name', 'common.service.configurations');
      expect(args).to.be.empty;
    });
    it("configs is correct", function () {
      controller.saveConfigsBatch([{'properties': {'site': {}}, 'properties_attributes': {'site': {}}}]);
      var args = testHelpers.filterAjaxRequests('name', 'common.service.configurations');
      expect(args).to.have.property('length').equal(1);
    });
  });

  describe('#updateZkConfigs()', function () {
    var makeHostComponentModel = function(componentName, hostNames) {
      return hostNames.map(function(hostName) {
        return {
          componentName: componentName,
          hostName: hostName
        };
      });
    };

    var tests = [
      {
        appGetterStubs: {
          isHaEnabled: true
        },
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "core-site": {
            "ha.zookeeper.quorum": "host2:8080"
          }
        },
        m: 'NameNode HA enabled, ha.zookeeper.quorum config should be updated',
        e: {
          configs: {
            "core-site": {
              "ha.zookeeper.quorum": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        appGetterStubs: {
          isHaEnabled: false
        },
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "core-site": {
            "ha.zookeeper.quorum": "host3:8080"
          }
        },
        m: 'NameNode HA disabled, ha.zookeeper.quorum config should be untouched',
        e: {
          configs: {
            "core-site": {
              "ha.zookeeper.quorum": "host3:8080"
            }
          }
        }
      },
      {
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "hbase-site": {
            "hbase.zookeeper.quorum": "host3"
          }
        },
        m: 'hbase.zookeeper.quorum property update test',
        e: {
          configs: {
            "hbase-site": {
              "hbase.zookeeper.quorum": "host1,host2"
            }
          }
        }
      },
      {
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        ctrlStubs: {
          'content.hostName': 'host2',
          fromDeleteHost: true
        },
        configs: {
          "zoo.cfg": {
            "clientPort": "1919"
          },
          "accumulo-site": {
            "instance.zookeeper.host": "host3:2020"
          }
        },
        m: 'instance.zookeeper.host property update test, zookeper marked to delete from host2',
        e: {
          configs: {
            "zoo.cfg": {
              "clientPort": "1919"
            },
            "accumulo-site": {
              "instance.zookeeper.host": "host1:1919"
            }
          }
        }
      },
      {
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "webhcat-site": {
            "templeton.zookeeper.hosts": "host3:2020"
          }
        },
        m: 'templeton.zookeeper.hosts property update test',
        e: {
          configs: {
            "webhcat-site": {
              "templeton.zookeeper.hosts": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "hive-site": {
            "hive.cluster.delegation.token.store.zookeeper.connectString": "host3:2020"
          }
        },
        m: 'hive.cluster.delegation.token.store.zookeeper.connectString property update test',
        e: {
          configs: {
            "hive-site": {
              "hive.cluster.delegation.token.store.zookeeper.connectString": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "storm-site": {
            "storm.zookeeper.servers": "['host3','host2']"
          }
        },
        m: 'storm.zookeeper.servers property update test',
        e: {
          configs: {
            "storm-site": {
              "storm.zookeeper.servers": "['host1','host2']"
            }
          }
        }
      },
      {
        appGetterStubs: {
          isRMHaEnabled: true
        },
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "yarn-site": {
            "yarn.resourcemanager.zk-address": "host3:2181"
          }
        },
        m: 'yarn.resourcemanager.zk-address property, ResourceManager HA enabled. Property value should be changed.',
        e: {
          configs: {
            "yarn-site": {
              "yarn.resourcemanager.zk-address": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        appGetterStubs: {
          currentStackVersionNumber: '2.2'
        },
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "hive-site": {
            "hive.zookeeper.quorum": "host3:2181"
          }
        },
        m: 'hive.zookeeper.quorum property, current stack version is 2.2 property should be updated.',
        e: {
          configs: {
            "hive-site": {
              "hive.zookeeper.quorum": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        appGetterStubs: {
          currentStackVersionNumber: '2.2'
        },
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          "yarn-site": {
            "hadoop.registry.zk.quorum": "host3:2181"
          }
        },
        m: 'hadoop.registry.zk.quorum property, current stack version is 2.2 property should be changed.',
        e: {
          configs: {
            "yarn-site": {
              "hadoop.registry.zk.quorum": "host1:2181,host2:2181"
            }
          }
        }
      },
      {
        m: 'ATLAS configs',
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          'application-properties': {
            'atlas.audit.hbase.zookeeper.quorum': '',
            'atlas.graph.index.search.solr.zookeeper-url': '',
            'atlas.graph.storage.hostname': '',
            'atlas.kafka.zookeeper.connect': ''
          }
        },
        e: {
          configs: {
            'application-properties': {
              'atlas.audit.hbase.zookeeper.quorum': 'host1,host2',
              'atlas.graph.index.search.solr.zookeeper-url': 'host1:2181/ambari-solr,host2:2181/ambari-solr',
              'atlas.graph.storage.hostname': 'host1,host2',
              'atlas.kafka.zookeeper.connect': 'host1:2181,host2:2181'
            }
          }
        }
      },
      {
        m: 'ATLAS configs with custom solr',
        hostComponentModel: makeHostComponentModel('ZOOKEEPER_SERVER', ['host1', 'host2']),
        configs: {
          'infra-solr-env': {
            'infra_solr_znode': '/custom-solr'
          },
          'application-properties': {
            'atlas.audit.hbase.zookeeper.quorum': '',
            'atlas.graph.index.search.solr.zookeeper-url': '',
            'atlas.graph.storage.hostname': '',
            'atlas.kafka.zookeeper.connect': ''
          }
        },
        e: {
          configs: {
            'infra-solr-env': {
              'infra_solr_znode': '/custom-solr'
            },
            'application-properties': {
              'atlas.audit.hbase.zookeeper.quorum': 'host1,host2',
              'atlas.graph.index.search.solr.zookeeper-url': 'host1:2181/custom-solr,host2:2181/custom-solr',
              'atlas.graph.storage.hostname': 'host1,host2',
              'atlas.kafka.zookeeper.connect': 'host1:2181,host2:2181'
            }
          }
        }
      }
    ];

    tests.forEach(function(test) {
      describe(test.m, function() {

        beforeEach(function() {
          if (test.appGetterStubs) {
            Em.keys(test.appGetterStubs).forEach(function(key) {
              sinon.stub(App, 'get').withArgs(key).returns(test.appGetterStubs[key]);
            });
          }
          if (test.ctrlStubs) {
            var stub = sinon.stub(controller, 'get');
            Em.keys(test.ctrlStubs).forEach(function(key) {
              stub.withArgs(key).returns(test.ctrlStubs[key]);
            });
          }
          sinon.stub(App.HostComponent, 'find').returns(test.hostComponentModel);
          controller.updateZkConfigs(test.configs);
        });

        afterEach(function () {
          if (test.ctrlStubs) {
            controller.get.restore();
          }
          if (test.appGetterStubs) {
            App.get.restore();
          }
          App.HostComponent.find.restore();
        });

        it('configs are mapped correctly', function () {
          expect(test.configs).to.be.eql(test.e.configs);
        });

      });
    });
  });

  describe('#installComponent()', function () {

    beforeEach(function () {
      sinon.spy(App.ModalPopup, "show");
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it('popup should be displayed', function () {
      var event = {context: Em.Object.create()};
      var popup = controller.installComponent(event);
      expect(App.ModalPopup.show.calledOnce).to.be.true;
      popup.onPrimary();
      var args = testHelpers.findAjaxRequest('name', 'common.host.host_component.update');
      expect(args).exists;
    });
  });

  describe('#decommission()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, "runDecommission", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.runDecommission.restore();
    });

    it('popup should be displayed', function () {
      var popup = controller.decommission(Em.Object.create({service: {}}));
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.runDecommission.calledOnce).to.be.true;
    });
  });

  describe('#recommission()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, "runRecommission", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.runRecommission.restore();
    });

    it('popup should be displayed', function () {
      var popup = controller.recommission(Em.Object.create({service: {}}));
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.runRecommission.calledOnce).to.be.true;
    });
  });

  describe('#runDecommission()', function () {

    beforeEach(function () {
      sinon.stub(controller, "doDecommission", Em.K);
      sinon.stub(controller, "showBackgroundOperationsPopup", Em.K);
    });

    afterEach(function () {
      controller.doDecommission.restore();
      controller.showBackgroundOperationsPopup.restore();
    });

    it('HDFS service', function () {
      controller.runDecommission('host1', 'HDFS');
      expect(controller.doDecommission.calledWith('host1', 'HDFS', "NAMENODE", "DATANODE")).to.be.true;
    });
    it('YARN service', function () {
      controller.runDecommission('host1', 'YARN');
      expect(controller.doDecommission.calledWith('host1', 'YARN', "RESOURCEMANAGER", "NODEMANAGER")).to.be.true;
    });

    describe('HBASE service', function () {

      beforeEach(function () {
        sinon.stub(controller, 'warnBeforeDecommission', Em.K);
      });

      afterEach(function () {
        controller.warnBeforeDecommission.restore();
      });
      it('warnBeforeDecommission is called with valid arguments', function () {
        controller.runDecommission('host1', 'HBASE');
        expect(controller.warnBeforeDecommission.calledWith('host1')).to.be.true;
      });

    });

  });

  describe('#runRecommission()', function () {

    beforeEach(function () {
      sinon.stub(controller, "doRecommissionAndStart", Em.K);
      sinon.stub(controller, "showBackgroundOperationsPopup", Em.K);
    });

    afterEach(function () {
      controller.doRecommissionAndStart.restore();
      controller.showBackgroundOperationsPopup.restore();
    });

    it('HDFS service', function () {
      controller.runRecommission('host1', 'HDFS');
      expect(controller.doRecommissionAndStart.calledWith('host1', 'HDFS', "NAMENODE", "DATANODE")).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
    it('YARN service', function () {
      controller.runRecommission('host1', 'YARN');
      expect(controller.doRecommissionAndStart.calledWith('host1', 'YARN', "RESOURCEMANAGER", "NODEMANAGER")).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
    it('HBASE service', function () {
      controller.runRecommission('host1', 'HBASE');
      expect(controller.doRecommissionAndStart.calledWith('host1', 'HBASE', "HBASE_MASTER", "HBASE_REGIONSERVER")).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#doDecommission()', function () {
    it('Query should be sent', function () {
      controller.doDecommission('', '', '', '');
      var args = testHelpers.findAjaxRequest('name', 'host.host_component.decommission_slave');
      expect(args).exists;
    });
  });

  describe('#doDecommissionRegionServer()', function () {
    it('Query should be sent', function () {
      controller.doDecommissionRegionServer('', '', '', '');
      var args = testHelpers.findAjaxRequest('name', 'host.host_component.recommission_and_restart');
      expect(args).exists;
    });
  });

  describe('#warnBeforeDecommission()', function () {
    beforeEach(function () {
      sinon.stub(controller, "showHbaseActiveWarning", Em.K);
      sinon.stub(controller, "checkRegionServerState", Em.K);
    });
    afterEach(function () {
      controller.checkRegionServerState.restore();
      controller.showHbaseActiveWarning.restore();
    });

    it('Component in passive state', function () {
      controller.set('content.hostComponents', [Em.Object.create({
        componentName: 'HBASE_REGIONSERVER',
        passiveState: 'ON'
      })]);
      controller.warnBeforeDecommission('host1');
      expect(controller.checkRegionServerState.calledOnce).to.be.true;
    });
    it('Component is not in passive state', function () {
      controller.set('content.hostComponents', [Em.Object.create({
        componentName: 'HBASE_REGIONSERVER',
        passiveState: 'OFF'
      })]);
      controller.warnBeforeDecommission('host1');
      expect(controller.showHbaseActiveWarning.calledOnce).to.be.true;
    });
  });

  describe('#checkRegionServerState()', function () {
    var result;
    beforeEach(function () {
      result = controller.checkRegionServerState('host1');
    });
    it('returns object', function () {
      expect(result).to.be.an('object');
    });
    it('request is sent with correct data', function () {
      var args = testHelpers.findAjaxRequest('name', 'host.region_servers.in_inservice');
      expect(args[0]).exists;
      expect(args[0].data.hostNames).to.be.equal('host1');
    });
  });

  describe('#checkRegionServerStateSuccessCallback()', function () {
    beforeEach(function () {
      sinon.stub(controller, "doDecommissionRegionServer", Em.K);
      sinon.stub(controller, "showRegionServerWarning", Em.K);
    });
    afterEach(function () {
      controller.doDecommissionRegionServer.restore();
      controller.showRegionServerWarning.restore();
    });

    it('Decommission all regionservers', function () {
      var data = {
        items: [
          {
            HostRoles: {
              host_name: 'host1'
            }
          },
          {
            HostRoles: {
              host_name: 'host2'
            }
          }
        ]
      };
      controller.checkRegionServerStateSuccessCallback(data, {}, {hostNames: 'host1,host2'});
      expect(controller.showRegionServerWarning.calledOnce).to.be.true;
    });
    it('Decommission one of two regionservers', function () {
      var data = {
        items: [
          {
            HostRoles: {
              host_name: 'host1'
            }
          },
          {
            HostRoles: {
              host_name: 'host2'
            }
          }
        ]
      };
      controller.checkRegionServerStateSuccessCallback(data, {}, {hostNames: 'host1'});
      expect(controller.doDecommissionRegionServer.calledWith('host1', "HBASE", "HBASE_MASTER", "HBASE_REGIONSERVER")).to.be.true;
    });
    it('Decommission one of three regionservers', function () {
      var data = {
        items: [
          {
            HostRoles: {
              host_name: 'host1'
            }
          },
          {
            HostRoles: {
              host_name: 'host2'
            }
          },
          {
            HostRoles: {
              host_name: 'host3'
            }
          }
        ]
      };
      controller.checkRegionServerStateSuccessCallback(data, {}, {hostNames: 'host1'});
      expect(controller.doDecommissionRegionServer.calledWith('host1', "HBASE", "HBASE_MASTER", "HBASE_REGIONSERVER")).to.be.true;
    });
  });

  describe('#showRegionServerWarning()', function () {
    beforeEach(function () {
      sinon.stub(App.ModalPopup, 'show', Em.K);
    });
    afterEach(function () {
      App.ModalPopup.show.restore();
    });
    it('modal popup is shown', function () {
      controller.showRegionServerWarning();
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe('#doRecommissionAndStart()', function () {
    it('Query should be sent', function () {
      controller.doRecommissionAndStart('', '', '', '');
      var args = testHelpers.findAjaxRequest('name', 'host.host_component.recommission_and_restart');
      expect(args).exists;
    });
  });

  describe('#decommissionSuccessCallback()', function () {

    beforeEach(function () {
      sinon.stub(controller, "showBackgroundOperationsPopup", Em.K);
    });
    afterEach(function () {
      controller.showBackgroundOperationsPopup.restore();
    });

    it('data is null', function () {
      expect(controller.decommissionSuccessCallback(null)).to.be.false;
      expect(controller.showBackgroundOperationsPopup.called).to.be.false;
    });
    it('data has Requests', function () {
      var data = {Requests: []};
      expect(controller.decommissionSuccessCallback(data)).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
    it('data has resources', function () {
      var data = {
        resources: [
          {RequestSchedule: {}}
        ]
      };
      expect(controller.decommissionSuccessCallback(data)).to.be.true;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#doAction()', function () {

    beforeEach(function () {
      sinon.stub(controller, "validateAndDeleteHost", Em.K);
      sinon.stub(controller, "doStartAllComponents", Em.K);
      sinon.stub(controller, "doStopAllComponents", Em.K);
      sinon.stub(controller, "doRestartAllComponents", Em.K);
      sinon.stub(controller, "onOffPassiveModeForHost", Em.K);
      sinon.stub(controller, "setRackIdForHost", Em.K);
    });

    afterEach(function () {
      controller.validateAndDeleteHost.restore();
      controller.doStartAllComponents.restore();
      controller.doStopAllComponents.restore();
      controller.doRestartAllComponents.restore();
      controller.onOffPassiveModeForHost.restore();
      controller.setRackIdForHost.restore();
    });

    it('"deleteHost" action', function () {
      var option = {context: {action: "deleteHost"}};
      controller.doAction(option);
      expect(controller.validateAndDeleteHost.calledOnce).to.be.true;
    });

    it('"startAllComponents" action, isNotHeartBeating = false', function () {
      var option = {context: {action: "startAllComponents"}};
      controller.set('content', {isNotHeartBeating: false});
      controller.doAction(option);
      expect(controller.doStartAllComponents.calledOnce).to.be.true;
    });

    it('"startAllComponents" action, isNotHeartBeating = true', function () {
      var option = {context: {action: "startAllComponents"}};
      controller.set('content', {isNotHeartBeating: true});
      controller.doAction(option);
      expect(controller.doStartAllComponents.called).to.be.false;
    });

    it('"stopAllComponents" action, isNotHeartBeating = false', function () {
      var option = {context: {action: "stopAllComponents"}};
      controller.set('content', {isNotHeartBeating: false});
      controller.doAction(option);
      expect(controller.doStopAllComponents.calledOnce).to.be.true;
    });

    it('"stopAllComponents" action, isNotHeartBeating = true', function () {
      var option = {context: {action: "stopAllComponents"}};
      controller.set('content', {isNotHeartBeating: true});
      controller.doAction(option);
      expect(controller.doStopAllComponents.called).to.be.false;
    });

    it('"restartAllComponents" action, isNotHeartBeating = false', function () {
      var option = {context: {action: "restartAllComponents"}};
      controller.set('content', {isNotHeartBeating: false});
      controller.doAction(option);
      expect(controller.doRestartAllComponents.calledOnce).to.be.true;
    });

    it('"restartAllComponents" action, isNotHeartBeating = true', function () {
      var option = {context: {action: "restartAllComponents"}};
      controller.set('content', {isNotHeartBeating: true});
      controller.doAction(option);
      expect(controller.doRestartAllComponents.called).to.be.false;
    });

    it('"onOffPassiveModeForHost" action', function () {
      var option = {context: {action: "onOffPassiveModeForHost"}};
      controller.doAction(option);
      expect(controller.onOffPassiveModeForHost.calledWith({action: "onOffPassiveModeForHost"})).to.be.true;
    });

    it('"setRackId" action', function () {
      var option = {context: {action: "setRackId"}};
      controller.doAction(option);
      expect(controller.setRackIdForHost.calledOnce).to.be.true;
    });
  });

  describe("#setRackIdForHost()", function() {
    beforeEach(function(){
      sinon.stub(hostsManagement, 'setRackInfo', Em.K);
    });
    afterEach(function() {
      hostsManagement.setRackInfo.restore();
    });
    it('setRackInfo called with valid arguments', function() {
      controller.set('content.rack', 'rack');
      controller.set('content.hostName', 'host1');
      controller.setRackIdForHost();
      expect(hostsManagement.setRackInfo.calledWith({message: Em.I18n.t('hosts.host.details.setRackId')}, [{hostName: 'host1'}], 'rack')).to.be.true;
    });
  });

  describe('#onOffPassiveModeForHost()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, "hostPassiveModeRequest", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.hostPassiveModeRequest.restore();
    });

    it('popup should be displayed, active = true', function () {
      var popup = controller.onOffPassiveModeForHost({active: true});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.hostPassiveModeRequest.calledWith('ON')).to.be.true;
    });
    it('popup should be displayed, active = false', function () {
      var popup = controller.onOffPassiveModeForHost({active: false});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.hostPassiveModeRequest.calledWith('OFF')).to.be.true;
    });
  });

  describe('#hostPassiveModeRequest()', function () {
    it('Query should be sent', function () {
      controller.hostPassiveModeRequest('', '');
      var args = testHelpers.findAjaxRequest('name', 'bulk_request.hosts.passive_state');
      expect(args).exists;
    });
  });

  describe('#doStartAllComponents()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, 'sendComponentCommand', Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.sendComponentCommand.restore();
    });

    it('serviceNonClientActiveComponents is empty', function () {
      controller.reopen({
        serviceNonClientActiveComponents: Em.A([])
      });
      controller.doStartAllComponents();
      expect(App.showConfirmationPopup.called).to.be.false;
    });
    it('serviceNonClientActiveComponents is correct', function () {
      controller.reopen({
        serviceNonClientActiveComponents: Em.A([{}])
      });
      var popup = controller.doStartAllComponents();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.sendComponentCommand.calledWith(
        controller.get('serviceNonClientActiveComponents'),
        Em.I18n.t('hosts.host.maintainance.startAllComponents.context'),
        App.HostComponentStatus.started)
      ).to.be.true;
    });
  });

  describe('#doStopAllComponents()', function () {
    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, 'sendComponentCommand', Em.K);
      sinon.stub(controller, 'checkNnLastCheckpointTime', function(callback){
        callback();
      });
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.sendComponentCommand.restore();
      controller.checkNnLastCheckpointTime.restore();
    });

    it('serviceNonClientActiveComponents is empty', function () {
      controller.reopen({
        serviceNonClientActiveComponents: []
      });
      controller.doStopAllComponents();
      expect(App.showConfirmationPopup.called).to.be.false;
    });

    it('serviceNonClientActiveComponents is correct', function () {
      controller.reopen({
        serviceNonClientActiveComponents: Em.A([{}])
      });

      var popup = controller.doStopAllComponents();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.sendComponentCommand.calledWith(
        controller.get('serviceNonClientActiveComponents'),
        Em.I18n.t('hosts.host.maintainance.stopAllComponents.context'),
        App.HostComponentStatus.stopped)
      ).to.be.true;
    });
    it('serviceNonClientActiveComponents is correct, NAMENODE started', function () {
      controller.reopen({
        serviceNonClientActiveComponents: Em.A([Em.Object.create({
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        })])
      });
      controller.set('content.hostComponents', [Em.Object.create({
        componentName: 'NAMENODE',
        workStatus: 'STARTED'
      })]);
      controller.doStopAllComponents();
      expect(controller.checkNnLastCheckpointTime.calledOnce).to.be.true;
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
    });
  });

  describe('#doRestartAllComponents()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(batchUtils, 'restartHostComponents', Em.K);
      sinon.stub(controller, 'checkNnLastCheckpointTime', function(callback){
        callback();
      });
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      batchUtils.restartHostComponents.restore();
      controller.checkNnLastCheckpointTime.restore();
    });

    it('serviceActiveComponents is empty', function () {
      controller.reopen({
        serviceActiveComponents: []
      });
      controller.doRestartAllComponents();
      expect(App.showConfirmationPopup.called).to.be.false;
    });

    it('serviceActiveComponents is correct', function () {
      var components = [{}];
      controller.reopen({
        serviceActiveComponents: components
      });

      var popup = controller.doRestartAllComponents();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(batchUtils.restartHostComponents.calledWith(components)).to.be.true;
    });
    it('serviceActiveComponents is correct, NAMENODE started', function () {
      controller.reopen({
        serviceActiveComponents: Em.A([Em.Object.create({
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        })])
      });
      controller.set('content.hostComponents', [Em.Object.create({
        componentName: 'NAMENODE',
        workStatus: 'STARTED'
      })]);
      controller.doRestartAllComponents();
      expect(controller.checkNnLastCheckpointTime.calledOnce).to.be.true;
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
    });
  });

  describe('#getHostComponentsInfo()', function () {

    var result = {
      zkServerInstalled: false,
      lastComponents: [],
      masterComponents: [],
      nonAddableMasterComponents: [],
      lastMasterComponents: [],
      runningComponents: [],
      nonDeletableComponents: [],
      unknownComponents: [],
      toDecommissionComponents: []
    };

    beforeEach(function () {
      this.stub = sinon.stub(App.HostComponent, 'find').returns([{
        id: 'TASKTRACKER_host1',
        componentName: 'TASKTRACKER'
      }]);
      this.mockTotal = sinon.stub(controller, 'getTotalComponent');
      this.mockTotal.returns(2);
    });

    afterEach(function () {
      this.stub.restore();
      this.mockTotal.restore();
    });

    it('content.hostComponents is null', function () {
      controller.set('content', {hostComponents: null});
      expect(controller.getHostComponentsInfo()).to.eql(result);
    });

    it('content.hostComponents is empty', function () {
      controller.set('content', {hostComponents: []});
      expect(controller.getHostComponentsInfo()).to.eql(result);
    });

    it('content.hostComponents has ZOOKEEPER_SERVER', function () {
      App.HostComponent.find().clear();
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'ZOOKEEPER_SERVER',
          workStatus: 'INIT',
          isDeletable: true
        })]
      });
      expect(controller.getHostComponentsInfo().zkServerInstalled).to.be.true;
    });

    it('content.hostComponents has last component', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'TASKTRACKER',
          displayName: 'TaskTracker',
          workStatus: 'INIT',
          isDeletable: true
        })]
      });
      this.mockTotal.returns(1);
      expect(controller.getHostComponentsInfo().lastComponents).to.eql(['TaskTracker']);
    });

    it('content.hostComponents has master non-deletable component', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'TASKTRACKER',
          workStatus: 'INIT',
          isDeletable: false,
          isMaster: true,
          displayName: 'ZK1'
        })]
      });
      expect(controller.getHostComponentsInfo().masterComponents).to.eql(['ZK1']);
      expect(controller.getHostComponentsInfo().nonDeletableComponents).to.eql(['ZK1']);
    });

    it('content.hostComponents has running component', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'TASKTRACKER',
          workStatus: 'STARTED',
          isDeletable: true,
          displayName: 'ZK1'
        })]
      });
      expect(controller.getHostComponentsInfo().runningComponents).to.eql(['ZK1']);
    });

    it('content.hostComponents has non-deletable component', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'TASKTRACKER',
          workStatus: 'INIT',
          isDeletable: false,
          displayName: 'ZK1'
        })]
      });
      expect(controller.getHostComponentsInfo().nonDeletableComponents).to.eql(['ZK1']);
    });

    it('content.hostComponents has component with UNKNOWN state', function () {
      controller.set('content', {
        hostComponents: [Em.Object.create({
          componentName: 'TASKTRACKER',
          workStatus: 'UNKNOWN',
          isDeletable: false,
          displayName: 'ZK1'
        })]
      });
      expect(controller.getHostComponentsInfo().unknownComponents).to.eql(['ZK1']);
    });

  });

  describe('#validateAndDeleteHost()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, "getHostComponentsInfo", function () {
        return this.get('mockHostComponentsInfo');
      });
      sinon.stub(controller, "raiseDeleteComponentsError", Em.K);
      sinon.stub(controller, "confirmDeleteHost", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.getHostComponentsInfo.restore();
      controller.raiseDeleteComponentsError.restore();
      controller.confirmDeleteHost.restore();
    });

    it('nonDeletableComponents exist', function () {
      controller.set('mockHostComponentsInfo', {
        nonDeletableComponents: [
          {}
        ]
      });
      controller.validateAndDeleteHost();
      expect(controller.raiseDeleteComponentsError.calledWith({
        nonDeletableComponents: [
          {}
        ]
      }, 'nonDeletableList')).to.be.true;
    });
    it('nonAddableMasterComponents exist', function () {
      controller.set('mockHostComponentsInfo', {
        nonDeletableComponents: [],
        nonAddableMasterComponents: [
        {}
        ]
      });
      controller.validateAndDeleteHost();
      expect(controller.raiseDeleteComponentsError.calledWith({
        nonDeletableComponents: [],
        nonAddableMasterComponents: [
          {}
        ]
      }, 'masterList')).to.be.true;
    });
    it('runningComponents exist', function () {
      controller.set('mockHostComponentsInfo', {
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [{}]
      });
      controller.validateAndDeleteHost();
      expect(controller.raiseDeleteComponentsError.calledWith({
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [{}]
      }, 'runningList')).to.be.true;
    });
    it('lastMasterComponents exist', function () {
      controller.set('mockHostComponentsInfo', {
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        lastMasterComponents: [{}]
      });
      controller.validateAndDeleteHost();
      expect(controller.raiseDeleteComponentsError.calledWith({
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        lastMasterComponents: [{}]
      }, 'lastMasterList')).to.be.true;
    });
    it('zkServerInstalled = true', function () {
      controller.set('mockHostComponentsInfo', {
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        unknownComponents: [],
        lastComponents: [],
        lastMasterComponents: [],
        zkServerInstalled: true
      });
      var popup = controller.validateAndDeleteHost();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.confirmDeleteHost.calledWith({
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        unknownComponents: [],
        lastComponents: [],
        lastMasterComponents: [],
        zkServerInstalled: true
      })).to.be.true;
    });
    it('zkServerInstalled = false', function () {
      controller.set('mockHostComponentsInfo', {
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        unknownComponents: [],
        lastComponents: [],
        lastMasterComponents: [],
        zkServerInstalled: false
      });
      controller.validateAndDeleteHost();
      expect(controller.confirmDeleteHost.calledWith({
        nonAddableMasterComponents: [],
        nonDeletableComponents: [],
        runningComponents: [],
        unknownComponents: [],
        lastComponents: [],
        lastMasterComponents: [],
        zkServerInstalled: false
      })).to.be.true;
    });
  });

  describe('#raiseDeleteComponentsError()', function () {

    beforeEach(function () {
      sinon.stub(App.ModalPopup, "show", Em.K);
    });
    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it('Popup should be displayed', function () {
      controller.raiseDeleteComponentsError([], '');
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe('#confirmDeleteHost()', function () {

    beforeEach(function () {
      sinon.spy(App.ModalPopup, "show");
      sinon.stub(controller, 'doDeleteHost');
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
      controller.doDeleteHost.restore();
    });

    it('Popup should be displayed', function () {
      var popup = controller.confirmDeleteHost({toDecommissionComponents:[]});
      expect(App.ModalPopup.show.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.doDeleteHost.calledOnce).to.be.true;
    });
  });

  describe('#setRackId', function () {
    beforeEach(function () {
      sinon.stub(hostsManagement, 'setRackInfo', Em.K);

    });
    afterEach(function () {
      hostsManagement.setRackInfo.restore();
    });
    it('should call setRackInfo with appropriate arguments', function () {
      var mockedHost = Em.Object.create({
        rack: 'rackId'
      });
      controller.setRackId({
        context: mockedHost
      });
      expect(hostsManagement.setRackInfo.calledWith({message: Em.I18n.t('hosts.host.details.setRackId')}, [mockedHost], 'rackId')).to.be.true;
    });
  });

  describe('#restartAllStaleConfigComponents()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(batchUtils, "restartHostComponents", Em.K);
      sinon.stub(controller, 'checkNnLastCheckpointTime', function(callback){
        callback();
      });
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      batchUtils.restartHostComponents.restore();
      controller.checkNnLastCheckpointTime.restore();
    });

    it('popup should be displayed', function () {
      controller.set('content', {
        componentsWithStaleConfigs: [
          {}
        ]
      });
      var popup = controller.restartAllStaleConfigComponents();
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(batchUtils.restartHostComponents.calledWith([
        {}
      ])).to.be.true;
    });

    it('popup ro check NameNode checkpoint should be displayed first', function () {
      controller.set('content.componentsWithStaleConfigs', [Em.Object.create({
        componentName: 'NAMENODE',
        workStatus: 'STARTED'
      })]);
      controller.set('content.hostComponents', [Em.Object.create({
        componentName: 'NAMENODE',
        workStatus: 'STARTED'
      })]);
      controller.restartAllStaleConfigComponents();
      expect(controller.checkNnLastCheckpointTime.calledOnce).to.be.true;
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
    });
  });

  describe.skip('#moveComponent()', function () {

    var jQueryMock,
      mock = {
        saveComponentToReassign: Em.K,
        getSecurityStatus: Em.K,
        setCurrentStep: Em.K
      },
      cases = [
        {
          isDisabled: false,
          showConfirmationPopupCallCount: 1,
          title: 'popup should be displayed'
        },
        {
          isDisabled: true,
          showConfirmationPopupCallCount: 0,
          title: 'popup shouldn\'t be displayed'
        }
      ];

    beforeEach(function () {
      jQueryMock = sinon.stub(window, '$');
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(App.router, 'get').withArgs('reassignMasterController').returns(mock);
      sinon.stub(App.router, 'transitionTo', Em.K);
      sinon.spy(mock, "saveComponentToReassign");
      sinon.spy(mock, "getSecurityStatus");
      sinon.spy(mock, "setCurrentStep");
    });

    afterEach(function () {
      window.$.restore();
      App.showConfirmationPopup.restore();
      App.router.get.restore();
      App.router.transitionTo.restore();
      mock.saveComponentToReassign.restore();
      mock.getSecurityStatus.restore();
      mock.setCurrentStep.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        jQueryMock.returns({
          closest: function () {
            return {
              hasClass: function () {
                return item.isDisabled;
              }
            }
          }
        });
        var popup = controller.moveComponent({context: {}});
        expect(App.showConfirmationPopup.callCount).to.equal(item.showConfirmationPopupCallCount);
        if (item.showConfirmationPopupCallCount) {
          popup.onPrimary();
          expect(App.router.get.calledWith('reassignMasterController')).to.be.true;
          expect(mock.saveComponentToReassign.calledWith({})).to.be.true;
          expect(mock.getSecurityStatus.calledOnce).to.be.true;
          expect(mock.setCurrentStep.calledWith('1')).to.be.true;
          expect(App.router.transitionTo.calledWith('reassign')).to.be.true;
        }
      });
    });

  });

  describe('#refreshConfigs()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(batchUtils, "restartHostComponents", Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      batchUtils.restartHostComponents.restore();
    });

    it('No components', function () {
      var event = {context: Em.A([])};
      controller.refreshConfigs(event);
      expect(App.showConfirmationPopup.called).to.be.false;
    });
    it('Some components present', function () {
      var event = {context: Em.A([Em.Object.create()])};
      var popup = controller.refreshConfigs(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(batchUtils.restartHostComponents.calledWith(event.context)).to.be.true;
    });
  });

  describe('#getTotalComponent()', function () {

    beforeEach(function () {
      sinon.stub(App.SlaveComponent, 'find', function () {
        return Em.Object.create({
          componentName: "SLAVE",
          totalCount: 1
        });
      });
      sinon.stub(App.ClientComponent, 'find', function () {
        return Em.Object.create({
          componentName: "CLIENT",
          totalCount: 1
        });
      });
      sinon.stub(App.HostComponent, 'find', function () {
        return [Em.Object.create({
          componentName: "MASTER",
          totalCount: 1
        })]
      });
    });
    afterEach(function () {
      App.SlaveComponent.find.restore();
      App.ClientComponent.find.restore();
      App.HostComponent.find.restore();
    });

    it('component is slave', function () {
      expect(controller.getTotalComponent(Em.Object.create({
        componentName: "SLAVE",
        isSlave: true
      }))).to.equal(1);
    });
    it('component is client', function () {
      expect(controller.getTotalComponent(Em.Object.create({
        componentName: "CLIENT",
        isClient: true
      }))).to.equal(1);
    });
    it('component is master', function () {
      expect(controller.getTotalComponent(Em.Object.create({
        componentName: "MASTER"
      }))).to.equal(1);
    });
    it('unknown component', function () {
      expect(controller.getTotalComponent(Em.Object.create({
        componentName: "UNKNOWN"
      }))).to.equal(0);
    });
  });

  describe('#downloadClientConfigsCall', function () {

    beforeEach(function () {
      sinon.stub(controller, 'downloadClientConfigsCall', Em.K);
    });
    afterEach(function () {
      controller.downloadClientConfigsCall.restore();
    });

    it('should launch controller.downloadClientConfigsCall method', function () {
      controller.downloadClientConfigs({
        context: Em.Object.create({
          componentName: 'name',
          hostName: 'host1'
        })
      });
      expect(controller.downloadClientConfigsCall.calledWith({
        componentName: 'name',
        hostName: 'host1',
        resourceType: controller.resourceTypeEnum.HOST_COMPONENT
      })).to.be.true;
    });
  });

  describe('#downloadAllClientConfigs', function () {

    beforeEach(function () {
      sinon.stub(controller, 'downloadClientConfigsCall', Em.K);
      sinon.stub(controller, 'get').withArgs('content.hostName').returns('host1');
    });
    afterEach(function () {
      controller.downloadClientConfigsCall.restore();
      controller.get.restore();
    });

    it('should launch controller.downloadClientConfigsCall method', function () {
      controller.downloadAllClientConfigs();
      expect(controller.downloadClientConfigsCall.calledWith({
        hostName: 'host1',
        resourceType: controller.resourceTypeEnum.HOST
      })).to.be.true;
    });
  });

  describe('#executeCustomCommands', function () {
    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
    });

    it('confirm popup should be displayed', function () {
      var popup = controller.executeCustomCommand({context: Em.Object.create()});
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      var args = testHelpers.findAjaxRequest('name', 'service.item.executeCustomCommand');
      expect(args).exists;
    });
  });

  describe('#_doDeleteHostComponent()', function () {
    it('single component', function () {
      controller.set('content.hostName', 'host1');
      var componentName = 'COMP';
      controller._doDeleteHostComponent(componentName);
      var args = testHelpers.findAjaxRequest('name', 'common.delete.host_component');
      expect(args[0]).exists;
      expect(args[0].data).to.be.eql({
        componentName: 'COMP',
        hostName: 'host1'
      });
    });
    it('all components', function () {
      controller.set('content.hostName', 'host1');
      controller._doDeleteHostComponent(null);
      var args = testHelpers.findAjaxRequest('name', 'common.delete.host');
      expect(args[0]).exists;
      expect(args[0].data).to.be.eql({
        componentName: '',
        hostName: 'host1'
      });
    });
  });

  describe('#_doDeleteHostComponentSuccessCallback()', function () {
    var data = {
      componentName: 'COMPONENT',
      hostName: 'h1'
    };

    beforeEach(function () {
      sinon.stub(controller, 'removeHostComponentModel', Em.K);
      controller.set('_deletedHostComponentResult', {});
      controller._doDeleteHostComponentSuccessCallback({}, {}, data);
    });

    afterEach(function () {
      controller.removeHostComponentModel.restore();
    });

    it('should reset `_deletedHostComponentResult`', function () {
      expect(controller.get('_deletedHostComponentResult')).to.be.null;
    });

    it('should call `removeHostComponentModel` with correct params', function () {
      expect(controller.removeHostComponentModel.calledWith('COMPONENT', 'h1')).to.be.true;
    });
  });

  describe('#upgradeComponentSuccessCallback()', function () {
    beforeEach(function () {
      sinon.stub(controller, 'showBackgroundOperationsPopup', Em.K);
      sinon.stub(controller, 'mimicWorkStatusChange', Em.K);
    });
    afterEach(function () {
      controller.mimicWorkStatusChange.restore();
      controller.showBackgroundOperationsPopup.restore();
    });
    it('testMode is false', function () {
      controller.upgradeComponentSuccessCallback({}, {}, {component: "COMP"});
      expect(controller.mimicWorkStatusChange.called).to.be.false;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#refreshComponentConfigsSuccessCallback()', function () {

    beforeEach(function () {
      sinon.stub(controller, 'showBackgroundOperationsPopup', Em.K);
    });

    afterEach(function () {
      controller.showBackgroundOperationsPopup.restore();
    });

    it('call showBackgroundOperationsPopup', function () {
      controller.refreshComponentConfigsSuccessCallback();
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#_doDeleteHostComponentErrorCallback()', function () {
    it('call showBackgroundOperationsPopup', function () {
      controller._doDeleteHostComponentErrorCallback({}, 'textStatus', {}, {url: 'url'});
      expect(controller.get('_deletedHostComponentResult')).to.be.eql({xhr: {}, url: 'url', method: 'DELETE'});
    });
  });

  describe('#installComponentSuccessCallback()', function () {
    beforeEach(function () {
      sinon.stub(controller, 'showBackgroundOperationsPopup', Em.K);
      sinon.stub(controller, 'mimicWorkStatusChange', Em.K);
    });
    afterEach(function () {
      controller.mimicWorkStatusChange.restore();
      controller.showBackgroundOperationsPopup.restore();
    });

    it('testMode is false', function () {
      controller.installComponentSuccessCallback({}, {}, {component: "COMP"});
      expect(controller.mimicWorkStatusChange.called).to.be.false;
      expect(controller.showBackgroundOperationsPopup.calledOnce).to.be.true;
    });
  });

  describe('#showHbaseActiveWarning()', function () {

    beforeEach(function () {
      sinon.spy(App.ModalPopup, "show");
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    it('popup should be displayed', function () {
      controller.showHbaseActiveWarning(Em.Object.create({service: {}}));
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe('#updateHost()', function () {

    beforeEach(function () {
      sinon.stub(batchUtils, "infoPassiveState", Em.K);
    });

    afterEach(function () {
      batchUtils.infoPassiveState.restore();
    });

    it('popup should be displayed', function () {
      controller.updateHost({}, {}, {passive_state: 'state'});
      expect(controller.get('content.passiveState')).to.equal('state');
      expect(batchUtils.infoPassiveState.calledWith('state')).to.be.true;
    });
  });

  describe('#updateComponentPassiveState()', function () {
    it('popup should be displayed', function () {
      controller.set('content.hostName', 'host1');
      var component = Em.Object.create({
        componentName: 'COMP1'
      });
      controller.updateComponentPassiveState(component, 'state', 'message');
      var args = testHelpers.findAjaxRequest('name', 'common.host.host_component.passive');
      expect(args[0]).exists;
      expect(args[0].data).to.be.eql({
        "hostName": "host1",
        "componentName": "COMP1",
        "component": component,
        "passive_state": "state",
        "context": "message"
      });
    });
  });

  describe('#updateHostComponent()', function () {

    var params = {
      component: Em.Object.create(),
      passive_state: 'state'
    };

    beforeEach(function () {
      sinon.stub(batchUtils, "infoPassiveState", Em.K);
    });

    afterEach(function () {
      batchUtils.infoPassiveState.restore();
    });

    it('popup should be displayed', function () {
      controller.updateHostComponent({}, {}, params);
      expect(params.component.get('passiveState')).to.equal('state');
      expect(batchUtils.infoPassiveState.calledWith('state')).to.be.true;
    });
  });

  describe('#toggleMaintenanceMode()', function () {
    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, 'updateComponentPassiveState');
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.updateComponentPassiveState.restore();
    });
    it('passive state is ON', function () {
      var event = {
        context: Em.Object.create({
          passiveState: 'ON'
        })
      };
      var popup = controller.toggleMaintenanceMode(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.updateComponentPassiveState.calledWith(Em.Object.create({
        passiveState: 'ON'
      }), 'OFF')).to.be.true;
    });
    it('passive state is OFF', function () {
      var event = {
        context: Em.Object.create({
          passiveState: 'OFF'
        })
      };
      var popup = controller.toggleMaintenanceMode(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.updateComponentPassiveState.calledWith(Em.Object.create({
        passiveState: 'OFF'
      }), 'ON')).to.be.true;
    });
    it('isImpliedState is true', function () {
      var event = {
        context: Em.Object.create({
          isImpliedState: true
        })
      };
      var result = controller.toggleMaintenanceMode(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.false;
      expect(result).to.be.null;
    });
  });

  describe('#installClients()', function () {

    var cases = [
      {
        context: [
          Em.Object.create({
            componentName: 'c0',
            workStatus: 'INSTALLED'
          }),
          Em.Object.create({
            componentName: 'c1',
            workStatus: 'INIT'
          }),
          Em.Object.create({
            componentName: 'c2',
            workStatus: 'INSTALL_FAILED'
          })
        ],
        dependencies: {
          c0: [],
          c1: [],
          c2: []
        },
        getSecurityTypeCalled: null, //should have same value as getKDCSessionStateCalled, always
        getKDCSessionStateCalled: true,
        sendComponentCommandCalled: true,
        showAlertPopupCalled: false,
        title: 'No clients to add, some clients to install'
      },
      {
        context: [
          Em.Object.create({
            componentName: 'c3',
            displayName: 'c3'
          })
        ],
        dependencies: {
          c3: []
        },
        getSecurityTypeCalled: null, //should have same value as getKDCSessionStateCalled, always
        getKDCSessionStateCalled: true,
        sendComponentCommandCalled: false,
        showAlertPopupCalled: false,
        title: 'No clients to install, some clients to add'
      },
      {
        context: [
          Em.Object.create({
            componentName: 'c4',
            displayName: 'c4'
          })
        ],
        dependencies: {
          c4: ['c5']
        },
        getSecurityTypeCalled: null, //should have same value as getKDCSessionStateCalled, always
        getKDCSessionStateCalled: false,
        sendComponentCommandCalled: false,
        showAlertPopupCalled: true,
        title: 'Clients to add have unresolved dependencies'
      },
      {
        context: [
          Em.Object.create({
            componentName: 'c5',
            displayName: 'c5'
          }),
          Em.Object.create({
            componentName: 'c6',
            displayName: 'c6'
          })
        ],
        dependencies: {
          c5: ['c6'],
          c6: ['c5']
        },
        getSecurityTypeCalled: null, //should have same value as getKDCSessionStateCalled, always
        getKDCSessionStateCalled: true,
        sendComponentCommandCalled: false,
        showAlertPopupCalled: false,
        title: 'Clients to add have mutual dependencies'
      }
    ];

    beforeEach(function () {
      sinon.stub(controller, 'sendComponentCommand', Em.K);
      sinon.stub(controller, 'showAddComponentPopup', Em.K);
      sinon.stub(App.get('router.mainAdminKerberosController'), 'getKDCSessionState', function (arg) {
        return arg();
      });
      sinon.stub(App.get('router.mainAdminKerberosController'), 'getSecurityType', function (arg) {
        return arg();
      });
      sinon.stub(App, 'showAlertPopup', Em.K);
      sinon.stub(App.StackServiceComponent, 'find', function (componentName) {
        return Em.Object.create({
          displayName: componentName
        });
      });
      controller.set('content.hostComponents', []);
    });
    afterEach(function () {
      controller.sendComponentCommand.restore();
      controller.showAddComponentPopup.restore();
      App.get('router.mainAdminKerberosController').getKDCSessionState.restore();
      App.get('router.mainAdminKerberosController').getSecurityType.restore();
      App.showAlertPopup.restore();
      App.StackServiceComponent.find.restore();
      controller.checkComponentDependencies.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(controller, 'checkComponentDependencies', function (componentName) {
            return item.dependencies[componentName];
          });
          controller.installClients(item.context);
        });

        it('getSecurityType is ' + (item.getKDCSessionStateCalled ? '' : 'not') + ' called', function() {
          expect(App.get('router.mainAdminKerberosController').getSecurityType.calledOnce).to.equal(item.getKDCSessionStateCalled);
        });

        it('getKDCSessionState is ' + (item.getKDCSessionStateCalled ? '' : 'not') + ' called', function() {
          expect(App.get('router.mainAdminKerberosController').getKDCSessionState.calledOnce).to.equal(item.getKDCSessionStateCalled);
        });

        it('sendComponentCommand is ' + (item.sendComponentCommandCalled ? '' : 'not') + ' called', function() {
          expect(controller.sendComponentCommand.calledOnce).to.equal(item.sendComponentCommandCalled);
        });

        it('showAlertPopup is ' + (item.showAlertPopupCalled ? '' : 'not') + ' called', function() {
          expect(App.showAlertPopup.calledOnce).to.equal(item.showAlertPopupCalled);
        });

      });
    });
  });

  describe("#executeCustomCommandErrorCallback()", function () {
    beforeEach(function () {
      sinon.stub($, 'parseJSON');
      sinon.spy(App, 'showAlertPopup');
    });
    afterEach(function () {
      App.showAlertPopup.restore();
      $.parseJSON.restore();
    });
    it("data empty", function () {
      controller.executeCustomCommandErrorCallback(null);

      expect(App.showAlertPopup.calledWith(Em.I18n.t('services.service.actions.run.executeCustomCommand.error'), Em.I18n.t('services.service.actions.run.executeCustomCommand.error'))).to.be.true;
      expect($.parseJSON.called).to.be.false;
    });
    it("responseText empty", function () {
      var data = {
        responseText: null
      };
      controller.executeCustomCommandErrorCallback(data);

      expect(App.showAlertPopup.calledWith(Em.I18n.t('services.service.actions.run.executeCustomCommand.error'), Em.I18n.t('services.service.actions.run.executeCustomCommand.error'))).to.be.true;
      expect($.parseJSON.called).to.be.false;
    });
    it("data empty (2)", function () {
      var data = {
        responseText: "test"
      };
      controller.executeCustomCommandErrorCallback(data);
      expect(App.showAlertPopup.calledWith(Em.I18n.t('services.service.actions.run.executeCustomCommand.error'), Em.I18n.t('services.service.actions.run.executeCustomCommand.error'))).to.be.true;
      expect($.parseJSON.calledWith('test')).to.be.true;
    });
  });

  describe("#doDeleteHost()", function () {
    beforeEach(function () {
      controller.set('fromDeleteHost', false);
      controller.set('content.hostName', 'host1');
      sinon.stub(controller, '_doDeleteHostComponent', function (comp, callback) {
        callback();
      });
    });
    afterEach(function () {
      controller._doDeleteHostComponent.restore();
    });

    describe("Host has no components", function () {

      beforeEach(function () {
        controller.set('content.hostComponents', Em.A([]));
        controller.doDeleteHost(Em.K);
        this.args = testHelpers.findAjaxRequest('name', 'common.delete.host');
      });

      it('fromDeleteHost is true', function () {
        expect(controller.get('fromDeleteHost')).to.be.true;
      });
      it('1st request is to delete host', function () {
        expect(this.args[0]).exists;
      });
      it('1st request is done with valid hostName', function () {
        expect(this.args[0].data.hostName).to.be.equal('host1');
      });
    });

    describe("Host has components", function () {

      beforeEach(function () {
        controller.set('content.hostComponents', Em.A([Em.Object.create({
          componentName: 'COMP1'
        })]));
        controller.doDeleteHost(Em.K);
      });

      it('_doDeleteHostComponent is called with correct arguments', function () {
        expect(controller._doDeleteHostComponent.calledWith('COMP1')).to.be.true;
      });
      it('fromDeleteHost is true', function () {
        expect(controller.get('fromDeleteHost')).to.be.true;
      });
      it('1st request is to delete host', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.delete.host');
        expect(args[0]).exists;
      });
      it('1st request is done with valid hostName', function () {
        var args = testHelpers.findAjaxRequest('name', 'common.delete.host');
        expect(args[0].data.hostName).to.be.equal('host1');
      });

    });
  });

  describe("#deleteHostSuccessCallback", function () {
    var mock;
    beforeEach(function () {
      mock = {
        updateHost: function (callback) {
          callback();
        },
        getAllHostNames: Em.K
      };
      sinon.stub(App.router, 'get').withArgs('updateController').returns(mock).withArgs('clusterController').returns(mock);
      sinon.spy(mock, 'updateHost');
      sinon.spy(mock, 'getAllHostNames');
      sinon.stub(controller, 'loadConfigs', Em.K);
      sinon.stub(App.router, 'transitionTo', Em.K);
      sinon.stub(controller, 'isServiceMetricsLoaded', Em.clb);
      controller.deleteHostSuccessCallback();
    });

    afterEach(function () {
      App.router.get.restore();
      mock.updateHost.restore();
      mock.getAllHostNames.restore();
      controller.loadConfigs.restore();
      controller.isServiceMetricsLoaded.restore();
      App.router.transitionTo.restore();
    });

    it('updateController is used', function () {
      expect(App.router.get.calledWith('updateController')).to.be.true;
    });
    it('updateHost is called once', function () {
      expect(mock.updateHost.calledOnce).to.be.true;
    });
    it('loadConfigs is not called', function () {
      expect(controller.loadConfigs.called).to.be.false;
    });
    it('user is moved to the hosts', function () {
      expect(App.router.transitionTo.calledWith('hosts.index')).to.be.true;
    });
    it('clusterController is used', function () {
      expect(App.router.get.calledWith('clusterController')).to.be.true;
    });
    it('getAllHostNames is called once', function () {
      expect(mock.getAllHostNames.calledOnce).to.be.true;
    });
  });

  describe("#deleteHostErrorCallback", function () {

    beforeEach(function () {
      sinon.stub(App.ajax, 'defaultErrorHandler', Em.K);
      controller.deleteHostErrorCallback({
        status: 'status',
        statusText: "statusText"
      }, 'textStatus', 'errorThrown', {url: 'url'});
    });

    afterEach(function () {
      App.ajax.defaultErrorHandler.restore();
    });

    it('defaultErrorHandler is called once', function () {
      expect(App.ajax.defaultErrorHandler.calledOnce).to.be.true;
    });
  });

  describe('#installVersionConfirmation()', function () {

    beforeEach(function () {
      sinon.spy(App, "showConfirmationPopup");
      sinon.stub(controller, 'installVersion', Em.K);
    });
    afterEach(function () {
      App.showConfirmationPopup.restore();
      controller.installVersion.restore();
    });

    it('confirm popup should be displayed', function () {
      var event = {context: Em.Object.create({displayName: 'displayName'})};
      var popup = controller.installVersionConfirmation(event);
      expect(App.showConfirmationPopup.calledOnce).to.be.true;
      popup.onPrimary();
      expect(controller.installVersion.calledWith(event)).to.be.true;
    });
  });

  describe("#installVersion()", function () {
    it("call App.ajax.send", function () {
      controller.set('content.hostName', 'host1');
      controller.installVersion({context: {}});
      var args = testHelpers.findAjaxRequest('name', 'host.stack_versions.install');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(controller);
      expect(args[0].data).to.be.eql({
        hostName: 'host1',
        version: {}
      });
    });
  });

  describe("#installVersionSuccessCallback()", function () {
    var version = Em.Object.create({
      id: 1,
      status: 'INIT'
    });
    beforeEach(function () {
      this.mock = sinon.stub(App.HostStackVersion, 'find');
      this.mock.returns(version);
      sinon.stub(App.db, 'set', Em.K);
      sinon.stub(App.clusterStatus, 'setClusterStatus', Em.K);
      controller.installVersionSuccessCallback({Requests: {id: 1}}, {}, {version: version});
    });
    afterEach(function () {
      this.mock.restore();
      App.db.set.restore();
      App.clusterStatus.setClusterStatus.restore();
    });
    it("status is INSTALLING", function () {
      expect(version.get('status')).to.equal('INSTALLING');
    });
    it('valid data is saved to the localDB', function () {
      expect(App.db.set.calledWith('repoVersionInstall', 'id', [1])).to.be.true;
    });
    it('clusterStatus is updated', function () {
      expect(App.clusterStatus.setClusterStatus.calledOnce).to.be.true;
    });
  });

  describe('#getHiveHosts()', function () {

    var cases = [
      {
        'input': {
          'hiveMetastoreHost': '',
          'fromDeleteHost': false,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h1', 'h2', 'h4'],
        'title': 'adding HiveServer2'
      },
      {
        'input': {
          'hiveMetastoreHost': 'h0',
          'fromDeleteHost': false,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h0', 'h1', 'h2', 'h4'],
        'title': 'adding Hive Metastore'
      },
      {
        'input': {
          'webhcatServerHost': 'h0',
          'fromDeleteHost': false,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h0', 'h1', 'h2', 'h4'],
        'title': 'adding WebHCat Server'
      },
      {
        'input': {
          'hiveMetastoreHost': '',
          'content.hostName': 'h1',
          'fromDeleteHost': false,
          'deleteHiveMetaStore': true,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h2', 'h4'],
        'title': 'deleting Hive component'
      },
      {
        'input': {
          'hiveMetastoreHost': '',
          'content.hostName': 'h4',
          'fromDeleteHost': false,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': true
        },
        'hiveHosts': ['h1', 'h2'],
        'title': 'deleting WebHCat Server'
      },
      {
        'input': {
          'hiveMetastoreHost': '',
          'content.hostName': 'h2',
          'fromDeleteHost': true,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h1', 'h4'],
        'title': 'deleting host with Hive component'
      },
      {
        'input': {
          'webhcatServerHost': '',
          'content.hostName': 'h2',
          'fromDeleteHost': true,
          'deleteHiveMetaStore': false,
          'deleteWebHCatServer': false
        },
        'hiveHosts': ['h1', 'h4'],
        'title': 'deleting host with WebHCat Server'
      }
    ];

    before(function () {
      sinon.stub(App.HostComponent, 'find').returns([
        {
          componentName: 'HIVE_METASTORE',
          hostName: 'h2'
        },
        {
          componentName: 'HIVE_METASTORE',
          hostName: 'h1'
        },
        {
          componentName: 'HIVE_SERVER',
          hostName: 'h3'
        },
        {
          componentName: 'WEBHCAT_SERVER',
          hostName: 'h4'
        }
      ]);
    });

    after(function () {
      App.HostComponent.find.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          Em.keys(item.input).forEach(function (key) {
            controller.set(key, item.input[key]);
          });
          this.hostsMap = controller.getHiveHosts().toArray();
          this.expectedHosts = this.hostsMap.filter(function(hostInfo) {
            return ['WEBHCAT_SERVER', 'HIVE_METASTORE'].contains(hostInfo.component) && hostInfo.isInstalled === true;
          }).mapProperty('hostName').uniq();
        });

        it(JSON.stringify(item.hiveHosts) + ' are in the list', function () {
          expect(this.expectedHosts).to.include.same.members(item.hiveHosts);
        });
        it('hiveMetastoreHost is empty', function () {
          expect(controller.get('hiveMetastoreHost')).to.be.empty;
        });
        it('webhcatServerHost is empty', function () {
          expect(controller.get('webhcatServerHost')).to.be.empty;
        });
        it('fromDeleteHost is false', function () {
          expect(controller.get('fromDeleteHost')).to.be.false;
        });
        it('deleteHiveMetaStore is false', function () {
          expect(controller.get('deleteHiveMetaStore')).to.be.false;
        });
      });
    });

  });

  describe('#onLoadRangerConfigs()', function () {

    var cases = [
      {
        'kmsHosts': ['host1'],
        'kmsPort': 'port',
        'title': 'single host',
        'hostToInstall': undefined,
        'result': [
          {
            properties: {
              'core-site': {'hadoop.security.key.provider.path': 'kms://http@host1:port/kms'},
              'hdfs-site': {'dfs.encryption.key.provider.uri': 'kms://http@host1:port/kms'}
            },
            properties_attributes: {
              'core-site': undefined,
              'hdfs-site': undefined
            }
          },
          {
            properties: {
              'kms-site': {
                'hadoop.kms.cache.enable': 'true',
                'hadoop.kms.cache.timeout.ms': '600000',
                'hadoop.kms.current.key.cache.timeout.ms': '30000',
                'hadoop.kms.authentication.signer.secret.provider': 'random',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.auth.type': 'kerberos',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string': '#HOSTNAME#:#PORT#,...'
              }
            },
            properties_attributes: {
              'kms-site': undefined
            }
          }
        ]
      },
      {
        'kmsHosts': ['host1', 'host2'],
        'kmsPort': 'port',
        'title': 'two hosts',
        'hostToInstall': 'host2',
        'result': [
          {
            properties: {
              'core-site': {'hadoop.security.key.provider.path': 'kms://http@host2;host1:port/kms'},
              'hdfs-site': {'dfs.encryption.key.provider.uri': 'kms://http@host1;host2:port/kms'}
            },
            properties_attributes: {
              'core-site': undefined,
              'hdfs-site': undefined
            }
          },
          {
            properties: {
              'kms-site': {
                'hadoop.kms.cache.enable': 'false',
                'hadoop.kms.cache.timeout.ms': '0',
                'hadoop.kms.current.key.cache.timeout.ms': '0',
                'hadoop.kms.authentication.signer.secret.provider': 'zookeeper',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.auth.type': 'none',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string': 'host1:2181,host2:2181'
              }
            },
            properties_attributes: {
              'kms-site': undefined
            }
          }
        ]
      }
    ];

    beforeEach(function () {
      sinon.spy(controller, 'saveConfigsBatch');
      sinon.stub(App.Service, 'find', function () {
        return [
          Em.Object.create({
            displayName: 'service',
            serviceName: 'RANGER_KMS'
          })
        ];
      });
      sinon.stub(controller, 'saveLoadedConfigs', Em.K);
    });

    afterEach(function () {
      controller.saveConfigsBatch.restore();
      App.Service.find.restore();
      controller.saveLoadedConfigs.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        var data = {
          items: [
            {
              type: 'kms-env',
              properties: {'kms_port': item.kmsPort}
            },
            {
              type: 'core-site',
              properties: {
                'hadoop.security.key.provider.path': 'kms://http@host2;host1:port/kms'
              }
            },
            {
              type: 'hdfs-site',
              properties: {
                'dfs.encryption.key.provider.uri': 'kms://http@host2:port/kms'
              }
            },
            {
              type: 'kms-site',
              properties: {
                'hadoop.kms.cache.enable': 'true',
                'hadoop.kms.cache.timeout.ms': '600000',
                'hadoop.kms.current.key.cache.timeout.ms': '30000',
                'hadoop.kms.authentication.signer.secret.provider': 'random',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.auth.type': 'kerberos',
                'hadoop.kms.authentication.signer.secret.provider.zookeeper.connection.string': '#HOSTNAME#:#PORT#,...'
              }
            }
          ]
        };

        beforeEach(function () {
          controller.set('rangerKMSServerHost', item.hostToInstall);
          sinon.stub(controller, 'getRangerKMSServerHosts').returns(item.kmsHosts);
          controller.onLoadRangerConfigs(data);
        });

        it('saveConfigsBatch is called with valid arguments', function () {
          expect(controller.saveConfigsBatch.calledWith(item.result, 'RANGER_KMS_SERVER', item.hostToInstall)).to.be.true;
        });
      });
    });

  });

  describe("#removeHostComponentModel()", function () {

    beforeEach(function () {
      App.cache.services = [
        {
          ServiceInfo: {
            service_name: 'S1'
          },
          host_components: ['C1_host1']
        }
      ];
      sinon.stub(App.HostComponent, 'find').returns([
        Em.Object.create({
          id: 'C1_host1',
          componentName: 'C1',
          hostName: 'host1',
          service: Em.Object.create({
            serviceName: 'S1'
          })
        })
      ]);
      sinon.stub(App.serviceMapper, 'deleteRecord', Em.K);
      controller.removeHostComponentModel('C1', 'host1');
    });
    afterEach(function () {
      App.HostComponent.find.restore();
      App.serviceMapper.deleteRecord.restore();
    });
    it("App.cache is updated", function () {
      expect(App.cache.services[0].host_components).to.be.empty;
    });
    it('Record is deleted', function () {
      expect(App.serviceMapper.deleteRecord.calledOnce).to.be.true;
    });
  });

  describe("#parseNnCheckPointTime", function () {
    var tests = [
      {
        m: "NameNode on this host has JMX data, the last checkpoint time is less than 12 hours ago",
        data:
        {
          "href" : "",
          "HostRoles" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "host_name" : "c6401.ambari.apache.org"
          },
          "metrics" : {
            "dfs" : {
              "FSNamesystem" : {
                "HAState" : "active",
                "LastCheckpointTime" : 1435775648000
              }
            }
          }
        },
        result: false
      },
      {
        m: "NameNode on this host has JMX data, the last checkpoint time is > 12 hours ago",
        data:
        {
          "href" : "",
          "HostRoles" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "host_name" : "c6401.ambari.apache.org"
          },
          "metrics" : {
            "dfs" : {
              "FSNamesystem" : {
                "HAState" : "active",
                "LastCheckpointTime" : 1435617248000
              }
            }
          }
        },
        result: "c6401.ambari.apache.org"
      },
      {
        m: "NameNode(standby) on this host has JMX data",
        data:
        {
          "href" : "",
          "HostRoles" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "host_name" : "c6401.ambari.apache.org"
          },
          "metrics" : {
            "dfs" : {
              "FSNamesystem" : {
                "HAState" : "standby",
                "LastCheckpointTime" : 1435617248000
              }
            }
          }
        },
        result: false
      },
      {
        m: "NameNode on this host has no JMX data",
        data:
        {
          "href" : "",
          "HostRoles" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "host_name" : "c6401.ambari.apache.org"
          },
          "metrics" : {
            "dfs" : {
              "FSNamesystem" : {
                "HAState" : "active"
              }
            }
          }
        },
        result: null
      },
      {
        m: "NameNode on this host has no JMX data",
        data:
        {
          "href" : "",
          "HostRoles" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "host_name" : "c6401.ambari.apache.org"
          },
          "metrics" : {
          }
        },
        result: null
      }
    ];

    beforeEach(function () {
      sinon.stub(App, 'dateTime').returns(1435790048000);
    });

    afterEach(function () {
      App.dateTime.restore();
    });

    tests.forEach(function (test) {
      it(test.m, function () {
        var mainHostDetailsController = App.MainHostDetailsController.create({isNNCheckpointTooOld: null});
        mainHostDetailsController.parseNnCheckPointTime(test.data);
        expect(mainHostDetailsController.get('isNNCheckpointTooOld')).to.equal(test.result);
      });
    });
  });

  describe("#checkComponentDependencies()", function() {

    beforeEach(function () {
      this.mock = sinon.stub(App.StackServiceComponent, 'find');
      sinon.stub(App.HostComponent, 'find').returns([{
        hostName: 'host1',
        componentName: 'C1'
      }]);
    });
    afterEach(function () {
      this.mock.restore();
      App.HostComponent.find.restore();
    });

    it("no dependencies", function () {
      var opt = {scope: '*'};
      this.mock.returns(Em.Object.create({
        dependencies: []
      }));
      expect(controller.checkComponentDependencies('C1', opt)).to.be.empty;
    });
    it("dependecies already installed", function () {
      var opt = {scope: '*', installedComponents: ['C2']};
      this.mock.returns(Em.Object.create({
        dependencies: [{componentName: 'C2'}]
      }));
      expect(controller.checkComponentDependencies('C1', opt)).to.be.empty;
    });
    it("dependecies should be added", function () {
      var opt = {scope: '*', installedComponents: ['C2']};
      this.mock.returns(Em.Object.create({
        dependencies: [{componentName: 'C3'}]
      }));
      expect(controller.checkComponentDependencies('C1', opt)).to.eql(['C3']);
    });
    it("scope is host", function () {
      var opt = {scope: 'host', hostName: 'host1'};
      this.mock.returns(Em.Object.create({
        dependencies: [{componentName: 'C3', scope: 'host'}]
      }));
      expect(controller.checkComponentDependencies('C1', opt)).to.eql(['C3']);
    });
  });

  describe('#onLoadHiveConfigs', function() {

    beforeEach(function() {
      sinon.stub(controller, 'saveConfigsBatch', Em.K);
      sinon.stub(controller, 'saveLoadedConfigs', Em.K);
      controller.set('configs', {});
    });

    afterEach(function() {
      controller.saveConfigsBatch.restore();
      controller.saveLoadedConfigs.restore();
    });

    var makeHostComponentModel = function(componentName, hostNames) {
      if (Em.isArray(componentName)) {
        return componentName.map(function(cName, index) {
          return makeHostComponentModel(cName, hostNames[index]);
        }).reduce(function(p,c) { return p.concat(c); }, []);
      }
      return hostNames.map(function(hostName) {
        return {
          componentName: componentName,
          hostName: hostName
        };
      });
    };

    var makeFileNameProps = function(fileName, configs) {
      var ret = {
        type: fileName,
        properties: {}
      };
      var propRet = {};
      configs.forEach(function(property) {
        propRet[property[0]] = property[1];
      });
      ret.properties = propRet;
      return ret;
    };

    var makeEmptyPropAttrs = function() {
      var fileNames = Array.prototype.slice.call(arguments);
      var ret = {};
      fileNames.forEach(function(fileName) {
        ret[fileName] = {};
      });
      return ret;
    };

    var inlineComponentHostInfo = function(hostComponentModel) {
      return hostComponentModel.mapProperty('componentName').uniq()
        .map(function(componentName) {
          return componentName + ":" + hostComponentModel.filterProperty('componentName', componentName).mapProperty('hostName').join();
        }).join(',');
    };

    var tests = [
      {
        hostComponentModel: makeHostComponentModel(['HIVE_SERVER', 'HIVE_METASTORE'], [['host1', 'host2'], ['host1']]),
        configs: {
          items: [
            makeFileNameProps('hive-site', [
              ['hive.metastore.uris', 'thrift://host1:9090']
            ]),
            makeFileNameProps('hive-env', [
              ['hive_user', 'hive_user_val']
            ]),
            makeFileNameProps('webhcat-site', [
              ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
            ]),
            makeFileNameProps('core-site', [
              ['hadoop.proxyuser.hive_user_val.hosts', 'host1']
            ])
          ]
        },
        m: 'Components: {0}, appropriate configs should be changed, thrift port 9090, Controller stubs: {1}',
        e: {
          configs: [
            {
              "properties": {
                "hive-site": makeFileNameProps('hive-site', [
                  ['hive.metastore.uris', 'thrift://host1:9090']
                ]).properties,
                "webhcat-site": makeFileNameProps('webhcat-site', [
                  ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9090,hive.metastore.sasl.enabled=false']
                ]).properties,
                "hive-env": makeFileNameProps('hive-env', [
                  ['hive_user', 'hive_user_val']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("hive-site", "webhcat-site", "hive-env")
            },
            {
              "properties": {
                "core-site": makeFileNameProps('core-site', [
                  ['hadoop.proxyuser.hive_user_val.hosts', 'host1,host2']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("core-site")
            },
          ]
        }
      },
      {
        hostComponentModel: makeHostComponentModel(['HIVE_SERVER', 'HIVE_METASTORE', 'WEBHCAT_SERVER'], [['host1', 'host2'], ['host1'], ['host2']]),
        ctrlStubs: {
          webhcatServerHost: 'host3'
        },
        configs: {
          items: [
            makeFileNameProps('hive-site', [
              ['hive.metastore.uris', 'thrift://host1']
            ]),
            makeFileNameProps('hive-env', [
              ['hive_user', 'hive_user_val']
            ]),
            makeFileNameProps('webhcat-site', [
              ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
            ]),
            makeFileNameProps('core-site', [
              ['hadoop.proxyuser.hive_user_val.hosts', 'host1']
            ])
          ]
        },
        m: 'Components: {0}, appropriate configs should be changed, thrift port should be default 9083, Controller Stubs: {1}',
        e: {
          configs: [
            {
              "properties": {
                "hive-site": makeFileNameProps('hive-site', [
                  ['hive.metastore.uris', 'thrift://host1:9083']
                ]).properties,
                "webhcat-site": makeFileNameProps('webhcat-site', [
                  ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
                ]).properties,
                "hive-env": makeFileNameProps('hive-env', [
                  ['hive_user', 'hive_user_val']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("hive-site", "webhcat-site", "hive-env")
            },
            {
              "properties": {
                "core-site": makeFileNameProps('core-site', [
                  ['hadoop.proxyuser.hive_user_val.hosts', 'host1,host2,host3']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("core-site")
            },
          ]
        }
      },
      {
        hostComponentModel: makeHostComponentModel(['HIVE_SERVER', 'HIVE_METASTORE', 'WEBHCAT_SERVER'], [['host1'], ['host1'], ['host1']]),
        ctrlStubs: {
          webhcatServerHost: 'host3',
          hiveMetastoreHost: 'host2'
        },
        configs: {
          items: [
            makeFileNameProps('hive-site', [
              ['hive.metastore.uris', 'thrift://host1:1111']
            ]),
            makeFileNameProps('hive-env', [
              ['hive_user', 'hive_user_val']
            ]),
            makeFileNameProps('webhcat-site', [
              ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
            ]),
            makeFileNameProps('core-site', [
              ['hadoop.proxyuser.hive_user_val.hosts', 'host1']
            ])
          ]
        },
        m: 'Components: {0}, appropriate configs should be changed, thrift port should be 1111, Controller Stubs: {1}',
        e: {
          configs: [
            {
              "properties": {
                "hive-site": makeFileNameProps('hive-site', [
                  ['hive.metastore.uris', 'thrift://host1:1111,thrift://host2:1111']
                ]).properties,
                "webhcat-site": makeFileNameProps('webhcat-site', [
                  ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:1111\\,thrift://host2:1111,hive.metastore.sasl.enabled=false']
                ]).properties,
                "hive-env": makeFileNameProps('hive-env', [
                  ['hive_user', 'hive_user_val']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("hive-site", "webhcat-site", "hive-env")
            },
            {
              "properties": {
                "core-site": makeFileNameProps('core-site', [
                  ['hadoop.proxyuser.hive_user_val.hosts', 'host1,host2,host3']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("core-site")
            },
          ]
        }
      },
      {
        hostComponentModel: makeHostComponentModel(['HIVE_SERVER', 'HIVE_METASTORE', 'WEBHCAT_SERVER'], [['host1', 'host2'], ['host1','host2'], ['host1', 'host3']]),
        ctrlStubs: {
          fromDeleteHost: true,
          'content.hostName': 'host2',
          webhcatServerHost: '',
          hiveMetastoreHost: ''
        },
        webHCat: true,
        configs: {
          items: [
            makeFileNameProps('hive-site', [
              ['hive.metastore.uris', 'thrift://host1:1111']
            ]),
            makeFileNameProps('hive-env', [
              ['webhcat_user', 'webhcat_user_val']
            ]),
            makeFileNameProps('webhcat-site', [
              ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
            ]),
            makeFileNameProps('core-site', [
              ['hadoop.proxyuser.webhcat_user_val.hosts', 'host1']
            ])
          ]
        },
        m: 'Change WebHCat proxyuser',
        e: {
          configs: [
            {
              "properties": {
                "hive-site": makeFileNameProps('hive-site', [
                  ['hive.metastore.uris', 'thrift://host1:1111']
                ]).properties,
                "webhcat-site": makeFileNameProps('webhcat-site', [
                  ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
                ]).properties,
                "hive-env": makeFileNameProps('hive-env', [
                  ['webhcat_user', 'webhcat_user_val']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("hive-site", "webhcat-site", "hive-env")
            },
            {
              "properties": {
                "core-site": makeFileNameProps('core-site', [
                  ['hadoop.proxyuser.webhcat_user_val.hosts', 'host1,host3']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("core-site")
            },
          ]
        }
      },
      {
        hostComponentModel: makeHostComponentModel(['HIVE_SERVER', 'HIVE_METASTORE', 'WEBHCAT_SERVER'], [['host1', 'host2'], ['host1','host2'], ['host1', 'host3']]),
        ctrlStubs: {
          fromDeleteHost: true,
          'content.hostName': 'host2',
          webhcatServerHost: '',
          hiveMetastoreHost: ''
        },
        configs: {
          items: [
            makeFileNameProps('hive-site', [
              ['hive.metastore.uris', 'thrift://host1:1111']
            ]),
            makeFileNameProps('hive-env', [
              ['hive_user', 'hive_user_val']
            ]),
            makeFileNameProps('webhcat-site', [
              ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:9083,hive.metastore.sasl.enabled=false']
            ]),
            makeFileNameProps('core-site', [
              ['hadoop.proxyuser.hive_user_val.hosts', 'host1']
            ])
          ]
        },
        m: 'Components: {0}, appropriate configs should be changed, thrift port should be default 9083, Controller Stubs: {1}',
        e: {
          configs: [
            {
              "properties": {
                "hive-site": makeFileNameProps('hive-site', [
                  ['hive.metastore.uris', 'thrift://host1:1111']
                ]).properties,
                "webhcat-site": makeFileNameProps('webhcat-site', [
                  ['templeton.hive.properties', 'hive.metastore.local=false,hive.metastore.uris=thrift://host1:1111,hive.metastore.sasl.enabled=false']
                ]).properties,
                "hive-env": makeFileNameProps('hive-env', [
                  ['hive_user', 'hive_user_val']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("hive-site", "webhcat-site", "hive-env")
            },
            {
              "properties": {
                "core-site": makeFileNameProps('core-site', [
                  ['hadoop.proxyuser.hive_user_val.hosts', 'host1,host3']
                ]).properties
              },
              "properties_attributes": makeEmptyPropAttrs("core-site")
            }
          ]
        }
      }
    ];

    tests.forEach(function(test) {
      describe(test.m.format(inlineComponentHostInfo(test.hostComponentModel), test.ctrlStubs ? JSON.stringify(test.ctrlStubs) : 'None'), function() {

        beforeEach(function () {
          if (test.appGetterStubs) {
            Em.keys(test.appGetterStubs).forEach(function(key) {
              sinon.stub(App, 'get').withArgs(key).returns(test.appGetterStubs[key]);
            });
          }
          if (test.ctrlStubs) {
            var stub = sinon.stub(controller, 'get');
            Em.keys(test.ctrlStubs).forEach(function(key) {
              stub.withArgs(key).returns(test.ctrlStubs[key]);
            });
          }
          sinon.stub(App.HostComponent, 'find').returns(test.hostComponentModel);
        });

        afterEach(function () {
          if (test.ctrlStubs) {
            controller.get.restore();
          }
          if (test.appGetterStubs) {
            App.get.restore();
          }
          App.HostComponent.find.restore();
        });

        it('saveConfigsBatch is called with correct configs', function () {
          controller.onLoadHiveConfigs(test.configs, null, {webHCat: test.webHCat});
          var configs = controller.saveConfigsBatch.args[0];
          var properties = configs[0];
          expect(properties).to.be.eql(test.e.configs);
        });

      });
    });
  });

  describe('#setConfigsChangesForDisplay', function () {

    var propertiesToChange = [
        {
          propertyName: 'n0',
          propertyFileName: 'f0'
        },
        {
          propertyName: 'n1',
          propertyFileName: 'f1'
        },
        {
          propertyName: 'n2',
          propertyFileName: 'f2'
        },
        {
          propertyName: 'n3',
          propertyFileName: 'f3'
        }
      ],
      result = {
        recommendedPropertiesToChange: [
          {
            propertyName: 'n0',
            propertyFileName: 'f0',
            saveRecommended: true
          },
          {
            propertyName: 'n3',
            propertyFileName: 'f3',
            saveRecommended: true
          }
        ],
        requiredPropertiesToChange: [
          {
            propertyName: 'n1',
            propertyFileName: 'f1'
          },
          {
            propertyName: 'n2',
            propertyFileName: 'f2'
          }
        ]
      };

    beforeEach(function () {
      controller.setProperties({
        allPropertiesToChange: propertiesToChange,
        recommendedPropertiesToChange: [],
        requiredPropertiesToChange: []
      });
      sinon.stub(App.configsCollection, 'getConfigByName', function (propertyName) {
        var map = {
          n0: {
            isEditable: true,
            isReconfigurable: true
          },
          n1: {
            isEditable: true,
            isReconfigurable: false
          },
          n2: {
            isEditable: false,
            isReconfigurable: false
          }
        };
        return map[propertyName];
      });
      sinon.stub(App, 'get').withArgs('router.clusterController.isConfigsPropertiesLoaded').returns(true);
      controller.set('isConfigsLoadingInProgress', true);
      controller.setConfigsChangesForDisplay();
    });

    afterEach(function () {
      App.configsCollection.getConfigByName.restore();
      App.get.restore();
    });

    it('editable changes', function () {
      expect(controller.get('recommendedPropertiesToChange').toArray()).to.eql(result.recommendedPropertiesToChange);
    });

    it('non-editable changes', function () {
      expect(controller.get('requiredPropertiesToChange').toArray()).to.eql(result.requiredPropertiesToChange);
    });

    it('isConfigsLoadingInProgress', function () {
      expect(controller.get('isConfigsLoadingInProgress')).to.be.false;
    });

  });

  describe('#clearConfigsChanges', function () {

    beforeEach(function () {
      sinon.stub(controller, 'abortRequests', Em.K);
      controller.setProperties({
        allPropertiesToChange: [{}],
        recommendedPropertiesToChange: [{}],
        requiredPropertiesToChange: [{}],
        groupedPropertiesToChange: [{}],
        isReconfigureRequired: true,
        configs: {}
      });
    });

    afterEach(function () {
      controller.abortRequests.restore();
    });

    describe('default case', function () {

      beforeEach(function () {
        controller.clearConfigsChanges();
      });

      it('allPropertiesToChange', function () {
        expect(controller.get('allPropertiesToChange')).to.have.length(0);
      });

      it('recommendedPropertiesToChange', function () {
        expect(controller.get('recommendedPropertiesToChange')).to.have.length(0);
      });

      it('groupedPropertiesToChange', function () {
        expect(controller.get('groupedPropertiesToChange')).to.have.length(0);
      });

      it('isReconfigureRequired', function () {
        expect(controller.get('isReconfigureRequired')).to.be.false;
      });

      it('configs', function () {
        expect(controller.get('configs')).to.be.null;
      });

    });

    describe('no loaded configs cleanup', function () {

      beforeEach(function () {
        controller.clearConfigsChanges(true);
      });

      it('configs shouldn\'t be cleared', function () {
        expect(controller.get('configs')).to.not.be.null;
      });

    });

  });

  describe('#saveLoadedConfigs', function () {

    var data = {
      items: [
        {
          type: 't0',
          properties: {
            p0: 'v0',
            p1: 'v1'
          },
          properties_attributes: {}
        },
        {
          type: 't1',
          properties: {
            p2: 'v2',
            p3: 'v3'
          },
          properties_attributes: {}
        }
      ]
    };

    it('should store data in configs object', function () {
      controller.set('configs', null);
      controller.saveLoadedConfigs(data);
      expect(controller.get('configs')).to.eql(data);
    });

  });

  describe('#loadComponentRelatedConfigs', function () {

    var testCases = [
      {
        isReconfigureRequired: true,
        loadConfigsCallCount: 1,
        isConfigsLoadingInProgress: true,
        message: 'reconfigure required'
      },
      {
        isReconfigureRequired: false,
        loadConfigsCallCount: 0,
        isConfigsLoadingInProgress: false,
        message: 'no reconfigure required'
      }
    ];

    testCases.forEach(function (test) {

      describe(test.message, function () {

        beforeEach(function () {
          sinon.stub(controller, 'isServiceMetricsLoaded', Em.clb);
          sinon.stub(controller, 'loadConfigs', Em.K);
          controller.setProperties({
            isReconfigureRequired: test.isReconfigureRequired,
            isConfigsLoadingInProgress: false
          });
          controller.loadComponentRelatedConfigs();
        });

        afterEach(function () {
          controller.isServiceMetricsLoaded.restore();
          controller.loadConfigs.restore();
        });

        it('loadConfigs', function () {
          expect(controller.loadConfigs.callCount).to.equal(test.loadConfigsCallCount);
        });

        it('isConfigsLoadingInProgress', function () {
          expect(controller.get('isConfigsLoadingInProgress')).to.equal(test.isConfigsLoadingInProgress);
        });

      });

    });

  });
});

});

require.register("test/controllers/main/host/host_alerts_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


var App = require('app');
require('controllers/main/host/host_alerts_controller');

var controller;

function getController() {
  return App.MainHostAlertsController.create();
}

describe('App.MainHostAlertsController', function () {

  beforeEach(function() {
    controller = getController();
  });

  App.TestAliases.testAsComputedAlias(getController(), 'selectedHost', 'App.router.mainHostDetailsController.content', 'object');

  describe("#routeToAlertDefinition()", function () {

    beforeEach(function () {
      sinon.stub(App.AlertDefinition, 'find').returns('alertDefinition');
      sinon.stub(App.router, 'transitionTo', Em.K);
    });
    afterEach(function () {
      App.AlertDefinition.find.restore();
      App.router.transitionTo.restore();
    });

    it("transitionTo is called with valid route and data", function () {
      controller.routeToAlertDefinition({context: 'id'});
      expect(App.router.transitionTo.calledWith('main.alerts.alertDetails', 'alertDefinition')).to.be.true;
    });
  });

});

});

require.register("test/controllers/main/host_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');

var testHelpers = require('test/helpers');
require('utils/batch_scheduled_requests');
require('controllers/main/host');
require('mappers/server_data_mapper');

describe('MainHostController', function () {

  var hostController, db;

  beforeEach(function () {
    hostController = App.MainHostController.create({});
  });

  afterEach(function () {
    hostController.destroy();
  });

  describe("#totalCount()", function () {

    it("TOTAL is undefined", function () {
      hostController.set('hostsCountMap', {});
      hostController.propertyDidChange('totalCount');
      expect(hostController.get('totalCount')).to.be.equal(0);
    });

    it("TOTAL is 1", function () {
      hostController.set('hostsCountMap', {TOTAL: 1});
      hostController.propertyDidChange('totalCount');
      expect(hostController.get('totalCount')).to.be.equal(1);
    });
  });

  describe('#getRegExp()', function () {
    var message = '`{0}` should convert to `{1}`',
      tests = [
        {value: '.*', expected: '.*'},
        {value: '.', expected: '.*'},
        {value: '.*.*', expected: '.*'},
        {value: '*', expected: '^$'},
        {value: '........', expected: '.*'},
        {value: '........*', expected: '.*'},
        {value: 'a1', expected: '.*a1.*'},
        {value: 'a1.', expected: '.*a1.*'},
        {value: 'a1...', expected: '.*a1.*'},
        {value: 'a1.*', expected: '.*a1.*'},
        {value: 'a1.*.a2.a3', expected: '.*a1.*.a2.a3.*'},
        {value: 'a1.*.a2...a3', expected: '.*a1.*.a2...a3.*'}
      ];

    tests.forEach(function (test) {
      it(message.format(test.value, test.expected), function () {
        expect(hostController.getRegExp(test.value)).to.be.equal(test.expected);
      });
    });
  });

  describe('#getQueryParameters', function () {
    beforeEach(function () {
      sinon.spy(hostController, 'getRegExp');
      sinon.stub(App.db, 'getFilterConditions', function () {
        return [{
          iColumn: 1,
          skipFilter: false,
          type: "string",
          value: "someval"
        }];
      });
    });

    afterEach(function () {
      App.db.getFilterConditions.restore();
      hostController.getRegExp.restore();
    });

    it('should call #getRegExp with value `someval` on host name filter', function () {
      hostController.getQueryParameters();
      expect(hostController.getRegExp.calledWith('someval')).to.ok;
    });

    it('result should include host name filter converted value', function () {
      expect(hostController.getQueryParameters().findProperty('key', 'Hosts/host_name').value).to.equal('.*someval.*');
    });
  });

  describe('#getSortProps', function () {

    beforeEach(function () {
      db = {
        mainHostController: [
          {name: 'hostName', status: 'sorting'}
        ]
      };
      sinon.stub(App.db, 'getSortingStatuses', function (k) {
        return db[k];
      });
      sinon.stub(App.db, 'setSortingStatuses', function (k, v) {
        db[k] = Em.makeArray(v);
      });
    });

    afterEach(function () {
      App.db.getSortingStatuses.restore();
      App.db.setSortingStatuses.restore();
    });

    it('should set default sorting condition', function () {
      hostController.getSortProps();
      expect(db.mainHostController).to.eql([{name: 'hostName', status: 'sorting_asc'}]);
    });

  });

  describe("#updateStatusCounters()", function() {

    it("isCountersUpdating is false", function() {
      hostController.set('isCountersUpdating', false);
      hostController.updateStatusCounters();
      expect(testHelpers.findAjaxRequest('name', 'host.status.counters')).to.be.undefined;
    });

    it("isCountersUpdating is true", function() {
      hostController.set('isCountersUpdating', true);
      hostController.updateStatusCounters();
      expect(testHelpers.findAjaxRequest('name', 'host.status.counters')).to.be.exist;
    });
  });

  describe("#updateStatusCountersSuccessCallback()", function() {
    var data = {
      Clusters: {
        health_report: {
          'Host/host_status/HEALTHY': 1,
          'Host/host_status/UNHEALTHY': 2,
          'Host/host_status/ALERT': 3,
          'Host/host_status/UNKNOWN': 4,
          'Host/stale_config': 5,
          'Host/maintenance_state': 6
        },
        total_hosts: 21
      }
    };

    it("hostsCountMap should be set", function() {
      hostController.updateStatusCountersSuccessCallback(data);
      expect(hostController.get('hostsCountMap')).to.be.eql({
        "HEALTHY": 1,
        "UNHEALTHY": 2,
        "ALERT": 3,
        "UNKNOWN": 4,
        "health-status-RESTART": 5,
        "health-status-PASSIVE_STATE": 6,
        "TOTAL": 21
      });
    });
  });

  describe("#getProperValue()", function() {

    var testCases = [
      {
        input: '>1',
        expected: '1'
      },
      {
        input: '<1',
        expected: '1'
      },
      {
        input: '=1',
        expected: '1'
      },
      {
        input: '1',
        expected: '1'
      }
    ];

    testCases.forEach(function(test) {
      it("value =" + test.input, function() {
        expect(hostController.getProperValue(test.input)).to.be.equal(test.expected);
      });
    });

  });

  describe("#convertMemory()", function() {

    beforeEach(function() {
      sinon.stub(hostController, 'getProperValue', function(input) {
        return input;
      })
    });
    afterEach(function() {
      hostController.getProperValue.restore();
    });

    var testCases = [
      {
        input: 'm',
        expected: 'm'
      },
      {
        input: '1',
        expected: 1048576
      },
      {
        input: '1g',
        expected: 1048576
      },
      {
        input: '1m',
        expected: 1024
      },
      {
        input: '1k',
        expected: 1
      }
    ];

    testCases.forEach(function(test) {
      it("value =" + test.input, function() {
        expect(hostController.convertMemory(test.input)).to.be.equal(test.expected);
      });
    });
  });

  describe("#convertMemoryToRange()", function() {

    beforeEach(function() {
      sinon.stub(hostController, 'rangeConvertNumber', function(arg1) {
        return [arg1, arg1];
      })
    });
    afterEach(function() {
      hostController.rangeConvertNumber.restore();
    });

    var testCases = [
      {
        input: 'm',
        expected: [0, 0]
      },
      {
        input: '1',
        expected: [1048576, 1048576]
      },
      {
        input: '1g',
        expected: [1048576, 1048576]
      },
      {
        input: '1m',
        expected: [1024, 1024]
      },
      {
        input: '1k',
        expected: [1, 1]
      }
    ];

    testCases.forEach(function(test) {
      it("value =" + test.input, function() {
        expect(hostController.convertMemoryToRange(test.input)).to.be.eql(test.expected);
      });
    });
  });

  describe("#rangeConvertNumber()", function() {

    var testCases = [
      {
        value: 'm',
        scale: '',
        expected: [0, 0]
      },
      {
        value: 1,
        scale: '',
        expected: [0.995, 1.004999999]
      },
      {
        value: 1,
        scale: 'g',
        expected: [0.995, 1.004999999]
      },
      {
        value: 1,
        scale: 'm',
        expected: [0.95, 1.04999]
      },
      {
        value: 1,
        scale: 'k',
        expected: [0.95, 1.04999]
      }
    ];

    testCases.forEach(function(test) {
      it("value = " + test.value + 'scale = ' + test.scale, function() {
        expect(hostController.rangeConvertNumber(test.value, test.scale)).to.be.eql(test.expected);
      });
    });
  });

  describe("#getComparisonType()", function() {

    var testCases = [
      {
        value: '1',
        expected: 'EQUAL'
      },
      {
        value: '>',
        expected: 'MORE'
      },
      {
        value: '<',
        expected: 'LESS'
      },
      {
        value: '=',
        expected: 'EQUAL'
      }
    ];

    testCases.forEach(function(test) {
      it("value = " + test.value, function() {
        expect(hostController.getComparisonType(test.value)).to.be.equal(test.expected);
      });
    });
  });

  describe("#filterByComponent()", function() {

    beforeEach(function() {
      sinon.stub(App.db, 'setFilterConditions');
    });
    afterEach(function() {
      App.db.setFilterConditions.restore();
    });

    it("component is null", function() {
      hostController.filterByComponent();
      expect(App.db.setFilterConditions.called).to.be.false;
    });

    it("component exist", function() {
      hostController.set('name', 'ctrl1');
      hostController.filterByComponent(Em.Object.create({
        componentName: 'C1'
      }));
      expect(App.db.setFilterConditions.calledWith('ctrl1', [{
        iColumn: 15,
        value: 'C1:ALL',
        type: 'string'
      }])).to.be.true;
    });
  });

  describe("#filterByStack()", function() {

    beforeEach(function() {
      sinon.stub(App.db, 'setFilterConditions');
    });
    afterEach(function() {
      App.db.setFilterConditions.restore();
    });

    it("displayName is null", function() {
      hostController.filterByStack(null, ['INSTALLED']);
      expect(App.db.setFilterConditions.called).to.be.false;
    });

    it("state is null", function() {
      hostController.filterByStack('stack1', null);
      expect(App.db.setFilterConditions.called).to.be.false;
    });

    it("stack and displayName exist", function() {
      hostController.set('name', 'ctrl1');
      hostController.filterByStack('stack1', ['INSTALLED']);
      expect(App.db.setFilterConditions.calledWith('ctrl1', [
      {
        iColumn: 16,
        value: 'stack1',
        type: 'string'
      },
      {
        iColumn: 17,
        value: ['INSTALLED'],
        type: 'string'
      }])).to.be.true;
    });
  });

  describe("#goToHostAlerts()", function() {

    beforeEach(function() {
      sinon.stub(App.router, 'transitionTo');
    });
    afterEach(function() {
      App.router.transitionTo.restore();
    });

    it("event is null", function() {
      hostController.goToHostAlerts(null);
      expect(App.router.transitionTo.called).to.be.false;
    });

    it("event.context is null", function() {
      hostController.goToHostAlerts({context: null});
      expect(App.router.transitionTo.called).to.be.false;
    });

    it("event.context is exist", function() {
      hostController.goToHostAlerts({context: {}});
      expect(App.router.transitionTo.calledWith('main.hosts.hostDetails.alerts', {})).to.be.true;
    });
  });

  describe("#removeHosts()", function() {

    it("host should be removed", function() {
      var host1 = Em.Object.create({id: 'host1', isChecked: true});
      hostController.set('content', [host1]);
      hostController.set('fullContent', [host1]);
      hostController.removeHosts();
      expect(hostController.get('fullContent')).to.be.empty;
    });
  });

  describe("#checkRemoved()", function() {

    it("host should be removed", function() {
      var host1 = Em.Object.create({id: 'host1', isChecked: true});
      hostController.set('content', [host1]);
      hostController.set('fullContent', [host1]);
      hostController.checkRemoved('host1');
      expect(hostController.get('fullContent')).to.be.empty;
    });
  });

});

});

require.register("test/controllers/main/service/add_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/wizard');
require('controllers/main/service/add_controller');
var addServiceController = null;
var testHelpers = require('test/helpers');

describe('App.AddServiceController', function() {

  beforeEach(function () {
    addServiceController = App.AddServiceController.create({});
  });

  describe('#generateDataForInstallServices', function() {
    var tests = [{
      selected: ["YARN","HBASE"],
      res: {
        "context": Em.I18n.t('requestInfo.installServices'),
        "ServiceInfo": {"state": "INSTALLED"},
        "urlParams": "ServiceInfo/service_name.in(YARN,HBASE)"
      }
    },
    {
      selected: ['OOZIE'],
      res: {
        "context": Em.I18n.t('requestInfo.installServices'),
        "ServiceInfo": {"state": "INSTALLED"},
        "urlParams": "ServiceInfo/service_name.in(OOZIE,HDFS,YARN,MAPREDUCE2)"
      }
    }];
    tests.forEach(function(t){
      it('should generate data with ' + t.selected.join(","), function () {
        expect(addServiceController.generateDataForInstallServices(t.selected)).to.be.eql(t.res);
      });
    });
  });

  describe('#saveServices', function() {
    beforeEach(function() {
      sinon.stub(addServiceController, 'setDBProperty', Em.K);
    });

    afterEach(function() {
      addServiceController.setDBProperty.restore();
    });

    var tests = [
      {
        appService: [
          Em.Object.create({ serviceName: 'HDFS' }),
          Em.Object.create({ serviceName: 'KERBEROS' })
        ],
        stepCtrlContent: Em.Object.create({
          content: Em.A([
            Em.Object.create({ serviceName: 'HDFS', isInstalled: true, isSelected: true }),
            Em.Object.create({ serviceName: 'YARN', isInstalled: false, isSelected: true })
          ])
        }),
        e: {
          selected: ['YARN'],
          installed: ['HDFS', 'KERBEROS']
        }
      },
      {
        appService: [
          Em.Object.create({ serviceName: 'HDFS' }),
          Em.Object.create({ serviceName: 'STORM' })
        ],
        stepCtrlContent: Em.Object.create({
          content: Em.A([
            Em.Object.create({ serviceName: 'HDFS', isInstalled: true, isSelected: true }),
            Em.Object.create({ serviceName: 'YARN', isInstalled: false, isSelected: true }),
            Em.Object.create({ serviceName: 'MAPREDUCE2', isInstalled: false, isSelected: true })
          ])
        }),
        e: {
          selected: ['YARN', 'MAPREDUCE2'],
          installed: ['HDFS', 'STORM']
        }
      }
    ];

    var message = '{0} installed, {1} selected. Installed list should be {2} and selected - {3}';
    tests.forEach(function(test) {

      var installed = test.appService.mapProperty('serviceName');
      var selected = test.stepCtrlContent.get('content').filterProperty('isSelected', true)
        .filterProperty('isInstalled', false).mapProperty('serviceName');

      describe(message.format(installed, selected, test.e.installed, test.e.selected), function() {

        beforeEach(function () {
          sinon.stub(App.Service, 'find').returns(test.appService);
          addServiceController.saveServices(test.stepCtrlContent);
          this.savedServices = addServiceController.setDBProperty.withArgs('services').args[0][1];
        });

        afterEach(function () {
          App.Service.find.restore();
        });

        it(JSON.stringify(test.e.selected) + ' are in the selectedServices', function () {
          expect(this.savedServices.selectedServices).to.have.members(test.e.selected);
        });

        it(JSON.stringify(test.e.installed) + ' are in the installedServices', function () {
          expect(this.savedServices.installedServices).to.have.members(test.e.installed);
        });

      });
    });
  });

  describe('#loadHosts', function () {

    var cases = [
      {
        hosts: {},
        isAjaxRequestSent: false,
        title: 'hosts are already loaded'
      },
      {
        areHostsLoaded: false,
        isAjaxRequestSent: true,
        title: 'hosts aren\'t yet loaded'
      }
    ];

    afterEach(function () {
      addServiceController.getDBProperty.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(addServiceController, 'getDBProperty').withArgs('hosts').returns(item.hosts);
          addServiceController.loadHosts();
          this.args = testHelpers.findAjaxRequest('name', 'hosts.confirmed');
        });

        it('request is ' + (item.isAjaxRequestSent ? '' : 'not') + ' sent', function () {
          expect(Em.isNone(this.args)).to.be.equal(!item.isAjaxRequestSent);
        });
      });
    });

  });

  describe('#loadHostsSuccessCallback', function () {

    it('should load hosts to local db and model', function () {
      var hostComponents = [
          [
            {
              HostRoles: {
                component_name: 'c0',
                state: 'STARTED'
              }
            },
            {
              HostRoles: {
                component_name: 'c1',
                state: 'INSTALLED'
              }
            }
          ],
          [
            {
              HostRoles: {
                component_name: 'c2',
                state: 'STARTED'
              }
            },
            {
              HostRoles: {
                component_name: 'c3',
                state: 'INSTALLED'
              }
            }
          ]
        ],
        response = {
          items: [
            {
              Hosts: {
                host_name: 'h0',
              },
              host_components: hostComponents[0]
            },
            {
              Hosts: {
                host_name: 'h1'
              },
              host_components: hostComponents[1]
            }
          ]
        },
        expected = {
          h0: {
            name: 'h0',
            bootStatus: 'REGISTERED',
            isInstalled: true,
            hostComponents: hostComponents[0],
            id: 0
          },
          h1: {
            name: 'h1',
            bootStatus: 'REGISTERED',
            isInstalled: true,
            hostComponents: hostComponents[1],
            id: 1
          }
        };
      addServiceController.loadHostsSuccessCallback(response);
      var hostsInDb = addServiceController.getDBProperty('hosts');
      var hostsInModel = addServiceController.get('content.hosts');
      expect(hostsInDb).to.eql(expected);
      expect(hostsInModel).to.eql(expected);
    });

  });

  describe('#loadHostsErrorCallback', function () {

    beforeEach(function () {
      sinon.stub(App.ajax, 'defaultErrorHandler', Em.K);
    });

    afterEach(function () {
      App.ajax.defaultErrorHandler.restore();
    });

    it('should execute default error handler', function () {
      addServiceController.loadHostsErrorCallback({status: '500'}, 'textStatus', 'errorThrown', {url: 'url', type: 'GET'});
      expect(App.ajax.defaultErrorHandler.calledOnce).to.be.true;
      expect(App.ajax.defaultErrorHandler.calledWith({status: '500'}, 'url', 'GET', '500')).to.be.true;
    });

  });

  describe('#loadServices', function() {
    var mock = {
      db: {}
    };
    beforeEach(function() {
      this.controller = App.AddServiceController.create({});
      this.mockGetDBProperty = sinon.stub(this.controller, 'getDBProperty');
      sinon.stub(this.controller, 'setDBProperty', function(key, value) {
        mock.db = value;
      });
      sinon.stub(this.controller, 'hasDependentSlaveComponent');
      sinon.stub(App.store, 'fastCommit', Em.K);
      this.mockStackService = sinon.stub(App.StackService, 'find');
      this.mockService = sinon.stub(App.Service, 'find');
    });

    afterEach(function() {
      this.mockGetDBProperty.restore();
      this.controller.setDBProperty.restore();
      this.controller.hasDependentSlaveComponent.restore();
      this.mockStackService.restore();
      this.mockService.restore();
      App.store.fastCommit.restore();
    });

    var tests = [
      {
        appStackService: [
          Em.Object.create({ id: 'HDFS', serviceName: 'HDFS', coSelectedServices: []}),
          Em.Object.create({ id: 'YARN', serviceName: 'YARN', coSelectedServices: ['MAPREDUCE2']}),
          Em.Object.create({ id: 'MAPREDUCE2', serviceName: 'MAPREDUCE2', coSelectedServices: []}),
          Em.Object.create({ id: 'FALCON', serviceName: 'FALCON', coSelectedServices: []}),
          Em.Object.create({ id: 'STORM', serviceName: 'STORM', coSelectedServices: []})
        ],
        appService: [
          Em.Object.create({ id: 'HDFS', serviceName: 'HDFS'}),
          Em.Object.create({ id: 'STORM', serviceName: 'STORM'})
        ],
        servicesFromDB: false,
        serviceToInstall: 'MAPREDUCE2',
        e: {
          selectedServices: ['HDFS', 'YARN', 'MAPREDUCE2', 'STORM'],
          installedServices: ['HDFS', 'STORM']
        },
        m: 'MapReduce selected on Admin -> Stack Versions Page, Yarn service should be selected because it coselected'
      },
      {
        appStackService: [
          Em.Object.create({ id: 'HDFS', serviceName: 'HDFS', coSelectedServices: []}),
          Em.Object.create({ id: 'YARN', serviceName: 'YARN', coSelectedServices: ['MAPREDUCE2']}),
          Em.Object.create({ id: 'HBASE', serviceName: 'HBASE', coSelectedServices: []}),
          Em.Object.create({ id: 'STORM', serviceName: 'STORM', coSelectedServices: []})
        ],
        appService: [
          Em.Object.create({ id: 'HDFS', serviceName: 'HDFS'}),
          Em.Object.create({ id: 'STORM', serviceName: 'STORM'})
        ],
        servicesFromDB: {
          selectedServices: ['HBASE'],
          installedServices: ['HDFS', 'STORM']
        },
        serviceToInstall: null,
        e: {
          selectedServices: ['HDFS', 'HBASE', 'STORM'],
          installedServices: ['HDFS', 'STORM']
        },
        m: 'HDFS and STORM are installed. Select HBASE'
      }
    ];

    tests.forEach(function(test) {
      describe(test.m, function() {

        beforeEach(function () {
          this.mockStackService.returns(test.appStackService);
          this.mockService.returns(test.appService);
          this.mockGetDBProperty.withArgs('services').returns(test.servicesFromDB);
          this.controller.set('serviceToInstall', test.serviceToInstall);
          this.controller.loadServices();
        });

        if (test.servicesFromDB) {
          // verify values for App.StackService
          it(JSON.stringify(test.e.selectedServices) + ' are selected', function () {
            expect(test.appStackService.filterProperty('isSelected', true).mapProperty('serviceName')).to.be.eql(test.e.selectedServices);
          });
          it(JSON.stringify(test.e.installedServices) + ' are installed', function () {
            expect(test.appStackService.filterProperty('isInstalled', true).mapProperty('serviceName')).to.be.eql(test.e.installedServices);
          });
        }
        else {
          // verify saving to local db on first enter to the wizard
          it('selectedServices are saced', function () {
            expect(mock.db.selectedServices).to.be.eql(test.e.selectedServices);
          });
          it('installedServices are saved', function () {
            expect(mock.db.installedServices).to.be.eql(test.e.installedServices);
          });

        }

        it('serviceToInstall is null', function () {
          expect(this.controller.get('serviceToInstall')).to.be.null;
        });

      });
    }, this);
  });

  describe('#checkSecurityStatus', function () {

    var cases = [
      {
        securityEnabled: true,
        skipConfigureIdentitiesStep: false,
        isStep5Disabled: false,
        title: 'security enabled'
      },
      {
        securityEnabled: false,
        skipConfigureIdentitiesStep: true,
        isStep5Disabled: true,
        title: 'security disabled'
      }
    ];

    beforeEach(function () {
      addServiceController.setProperties({
        skipConfigureIdentitiesStep: false,
        isStepDisabled: [
          Em.Object.create({
            step: 5,
            value: false
          })
        ]
      });
    });

    afterEach(function () {
      App.get.restore();
    });

    cases.forEach(function (item) {
      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(App, 'get').withArgs('isKerberosEnabled').returns(item.securityEnabled);
          addServiceController.checkSecurityStatus();
        });

        it('skipConfigureIdentitiesStep is ' + item.skipConfigureIdentitiesStep, function () {
          expect(addServiceController.get('skipConfigureIdentitiesStep')).to.equal(item.skipConfigureIdentitiesStep);
        });

        it('step 5 is ' + (item.isStep5Disabled ? 'disabved' : 'enabled'), function () {
          expect(addServiceController.get('isStepDisabled').findProperty('step', 5).get('value')).to.equal(item.isStep5Disabled);
        });

      });
    });

  });

  describe('#loadServiceConfigGroups', function () {

    var dbMock,
      dbMock2,
      cases = [
        {
          serviceConfigGroups: null,
          areInstalledConfigGroupsLoaded: false,
          title: 'config groups not yet loaded'
        },
        {
          serviceConfigGroups: [],
          areInstalledConfigGroupsLoaded: true,
          title: 'config groups already loaded'
        }
      ];

    beforeEach(function () {
      dbMock = sinon.stub(addServiceController, 'getDBProperties');
      dbMock2 = sinon.stub(addServiceController, 'getDBProperty');
    });

    afterEach(function () {
      dbMock.restore();
      dbMock2.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        dbMock.withArgs(['serviceConfigGroups', 'hosts']).returns({
          hosts: {},
          serviceConfigGroups: item.serviceConfigGroups
        });
        dbMock2.withArgs('hosts').returns({}).
          withArgs('serviceConfigGroups').returns(item.serviceConfigGroups);
        addServiceController.loadServiceConfigGroups();
        expect(addServiceController.get('areInstalledConfigGroupsLoaded')).to.equal(item.areInstalledConfigGroupsLoaded);
      });
    });

  });

  describe('#clearStorageData', function () {
    it('areInstalledConfigGroupsLoaded should be false', function () {
      addServiceController.set('areInstalledConfigGroupsLoaded', true);
      addServiceController.clearStorageData();
      expect(addServiceController.get('areInstalledConfigGroupsLoaded')).to.be.false;
    });
  });

  describe('#loadClients', function () {

    var cases = [
      {
        clients: null,
        contentClients: [],
        saveClientsCallCount: 1,
        title: 'no clients info in local db'
      },
      {
        clients: [{}],
        contentClients: [{}],
        saveClientsCallCount: 0,
        title: 'clients info saved in local db'
      }
    ];

    cases.forEach(function (item) {

      describe(item.title, function () {

        beforeEach(function () {
          sinon.stub(addServiceController, 'getDBProperty').withArgs('clientInfo').returns(item.clients);
          sinon.stub(addServiceController, 'saveClients', Em.K);
          addServiceController.set('content.clients', []);
          addServiceController.loadClients();
        });

        afterEach(function () {
          addServiceController.getDBProperty.restore();
          addServiceController.saveClients.restore();
        });

        it('content.clients', function () {
          expect(addServiceController.get('content.clients', [])).to.eql(item.contentClients);
        });

        it('saveClients call', function () {
          expect(addServiceController.saveClients.callCount).to.equal(item.saveClientsCallCount);
        });

      });

    });

  });

  describe('#getServicesBySelectedSlaves', function () {

    beforeEach(function () {
      sinon.stub(App.StackServiceComponent, 'find').returns([
        Em.Object.create({
          componentName: 'c1',
          serviceName: 's1'
        }),
        Em.Object.create({
          componentName: 'c2',
          serviceName: 's2'
        }),
        Em.Object.create({
          componentName: 'c3',
          serviceName: 's3'
        }),
        Em.Object.create({
          componentName: 'c4',
          serviceName: 's1'
        })
      ]);
    });

    [
      {
        title: 'should return empty array',
        sch: [],
        expect: []
      },
      {
        title: 'should return empty array if component is absent in StackServiceComponent model',
        sch: [
          {
            componentName: 'c5',
            hosts: [
              {
                isInstalled: false
              },
              {
                isInstalled: true
              }
            ]
          },
        ],
        expect: []
      },
      {
        title: 'should return services for not installed slaves',
        sch: [
          {
            componentName: 'c1',
            hosts: [
              {
                isInstalled: false
              },
              {
                isInstalled: true
              }
            ]
          },
          {
            componentName: 'c2',
            hosts: [
              {
                isInstalled: false
              },
              {
                isInstalled: true
              }
            ]
          },
          {
            componentName: 'c4',
            hosts: [
              {
                isInstalled: false
              },
              {
                isInstalled: true
              }
            ]
          }
        ],
        expect: ['s1', 's2']
      }
    ].forEach(function (test) {
          describe(test.title, function () {
            it(function () {
              addServiceController.set('content.slaveComponentHosts', test.sch);
              expect(addServiceController.getServicesBySelectedSlaves()).to.eql(test.expect);
            });
          })
        });

  });

});

});

require.register("test/controllers/main/service/info/config_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/service/info/configs');
var batchUtils = require('utils/batch_scheduled_requests');
var mainServiceInfoConfigsController = null;
var testHelpers = require('test/helpers');

function getController() {
  return App.MainServiceInfoConfigsController.create({
    dependentServiceNames: [],
    loadDependentConfigs: function () {
      return {done: Em.K}
    },
    loadConfigTheme: function () {
      return $.Deferred().resolve().promise();
    }
  });
}

describe("App.MainServiceInfoConfigsController", function () {

  beforeEach(function () {
    sinon.stub(App.themesMapper, 'generateAdvancedTabs').returns(Em.K);
    sinon.stub(App.router.get('mainController'), 'startPolling');
    sinon.stub(App.router.get('mainController'), 'stopPolling');
    mainServiceInfoConfigsController = getController();
  });

  App.TestAliases.testAsComputedAlias(getController(), 'serviceConfigs', 'App.config.preDefinedServiceConfigs', 'array');

  afterEach(function() {
    App.themesMapper.generateAdvancedTabs.restore();
    App.router.get('mainController').startPolling.restore();
    App.router.get('mainController').stopPolling.restore();
  });

  describe("#getHash", function () {

    var tests = [
      {
        msg: "properties only used for ui purpose should be excluded from hash",
        configs: [
          Em.Object.create({
            id: "hive.llap.daemon.task.scheduler.enable.preemption",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          }),
          Em.Object.create({
            id: "ambari.copy.hive.llap.daemon.num.executors",
            isRequiredByAgent: false,
            isFinal: false,
            value: ''
          })
        ],
        result: JSON.stringify({
          'hive.llap.daemon.task.scheduler.enable.preemption': {
            value: '',
            overrides: [],
            isFinal: false
          }
        })
      },
      {
        msg: "properties should be sorted in alphabetical order",
        configs: [
          Em.Object.create({
            id: "b.b",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          }),
          Em.Object.create({
            id: "b.a",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          }),
          Em.Object.create({
            id: "b.c",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          }),
          Em.Object.create({
            id: "a.b",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          })
        ],
        result: JSON.stringify({
          'a.b': {
            value: '',
            overrides: [],
            isFinal: false
          },
          'b.a': {
            value: '',
            overrides: [],
            isFinal: false
          },
          'b.b': {
            value: '',
            overrides: [],
            isFinal: false
          },
          'b.c': {
            value: '',
            overrides: [],
            isFinal: false
          }
        })
      },{
        msg: "properties without id should be sorted with",
        configs: [
          Em.Object.create({
            isRequiredByAgent: true,
            isFinal: false,
            value: '',
            name: 'name',
            filename: 'filename'
          }),
          Em.Object.create({
            id: "a",
            isRequiredByAgent: true,
            isFinal: false,
            value: ''
          })
        ],
        result: JSON.stringify({
          'a': {
            value: '',
            overrides: [],
            isFinal: false
          },
          'name__filename': {
            value: '',
            overrides: [],
            isFinal: false
          }
        })
      }
    ];

    afterEach(function () {
      mainServiceInfoConfigsController.set('selectedService', '');
    });

    tests.forEach(function (t) {
      it(t.msg, function () {
        mainServiceInfoConfigsController.set('selectedService', {configs: t.configs});
        expect(mainServiceInfoConfigsController.getHash()).to.equal(t.result);
      });
    });
  });


  describe("#showSavePopup", function () {
    var tests = [
      {
        transitionCallback: false,
        callback: false,
        action: "onSave",
        m: "save configs without transitionCallback/callback",
        results: [
          {
            method: "restartServicePopup",
            called: true
          }
        ]
      },
      {
        transitionCallback: true,
        callback: true,
        action: "onSave",
        m: "save configs with transitionCallback/callback",
        results: [
          {
            method: "restartServicePopup",
            called: true
          }
        ]
      },
      {
        transitionCallback: false,
        callback: false,
        action: "onDiscard",
        m: "discard changes without transitionCallback/callback",
        results: [
          {
            method: "restartServicePopup",
            called: false
          }
        ]
      },
      {
        transitionCallback: false,
        callback: true,
        action: "onDiscard",
        m: "discard changes with callback",
        results: [
          {
            method: "restartServicePopup",
            called: false
          },
          {
            method: "callback",
            called: true
          },
          {
            field: "hash",
            value: "hash"
          }
        ]
      },
      {
        transitionCallback: true,
        callback: false,
        action: "onDiscard",
        m: "discard changes with transitionCallback",
        results: [
          {
            method: "restartServicePopup",
            called: false
          },
          {
            method: "transitionCallback",
            called: true
          }
        ]
      }
    ];

    beforeEach(function () {
      mainServiceInfoConfigsController.reopen({
        passwordConfigsAreChanged: false
      });
      sinon.stub(mainServiceInfoConfigsController, "get", function(key) {
        return key === 'isSubmitDisabled' ? false : Em.get(mainServiceInfoConfigsController, key);
      });
      sinon.stub(mainServiceInfoConfigsController, "restartServicePopup", Em.K);
      sinon.stub(mainServiceInfoConfigsController, "getHash", function () {
        return "hash"
      });
      sinon.stub(mainServiceInfoConfigsController, 'trackRequest');
    });

    afterEach(function () {
      mainServiceInfoConfigsController.get.restore();
      mainServiceInfoConfigsController.restartServicePopup.restore();
      mainServiceInfoConfigsController.getHash.restore();
      mainServiceInfoConfigsController.trackRequest.restore();
    });

    tests.forEach(function (t) {
      t.results.forEach(function (r) {
        describe(t.m + " " + r.method + " " + r.field, function () {

          beforeEach(function () {
            if (t.callback) {
              t.callback = sinon.stub();
            }
            if (t.transitionCallback) {
              t.transitionCallback = sinon.stub();
            }
            mainServiceInfoConfigsController.showSavePopup(t.transitionCallback, t.callback)[t.action]();
          });


          if (r.method) {
            if (r.method === 'callback') {
              it('callback is ' + (r.called ? '' : 'not') + ' called once', function () {
                expect(t.callback.calledOnce).to.equal(r.called);
              });
            }
            else {
              if (r.method === 'transitionCallback') {
                it('transitionCallback is ' + (r.called ? '' : 'not') + ' called once', function () {
                  expect(t.transitionCallback.calledOnce).to.equal(r.called);
                });
              }
              else {
                it(r.method + ' is ' + (r.called ? '' : 'not') + ' called once', function () {
                  expect(mainServiceInfoConfigsController[r.method].calledOnce).to.equal(r.called);
                });
              }
            }
          }
          else {
            if (r.field) {
              it(r.field + ' is equal to ' + r.value, function () {
                expect(mainServiceInfoConfigsController.get(r.field)).to.equal(r.value);
              });

            }
          }
        }, this);
      });
    }, this);
  });

  describe("#hasUnsavedChanges", function () {
    var cases = [
      {
        hash: null,
        hasUnsavedChanges: false,
        title: 'configs not rendered'
      },
      {
        hash: 'hash1',
        hasUnsavedChanges: true,
        title: 'with unsaved'
      },
      {
        hash: 'hash',
        hasUnsavedChanges: false,
        title: 'without unsaved'
      }
    ];

    beforeEach(function () {
      sinon.stub(mainServiceInfoConfigsController, "getHash", function () {
        return "hash"
      });
    });
    afterEach(function () {
      mainServiceInfoConfigsController.getHash.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        mainServiceInfoConfigsController.set('hash', item.hash);
        expect(mainServiceInfoConfigsController.hasUnsavedChanges()).to.equal(item.hasUnsavedChanges);
      });
    });
  });

  describe("#showComponentsShouldBeRestarted", function () {

    var tests = [
      {
        input: {
          context: {
            restartRequiredHostsAndComponents: {
              'publicHostName1': ['TaskTracker'],
              'publicHostName2': ['JobTracker', 'TaskTracker']
            }
          }
        },
        components: "2 TaskTrackers, 1 JobTracker",
        text: Em.I18n.t('service.service.config.restartService.shouldBeRestarted').format(Em.I18n.t('common.components'))
      },
      {
        input: {
          context: {
            restartRequiredHostsAndComponents: {
              'publicHostName1': ['TaskTracker']
            }
          }
        },
        components: "1 TaskTracker",
        text: Em.I18n.t('service.service.config.restartService.shouldBeRestarted').format(Em.I18n.t('common.component'))
      }
    ];

    beforeEach(function () {
      sinon.stub(mainServiceInfoConfigsController, "showItemsShouldBeRestarted", Em.K);
    });
    afterEach(function () {
      mainServiceInfoConfigsController.showItemsShouldBeRestarted.restore();
    });

    tests.forEach(function (t) {
      it("trigger showItemsShouldBeRestarted popup with components", function () {
        mainServiceInfoConfigsController.showComponentsShouldBeRestarted(t.input);
        expect(mainServiceInfoConfigsController.showItemsShouldBeRestarted.calledWith(t.components, t.text)).to.equal(true);
      });
    });
  });

  describe("#showHostsShouldBeRestarted", function () {

    var tests = [
      {
        input: {
          context: {
            restartRequiredHostsAndComponents: {
              'publicHostName1': ['TaskTracker'],
              'publicHostName2': ['JobTracker', 'TaskTracker']
            }
          }
        },
        hosts: "publicHostName1, publicHostName2",
        text: Em.I18n.t('service.service.config.restartService.shouldBeRestarted').format(Em.I18n.t('common.hosts'))
      },
      {
        input: {
          context: {
            restartRequiredHostsAndComponents: {
              'publicHostName1': ['TaskTracker']
            }
          }
        },
        hosts: "publicHostName1",
        text: Em.I18n.t('service.service.config.restartService.shouldBeRestarted').format(Em.I18n.t('common.host'))
      }
    ];

    beforeEach(function () {
      sinon.stub(mainServiceInfoConfigsController, "showItemsShouldBeRestarted", Em.K);
    });
    afterEach(function () {
      mainServiceInfoConfigsController.showItemsShouldBeRestarted.restore();
    });

    tests.forEach(function (t) {
      it("trigger showItemsShouldBeRestarted popup with hosts", function () {
        mainServiceInfoConfigsController.showHostsShouldBeRestarted(t.input);
        expect(mainServiceInfoConfigsController.showItemsShouldBeRestarted.calledWith(t.hosts, t.text)).to.equal(true);
      });
    });
  });

  describe("#rollingRestartStaleConfigSlaveComponents", function () {
    var tests = [
      {
        componentName: {
          context: "ComponentName"
        },
        displayName: "displayName",
        passiveState: "ON"
      },
      {
        componentName: {
          context: "ComponentName1"
        },
        displayName: "displayName1",
        passiveState: "OFF"
      }
    ];

    beforeEach(function () {
      mainServiceInfoConfigsController.set("content", {displayName: "", passiveState: ""});
      sinon.stub(batchUtils, "launchHostComponentRollingRestart", Em.K);
    });
    afterEach(function () {
      batchUtils.launchHostComponentRollingRestart.restore();
    });
    tests.forEach(function (t) {
      it("trigger rollingRestartStaleConfigSlaveComponents", function () {
        mainServiceInfoConfigsController.set("content.displayName", t.displayName);
        mainServiceInfoConfigsController.set("content.passiveState", t.passiveState);
        mainServiceInfoConfigsController.rollingRestartStaleConfigSlaveComponents(t.componentName);
        expect(batchUtils.launchHostComponentRollingRestart.calledWith(t.componentName.context, t.displayName, t.passiveState === "ON", true)).to.equal(true);
      });
    });
  });

  describe("#restartAllStaleConfigComponents", function () {

    beforeEach(function () {
      sinon.stub(batchUtils, "restartAllServiceHostComponents", Em.K);
    });

    afterEach(function () {
      batchUtils.restartAllServiceHostComponents.restore();
    });

    it("trigger restartAllServiceHostComponents", function () {
      mainServiceInfoConfigsController.restartAllStaleConfigComponents().onPrimary();
      expect(batchUtils.restartAllServiceHostComponents.calledOnce).to.equal(true);
    });

    describe("trigger check last check point warning before triggering restartAllServiceHostComponents", function () {
      var mainConfigsControllerHdfsStarted = App.MainServiceInfoConfigsController.create({
        content: {
          serviceName: "HDFS",
          hostComponents: [{
            componentName: 'NAMENODE',
            workStatus: 'STARTED'
          }],
          restartRequiredHostsAndComponents: {
            "host1": ['NameNode'],
            "host2": ['DataNode', 'ZooKeeper']
          }
        }
      });
      var mainServiceItemController = App.MainServiceItemController.create({});

      beforeEach(function () {
        sinon.stub(mainServiceItemController, 'checkNnLastCheckpointTime', function() {
          return true;
        });
        sinon.stub(App.router, 'get', function(k) {
          if ('mainServiceItemController' === k) {
            return mainServiceItemController;
          }
          return Em.get(App.router, k);
        });
        mainConfigsControllerHdfsStarted.restartAllStaleConfigComponents();
      });

      afterEach(function () {
        mainServiceItemController.checkNnLastCheckpointTime.restore();
        App.router.get.restore();
      });

      it('checkNnLastCheckpointTime is called once', function () {
        expect(mainServiceItemController.checkNnLastCheckpointTime.calledOnce).to.equal(true);
      });


    });
  });

  describe("#doCancel", function () {
    beforeEach(function () {
      sinon.stub(Em.run, 'once', Em.K);
      sinon.stub(mainServiceInfoConfigsController, 'loadSelectedVersion');
      sinon.spy(mainServiceInfoConfigsController, 'clearRecommendations');
      mainServiceInfoConfigsController.set('groupsToSave', { HDFS: 'my cool group'});
      mainServiceInfoConfigsController.set('recommendations', Em.A([{name: 'prop_1'}]));
      mainServiceInfoConfigsController.doCancel();
    });
    afterEach(function () {
      Em.run.once.restore();
      mainServiceInfoConfigsController.loadSelectedVersion.restore();
      mainServiceInfoConfigsController.clearRecommendations.restore();
    });

    it("should launch recommendations cleanup", function() {
      expect(mainServiceInfoConfigsController.clearRecommendations.calledOnce).to.be.true;
    });

    it("should clear dependent configs", function() {
      expect(App.isEmptyObject(mainServiceInfoConfigsController.get('recommendations'))).to.be.true;
    });
  });

  describe("#putChangedConfigurations", function () {
      var sc = [
      Em.Object.create({
        configs: [
          Em.Object.create({
            name: '_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: '_newsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: '_maxnewsize',
            value: '1024m'
          })
        ]
      })
    ],
    scExc = [
      Em.Object.create({
        configs: [
          Em.Object.create({
            name: 'hadoop_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: 'yarn_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: 'nodemanager_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: 'resourcemanager_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: 'apptimelineserver_heapsize',
            value: '1024m'
          }),
          Em.Object.create({
            name: 'jobhistory_heapsize',
            value: '1024m'
          })
        ]
      })
    ];
    beforeEach(function () {
      sinon.stub(App.router, 'getClusterName', function() {
        return 'clName';
      });
    });
    afterEach(function () {
      App.router.getClusterName.restore();
    });
    it("ajax request to put cluster cfg", function () {
      mainServiceInfoConfigsController.set('stepConfigs', sc);
      mainServiceInfoConfigsController.putChangedConfigurations([]);
      var args = testHelpers.findAjaxRequest('name', 'common.across.services.configurations');
      expect(args[0]).exists;
    });
    it('values should be parsed', function () {
      mainServiceInfoConfigsController.set('stepConfigs', sc);
      mainServiceInfoConfigsController.putChangedConfigurations([]);
      expect(mainServiceInfoConfigsController.get('stepConfigs')[0].get('configs').mapProperty('value').uniq()).to.eql(['1024m']);
    });
    it('values should not be parsed', function () {
      mainServiceInfoConfigsController.set('stepConfigs', scExc);
      mainServiceInfoConfigsController.putChangedConfigurations([]);
      expect(mainServiceInfoConfigsController.get('stepConfigs')[0].get('configs').mapProperty('value').uniq()).to.eql(['1024m']);
    });
  });

  describe("#isDirChanged", function() {

    describe("when service name is HDFS", function() {
      beforeEach(function() {
        mainServiceInfoConfigsController.set('content', Ember.Object.create ({ serviceName: 'HDFS' }));
      });

      describe("for hadoop 2", function() {

        var tests = [
          {
            it: "should set dirChanged to false if none of the properties exist",
            expect: false,
            config: Ember.Object.create ({})
          },
          {
            it: "should set dirChanged to true if dfs.namenode.name.dir is not default",
            expect: true,
            config: Ember.Object.create ({
              name: 'dfs.namenode.name.dir',
              isNotDefaultValue: true
            })
          },
          {
            it: "should set dirChanged to false if dfs.namenode.name.dir is default",
            expect: false,
            config: Ember.Object.create ({
              name: 'dfs.namenode.name.dir',
              isNotDefaultValue: false
            })
          },
          {
            it: "should set dirChanged to true if dfs.namenode.checkpoint.dir is not default",
            expect: true,
            config: Ember.Object.create ({
              name: 'dfs.namenode.checkpoint.dir',
              isNotDefaultValue: true
            })
          },
          {
            it: "should set dirChanged to false if dfs.namenode.checkpoint.dir is default",
            expect: false,
            config: Ember.Object.create ({
              name: 'dfs.namenode.checkpoint.dir',
              isNotDefaultValue: false
            })
          },
          {
            it: "should set dirChanged to true if dfs.datanode.data.dir is not default",
            expect: true,
            config: Ember.Object.create ({
              name: 'dfs.datanode.data.dir',
              isNotDefaultValue: true
            })
          },
          {
            it: "should set dirChanged to false if dfs.datanode.data.dir is default",
            expect: false,
            config: Ember.Object.create ({
              name: 'dfs.datanode.data.dir',
              isNotDefaultValue: false
            })
          }
        ];

        beforeEach(function() {
          sinon.stub(App, 'get').returns(true);
        });

        afterEach(function() {
          App.get.restore();
        });

        tests.forEach(function(test) {
          it(test.it, function() {
            mainServiceInfoConfigsController.set('stepConfigs', [Ember.Object.create ({ configs: [test.config], serviceName: 'HDFS' })]);
            expect(mainServiceInfoConfigsController.isDirChanged()).to.equal(test.expect);
          })
        });
      });
    });

  });

  describe("#formatConfigValues", function () {
    var t = {
      configs: [
        Em.Object.create({ name: "p1", value: " v1 v1 ", displayType: "" }),
        Em.Object.create({ name: "p2", value: true, displayType: "" }),
        Em.Object.create({ name: "p3", value: " d1 ", displayType: "directory" }),
        Em.Object.create({ name: "p4", value: " d1 d2 d3 ", displayType: "directories" }),
        Em.Object.create({ name: "p5", value: " v1 ", displayType: "password" }),
        Em.Object.create({ name: "p6", value: " v ", displayType: "host" }),
        Em.Object.create({ name: "javax.jdo.option.ConnectionURL", value: " v1 ", displayType: "string" }),
        Em.Object.create({ name: "oozie.service.JPAService.jdbc.url", value: " v1 ", displayType: "string" })
      ],
      result: [
        Em.Object.create({ name: "p1", value: " v1 v1", displayType: "" }),
        Em.Object.create({ name: "p2", value: "true", displayType: "" }),
        Em.Object.create({ name: "p3", value: "d1", displayType: "directory" }),
        Em.Object.create({ name: "p4", value: "d1,d2,d3", displayType: "directories" }),
        Em.Object.create({ name: "p5", value: " v1 ", displayType: "password" }),
        Em.Object.create({ name: "p6", value: "v", displayType: "host" }),
        Em.Object.create({ name: "javax.jdo.option.ConnectionURL", value: " v1", displayType: "string" }),
        Em.Object.create({ name: "oozie.service.JPAService.jdbc.url", value: " v1", displayType: "string" })
      ]
    };

    it("format config values", function () {
      mainServiceInfoConfigsController.formatConfigValues(t.configs);
      expect(t.configs).to.deep.equal(t.result);
    });

  });

  describe("#checkOverrideProperty", function () {
    var tests = [{
      overrideToAdd: {
        name: "name1",
        filename: "filename1"
      },
      componentConfig: {
        configs: [
          {
            name: "name1",
            filename: "filename2"
          },
          {
            name: "name1",
            filename: "filename1"
          }
        ]
      },
      add: true,
      m: "add property"
    },
      {
        overrideToAdd: {
          name: "name1"
        },
        componentConfig: {
          configs: [
            {
              name: "name2"
            }
          ]
        },
        add: false,
        m: "don't add property, different names"
      },
      {
        overrideToAdd: {
          name: "name1",
          filename: "filename1"
        },
        componentConfig: {
          configs: [
            {
              name: "name1",
              filename: "filename2"
            }
          ]
        },
        add: false,
        m: "don't add property, different filenames"
      },
      {
        overrideToAdd: null,
        componentConfig: {},
        add: false,
        m: "don't add property, overrideToAdd is null"
      }];

    beforeEach(function() {
      sinon.stub(App.config,"createOverride", Em.K)
    });
    afterEach(function() {
      App.config.createOverride.restore();
    });
    tests.forEach(function(t) {
      it(t.m, function() {
        mainServiceInfoConfigsController.set("overrideToAdd", t.overrideToAdd);
        mainServiceInfoConfigsController.checkOverrideProperty(t.componentConfig);
        if(t.add) {
          expect(App.config.createOverride.calledWith(t.overrideToAdd)).to.equal(true);
          expect(mainServiceInfoConfigsController.get("overrideToAdd")).to.equal(null);
        } else {
          expect(App.config.createOverride.calledOnce).to.equal(false);
        }
      });
    });
  });

  describe("#trackRequest()", function () {
    after(function(){
      mainServiceInfoConfigsController.get('requestsInProgress').clear();
    });
    it("should set requestsInProgress", function () {
      var dfd = $.Deferred();
      mainServiceInfoConfigsController.get('requestsInProgress').clear();
      mainServiceInfoConfigsController.trackRequest(dfd);
      expect(mainServiceInfoConfigsController.get('requestsInProgress')[0]).to.eql(
        {
          request: dfd,
          id: 0,
          status: 'pending',
          completed: false
        }
      );
    });
    it('should update request status when it become resolved', function() {
      var request = $.Deferred();
      mainServiceInfoConfigsController.get('requestsInProgress').clear();
      mainServiceInfoConfigsController.trackRequest(request);
      expect(mainServiceInfoConfigsController.get('requestsInProgress')[0]).to.eql({
        request: request,
        id: 0,
        status: 'pending',
        completed: false
      });
      request.resolve();
      expect(mainServiceInfoConfigsController.get('requestsInProgress')[0]).to.eql({
        request: request,
        id: 0,
        status: 'resolved',
        completed: true
      });
    });
  });

  describe('#trackRequestChain', function() {
    beforeEach(function() {
      mainServiceInfoConfigsController.get('requestsInProgress').clear();
    });
    it('should set 2 requests in to requestsInProgress list', function() {
      mainServiceInfoConfigsController.trackRequestChain($.Deferred());
      expect(mainServiceInfoConfigsController.get('requestsInProgress')).to.have.length(2);
    });
    it('should update status for both requests when tracked requests become resolved', function() {
      var request = $.Deferred(),
          requests;
      mainServiceInfoConfigsController.trackRequestChain(request);
      requests = mainServiceInfoConfigsController.get('requestsInProgress');
      assert.deepEqual(requests.mapProperty('status'), ['pending', 'pending'], 'initial statuses');
      assert.deepEqual(requests.mapProperty('completed'), [false, false], 'initial completed');
      request.reject();
      assert.deepEqual(requests.mapProperty('status'), ['rejected', 'resolved'], 'update status when rejected');
      assert.deepEqual(requests.mapProperty('completed'), [true, true], 'initial complete are false');
    });
  });

  describe('#abortRequests', function() {
    beforeEach(function() {
      mainServiceInfoConfigsController.get('requestsInProgress').clear();
    });
    it('should clear requests when abort called', function() {
      mainServiceInfoConfigsController.trackRequest($.Deferred());
      mainServiceInfoConfigsController.abortRequests();
      expect(mainServiceInfoConfigsController.get('requestsInProgress')).to.have.length(0);
    });
    it('should abort requests which are not finished', function() {
      var pendingRequest = {
        abort: sinon.spy(),
        readyState: 0,
        state: sinon.spy(),
        always: sinon.spy()
      };
      var finishedRequest = {
        abort: sinon.spy(),
        readyState: 4,
        state: sinon.spy(),
        always: sinon.spy()
      };
      mainServiceInfoConfigsController.trackRequest(pendingRequest);
      mainServiceInfoConfigsController.trackRequest(finishedRequest);
      mainServiceInfoConfigsController.abortRequests();
      expect(pendingRequest.abort.calledOnce).to.be.true;
      expect(finishedRequest.abort.calledOnce).to.be.false;
    });
  });

  describe("#setCompareDefaultGroupConfig", function() {
    beforeEach(function() {
      sinon.stub(mainServiceInfoConfigsController, "getComparisonConfig").returns("compConfig");
      sinon.stub(mainServiceInfoConfigsController, "getMockComparisonConfig").returns("mockConfig");
      sinon.stub(mainServiceInfoConfigsController, "hasCompareDiffs").returns(true);
    });
    afterEach(function() {
      mainServiceInfoConfigsController.getComparisonConfig.restore();
      mainServiceInfoConfigsController.getMockComparisonConfig.restore();
      mainServiceInfoConfigsController.hasCompareDiffs.restore();
    });
    it("empty service config passed, expect that setCompareDefaultGroupConfig will not run anything", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({}).compareConfigs.length).to.equal(0);
    });
    it("empty service config and comparison passed, expect that setCompareDefaultGroupConfig will not run anything", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({},{}).compareConfigs).to.eql(["compConfig"]);
    });
    it("expect that serviceConfig.compareConfigs will be getMockComparisonConfig", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({isUserProperty: true}, null)).to.eql({compareConfigs: ["mockConfig"], isUserProperty: true, isComparison: true, hasCompareDiffs: true});
    });
    it("expect that serviceConfig.compareConfigs will be getComparisonConfig", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({isUserProperty: true}, {})).to.eql({compareConfigs: ["compConfig"], isUserProperty: true, isComparison: true, hasCompareDiffs: true});
    });
    it("expect that serviceConfig.compareConfigs will be getComparisonConfig (2)", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({isReconfigurable: true}, {})).to.eql({compareConfigs: ["compConfig"], isReconfigurable: true, isComparison: true, hasCompareDiffs: true});
    });
    it("expect that serviceConfig.compareConfigs will be getComparisonConfig (3)", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({isReconfigurable: true, isMock: true}, {})).to.eql({compareConfigs: ["compConfig"], isReconfigurable: true, isMock: true, isComparison: true, hasCompareDiffs: true});
    });
    it("property was created during upgrade and have no comparison, compare with 'Undefined' value should be created", function() {
      expect(mainServiceInfoConfigsController.setCompareDefaultGroupConfig({name: 'prop1', isUserProperty: false}, null)).to.eql({
        name: 'prop1', isUserProperty: false, compareConfigs: ["mockConfig"],
        isComparison: true, hasCompareDiffs: true
      });
    });
  });

  describe('#showSaveConfigsPopup', function () {

    var bodyView;

    describe('#bodyClass', function () {
      beforeEach(function() {
        sinon.stub(App.StackService, 'find').returns([{dependentServiceNames: []}]);
        // default implementation
        bodyView = mainServiceInfoConfigsController.showSaveConfigsPopup().get('bodyClass').create({
          parentView: Em.View.create()
        });
      });

      afterEach(function() {
        App.StackService.find.restore();
      });

      describe('#componentsFilterSuccessCallback', function () {
        it('check components with unknown state', function () {
          bodyView = mainServiceInfoConfigsController.showSaveConfigsPopup('', true, '', {}, '', 'unknown', '').get('bodyClass').create({
            didInsertElement: Em.K,
            parentView: Em.View.create()
          });
          bodyView.componentsFilterSuccessCallback({
            items: [
              {
                ServiceComponentInfo: {
                  total_count: 4,
                  started_count: 2,
                  installed_count: 1,
                  component_name: 'c1'
                },
                host_components: [
                  {HostRoles: {host_name: 'h1'}}
                ]
              }
            ]
          });
          var unknownHosts = bodyView.get('unknownHosts');
          expect(unknownHosts.length).to.equal(1);
          expect(unknownHosts[0]).to.eql({name: 'h1', components: 'C1'});
        });
      });
    });
  });

  describe('#errorsCount', function () {

    it('should ignore configs with widgets (enhanced configs)', function () {

      mainServiceInfoConfigsController.reopen({selectedService: Em.Object.create({
        configsWithErrors: Em.A([
          Em.Object.create({widget: {}}),
          Em.Object.create({widget: null})
        ])
      })});

      expect(mainServiceInfoConfigsController.get('errorsCount')).to.equal(1);

    });

  });

  describe('#_onLoadComplete', function () {

    beforeEach(function () {
      sinon.stub(Em.run, 'next', Em.K);
      mainServiceInfoConfigsController.setProperties({
        dataIsLoaded: false,
        versionLoaded: false,
        isInit: true
      });
    });

    afterEach(function () {
      Em.run.next.restore();
    });

    it('should update flags', function () {

      mainServiceInfoConfigsController._onLoadComplete();
      expect(mainServiceInfoConfigsController.get('dataIsLoaded')).to.be.true;
      expect(mainServiceInfoConfigsController.get('versionLoaded')).to.be.true;
      expect(mainServiceInfoConfigsController.get('isInit')).to.be.false;

    });

  });

  describe('#hasCompareDiffs', function () {

    it('should return false for `password`-configs', function () {

      var hasCompareDiffs = mainServiceInfoConfigsController.hasCompareDiffs({displayType: 'password'}, {});
      expect(hasCompareDiffs).to.be.false;

    });

  });

  describe('#getServicesDependencies', function() {
    var createService = function(serviceName, dependencies) {
      return Em.Object.create({
        serviceName: serviceName,
        dependentServiceNames: dependencies || []
      });
    };
    var stackServices = [
      createService('STORM', ['RANGER', 'ATLAS', 'ZOOKEEPER']),
      createService('RANGER', ['HIVE', 'HDFS']),
      createService('HIVE', ['YARN']),
      createService('ZOOKEEPER', ['HDFS']),
      createService('ATLAS'),
      createService('HDFS', ['ZOOKEEPER']),
      createService('YARN', ['HIVE'])
    ];
    beforeEach(function() {
      sinon.stub(App.StackService, 'find', function(serviceName) {
        return stackServices.findProperty('serviceName', serviceName);
      });
    });
    afterEach(function() {
      App.StackService.find.restore();
    });

    it('should returns all service dependencies STORM service', function() {
      var result = mainServiceInfoConfigsController.getServicesDependencies('STORM');
      expect(result).to.be.eql(['RANGER', 'ATLAS', 'ZOOKEEPER', 'HIVE', 'HDFS', 'YARN']);
    });

    it('should returns all service dependencies for ATLAS', function() {
      var result = mainServiceInfoConfigsController.getServicesDependencies('ATLAS');
      expect(result).to.be.eql([]);
    });

    it('should returns all service dependencies for RANGER', function() {
      var result = mainServiceInfoConfigsController.getServicesDependencies('RANGER');
      expect(result).to.be.eql(['HIVE', 'HDFS', 'YARN', 'ZOOKEEPER']);
    });

    it('should returns all service dependencies for YARN', function() {
      var result = mainServiceInfoConfigsController.getServicesDependencies('YARN');
      expect(result).to.be.eql(['HIVE']);
    });
  });
});

});

require.register("test/controllers/main/service/info/summary_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
require('controllers/main/service/info/summary');
var testHelpers = require('test/helpers');
function getController() {
  return App.MainServiceInfoSummaryController.create();
}

describe('App.MainServiceInfoSummaryController', function () {

  var controller;

  beforeEach(function () {
    controller = App.MainServiceInfoSummaryController.create();
  });

App.TestAliases.testAsComputedOr(getController(), 'showTimeRangeControl', ['!isServiceWithEnhancedWidgets', 'someWidgetGraphExists']);

  describe('#setRangerPlugins', function () {

    var cases = [
      {
        isLoaded: true,
        isRangerPluginsArraySet: false,
        expectedIsRangerPluginsArraySet: true,
        title: 'cluster loaded, ranger plugins array not set'
      },
      {
        isLoaded: false,
        isRangerPluginsArraySet: false,
        expectedIsRangerPluginsArraySet: false,
        title: 'cluster not loaded, ranger plugins array not set'
      },
      {
        isLoaded: false,
        isRangerPluginsArraySet: true,
        expectedIsRangerPluginsArraySet: true,
        title: 'cluster not loaded, ranger plugins array set'
      },
      {
        isLoaded: true,
        isRangerPluginsArraySet: true,
        expectedIsRangerPluginsArraySet: true,
        title: 'cluster loaded, ranger plugins array set'
      }
    ];

    beforeEach(function () {
      sinon.stub(App.Service, 'find').returns([
        Em.Object.create({
          serviceName: 'HDFS'
        }),
        Em.Object.create({
          serviceName: 'YARN'
        }),
        Em.Object.create({
          serviceName: 'HIVE'
        })
      ]);
      sinon.stub(App.StackService, 'find').returns([
        Em.Object.create({
          serviceName: 'HDFS',
          displayName: 'HDFS',
          configTypes: {
            'ranger-hdfs-plugin-properties': {}
          }
        }),
        Em.Object.create({
          serviceName: 'HIVE',
          displayName: 'Hive',
          configTypes: {
            'hive-env': {}
          }
        }),
        Em.Object.create({
          serviceName: 'HBASE',
          displayName: 'HBase',
          configTypes: {
            'ranger-hbase-plugin-properties': {}
          }
        }),
        Em.Object.create({
          serviceName: 'KNOX',
          displayName: 'Knox',
          configTypes: {
            'ranger-knox-plugin-properties': {}
          }
        }),
        Em.Object.create({
          serviceName: 'STORM',
          displayName: 'Storm',
          configTypes: {
            'ranger-storm-plugin-properties': {}
          }
        }),
        Em.Object.create({
          serviceName: 'YARN',
          displayName: 'YARN',
          configTypes: {}
        })
      ]);
    });

    afterEach(function () {
      App.Service.find.restore();
      App.StackService.find.restore();
    });

    cases.forEach(function (item) {
      it(item.title, function () {
        controller.set('isRangerPluginsArraySet', item.isRangerPluginsArraySet);
        App.set('router.clusterController.isLoaded', item.isLoaded);
        expect(controller.get('isRangerPluginsArraySet')).to.equal(item.expectedIsRangerPluginsArraySet);
        expect(controller.get('rangerPlugins').filterProperty('isDisplayed').mapProperty('serviceName').sort()).to.eql(['HDFS', 'HIVE']);
      });
    });

  });

  describe('#getRangerPluginsStatusSuccess', function () {

    beforeEach(function () {
      controller.getRangerPluginsStatusSuccess({
        'items': [
          {
            'type': 'ranger-hdfs-plugin-properties',
            'properties': {
              'ranger-hdfs-plugin-enabled': 'Yes'
            }
          },
          {
            'type': 'hive-env',
            'properties': {
              'hive_security_authorization': 'Ranger'
            }
          },
          {
            'type': 'ranger-hbase-plugin-properties',
            'properties': {
              'ranger-hbase-plugin-enabled': ''
            }
          }
        ]
      });
    });

    it('isPreviousRangerConfigsCallFailed is false', function () {
      expect(controller.get('isPreviousRangerConfigsCallFailed')).to.be.false;
    });
    it('rangerPlugins.HDFS status is valid', function () {
      expect(controller.get('rangerPlugins').findProperty('serviceName', 'HDFS').status).to.equal(Em.I18n.t('alerts.table.state.enabled'));
    });
    it('rangerPlugins.HIVE status is valid', function () {
      expect(controller.get('rangerPlugins').findProperty('serviceName', 'HIVE').status).to.equal(Em.I18n.t('alerts.table.state.enabled'));
    });
    it('rangerPlugins.HBASE status is valid', function () {
      expect(controller.get('rangerPlugins').findProperty('serviceName', 'HBASE').status).to.equal(Em.I18n.t('common.unknown'));
    });
  });

  describe('#getRangerPluginsStatusError', function () {

    it('should set isPreviousRangerConfigsCallFailed to true', function () {
      controller.getRangerPluginsStatusError();
      expect(controller.get('isPreviousRangerConfigsCallFailed')).to.be.true;
    });

  });

  describe("#getActiveWidgetLayout() for Enhanced Dashboard", function () {

    it("make GET call", function () {
      var _controller = App.MainServiceInfoSummaryController.create({
        isServiceWithEnhancedWidgets: true,
        content: Em.Object.create({serviceName: 'HDFS'})
      });
      _controller.getActiveWidgetLayout();
      expect(testHelpers.findAjaxRequest('name', 'widgets.layouts.active.get')).to.exists;
    });
  });

  describe("#getActiveWidgetLayoutSuccessCallback()", function () {
    beforeEach(function () {
      sinon.stub( App.widgetLayoutMapper, 'map');
      sinon.stub( App.widgetMapper, 'map');
    });
    afterEach(function () {
      App.widgetLayoutMapper.map.restore();
      App.widgetMapper.map.restore();
    });
    it("isWidgetLayoutsLoaded should be set to true", function () {
      var _controller = App.MainServiceInfoSummaryController.create({
        isServiceWithEnhancedWidgets: true,
        content: Em.Object.create({serviceName: 'HDFS'})
      });
      _controller.getActiveWidgetLayoutSuccessCallback({items:[{
        WidgetLayoutInfo: {}
      }]});
      expect(_controller.get('isWidgetsLoaded')).to.be.true;
    });

  });

  describe("#hideWidgetSuccessCallback()", function () {
    beforeEach(function () {
      sinon.stub(App.widgetLayoutMapper, 'map');
      sinon.stub(controller, 'propertyDidChange');
      var params = {
        data: {
          WidgetLayoutInfo: {
            widgets: [
              {id: 1}
            ]
          }
        }
      };
      controller.hideWidgetSuccessCallback({}, {}, params);
    });
    afterEach(function () {
      App.widgetLayoutMapper.map.restore();
      controller.propertyDidChange.restore();
    });
    it("mapper is called with valid data", function () {
      expect(App.widgetLayoutMapper.map.calledWith({
        items: [{
          WidgetLayoutInfo: {
            widgets: [
              {
                WidgetInfo: {
                  id: 1
                }
              }
            ]
          }
        }]
      })).to.be.true;
    });
    it('`widgets` is forced to be recalculated', function () {
      expect(controller.propertyDidChange.calledWith('widgets')).to.be.true;
    });
  });

});
});

require.register("test/controllers/main/service/item_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

App = require('app');
require('ember');
require('models/host_component');
require('views/common/modal_popup');
require('mixins/common/userPref');
require('controllers/application');
require('controllers/global/background_operations_controller');
require('controllers/global/cluster_controller');
require('controllers/main/service/reassign_controller');
require('controllers/main/service/item');
var batchUtils = require('utils/batch_scheduled_requests');
var testHelpers = require('test/helpers');
var stackSerivceModel = {
  'HDFS': Em.Object.create({
    serviceName: 'HDFS',
    requiredServices: ['ZOOKEEPER']
  }),
  'YARN': Em.Object.create({
    serviceName: 'YARN',
    requiredServices: ['MAPREDUCE2', 'HDFS']
  }),
  'MAPREDUCE2': Em.Object.create({
    serviceName: 'MAPREDUCE2',
    requiredServices: ['YARN']
  }),
  'TEZ': Em.Object.create({
    serviceName: 'TEZ',
    requiredServices: ['YARN']
  }),
  'HIVE': Em.Object.create({
    serviceName: 'HIVE',
    requiredServices: ['YARN', 'TEZ']
  })
};

describe('App.MainServiceItemController', function () {

  describe('#setStartStopState', function () {
    var tests = [
      {
        serviceController: {
          serviceName: "YARN"
        },
        backgroundOperationsController: {
          services: [
            {
              isRunning: true,
              dependentService: "ALL_SERVICES"
            }
          ]
        },
        isPending: true,
        m: 'operaion is active because all services are running'
      },
      {
        serviceController: {
          serviceName: "HBASE"
        },
        backgroundOperationsController: {
          services: [
            {
              isRunning: true,
              dependentService: "HBASE"
            }
          ]
        },
        isPending: true,
        m: 'operaion is active button because current service is running'
      },
      {
        serviceController: {
          serviceName: "HDFS"
        },
        backgroundOperationsController: {
          services: [

          ]
        },
        isPending: true,
        m: 'pending is true - backgroundOperationsController.services is empty'
      },
      {
        serviceController: {
          serviceName: "HBASE"
        },
        backgroundOperationsController: {
          services: [
            {
              isRunning: false,
              dependentService: "ALL_SERVICES"
            }
          ]
        },
        isPending: false,
        m: 'pending is false - operation is not running'
      },
      {
        serviceController: {
          serviceName: "HBASE"
        },
        backgroundOperationsController: {
          services: [
            {
              isRunning: true,
              dependentService: "HDFS"
            }
          ]
        },
        isPending: false,
        m: 'pending is false - current service is not running'
      }
    ];

    tests.forEach(function (test) {
      describe(test.m, function () {

        var mainServiceItemController;

        beforeEach(function () {
          sinon.stub(App.router, 'get', function(k) {
            if ('backgroundOperationsController.services' === k) return test.backgroundOperationsController.services;
            return Em.get(App.router, k);
          });
          mainServiceItemController = App.MainServiceItemController.create({content: {serviceName: test.serviceController.serviceName}});
          mainServiceItemController.setStartStopState();
        });

        afterEach(function () {
          App.router.get.restore();
        });

        it('isPending is ' + test.isPending, function () {
          expect(mainServiceItemController.get('isPending')).to.equal(test.isPending);
        });

      });
    })
  });

  describe('#reassignMaster()', function () {
    var tests = [
      {
        host_components: [
          {componentName: "RESOURCEMANGER"}
        ],
        componentName: "RESOURCEMANGER",
        result: true,
        m: 'run reassignMaster'
      },
      {
        host_components: [
          {componentName: "RESOURCEMANGER"}
        ],
        componentName: "DATANODE",
        result: false,
        m: 'don\t run reassignMaster'
      }
    ];

    tests.forEach(function (test) {
      describe(test.m, function () {

        var reassignMasterController = App.ReassignMasterController.create({currentStep: ''});

        beforeEach(function () {
          sinon.stub(reassignMasterController, 'saveComponentToReassign', Em.K);
          sinon.stub(reassignMasterController, 'setCurrentStep', Em.K);
          sinon.stub(App.router, 'transitionTo', Em.K);
          var mainServiceItemController = App.MainServiceItemController.create({});
          sinon.stub(App.HostComponent, 'find', function() {
            return test.host_components
          });
          sinon.stub(App.router, 'get', function(k) {
            if ('reassignMasterController' === k) return reassignMasterController;
            return Em.get(App.router, k);
          });
          mainServiceItemController.reassignMaster(test.componentName);
        });

        afterEach(function () {
          reassignMasterController.saveComponentToReassign.restore();
          reassignMasterController.setCurrentStep.restore();
          App.HostComponent.find.restore();
          App.router.transitionTo.restore();
          App.router.get.restore();
        });

        it('saveComponentToReassign is ' + (test.result ? '' : 'not') + ' called once', function () {
          expect(reassignMasterController.saveComponentToReassign.calledOnce).to.equal(test.result);
        });

        it('setCurrentStep is ' + (test.result ? '' : 'not') + ' called once', function () {
          expect(reassignMasterController.setCurrentStep.calledOnce).to.equal(test.result);
        });

      });
    }, this);
  });

  describe("#doAction", function () {

    var el = document.createElement("BUTTON");
    el.disabled = false;
    var tests = [
      {
        event: {
          target: el,
          context: {
            action: 'runSmokeTest'
          }
        },
        m: "run runSmokeTest"
      },
      {
        event: {
          target: el,
          context: {
            action: 'refreshConfigs'
          }
        },
        m: "run refreshConfigs"
      },
      {
        event: {
          target: el,
          context: {
            action: 'restartAllHostComponents'
          }
        },
        m: "run restartAllHostComponents"
      },
      {
        event: {
          target: el,
          context: {
            action: 'rollingRestart'
          }
        },
        m: "run rollingRestart"
      }
    ];

    tests.forEach(function (test) {
      var mainServiceItemController = App.MainServiceItemController.create({});
      mainServiceItemController.set(test.event.context.action, Em.K);
      beforeEach(function () {
        sinon.spy(mainServiceItemController, test.event.context.action);
      });
      afterEach(function () {
        mainServiceItemController[test.event.context.action].restore();
      });
      it(test.m, function () {
        mainServiceItemController.doAction(test.event);
        expect(mainServiceItemController[test.event.context.action].calledOnce).to.equal(!test.event.target.disabled);
      });
    });
  });

  describe("#startService , #stopService", function () {
    var mainServiceItemController = App.MainServiceItemController.create({startStopPopup: Em.K});
    beforeEach(function () {
      sinon.spy(mainServiceItemController, "startStopPopup");
    });
    afterEach(function () {
      mainServiceItemController.startStopPopup.restore();
    });
    it("start service", function () {
      mainServiceItemController.startService({});
      expect(mainServiceItemController.startStopPopup.calledWith({},App.HostComponentStatus.started)).to.equal(true);
    });
    it("stop service", function () {
      mainServiceItemController.stopService({});
      expect(mainServiceItemController.startStopPopup.calledWith({},App.HostComponentStatus.stopped)).to.equal(true);
    });
  });

  describe("#turnOnOffPassive", function () {
    var mainServiceItemController = App.MainServiceItemController.create({turnOnOffPassiveRequest: Em.K});
    beforeEach(function () {
      sinon.spy(batchUtils, "turnOnOffPassiveRequest");
      mainServiceItemController.set('content', {serviceName: ''});
    });
    afterEach(function () {
      batchUtils.turnOnOffPassiveRequest.restore();
    });
    it("turns on/off passive mode for service", function () {
      mainServiceItemController.turnOnOffPassive({}).onPrimary();
      expect(batchUtils.turnOnOffPassiveRequest.calledOnce).to.equal(true);
    });
  });

  describe("#runSmokeTest", function () {
    var tests = [
      {
        content: {
          id: "YARN",
          service_name: "YARN",
          work_status: "STARTED"
        },
        startSmoke: true,
        serviceName: "MAPREDUCE2",
        m: "don't run smoke test primary for MAPREDUCE2"
      },
      {
        content: {
          id: "YARN",
          service_name: "YARN",
          work_status: "STOPPED"
        },
        startSmoke: false,
        serviceName: "MAPREDUCE2",
        m: "run smoke test primary for MAPREDUCE2"
      },
      {
        m: "run smoke test primary for all services (not MAPREDUCE2)",
        startSmoke: true,
        default: true
      }
    ];

    tests.forEach(function (test) {
      var mainServiceItemController = test.default ? App.MainServiceItemController.create({runSmokeTestPrimary: Em.K}) :
        App.MainServiceItemController.create({content: {serviceName: test.serviceName}, runSmokeTestPrimary: Em.K});
      beforeEach(function () {
        sinon.spy(mainServiceItemController, "runSmokeTestPrimary");
      });
      afterEach(function () {
        mainServiceItemController.runSmokeTestPrimary.restore();
      });
      it(test.m, function () {
        if (!test.default) {
          App.store.safeLoad(App.Service, test.content);
        }
        mainServiceItemController.runSmokeTest({}).onPrimary();
        expect(mainServiceItemController.runSmokeTestPrimary.calledOnce).to.equal(test.startSmoke);
      });
    });
  });

  describe("#startStopPopup", function () {
    var el = document.createElement("BUTTON");
    el.disabled = false;
    var event = {
      target: el
    };
    var mainServiceItemController = App.MainServiceItemController.create({
      content: {
        serviceName: "HDFS",
        hostComponents: [ {
          componentName: 'NAMENODE',
          workStatus: 'INSTALLED'
        }]
      }
    });
    var mainServiceItemControllerHdfsStarted = App.MainServiceItemController.create({
      content: {
        serviceName: "HDFS",
        hostComponents: [ {
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        }]
      }
    });
    beforeEach(function () {
      sinon.spy(mainServiceItemController, "startStopPopupPrimary");
      sinon.spy(mainServiceItemControllerHdfsStarted, "startStopPopupPrimary");
      sinon.spy(Em.I18n, "t");
      sinon.stub(mainServiceItemControllerHdfsStarted, 'checkNnLastCheckpointTime', function(callback) {
        return callback;
      });
    });
    afterEach(function () {
      mainServiceItemController.startStopPopupPrimary.restore();
      mainServiceItemControllerHdfsStarted.startStopPopupPrimary.restore();
      mainServiceItemControllerHdfsStarted.checkNnLastCheckpointTime.restore();
      Em.I18n.t.restore();
    });
    it("start start/stop service popup", function () {
      mainServiceItemController.startStopPopup(event, "").onPrimary();
      expect(mainServiceItemController.startStopPopupPrimary.calledOnce).to.equal(true);
    });

    it ("should popup warning to check last checkpoint time if work status is STARTED", function() {
      mainServiceItemControllerHdfsStarted.startStopPopup(event, "INSTALLED");
      expect(mainServiceItemControllerHdfsStarted.checkNnLastCheckpointTime.calledOnce).to.equal(true);
    });

    describe("modal messages", function() {

      beforeEach(function () {
        sinon.stub(App.StackService, 'find').returns([
          Em.Object.create({
            serviceName: 'HDFS',
            displayName: 'HDFS',
            isInstalled: true,
            isSelected: true,
            requiredServices:["ZOOKEEPER"]
          }),
          Em.Object.create({
            serviceName: 'HIVE',
            displayName: 'Hive',
            isInstalled: true,
            isSelected: true
          }),
          Em.Object.create({
            serviceName: 'HBASE',
            displayName: 'HBase',
            isInstalled: true,
            isSelected: true,
            requiredServices:["HDFS", "ZOOKEEPER"]
          }),
          Em.Object.create({
            serviceName: 'YARN',
            displayName: 'YARN',
            isInstalled: true,
            isSelected: true,
            requiredServices:["HDFS"]
          }),
          Em.Object.create({
            serviceName: 'SPARK',
            displayName: 'Spark',
            isInstalled: true,
            isSelected: true,
            requiredServices:["HIVE"]
          })
        ]);
      });

      it ("should confirm stop if serviceHealth is INSTALLED", function() {
        mainServiceItemController.startStopPopup(event, "INSTALLED");
        expect(Em.I18n.t.calledWith('services.service.stop.confirmMsg')).to.be.ok;
        expect(Em.I18n.t.calledWith('services.service.stop.confirmButton')).to.be.ok;
      });

      it ("should confirm start if serviceHealth is not INSTALLED", function() {
        mainServiceItemController.startStopPopup(event, "");
        expect(Em.I18n.t.calledWith('services.service.start.confirmMsg')).to.be.ok;
        expect(Em.I18n.t.calledWith('services.service.start.confirmButton')).to.be.ok;
      });

      it ("should not display a dependent list if it is to start a service", function() {
        var _mainServiceItemController = App.MainServiceItemController.create(
            {content: {serviceName: "HDFS", passiveState:'OFF'}});
        _mainServiceItemController.startStopPopup(event, "");
        expect(Em.I18n.t.calledWith('services.service.stop.warningMsg.dependent.services')).to.not.be.ok;
      });

      describe ("should display dependent list if other services depend on the one to be stopped", function() {
        beforeEach(function () {
          var _mainServiceItemController = App.MainServiceItemController.create(
            {content: {
              serviceName: "HDFS",
              passiveState:'OFF',
              hostComponents: [{
                componentName: 'NAMENODE',
                workStatus: 'INSTALLED'
              }]
            }}
          );
          _mainServiceItemController.startStopPopup(event, "INSTALLED");
          this.dependencies = Em.I18n.t('services.service.stop.warningMsg.dependent.services').format("HDFS", "HBase,YARN");
          this.msg = Em.I18n.t('services.service.stop.warningMsg.turnOnMM').format("HDFS");
          this.fullMsg = _mainServiceItemController.addAdditionalWarningMessage("INSTALLED", this.msg, "HDFS");
        });

        it('turnOnMM message is shown', function () {
          expect(Em.I18n.t.calledWith('services.service.stop.warningMsg.turnOnMM')).to.be.ok;
        });
        it('message about dependent services is shown', function () {
          expect(Em.I18n.t.calledWith('services.service.stop.warningMsg.dependent.services')).to.be.ok;
        });
        it('full message is valid', function () {
          expect(this.fullMsg).to.be.equal(this.msg + " " + this.dependencies);
        });
      });

      describe("should display the dependent service if another service depends on the one to be stopped", function() {

        beforeEach(function () {
          var _mainServiceItemController = App.MainServiceItemController.create(
            {content: {serviceName: "HIVE", passiveState:'OFF'}});
          _mainServiceItemController.startStopPopup(event, "INSTALLED");
          this.dependencies = Em.I18n.t('services.service.stop.warningMsg.dependent.services').format("HIVE", "Spark");
          this.msg = Em.I18n.t('services.service.stop.warningMsg.turnOnMM').format("HIVE");
          this.fullMsg = _mainServiceItemController.addAdditionalWarningMessage("INSTALLED", this.msg, "HIVE");
        });

        it('message about dependent services is shown', function () {
          expect(Em.I18n.t.calledWith('services.service.stop.warningMsg.dependent.services')).to.be.ok;
        });
        it('full message is valid', function () {
          expect(this.fullMsg).to.be.equal(this.msg + " " + this.dependencies);
        });
      });

      afterEach(function () {
        App.StackService.find.restore();
      });
    });
  });

  describe("#restartAllHostComponents", function () {
    var temp = batchUtils.restartAllServiceHostComponents;
    var mainServiceItemController = App.MainServiceItemController.create({
      content: {
        serviceName: "HDFS",
        hostComponents: [{
          componentName: 'NAMENODE',
          workStatus: 'STARTED'
        }]
      }
    });
    beforeEach(function () {
      batchUtils.restartAllServiceHostComponents = Em.K;
      sinon.spy(batchUtils, "restartAllServiceHostComponents");
      sinon.stub(App.Service, 'find', function() {
        return Em.Object.create({serviceTypes: []});
      });
      sinon.stub(mainServiceItemController, 'checkNnLastCheckpointTime', function() {
        return true;
      });
    });
    afterEach(function () {
      batchUtils.restartAllServiceHostComponents.restore();
      batchUtils.restartAllServiceHostComponents = temp;
      App.Service.find.restore();
      mainServiceItemController.checkNnLastCheckpointTime.restore();
    });

    it("start restartAllHostComponents for service", function () {
      var controller = App.MainServiceItemController.create({
        content: {
          serviceName: "HDFS",
          hostComponents: [{
            componentName: 'NAMENODE',
            workStatus: 'INSTALLED'
          }]
        }
      });
      controller.restartAllHostComponents({}).onPrimary();
      expect(batchUtils.restartAllServiceHostComponents.calledOnce).to.equal(true);
    });

    it("check last checkpoint time for NameNode before start restartAllHostComponents for service", function () {
      mainServiceItemController.restartAllHostComponents({});
      expect(mainServiceItemController.checkNnLastCheckpointTime.calledOnce).to.equal(true);
    });
  });

  describe("#rollingRestart", function () {
    var temp = batchUtils.launchHostComponentRollingRestart;
    beforeEach(function () {
      batchUtils.launchHostComponentRollingRestart = Em.K;
      sinon.spy(batchUtils, "launchHostComponentRollingRestart");
    });
    afterEach(function () {
      batchUtils.launchHostComponentRollingRestart.restore();
      batchUtils.launchHostComponentRollingRestart = temp;
    });

    var mainServiceItemController = App.MainServiceItemController.create();

    it("start restartAllHostComponents for service", function () {
      mainServiceItemController.rollingRestart();
      expect(batchUtils.launchHostComponentRollingRestart.calledOnce).to.equal(true);
    });
  });

  describe("#parseNnCheckPointTime", function () {
    var tests = [
      {
        m: "NameNode has JMX data, the last checkpoint time is less than 12 hours ago",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "active",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            }
          ]
        },
        result: false
      },
      {
        m: "NameNode has JMX data, the last checkpoint time is > 12 hours ago",
        data:
          {"href" : "",
            "ServiceComponentInfo" : {
              "cluster_name" : "c123",
              "component_name" : "NAMENODE",
              "service_name" : "HDFS"
            },
            "host_components" : [
              {
                "href" : "",
                "HostRoles" : {
                  "cluster_name" : "c123",
                  "component_name" : "NAMENODE",
                  "host_name" : "c6401.ambari.apache.org"
                },
                "metrics" : {
                  "dfs" : {
                    "FSNamesystem" : {
                      "HAState" : "active",
                      "LastCheckpointTime" : 1435617248000
                    }
                  }
                }
              }
            ]
          },
        result: "c6401.ambari.apache.org"
      },
      {
        m: "NameNode has no JMX data available",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "active"
                  }
                }
              }
            }
          ]
        },
        result: null
      },
      {
        m: "HA enabled, both active and standby NN has JMX data normally.",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "active",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            },
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6402.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "standby",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            }
          ]
        },
        result: false
      },
      {
        m: "HA enabled, both NamoNodes are standby NN",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "standby",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            },
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6402.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "standby",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            }
          ]
        },
        result: false
      },
      {
        m: "HA enabled, active NN has no JMX data, use the standby's data",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "active"
                  }
                }
              }
            },
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6402.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "standby",
                    "LastCheckpointTime" : 1435775648000
                  }
                }
              }
            }
          ]
        },
        result: false
      },
      {
        m: "HA enabled, both NamoNodes no JMX data",
        data:
        {"href" : "",
          "ServiceComponentInfo" : {
            "cluster_name" : "c123",
            "component_name" : "NAMENODE",
            "service_name" : "HDFS"
          },
          "host_components" : [
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6401.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "active"
                  }
                }
              }
            },
            {
              "href" : "",
              "HostRoles" : {
                "cluster_name" : "c123",
                "component_name" : "NAMENODE",
                "host_name" : "c6402.ambari.apache.org"
              },
              "metrics" : {
                "dfs" : {
                  "FSNamesystem" : {
                    "HAState" : "standby"
                  }
                }
              }
            }
          ]
        },
        result: null
      }
    ];

    beforeEach(function () {
      sinon.stub(App, 'dateTime').returns(1435790048000);
    });

    afterEach(function () {
      App.dateTime.restore();
    });

    tests.forEach(function (test) {
      it(test.m, function () {
        var mainServiceItemController = App.MainServiceItemController.create({isNNCheckpointTooOld: null});
        mainServiceItemController.parseNnCheckPointTime(test.data);
        expect(mainServiceItemController.get('isNNCheckpointTooOld')).to.equal(test.result);
      });
    });
  });

  describe("#isStartDisabled", function () {
    var tests = [
      {
        content: {
          healthStatus: 'red'
        },
        isPending: true,
        disabled: true,
        m: "disabled because of pending"
      },
      {
        content: {
          healthStatus: 'green'
        },
        isPending: false,
        disabled: true,
        m: "disabled because healthStatus is not red"
      },
      {
        content: {
          healthStatus: 'red'
        },
        isPending: false,
        disabled: false,
        m: "enabled because healthStatus is red and pending is false"
      }
    ];
    tests.forEach(function (test) {
      it(test.m, function () {
        var mainServiceItemController = App.MainServiceItemController.create({content: {healthStatus: test.content.healthStatus}, isPending: test.isPending});
        expect(mainServiceItemController.get('isStartDisabled')).to.equal(test.disabled);
      });
    });
  });

  describe("#isStopDisabled", function () {
    var tests = [
      {
        content: {
          healthStatus: 'red'
        },
        isPending: true,
        disabled: true,
        m: "disabled because of pending"
      },
      {
        content: {
          healthStatus: 'green'
        },
        isPending: false,
        disabled: false,
        m: "enabled because healthStatus is green and pending is false"
      },
      {
        content: {
          healthStatus: 'red'
        },
        isPending: false,
        disabled: true,
        m: "disabled because healthStatus is not green"
      }
    ];
    tests.forEach(function (test) {
      it(test.m, function () {
        var mainServiceItemController = App.MainServiceItemController.create({content: test.content, isPending: test.isPending});
        expect(mainServiceItemController.get('isStopDisabled')).to.equal(test.disabled);
      });
    });
  });

  describe("#isHAWQStopDisabled", function () {
    var tests = [
      {
        content: {
          serviceName: 'HAWQ',
          healthStatus: 'green',
          hostComponents: [
            {
              componentName: 'HAWQMASTER',
              workStatus: 'STARTED'
            }, {
              componentName: 'HAWQSTANDBY',
              workStatus: 'STARTED'
            }]
        },
        isPending: true,
        disabled: true,
        m: "disabled because of pending"
      },
      {
        content: {
          serviceName: 'HAWQ',
          healthStatus: 'red',
          hostComponents: [
            {
              componentName: 'HAWQMASTER',
              workStatus: 'INSTALLED'
            }, {
              componentName: 'HAWQSTANDBY',
              workStatus: 'STARTED'
            }]
        },
        isPending: false,
        disabled: true,
        m: "disabled because HAWQMASTER is stopped and health is red"
      },
      {
        content: {
          serviceName: 'HAWQ',
          healthStatus: 'green',
          hostComponents: [
            {
              componentName: 'HAWQMASTER',
              workStatus: 'STARTED'
            }, {
              componentName: 'HAWQSTANDBY',
              workStatus: 'INSTALLED'
            }]
        },
        isPending: false,
        disabled: false,
        m: "enabled because HAWQMASTER is started"
      }
    ];
    tests.forEach(function (test) {
      it(test.m, function () {
        var mainServiceItemController = App.MainServiceItemController.create({content: test.content, isPending: test.isPending});
        expect(mainServiceItemController.get('isStopDisabled')).to.equal(test.disabled);
      });
    });
  });

  describe("#isPXFStopDisabled", function () {

    var hostComponentStub;

    before(function () {
      hostComponentStub = sinon.stub(App.HostComponent.find(), 'filterProperty');
    });
    after(function () {
      hostComponentStub.restore();
    });

    var tests = [
      {
        content: {
          serviceName: 'PXF',
        },
        isPending: false,
        pxfWorkstatus: [{"workStatus": "STARTED"}, {"workStatus": "STARTED"}],
        disabled: false,
        m: "Enabled because all agents are started."
      },
      {
        content: {
          serviceName: 'PXF',
        },
        isPending: false,
        pxfWorkstatus: [{"workStatus": "INSTALLED"}, {"workStatus": "STARTED"}],
        disabled: false,
        m: "Enabled because atleast one agent is started."
      },
      {
        content: {
          serviceName: 'PXF',
        },
        isPending: false,
        pxfWorkstatus: [{"workStatus": "INSTALLED"}, {"workStatus": "INSTALLED"}],
        disabled: true,
        m: "Disabled because all PXF agents are down."
      }
    ];
    tests.forEach(function (test) {
      it(test.m, function () {
        hostComponentStub.withArgs('componentName', 'PXF').returns(test.pxfWorkstatus);
        var mainServiceItemController = App.MainServiceItemController.create({content: test.content, isPending: test.isPending});
        expect(mainServiceItemController.get('isStopDisabled')).to.equal(test.disabled);
      });
    });
  });

  describe("#runRebalancer", function () {

    beforeEach(function () {
      sinon.stub(App.router, 'get', function(k) {
        if ('applicationController' === k) {
          return Em.Object.create({
            dataLoading: function() {
              return {done: Em.K}
            }
          });
        }
        return Em.get(App.router, k);
      });
    });

    afterEach(function () {
      App.router.get.restore();
    });

    it("run rebalancer", function () {
      var mainServiceItemController = App.MainServiceItemController.create({content: {runRebalancer: false}});
      mainServiceItemController.runRebalancer().onPrimary();
      expect(mainServiceItemController.get("content.runRebalancer")).to.equal(true);
    });
  });

  describe("#runCompaction", function () {

    beforeEach(function () {
      sinon.stub(App.router, 'get', function(k) {
        if ('applicationController' === k) {
          return Em.Object.create({
            dataLoading: function() {
              return {done: Em.K}
            }
          });
        }
        return Em.get(App.router, k);
      });
    });

    afterEach(function () {
      App.router.get.restore();
    });

    it("run compaction", function () {
      var mainServiceItemController = App.MainServiceItemController.create({content: {runCompaction: false}});
      mainServiceItemController.runCompaction().onPrimary();
      expect(mainServiceItemController.get("content.runCompaction")).to.equal(true);
    });
  });

  describe("#runSmokeTestPrimary", function () {
    beforeEach(function () {
      sinon.stub(App, 'get').withArgs('clusterName').returns('myCluster');
    });

    afterEach(function () {
      App.get.restore();
    });

    var tests = [
      {
        data: {
          'serviceName': "HDFS",
          'displayName': "HDFS",
          'query': "test"
        },
        "RequestInfo": {
          "context": "HDFS Service Check",
          "command" : "HDFS_SERVICE_CHECK"
        },
        "Requests/resource_filters": [{"service_name" : "HDFS"}]
      },
      {
        data: {
          'serviceName': "KERBEROS",
          'displayName': "Kerberos",
          'query': "test"
        },
        "RequestInfo": {
          "context": "Kerberos Service Check",
          "command" : "KERBEROS_SERVICE_CHECK",
          "operation_level": {
            "level": "CLUSTER",
            "cluster_name": "myCluster"
          }
        },
        "Requests/resource_filters": [{"service_name" : "KERBEROS"}]
      }
    ];

    tests.forEach(function (test) {

      var mainServiceItemController = App.MainServiceItemController.create({content: {serviceName: test.data.serviceName,
        displayName: test.data.displayName}});
      describe('send request to run smoke test for ' + test.data.serviceName, function () {

        beforeEach(function () {
          mainServiceItemController.set("runSmokeTestErrorCallBack", Em.K);
          mainServiceItemController.set("runSmokeTestSuccessCallBack", Em.K);
          mainServiceItemController.runSmokeTestPrimary(test.data.query);
          this.args = testHelpers.findAjaxRequest('name', 'service.item.smoke')[0];
          this.data = this.args.data;
          this.data = JSON.parse(App.ajax.fakeGetUrl('service.item.smoke').format(this.data).data);
        });

        it('ajax request is sent', function () {
          expect(this.args).exists;
        });

        it('RequestInfo.context is valid', function () {
          expect(this.data.RequestInfo.context).to.equal(test.RequestInfo.context);
        });

        it('RequestInfo.command is valid', function () {
          expect(this.data.RequestInfo.command).to.equal(test.RequestInfo.command);
        });

        it('Requests/resource_filter.0.serviceName is valid', function () {
          expect(this.data["Requests/resource_filters"][0].serviceName).to.equal(test["Requests/resource_filters"][0].serviceName);
        });

        it('RequestInfo.operation_level is valid', function () {
          expect(this.data.RequestInfo.operation_level).to.be.deep.equal(test.RequestInfo.operation_level);
        });

      });
    });
  });

  describe('#downloadClientConfigs()', function () {

    var mainServiceItemController = App.MainServiceItemController.create({
      content: {
        clientComponents: [
          Em.Object.create({
            totalCount: 1,
            componentName: 'C1',
            displayName: 'd1'
          })
        ],
        serviceName: 'S1'
      }
    });

    beforeEach(function () {
      sinon.stub(mainServiceItemController, 'downloadClientConfigsCall', Em.K);
    });
    afterEach(function () {
      mainServiceItemController.downloadClientConfigsCall.restore();
    });

    it('should launch $.fileDownload method', function () {
      mainServiceItemController.downloadClientConfigs();
      expect(mainServiceItemController.downloadClientConfigsCall.calledWith({
        serviceName: 'S1',
        componentName: 'C1',
        resourceType: mainServiceItemController.resourceTypeEnum.SERVICE_COMPONENT
      })).to.be.true;
    });
    it('should launch $.fileDownload method, event passed', function () {
      var event = {
        label: 'label1',
        name: 'name1'
      };
      mainServiceItemController.downloadClientConfigs(event);
      expect(mainServiceItemController.downloadClientConfigsCall.calledWith({
        serviceName: 'S1',
        componentName: 'name1',
        resourceType: mainServiceItemController.resourceTypeEnum.SERVICE_COMPONENT
      })).to.be.true;
    });
  });

  describe('#downloadAllClientConfigs()', function () {

    var mainServiceItemController = App.MainServiceItemController.create({
      content: {
        clientComponents: [
          Em.Object.create({
            totalCount: 1,
            componentName: 'C1',
            displayName: 'd1'
          }),
          Em.Object.create({
            totalCount: 1,
            componentName: 'C2',
            displayName: 'd2'
          })
        ],
        serviceName: 'S1'
      }
    });

    beforeEach(function () {
      sinon.stub(mainServiceItemController, 'downloadClientConfigsCall', Em.K);
    });
    afterEach(function () {
      mainServiceItemController.downloadClientConfigsCall.restore();
    });

    it('should call downloadClientConfigsCall method for all clients', function () {
      mainServiceItemController.downloadAllClientConfigs();
      expect(mainServiceItemController.downloadClientConfigsCall.calledWith({
        serviceName: 'S1',
        resourceType: mainServiceItemController.resourceTypeEnum.SERVICE
      })).to.be.true;
    });
  });

  describe('#startLdapKnox() and #stopLdapKnox() should call startStopLdapKnox once: ', function () {


    var mainServiceItemController = App.MainServiceItemController.create({content: {serviceName: 'KNOX',
      displayName: 'Knox'}});

    beforeEach(function () {
      sinon.stub(mainServiceItemController, 'startStopLdapKnox', function(){
        return true;
      });
    });
    afterEach(function () {
      mainServiceItemController.startStopLdapKnox.restore();
    });

    var tests = [
      {
        methodName: 'startLdapKnox',
        callback: mainServiceItemController.startLdapKnox
      },
      {
        methodName: 'stopLdapKnox',
        callback: mainServiceItemController.stopLdapKnox
      }
    ];

    tests.forEach(function(test){
      it(test.methodName + ' should call startStopLdapKnox method', function () {
        test.callback.call(mainServiceItemController);
        expect(mainServiceItemController.startStopLdapKnox.calledOnce).to.be.true;
      });
    },this);

  });

  describe("#executeCustomCommand", function () {
    var data = {
      data: {
        'serviceName': "SAMPLESRV",
        'displayName': "SAMPLESRV",
        'query': "test"
      },
      "RequestInfo": {
        "context": "Execute Custom Commands",
        "command" : "SAMPLESRVCUSTOMCOMMANDS"
      },
      "Requests/resource_filters": [{"service_name" : "SAMPLESRV"}]
    };

    var context = {
      label: 'Execute Custom Commands',
      service: data.data.serviceName,
      component: data.data.serviceName,
      command: data.RequestInfo.command
    };

    var mainServiceItemController = App.MainServiceItemController.create({
      content: {
        serviceName: data.data.serviceName,
        displayName: data.data.displayName
      }
    });

    before(function () {
      mainServiceItemController.set("executeCustomCommandErrorCallback", Em.K);
      mainServiceItemController.set("executeCustomCommandSuccessCallback", Em.K);
      sinon.spy(App, 'showConfirmationPopup');
    });

    after(function () {
      App.showConfirmationPopup.restore();
    });

    it('shows a confirmation popup', function () {
      mainServiceItemController.executeCustomCommand(context);
      expect(App.showConfirmationPopup.calledOnce).to.equal(true);
    });
  });

  describe("#findDependentServices()", function() {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      sinon.stub(App.StackService, 'find', function (serviceName) {
        return stackSerivceModel[serviceName];
      });
      this.mockService = sinon.stub(App.Service, 'find');
    });
    afterEach(function() {
      App.StackService.find.restore();
      this.mockService.restore();
    });

    it("no services", function() {
      this.mockService.returns([]);
      expect(mainServiceItemController.findDependentServices(['S1'])).to.be.empty;
    });

    it("service has dependencies", function() {
      this.mockService.returns([
        Em.Object.create({ serviceName: 'HDFS' }),
        Em.Object.create({ serviceName: 'YARN' }),
        Em.Object.create({ serviceName: 'MAPREDUCE2' }),
        Em.Object.create({ serviceName: 'TEZ' }),
        Em.Object.create({ serviceName: 'HIVE' })
      ]);
      expect(mainServiceItemController.findDependentServices(['YARN', 'MAPREDUCE2'])).to.eql(['TEZ', 'HIVE']);
    });

    it("service has no dependencies", function() {
       this.mockService.returns([
         Em.Object.create({ serviceName: 'HDFS' }),
         Em.Object.create({ serviceName: 'YARN' }),
         Em.Object.create({ serviceName: 'MAPREDUCE2' }),
         Em.Object.create({ serviceName: 'TEZ' }),
         Em.Object.create({ serviceName: 'HIVE' })
      ]);
      expect(mainServiceItemController.findDependentServices(['HIVE'])).to.be.empty;
    });

    it("service has no dependencies (except interdependent)", function() {
      this.mockService.returns([
        Em.Object.create({ serviceName: 'HDFS' }),
        Em.Object.create({ serviceName: 'YARN' }),
        Em.Object.create({ serviceName: 'MAPREDUCE2' })
      ]);
      expect(mainServiceItemController.findDependentServices(['YARN', 'MAPREDUCE2'])).to.be.empty;
    });

  });

  describe("#deleteService()", function() {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      this.mockDependentServices = sinon.stub(mainServiceItemController, 'findDependentServices');
      sinon.stub(mainServiceItemController, 'dependentServicesWarning');
      sinon.stub(mainServiceItemController, 'servicesDisplayNames', function(servicesDisplayNames) {
        return servicesDisplayNames;
      });
      this.allowUninstallServices = sinon.stub(mainServiceItemController, 'allowUninstallServices');
      this.mockService = sinon.stub(App.Service, 'find');
      this.mockRangerPluginEnabled = sinon.stub(mainServiceItemController, 'isRangerPluginEnabled');
      sinon.stub(App, 'showConfirmationPopup');
      sinon.stub(App.ModalPopup, 'show');
      sinon.stub(App.format, 'role', function(name) {return name});
      sinon.stub(mainServiceItemController, 'kerberosDeleteWarning');
      sinon.stub(mainServiceItemController, 'showLastWarning');

      mainServiceItemController.reopen({
        interDependentServices: []
      })
    });
    afterEach(function() {
      mainServiceItemController.allowUninstallServices.restore();
      mainServiceItemController.servicesDisplayNames.restore();
      this.mockDependentServices.restore();
      this.mockService.restore();
      mainServiceItemController.dependentServicesWarning.restore();
      App.showConfirmationPopup.restore();
      App.ModalPopup.show.restore();
      App.format.role.restore();
      mainServiceItemController.kerberosDeleteWarning.restore();
      this.mockRangerPluginEnabled.restore();
    });

    it("Kerberos delete should show specific warning", function() {
      mainServiceItemController.deleteService('KERBEROS');
      expect(mainServiceItemController.kerberosDeleteWarning.
        calledWith(Em.I18n.t('services.service.delete.popup.header'))).to.be.true;
    });

    it("RANGER delete should show specific warning", function() {
      this.mockRangerPluginEnabled.returns(true);
      mainServiceItemController.deleteService('RANGER');
      expect(App.ModalPopup.show.calledWith({
        secondary: null,
        header: Em.I18n.t('services.service.delete.popup.header'),
        encodeBody: false,
        body: Em.I18n.t('services.service.delete.popup.ranger')
      })).to.be.true;
    });

    it("only one service installed", function() {
      this.mockDependentServices.returns(['S2']);
      this.mockService.returns(Em.Object.create({length: 1}));
      mainServiceItemController.deleteService('S1');
      expect(App.ModalPopup.show.calledWith({
        secondary: null,
        header: Em.I18n.t('services.service.delete.popup.header'),
        encodeBody: false,
        body: Em.I18n.t('services.service.delete.lastService.popup.body').format('S1')
      })).to.be.true;
    });

    it("service has installed dependent services", function() {
      this.mockDependentServices.returns(['S2']);
      this.mockService.returns([Em.Object.create({workStatus: App.Service.statesMap.stopped}), Em.Object.create({workStatus: App.Service.statesMap.stopped})]);
      mainServiceItemController.deleteService('S1');
      expect(mainServiceItemController.dependentServicesWarning.calledWith('S1', ['S2'])).to.be.true;
    });

    it("service has not dependent services, and stopped", function() {
      this.mockDependentServices.returns([]);
      this.allowUninstallServices.returns(true);
      this.mockService.returns([Em.Object.create({workStatus: App.Service.statesMap.stopped}), Em.Object.create({workStatus: App.Service.statesMap.stopped})]);
      mainServiceItemController.deleteService('S1');
      expect(mainServiceItemController.showLastWarning.calledOnce).to.be.true;
    });

    it("service has not dependent services, and install failed", function() {
      this.mockDependentServices.returns([]);
      this.allowUninstallServices.returns(true);
      this.mockService.returns([Em.Object.create({workStatus: App.Service.statesMap.install_failed}), Em.Object.create({workStatus: App.Service.statesMap.install_failed})]);
      mainServiceItemController.deleteService('S1');
      expect(mainServiceItemController.showLastWarning.calledOnce).to.be.true;
    });

    it("service has not dependent services, and not stopped", function() {
      this.mockDependentServices.returns([]);
      this.mockService.returns(Em.Object.create({workStatus: App.Service.statesMap.started}));
      mainServiceItemController.deleteService('S1');
      expect(App.ModalPopup.show.calledWith({
        secondary: null,
        header: Em.I18n.t('services.service.delete.popup.header'),
        encodeBody: false,
        body: Em.I18n.t('services.service.delete.popup.mustBeStopped').format('S1')
      })).to.be.true;
    });
  });

  describe("#kerberosDeleteWarning()", function () {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      sinon.spy(App.ModalPopup, 'show');
      sinon.stub(App.router, 'transitionTo');
    });

    afterEach(function() {
      App.ModalPopup.show.restore();
      App.router.transitionTo.restore();
    });

    it("App.ModalPopup.show should be called", function() {
      var popup = mainServiceItemController.kerberosDeleteWarning('header');
      expect(App.ModalPopup.show.calledOnce).to.be.true;
      popup.onSecondary();
      expect(App.router.transitionTo.calledWith('main.admin.adminKerberos.index')).to.be.true;
    });
  });

  describe("#dependentServicesWarning()", function() {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      sinon.stub(App.ModalPopup, 'show');
      sinon.stub(App.format, 'role', function(name) {return name});
    });
    afterEach(function() {
      App.ModalPopup.show.restore();
      App.format.role.restore();
    });

    it("App.ModalPopup.show should be called", function() {
      mainServiceItemController.dependentServicesWarning('S1', ['S2']);
      expect(App.ModalPopup.show.calledOnce).to.be.true;
    });
  });

  describe("#confirmDeleteService()", function() {
    var mainServiceItemController;

    beforeEach(function () {
      mainServiceItemController = App.MainServiceItemController.create();
    });

    afterEach(function () {
      App.ModalPopup.show.restore();
    });

    describe('confirmation popup', function () {

      beforeEach(function () {
        sinon.stub(App.ModalPopup, 'show', Em.K);
        mainServiceItemController.confirmDeleteService('S1', [], '');
      });

      it("App.ModalPopup.show should be called", function() {
        expect(App.ModalPopup.show.calledOnce).to.be.true;
      });

    });

    describe('progress popup', function () {

      var cases = [
        {
          serviceName: 'S0',
          dependentServiceNames: [],
          serviceNames: ['S0'],
          message: 's0',
          title: 'no dependent services'
        },
        {
          serviceName: 'S1',
          dependentServiceNames: ['S2', 'S3', 'S4'],
          serviceNames: ['S1', 'S2', 'S3', 'S4'],
          message: 's1, s2, s3 and s4',
          title: 'dependent services present'
        }
      ];

      cases.forEach(function (item) {

        describe(item.title, function () {

          beforeEach(function () {
            sinon.stub(App.ModalPopup, 'show', function (options) {
              options._super = Em.K;
              if (options.onPrimary) {
                options.onPrimary();
              }
              return options;
            });
            sinon.stub(App.Service, 'find', function (serviceName) {
              return Em.Object.create({
                displayName: serviceName.toLowerCase()
              });
            });
            sinon.stub(mainServiceItemController, 'deleteServiceCall', Em.K);
            mainServiceItemController.confirmDeleteService(item.serviceName, item.dependentServiceNames, '');
          });

          afterEach(function () {
            App.Service.find.restore();
            mainServiceItemController.deleteServiceCall.restore();
          });

          it('modal popups display', function () {
            expect(App.ModalPopup.show.calledTwice).to.be.true;
          });

          it('progress popup message', function () {
            expect(mainServiceItemController.get('deleteServiceProgressPopup.message')).to.equal(Em.I18n.t('services.service.delete.progressPopup.message').format(item.message));
          });

          it('delete service call', function () {
            expect(mainServiceItemController.deleteServiceCall.calledOnce).to.be.true;
          });

          it('delete service call arguments', function () {
            expect(mainServiceItemController.deleteServiceCall.calledWith(item.serviceNames)).to.be.true;
          });

          it('progress popup close', function () {
            mainServiceItemController.get('deleteServiceProgressPopup').onClose();
            expect(mainServiceItemController.get('deleteServiceProgressPopup')).to.be.null;
          });

        });

      });

    });

  });

  describe('#interDependentServices', function() {
    var mainServiceItemController;

    beforeEach(function() {
      sinon.stub(App.StackService, 'find', function (serviceName) {
        return stackSerivceModel[serviceName];
      });
      mainServiceItemController = App.MainServiceItemController.create({
        content: {}
      });
    });

    afterEach(function() {
      App.StackService.find.restore();
    });

    it('get interdependent services for YARN', function() {
      mainServiceItemController.set('content', Em.Object.create({
        serviceName: 'YARN'
      }));
      expect(mainServiceItemController.get('interDependentServices')).to.eql(['MAPREDUCE2']);
    });

    it('get interdependent services for MAPREDUCE2', function() {
      mainServiceItemController.set('content', Em.Object.create({
        serviceName: 'MAPREDUCE2'
      }));
      expect(mainServiceItemController.get('interDependentServices')).to.eql(['YARN']);
    });
  });

  describe("#deleteServiceCall()", function() {
    var mainServiceItemController;
    var service;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      service = Em.Object.create({serviceName: 'S1', deleteInProgress: false});
      sinon.stub( App.Service, 'find', function () {
        return [service];
      });
      mainServiceItemController.deleteServiceCall(['S1', 'S2']);
    });

    afterEach(function () {
      App.Service.find.restore();
    });

    it("App.ajax.send should be called", function() {
      var args = testHelpers.findAjaxRequest('name', 'common.delete.service');
      expect(args[0]).exists;
      expect(args[0].sender).to.be.eql(mainServiceItemController);
      expect(args[0].data).to.be.eql({
        serviceName : 'S1',
        servicesToDeleteNext: ['S2']
      });
    });

    it('service is marked as deleted', function () {
      expect(service.get('deleteInProgress')).to.be.true;
    });

  });

  describe("#deleteServiceCallSuccessCallback()", function() {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create({});
      sinon.stub(mainServiceItemController, 'saveConfigs', Em.K);
      sinon.stub(mainServiceItemController, 'deleteServiceCall', Em.K);
      mainServiceItemController.reopen({
        interDependentServices: []
      })
    });
    afterEach(function() {
      mainServiceItemController.saveConfigs.restore();
      mainServiceItemController.deleteServiceCall.restore();
    });

    it("saveConfigs should be called", function() {
      mainServiceItemController.deleteServiceCallSuccessCallback([], null, {});
      expect(mainServiceItemController.deleteServiceCall.called).to.be.false;
      expect(mainServiceItemController.saveConfigs.calledOnce).to.be.true;
    });

    it("deleteServiceCall should be called", function() {
      mainServiceItemController.deleteServiceCallSuccessCallback([], null, {servicesToDeleteNext: true});
      expect(mainServiceItemController.deleteServiceCall.calledOnce).to.be.true;
      expect(mainServiceItemController.saveConfigs.called).to.be.false;
    });
  });

  describe("#restartLLAP()", function () {
    var mainServiceItemController;

    beforeEach(function () {
      mainServiceItemController = App.MainServiceItemController.create();
      sinon.stub(mainServiceItemController, 'restartLLAPAndRefreshQueueRequest', Em.K);
      sinon.stub(mainServiceItemController, 'restartLLAPRequest', Em.K);
      this.mockService = sinon.stub(App.Service, 'find');
    });
    afterEach(function () {
      mainServiceItemController.restartLLAPAndRefreshQueueRequest.restore();
      mainServiceItemController.restartLLAPRequest.restore();
      this.mockService.restore();
    });

    [
      {
        m: 'should call only restartLLAPRequest',
        isRestartRequired: false,
        toCall: 'restartLLAPRequest'
      },
      {
        m: 'should call only restartLLAPAndRefreshQueueRequest',
        isRestartRequired: true,
        toCall: 'restartLLAPAndRefreshQueueRequest'
      }
    ].forEach(function (test) {
        it(test.m, function () {
          this.mockService.returns([Em.Object.create({
            serviceName: 'YARN',
            isRestartRequired: test.isRestartRequired
          })]);
          var confirmationPopup = mainServiceItemController.restartLLAP();
          confirmationPopup.onPrimary();
          expect(mainServiceItemController[test.toCall].calledOnce).to.be.true;
        });
      });
  });

  describe("#saveConfigs()", function () {
    var mainServiceItemController;

    beforeEach(function () {
      mainServiceItemController = App.MainServiceItemController.create();
      sinon.stub(mainServiceItemController, 'getServiceConfigToSave').returns({});
      sinon.stub(mainServiceItemController, 'putChangedConfigurations');
      sinon.stub(mainServiceItemController, 'confirmServiceDeletion');
    });

    afterEach(function () {
      mainServiceItemController.getServiceConfigToSave.restore();
      mainServiceItemController.putChangedConfigurations.restore();
      mainServiceItemController.confirmServiceDeletion.restore();
    });

    it("empty stepConfigs", function() {
      mainServiceItemController.set('stepConfigs', []);
      mainServiceItemController.saveConfigs();
      expect(mainServiceItemController.confirmServiceDeletion.calledOnce).to.be.true;
      expect(mainServiceItemController.putChangedConfigurations.called).to.be.false;
    });

    it("stepConfigs has configs", function() {
      mainServiceItemController.set('stepConfigs', [Em.Object.create({serviceName: 'S1'})]);
      mainServiceItemController.saveConfigs();
      expect(mainServiceItemController.putChangedConfigurations.calledWith([{}], 'confirmServiceDeletion')).to.be.true;
      expect(mainServiceItemController.confirmServiceDeletion.called).to.be.false;
    });
  });

  describe("#isRangerPluginEnabled()", function () {
    var mainServiceItemController;

    beforeEach(function() {
      mainServiceItemController = App.MainServiceItemController.create();
      this.mock = sinon.stub(App.router, 'get');
    });

    afterEach(function() {
      this.mock.restore();
    });

    it("should return false", function() {
      this.mock.returns([Em.Object.create({
        isDisplayed: true,
        status: 'Disabled'
      })]);
      expect(mainServiceItemController.isRangerPluginEnabled()).to.be.false;
    });

    it("should return true", function() {
      this.mock.returns([Em.Object.create({
        isDisplayed: true,
        status: 'Enabled'
      })]);
      expect(mainServiceItemController.isRangerPluginEnabled()).to.be.true;
    });
  });

  describe('#dependentServiceNames', function () {

    var controller,
      serviceName = 's0',
      dependentServiceNames = ['s1', 's2'],
      testCases = [
        {
          isConfigsPropertiesLoaded: true,
          dependentServiceNames: dependentServiceNames,
          message: 'model is ready'
        },
        {
          isConfigsPropertiesLoaded: false,
          dependentServiceNames: [],
          message: 'model is not ready'
        }
      ];

    beforeEach(function () {
      controller = App.MainServiceItemController.create({
        content: {
          serviceName: serviceName
        }
      });
      sinon.stub(App.StackService, 'find').returns(Em.Object.create({
        dependentServiceNames: dependentServiceNames
      }));
    });

    afterEach(function () {
      App.StackService.find.restore();
    });

    testCases.forEach(function (test) {

      it(test.message, function () {
        App.set('router.clusterController.isConfigsPropertiesLoaded', test.isConfigsPropertiesLoaded);
        expect(controller.get('dependentServiceNames')).to.eql(test.dependentServiceNames);
      });

    });

  });

  describe('#applyRecommendedValues', function () {

    var controller;

    beforeEach(function () {
      controller = App.MainServiceItemController.create({
        stepConfigs: [
          Em.Object.create({
            serviceName: 's1',
            configs: [
              Em.Object.create({
                name: 'p1',
                value: 'v1'
              }),
              Em.Object.create({
                name: 'p2',
                value: 'v2'
              })
            ]
          }),
          Em.Object.create({
            serviceName: 's2',
            configs: [
              Em.Object.create({
                name: 'p3',
                value: 'v3'
              }),
              Em.Object.create({
                name: 'p4',
                value: 'v4'
              })
            ]
          })
        ],
        changedProperties: [
          {
            serviceName: 's1',
            propertyName: 'p1',
            recommendedValue: 'r1',
            initialValue: 'i1',
            saveRecommended: false
          },
          {
            serviceName: 's1',
            propertyName: 'p2',
            recommendedValue: 'r2',
            initialValue: 'i2',
            saveRecommended: true
          },
          {
            serviceName: 's2',
            propertyName: 'p3',
            recommendedValue: 'r3',
            initialValue: 'i3',
            saveRecommended: true
          }
        ]
      });
    });

    it('should update properties with saveRecommended flag set to true', function () {
      controller.applyRecommendedValues(controller.get('stepConfigs'));
      expect(controller.get('stepConfigs').findProperty('serviceName', 's1').get('configs').findProperty('name', 'p1').get('value')).to.equal('i1');
      expect(controller.get('stepConfigs').findProperty('serviceName', 's1').get('configs').findProperty('name', 'p2').get('value')).to.equal('r2');
      expect(controller.get('stepConfigs').findProperty('serviceName', 's2').get('configs').findProperty('name', 'p3').get('value')).to.equal('r3');
      expect(controller.get('stepConfigs').findProperty('serviceName', 's2').get('configs').findProperty('name', 'p4').get('value')).to.equal('v4');
    });

  });

});

});

require.register("test/controllers/main/service/manage_config_groups_controller_test", function(exports, require, module) {
/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

var App = require('app');
var c;

describe('App.ManageConfigGroupsController', function() {

  beforeEach(function() {
    c = App.ManageConfigGroupsController.create({});
  });

  var manageConfigGroupsController = App.ManageConfigGroupsController.create({});

  describe('#addConfigGroup', function() {
    beforeEach(function() {
      manageConfigGroupsController.addConfigGroup();
    });

    describe("#validate", function() {
      it("should display no warning if user inputs valid characters into group name", function() {

        manageConfigGroupsController.addGroupPopup.set('configGroupName', 'hello');

        expect(manageConfigGroupsController.addGroupPopup.warningMessage).to.be.empty;
      });

      it("should display warning if user inputs invalid characters into group name", function() {
        manageConfigGroupsController.addGroupPopup.set('configGroupName', '/{"!@#$%');

        expect(manageConfigGroupsController.addGroupPopup.warningMessage).to.equal('Invalid Group Name. Only alphanumerics, hyphens, spaces and underscores are allowed.');
      });
    });
  });

  describe('#renameConfigGroup', function() {
    beforeEach(function() {
      var configGroup = Ember.Object.create ({
        name: 'name',
        description: 'description'
      });

      manageConfigGroupsController.set('selectedConfigGroup', configGroup);
      manageConfigGroupsController.renameConfigGroup();
    });

    describe("#validate", function() {
      it("should display no warning if user inputs valid characters into group name", function() {
        manageConfigGroupsController.renameGroupPopup.set('configGroupName', 'hello');

        expect(manageConfigGroupsController.renameGroupPopup.warningMessage).to.be.empty;
      });

      it("should display warning if user inputs invalid characters into group name", function() {
        manageConfigGroupsController.renameGroupPopup.set('configGroupName', '/{"!@#$%');

        expect(manageConfigGroupsController.renameGroupPopup.warningMessage).to.equal('Invalid Group Name. Only alphanumerics, hyphens, spaces and underscores are allowed.');
      });
    });
  });

  describe('#addHostsCallback', function() {

    beforeEach(function() {

      c.reopen({
        selectedConfigGroup: Em.Object.create({
          hosts: ['h1'],
          parentConfigGroup: Em.Object.create({
            hosts: ['h2', 'h3']
          })
        })
      });
    });

    it('should set hosts to selectedConfigGroup and remove them form default group', function () {

      c.addHostsCallback(['h2', 'h3']);

      expect(c.get('selectedConfigGroup.hosts')).to.include.members(['h1','h2','h3']);
      expect(c.get('selectedConfigGroup.parentConfigGroup.hosts').toArray()).to.be.empty;
    });

  });

  describe('#isHostsModified', function () {

    Em.A([
      {
        o: {
          toClearHosts: [],
          toDelete: [],
          toSetHosts: [],
          toCreate: []
        },
        e: false
      },
      {
        o: {
          toClearHosts: [{}],
          toDelete: [],
          toSetHosts: [],
          toCreate: []
        },
        e: true
      },
      {
        o: {
          toClearHosts: [],
          toDelete: [{}],
          toSetHosts: [],
          toCreate: []
        },
        e: true
      },
      {
        o: {
          toClearHosts: [],
          toDelete: [],
          toSetHosts: [{}],
          toCreate: []
        },
        e: true
      },
      {
        o: {
          toClearHosts: [],
          toDelete: [],
          toSetHosts: [],
          toCreate: [{}]
        },
        e: true
      }
    ]).forEach(function (test, index) {
      it('test #' + index, function () {
        c.reopen({
          isLoaded: true,
          hostsModifiedConfigGroups: test.o
        });
        expect(c.get('isHostsModified')).to.equal(test.e);
      });
    });

  });

  describe('#deleteConfigGroup', function () {

    beforeEach(function() {

      var defaultGroup = Em.Object.create({
        hosts: ['h2', 'h3'],
        isDefault: true
      });

      var selectedGroup = Em.Object.create({
        hosts: ['h1'],
        parentConfigGroup: defaultGroup
      });

      c.reopen({
        configGroups: [defaultGroup, selectedGroup],
        selectedConfigGroup: selectedGroup
      });

      sinon.stub(App.configGroupsMapper, 'deleteRecord', Em.K);
    });

    afterEach(function(){
      App.configGroupsMapper.deleteRecord.restore();
    });

    it('after deleting some config group, Default should be selected', function () {

      c.deleteConfigGroup();

      expect(c.get('configGroups.length')).to.equal(1);
      expect(c.get('selectedConfigGroup.hosts')).to.include.members(['h1','h2','h3']);
      expect(c.get('selectedConfigGroup.isDefault')).to.be.true;
    });

  });

  describe("#manageConfigurationGroups", function () {
    var service = Em.Object.create({});
    manageConfigGroupsController.set('hostsModifiedConfigGroups', {});
    describe("#controller passed", function () {
      controller = Em.Object.create({
        content: Em.Object.create()
      });
      var popup = manageConfigGroupsController.manageConfigurationGroups(controller, service);

      describe("#onPrimary()", function () {
        beforeEach(function () {
          sinon.stub(popup, 'onPrimaryWizard', Em.K);
        });
        afterEach(function () {
          popup.onPrimaryWizard.restore();
        });
        it("onPrimaryWizard is called", function () {
          popup.onPrimary();
          expect(popup.onPrimaryWizard.calledOnce).to.be.true;
        });
      });

      describe("#onPrimaryWizard()", function () {

        var ctrl = Em.Object.create({
          selectedService: Em.Object.create({
            selected: false
          }),
          selectedServiceObserver: Em.K,
          setGroupsToDelete: Em.K
        });

        beforeEach(function () {
          sinon.spy(ctrl, 'selectedServiceObserver');
          sinon.spy(ctrl, 'setGroupsToDelete');
          sinon.stub(manageConfigGroupsController, 'persistConfigGroups', Em.K);
          sinon.stub(popup, 'updateConfigGroupOnServicePage', Em.K);
          sinon.stub(popup, 'hide', Em.K);
        });

        afterEach(function () {
          ctrl.setGroupsToDelete.restore();
          ctrl.selectedServiceObserver.restore();
          manageConfigGroupsController.persistConfigGroups.restore();
          popup.updateConfigGroupOnServicePage.restore();
          popup.hide.restore();
        });

        describe("groups deleted on 7th step", function () {

          beforeEach(function () {
            ctrl.set('name', 'wizardStep7Controller');
            popup.onPrimaryWizard(ctrl, {toDelete: [1]});
          });

          it('selectedServiceObserver is called once', function () {
            expect(ctrl.selectedServiceObserver.calledOnce).to.be.true;
          });
          it('setGroupsToDelete is called with [1]', function () {
            expect(ctrl.setGroupsToDelete.calledWith([1])).to.be.true;
          });
          it('persistConfigGroups is called once', function () {
            expect(manageConfigGroupsController.persistConfigGroups.calledOnce).to.be.true;
          });
          it('updateConfigGroupOnServicePage is called once', function () {
            expect(popup.updateConfigGroupOnServicePage.calledOnce).to.be.true;
          });
          it('hide is called once', function () {
            expect(popup.hide.calledOnce).to.be.true;
          });
        });

        describe("wizard not on 7th step", function () {

          beforeEach(function () {
            ctrl.set('name', '');
            popup.onPrimaryWizard(ctrl, {});
          });

          it('selectedServiceObserver is called once', function () {
            expect(ctrl.selectedServiceObserver.calledOnce).to.be.true;
          });

          it('setGroupsToDelete is not called', function () {
            expect(ctrl.setGroupsToDelete.called).to.be.false;
          });

          it('persistConfigGroups is not called', function () {
            expect(manageConfigGroupsController.persistConfigGroups.called).to.be.false;
          });

          it('updateConfigGroupOnServicePage is not called', function () {
            expect(popup.updateConfigGroupOnServicePage.called).to.be.false;
          });

          it('hide is called once', function () {
            expect(popup.hide.calledOnce).to.be.true;
          });
        });

        describe("wizard on 7th step, service selected", function () {

          beforeEach(function () {
            ctrl.set('name', 'wizardStep7Controller');
            ctrl.set('selectedService.selected', true);
            popup.onPrimaryWizard(ctrl, {toDelete: [1]});
          });

          it('selectedServiceObserver is called once', function () {
            expect(ctrl.selectedServiceObserver.calledOnce).to.be.true;
          });
          it('setGroupsToDelete is not called', function () {
            expect(ctrl.setGroupsToDelete.called).to.be.false;
          });
          it('persistConfigGroups is called once', function () {
            expect(manageConfigGroupsController.persistConfigGroups.calledOnce).to.be.true;
          });
          it('updateConfigGroupOnServicePage is called once', function () {
            expect(popup.updateConfigGroupOnServicePage.calledOnce).to.be.true;
          });
          it('hide is called once', function () {
            expect(popup.hide.calledOnce).to.be.true;
          });
        });

        describe("wizard on 7th step, no groups to delete", function () {

          beforeEach(function () {
            ctrl.set('name', 'wizardStep7Controller');
            ctrl.set('selectedService.selected', false);
            popup.onPrimaryWizard(ctrl, {toDelete: []});
          });

          it('selectedServiceObserver is called once', function () {
            expect(ctrl.selectedServiceObserver.calledOnce).to.be.true;
          });
          it('setGroupsToDelete is not called', function () {
            expect(ctrl.setGroupsToDelete.called).to.be.false;
          });
          it('persistConfigGroups is called once', function () {
            expect(manageConfigGroupsController.persistConfigGroups.calledOnce).to.be.true;
          });
          it('updateConfigGroupOnServicePage is called once', function () {
            expect(popup.updateConfigGroupOnServicePage.calledOnce).to.be.true;
          });
          it('hide is called once', function () {
            expect(popup.hide.calledOnce).to.be.true;
          });

        });

      });
    });

    describe("#controller not passed", function () {
      var popup = manageConfigGroupsController.manageConfigurationGroups(null, service);

      describe("#onPrimary()", function () {
        beforeEach(function () {
          sinon.stub(popup, 'runClearCGQueue').returns({
            done: function (callback) {
              callback();
            }
          });
          sinon.stub(popup, 'runModifyCGQueue').returns({
            done: function (callback) {
              callback();
            }
          });
          sinon.stub(popup, 'runCreateCGQueue').returns({
            done: function (callback) {
              callback();
            }
          });
          sinon.stub(popup, 'updateConfigGroupOnServicePage', Em.K);
          sinon.stub(popup, 'hide', Em.K);
          manageConfigGroupsController.set('hostsModifiedConfigGroups', {toCreate: []});
          popup.onPrimary();
        });
        afterEach(function () {
          popup.runCreateCGQueue.restore();
          popup.runModifyCGQueue.restore();
          popup.runClearCGQueue.restore();
          popup.updateConfigGroupOnServicePage.restore();
          popup.hide.restore();
        });
        it("runClearCGQueue is called", function () {
          expect(popup.runClearCGQueue.calledOnce).to.be.true;
        });
        it("runModifyCGQueue is called", function () {
          expect(popup.runModifyCGQueue.calledOnce).to.be.true;
        });
        it("runCreateCGQueue is called", function () {
          expect(popup.runCreateCGQueue.calledOnce).to.be.true;
        });
        it("updateConfigGroupOnServicePage is called", function () {
          expect(popup.updateConfigGroupOnServicePage.calledOnce).to.be.true;
        });
        it("hide is called", function () {
          expect(popup.hide.calledOnce).to.be.true;
        });
      });
      describe("#runClearCGQueue()", function () {
        beforeEach(function () {
          sinon.stub(manageConfigGroupsController, 'updateConfigurationGroup', Em.K);
          sinon.stub(manageConfigGroupsController, 'deleteConfigurationGroup', Em.K);
          popup.runClearCGQueue(Em.K, {
            initialGroups: [],
            toClearHosts: [Em.Object.create()],
            toDelete: [1]
          });
        });
        afterEach(function () {
          manageConfigGroupsController.updateConfigurationGroup.restore();
          manageConfigGroupsController.deleteConfigurationGroup.restore();
        });
        it("updateConfigurationGroup is called once", function () {
          expect(manageConfigGroupsController.updateConfigurationGroup.calledOnce).to.be.true;
        });
        it("deleteConfigurationGroup is called once", function () {
          expect(manageConfigGroupsController.deleteConfigurationGroup.calledOnce).to.be.true;
        });
      });
      describe("#runModifyCGQueue()", function () {
        beforeEach(function () {
          sinon.stub(manageConfigGroupsController, 'updateConfigurationGroup', Em.K);
        });
        afterEach(function () {
          manageConfigGroupsController.updateConfigurationGroup.restore();
        });
        it("updateConfigurationGroup is called once", function () {
          popup.runModifyCGQueue(Em.K, {toSetHosts: [1]});
          expect(manageConfigGroupsController.updateConfigurationGroup.calledOnce).to.be.true;
        });
      });
      describe("#runCreateCGQueue()", function () {
        beforeEach(function () {
          sinon.stub(manageConfigGroupsController, 'postNewConfigurationGroup', Em.K);
        });
        afterEach(function () {
          manageConfigGroupsController.postNewConfigurationGroup.restore();
        });
        it("postNewConfigurationGroup is called once", function () {
          popup.runCreateCGQueue(Em.K, {toCreate: [1]});
          expect(manageConfigGroupsController.postNewConfigurationGroup.calledOnce).to.be.true;
        });
      });
    });
  });

  describe('#_onLoadPropertiesSuccess', function () {

    var data = {
      items: [
        {
          type: 'type1',
          tag: 'tag1',
          properties: {
            prop1: 'val1',
            prop2: 'val2'
          }
        },
        {
          type: 'type1',
          tag: 'tag2',
          properties: {
            prop3: 'val3'
          }
        },
        {
          type: 'type2',
          tag: 'tag1',
          properties: {
            prop4: 'val4'
          }
        }
      ]
    };
    var params = {
      typeTagToGroupMap: {
        'type1///tag1': 'group1',
        'type1///tag2': 'group2',
        'type2///tag1': 'group3'
      }
    };
    var configGroups = [
      Em.Object.create({
        name: 'group1',
        properties: []
      }),
      Em.Object.create({
        name: 'group2',
        properties: []
      }),
      Em.Object.create({
        name: 'group3',
        properties: []
      }),
      Em.Object.create({
        name: 'group4',
        properties: []
      })
    ];

    beforeEach(function () {
      sinon.stub(c, 'resortConfigGroup', Em.K);
    });

    afterEach(function () {
      c.resortConfigGroup.restore();
    });

    it('should set properties to config groups', function () {
      c.set('configGroups', configGroups);
      c._onLoadPropertiesSuccess(data, null, params);
      expect(JSON.stringify(c.get('configGroups'))).to.equal(JSON.stringify([
        Em.Object.create({
          properties: [
            {
              name: 'prop1',
              value: 'val1',
              type: 'type1'
            },
            {
              name: 'prop2',
              value: 'val2',
              type: 'type1'
            }
          ],
          name: 'group1'
        }),
        Em.Object.create({
          properties: [
            {
              name: 'prop3',
              value: 'val3',
              type: 'type1'
            }
          ],
          name: 'group2'
        }),
        Em.Object.create({
          properties: [
            {
              name: 'prop4',
              value: 'val4',
              type: 'type2'
            }
          ],
          name: 'group3'
        }),
        Em.Object.create({
          properties: [],
          name: 'group4'
        })
      ]));
    })