/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.meta;

import java.io.IOException;
import org.apache.hadoop.record.Index;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.meta.FieldTypeInfo;
import org.apache.hadoop.record.meta.MapTypeID;
import org.apache.hadoop.record.meta.StructTypeID;
import org.apache.hadoop.record.meta.TypeID;
import org.apache.hadoop.record.meta.VectorTypeID;

public class Utils {
    private Utils() {
    }

    public static void skip(RecordInput rin, String tag, TypeID typeID) throws IOException {
        switch (typeID.typeVal) {
            case 1: {
                rin.readBool(tag);
                break;
            }
            case 2: {
                rin.readBuffer(tag);
                break;
            }
            case 3: {
                rin.readByte(tag);
                break;
            }
            case 4: {
                rin.readDouble(tag);
                break;
            }
            case 5: {
                rin.readFloat(tag);
                break;
            }
            case 6: {
                rin.readInt(tag);
                break;
            }
            case 7: {
                rin.readLong(tag);
                break;
            }
            case 8: {
                Index midx1 = rin.startMap(tag);
                MapTypeID mtID = (MapTypeID)typeID;
                while (!midx1.done()) {
                    Utils.skip(rin, tag, mtID.getKeyTypeID());
                    Utils.skip(rin, tag, mtID.getValueTypeID());
                    midx1.incr();
                }
                rin.endMap(tag);
                break;
            }
            case 9: {
                rin.readString(tag);
                break;
            }
            case 10: {
                rin.startRecord(tag);
                StructTypeID stID = (StructTypeID)typeID;
                for (FieldTypeInfo tInfo : stID.getFieldTypeInfos()) {
                    Utils.skip(rin, tag, tInfo.getTypeID());
                }
                rin.endRecord(tag);
                break;
            }
            case 11: {
                Index vidx1 = rin.startVector(tag);
                VectorTypeID vtID = (VectorTypeID)typeID;
                while (!vidx1.done()) {
                    Utils.skip(rin, tag, vtID.getElementTypeID());
                    vidx1.incr();
                }
                rin.endVector(tag);
                break;
            }
            default: {
                throw new IOException("Unknown typeID when skipping bytes");
            }
        }
    }
}

