/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.distcp2.mapred.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.tools.distcp2.mapred.lib.DynamicInputChunk;
import org.apache.hadoop.tools.distcp2.mapred.lib.DynamicRecordReader;
import org.apache.hadoop.tools.distcp2.util.DistCpUtils;

public class DynamicInputFormat<K, V>
extends InputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog(DynamicInputFormat.class);
    private static final String CONF_LABEL_LISTING_SPLIT_RATIO = "mapred.listing.split.ratio";
    private static final String CONF_LABEL_NUM_SPLITS = "mapred.num.splits";
    private static final String CONF_LABEL_NUM_ENTRIES_PER_CHUNK = "mapred.num.entries.per.chunk";
    private static int N_CHUNKS_OPEN_AT_ONCE_DEFAULT = 16;
    private static final int MAX_CHUNKS_TOLERABLE = 400;
    private static final int MAX_CHUNKS_IDEAL = 100;
    private static final int MIN_RECORDS_PER_CHUNK = 5;
    private static final int SPLIT_RATIO_DEFAULT = 2;

    @Override
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        LOG.info("DynamicInputFormat: Getting splits for job:" + jobContext.getJobID());
        return this.createSplits(jobContext, this.splitCopyListingIntoChunksWithShuffle(jobContext));
    }

    private List<InputSplit> createSplits(JobContext jobContext, List<DynamicInputChunk> chunks) throws IOException {
        int numMaps = DynamicInputFormat.getNumMapTasks(jobContext.getConfiguration());
        int nSplits = Math.min(numMaps, chunks.size());
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(nSplits);
        for (int i = 0; i < nSplits; ++i) {
            TaskID taskId = new TaskID(jobContext.getJobID(), true, i);
            chunks.get(i).assignTo(taskId);
            splits.add(new FileSplit(chunks.get(i).getPath(), 0L, 5L, null));
        }
        DistCpUtils.publish(jobContext.getConfiguration(), CONF_LABEL_NUM_SPLITS, splits.size());
        return splits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DynamicInputChunk> splitCopyListingIntoChunksWithShuffle(JobContext context) throws IOException {
        Configuration configuration = context.getConfiguration();
        int numRecords = DynamicInputFormat.getNumberOfRecords(configuration);
        int numMaps = DynamicInputFormat.getNumMapTasks(configuration);
        int splitRatio = DynamicInputFormat.getListingSplitRatio(configuration, numMaps, numRecords);
        DynamicInputFormat.validateNumChunksUsing(splitRatio, numMaps);
        int numEntriesPerChunk = (int)Math.ceil((float)numRecords / (float)(splitRatio * numMaps));
        DistCpUtils.publish(context.getConfiguration(), CONF_LABEL_NUM_ENTRIES_PER_CHUNK, numEntriesPerChunk);
        int nChunksTotal = (int)Math.ceil((float)numRecords / (float)numEntriesPerChunk);
        int nChunksOpenAtOnce = Math.min(N_CHUNKS_OPEN_AT_ONCE_DEFAULT, nChunksTotal);
        Path listingPath = DynamicInputFormat.getListingFilePath(configuration);
        SequenceFile.Reader reader = new SequenceFile.Reader(listingPath.getFileSystem(configuration), listingPath, configuration);
        List<DynamicInputChunk> openChunks = new ArrayList<DynamicInputChunk>();
        ArrayList<DynamicInputChunk> chunksFinal = new ArrayList<DynamicInputChunk>();
        FileStatus fileStatus = new FileStatus();
        Text relPath = new Text();
        int recordCounter = 0;
        int chunkCount = 0;
        try {
            while (reader.next(relPath, fileStatus)) {
                if (recordCounter % (nChunksOpenAtOnce * numEntriesPerChunk) == 0) {
                    DynamicInputFormat.closeAll(openChunks);
                    chunksFinal.addAll(openChunks);
                    openChunks = DynamicInputFormat.createChunks(configuration, chunkCount, nChunksTotal, nChunksOpenAtOnce);
                    chunkCount += openChunks.size();
                    nChunksOpenAtOnce = openChunks.size();
                    recordCounter = 0;
                }
                ((DynamicInputChunk)openChunks.get(recordCounter % nChunksOpenAtOnce)).write(relPath, fileStatus);
                ++recordCounter;
            }
        }
        finally {
            DynamicInputFormat.closeAll(openChunks);
            chunksFinal.addAll(openChunks);
            IOUtils.closeStream(reader);
        }
        LOG.info("Number of dynamic-chunk-files created: " + chunksFinal.size());
        return chunksFinal;
    }

    private static void validateNumChunksUsing(int splitRatio, int numMaps) throws IOException {
        if (splitRatio * numMaps > 400) {
            throw new IOException("Too many chunks created with splitRatio:" + splitRatio + ", numMaps:" + numMaps + ". Reduce numMaps or decrease split-ratio to proceed.");
        }
    }

    private static void closeAll(List<DynamicInputChunk> chunks) {
        for (DynamicInputChunk chunk : chunks) {
            chunk.close();
        }
    }

    private static List<DynamicInputChunk> createChunks(Configuration config, int chunkCount, int nChunksTotal, int nChunksOpenAtOnce) throws IOException {
        ArrayList<DynamicInputChunk> chunks = new ArrayList<DynamicInputChunk>();
        int chunkIdUpperBound = Math.min(nChunksTotal, chunkCount + nChunksOpenAtOnce);
        if (nChunksTotal - chunkIdUpperBound < nChunksOpenAtOnce) {
            chunkIdUpperBound = nChunksTotal;
        }
        for (int i = chunkCount; i < chunkIdUpperBound; ++i) {
            chunks.add(DynamicInputFormat.createChunk(i, config));
        }
        return chunks;
    }

    private static DynamicInputChunk createChunk(int chunkId, Configuration config) throws IOException {
        return DynamicInputChunk.createChunkForWrite(String.format("%05d", chunkId), config);
    }

    private static Path getListingFilePath(Configuration configuration) {
        Path listingFilePath;
        block4: {
            String listingFilePathString = configuration.get("distcp.listing.file.path", "");
            assert (!listingFilePathString.equals("")) : "Listing file not found.";
            listingFilePath = new Path(listingFilePathString);
            try {
                assert (listingFilePath.getFileSystem(configuration).exists(listingFilePath)) : "Listing file: " + listingFilePath + " not found.";
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("Listing file: " + listingFilePath + " couldn't be accessed. " + e.getMessage()));
            }
        }
        return listingFilePath;
    }

    private static int getNumberOfRecords(Configuration configuration) {
        return DistCpUtils.getInt(configuration, "mapred.number.of.records");
    }

    private static int getNumMapTasks(Configuration configuration) {
        return DistCpUtils.getNumMapTasks(configuration);
    }

    private static int getListingSplitRatio(Configuration configuration, int numMaps, int numPaths) {
        return configuration.getInt(CONF_LABEL_LISTING_SPLIT_RATIO, DynamicInputFormat.getSplitRatio(numMaps, numPaths));
    }

    static int getSplitRatio(int nMaps, int nRecords) {
        if (nMaps == 1) {
            LOG.warn("nMaps == 1. Why use DynamicInputFormat?");
            return 1;
        }
        if (nMaps > 100) {
            return 2;
        }
        int nPickups = (int)Math.ceil(100.0f / (float)nMaps);
        int nRecordsPerChunk = (int)Math.ceil((float)nRecords / (float)(nMaps * nPickups));
        return nRecordsPerChunk < 5 ? 2 : nPickups;
    }

    static int getNumEntriesPerChunk(Configuration configuration) {
        return DistCpUtils.getInt(configuration, CONF_LABEL_NUM_ENTRIES_PER_CHUNK);
    }

    @Override
    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new DynamicRecordReader();
    }
}

