/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.security.token.block;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

public class BlockTokenIdentifier
extends TokenIdentifier {
    static final Text KIND_NAME = new Text("HDFS_BLOCK_TOKEN");
    private long expiryDate;
    private int keyId;
    private String userId;
    private long[] blockIds;
    private EnumSet<BlockTokenSecretManager.AccessMode> modes;
    private byte[] cache;

    public BlockTokenIdentifier() {
        this(null, new long[0], EnumSet.noneOf(BlockTokenSecretManager.AccessMode.class));
    }

    public BlockTokenIdentifier(String userId, long[] blockIds, EnumSet<BlockTokenSecretManager.AccessMode> modes) {
        if (blockIds == null) {
            throw new IllegalArgumentException("blockIds can't be null");
        }
        this.cache = null;
        this.userId = userId;
        this.blockIds = Arrays.copyOf(blockIds, blockIds.length);
        Arrays.sort(this.blockIds);
        this.modes = modes == null ? EnumSet.noneOf(BlockTokenSecretManager.AccessMode.class) : modes;
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    @Override
    public UserGroupInformation getUser() {
        if (this.userId == null || "".equals(this.userId)) {
            return UserGroupInformation.createRemoteUser(Arrays.toString(this.blockIds));
        }
        return UserGroupInformation.createRemoteUser(this.userId);
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(long expiryDate) {
        this.cache = null;
        this.expiryDate = expiryDate;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int keyId) {
        this.cache = null;
        this.keyId = keyId;
    }

    public String getUserId() {
        return this.userId;
    }

    public long[] getBlockIds() {
        return this.blockIds;
    }

    public boolean isBlockIncluded(long blockId) {
        switch (this.blockIds.length) {
            case 1: {
                return this.blockIds[0] == blockId;
            }
            case 2: {
                return this.blockIds[0] == blockId || this.blockIds[1] == blockId;
            }
        }
        return Arrays.binarySearch(this.blockIds, blockId) >= 0;
    }

    public EnumSet<BlockTokenSecretManager.AccessMode> getAccessModes() {
        return this.modes;
    }

    public String toString() {
        return "block_token_identifier (expiryDate=" + this.getExpiryDate() + ", keyId=" + this.getKeyId() + ", userId=" + this.getUserId() + ", blockIds=" + Arrays.toString(this.blockIds) + ", access modes=" + this.getAccessModes() + ")";
    }

    static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockTokenIdentifier) {
            BlockTokenIdentifier that = (BlockTokenIdentifier)obj;
            return this.expiryDate == that.expiryDate && this.keyId == that.keyId && BlockTokenIdentifier.isEqual(this.userId, that.userId) && Arrays.equals(this.blockIds, that.blockIds) && BlockTokenIdentifier.isEqual(this.modes, that.modes);
        }
        return false;
    }

    public int hashCode() {
        return (int)this.expiryDate ^ this.keyId ^ Arrays.hashCode(this.blockIds) ^ this.modes.hashCode() ^ (this.userId == null ? 0 : this.userId.hashCode());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.cache = null;
        this.expiryDate = WritableUtils.readVLong(in);
        this.keyId = WritableUtils.readVInt(in);
        this.userId = WritableUtils.readString(in);
        this.blockIds = new long[WritableUtils.readVInt(in)];
        for (int i = 0; i < this.blockIds.length; ++i) {
            this.blockIds[i] = WritableUtils.readVLong(in);
        }
        int length = WritableUtils.readVInt(in);
        for (int i = 0; i < length; ++i) {
            this.modes.add(WritableUtils.readEnum(in, BlockTokenSecretManager.AccessMode.class));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVLong(out, this.expiryDate);
        WritableUtils.writeVInt(out, this.keyId);
        WritableUtils.writeString(out, this.userId);
        WritableUtils.writeVInt(out, this.blockIds.length);
        for (int i = 0; i < this.blockIds.length; ++i) {
            WritableUtils.writeVLong(out, this.blockIds[i]);
        }
        WritableUtils.writeVInt(out, this.modes.size());
        for (BlockTokenSecretManager.AccessMode aMode : this.modes) {
            WritableUtils.writeEnum(out, aMode);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.cache == null) {
            this.cache = super.getBytes();
        }
        return this.cache;
    }

    @InterfaceAudience.Private
    public static class Renewer
    extends Token.TrivialRenewer {
        @Override
        protected Text getKind() {
            return KIND_NAME;
        }
    }
}

