/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetgroupCache {
    private static final Log LOG = LogFactory.getLog(NetgroupCache.class);
    private static boolean netgroupToUsersMapUpdated = true;
    private static Map<String, Set<String>> netgroupToUsersMap = new ConcurrentHashMap<String, Set<String>>();
    private static Map<String, Set<String>> userToNetgroupsMap = new ConcurrentHashMap<String, Set<String>>();

    public void getNetgroups(String user, List<String> groups) {
        if (netgroupToUsersMapUpdated) {
            netgroupToUsersMapUpdated = false;
            for (String netgroup : netgroupToUsersMap.keySet()) {
                for (String netuser : netgroupToUsersMap.get(netgroup)) {
                    if (!userToNetgroupsMap.containsKey(netuser)) {
                        userToNetgroupsMap.put(netuser, new HashSet());
                    }
                    userToNetgroupsMap.get(netuser).add(netgroup);
                }
            }
        }
        if (userToNetgroupsMap.containsKey(user)) {
            for (String netgroup : userToNetgroupsMap.get(user)) {
                groups.add(netgroup);
            }
        }
    }

    public List<String> getNetgroupNames() {
        return new LinkedList<String>(netgroupToUsersMap.keySet());
    }

    public boolean isCached(String group) {
        return netgroupToUsersMap.containsKey(group);
    }

    public void clear() {
        netgroupToUsersMap.clear();
    }

    public void add(String group, List<String> users) {
        if (!this.isCached(group)) {
            netgroupToUsersMap.put(group, new HashSet());
            for (String user : users) {
                netgroupToUsersMap.get(group).add(user);
            }
        }
        netgroupToUsersMapUpdated = true;
    }
}

