/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobLocalizer;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskLogsTruncater;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.util.ProcessTree;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

class LinuxTaskController
extends TaskController {
    private static final Log LOG = LogFactory.getLog(LinuxTaskController.class);
    private String taskControllerExe;
    private static final String TASK_CONTROLLER_EXEC_KEY = "mapreduce.tasktracker.task-controller.exe";

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        File hadoopBin = new File(System.getenv("HADOOP_HOME"), "bin");
        String defaultTaskController = new File(hadoopBin, "task-controller").getAbsolutePath();
        this.taskControllerExe = conf.get(TASK_CONTROLLER_EXEC_KEY, defaultTaskController);
    }

    @Override
    public void setup(LocalDirAllocator allocator, TaskTracker.LocalStorage localStorage) throws IOException {
        block2: {
            String[] taskControllerCmd = new String[]{this.taskControllerExe};
            Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor(taskControllerCmd);
            try {
                shExec.execute();
            }
            catch (Shell.ExitCodeException e) {
                int exitCode = shExec.getExitCode();
                if (exitCode == 1) break block2;
                LOG.warn("Exit code from checking binary permissions is : " + exitCode);
                this.logOutput(shExec.getOutput());
                throw new IOException("Task controller setup failed because of invalidpermissions/ownership with exit code " + exitCode, e);
            }
        }
        this.allocator = allocator;
        this.localStorage = localStorage;
    }

    @Override
    public void initializeJob(String user, String jobid, Path credentials, Path jobConf, TaskUmbilicalProtocol taskTracker, InetSocketAddress ttAddr) throws IOException {
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.taskControllerExe, user, this.localStorage.getDirsString(), Integer.toString(Commands.INITIALIZE_JOB.getValue()), jobid, credentials.toUri().getPath().toString(), jobConf.toUri().getPath().toString()));
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        command.add(jvm.toString());
        command.add("-classpath");
        command.add(System.getProperty("java.class.path"));
        command.add("-Dhadoop.log.dir=" + TaskLog.getBaseLogDir());
        command.add("-Dhadoop.root.logger=INFO,console");
        command.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        command.add(JobLocalizer.class.getName());
        command.add(user);
        command.add(jobid);
        command.add(ttAddr.getHostName());
        command.add(Integer.toString(ttAddr.getPort()));
        Object[] commandArray = command.toArray(new String[0]);
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])commandArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug("initializeJob: " + Arrays.toString(commandArray));
        }
        try {
            shExec.execute();
            if (LOG.isDebugEnabled()) {
                this.logOutput(shExec.getOutput());
            }
        }
        catch (Shell.ExitCodeException e) {
            int exitCode = shExec.getExitCode();
            this.logOutput(shExec.getOutput());
            throw new IOException("Job initialization failed (" + exitCode + ") with output: " + shExec.getOutput(), e);
        }
    }

    @Override
    public int launchTask(String user, String jobId, String attemptId, List<String> setup, List<String> jvmArguments, File currentWorkDirectory, String stdout, String stderr) throws IOException {
        Shell shExec = null;
        try {
            FileSystem rawFs = FileSystem.getLocal(this.getConf()).getRaw();
            long logSize = 0L;
            String cmdLine = TaskLog.buildCommandLine(setup, jvmArguments, new File(stdout), new File(stderr), logSize, true);
            Path p = new Path(this.allocator.getLocalPathForWrite(TaskTracker.getPrivateDirTaskScriptLocation(user, jobId, attemptId), this.getConf()), "taskjvm.sh");
            String commandFile = LinuxTaskController.writeCommand(cmdLine, rawFs, p);
            Object[] command = new String[]{this.taskControllerExe, user, this.localStorage.getDirsString(), Integer.toString(Commands.LAUNCH_TASK_JVM.getValue()), jobId, attemptId, currentWorkDirectory.toString(), commandFile};
            shExec = new Shell.ShellCommandExecutor((String[])command);
            if (LOG.isDebugEnabled()) {
                LOG.debug("launchTask: " + Arrays.toString(command));
            }
            ((Shell.ShellCommandExecutor)shExec).execute();
        }
        catch (Exception e) {
            if (shExec == null) {
                return -1;
            }
            int exitCode = shExec.getExitCode();
            LOG.warn("Exit code from task is : " + exitCode);
            if (exitCode != 143 && exitCode != 137) {
                LOG.warn("Exception thrown while launching task JVM : " + StringUtils.stringifyException(e));
                LOG.info("Output from LinuxTaskController's launchTaskJVM follows:");
                this.logOutput(((Shell.ShellCommandExecutor)shExec).getOutput());
            }
            return exitCode;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Output from LinuxTaskController's launchTask follows:");
            this.logOutput(((Shell.ShellCommandExecutor)shExec).getOutput());
        }
        return 0;
    }

    @Override
    public void createLogDir(TaskAttemptID taskID, boolean isCleanup) throws IOException {
    }

    @Override
    public void deleteAsUser(String user, String subDir) throws IOException {
        Object[] command = new String[]{this.taskControllerExe, user, this.localStorage.getDirsString(), Integer.toString(Commands.DELETE_AS_USER.getValue()), subDir};
        Shell.ShellCommandExecutor shExec = null;
        try {
            shExec = new Shell.ShellCommandExecutor((String[])command);
            if (LOG.isDebugEnabled()) {
                LOG.debug("deleteAsUser: " + Arrays.toString(command));
            }
            shExec.execute();
        }
        catch (IOException e) {
            if (shExec != null) {
                int exitCode = shExec.getExitCode();
                LOG.info("deleteAsUser: " + Arrays.toString(command));
                LOG.warn("Exit code is : " + exitCode);
                LOG.info("Output from deleteAsUser LinuxTaskController:");
                this.logOutput(shExec.getOutput());
            }
            throw e;
        }
    }

    @Override
    public void deleteLogAsUser(String user, String subDir) throws IOException {
        Object[] command = new String[]{this.taskControllerExe, user, this.localStorage.getDirsString(), Integer.toString(Commands.DELETE_LOG_AS_USER.getValue()), subDir};
        Shell.ShellCommandExecutor shExec = null;
        try {
            shExec = new Shell.ShellCommandExecutor((String[])command);
            if (LOG.isDebugEnabled()) {
                LOG.debug("deleteLogAsUser: " + Arrays.toString(command));
            }
            shExec.execute();
        }
        catch (IOException e) {
            if (shExec != null) {
                int exitCode = shExec.getExitCode();
                LOG.info("deleteLogAsUser: " + Arrays.toString(command));
                LOG.warn("Exit code is : " + exitCode);
                LOG.info("Output from deleteLogAsUser LinuxTaskController:");
                this.logOutput(shExec.getOutput());
            }
            throw e;
        }
    }

    @Override
    public void signalTask(String user, int taskPid, ProcessTree.Signal signal) throws IOException {
        block3: {
            Object[] command = new String[]{this.taskControllerExe, user, this.localStorage.getDirsString(), Integer.toString(Commands.SIGNAL_TASK.getValue()), Integer.toString(taskPid), Integer.toString(signal.getValue())};
            Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor((String[])command);
            if (LOG.isDebugEnabled()) {
                LOG.debug("signalTask: " + Arrays.toString(command));
            }
            try {
                shExec.execute();
            }
            catch (Shell.ExitCodeException e) {
                int ret_code = shExec.getExitCode();
                if (ret_code == ResultCode.INVALID_TASK_PID.getValue()) break block3;
                this.logOutput(shExec.getOutput());
                throw new IOException("Problem signalling task " + taskPid + " with " + (Object)((Object)signal) + "; exit = " + ret_code);
            }
        }
    }

    @Override
    public String getRunAsUser(JobConf conf) {
        return conf.getUser();
    }

    @Override
    public void truncateLogsAsUser(String user, List<Task> allAttempts) throws IOException {
        Task firstTask = allAttempts.get(0);
        String taskid = firstTask.getTaskID().toString();
        LocalDirAllocator ldirAlloc = new LocalDirAllocator("mapred.local.dir");
        String taskRanFile = "tt_log_tmp/" + taskid;
        Configuration conf = this.getConf();
        Path taskRanFilePath = ldirAlloc.getLocalPathForWrite(taskRanFile, conf);
        LocalFileSystem lfs = FileSystem.getLocal(conf);
        FSDataOutputStream out = lfs.create(taskRanFilePath);
        out.writeInt(allAttempts.size());
        for (Task t : allAttempts) {
            out.writeBoolean(t.isMapTask());
            t.write(out);
        }
        out.close();
        lfs.setPermission(taskRanFilePath, FsPermission.createImmutable((short)493));
        ArrayList<String> command = new ArrayList<String>();
        File jvm = new File(new File(System.getProperty("java.home"), "bin"), "java");
        command.add(jvm.toString());
        command.add("-Djava.library.path=" + System.getProperty("java.library.path"));
        command.add("-Dhadoop.log.dir=" + TaskLog.getBaseLogDir());
        command.add("-Dhadoop.root.logger=INFO,console");
        command.add("-classpath");
        command.add(System.getProperty("java.class.path"));
        command.add(TaskLogsTruncater.class.getName());
        command.add(taskRanFilePath.toString());
        String[] taskControllerCmd = new String[4 + command.size()];
        taskControllerCmd[0] = this.taskControllerExe;
        taskControllerCmd[1] = user;
        taskControllerCmd[2] = this.localStorage.getDirsString();
        taskControllerCmd[3] = Integer.toString(Commands.RUN_COMMAND_AS_USER.getValue());
        int i = 4;
        for (String cmdArg : command) {
            taskControllerCmd[i++] = cmdArg;
        }
        if (LOG.isDebugEnabled()) {
            for (String cmd : taskControllerCmd) {
                LOG.debug("taskctrl command = " + cmd);
            }
        }
        Shell.ShellCommandExecutor shExec = new Shell.ShellCommandExecutor(taskControllerCmd);
        try {
            shExec.execute();
        }
        catch (Exception e) {
            LOG.warn("Exit code from " + this.taskControllerExe.toString() + " is : " + shExec.getExitCode() + " for truncateLogs");
            LOG.warn("Exception thrown by " + this.taskControllerExe.toString() + " : " + StringUtils.stringifyException(e));
            LOG.info("Output from LinuxTaskController's " + this.taskControllerExe.toString() + " follows:");
            this.logOutput(shExec.getOutput());
            lfs.delete(taskRanFilePath, false);
            throw new IOException(e);
        }
        lfs.delete(taskRanFilePath, false);
        if (LOG.isDebugEnabled()) {
            LOG.info("Output from LinuxTaskController's " + this.taskControllerExe.toString() + " follows:");
            this.logOutput(shExec.getOutput());
        }
    }

    static enum ResultCode {
        OK(0),
        INVALID_USER_NAME(2),
        INVALID_TASK_PID(9),
        INVALID_CONFIG_FILE(24);

        private final int value;

        private ResultCode(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    static enum Commands {
        INITIALIZE_JOB(0),
        LAUNCH_TASK_JVM(1),
        SIGNAL_TASK(2),
        DELETE_AS_USER(3),
        DELETE_LOG_AS_USER(4),
        RUN_COMMAND_AS_USER(5);

        private int value;

        private Commands(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }
}

