/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutableCounter;

public class MetricMutableCounterLong
extends MetricMutableCounter<Long> {
    private volatile long value;

    public MetricMutableCounterLong(String name, String description, long initValue) {
        super(name, description);
        this.value = initValue;
    }

    @Override
    public synchronized void incr() {
        ++this.value;
        this.setChanged();
    }

    public synchronized void incr(long delta) {
        this.value += delta;
        this.setChanged();
    }

    @Override
    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.name, this.description, this.value);
            this.clearChanged();
        }
    }
}

